# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, endpoint=None, hybrid_service_url=None, id=None, identities=None, name=None, primary_key=None, private_endpoint_connections=None, resource_group_name=None, secondary_key=None):
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if hybrid_service_url and not isinstance(hybrid_service_url, str):
            raise TypeError("Expected argument 'hybrid_service_url' to be a str")
        pulumi.set(__self__, "hybrid_service_url", hybrid_service_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if private_endpoint_connections and not isinstance(private_endpoint_connections, list):
            raise TypeError("Expected argument 'private_endpoint_connections' to be a list")
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The Endpoint for this Automation Account.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="hybridServiceUrl")
    def hybrid_service_url(self) -> _builtins.str:
        """
        The URL of automation hybrid service which is used for hybrid worker on-boarding With this Automation Account.
        """
        return pulumi.get(self, "hybrid_service_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetAccountIdentityResult']:
        """
        (Optional) An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> _builtins.str:
        """
        The Primary Access Key for the Automation Account.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.GetAccountPrivateEndpointConnectionResult']:
        return pulumi.get(self, "private_endpoint_connections")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> _builtins.str:
        """
        The Secondary Access Key for the Automation Account.
        """
        return pulumi.get(self, "secondary_key")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            endpoint=self.endpoint,
            hybrid_service_url=self.hybrid_service_url,
            id=self.id,
            identities=self.identities,
            name=self.name,
            primary_key=self.primary_key,
            private_endpoint_connections=self.private_endpoint_connections,
            resource_group_name=self.resource_group_name,
            secondary_key=self.secondary_key)


def get_account(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Use this data source to access information about an existing Automation Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.automation.get_account(name="example-account",
        resource_group_name="example-resources")
    pulumi.export("automationAccountId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Automation` - 2024-10-23, 2019-06-01


    :param _builtins.str name: The name of the Automation Account.
    :param _builtins.str resource_group_name: Specifies the name of the Resource Group where the Automation Account exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:automation/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        endpoint=pulumi.get(__ret__, 'endpoint'),
        hybrid_service_url=pulumi.get(__ret__, 'hybrid_service_url'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        name=pulumi.get(__ret__, 'name'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        private_endpoint_connections=pulumi.get(__ret__, 'private_endpoint_connections'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'))
def get_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    Use this data source to access information about an existing Automation Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.automation.get_account(name="example-account",
        resource_group_name="example-resources")
    pulumi.export("automationAccountId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Automation` - 2024-10-23, 2019-06-01


    :param _builtins.str name: The name of the Automation Account.
    :param _builtins.str resource_group_name: Specifies the name of the Resource Group where the Automation Account exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:automation/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        endpoint=pulumi.get(__response__, 'endpoint'),
        hybrid_service_url=pulumi.get(__response__, 'hybrid_service_url'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        name=pulumi.get(__response__, 'name'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        private_endpoint_connections=pulumi.get(__response__, 'private_endpoint_connections'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_key=pulumi.get(__response__, 'secondary_key')))
