# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRunbookResult',
    'AwaitableGetRunbookResult',
    'get_runbook',
    'get_runbook_output',
]

@pulumi.output_type
class GetRunbookResult:
    """
    A collection of values returned by getRunbook.
    """
    def __init__(__self__, automation_account_name=None, content=None, description=None, id=None, location=None, log_activity_trace_level=None, log_progress=None, log_verbose=None, name=None, resource_group_name=None, runbook_type=None, tags=None):
        if automation_account_name and not isinstance(automation_account_name, str):
            raise TypeError("Expected argument 'automation_account_name' to be a str")
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if log_activity_trace_level and not isinstance(log_activity_trace_level, int):
            raise TypeError("Expected argument 'log_activity_trace_level' to be a int")
        pulumi.set(__self__, "log_activity_trace_level", log_activity_trace_level)
        if log_progress and not isinstance(log_progress, bool):
            raise TypeError("Expected argument 'log_progress' to be a bool")
        pulumi.set(__self__, "log_progress", log_progress)
        if log_verbose and not isinstance(log_verbose, bool):
            raise TypeError("Expected argument 'log_verbose' to be a bool")
        pulumi.set(__self__, "log_verbose", log_verbose)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if runbook_type and not isinstance(runbook_type, str):
            raise TypeError("Expected argument 'runbook_type' to be a str")
        pulumi.set(__self__, "runbook_type", runbook_type)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> _builtins.str:
        return pulumi.get(self, "automation_account_name")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The content of the Runbook.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Runbook.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Runbook exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logActivityTraceLevel")
    def log_activity_trace_level(self) -> _builtins.int:
        """
        The activity-level tracing of the Runbook.
        """
        return pulumi.get(self, "log_activity_trace_level")

    @_builtins.property
    @pulumi.getter(name="logProgress")
    def log_progress(self) -> _builtins.bool:
        """
        The Progress log option of the Runbook.
        """
        return pulumi.get(self, "log_progress")

    @_builtins.property
    @pulumi.getter(name="logVerbose")
    def log_verbose(self) -> _builtins.bool:
        """
        The Verbose log option of the Runbook.
        """
        return pulumi.get(self, "log_verbose")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="runbookType")
    def runbook_type(self) -> _builtins.str:
        """
        The type of Runbook.
        """
        return pulumi.get(self, "runbook_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Runbook.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRunbookResult(GetRunbookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunbookResult(
            automation_account_name=self.automation_account_name,
            content=self.content,
            description=self.description,
            id=self.id,
            location=self.location,
            log_activity_trace_level=self.log_activity_trace_level,
            log_progress=self.log_progress,
            log_verbose=self.log_verbose,
            name=self.name,
            resource_group_name=self.resource_group_name,
            runbook_type=self.runbook_type,
            tags=self.tags)


def get_runbook(automation_account_name: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunbookResult:
    """
    Use this data source to access information about an existing Automation Runbook.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.automation.get_runbook(name="existing-runbook",
        resource_group_name="existing",
        automation_account_name="existing-automation")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Automation` - 2024-10-23


    :param _builtins.str automation_account_name: The name of the Automation Account the runbook belongs to.
    :param _builtins.str name: The name of the Automation Runbook.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Automation exists.
    """
    __args__ = dict()
    __args__['automationAccountName'] = automation_account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:automation/getRunbook:getRunbook', __args__, opts=opts, typ=GetRunbookResult).value

    return AwaitableGetRunbookResult(
        automation_account_name=pulumi.get(__ret__, 'automation_account_name'),
        content=pulumi.get(__ret__, 'content'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        log_activity_trace_level=pulumi.get(__ret__, 'log_activity_trace_level'),
        log_progress=pulumi.get(__ret__, 'log_progress'),
        log_verbose=pulumi.get(__ret__, 'log_verbose'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        runbook_type=pulumi.get(__ret__, 'runbook_type'),
        tags=pulumi.get(__ret__, 'tags'))
def get_runbook_output(automation_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                       name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunbookResult]:
    """
    Use this data source to access information about an existing Automation Runbook.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.automation.get_runbook(name="existing-runbook",
        resource_group_name="existing",
        automation_account_name="existing-automation")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Automation` - 2024-10-23


    :param _builtins.str automation_account_name: The name of the Automation Account the runbook belongs to.
    :param _builtins.str name: The name of the Automation Runbook.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Automation exists.
    """
    __args__ = dict()
    __args__['automationAccountName'] = automation_account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:automation/getRunbook:getRunbook', __args__, opts=opts, typ=GetRunbookResult)
    return __ret__.apply(lambda __response__: GetRunbookResult(
        automation_account_name=pulumi.get(__response__, 'automation_account_name'),
        content=pulumi.get(__response__, 'content'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        log_activity_trace_level=pulumi.get(__response__, 'log_activity_trace_level'),
        log_progress=pulumi.get(__response__, 'log_progress'),
        log_verbose=pulumi.get(__response__, 'log_verbose'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        runbook_type=pulumi.get(__response__, 'runbook_type'),
        tags=pulumi.get(__response__, 'tags')))
