# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModuleArgs', 'Module']

@pulumi.input_type
class ModuleArgs:
    def __init__(__self__, *,
                 automation_account_name: pulumi.Input[_builtins.str],
                 module_link: pulumi.Input['ModuleModuleLinkArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Module resource.
        :param pulumi.Input[_builtins.str] automation_account_name: The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        :param pulumi.Input['ModuleModuleLinkArgs'] module_link: A `module_link` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Module. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        pulumi.set(__self__, "module_link", module_link)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "automation_account_name", value)

    @_builtins.property
    @pulumi.getter(name="moduleLink")
    def module_link(self) -> pulumi.Input['ModuleModuleLinkArgs']:
        """
        A `module_link` block as defined below.
        """
        return pulumi.get(self, "module_link")

    @module_link.setter
    def module_link(self, value: pulumi.Input['ModuleModuleLinkArgs']):
        pulumi.set(self, "module_link", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ModuleState:
    def __init__(__self__, *,
                 automation_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 module_link: Optional[pulumi.Input['ModuleModuleLinkArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Module resources.
        :param pulumi.Input[_builtins.str] automation_account_name: The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        :param pulumi.Input['ModuleModuleLinkArgs'] module_link: A `module_link` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        """
        if automation_account_name is not None:
            pulumi.set(__self__, "automation_account_name", automation_account_name)
        if module_link is not None:
            pulumi.set(__self__, "module_link", module_link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automation_account_name", value)

    @_builtins.property
    @pulumi.getter(name="moduleLink")
    def module_link(self) -> Optional[pulumi.Input['ModuleModuleLinkArgs']]:
        """
        A `module_link` block as defined below.
        """
        return pulumi.get(self, "module_link")

    @module_link.setter
    def module_link(self, value: Optional[pulumi.Input['ModuleModuleLinkArgs']]):
        pulumi.set(self, "module_link", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:automation/module:Module")
class Module(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 module_link: Optional[pulumi.Input[Union['ModuleModuleLinkArgs', 'ModuleModuleLinkArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Automation Module.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="account1",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_module = azure.automation.Module("example",
            name="xActiveDirectory",
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            module_link={
                "uri": "https://devopsgallerystorage.blob.core.windows.net/packages/xactivedirectory.2.19.0.nupkg",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation` - 2024-10-23

        ## Import

        Automation Modules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/module:Module module1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/modules/module1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automation_account_name: The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ModuleModuleLinkArgs', 'ModuleModuleLinkArgsDict']] module_link: A `module_link` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Automation Module.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="account1",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_module = azure.automation.Module("example",
            name="xActiveDirectory",
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            module_link={
                "uri": "https://devopsgallerystorage.blob.core.windows.net/packages/xactivedirectory.2.19.0.nupkg",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation` - 2024-10-23

        ## Import

        Automation Modules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/module:Module module1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/modules/module1
        ```

        :param str resource_name: The name of the resource.
        :param ModuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 module_link: Optional[pulumi.Input[Union['ModuleModuleLinkArgs', 'ModuleModuleLinkArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModuleArgs.__new__(ModuleArgs)

            if automation_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_name'")
            __props__.__dict__["automation_account_name"] = automation_account_name
            if module_link is None and not opts.urn:
                raise TypeError("Missing required property 'module_link'")
            __props__.__dict__["module_link"] = module_link
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(Module, __self__).__init__(
            'azure:automation/module:Module',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automation_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            module_link: Optional[pulumi.Input[Union['ModuleModuleLinkArgs', 'ModuleModuleLinkArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Module':
        """
        Get an existing Module resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automation_account_name: The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ModuleModuleLinkArgs', 'ModuleModuleLinkArgsDict']] module_link: A `module_link` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Module. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModuleState.__new__(_ModuleState)

        __props__.__dict__["automation_account_name"] = automation_account_name
        __props__.__dict__["module_link"] = module_link
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return Module(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the automation account in which the Module is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @_builtins.property
    @pulumi.getter(name="moduleLink")
    def module_link(self) -> pulumi.Output['outputs.ModuleModuleLink']:
        """
        A `module_link` block as defined below.
        """
        return pulumi.get(self, "module_link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Module. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Module is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

