# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SoftwareUpdateConfigurationArgs', 'SoftwareUpdateConfiguration']

@pulumi.input_type
class SoftwareUpdateConfigurationArgs:
    def __init__(__self__, *,
                 automation_account_id: pulumi.Input[_builtins.str],
                 schedule: pulumi.Input['SoftwareUpdateConfigurationScheduleArgs'],
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 linux: Optional[pulumi.Input['SoftwareUpdateConfigurationLinuxArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_azure_computer_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 post_task: Optional[pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs']] = None,
                 pre_task: Optional[pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs']] = None,
                 target: Optional[pulumi.Input['SoftwareUpdateConfigurationTargetArgs']] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 windows: Optional[pulumi.Input['SoftwareUpdateConfigurationWindowsArgs']] = None):
        """
        The set of arguments for constructing a SoftwareUpdateConfiguration resource.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        :param pulumi.Input['SoftwareUpdateConfigurationScheduleArgs'] schedule: A `schedule` blocks as defined below.
        :param pulumi.Input[_builtins.str] duration: Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        :param pulumi.Input['SoftwareUpdateConfigurationLinuxArgs'] linux: A `linux` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation. Changing this forces a new Automation to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] non_azure_computer_names: Specifies a list of names of non-Azure machines for the software update configuration.
        :param pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs'] post_task: A `post_task` blocks as defined below.
        :param pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs'] pre_task: A `pre_task` blocks as defined below.
        :param pulumi.Input['SoftwareUpdateConfigurationTargetArgs'] target: A `target` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_machine_ids: Specifies a list of Azure Resource IDs of azure virtual machines.
        :param pulumi.Input['SoftwareUpdateConfigurationWindowsArgs'] windows: A `windows` block as defined below.
               
               > **Note:** One of `linux` or `windows` must be specified.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "schedule", schedule)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if linux is not None:
            pulumi.set(__self__, "linux", linux)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_azure_computer_names is not None:
            pulumi.set(__self__, "non_azure_computer_names", non_azure_computer_names)
        if post_task is not None:
            pulumi.set(__self__, "post_task", post_task)
        if pre_task is not None:
            pulumi.set(__self__, "pre_task", pre_task)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if virtual_machine_ids is not None:
            pulumi.set(__self__, "virtual_machine_ids", virtual_machine_ids)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "automation_account_id", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['SoftwareUpdateConfigurationScheduleArgs']:
        """
        A `schedule` blocks as defined below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['SoftwareUpdateConfigurationScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def linux(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationLinuxArgs']]:
        """
        A `linux` block as defined below.
        """
        return pulumi.get(self, "linux")

    @linux.setter
    def linux(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationLinuxArgs']]):
        pulumi.set(self, "linux", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Automation. Changing this forces a new Automation to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonAzureComputerNames")
    def non_azure_computer_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of names of non-Azure machines for the software update configuration.
        """
        return pulumi.get(self, "non_azure_computer_names")

    @non_azure_computer_names.setter
    def non_azure_computer_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "non_azure_computer_names", value)

    @_builtins.property
    @pulumi.getter(name="postTask")
    def post_task(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs']]:
        """
        A `post_task` blocks as defined below.
        """
        return pulumi.get(self, "post_task")

    @post_task.setter
    def post_task(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs']]):
        pulumi.set(self, "post_task", value)

    @_builtins.property
    @pulumi.getter(name="preTask")
    def pre_task(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs']]:
        """
        A `pre_task` blocks as defined below.
        """
        return pulumi.get(self, "pre_task")

    @pre_task.setter
    def pre_task(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs']]):
        pulumi.set(self, "pre_task", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationTargetArgs']]:
        """
        A `target` blocks as defined below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Azure Resource IDs of azure virtual machines.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @virtual_machine_ids.setter
    def virtual_machine_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "virtual_machine_ids", value)

    @_builtins.property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationWindowsArgs']]:
        """
        A `windows` block as defined below.

        > **Note:** One of `linux` or `windows` must be specified.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationWindowsArgs']]):
        pulumi.set(self, "windows", value)


@pulumi.input_type
class _SoftwareUpdateConfigurationState:
    def __init__(__self__, *,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 error_code: Optional[pulumi.Input[_builtins.str]] = None,
                 error_message: Optional[pulumi.Input[_builtins.str]] = None,
                 linux: Optional[pulumi.Input['SoftwareUpdateConfigurationLinuxArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_azure_computer_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 post_task: Optional[pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs']] = None,
                 pre_task: Optional[pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs']] = None,
                 schedule: Optional[pulumi.Input['SoftwareUpdateConfigurationScheduleArgs']] = None,
                 target: Optional[pulumi.Input['SoftwareUpdateConfigurationTargetArgs']] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 windows: Optional[pulumi.Input['SoftwareUpdateConfigurationWindowsArgs']] = None):
        """
        Input properties used for looking up and filtering SoftwareUpdateConfiguration resources.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        :param pulumi.Input[_builtins.str] duration: Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        :param pulumi.Input[_builtins.str] error_code: The Error code when failed.
        :param pulumi.Input[_builtins.str] error_message: The Error message indicating why the operation failed.
        :param pulumi.Input['SoftwareUpdateConfigurationLinuxArgs'] linux: A `linux` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation. Changing this forces a new Automation to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] non_azure_computer_names: Specifies a list of names of non-Azure machines for the software update configuration.
        :param pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs'] post_task: A `post_task` blocks as defined below.
        :param pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs'] pre_task: A `pre_task` blocks as defined below.
        :param pulumi.Input['SoftwareUpdateConfigurationScheduleArgs'] schedule: A `schedule` blocks as defined below.
        :param pulumi.Input['SoftwareUpdateConfigurationTargetArgs'] target: A `target` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_machine_ids: Specifies a list of Azure Resource IDs of azure virtual machines.
        :param pulumi.Input['SoftwareUpdateConfigurationWindowsArgs'] windows: A `windows` block as defined below.
               
               > **Note:** One of `linux` or `windows` must be specified.
        """
        if automation_account_id is not None:
            pulumi.set(__self__, "automation_account_id", automation_account_id)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if linux is not None:
            pulumi.set(__self__, "linux", linux)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_azure_computer_names is not None:
            pulumi.set(__self__, "non_azure_computer_names", non_azure_computer_names)
        if post_task is not None:
            pulumi.set(__self__, "post_task", post_task)
        if pre_task is not None:
            pulumi.set(__self__, "pre_task", pre_task)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if virtual_machine_ids is not None:
            pulumi.set(__self__, "virtual_machine_ids", virtual_machine_ids)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automation_account_id", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Error code when failed.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_code", value)

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Error message indicating why the operation failed.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_message", value)

    @_builtins.property
    @pulumi.getter
    def linux(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationLinuxArgs']]:
        """
        A `linux` block as defined below.
        """
        return pulumi.get(self, "linux")

    @linux.setter
    def linux(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationLinuxArgs']]):
        pulumi.set(self, "linux", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Automation. Changing this forces a new Automation to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonAzureComputerNames")
    def non_azure_computer_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of names of non-Azure machines for the software update configuration.
        """
        return pulumi.get(self, "non_azure_computer_names")

    @non_azure_computer_names.setter
    def non_azure_computer_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "non_azure_computer_names", value)

    @_builtins.property
    @pulumi.getter(name="postTask")
    def post_task(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs']]:
        """
        A `post_task` blocks as defined below.
        """
        return pulumi.get(self, "post_task")

    @post_task.setter
    def post_task(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationPostTaskArgs']]):
        pulumi.set(self, "post_task", value)

    @_builtins.property
    @pulumi.getter(name="preTask")
    def pre_task(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs']]:
        """
        A `pre_task` blocks as defined below.
        """
        return pulumi.get(self, "pre_task")

    @pre_task.setter
    def pre_task(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationPreTaskArgs']]):
        pulumi.set(self, "pre_task", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationScheduleArgs']]:
        """
        A `schedule` blocks as defined below.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationTargetArgs']]:
        """
        A `target` blocks as defined below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Azure Resource IDs of azure virtual machines.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @virtual_machine_ids.setter
    def virtual_machine_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "virtual_machine_ids", value)

    @_builtins.property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input['SoftwareUpdateConfigurationWindowsArgs']]:
        """
        A `windows` block as defined below.

        > **Note:** One of `linux` or `windows` must be specified.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input['SoftwareUpdateConfigurationWindowsArgs']]):
        pulumi.set(self, "windows", value)


@pulumi.type_token("azure:automation/softwareUpdateConfiguration:SoftwareUpdateConfiguration")
class SoftwareUpdateConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 linux: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationLinuxArgs', 'SoftwareUpdateConfigurationLinuxArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_azure_computer_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 post_task: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationPostTaskArgs', 'SoftwareUpdateConfigurationPostTaskArgsDict']]] = None,
                 pre_task: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationPreTaskArgs', 'SoftwareUpdateConfigurationPreTaskArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationScheduleArgs', 'SoftwareUpdateConfigurationScheduleArgsDict']]] = None,
                 target: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationTargetArgs', 'SoftwareUpdateConfigurationTargetArgsDict']]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 windows: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationWindowsArgs', 'SoftwareUpdateConfigurationWindowsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an Automation Software Update Configuration.

        !> **Note:** The `automation.SoftwareUpdateConfiguration` resource has been deprecated because the Azure Automation Update Management was retired on 2024-08-31 and has been shutdown on 2025-02-28. This resource will be removed in v5.0 of the AzureRM Provider. Please migrate to Azure Update Manager, and use the `maintenance.Configuration` resource combined with the appropriate assignment resources instead. See https://techcommunity.microsoft.com/blog/azuregovernanceandmanagementblog/log-analytics-agent-based-azure-management-services-shut-down-starting-28-februa/4381853 for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        example_account = azure.automation.Account("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_run_book = azure.automation.RunBook("example",
            name="Get-AzureVMTutorial",
            location=example.location,
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            log_verbose=True,
            log_progress=True,
            description="This is a example runbook for terraform acceptance example",
            runbook_type="Python3",
            content=\"\"\"# Some example content
        # for Terraform acceptance example
        \"\"\",
            tags={
                "ENV": "runbook_test",
            })
        example_software_update_configuration = azure.automation.SoftwareUpdateConfiguration("example",
            name="example",
            automation_account_id=example_account.id,
            linux={
                "classifications_includeds": "Security",
                "excluded_packages": ["apt"],
                "included_packages": ["vim"],
                "reboot": "IfRequired",
            },
            pre_task={
                "source": example_run_book.name,
                "parameters": {
                    "COMPUTER_NAME": "Foo",
                },
            },
            duration="PT2H2M2S")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation` - 2019-06-01

        ## Import

        Automations Software Update Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/softwareUpdateConfiguration:SoftwareUpdateConfiguration example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/softwareUpdateConfigurations/suc1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        :param pulumi.Input[_builtins.str] duration: Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationLinuxArgs', 'SoftwareUpdateConfigurationLinuxArgsDict']] linux: A `linux` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation. Changing this forces a new Automation to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] non_azure_computer_names: Specifies a list of names of non-Azure machines for the software update configuration.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationPostTaskArgs', 'SoftwareUpdateConfigurationPostTaskArgsDict']] post_task: A `post_task` blocks as defined below.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationPreTaskArgs', 'SoftwareUpdateConfigurationPreTaskArgsDict']] pre_task: A `pre_task` blocks as defined below.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationScheduleArgs', 'SoftwareUpdateConfigurationScheduleArgsDict']] schedule: A `schedule` blocks as defined below.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationTargetArgs', 'SoftwareUpdateConfigurationTargetArgsDict']] target: A `target` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_machine_ids: Specifies a list of Azure Resource IDs of azure virtual machines.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationWindowsArgs', 'SoftwareUpdateConfigurationWindowsArgsDict']] windows: A `windows` block as defined below.
               
               > **Note:** One of `linux` or `windows` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SoftwareUpdateConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Automation Software Update Configuration.

        !> **Note:** The `automation.SoftwareUpdateConfiguration` resource has been deprecated because the Azure Automation Update Management was retired on 2024-08-31 and has been shutdown on 2025-02-28. This resource will be removed in v5.0 of the AzureRM Provider. Please migrate to Azure Update Manager, and use the `maintenance.Configuration` resource combined with the appropriate assignment resources instead. See https://techcommunity.microsoft.com/blog/azuregovernanceandmanagementblog/log-analytics-agent-based-azure-management-services-shut-down-starting-28-februa/4381853 for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        example_account = azure.automation.Account("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_run_book = azure.automation.RunBook("example",
            name="Get-AzureVMTutorial",
            location=example.location,
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            log_verbose=True,
            log_progress=True,
            description="This is a example runbook for terraform acceptance example",
            runbook_type="Python3",
            content=\"\"\"# Some example content
        # for Terraform acceptance example
        \"\"\",
            tags={
                "ENV": "runbook_test",
            })
        example_software_update_configuration = azure.automation.SoftwareUpdateConfiguration("example",
            name="example",
            automation_account_id=example_account.id,
            linux={
                "classifications_includeds": "Security",
                "excluded_packages": ["apt"],
                "included_packages": ["vim"],
                "reboot": "IfRequired",
            },
            pre_task={
                "source": example_run_book.name,
                "parameters": {
                    "COMPUTER_NAME": "Foo",
                },
            },
            duration="PT2H2M2S")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation` - 2019-06-01

        ## Import

        Automations Software Update Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/softwareUpdateConfiguration:SoftwareUpdateConfiguration example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/softwareUpdateConfigurations/suc1
        ```

        :param str resource_name: The name of the resource.
        :param SoftwareUpdateConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SoftwareUpdateConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 linux: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationLinuxArgs', 'SoftwareUpdateConfigurationLinuxArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_azure_computer_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 post_task: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationPostTaskArgs', 'SoftwareUpdateConfigurationPostTaskArgsDict']]] = None,
                 pre_task: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationPreTaskArgs', 'SoftwareUpdateConfigurationPreTaskArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationScheduleArgs', 'SoftwareUpdateConfigurationScheduleArgsDict']]] = None,
                 target: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationTargetArgs', 'SoftwareUpdateConfigurationTargetArgsDict']]] = None,
                 virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 windows: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationWindowsArgs', 'SoftwareUpdateConfigurationWindowsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SoftwareUpdateConfigurationArgs.__new__(SoftwareUpdateConfigurationArgs)

            if automation_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_id'")
            __props__.__dict__["automation_account_id"] = automation_account_id
            __props__.__dict__["duration"] = duration
            __props__.__dict__["linux"] = linux
            __props__.__dict__["name"] = name
            __props__.__dict__["non_azure_computer_names"] = non_azure_computer_names
            __props__.__dict__["post_task"] = post_task
            __props__.__dict__["pre_task"] = pre_task
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["target"] = target
            __props__.__dict__["virtual_machine_ids"] = virtual_machine_ids
            __props__.__dict__["windows"] = windows
            __props__.__dict__["error_code"] = None
            __props__.__dict__["error_message"] = None
        super(SoftwareUpdateConfiguration, __self__).__init__(
            'azure:automation/softwareUpdateConfiguration:SoftwareUpdateConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.str]] = None,
            error_code: Optional[pulumi.Input[_builtins.str]] = None,
            error_message: Optional[pulumi.Input[_builtins.str]] = None,
            linux: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationLinuxArgs', 'SoftwareUpdateConfigurationLinuxArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            non_azure_computer_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            post_task: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationPostTaskArgs', 'SoftwareUpdateConfigurationPostTaskArgsDict']]] = None,
            pre_task: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationPreTaskArgs', 'SoftwareUpdateConfigurationPreTaskArgsDict']]] = None,
            schedule: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationScheduleArgs', 'SoftwareUpdateConfigurationScheduleArgsDict']]] = None,
            target: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationTargetArgs', 'SoftwareUpdateConfigurationTargetArgsDict']]] = None,
            virtual_machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            windows: Optional[pulumi.Input[Union['SoftwareUpdateConfigurationWindowsArgs', 'SoftwareUpdateConfigurationWindowsArgsDict']]] = None) -> 'SoftwareUpdateConfiguration':
        """
        Get an existing SoftwareUpdateConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        :param pulumi.Input[_builtins.str] duration: Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        :param pulumi.Input[_builtins.str] error_code: The Error code when failed.
        :param pulumi.Input[_builtins.str] error_message: The Error message indicating why the operation failed.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationLinuxArgs', 'SoftwareUpdateConfigurationLinuxArgsDict']] linux: A `linux` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation. Changing this forces a new Automation to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] non_azure_computer_names: Specifies a list of names of non-Azure machines for the software update configuration.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationPostTaskArgs', 'SoftwareUpdateConfigurationPostTaskArgsDict']] post_task: A `post_task` blocks as defined below.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationPreTaskArgs', 'SoftwareUpdateConfigurationPreTaskArgsDict']] pre_task: A `pre_task` blocks as defined below.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationScheduleArgs', 'SoftwareUpdateConfigurationScheduleArgsDict']] schedule: A `schedule` blocks as defined below.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationTargetArgs', 'SoftwareUpdateConfigurationTargetArgsDict']] target: A `target` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtual_machine_ids: Specifies a list of Azure Resource IDs of azure virtual machines.
        :param pulumi.Input[Union['SoftwareUpdateConfigurationWindowsArgs', 'SoftwareUpdateConfigurationWindowsArgsDict']] windows: A `windows` block as defined below.
               
               > **Note:** One of `linux` or `windows` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SoftwareUpdateConfigurationState.__new__(_SoftwareUpdateConfigurationState)

        __props__.__dict__["automation_account_id"] = automation_account_id
        __props__.__dict__["duration"] = duration
        __props__.__dict__["error_code"] = error_code
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["linux"] = linux
        __props__.__dict__["name"] = name
        __props__.__dict__["non_azure_computer_names"] = non_azure_computer_names
        __props__.__dict__["post_task"] = post_task
        __props__.__dict__["pre_task"] = pre_task
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["target"] = target
        __props__.__dict__["virtual_machine_ids"] = virtual_machine_ids
        __props__.__dict__["windows"] = windows
        return SoftwareUpdateConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Automation Account to manage this Source Control. Changing this forces a new Automation Source Control to be created.
        """
        return pulumi.get(self, "automation_account_id")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Maximum time allowed for the software update configuration run. using format `PT[n]H[n]M[n]S` as per ISO8601. Defaults to `PT2H`.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> pulumi.Output[_builtins.str]:
        """
        The Error code when failed.
        """
        return pulumi.get(self, "error_code")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[_builtins.str]:
        """
        The Error message indicating why the operation failed.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    def linux(self) -> pulumi.Output[Optional['outputs.SoftwareUpdateConfigurationLinux']]:
        """
        A `linux` block as defined below.
        """
        return pulumi.get(self, "linux")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Automation. Changing this forces a new Automation to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nonAzureComputerNames")
    def non_azure_computer_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of names of non-Azure machines for the software update configuration.
        """
        return pulumi.get(self, "non_azure_computer_names")

    @_builtins.property
    @pulumi.getter(name="postTask")
    def post_task(self) -> pulumi.Output[Optional['outputs.SoftwareUpdateConfigurationPostTask']]:
        """
        A `post_task` blocks as defined below.
        """
        return pulumi.get(self, "post_task")

    @_builtins.property
    @pulumi.getter(name="preTask")
    def pre_task(self) -> pulumi.Output[Optional['outputs.SoftwareUpdateConfigurationPreTask']]:
        """
        A `pre_task` blocks as defined below.
        """
        return pulumi.get(self, "pre_task")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.SoftwareUpdateConfigurationSchedule']:
        """
        A `schedule` blocks as defined below.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional['outputs.SoftwareUpdateConfigurationTarget']]:
        """
        A `target` blocks as defined below.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="virtualMachineIds")
    def virtual_machine_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Azure Resource IDs of azure virtual machines.
        """
        return pulumi.get(self, "virtual_machine_ids")

    @_builtins.property
    @pulumi.getter
    def windows(self) -> pulumi.Output[Optional['outputs.SoftwareUpdateConfigurationWindows']]:
        """
        A `windows` block as defined below.

        > **Note:** One of `linux` or `windows` must be specified.
        """
        return pulumi.get(self, "windows")

