# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PrivateCloudCircuit',
    'PrivateCloudManagementCluster',
    'GetPrivateCloudCircuitResult',
    'GetPrivateCloudManagementClusterResult',
]

@pulumi.output_type
class PrivateCloudCircuit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressRouteId":
            suggest = "express_route_id"
        elif key == "expressRoutePrivatePeeringId":
            suggest = "express_route_private_peering_id"
        elif key == "primarySubnetCidr":
            suggest = "primary_subnet_cidr"
        elif key == "secondarySubnetCidr":
            suggest = "secondary_subnet_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudCircuit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudCircuit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudCircuit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 express_route_id: Optional[_builtins.str] = None,
                 express_route_private_peering_id: Optional[_builtins.str] = None,
                 primary_subnet_cidr: Optional[_builtins.str] = None,
                 secondary_subnet_cidr: Optional[_builtins.str] = None):
        """
        :param _builtins.str express_route_id: The ID of the ExpressRoute Circuit.
        :param _builtins.str express_route_private_peering_id: The ID of the ExpressRoute Circuit private peering.
        :param _builtins.str primary_subnet_cidr: The CIDR of the primary subnet.
        :param _builtins.str secondary_subnet_cidr: The CIDR of the secondary subnet.
        """
        if express_route_id is not None:
            pulumi.set(__self__, "express_route_id", express_route_id)
        if express_route_private_peering_id is not None:
            pulumi.set(__self__, "express_route_private_peering_id", express_route_private_peering_id)
        if primary_subnet_cidr is not None:
            pulumi.set(__self__, "primary_subnet_cidr", primary_subnet_cidr)
        if secondary_subnet_cidr is not None:
            pulumi.set(__self__, "secondary_subnet_cidr", secondary_subnet_cidr)

    @_builtins.property
    @pulumi.getter(name="expressRouteId")
    def express_route_id(self) -> Optional[_builtins.str]:
        """
        The ID of the ExpressRoute Circuit.
        """
        return pulumi.get(self, "express_route_id")

    @_builtins.property
    @pulumi.getter(name="expressRoutePrivatePeeringId")
    def express_route_private_peering_id(self) -> Optional[_builtins.str]:
        """
        The ID of the ExpressRoute Circuit private peering.
        """
        return pulumi.get(self, "express_route_private_peering_id")

    @_builtins.property
    @pulumi.getter(name="primarySubnetCidr")
    def primary_subnet_cidr(self) -> Optional[_builtins.str]:
        """
        The CIDR of the primary subnet.
        """
        return pulumi.get(self, "primary_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="secondarySubnetCidr")
    def secondary_subnet_cidr(self) -> Optional[_builtins.str]:
        """
        The CIDR of the secondary subnet.
        """
        return pulumi.get(self, "secondary_subnet_cidr")


@pulumi.output_type
class PrivateCloudManagementCluster(dict):
    def __init__(__self__, *,
                 size: _builtins.int,
                 hosts: Optional[Sequence[_builtins.str]] = None,
                 id: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: The size of the management cluster. This field can not updated with `internet_connection_enabled` together.
        :param Sequence[_builtins.str] hosts: A list of hosts in the management cluster.
        :param _builtins.int id: The ID of the management cluster.
        """
        pulumi.set(__self__, "size", size)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the management cluster. This field can not updated with `internet_connection_enabled` together.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of hosts in the management cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The ID of the management cluster.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPrivateCloudCircuitResult(dict):
    def __init__(__self__, *,
                 express_route_id: _builtins.str,
                 express_route_private_peering_id: _builtins.str,
                 primary_subnet_cidr: _builtins.str,
                 secondary_subnet_cidr: _builtins.str):
        """
        :param _builtins.str express_route_id: The ID of the ExpressRoute Circuit.
        :param _builtins.str express_route_private_peering_id: The ID of the ExpressRoute Circuit private peering.
        :param _builtins.str primary_subnet_cidr: The CIDR of the primary subnet.
        :param _builtins.str secondary_subnet_cidr: The CIDR of the secondary subnet.
        """
        pulumi.set(__self__, "express_route_id", express_route_id)
        pulumi.set(__self__, "express_route_private_peering_id", express_route_private_peering_id)
        pulumi.set(__self__, "primary_subnet_cidr", primary_subnet_cidr)
        pulumi.set(__self__, "secondary_subnet_cidr", secondary_subnet_cidr)

    @_builtins.property
    @pulumi.getter(name="expressRouteId")
    def express_route_id(self) -> _builtins.str:
        """
        The ID of the ExpressRoute Circuit.
        """
        return pulumi.get(self, "express_route_id")

    @_builtins.property
    @pulumi.getter(name="expressRoutePrivatePeeringId")
    def express_route_private_peering_id(self) -> _builtins.str:
        """
        The ID of the ExpressRoute Circuit private peering.
        """
        return pulumi.get(self, "express_route_private_peering_id")

    @_builtins.property
    @pulumi.getter(name="primarySubnetCidr")
    def primary_subnet_cidr(self) -> _builtins.str:
        """
        The CIDR of the primary subnet.
        """
        return pulumi.get(self, "primary_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="secondarySubnetCidr")
    def secondary_subnet_cidr(self) -> _builtins.str:
        """
        The CIDR of the secondary subnet.
        """
        return pulumi.get(self, "secondary_subnet_cidr")


@pulumi.output_type
class GetPrivateCloudManagementClusterResult(dict):
    def __init__(__self__, *,
                 hosts: Sequence[_builtins.str],
                 id: _builtins.int,
                 size: _builtins.int):
        """
        :param Sequence[_builtins.str] hosts: The list of the hosts in the management cluster.
        :param _builtins.int id: The ID of the management cluster.
        :param _builtins.int size: The size of the management cluster.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence[_builtins.str]:
        """
        The list of the hosts in the management cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the management cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the management cluster.
        """
        return pulumi.get(self, "size")


