# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountEncryption',
    'AccountIdentity',
    'AccountKeyVaultReference',
    'AccountNetworkProfile',
    'AccountNetworkProfileAccountAccess',
    'AccountNetworkProfileAccountAccessIpRule',
    'AccountNetworkProfileNodeManagementAccess',
    'AccountNetworkProfileNodeManagementAccessIpRule',
    'PoolAutoScale',
    'PoolCertificate',
    'PoolContainerConfiguration',
    'PoolContainerConfigurationContainerRegistry',
    'PoolDataDisk',
    'PoolDiskEncryption',
    'PoolExtension',
    'PoolFixedScale',
    'PoolIdentity',
    'PoolMount',
    'PoolMountAzureBlobFileSystem',
    'PoolMountAzureFileShare',
    'PoolMountCifsMount',
    'PoolMountNfsMount',
    'PoolNetworkConfiguration',
    'PoolNetworkConfigurationEndpointConfiguration',
    'PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule',
    'PoolNodePlacement',
    'PoolSecurityProfile',
    'PoolStartTask',
    'PoolStartTaskContainer',
    'PoolStartTaskContainerRegistry',
    'PoolStartTaskResourceFile',
    'PoolStartTaskUserIdentity',
    'PoolStartTaskUserIdentityAutoUser',
    'PoolStorageImageReference',
    'PoolTaskSchedulingPolicy',
    'PoolUserAccount',
    'PoolUserAccountLinuxUserConfiguration',
    'PoolUserAccountWindowsUserConfiguration',
    'PoolWindow',
    'GetAccountEncryptionResult',
    'GetAccountKeyVaultReferenceResult',
    'GetPoolAutoScaleResult',
    'GetPoolCertificateResult',
    'GetPoolContainerConfigurationResult',
    'GetPoolContainerConfigurationContainerRegistryResult',
    'GetPoolDataDiskResult',
    'GetPoolDiskEncryptionResult',
    'GetPoolExtensionResult',
    'GetPoolFixedScaleResult',
    'GetPoolMountResult',
    'GetPoolMountAzureBlobFileSystemResult',
    'GetPoolMountAzureFileShareResult',
    'GetPoolMountCifsMountResult',
    'GetPoolMountNfsMountResult',
    'GetPoolNetworkConfigurationResult',
    'GetPoolNetworkConfigurationEndpointConfigurationResult',
    'GetPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleResult',
    'GetPoolNodePlacementResult',
    'GetPoolStartTaskResult',
    'GetPoolStartTaskContainerResult',
    'GetPoolStartTaskContainerRegistryResult',
    'GetPoolStartTaskResourceFileResult',
    'GetPoolStartTaskUserIdentityResult',
    'GetPoolStartTaskUserIdentityAutoUserResult',
    'GetPoolStorageImageReferenceResult',
    'GetPoolTaskSchedulingPolicyResult',
    'GetPoolUserAccountResult',
    'GetPoolUserAccountLinuxUserConfigurationResult',
    'GetPoolUserAccountWindowsUserConfigurationResult',
    'GetPoolWindowResult',
]

@pulumi.output_type
class AccountEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultKeyId":
            suggest = "key_vault_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_key_id: _builtins.str):
        """
        :param _builtins.str key_vault_key_id: The full URL path to the Azure key vault key id that should be used to encrypt data, as documented [here](https://docs.microsoft.com/azure/batch/batch-customer-managed-key). Both versioned and versionless keys are supported.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The full URL path to the Azure key vault key id that should be used to encrypt data, as documented [here](https://docs.microsoft.com/azure/batch/batch-customer-managed-key). Both versioned and versionless keys are supported.
        """
        return pulumi.get(self, "key_vault_key_id")


@pulumi.output_type
class AccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Batch Account. Possible values are `SystemAssigned` or `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Batch Account. Possible values are `SystemAssigned` or `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Batch Account.

        > **NOTE:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AccountKeyVaultReference(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str id: The Azure identifier of the Azure KeyVault to use.
        :param _builtins.str url: The HTTPS URL of the Azure KeyVault to use.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Azure identifier of the Azure KeyVault to use.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The HTTPS URL of the Azure KeyVault to use.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class AccountNetworkProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountAccess":
            suggest = "account_access"
        elif key == "nodeManagementAccess":
            suggest = "node_management_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_access: Optional['outputs.AccountNetworkProfileAccountAccess'] = None,
                 node_management_access: Optional['outputs.AccountNetworkProfileNodeManagementAccess'] = None):
        """
        :param 'AccountNetworkProfileAccountAccessArgs' account_access: An `account_access` block as defined below.
        :param 'AccountNetworkProfileNodeManagementAccessArgs' node_management_access: A `node_management_access` block as defined below.
               
               > **NOTE:** At least one of `account_access` or `node_management_access` must be specified.
        """
        if account_access is not None:
            pulumi.set(__self__, "account_access", account_access)
        if node_management_access is not None:
            pulumi.set(__self__, "node_management_access", node_management_access)

    @_builtins.property
    @pulumi.getter(name="accountAccess")
    def account_access(self) -> Optional['outputs.AccountNetworkProfileAccountAccess']:
        """
        An `account_access` block as defined below.
        """
        return pulumi.get(self, "account_access")

    @_builtins.property
    @pulumi.getter(name="nodeManagementAccess")
    def node_management_access(self) -> Optional['outputs.AccountNetworkProfileNodeManagementAccess']:
        """
        A `node_management_access` block as defined below.

        > **NOTE:** At least one of `account_access` or `node_management_access` must be specified.
        """
        return pulumi.get(self, "node_management_access")


@pulumi.output_type
class AccountNetworkProfileAccountAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkProfileAccountAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkProfileAccountAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkProfileAccountAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: Optional[_builtins.str] = None,
                 ip_rules: Optional[Sequence['outputs.AccountNetworkProfileAccountAccessIpRule']] = None):
        """
        :param _builtins.str default_action: Specifies the default action for the account access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param Sequence['AccountNetworkProfileAccountAccessIpRuleArgs'] ip_rules: One or more `ip_rule` blocks as defined below.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[_builtins.str]:
        """
        Specifies the default action for the account access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.AccountNetworkProfileAccountAccessIpRule']]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")


@pulumi.output_type
class AccountNetworkProfileAccountAccessIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkProfileAccountAccessIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkProfileAccountAccessIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkProfileAccountAccessIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_range: _builtins.str,
                 action: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_range: The CIDR block from which requests will match the rule.
        :param _builtins.str action: Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The CIDR block from which requests will match the rule.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class AccountNetworkProfileNodeManagementAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkProfileNodeManagementAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkProfileNodeManagementAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkProfileNodeManagementAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: Optional[_builtins.str] = None,
                 ip_rules: Optional[Sequence['outputs.AccountNetworkProfileNodeManagementAccessIpRule']] = None):
        """
        :param _builtins.str default_action: Specifies the default action for the node management access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param Sequence['AccountNetworkProfileNodeManagementAccessIpRuleArgs'] ip_rules: One or more `ip_rule` blocks as defined below.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[_builtins.str]:
        """
        Specifies the default action for the node management access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.AccountNetworkProfileNodeManagementAccessIpRule']]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")


@pulumi.output_type
class AccountNetworkProfileNodeManagementAccessIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkProfileNodeManagementAccessIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkProfileNodeManagementAccessIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkProfileNodeManagementAccessIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_range: _builtins.str,
                 action: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_range: The CIDR block from which requests will match the rule.
        :param _builtins.str action: Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The CIDR block from which requests will match the rule.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class PoolAutoScale(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationInterval":
            suggest = "evaluation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolAutoScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolAutoScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolAutoScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 formula: _builtins.str,
                 evaluation_interval: Optional[_builtins.str] = None):
        """
        :param _builtins.str formula: The autoscale formula that needs to be used for scaling the Batch pool.
        :param _builtins.str evaluation_interval: The interval to wait before evaluating if the pool needs to be scaled. Defaults to `PT15M`.
        """
        pulumi.set(__self__, "formula", formula)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @_builtins.property
    @pulumi.getter
    def formula(self) -> _builtins.str:
        """
        The autoscale formula that needs to be used for scaling the Batch pool.
        """
        return pulumi.get(self, "formula")

    @_builtins.property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[_builtins.str]:
        """
        The interval to wait before evaluating if the pool needs to be scaled. Defaults to `PT15M`.
        """
        return pulumi.get(self, "evaluation_interval")


@pulumi.output_type
class PoolCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storeLocation":
            suggest = "store_location"
        elif key == "storeName":
            suggest = "store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 store_location: _builtins.str,
                 store_name: Optional[_builtins.str] = None,
                 visibilities: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str id: The ID of the Batch Certificate to install on the Batch Pool, which must be inside the same Batch Account.
        :param _builtins.str store_location: The location of the certificate store on the compute node into which to install the certificate. Possible values are `CurrentUser` or `LocalMachine`.
               
               > **Note:** This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a 'certs' directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
        :param _builtins.str store_name: The name of the certificate store on the compute node into which to install the certificate. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: `My`, `Root`, `CA`, `Trust`, `Disallowed`, `TrustedPeople`, `TrustedPublisher`, `AuthRoot`, `AddressBook`, but any custom store name can also be used.
        :param Sequence[_builtins.str] visibilities: Which user accounts on the compute node should have access to the private data of the certificate. Possible values are `StartTask`, `Task` and `RemoteUser`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "store_location", store_location)
        if store_name is not None:
            pulumi.set(__self__, "store_name", store_name)
        if visibilities is not None:
            pulumi.set(__self__, "visibilities", visibilities)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Batch Certificate to install on the Batch Pool, which must be inside the same Batch Account.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="storeLocation")
    def store_location(self) -> _builtins.str:
        """
        The location of the certificate store on the compute node into which to install the certificate. Possible values are `CurrentUser` or `LocalMachine`.

        > **Note:** This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a 'certs' directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
        """
        return pulumi.get(self, "store_location")

    @_builtins.property
    @pulumi.getter(name="storeName")
    def store_name(self) -> Optional[_builtins.str]:
        """
        The name of the certificate store on the compute node into which to install the certificate. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: `My`, `Root`, `CA`, `Trust`, `Disallowed`, `TrustedPeople`, `TrustedPublisher`, `AuthRoot`, `AddressBook`, but any custom store name can also be used.
        """
        return pulumi.get(self, "store_name")

    @_builtins.property
    @pulumi.getter
    def visibilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        Which user accounts on the compute node should have access to the private data of the certificate. Possible values are `StartTask`, `Task` and `RemoteUser`.
        """
        return pulumi.get(self, "visibilities")


@pulumi.output_type
class PoolContainerConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImageNames":
            suggest = "container_image_names"
        elif key == "containerRegistries":
            suggest = "container_registries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolContainerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolContainerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolContainerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_image_names: Optional[Sequence[_builtins.str]] = None,
                 container_registries: Optional[Sequence['outputs.PoolContainerConfigurationContainerRegistry']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] container_image_names: A list of container image names to use, as would be specified by `docker pull`. Changing this forces a new resource to be created.
        :param Sequence['PoolContainerConfigurationContainerRegistryArgs'] container_registries: One or more `container_registries` blocks as defined below. Additional container registries from which container images can be pulled by the pool's VMs. Changing this forces a new resource to be created.
        :param _builtins.str type: The type of container configuration. Possible value is `DockerCompatible`.
        """
        if container_image_names is not None:
            pulumi.set(__self__, "container_image_names", container_image_names)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="containerImageNames")
    def container_image_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of container image names to use, as would be specified by `docker pull`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_image_names")

    @_builtins.property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[Sequence['outputs.PoolContainerConfigurationContainerRegistry']]:
        """
        One or more `container_registries` blocks as defined below. Additional container registries from which container images can be pulled by the pool's VMs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registries")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of container configuration. Possible value is `DockerCompatible`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PoolContainerConfigurationContainerRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryServer":
            suggest = "registry_server"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolContainerConfigurationContainerRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolContainerConfigurationContainerRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolContainerConfigurationContainerRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_server: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 user_assigned_identity_id: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str registry_server: The container registry URL. Changing this forces a new resource to be created.
        :param _builtins.str password: The password to log into the registry server. Changing this forces a new resource to be created.
        :param _builtins.str user_assigned_identity_id: The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password. Changing this forces a new resource to be created.
        :param _builtins.str user_name: The user name to log into the registry server. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "registry_server", registry_server)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> _builtins.str:
        """
        The container registry URL. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password to log into the registry server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        The user name to log into the registry server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class PoolDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: _builtins.int,
                 lun: _builtins.int,
                 caching: Optional[_builtins.str] = None,
                 storage_account_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int disk_size_gb: The initial disk size in GB when creating new data disk.
        :param _builtins.int lun: The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        :param _builtins.str caching: Values are: "none" - The caching mode for the disk is not enabled. "readOnly" - The caching mode for the disk is read only. "readWrite" - The caching mode for the disk is read and write. For information about the caching options see: <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>. Possible values are `None`, `ReadOnly` and `ReadWrite`. Defaults to `ReadOnly`.
        :param _builtins.str storage_account_type: The storage account type to be used for the data disk. Values are: Possible values are `Standard_LRS` - The data disk should use standard locally redundant storage. `Premium_LRS` - The data disk should use premium locally redundant storage. Defaults to `Standard_LRS`.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        The initial disk size in GB when creating new data disk.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Values are: "none" - The caching mode for the disk is not enabled. "readOnly" - The caching mode for the disk is read only. "readWrite" - The caching mode for the disk is read and write. For information about the caching options see: <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>. Possible values are `None`, `ReadOnly` and `ReadWrite`. Defaults to `ReadOnly`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[_builtins.str]:
        """
        The storage account type to be used for the data disk. Values are: Possible values are `Standard_LRS` - The data disk should use standard locally redundant storage. `Premium_LRS` - The data disk should use premium locally redundant storage. Defaults to `Standard_LRS`.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class PoolDiskEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionTarget":
            suggest = "disk_encryption_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolDiskEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolDiskEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolDiskEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_target: _builtins.str):
        """
        :param _builtins.str disk_encryption_target: On Linux pool, only \\"TemporaryDisk\\" is supported; on Windows pool, \\"OsDisk\\" and \\"TemporaryDisk\\" must be specified.
        """
        pulumi.set(__self__, "disk_encryption_target", disk_encryption_target)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionTarget")
    def disk_encryption_target(self) -> _builtins.str:
        """
        On Linux pool, only \\"TemporaryDisk\\" is supported; on Windows pool, \\"OsDisk\\" and \\"TemporaryDisk\\" must be specified.
        """
        return pulumi.get(self, "disk_encryption_target")


@pulumi.output_type
class PoolExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "automaticUpgradeEnabled":
            suggest = "automatic_upgrade_enabled"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"
        elif key == "settingsJson":
            suggest = "settings_json"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 publisher: _builtins.str,
                 type: _builtins.str,
                 auto_upgrade_minor_version: Optional[_builtins.bool] = None,
                 automatic_upgrade_enabled: Optional[_builtins.bool] = None,
                 protected_settings: Optional[_builtins.str] = None,
                 provision_after_extensions: Optional[Sequence[_builtins.str]] = None,
                 settings_json: Optional[_builtins.str] = None,
                 type_handler_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the virtual machine extension.
        :param _builtins.str publisher: The name of the extension handler publisher.The name of the extension handler publisher.
        :param _builtins.str type: The type of the extensions.
        :param _builtins.bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param _builtins.bool automatic_upgrade_enabled: Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available. Supported values are `true` and `false`.
               
               > **Note:** When `automatic_upgrade_enabled` is set to `true`, the `type_handler_version` is automatically updated by the Azure platform when a new version is available and any change in `type_handler_version` should be manually ignored by user.
        :param _builtins.str protected_settings: JSON formatted protected settings for the extension, the value should be encoded with `jsonencode` function. The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        :param Sequence[_builtins.str] provision_after_extensions: The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        :param _builtins.str settings_json: JSON formatted public settings for the extension, the value should be encoded with `jsonencode` function.
        :param _builtins.str type_handler_version: The version of script handler.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings_json is not None:
            pulumi.set(__self__, "settings_json", settings_json)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the virtual machine extension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The name of the extension handler publisher.The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the extensions.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available. Supported values are `true` and `false`.

        > **Note:** When `automatic_upgrade_enabled` is set to `true`, the `type_handler_version` is automatically updated by the Azure platform when a new version is available and any change in `type_handler_version` should be manually ignored by user.
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[_builtins.str]:
        """
        JSON formatted protected settings for the extension, the value should be encoded with `jsonencode` function. The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[_builtins.str]]:
        """
        The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter(name="settingsJson")
    def settings_json(self) -> Optional[_builtins.str]:
        """
        JSON formatted public settings for the extension, the value should be encoded with `jsonencode` function.
        """
        return pulumi.get(self, "settings_json")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[_builtins.str]:
        """
        The version of script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class PoolFixedScale(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeDeallocationMethod":
            suggest = "node_deallocation_method"
        elif key == "resizeTimeout":
            suggest = "resize_timeout"
        elif key == "targetDedicatedNodes":
            suggest = "target_dedicated_nodes"
        elif key == "targetLowPriorityNodes":
            suggest = "target_low_priority_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolFixedScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolFixedScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolFixedScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_deallocation_method: Optional[_builtins.str] = None,
                 resize_timeout: Optional[_builtins.str] = None,
                 target_dedicated_nodes: Optional[_builtins.int] = None,
                 target_low_priority_nodes: Optional[_builtins.int] = None):
        """
        :param _builtins.str node_deallocation_method: It determines what to do with a node and its running task(s) if the pool size is decreasing. Values are `Requeue`, `RetainedData`, `TaskCompletion` and `Terminate`.
        :param _builtins.str resize_timeout: The timeout for resize operations. Defaults to `PT15M`.
        :param _builtins.int target_dedicated_nodes: The number of nodes in the Batch pool. Defaults to `1`.
        :param _builtins.int target_low_priority_nodes: The number of low priority nodes in the Batch pool. Defaults to `0`.
        """
        if node_deallocation_method is not None:
            pulumi.set(__self__, "node_deallocation_method", node_deallocation_method)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @_builtins.property
    @pulumi.getter(name="nodeDeallocationMethod")
    def node_deallocation_method(self) -> Optional[_builtins.str]:
        """
        It determines what to do with a node and its running task(s) if the pool size is decreasing. Values are `Requeue`, `RetainedData`, `TaskCompletion` and `Terminate`.
        """
        return pulumi.get(self, "node_deallocation_method")

    @_builtins.property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[_builtins.str]:
        """
        The timeout for resize operations. Defaults to `PT15M`.
        """
        return pulumi.get(self, "resize_timeout")

    @_builtins.property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[_builtins.int]:
        """
        The number of nodes in the Batch pool. Defaults to `1`.
        """
        return pulumi.get(self, "target_dedicated_nodes")

    @_builtins.property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[_builtins.int]:
        """
        The number of low priority nodes in the Batch pool. Defaults to `0`.
        """
        return pulumi.get(self, "target_low_priority_nodes")


@pulumi.output_type
class PoolIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Batch Account. Only possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Batch Account. Only possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PoolMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlobFileSystem":
            suggest = "azure_blob_file_system"
        elif key == "azureFileShares":
            suggest = "azure_file_shares"
        elif key == "cifsMounts":
            suggest = "cifs_mounts"
        elif key == "nfsMounts":
            suggest = "nfs_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_blob_file_system: Optional['outputs.PoolMountAzureBlobFileSystem'] = None,
                 azure_file_shares: Optional[Sequence['outputs.PoolMountAzureFileShare']] = None,
                 cifs_mounts: Optional[Sequence['outputs.PoolMountCifsMount']] = None,
                 nfs_mounts: Optional[Sequence['outputs.PoolMountNfsMount']] = None):
        """
        :param 'PoolMountAzureBlobFileSystemArgs' azure_blob_file_system: A `azure_blob_file_system` block defined as below.
        :param Sequence['PoolMountAzureFileShareArgs'] azure_file_shares: A `azure_file_share` block defined as below.
        :param Sequence['PoolMountCifsMountArgs'] cifs_mounts: A `cifs_mount` block defined as below.
        :param Sequence['PoolMountNfsMountArgs'] nfs_mounts: A `nfs_mount` block defined as below.
        """
        if azure_blob_file_system is not None:
            pulumi.set(__self__, "azure_blob_file_system", azure_blob_file_system)
        if azure_file_shares is not None:
            pulumi.set(__self__, "azure_file_shares", azure_file_shares)
        if cifs_mounts is not None:
            pulumi.set(__self__, "cifs_mounts", cifs_mounts)
        if nfs_mounts is not None:
            pulumi.set(__self__, "nfs_mounts", nfs_mounts)

    @_builtins.property
    @pulumi.getter(name="azureBlobFileSystem")
    def azure_blob_file_system(self) -> Optional['outputs.PoolMountAzureBlobFileSystem']:
        """
        A `azure_blob_file_system` block defined as below.
        """
        return pulumi.get(self, "azure_blob_file_system")

    @_builtins.property
    @pulumi.getter(name="azureFileShares")
    def azure_file_shares(self) -> Optional[Sequence['outputs.PoolMountAzureFileShare']]:
        """
        A `azure_file_share` block defined as below.
        """
        return pulumi.get(self, "azure_file_shares")

    @_builtins.property
    @pulumi.getter(name="cifsMounts")
    def cifs_mounts(self) -> Optional[Sequence['outputs.PoolMountCifsMount']]:
        """
        A `cifs_mount` block defined as below.
        """
        return pulumi.get(self, "cifs_mounts")

    @_builtins.property
    @pulumi.getter(name="nfsMounts")
    def nfs_mounts(self) -> Optional[Sequence['outputs.PoolMountNfsMount']]:
        """
        A `nfs_mount` block defined as below.
        """
        return pulumi.get(self, "nfs_mounts")


@pulumi.output_type
class PoolMountAzureBlobFileSystem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "accountKey":
            suggest = "account_key"
        elif key == "blobfuseOptions":
            suggest = "blobfuse_options"
        elif key == "identityId":
            suggest = "identity_id"
        elif key == "sasKey":
            suggest = "sas_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolMountAzureBlobFileSystem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolMountAzureBlobFileSystem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolMountAzureBlobFileSystem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: _builtins.str,
                 container_name: _builtins.str,
                 relative_mount_path: _builtins.str,
                 account_key: Optional[_builtins.str] = None,
                 blobfuse_options: Optional[_builtins.str] = None,
                 identity_id: Optional[_builtins.str] = None,
                 sas_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_name: The Azure Storage Account name.
        :param _builtins.str container_name: The Azure Blob Storage Container name.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str account_key: The Azure Storage Account key. This property is mutually exclusive with both `sas_key` and `identity_id`; exactly one must be specified.
        :param _builtins.str blobfuse_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        :param _builtins.str identity_id: The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        :param _builtins.str sas_key: The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if blobfuse_options is not None:
            pulumi.set(__self__, "blobfuse_options", blobfuse_options)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if sas_key is not None:
            pulumi.set(__self__, "sas_key", sas_key)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The Azure Storage Account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> _builtins.str:
        """
        The Azure Blob Storage Container name.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[_builtins.str]:
        """
        The Azure Storage Account key. This property is mutually exclusive with both `sas_key` and `identity_id`; exactly one must be specified.
        """
        return pulumi.get(self, "account_key")

    @_builtins.property
    @pulumi.getter(name="blobfuseOptions")
    def blobfuse_options(self) -> Optional[_builtins.str]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "blobfuse_options")

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[_builtins.str]:
        """
        The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> Optional[_builtins.str]:
        """
        The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
        return pulumi.get(self, "sas_key")


@pulumi.output_type
class PoolMountAzureFileShare(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountKey":
            suggest = "account_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "azureFileUrl":
            suggest = "azure_file_url"
        elif key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolMountAzureFileShare. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolMountAzureFileShare.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolMountAzureFileShare.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_key: _builtins.str,
                 account_name: _builtins.str,
                 azure_file_url: _builtins.str,
                 relative_mount_path: _builtins.str,
                 mount_options: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_key: The Azure Storage Account key.
        :param _builtins.str account_name: The Azure Storage Account name.
        :param _builtins.str azure_file_url: The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "azure_file_url", azure_file_url)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @_builtins.property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> _builtins.str:
        """
        The Azure Storage Account key.
        """
        return pulumi.get(self, "account_key")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The Azure Storage Account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="azureFileUrl")
    def azure_file_url(self) -> _builtins.str:
        """
        The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        """
        return pulumi.get(self, "azure_file_url")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[_builtins.str]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class PoolMountCifsMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "userName":
            suggest = "user_name"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolMountCifsMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolMountCifsMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolMountCifsMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: _builtins.str,
                 relative_mount_path: _builtins.str,
                 source: _builtins.str,
                 user_name: _builtins.str,
                 mount_options: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The password to use for authentication against the CIFS file system.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str source: The URI of the file system to mount.
        :param _builtins.str user_name: The user to use for authentication against the CIFS file system.
        :param _builtins.str mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "user_name", user_name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The URI of the file system to mount.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The user to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[_builtins.str]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class PoolMountNfsMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relativeMountPath":
            suggest = "relative_mount_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolMountNfsMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolMountNfsMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolMountNfsMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relative_mount_path: _builtins.str,
                 source: _builtins.str,
                 mount_options: Optional[_builtins.str] = None):
        """
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str source: The URI of the file system to mount.
        :param _builtins.str mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The URI of the file system to mount.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[_builtins.str]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class PoolNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratedNetworkingEnabled":
            suggest = "accelerated_networking_enabled"
        elif key == "dynamicVnetAssignmentScope":
            suggest = "dynamic_vnet_assignment_scope"
        elif key == "endpointConfigurations":
            suggest = "endpoint_configurations"
        elif key == "publicAddressProvisioningType":
            suggest = "public_address_provisioning_type"
        elif key == "publicIps":
            suggest = "public_ips"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerated_networking_enabled: Optional[_builtins.bool] = None,
                 dynamic_vnet_assignment_scope: Optional[_builtins.str] = None,
                 endpoint_configurations: Optional[Sequence['outputs.PoolNetworkConfigurationEndpointConfiguration']] = None,
                 public_address_provisioning_type: Optional[_builtins.str] = None,
                 public_ips: Optional[Sequence[_builtins.str]] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool accelerated_networking_enabled: Whether to enable accelerated networking. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param _builtins.str dynamic_vnet_assignment_scope: The scope of dynamic vnet assignment. Allowed values: `none`, `job`. Changing this forces a new resource to be created. Defaults to `none`.
        :param Sequence['PoolNetworkConfigurationEndpointConfigurationArgs'] endpoint_configurations: A list of `endpoint_configuration` blocks that can be used to address specific ports on an individual compute node externally as defined below. Set as documented in the inbound_nat_pools block below. Changing this forces a new resource to be created.
        :param _builtins.str public_address_provisioning_type: Type of public IP address provisioning. Supported values are `BatchManaged`, `UserManaged` and `NoPublicIPAddresses`.
        :param Sequence[_builtins.str] public_ips: A list of public IP ids that will be allocated to nodes. Changing this forces a new resource to be created.
        :param _builtins.str subnet_id: The ARM resource identifier of the virtual network subnet which the compute nodes of the pool will join. Changing this forces a new resource to be created.
        """
        if accelerated_networking_enabled is not None:
            pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        if dynamic_vnet_assignment_scope is not None:
            pulumi.set(__self__, "dynamic_vnet_assignment_scope", dynamic_vnet_assignment_scope)
        if endpoint_configurations is not None:
            pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        if public_address_provisioning_type is not None:
            pulumi.set(__self__, "public_address_provisioning_type", public_address_provisioning_type)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable accelerated networking. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @_builtins.property
    @pulumi.getter(name="dynamicVnetAssignmentScope")
    def dynamic_vnet_assignment_scope(self) -> Optional[_builtins.str]:
        """
        The scope of dynamic vnet assignment. Allowed values: `none`, `job`. Changing this forces a new resource to be created. Defaults to `none`.
        """
        return pulumi.get(self, "dynamic_vnet_assignment_scope")

    @_builtins.property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Optional[Sequence['outputs.PoolNetworkConfigurationEndpointConfiguration']]:
        """
        A list of `endpoint_configuration` blocks that can be used to address specific ports on an individual compute node externally as defined below. Set as documented in the inbound_nat_pools block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "endpoint_configurations")

    @_builtins.property
    @pulumi.getter(name="publicAddressProvisioningType")
    def public_address_provisioning_type(self) -> Optional[_builtins.str]:
        """
        Type of public IP address provisioning. Supported values are `BatchManaged`, `UserManaged` and `NoPublicIPAddresses`.
        """
        return pulumi.get(self, "public_address_provisioning_type")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of public IP ids that will be allocated to nodes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The ARM resource identifier of the virtual network subnet which the compute nodes of the pool will join. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class PoolNetworkConfigurationEndpointConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRange":
            suggest = "frontend_port_range"
        elif key == "networkSecurityGroupRules":
            suggest = "network_security_group_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolNetworkConfigurationEndpointConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolNetworkConfigurationEndpointConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolNetworkConfigurationEndpointConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: _builtins.int,
                 frontend_port_range: _builtins.str,
                 name: _builtins.str,
                 protocol: _builtins.str,
                 network_security_group_rules: Optional[Sequence['outputs.PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule']] = None):
        """
        :param _builtins.int backend_port: The port number on the compute node. Acceptable values are between `1` and `65535` except for `29876`, `29877` as these are reserved. Changing this forces a new resource to be created.
        :param _builtins.str frontend_port_range: The range of external ports that will be used to provide inbound access to the backendPort on individual compute nodes in the format of `1000-1100`. Acceptable values range between `1` and `65534` except ports from `50000` to `55000` which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. Values must be a range of at least `100` nodes. Changing this forces a new resource to be created.
        :param _builtins.str name: The name of the endpoint. The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters. Changing this forces a new resource to be created.
        :param _builtins.str protocol: The protocol of the endpoint. Acceptable values are `TCP` and `UDP`. Changing this forces a new resource to be created.
        :param Sequence['PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs'] network_security_group_rules: A list of `network_security_group_rules` blocks as defined below that will be applied to the endpoint. The maximum number of rules that can be specified across all the endpoints on a Batch pool is `25`. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. Set as documented in the network_security_group_rules block below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range", frontend_port_range)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if network_security_group_rules is not None:
            pulumi.set(__self__, "network_security_group_rules", network_security_group_rules)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.int:
        """
        The port number on the compute node. Acceptable values are between `1` and `65535` except for `29876`, `29877` as these are reserved. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter(name="frontendPortRange")
    def frontend_port_range(self) -> _builtins.str:
        """
        The range of external ports that will be used to provide inbound access to the backendPort on individual compute nodes in the format of `1000-1100`. Acceptable values range between `1` and `65534` except ports from `50000` to `55000` which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. Values must be a range of at least `100` nodes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontend_port_range")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the endpoint. The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol of the endpoint. Acceptable values are `TCP` and `UDP`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupRules")
    def network_security_group_rules(self) -> Optional[Sequence['outputs.PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule']]:
        """
        A list of `network_security_group_rules` blocks as defined below that will be applied to the endpoint. The maximum number of rules that can be specified across all the endpoints on a Batch pool is `25`. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. Set as documented in the network_security_group_rules block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_rules")


@pulumi.output_type
class PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "sourcePortRanges":
            suggest = "source_port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: _builtins.str,
                 priority: _builtins.int,
                 source_address_prefix: _builtins.str,
                 source_port_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str access: The action that should be taken for a specified IP address, subnet range or tag. Acceptable values are `Allow` and `Deny`. Changing this forces a new resource to be created.
        :param _builtins.int priority: The priority for this rule. The value must be at least `150`. Changing this forces a new resource to be created.
        :param _builtins.str source_address_prefix: The source address prefix or tag to match for the rule. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] source_port_ranges: The source port ranges to match for the rule. Valid values are `*` (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. `100-200`). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be `*`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @_builtins.property
    @pulumi.getter
    def access(self) -> _builtins.str:
        """
        The action that should be taken for a specified IP address, subnet range or tag. Acceptable values are `Allow` and `Deny`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority for this rule. The value must be at least `150`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> _builtins.str:
        """
        The source address prefix or tag to match for the rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_address_prefix")

    @_builtins.property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        The source port ranges to match for the rule. Valid values are `*` (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. `100-200`). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be `*`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_port_ranges")


@pulumi.output_type
class PoolNodePlacement(dict):
    def __init__(__self__, *,
                 policy: Optional[_builtins.str] = None):
        """
        :param _builtins.str policy: The placement policy for allocating nodes in the pool. Values are: "Regional": All nodes in the pool will be allocated in the same region; "Zonal": Nodes in the pool will be spread across different zones with the best effort balancing. Defaults to `Regional`.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The placement policy for allocating nodes in the pool. Values are: "Regional": All nodes in the pool will be allocated in the same region; "Zonal": Nodes in the pool will be spread across different zones with the best effort balancing. Defaults to `Regional`.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class PoolSecurityProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostEncryptionEnabled":
            suggest = "host_encryption_enabled"
        elif key == "secureBootEnabled":
            suggest = "secure_boot_enabled"
        elif key == "securityType":
            suggest = "security_type"
        elif key == "vtpmEnabled":
            suggest = "vtpm_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolSecurityProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolSecurityProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolSecurityProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_encryption_enabled: Optional[_builtins.bool] = None,
                 secure_boot_enabled: Optional[_builtins.bool] = None,
                 security_type: Optional[_builtins.str] = None,
                 vtpm_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool host_encryption_enabled: Whether to enable host encryption for the Virtual Machine or Virtual Machine Scale Set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        :param _builtins.bool secure_boot_enabled: Whether to enable secure boot for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        :param _builtins.str security_type: The security type of the Virtual Machine. Possible values are `confidentialVM` and `trustedLaunch`. Changing this forces a new resource to be created.
        :param _builtins.bool vtpm_enabled: Whether to enable virtual trusted platform module (vTPM) for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
               
               > **Note:** `security_profile` block can only be specified during creation and does not support updates.
               
               > **Note:** `security_type` must be specified to set UEFI related properties including `secure_boot_enabled` and `vtpm_enabled`.
        """
        if host_encryption_enabled is not None:
            pulumi.set(__self__, "host_encryption_enabled", host_encryption_enabled)
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if vtpm_enabled is not None:
            pulumi.set(__self__, "vtpm_enabled", vtpm_enabled)

    @_builtins.property
    @pulumi.getter(name="hostEncryptionEnabled")
    def host_encryption_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable host encryption for the Virtual Machine or Virtual Machine Scale Set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable secure boot for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @_builtins.property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[_builtins.str]:
        """
        The security type of the Virtual Machine. Possible values are `confidentialVM` and `trustedLaunch`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_type")

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable virtual trusted platform module (vTPM) for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.

        > **Note:** `security_profile` block can only be specified during creation and does not support updates.

        > **Note:** `security_type` must be specified to set UEFI related properties including `secure_boot_enabled` and `vtpm_enabled`.
        """
        return pulumi.get(self, "vtpm_enabled")


@pulumi.output_type
class PoolStartTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandLine":
            suggest = "command_line"
        elif key == "userIdentity":
            suggest = "user_identity"
        elif key == "commonEnvironmentProperties":
            suggest = "common_environment_properties"
        elif key == "resourceFiles":
            suggest = "resource_files"
        elif key == "taskRetryMaximum":
            suggest = "task_retry_maximum"
        elif key == "waitForSuccess":
            suggest = "wait_for_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolStartTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolStartTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolStartTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_line: _builtins.str,
                 user_identity: 'outputs.PoolStartTaskUserIdentity',
                 common_environment_properties: Optional[Mapping[str, _builtins.str]] = None,
                 containers: Optional[Sequence['outputs.PoolStartTaskContainer']] = None,
                 resource_files: Optional[Sequence['outputs.PoolStartTaskResourceFile']] = None,
                 task_retry_maximum: Optional[_builtins.int] = None,
                 wait_for_success: Optional[_builtins.bool] = None):
        """
        :param _builtins.str command_line: The command line executed by the start task.
        :param 'PoolStartTaskUserIdentityArgs' user_identity: A `user_identity` block that describes the user identity under which the start task runs as defined below.
        :param Mapping[str, _builtins.str] common_environment_properties: A map of strings (key,value) that represents the environment variables to set in the start task.
        :param Sequence['PoolStartTaskContainerArgs'] containers: A `container` block is the settings for the container under which the start task runs as defined below. When this is specified, all directories recursively below the `AZ_BATCH_NODE_ROOT_DIR` (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        :param Sequence['PoolStartTaskResourceFileArgs'] resource_files: One or more `resource_file` blocks that describe the files to be downloaded to a compute node as defined below.
        :param _builtins.int task_retry_maximum: The number of retry count. If this is set to `0`, the Batch service does not retry Tasks. If this is set to `-1`, the Batch service retries Batch Tasks without limit.
        :param _builtins.bool wait_for_success: A flag that indicates if the Batch pool should wait for the start task to be completed. Default to `false`.
        """
        pulumi.set(__self__, "command_line", command_line)
        pulumi.set(__self__, "user_identity", user_identity)
        if common_environment_properties is not None:
            pulumi.set(__self__, "common_environment_properties", common_environment_properties)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if resource_files is not None:
            pulumi.set(__self__, "resource_files", resource_files)
        if task_retry_maximum is not None:
            pulumi.set(__self__, "task_retry_maximum", task_retry_maximum)
        if wait_for_success is not None:
            pulumi.set(__self__, "wait_for_success", wait_for_success)

    @_builtins.property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> _builtins.str:
        """
        The command line executed by the start task.
        """
        return pulumi.get(self, "command_line")

    @_builtins.property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> 'outputs.PoolStartTaskUserIdentity':
        """
        A `user_identity` block that describes the user identity under which the start task runs as defined below.
        """
        return pulumi.get(self, "user_identity")

    @_builtins.property
    @pulumi.getter(name="commonEnvironmentProperties")
    def common_environment_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of strings (key,value) that represents the environment variables to set in the start task.
        """
        return pulumi.get(self, "common_environment_properties")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.PoolStartTaskContainer']]:
        """
        A `container` block is the settings for the container under which the start task runs as defined below. When this is specified, all directories recursively below the `AZ_BATCH_NODE_ROOT_DIR` (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="resourceFiles")
    def resource_files(self) -> Optional[Sequence['outputs.PoolStartTaskResourceFile']]:
        """
        One or more `resource_file` blocks that describe the files to be downloaded to a compute node as defined below.
        """
        return pulumi.get(self, "resource_files")

    @_builtins.property
    @pulumi.getter(name="taskRetryMaximum")
    def task_retry_maximum(self) -> Optional[_builtins.int]:
        """
        The number of retry count. If this is set to `0`, the Batch service does not retry Tasks. If this is set to `-1`, the Batch service retries Batch Tasks without limit.
        """
        return pulumi.get(self, "task_retry_maximum")

    @_builtins.property
    @pulumi.getter(name="waitForSuccess")
    def wait_for_success(self) -> Optional[_builtins.bool]:
        """
        A flag that indicates if the Batch pool should wait for the start task to be completed. Default to `false`.
        """
        return pulumi.get(self, "wait_for_success")


@pulumi.output_type
class PoolStartTaskContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "runOptions":
            suggest = "run_options"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolStartTaskContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolStartTaskContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolStartTaskContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_name: _builtins.str,
                 registries: Optional[Sequence['outputs.PoolStartTaskContainerRegistry']] = None,
                 run_options: Optional[_builtins.str] = None,
                 working_directory: Optional[_builtins.str] = None):
        """
        :param _builtins.str image_name: The image to use to create the container in which the task will run. This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        :param Sequence['PoolStartTaskContainerRegistryArgs'] registries: The `container_registries` block defined as below.
        :param _builtins.str run_options: Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        :param _builtins.str working_directory: A flag to indicate where the container task working directory is. Possible values are `TaskWorkingDirectory` and `ContainerImageDefault`.
        """
        pulumi.set(__self__, "image_name", image_name)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if run_options is not None:
            pulumi.set(__self__, "run_options", run_options)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> _builtins.str:
        """
        The image to use to create the container in which the task will run. This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter
    def registries(self) -> Optional[Sequence['outputs.PoolStartTaskContainerRegistry']]:
        """
        The `container_registries` block defined as below.
        """
        return pulumi.get(self, "registries")

    @_builtins.property
    @pulumi.getter(name="runOptions")
    def run_options(self) -> Optional[_builtins.str]:
        """
        Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        """
        return pulumi.get(self, "run_options")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[_builtins.str]:
        """
        A flag to indicate where the container task working directory is. Possible values are `TaskWorkingDirectory` and `ContainerImageDefault`.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class PoolStartTaskContainerRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryServer":
            suggest = "registry_server"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolStartTaskContainerRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolStartTaskContainerRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolStartTaskContainerRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_server: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 user_assigned_identity_id: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str registry_server: The container registry URL. Changing this forces a new resource to be created.
        :param _builtins.str user_assigned_identity_id: The User Assigned Identity to use for Container Registry access.
        """
        pulumi.set(__self__, "registry_server", registry_server)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> _builtins.str:
        """
        The container registry URL. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The User Assigned Identity to use for Container Registry access.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class PoolStartTaskResourceFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoStorageContainerName":
            suggest = "auto_storage_container_name"
        elif key == "blobPrefix":
            suggest = "blob_prefix"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "filePath":
            suggest = "file_path"
        elif key == "httpUrl":
            suggest = "http_url"
        elif key == "storageContainerUrl":
            suggest = "storage_container_url"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolStartTaskResourceFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolStartTaskResourceFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolStartTaskResourceFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_storage_container_name: Optional[_builtins.str] = None,
                 blob_prefix: Optional[_builtins.str] = None,
                 file_mode: Optional[_builtins.str] = None,
                 file_path: Optional[_builtins.str] = None,
                 http_url: Optional[_builtins.str] = None,
                 storage_container_url: Optional[_builtins.str] = None,
                 user_assigned_identity_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str auto_storage_container_name: The storage container name in the auto storage account.
        :param _builtins.str blob_prefix: The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs whose names begin with the specified prefix will be downloaded. The property is valid only when `auto_storage_container_name` or `storage_container_url` is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        :param _builtins.str file_mode: The file permission mode represented as a string in octal format (e.g. `"0644"`). This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a `resource_file` which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        :param _builtins.str file_path: The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified, `file_path` is optional and is the directory to download the files to. In the case where `file_path` is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        :param _builtins.str http_url: The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param _builtins.str storage_container_url: The URL of the blob container within Azure Blob Storage. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param _builtins.str user_assigned_identity_id: An identity reference from pool's user assigned managed identity list.
               
               > **Note:** Exactly one of `auto_storage_container_name`, `storage_container_url` and `auto_user` must be specified.
        """
        if auto_storage_container_name is not None:
            pulumi.set(__self__, "auto_storage_container_name", auto_storage_container_name)
        if blob_prefix is not None:
            pulumi.set(__self__, "blob_prefix", blob_prefix)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if http_url is not None:
            pulumi.set(__self__, "http_url", http_url)
        if storage_container_url is not None:
            pulumi.set(__self__, "storage_container_url", storage_container_url)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="autoStorageContainerName")
    def auto_storage_container_name(self) -> Optional[_builtins.str]:
        """
        The storage container name in the auto storage account.
        """
        return pulumi.get(self, "auto_storage_container_name")

    @_builtins.property
    @pulumi.getter(name="blobPrefix")
    def blob_prefix(self) -> Optional[_builtins.str]:
        """
        The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs whose names begin with the specified prefix will be downloaded. The property is valid only when `auto_storage_container_name` or `storage_container_url` is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        """
        return pulumi.get(self, "blob_prefix")

    @_builtins.property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[_builtins.str]:
        """
        The file permission mode represented as a string in octal format (e.g. `"0644"`). This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a `resource_file` which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        """
        return pulumi.get(self, "file_mode")

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[_builtins.str]:
        """
        The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified, `file_path` is optional and is the directory to download the files to. In the case where `file_path` is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        """
        return pulumi.get(self, "file_path")

    @_builtins.property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[_builtins.str]:
        """
        The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "http_url")

    @_builtins.property
    @pulumi.getter(name="storageContainerUrl")
    def storage_container_url(self) -> Optional[_builtins.str]:
        """
        The URL of the blob container within Azure Blob Storage. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "storage_container_url")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        An identity reference from pool's user assigned managed identity list.

        > **Note:** Exactly one of `auto_storage_container_name`, `storage_container_url` and `auto_user` must be specified.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class PoolStartTaskUserIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUser":
            suggest = "auto_user"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolStartTaskUserIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolStartTaskUserIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolStartTaskUserIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_user: Optional['outputs.PoolStartTaskUserIdentityAutoUser'] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param 'PoolStartTaskUserIdentityAutoUserArgs' auto_user: A `auto_user` block that describes the user identity under which the start task runs as defined below.
               
               > **Note:** `user_name` and `auto_user` blocks cannot be used both at the same time, but you need to define one or the other.
        :param _builtins.str user_name: The username to be used by the Batch pool start task.
        """
        if auto_user is not None:
            pulumi.set(__self__, "auto_user", auto_user)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="autoUser")
    def auto_user(self) -> Optional['outputs.PoolStartTaskUserIdentityAutoUser']:
        """
        A `auto_user` block that describes the user identity under which the start task runs as defined below.

        > **Note:** `user_name` and `auto_user` blocks cannot be used both at the same time, but you need to define one or the other.
        """
        return pulumi.get(self, "auto_user")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        The username to be used by the Batch pool start task.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class PoolStartTaskUserIdentityAutoUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elevationLevel":
            suggest = "elevation_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolStartTaskUserIdentityAutoUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolStartTaskUserIdentityAutoUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolStartTaskUserIdentityAutoUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elevation_level: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None):
        """
        :param _builtins.str elevation_level: The elevation level of the user identity under which the start task runs. Possible values are `Admin` or `NonAdmin`. Defaults to `NonAdmin`.
        :param _builtins.str scope: The scope of the user identity under which the start task runs. Possible values are `Task` or `Pool`. Defaults to `Task`.
        """
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[_builtins.str]:
        """
        The elevation level of the user identity under which the start task runs. Possible values are `Admin` or `NonAdmin`. Defaults to `NonAdmin`.
        """
        return pulumi.get(self, "elevation_level")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The scope of the user identity under which the start task runs. Possible values are `Task` or `Pool`. Defaults to `Task`.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class PoolStorageImageReference(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 offer: Optional[_builtins.str] = None,
                 publisher: Optional[_builtins.str] = None,
                 sku: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Specifies the ID of the Custom Image which the virtual machines should be created from. Changing this forces a new resource to be created. See [official documentation](https://docs.microsoft.com/azure/batch/batch-custom-images) for more details.
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.
               
               To provision a Custom Image, the following fields are applicable:
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the Custom Image which the virtual machines should be created from. Changing this forces a new resource to be created. See [official documentation](https://docs.microsoft.com/azure/batch/batch-custom-images) for more details.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> Optional[_builtins.str]:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[_builtins.str]:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[_builtins.str]:
        """
        Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.

        To provision a Custom Image, the following fields are applicable:
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PoolTaskSchedulingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeFillType":
            suggest = "node_fill_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolTaskSchedulingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolTaskSchedulingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolTaskSchedulingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_fill_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str node_fill_type: Supported values are "Pack" and "Spread". "Pack" means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. "Spread" means that tasks should be assigned evenly across all nodes in the pool.
        """
        if node_fill_type is not None:
            pulumi.set(__self__, "node_fill_type", node_fill_type)

    @_builtins.property
    @pulumi.getter(name="nodeFillType")
    def node_fill_type(self) -> Optional[_builtins.str]:
        """
        Supported values are "Pack" and "Spread". "Pack" means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. "Spread" means that tasks should be assigned evenly across all nodes in the pool.
        """
        return pulumi.get(self, "node_fill_type")


@pulumi.output_type
class PoolUserAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elevationLevel":
            suggest = "elevation_level"
        elif key == "linuxUserConfigurations":
            suggest = "linux_user_configurations"
        elif key == "windowsUserConfigurations":
            suggest = "windows_user_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolUserAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolUserAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolUserAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elevation_level: _builtins.str,
                 name: _builtins.str,
                 password: _builtins.str,
                 linux_user_configurations: Optional[Sequence['outputs.PoolUserAccountLinuxUserConfiguration']] = None,
                 windows_user_configurations: Optional[Sequence['outputs.PoolUserAccountWindowsUserConfiguration']] = None):
        """
        :param _builtins.str elevation_level: The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param _builtins.str name: The name of the user account.
        :param _builtins.str password: The password for the user account.
        :param Sequence['PoolUserAccountLinuxUserConfigurationArgs'] linux_user_configurations: The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        :param Sequence['PoolUserAccountWindowsUserConfigurationArgs'] windows_user_configurations: The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        pulumi.set(__self__, "elevation_level", elevation_level)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        if linux_user_configurations is not None:
            pulumi.set(__self__, "linux_user_configurations", linux_user_configurations)
        if windows_user_configurations is not None:
            pulumi.set(__self__, "windows_user_configurations", windows_user_configurations)

    @_builtins.property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> _builtins.str:
        """
        The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the user account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the user account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="linuxUserConfigurations")
    def linux_user_configurations(self) -> Optional[Sequence['outputs.PoolUserAccountLinuxUserConfiguration']]:
        """
        The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        return pulumi.get(self, "linux_user_configurations")

    @_builtins.property
    @pulumi.getter(name="windowsUserConfigurations")
    def windows_user_configurations(self) -> Optional[Sequence['outputs.PoolUserAccountWindowsUserConfiguration']]:
        """
        The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        return pulumi.get(self, "windows_user_configurations")


@pulumi.output_type
class PoolUserAccountLinuxUserConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshPrivateKey":
            suggest = "ssh_private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolUserAccountLinuxUserConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolUserAccountLinuxUserConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolUserAccountLinuxUserConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: Optional[_builtins.int] = None,
                 ssh_private_key: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.int] = None):
        """
        :param _builtins.int gid: The user ID of the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        :param _builtins.str ssh_private_key: The SSH private key for the user account. The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        :param _builtins.int uid: The group ID for the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> Optional[_builtins.int]:
        """
        The user ID of the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[_builtins.str]:
        """
        The SSH private key for the user account. The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        """
        return pulumi.get(self, "ssh_private_key")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.int]:
        """
        The group ID for the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class PoolUserAccountWindowsUserConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginMode":
            suggest = "login_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolUserAccountWindowsUserConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolUserAccountWindowsUserConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolUserAccountWindowsUserConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_mode: _builtins.str):
        """
        :param _builtins.str login_mode: Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode. Values supported are "Batch" and "Interactive".
        """
        pulumi.set(__self__, "login_mode", login_mode)

    @_builtins.property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> _builtins.str:
        """
        Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode. Values supported are "Batch" and "Interactive".
        """
        return pulumi.get(self, "login_mode")


@pulumi.output_type
class PoolWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_automatic_updates: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_automatic_updates: Whether automatic updates are enabled on the virtual machine. Defaults to `true`.
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[_builtins.bool]:
        """
        Whether automatic updates are enabled on the virtual machine. Defaults to `true`.
        """
        return pulumi.get(self, "enable_automatic_updates")


@pulumi.output_type
class GetAccountEncryptionResult(dict):
    def __init__(__self__, *,
                 key_vault_key_id: _builtins.str):
        """
        :param _builtins.str key_vault_key_id: The full URL path of the Key Vault Key used to encrypt data for this Batch account.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The full URL path of the Key Vault Key used to encrypt data for this Batch account.
        """
        return pulumi.get(self, "key_vault_key_id")


@pulumi.output_type
class GetAccountKeyVaultReferenceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str id: The Azure identifier of the Azure KeyVault reference.
        :param _builtins.str url: The HTTPS URL of the Azure KeyVault reference.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Azure identifier of the Azure KeyVault reference.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The HTTPS URL of the Azure KeyVault reference.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetPoolAutoScaleResult(dict):
    def __init__(__self__, *,
                 evaluation_interval: _builtins.str,
                 formula: _builtins.str):
        """
        :param _builtins.str evaluation_interval: The interval to wait before evaluating if the pool needs to be scaled.
        :param _builtins.str formula: The autoscale formula that needs to be used for scaling the Batch pool.
        """
        pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        pulumi.set(__self__, "formula", formula)

    @_builtins.property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> _builtins.str:
        """
        The interval to wait before evaluating if the pool needs to be scaled.
        """
        return pulumi.get(self, "evaluation_interval")

    @_builtins.property
    @pulumi.getter
    def formula(self) -> _builtins.str:
        """
        The autoscale formula that needs to be used for scaling the Batch pool.
        """
        return pulumi.get(self, "formula")


@pulumi.output_type
class GetPoolCertificateResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 store_location: _builtins.str,
                 store_name: _builtins.str,
                 visibilities: Sequence[_builtins.str]):
        """
        :param _builtins.str id: The fully qualified ID of the certificate installed on the pool.
        :param _builtins.str store_location: The location of the certificate store on the compute node into which the certificate is installed, either `CurrentUser` or `LocalMachine`.
        :param _builtins.str store_name: The name of the certificate store on the compute node into which the certificate is installed.
        :param Sequence[_builtins.str] visibilities: Which user accounts on the compute node have access to the private data of the certificate.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "store_location", store_location)
        pulumi.set(__self__, "store_name", store_name)
        pulumi.set(__self__, "visibilities", visibilities)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The fully qualified ID of the certificate installed on the pool.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="storeLocation")
    def store_location(self) -> _builtins.str:
        """
        The location of the certificate store on the compute node into which the certificate is installed, either `CurrentUser` or `LocalMachine`.
        """
        return pulumi.get(self, "store_location")

    @_builtins.property
    @pulumi.getter(name="storeName")
    def store_name(self) -> _builtins.str:
        """
        The name of the certificate store on the compute node into which the certificate is installed.
        """
        return pulumi.get(self, "store_name")

    @_builtins.property
    @pulumi.getter
    def visibilities(self) -> Sequence[_builtins.str]:
        """
        Which user accounts on the compute node have access to the private data of the certificate.
        """
        return pulumi.get(self, "visibilities")


@pulumi.output_type
class GetPoolContainerConfigurationResult(dict):
    def __init__(__self__, *,
                 container_image_names: Sequence[_builtins.str],
                 container_registries: Sequence['outputs.GetPoolContainerConfigurationContainerRegistryResult'],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] container_image_names: A list of container image names to use, as would be specified by `docker pull`.
        :param Sequence['GetPoolContainerConfigurationContainerRegistryArgs'] container_registries: Additional container registries from which container images can be pulled by the pool's VMs.
        :param _builtins.str type: The type of container configuration.
        """
        pulumi.set(__self__, "container_image_names", container_image_names)
        pulumi.set(__self__, "container_registries", container_registries)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="containerImageNames")
    def container_image_names(self) -> Sequence[_builtins.str]:
        """
        A list of container image names to use, as would be specified by `docker pull`.
        """
        return pulumi.get(self, "container_image_names")

    @_builtins.property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Sequence['outputs.GetPoolContainerConfigurationContainerRegistryResult']:
        """
        Additional container registries from which container images can be pulled by the pool's VMs.
        """
        return pulumi.get(self, "container_registries")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of container configuration.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPoolContainerConfigurationContainerRegistryResult(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 registry_server: _builtins.str,
                 user_assigned_identity_id: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str password: The password for the user account.
        :param _builtins.str registry_server: The container registry URL. The default is "docker.io".
        :param _builtins.str user_assigned_identity_id: The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password.
        :param _builtins.str user_name: The user to use for authentication against the CIFS file system.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "registry_server", registry_server)
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the user account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> _builtins.str:
        """
        The container registry URL. The default is "docker.io".
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> _builtins.str:
        """
        The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The user to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetPoolDataDiskResult(dict):
    def __init__(__self__, *,
                 caching: _builtins.str,
                 disk_size_gb: _builtins.int,
                 lun: _builtins.int,
                 storage_account_type: _builtins.str):
        """
        :param _builtins.str caching: The caching mode of data disks.
        :param _builtins.int disk_size_gb: The initial disk size in GB when creating new data disk.
        :param _builtins.int lun: The lun is used to uniquely identify each data disk.
        :param _builtins.str storage_account_type: The storage account type to be used for the data disk.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "storage_account_type", storage_account_type)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The caching mode of data disks.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        The initial disk size in GB when creating new data disk.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        The lun is used to uniquely identify each data disk.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The storage account type to be used for the data disk.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class GetPoolDiskEncryptionResult(dict):
    def __init__(__self__, *,
                 disk_encryption_target: _builtins.str):
        """
        :param _builtins.str disk_encryption_target: On Linux pool, only `TemporaryDisk` is supported; on Windows pool, `OsDisk` and `TemporaryDisk` must be specified.
        """
        pulumi.set(__self__, "disk_encryption_target", disk_encryption_target)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionTarget")
    def disk_encryption_target(self) -> _builtins.str:
        """
        On Linux pool, only `TemporaryDisk` is supported; on Windows pool, `OsDisk` and `TemporaryDisk` must be specified.
        """
        return pulumi.get(self, "disk_encryption_target")


@pulumi.output_type
class GetPoolExtensionResult(dict):
    def __init__(__self__, *,
                 auto_upgrade_minor_version: _builtins.bool,
                 name: _builtins.str,
                 protected_settings: _builtins.str,
                 provision_after_extensions: Sequence[_builtins.str],
                 publisher: _builtins.str,
                 settings_json: _builtins.str,
                 type: _builtins.str,
                 type_handler_version: _builtins.str):
        """
        :param _builtins.bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param _builtins.str name: The name of the Batch pool.
        :param _builtins.str protected_settings: The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        :param Sequence[_builtins.str] provision_after_extensions: The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        :param _builtins.str publisher: The name of the extension handler publisher.The name of the extension handler publisher.
        :param _builtins.str settings_json: JSON formatted public settings for the extension.
        :param _builtins.str type: The type of container configuration.
        :param _builtins.str type_handler_version: The version of script handler.
        """
        pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protected_settings", protected_settings)
        pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "settings_json", settings_json)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> _builtins.bool:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Batch pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> _builtins.str:
        """
        The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Sequence[_builtins.str]:
        """
        The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The name of the extension handler publisher.The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter(name="settingsJson")
    def settings_json(self) -> _builtins.str:
        """
        JSON formatted public settings for the extension.
        """
        return pulumi.get(self, "settings_json")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of container configuration.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> _builtins.str:
        """
        The version of script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class GetPoolFixedScaleResult(dict):
    def __init__(__self__, *,
                 resize_timeout: _builtins.str,
                 target_dedicated_nodes: _builtins.int,
                 target_low_priority_nodes: _builtins.int):
        """
        :param _builtins.str resize_timeout: The timeout for resize operations.
        :param _builtins.int target_dedicated_nodes: The number of nodes in the Batch pool.
        :param _builtins.int target_low_priority_nodes: The number of low priority nodes in the Batch pool.
        """
        pulumi.set(__self__, "resize_timeout", resize_timeout)
        pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @_builtins.property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> _builtins.str:
        """
        The timeout for resize operations.
        """
        return pulumi.get(self, "resize_timeout")

    @_builtins.property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> _builtins.int:
        """
        The number of nodes in the Batch pool.
        """
        return pulumi.get(self, "target_dedicated_nodes")

    @_builtins.property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> _builtins.int:
        """
        The number of low priority nodes in the Batch pool.
        """
        return pulumi.get(self, "target_low_priority_nodes")


@pulumi.output_type
class GetPoolMountResult(dict):
    def __init__(__self__, *,
                 cifs_mounts: Sequence['outputs.GetPoolMountCifsMountResult'],
                 nfs_mounts: Sequence['outputs.GetPoolMountNfsMountResult'],
                 azure_blob_file_systems: Optional[Sequence['outputs.GetPoolMountAzureBlobFileSystemResult']] = None,
                 azure_file_shares: Optional[Sequence['outputs.GetPoolMountAzureFileShareResult']] = None):
        """
        :param Sequence['GetPoolMountCifsMountArgs'] cifs_mounts: A `cifs_mount` block defined as below.
        :param Sequence['GetPoolMountNfsMountArgs'] nfs_mounts: A `nfs_mount` block defined as below.
        :param Sequence['GetPoolMountAzureBlobFileSystemArgs'] azure_blob_file_systems: A `azure_blob_file_system` block defined as below.
        :param Sequence['GetPoolMountAzureFileShareArgs'] azure_file_shares: A `azure_file_share` block defined as below.
        """
        pulumi.set(__self__, "cifs_mounts", cifs_mounts)
        pulumi.set(__self__, "nfs_mounts", nfs_mounts)
        if azure_blob_file_systems is not None:
            pulumi.set(__self__, "azure_blob_file_systems", azure_blob_file_systems)
        if azure_file_shares is not None:
            pulumi.set(__self__, "azure_file_shares", azure_file_shares)

    @_builtins.property
    @pulumi.getter(name="cifsMounts")
    def cifs_mounts(self) -> Sequence['outputs.GetPoolMountCifsMountResult']:
        """
        A `cifs_mount` block defined as below.
        """
        return pulumi.get(self, "cifs_mounts")

    @_builtins.property
    @pulumi.getter(name="nfsMounts")
    def nfs_mounts(self) -> Sequence['outputs.GetPoolMountNfsMountResult']:
        """
        A `nfs_mount` block defined as below.
        """
        return pulumi.get(self, "nfs_mounts")

    @_builtins.property
    @pulumi.getter(name="azureBlobFileSystems")
    def azure_blob_file_systems(self) -> Optional[Sequence['outputs.GetPoolMountAzureBlobFileSystemResult']]:
        """
        A `azure_blob_file_system` block defined as below.
        """
        return pulumi.get(self, "azure_blob_file_systems")

    @_builtins.property
    @pulumi.getter(name="azureFileShares")
    def azure_file_shares(self) -> Optional[Sequence['outputs.GetPoolMountAzureFileShareResult']]:
        """
        A `azure_file_share` block defined as below.
        """
        return pulumi.get(self, "azure_file_shares")


@pulumi.output_type
class GetPoolMountAzureBlobFileSystemResult(dict):
    def __init__(__self__, *,
                 account_key: _builtins.str,
                 account_name: _builtins.str,
                 blobfuse_options: _builtins.str,
                 container_name: _builtins.str,
                 identity_id: _builtins.str,
                 relative_mount_path: _builtins.str,
                 sas_key: _builtins.str):
        """
        :param _builtins.str account_key: The Azure Storage Account key.
        :param _builtins.str account_name: The Batch Account name associated with the Batch pool.
        :param _builtins.str blobfuse_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        :param _builtins.str container_name: The Azure Blob Storage Container name.
        :param _builtins.str identity_id: The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str sas_key: The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "blobfuse_options", blobfuse_options)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "identity_id", identity_id)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "sas_key", sas_key)

    @_builtins.property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> _builtins.str:
        """
        The Azure Storage Account key.
        """
        return pulumi.get(self, "account_key")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The Batch Account name associated with the Batch pool.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="blobfuseOptions")
    def blobfuse_options(self) -> _builtins.str:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "blobfuse_options")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> _builtins.str:
        """
        The Azure Blob Storage Container name.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> _builtins.str:
        """
        The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> _builtins.str:
        """
        The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
        return pulumi.get(self, "sas_key")


@pulumi.output_type
class GetPoolMountAzureFileShareResult(dict):
    def __init__(__self__, *,
                 account_key: _builtins.str,
                 account_name: _builtins.str,
                 azure_file_url: _builtins.str,
                 mount_options: _builtins.str,
                 relative_mount_path: _builtins.str):
        """
        :param _builtins.str account_key: The Azure Storage Account key.
        :param _builtins.str account_name: The Batch Account name associated with the Batch pool.
        :param _builtins.str azure_file_url: The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        :param _builtins.str mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "azure_file_url", azure_file_url)
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)

    @_builtins.property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> _builtins.str:
        """
        The Azure Storage Account key.
        """
        return pulumi.get(self, "account_key")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The Batch Account name associated with the Batch pool.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="azureFileUrl")
    def azure_file_url(self) -> _builtins.str:
        """
        The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        """
        return pulumi.get(self, "azure_file_url")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> _builtins.str:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")


@pulumi.output_type
class GetPoolMountCifsMountResult(dict):
    def __init__(__self__, *,
                 mount_options: _builtins.str,
                 password: _builtins.str,
                 relative_mount_path: _builtins.str,
                 source: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        :param _builtins.str password: The password for the user account.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str source: The URI of the file system to mount.
        :param _builtins.str user_name: The user to use for authentication against the CIFS file system.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> _builtins.str:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the user account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The URI of the file system to mount.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The user to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetPoolMountNfsMountResult(dict):
    def __init__(__self__, *,
                 mount_options: _builtins.str,
                 relative_mount_path: _builtins.str,
                 source: _builtins.str):
        """
        :param _builtins.str mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        :param _builtins.str relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param _builtins.str source: The URI of the file system to mount.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> _builtins.str:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> _builtins.str:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The URI of the file system to mount.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetPoolNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 accelerated_networking_enabled: _builtins.bool,
                 dynamic_vnet_assignment_scope: _builtins.str,
                 endpoint_configurations: Sequence['outputs.GetPoolNetworkConfigurationEndpointConfigurationResult'],
                 public_address_provisioning_type: _builtins.str,
                 public_ips: Sequence[_builtins.str],
                 subnet_id: _builtins.str):
        """
        :param _builtins.str dynamic_vnet_assignment_scope: The scope of dynamic vnet assignment.
        :param Sequence['GetPoolNetworkConfigurationEndpointConfigurationArgs'] endpoint_configurations: The inbound NAT pools that are used to address specific ports on the individual compute node externally.
        :param _builtins.str public_address_provisioning_type: Type of public IP address provisioning.
        :param Sequence[_builtins.str] public_ips: A list of public IP ids that will be allocated to nodes.
        :param _builtins.str subnet_id: The ARM resource identifier of the virtual network subnet which the compute nodes of the pool are joined too.
        """
        pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        pulumi.set(__self__, "dynamic_vnet_assignment_scope", dynamic_vnet_assignment_scope)
        pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        pulumi.set(__self__, "public_address_provisioning_type", public_address_provisioning_type)
        pulumi.set(__self__, "public_ips", public_ips)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "accelerated_networking_enabled")

    @_builtins.property
    @pulumi.getter(name="dynamicVnetAssignmentScope")
    def dynamic_vnet_assignment_scope(self) -> _builtins.str:
        """
        The scope of dynamic vnet assignment.
        """
        return pulumi.get(self, "dynamic_vnet_assignment_scope")

    @_builtins.property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Sequence['outputs.GetPoolNetworkConfigurationEndpointConfigurationResult']:
        """
        The inbound NAT pools that are used to address specific ports on the individual compute node externally.
        """
        return pulumi.get(self, "endpoint_configurations")

    @_builtins.property
    @pulumi.getter(name="publicAddressProvisioningType")
    def public_address_provisioning_type(self) -> _builtins.str:
        """
        Type of public IP address provisioning.
        """
        return pulumi.get(self, "public_address_provisioning_type")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence[_builtins.str]:
        """
        A list of public IP ids that will be allocated to nodes.
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ARM resource identifier of the virtual network subnet which the compute nodes of the pool are joined too.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetPoolNetworkConfigurationEndpointConfigurationResult(dict):
    def __init__(__self__, *,
                 backend_port: _builtins.int,
                 frontend_port_range: _builtins.str,
                 name: _builtins.str,
                 network_security_group_rules: Sequence['outputs.GetPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleResult'],
                 protocol: _builtins.str):
        """
        :param _builtins.int backend_port: The port number on the compute node.
        :param _builtins.str frontend_port_range: The range of external ports that are used to provide inbound access to the backendPort on the individual compute nodes in the format of `1000-1100`.
        :param _builtins.str name: The name of the Batch pool.
        :param Sequence['GetPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs'] network_security_group_rules: The list of network security group rules that are applied to the endpoint.
        :param _builtins.str protocol: The protocol of the endpoint.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range", frontend_port_range)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_security_group_rules", network_security_group_rules)
        pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.int:
        """
        The port number on the compute node.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter(name="frontendPortRange")
    def frontend_port_range(self) -> _builtins.str:
        """
        The range of external ports that are used to provide inbound access to the backendPort on the individual compute nodes in the format of `1000-1100`.
        """
        return pulumi.get(self, "frontend_port_range")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Batch pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupRules")
    def network_security_group_rules(self) -> Sequence['outputs.GetPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleResult']:
        """
        The list of network security group rules that are applied to the endpoint.
        """
        return pulumi.get(self, "network_security_group_rules")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol of the endpoint.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleResult(dict):
    def __init__(__self__, *,
                 access: _builtins.str,
                 priority: _builtins.int,
                 source_address_prefix: _builtins.str,
                 source_port_ranges: Sequence[_builtins.str]):
        """
        :param _builtins.str access: The action that should be taken for a specified IP address, subnet range or tag.
        :param _builtins.int priority: The priority for this rule.
        :param _builtins.str source_address_prefix: The source address prefix or tag to match for the rule.
        :param Sequence[_builtins.str] source_port_ranges: The source port ranges to match for the rule.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @_builtins.property
    @pulumi.getter
    def access(self) -> _builtins.str:
        """
        The action that should be taken for a specified IP address, subnet range or tag.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority for this rule.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> _builtins.str:
        """
        The source address prefix or tag to match for the rule.
        """
        return pulumi.get(self, "source_address_prefix")

    @_builtins.property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Sequence[_builtins.str]:
        """
        The source port ranges to match for the rule.
        """
        return pulumi.get(self, "source_port_ranges")


@pulumi.output_type
class GetPoolNodePlacementResult(dict):
    def __init__(__self__, *,
                 policy: _builtins.str):
        """
        :param _builtins.str policy: The placement policy for allocating nodes in the pool.
        """
        pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The placement policy for allocating nodes in the pool.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GetPoolStartTaskResult(dict):
    def __init__(__self__, *,
                 command_line: _builtins.str,
                 containers: Sequence['outputs.GetPoolStartTaskContainerResult'],
                 resource_files: Sequence['outputs.GetPoolStartTaskResourceFileResult'],
                 task_retry_maximum: _builtins.int,
                 user_identities: Sequence['outputs.GetPoolStartTaskUserIdentityResult'],
                 wait_for_success: _builtins.bool,
                 common_environment_properties: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str command_line: The command line executed by the start task.
        :param Sequence['GetPoolStartTaskContainerArgs'] containers: The settings for the container under which the start task runs.
        :param Sequence['GetPoolStartTaskResourceFileArgs'] resource_files: One or more `resource_file` blocks that describe the files to be downloaded to a compute node.
        :param _builtins.int task_retry_maximum: The number of retry count
        :param Sequence['GetPoolStartTaskUserIdentityArgs'] user_identities: A `user_identity` block that describes the user identity under which the start task runs.
        :param _builtins.bool wait_for_success: A flag that indicates if the Batch pool should wait for the start task to be completed.
        :param Mapping[str, _builtins.str] common_environment_properties: A map of strings (key,value) that represents the environment variables to set in the start task.
        """
        pulumi.set(__self__, "command_line", command_line)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "resource_files", resource_files)
        pulumi.set(__self__, "task_retry_maximum", task_retry_maximum)
        pulumi.set(__self__, "user_identities", user_identities)
        pulumi.set(__self__, "wait_for_success", wait_for_success)
        if common_environment_properties is not None:
            pulumi.set(__self__, "common_environment_properties", common_environment_properties)

    @_builtins.property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> _builtins.str:
        """
        The command line executed by the start task.
        """
        return pulumi.get(self, "command_line")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetPoolStartTaskContainerResult']:
        """
        The settings for the container under which the start task runs.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="resourceFiles")
    def resource_files(self) -> Sequence['outputs.GetPoolStartTaskResourceFileResult']:
        """
        One or more `resource_file` blocks that describe the files to be downloaded to a compute node.
        """
        return pulumi.get(self, "resource_files")

    @_builtins.property
    @pulumi.getter(name="taskRetryMaximum")
    def task_retry_maximum(self) -> _builtins.int:
        """
        The number of retry count
        """
        return pulumi.get(self, "task_retry_maximum")

    @_builtins.property
    @pulumi.getter(name="userIdentities")
    def user_identities(self) -> Sequence['outputs.GetPoolStartTaskUserIdentityResult']:
        """
        A `user_identity` block that describes the user identity under which the start task runs.
        """
        return pulumi.get(self, "user_identities")

    @_builtins.property
    @pulumi.getter(name="waitForSuccess")
    def wait_for_success(self) -> _builtins.bool:
        """
        A flag that indicates if the Batch pool should wait for the start task to be completed.
        """
        return pulumi.get(self, "wait_for_success")

    @_builtins.property
    @pulumi.getter(name="commonEnvironmentProperties")
    def common_environment_properties(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of strings (key,value) that represents the environment variables to set in the start task.
        """
        return pulumi.get(self, "common_environment_properties")


@pulumi.output_type
class GetPoolStartTaskContainerResult(dict):
    def __init__(__self__, *,
                 image_name: _builtins.str,
                 registries: Sequence['outputs.GetPoolStartTaskContainerRegistryResult'],
                 run_options: _builtins.str,
                 working_directory: _builtins.str):
        """
        :param _builtins.str image_name: The image to use to create the container in which the task will run.
        :param Sequence['GetPoolStartTaskContainerRegistryArgs'] registries: The same reference as `container_registries` block defined as follows.
        :param _builtins.str run_options: Additional options to the container create command.
        :param _builtins.str working_directory: A flag to indicate where the container task working directory is.
        """
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "registries", registries)
        pulumi.set(__self__, "run_options", run_options)
        pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> _builtins.str:
        """
        The image to use to create the container in which the task will run.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter
    def registries(self) -> Sequence['outputs.GetPoolStartTaskContainerRegistryResult']:
        """
        The same reference as `container_registries` block defined as follows.
        """
        return pulumi.get(self, "registries")

    @_builtins.property
    @pulumi.getter(name="runOptions")
    def run_options(self) -> _builtins.str:
        """
        Additional options to the container create command.
        """
        return pulumi.get(self, "run_options")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> _builtins.str:
        """
        A flag to indicate where the container task working directory is.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class GetPoolStartTaskContainerRegistryResult(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 registry_server: _builtins.str,
                 user_assigned_identity_id: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str password: The password for the user account.
        :param _builtins.str registry_server: The container registry URL. The default is "docker.io".
        :param _builtins.str user_assigned_identity_id: The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password.
        :param _builtins.str user_name: The user to use for authentication against the CIFS file system.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "registry_server", registry_server)
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the user account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> _builtins.str:
        """
        The container registry URL. The default is "docker.io".
        """
        return pulumi.get(self, "registry_server")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> _builtins.str:
        """
        The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The user to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetPoolStartTaskResourceFileResult(dict):
    def __init__(__self__, *,
                 auto_storage_container_name: _builtins.str,
                 blob_prefix: _builtins.str,
                 file_mode: _builtins.str,
                 file_path: _builtins.str,
                 http_url: _builtins.str,
                 storage_container_url: _builtins.str,
                 user_assigned_identity_id: _builtins.str):
        """
        :param _builtins.str auto_storage_container_name: The storage container name in the auto storage account.
        :param _builtins.str blob_prefix: The blob prefix used when downloading blobs from an Azure Storage container.
        :param _builtins.str file_mode: The file permission mode attribute represented as a string in octal format (e.g. `"0644"`).
        :param _builtins.str file_path: The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified.
        :param _builtins.str http_url: The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access.
        :param _builtins.str storage_container_url: The URL of the blob container within Azure Blob Storage.
        :param _builtins.str user_assigned_identity_id: The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password.
        """
        pulumi.set(__self__, "auto_storage_container_name", auto_storage_container_name)
        pulumi.set(__self__, "blob_prefix", blob_prefix)
        pulumi.set(__self__, "file_mode", file_mode)
        pulumi.set(__self__, "file_path", file_path)
        pulumi.set(__self__, "http_url", http_url)
        pulumi.set(__self__, "storage_container_url", storage_container_url)
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="autoStorageContainerName")
    def auto_storage_container_name(self) -> _builtins.str:
        """
        The storage container name in the auto storage account.
        """
        return pulumi.get(self, "auto_storage_container_name")

    @_builtins.property
    @pulumi.getter(name="blobPrefix")
    def blob_prefix(self) -> _builtins.str:
        """
        The blob prefix used when downloading blobs from an Azure Storage container.
        """
        return pulumi.get(self, "blob_prefix")

    @_builtins.property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> _builtins.str:
        """
        The file permission mode attribute represented as a string in octal format (e.g. `"0644"`).
        """
        return pulumi.get(self, "file_mode")

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> _builtins.str:
        """
        The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified.
        """
        return pulumi.get(self, "file_path")

    @_builtins.property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> _builtins.str:
        """
        The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access.
        """
        return pulumi.get(self, "http_url")

    @_builtins.property
    @pulumi.getter(name="storageContainerUrl")
    def storage_container_url(self) -> _builtins.str:
        """
        The URL of the blob container within Azure Blob Storage.
        """
        return pulumi.get(self, "storage_container_url")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> _builtins.str:
        """
        The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class GetPoolStartTaskUserIdentityResult(dict):
    def __init__(__self__, *,
                 auto_users: Sequence['outputs.GetPoolStartTaskUserIdentityAutoUserResult'],
                 user_name: _builtins.str):
        """
        :param Sequence['GetPoolStartTaskUserIdentityAutoUserArgs'] auto_users: A `auto_user` block that describes the user identity under which the start task runs.
        :param _builtins.str user_name: The user to use for authentication against the CIFS file system.
        """
        pulumi.set(__self__, "auto_users", auto_users)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="autoUsers")
    def auto_users(self) -> Sequence['outputs.GetPoolStartTaskUserIdentityAutoUserResult']:
        """
        A `auto_user` block that describes the user identity under which the start task runs.
        """
        return pulumi.get(self, "auto_users")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The user to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetPoolStartTaskUserIdentityAutoUserResult(dict):
    def __init__(__self__, *,
                 elevation_level: _builtins.str,
                 scope: _builtins.str):
        """
        :param _builtins.str elevation_level: The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param _builtins.str scope: The scope of the user identity under which the start task runs.
        """
        pulumi.set(__self__, "elevation_level", elevation_level)
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> _builtins.str:
        """
        The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of the user identity under which the start task runs.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetPoolStorageImageReferenceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str id: The fully qualified ID of the certificate installed on the pool.
        :param _builtins.str publisher: The name of the extension handler publisher.The name of the extension handler publisher.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The fully qualified ID of the certificate installed on the pool.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The name of the extension handler publisher.The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPoolTaskSchedulingPolicyResult(dict):
    def __init__(__self__, *,
                 node_fill_type: _builtins.str):
        """
        :param _builtins.str node_fill_type: Supported values are `Pack` and `Spread`. `Pack` means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. `Spread` means that tasks should be assigned evenly across all nodes in the pool.
        """
        pulumi.set(__self__, "node_fill_type", node_fill_type)

    @_builtins.property
    @pulumi.getter(name="nodeFillType")
    def node_fill_type(self) -> _builtins.str:
        """
        Supported values are `Pack` and `Spread`. `Pack` means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. `Spread` means that tasks should be assigned evenly across all nodes in the pool.
        """
        return pulumi.get(self, "node_fill_type")


@pulumi.output_type
class GetPoolUserAccountResult(dict):
    def __init__(__self__, *,
                 elevation_level: _builtins.str,
                 linux_user_configurations: Sequence['outputs.GetPoolUserAccountLinuxUserConfigurationResult'],
                 name: _builtins.str,
                 password: _builtins.str,
                 windows_user_configurations: Sequence['outputs.GetPoolUserAccountWindowsUserConfigurationResult']):
        """
        :param _builtins.str elevation_level: The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param Sequence['GetPoolUserAccountLinuxUserConfigurationArgs'] linux_user_configurations: The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        :param _builtins.str name: The name of the Batch pool.
        :param _builtins.str password: The password for the user account.
        :param Sequence['GetPoolUserAccountWindowsUserConfigurationArgs'] windows_user_configurations: The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        pulumi.set(__self__, "elevation_level", elevation_level)
        pulumi.set(__self__, "linux_user_configurations", linux_user_configurations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "windows_user_configurations", windows_user_configurations)

    @_builtins.property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> _builtins.str:
        """
        The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @_builtins.property
    @pulumi.getter(name="linuxUserConfigurations")
    def linux_user_configurations(self) -> Sequence['outputs.GetPoolUserAccountLinuxUserConfigurationResult']:
        """
        The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        return pulumi.get(self, "linux_user_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Batch pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the user account.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="windowsUserConfigurations")
    def windows_user_configurations(self) -> Sequence['outputs.GetPoolUserAccountWindowsUserConfigurationResult']:
        """
        The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        return pulumi.get(self, "windows_user_configurations")


@pulumi.output_type
class GetPoolUserAccountLinuxUserConfigurationResult(dict):
    def __init__(__self__, *,
                 gid: _builtins.int,
                 ssh_private_key: _builtins.str,
                 uid: _builtins.int):
        """
        :param _builtins.int gid: The user ID of the user account.
        :param _builtins.str ssh_private_key: The SSH private key for the user account.
        :param _builtins.int uid: The group ID for the user account.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> _builtins.int:
        """
        The user ID of the user account.
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> _builtins.str:
        """
        The SSH private key for the user account.
        """
        return pulumi.get(self, "ssh_private_key")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.int:
        """
        The group ID for the user account.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetPoolUserAccountWindowsUserConfigurationResult(dict):
    def __init__(__self__, *,
                 login_mode: _builtins.str):
        """
        :param _builtins.str login_mode: Specifies login mode for the user.
        """
        pulumi.set(__self__, "login_mode", login_mode)

    @_builtins.property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> _builtins.str:
        """
        Specifies login mode for the user.
        """
        return pulumi.get(self, "login_mode")


@pulumi.output_type
class GetPoolWindowResult(dict):
    def __init__(__self__, *,
                 enable_automatic_updates: _builtins.bool):
        """
        :param _builtins.bool enable_automatic_updates: Whether automatic updates are enabled on the virtual machine.
        """
        pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> _builtins.bool:
        """
        Whether automatic updates are enabled on the virtual machine.
        """
        return pulumi.get(self, "enable_automatic_updates")


