# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChannelSmsArgs', 'ChannelSms']

@pulumi.input_type
class ChannelSmsArgs:
    def __init__(__self__, *,
                 bot_name: pulumi.Input[_builtins.str],
                 phone_number: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sms_channel_account_security_id: pulumi.Input[_builtins.str],
                 sms_channel_auth_token: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ChannelSms resource.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] phone_number: The phone number for the SMS Channel.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sms_channel_account_security_id: The account security identifier (SID) for the SMS Channel.
        :param pulumi.Input[_builtins.str] sms_channel_auth_token: The authorization token for the SMS Channel.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "bot_name", bot_name)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sms_channel_account_security_id", sms_channel_account_security_id)
        pulumi.set(__self__, "sms_channel_auth_token", sms_channel_auth_token)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bot_name")

    @bot_name.setter
    def bot_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bot_name", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[_builtins.str]:
        """
        The phone number for the SMS Channel.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="smsChannelAccountSecurityId")
    def sms_channel_account_security_id(self) -> pulumi.Input[_builtins.str]:
        """
        The account security identifier (SID) for the SMS Channel.
        """
        return pulumi.get(self, "sms_channel_account_security_id")

    @sms_channel_account_security_id.setter
    def sms_channel_account_security_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sms_channel_account_security_id", value)

    @_builtins.property
    @pulumi.getter(name="smsChannelAuthToken")
    def sms_channel_auth_token(self) -> pulumi.Input[_builtins.str]:
        """
        The authorization token for the SMS Channel.
        """
        return pulumi.get(self, "sms_channel_auth_token")

    @sms_channel_auth_token.setter
    def sms_channel_auth_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sms_channel_auth_token", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class _ChannelSmsState:
    def __init__(__self__, *,
                 bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_channel_account_security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_channel_auth_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ChannelSms resources.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] phone_number: The phone number for the SMS Channel.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sms_channel_account_security_id: The account security identifier (SID) for the SMS Channel.
        :param pulumi.Input[_builtins.str] sms_channel_auth_token: The authorization token for the SMS Channel.
        """
        if bot_name is not None:
            pulumi.set(__self__, "bot_name", bot_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sms_channel_account_security_id is not None:
            pulumi.set(__self__, "sms_channel_account_security_id", sms_channel_account_security_id)
        if sms_channel_auth_token is not None:
            pulumi.set(__self__, "sms_channel_auth_token", sms_channel_auth_token)

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bot_name")

    @bot_name.setter
    def bot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bot_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The phone number for the SMS Channel.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="smsChannelAccountSecurityId")
    def sms_channel_account_security_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account security identifier (SID) for the SMS Channel.
        """
        return pulumi.get(self, "sms_channel_account_security_id")

    @sms_channel_account_security_id.setter
    def sms_channel_account_security_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sms_channel_account_security_id", value)

    @_builtins.property
    @pulumi.getter(name="smsChannelAuthToken")
    def sms_channel_auth_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization token for the SMS Channel.
        """
        return pulumi.get(self, "sms_channel_auth_token")

    @sms_channel_auth_token.setter
    def sms_channel_auth_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sms_channel_auth_token", value)


@pulumi.type_token("azure:bot/channelSms:ChannelSms")
class ChannelSms(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_channel_account_security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_channel_auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a SMS integration for a Bot Channel

        > **Note:** A bot can only have a single SMS Channel associated with it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_channels_registration = azure.bot.ChannelsRegistration("example",
            name="example-bcr",
            location="global",
            resource_group_name=example.name,
            sku="F0",
            microsoft_app_id=current.client_id)
        example_channel_sms = azure.bot.ChannelSms("example",
            bot_name=example_channels_registration.name,
            location=example_channels_registration.location,
            resource_group_name=example.name,
            sms_channel_account_security_id="BG61f7cf5157f439b084e98256409c2815",
            sms_channel_auth_token="jh8980432610052ed4e29565c5e232f",
            phone_number="+12313803556")
        ```

        ## Import

        The SMS Integration for a Bot Channel can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/channelSms:ChannelSms example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.BotService/botServices/botService1/channels/SmsChannel
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] phone_number: The phone number for the SMS Channel.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sms_channel_account_security_id: The account security identifier (SID) for the SMS Channel.
        :param pulumi.Input[_builtins.str] sms_channel_auth_token: The authorization token for the SMS Channel.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelSmsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SMS integration for a Bot Channel

        > **Note:** A bot can only have a single SMS Channel associated with it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_channels_registration = azure.bot.ChannelsRegistration("example",
            name="example-bcr",
            location="global",
            resource_group_name=example.name,
            sku="F0",
            microsoft_app_id=current.client_id)
        example_channel_sms = azure.bot.ChannelSms("example",
            bot_name=example_channels_registration.name,
            location=example_channels_registration.location,
            resource_group_name=example.name,
            sms_channel_account_security_id="BG61f7cf5157f439b084e98256409c2815",
            sms_channel_auth_token="jh8980432610052ed4e29565c5e232f",
            phone_number="+12313803556")
        ```

        ## Import

        The SMS Integration for a Bot Channel can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/channelSms:ChannelSms example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.BotService/botServices/botService1/channels/SmsChannel
        ```

        :param str resource_name: The name of the resource.
        :param ChannelSmsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelSmsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_channel_account_security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_channel_auth_token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelSmsArgs.__new__(ChannelSmsArgs)

            if bot_name is None and not opts.urn:
                raise TypeError("Missing required property 'bot_name'")
            __props__.__dict__["bot_name"] = bot_name
            __props__.__dict__["location"] = location
            if phone_number is None and not opts.urn:
                raise TypeError("Missing required property 'phone_number'")
            __props__.__dict__["phone_number"] = phone_number
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sms_channel_account_security_id is None and not opts.urn:
                raise TypeError("Missing required property 'sms_channel_account_security_id'")
            __props__.__dict__["sms_channel_account_security_id"] = sms_channel_account_security_id
            if sms_channel_auth_token is None and not opts.urn:
                raise TypeError("Missing required property 'sms_channel_auth_token'")
            __props__.__dict__["sms_channel_auth_token"] = None if sms_channel_auth_token is None else pulumi.Output.secret(sms_channel_auth_token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["smsChannelAuthToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ChannelSms, __self__).__init__(
            'azure:bot/channelSms:ChannelSms',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sms_channel_account_security_id: Optional[pulumi.Input[_builtins.str]] = None,
            sms_channel_auth_token: Optional[pulumi.Input[_builtins.str]] = None) -> 'ChannelSms':
        """
        Get an existing ChannelSms resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] phone_number: The phone number for the SMS Channel.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sms_channel_account_security_id: The account security identifier (SID) for the SMS Channel.
        :param pulumi.Input[_builtins.str] sms_channel_auth_token: The authorization token for the SMS Channel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelSmsState.__new__(_ChannelSmsState)

        __props__.__dict__["bot_name"] = bot_name
        __props__.__dict__["location"] = location
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sms_channel_account_security_id"] = sms_channel_account_security_id
        __props__.__dict__["sms_channel_auth_token"] = sms_channel_auth_token
        return ChannelSms(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bot_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[_builtins.str]:
        """
        The phone number for the SMS Channel.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group where the SMS Channel should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="smsChannelAccountSecurityId")
    def sms_channel_account_security_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account security identifier (SID) for the SMS Channel.
        """
        return pulumi.get(self, "sms_channel_account_security_id")

    @_builtins.property
    @pulumi.getter(name="smsChannelAuthToken")
    def sms_channel_auth_token(self) -> pulumi.Output[_builtins.str]:
        """
        The authorization token for the SMS Channel.
        """
        return pulumi.get(self, "sms_channel_auth_token")

