# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorOriginGroupArgs', 'FrontdoorOriginGroup']

@pulumi.input_type
class FrontdoorOriginGroupArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: pulumi.Input[_builtins.str],
                 load_balancing: pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs'],
                 health_probe: Optional[pulumi.Input['FrontdoorOriginGroupHealthProbeArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 session_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a FrontdoorOriginGroup resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs'] load_balancing: A `load_balancing` block as defined below.
        :param pulumi.Input['FrontdoorOriginGroupHealthProbeArgs'] health_probe: A `health_probe` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input[_builtins.int] restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.
               
               > **Note:** This property is currently not used, but will be in the near future.
        :param pulumi.Input[_builtins.bool] session_affinity_enabled: Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        pulumi.set(__self__, "load_balancing", load_balancing)
        if health_probe is not None:
            pulumi.set(__self__, "health_probe", health_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restore_traffic_time_to_healed_or_new_endpoint_in_minutes is not None:
            pulumi.set(__self__, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes", restore_traffic_time_to_healed_or_new_endpoint_in_minutes)
        if session_affinity_enabled is not None:
            pulumi.set(__self__, "session_affinity_enabled", session_affinity_enabled)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs']:
        """
        A `load_balancing` block as defined below.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs']):
        pulumi.set(self, "load_balancing", value)

    @_builtins.property
    @pulumi.getter(name="healthProbe")
    def health_probe(self) -> Optional[pulumi.Input['FrontdoorOriginGroupHealthProbeArgs']]:
        """
        A `health_probe` block as defined below.
        """
        return pulumi.get(self, "health_probe")

    @health_probe.setter
    def health_probe(self, value: Optional[pulumi.Input['FrontdoorOriginGroupHealthProbeArgs']]):
        pulumi.set(self, "health_probe", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="restoreTrafficTimeToHealedOrNewEndpointInMinutes")
    def restore_traffic_time_to_healed_or_new_endpoint_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.

        > **Note:** This property is currently not used, but will be in the near future.
        """
        return pulumi.get(self, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes")

    @restore_traffic_time_to_healed_or_new_endpoint_in_minutes.setter
    def restore_traffic_time_to_healed_or_new_endpoint_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinityEnabled")
    def session_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        return pulumi.get(self, "session_affinity_enabled")

    @session_affinity_enabled.setter
    def session_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "session_affinity_enabled", value)


@pulumi.input_type
class _FrontdoorOriginGroupState:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_probe: Optional[pulumi.Input['FrontdoorOriginGroupHealthProbeArgs']] = None,
                 load_balancing: Optional[pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 session_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering FrontdoorOriginGroup resources.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input['FrontdoorOriginGroupHealthProbeArgs'] health_probe: A `health_probe` block as defined below.
        :param pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs'] load_balancing: A `load_balancing` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input[_builtins.int] restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.
               
               > **Note:** This property is currently not used, but will be in the near future.
        :param pulumi.Input[_builtins.bool] session_affinity_enabled: Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        if cdn_frontdoor_profile_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        if health_probe is not None:
            pulumi.set(__self__, "health_probe", health_probe)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restore_traffic_time_to_healed_or_new_endpoint_in_minutes is not None:
            pulumi.set(__self__, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes", restore_traffic_time_to_healed_or_new_endpoint_in_minutes)
        if session_affinity_enabled is not None:
            pulumi.set(__self__, "session_affinity_enabled", session_affinity_enabled)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="healthProbe")
    def health_probe(self) -> Optional[pulumi.Input['FrontdoorOriginGroupHealthProbeArgs']]:
        """
        A `health_probe` block as defined below.
        """
        return pulumi.get(self, "health_probe")

    @health_probe.setter
    def health_probe(self, value: Optional[pulumi.Input['FrontdoorOriginGroupHealthProbeArgs']]):
        pulumi.set(self, "health_probe", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs']]:
        """
        A `load_balancing` block as defined below.
        """
        return pulumi.get(self, "load_balancing")

    @load_balancing.setter
    def load_balancing(self, value: Optional[pulumi.Input['FrontdoorOriginGroupLoadBalancingArgs']]):
        pulumi.set(self, "load_balancing", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="restoreTrafficTimeToHealedOrNewEndpointInMinutes")
    def restore_traffic_time_to_healed_or_new_endpoint_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.

        > **Note:** This property is currently not used, but will be in the near future.
        """
        return pulumi.get(self, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes")

    @restore_traffic_time_to_healed_or_new_endpoint_in_minutes.setter
    def restore_traffic_time_to_healed_or_new_endpoint_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinityEnabled")
    def session_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        return pulumi.get(self, "session_affinity_enabled")

    @session_affinity_enabled.setter
    def session_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "session_affinity_enabled", value)


@pulumi.type_token("azure:cdn/frontdoorOriginGroup:FrontdoorOriginGroup")
class FrontdoorOriginGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_probe: Optional[pulumi.Input[Union['FrontdoorOriginGroupHealthProbeArgs', 'FrontdoorOriginGroupHealthProbeArgsDict']]] = None,
                 load_balancing: Optional[pulumi.Input[Union['FrontdoorOriginGroupLoadBalancingArgs', 'FrontdoorOriginGroupLoadBalancingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 session_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Origin Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origin-group",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            session_affinity_enabled=True,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes=10,
            health_probe={
                "interval_in_seconds": 240,
                "path": "/healthProbe",
                "protocol": "Https",
                "request_type": "HEAD",
            },
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        ```

        ## Import

        Front Door Origin Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorOriginGroup:FrontdoorOriginGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input[Union['FrontdoorOriginGroupHealthProbeArgs', 'FrontdoorOriginGroupHealthProbeArgsDict']] health_probe: A `health_probe` block as defined below.
        :param pulumi.Input[Union['FrontdoorOriginGroupLoadBalancingArgs', 'FrontdoorOriginGroupLoadBalancingArgsDict']] load_balancing: A `load_balancing` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input[_builtins.int] restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.
               
               > **Note:** This property is currently not used, but will be in the near future.
        :param pulumi.Input[_builtins.bool] session_affinity_enabled: Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorOriginGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Origin Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origin-group",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            session_affinity_enabled=True,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes=10,
            health_probe={
                "interval_in_seconds": 240,
                "path": "/healthProbe",
                "protocol": "Https",
                "request_type": "HEAD",
            },
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        ```

        ## Import

        Front Door Origin Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorOriginGroup:FrontdoorOriginGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorOriginGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorOriginGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health_probe: Optional[pulumi.Input[Union['FrontdoorOriginGroupHealthProbeArgs', 'FrontdoorOriginGroupHealthProbeArgsDict']]] = None,
                 load_balancing: Optional[pulumi.Input[Union['FrontdoorOriginGroupLoadBalancingArgs', 'FrontdoorOriginGroupLoadBalancingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 session_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorOriginGroupArgs.__new__(FrontdoorOriginGroupArgs)

            if cdn_frontdoor_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_profile_id'")
            __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
            __props__.__dict__["health_probe"] = health_probe
            if load_balancing is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancing'")
            __props__.__dict__["load_balancing"] = load_balancing
            __props__.__dict__["name"] = name
            __props__.__dict__["restore_traffic_time_to_healed_or_new_endpoint_in_minutes"] = restore_traffic_time_to_healed_or_new_endpoint_in_minutes
            __props__.__dict__["session_affinity_enabled"] = session_affinity_enabled
        super(FrontdoorOriginGroup, __self__).__init__(
            'azure:cdn/frontdoorOriginGroup:FrontdoorOriginGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            health_probe: Optional[pulumi.Input[Union['FrontdoorOriginGroupHealthProbeArgs', 'FrontdoorOriginGroupHealthProbeArgsDict']]] = None,
            load_balancing: Optional[pulumi.Input[Union['FrontdoorOriginGroupLoadBalancingArgs', 'FrontdoorOriginGroupLoadBalancingArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            session_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'FrontdoorOriginGroup':
        """
        Get an existing FrontdoorOriginGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input[Union['FrontdoorOriginGroupHealthProbeArgs', 'FrontdoorOriginGroupHealthProbeArgsDict']] health_probe: A `health_probe` block as defined below.
        :param pulumi.Input[Union['FrontdoorOriginGroupLoadBalancingArgs', 'FrontdoorOriginGroupLoadBalancingArgsDict']] load_balancing: A `load_balancing` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        :param pulumi.Input[_builtins.int] restore_traffic_time_to_healed_or_new_endpoint_in_minutes: Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.
               
               > **Note:** This property is currently not used, but will be in the near future.
        :param pulumi.Input[_builtins.bool] session_affinity_enabled: Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorOriginGroupState.__new__(_FrontdoorOriginGroupState)

        __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
        __props__.__dict__["health_probe"] = health_probe
        __props__.__dict__["load_balancing"] = load_balancing
        __props__.__dict__["name"] = name
        __props__.__dict__["restore_traffic_time_to_healed_or_new_endpoint_in_minutes"] = restore_traffic_time_to_healed_or_new_endpoint_in_minutes
        __props__.__dict__["session_affinity_enabled"] = session_affinity_enabled
        return FrontdoorOriginGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Front Door Profile within which this Front Door Origin Group should exist. Changing this forces a new Front Door Origin Group to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @_builtins.property
    @pulumi.getter(name="healthProbe")
    def health_probe(self) -> pulumi.Output[Optional['outputs.FrontdoorOriginGroupHealthProbe']]:
        """
        A `health_probe` block as defined below.
        """
        return pulumi.get(self, "health_probe")

    @_builtins.property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> pulumi.Output['outputs.FrontdoorOriginGroupLoadBalancing']:
        """
        A `load_balancing` block as defined below.
        """
        return pulumi.get(self, "load_balancing")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Front Door Origin Group. Changing this forces a new Front Door Origin Group to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="restoreTrafficTimeToHealedOrNewEndpointInMinutes")
    def restore_traffic_time_to_healed_or_new_endpoint_in_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the amount of time which should elapse before shifting traffic to another endpoint when a healthy endpoint becomes unhealthy or a new endpoint is added. Possible values are between `0` and `50` minutes (inclusive). Default is `10` minutes.

        > **Note:** This property is currently not used, but will be in the near future.
        """
        return pulumi.get(self, "restore_traffic_time_to_healed_or_new_endpoint_in_minutes")

    @_builtins.property
    @pulumi.getter(name="sessionAffinityEnabled")
    def session_affinity_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether session affinity should be enabled on this host. Defaults to `true`.
        """
        return pulumi.get(self, "session_affinity_enabled")

