# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountCustomerManagedKeyInitArgs', 'AccountCustomerManagedKey']

@pulumi.input_type
class AccountCustomerManagedKeyInitArgs:
    def __init__(__self__, *,
                 cognitive_account_id: pulumi.Input[_builtins.str],
                 key_vault_key_id: pulumi.Input[_builtins.str],
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountCustomerManagedKey resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        :param pulumi.Input[_builtins.str] identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        pulumi.set(__self__, "cognitive_account_id", cognitive_account_id)
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Cognitive Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @cognitive_account_id.setter
    def cognitive_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cognitive_account_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_client_id", value)


@pulumi.input_type
class _AccountCustomerManagedKeyState:
    def __init__(__self__, *,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountCustomerManagedKey resources.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        if cognitive_account_id is not None:
            pulumi.set(__self__, "cognitive_account_id", cognitive_account_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cognitive Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @cognitive_account_id.setter
    def cognitive_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cognitive_account_id", value)

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_client_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)


@pulumi.type_token("azure:cognitive/accountCustomerManagedKey:AccountCustomerManagedKey")
class AccountCustomerManagedKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Customer Managed Key for a Cognitive Services Account.

        > **Note:** It's possible to define a Customer Managed Key both within the `cognitive.Account` resource via the `customer_managed_key` block and by using the `cognitive.AccountCustomerManagedKey` resource. However it's not possible to use both methods to manage a Customer Managed Key for a Cognitive Account, since there'll be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example.name,
            location=example.location,
            name="example-identity")
        example_account = azure.cognitive.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            kind="Face",
            sku_name="E0",
            custom_subdomain_name="example-account",
            identity={
                "type": "SystemAssigned, UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-vault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True,
            access_policies=[
                {
                    "tenant_id": example_account.identity.tenant_id,
                    "object_id": example_account.identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "List",
                        "Restore",
                        "Recover",
                        "UnwrapKey",
                        "WrapKey",
                        "Purge",
                        "Encrypt",
                        "Decrypt",
                        "Sign",
                        "Verify",
                    ],
                    "secret_permissions": ["Get"],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "Delete",
                        "List",
                        "Restore",
                        "Recover",
                        "UnwrapKey",
                        "WrapKey",
                        "Purge",
                        "Encrypt",
                        "Decrypt",
                        "Sign",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Get"],
                },
                {
                    "tenant_id": example_user_assigned_identity.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "Delete",
                        "List",
                        "Restore",
                        "Recover",
                        "UnwrapKey",
                        "WrapKey",
                        "Purge",
                        "Encrypt",
                        "Decrypt",
                        "Sign",
                        "Verify",
                    ],
                    "secret_permissions": ["Get"],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_account_customer_managed_key = azure.cognitive.AccountCustomerManagedKey("example",
            cognitive_account_id=example_account.id,
            key_vault_key_id=example_key.id,
            identity_client_id=example_user_assigned_identity.client_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices` - 2025-06-01

        ## Import

        Customer Managed Keys for a Cognitive Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/accountCustomerManagedKey:AccountCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.CognitiveServices/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountCustomerManagedKeyInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Customer Managed Key for a Cognitive Services Account.

        > **Note:** It's possible to define a Customer Managed Key both within the `cognitive.Account` resource via the `customer_managed_key` block and by using the `cognitive.AccountCustomerManagedKey` resource. However it's not possible to use both methods to manage a Customer Managed Key for a Cognitive Account, since there'll be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West US")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example.name,
            location=example.location,
            name="example-identity")
        example_account = azure.cognitive.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            kind="Face",
            sku_name="E0",
            custom_subdomain_name="example-account",
            identity={
                "type": "SystemAssigned, UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-vault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True,
            access_policies=[
                {
                    "tenant_id": example_account.identity.tenant_id,
                    "object_id": example_account.identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "List",
                        "Restore",
                        "Recover",
                        "UnwrapKey",
                        "WrapKey",
                        "Purge",
                        "Encrypt",
                        "Decrypt",
                        "Sign",
                        "Verify",
                    ],
                    "secret_permissions": ["Get"],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "Delete",
                        "List",
                        "Restore",
                        "Recover",
                        "UnwrapKey",
                        "WrapKey",
                        "Purge",
                        "Encrypt",
                        "Decrypt",
                        "Sign",
                        "Verify",
                        "GetRotationPolicy",
                    ],
                    "secret_permissions": ["Get"],
                },
                {
                    "tenant_id": example_user_assigned_identity.tenant_id,
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "Delete",
                        "List",
                        "Restore",
                        "Recover",
                        "UnwrapKey",
                        "WrapKey",
                        "Purge",
                        "Encrypt",
                        "Decrypt",
                        "Sign",
                        "Verify",
                    ],
                    "secret_permissions": ["Get"],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="example-key",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_account_customer_managed_key = azure.cognitive.AccountCustomerManagedKey("example",
            cognitive_account_id=example_account.id,
            key_vault_key_id=example_key.id,
            identity_client_id=example_user_assigned_identity.client_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices` - 2025-06-01

        ## Import

        Customer Managed Keys for a Cognitive Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/accountCustomerManagedKey:AccountCustomerManagedKey example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.CognitiveServices/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountCustomerManagedKeyInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountCustomerManagedKeyInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountCustomerManagedKeyInitArgs.__new__(AccountCustomerManagedKeyInitArgs)

            if cognitive_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'cognitive_account_id'")
            __props__.__dict__["cognitive_account_id"] = cognitive_account_id
            __props__.__dict__["identity_client_id"] = identity_client_id
            if key_vault_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_key_id'")
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        super(AccountCustomerManagedKey, __self__).__init__(
            'azure:cognitive/accountCustomerManagedKey:AccountCustomerManagedKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountCustomerManagedKey':
        """
        Get an existing AccountCustomerManagedKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountCustomerManagedKeyState.__new__(_AccountCustomerManagedKeyState)

        __props__.__dict__["cognitive_account_id"] = cognitive_account_id
        __props__.__dict__["identity_client_id"] = identity_client_id
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        return AccountCustomerManagedKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Cognitive Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        return pulumi.get(self, "identity_client_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        return pulumi.get(self, "key_vault_key_id")

