# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExtensionArgs', 'Extension']

@pulumi.input_type
class ExtensionArgs:
    def __init__(__self__, *,
                 publisher: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 type_handler_version: pulumi.Input[_builtins.str],
                 virtual_machine_id: pulumi.Input[_builtins.str],
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs']] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Extension resource.
        :param pulumi.Input[_builtins.str] publisher: The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of extension, available types for a publisher can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vm extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the Virtual Machine. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] name: The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs'] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: Specifies the collection of extension names after which this extension needs to be provisioned.
        :param pulumi.Input[_builtins.str] settings: The settings passed to the extension, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if failure_suppression_enabled is not None:
            pulumi.set(__self__, "failure_suppression_enabled", failure_suppression_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[_builtins.str]:
        """
        The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of extension, available types for a publisher can be found using the Azure CLI.

        > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:

        ```shell
        az vm extension image list --location westus -o table
        ```
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type_handler_version", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Machine. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @automatic_upgrade_enabled.setter
    def automatic_upgrade_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_enabled", value)

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @failure_suppression_enabled.setter
    def failure_suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "failure_suppression_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.

        > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protected_settings", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional[pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs']]:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @protected_settings_from_key_vault.setter
    def protected_settings_from_key_vault(self, value: Optional[pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs']]):
        pulumi.set(self, "protected_settings_from_key_vault", value)

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The settings passed to the extension, these are specified as a JSON object in a string.

        > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ExtensionState:
    def __init__(__self__, *,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs']] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Extension resources.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] name: The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs'] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: Specifies the collection of extension names after which this extension needs to be provisioned.
        :param pulumi.Input[_builtins.str] publisher: The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] settings: The settings passed to the extension, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of extension, available types for a publisher can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vm extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the Virtual Machine. Changing this forces a new resource to be created
        """
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if failure_suppression_enabled is not None:
            pulumi.set(__self__, "failure_suppression_enabled", failure_suppression_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @automatic_upgrade_enabled.setter
    def automatic_upgrade_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_enabled", value)

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @failure_suppression_enabled.setter
    def failure_suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "failure_suppression_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.

        > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protected_settings", value)

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional[pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs']]:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @protected_settings_from_key_vault.setter
    def protected_settings_from_key_vault(self, value: Optional[pulumi.Input['ExtensionProtectedSettingsFromKeyVaultArgs']]):
        pulumi.set(self, "protected_settings_from_key_vault", value)

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The settings passed to the extension, these are specified as a JSON object in a string.

        > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of extension, available types for a publisher can be found using the Azure CLI.

        > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:

        ```shell
        az vm extension image list --location westus -o table
        ```
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_handler_version", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Machine. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:compute/extension:Extension")
class Extension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input[Union['ExtensionProtectedSettingsFromKeyVaultArgs', 'ExtensionProtectedSettingsFromKeyVaultArgsDict']]] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Machine Extension to provide post deployment configuration
        and run automated tasks.

        > **Note:** Custom Script Extensions for Linux & Windows require that the `commandToExecute` returns a `0` exit code to be classified as successfully deployed. You can achieve this by appending `exit 0` to the end of your `commandToExecute`.

        > **Note:** Custom Script Extensions require that the Azure Virtual Machine Guest Agent is running on the Virtual Machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="acctni",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_extension = azure.compute.Extension("example",
            name="hostname",
            virtual_machine_id=example_linux_virtual_machine.id,
            publisher="Microsoft.Azure.Extensions",
            type="CustomScript",
            type_handler_version="2.0",
            settings=\"\"\" {
          \\"commandToExecute\\": \\"hostname && uptime\\"
         }
        \"\"\",
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2024-03-01

        ## Import

        Virtual Machine Extensions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/extension:Extension example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/myVM/extensions/extensionName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] name: The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input[Union['ExtensionProtectedSettingsFromKeyVaultArgs', 'ExtensionProtectedSettingsFromKeyVaultArgsDict']] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: Specifies the collection of extension names after which this extension needs to be provisioned.
        :param pulumi.Input[_builtins.str] publisher: The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] settings: The settings passed to the extension, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of extension, available types for a publisher can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vm extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the Virtual Machine. Changing this forces a new resource to be created
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Machine Extension to provide post deployment configuration
        and run automated tasks.

        > **Note:** Custom Script Extensions for Linux & Windows require that the `commandToExecute` returns a `0` exit code to be classified as successfully deployed. You can achieve this by appending `exit 0` to the end of your `commandToExecute`.

        > **Note:** Custom Script Extensions require that the Azure Virtual Machine Guest Agent is running on the Virtual Machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="acctni",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_extension = azure.compute.Extension("example",
            name="hostname",
            virtual_machine_id=example_linux_virtual_machine.id,
            publisher="Microsoft.Azure.Extensions",
            type="CustomScript",
            type_handler_version="2.0",
            settings=\"\"\" {
          \\"commandToExecute\\": \\"hostname && uptime\\"
         }
        \"\"\",
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2024-03-01

        ## Import

        Virtual Machine Extensions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/extension:Extension example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/myVM/extensions/extensionName
        ```

        :param str resource_name: The name of the resource.
        :param ExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input[Union['ExtensionProtectedSettingsFromKeyVaultArgs', 'ExtensionProtectedSettingsFromKeyVaultArgsDict']]] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 publisher: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtensionArgs.__new__(ExtensionArgs)

            __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
            __props__.__dict__["automatic_upgrade_enabled"] = automatic_upgrade_enabled
            __props__.__dict__["failure_suppression_enabled"] = failure_suppression_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["protected_settings"] = None if protected_settings is None else pulumi.Output.secret(protected_settings)
            __props__.__dict__["protected_settings_from_key_vault"] = protected_settings_from_key_vault
            __props__.__dict__["provision_after_extensions"] = provision_after_extensions
            if publisher is None and not opts.urn:
                raise TypeError("Missing required property 'publisher'")
            __props__.__dict__["publisher"] = publisher
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if type_handler_version is None and not opts.urn:
                raise TypeError("Missing required property 'type_handler_version'")
            __props__.__dict__["type_handler_version"] = type_handler_version
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["protectedSettings"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Extension, __self__).__init__(
            'azure:compute/extension:Extension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.bool]] = None,
            automatic_upgrade_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            failure_suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protected_settings: Optional[pulumi.Input[_builtins.str]] = None,
            protected_settings_from_key_vault: Optional[pulumi.Input[Union['ExtensionProtectedSettingsFromKeyVaultArgs', 'ExtensionProtectedSettingsFromKeyVaultArgsDict']]] = None,
            provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            publisher: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            type_handler_version: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Extension':
        """
        Get an existing Extension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_upgrade_minor_version: Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        :param pulumi.Input[_builtins.bool] automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param pulumi.Input[_builtins.bool] failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param pulumi.Input[_builtins.str] name: The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protected_settings: The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input[Union['ExtensionProtectedSettingsFromKeyVaultArgs', 'ExtensionProtectedSettingsFromKeyVaultArgsDict']] protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provision_after_extensions: Specifies the collection of extension names after which this extension needs to be provisioned.
        :param pulumi.Input[_builtins.str] publisher: The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] settings: The settings passed to the extension, these are specified as a JSON object in a string.
               
               > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of extension, available types for a publisher can be found using the Azure CLI.
               
               > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:
               
               ```shell
               az vm extension image list --location westus -o table
               ```
        :param pulumi.Input[_builtins.str] type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the Virtual Machine. Changing this forces a new resource to be created
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtensionState.__new__(_ExtensionState)

        __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
        __props__.__dict__["automatic_upgrade_enabled"] = automatic_upgrade_enabled
        __props__.__dict__["failure_suppression_enabled"] = failure_suppression_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["protected_settings"] = protected_settings
        __props__.__dict__["protected_settings_from_key_vault"] = protected_settings_from_key_vault
        __props__.__dict__["provision_after_extensions"] = provision_after_extensions
        __props__.__dict__["publisher"] = publisher
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["type_handler_version"] = type_handler_version
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return Extension(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the platform deploys the latest minor version update to the `type_handler_version` specified.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`. Defaults to `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the virtual machine extension peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.

        > **Note:** Certain VM Extensions require that the keys in the `protected_settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> pulumi.Output[Optional['outputs.ExtensionProtectedSettingsFromKeyVault']]:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Output[_builtins.str]:
        """
        The publisher of the extension, available publishers can be found by using the Azure CLI. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The settings passed to the extension, these are specified as a JSON object in a string.

        > **Note:** Certain VM Extensions require that the keys in the `settings` block are case sensitive. If you're seeing unhelpful errors, please ensure the keys are consistent with how Azure is expecting them (for instance, for the `JsonADDomainExtension` extension, the keys are expected to be in `TitleCase`.)
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of extension, available types for a publisher can be found using the Azure CLI.

        > **Note:** The `Publisher` and `Type` of Virtual Machine Extensions can be found using the Azure CLI, via:

        ```shell
        az vm extension image list --location westus -o table
        ```
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Machine. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "virtual_machine_id")

