# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RunCommandArgs', 'RunCommand']

@pulumi.input_type
class RunCommandArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['RunCommandSourceArgs'],
                 virtual_machine_id: pulumi.Input[_builtins.str],
                 error_blob_managed_identity: Optional[pulumi.Input['RunCommandErrorBlobManagedIdentityArgs']] = None,
                 error_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_blob_managed_identity: Optional[pulumi.Input['RunCommandOutputBlobManagedIdentityArgs']] = None,
                 output_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]]] = None,
                 protected_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]]] = None,
                 run_as_password: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RunCommand resource.
        :param pulumi.Input['RunCommandSourceArgs'] source: A `source` block as defined below. The source of the run command script.
        :param pulumi.Input[_builtins.str] virtual_machine_id: Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input['RunCommandErrorBlobManagedIdentityArgs'] error_blob_managed_identity: An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        :param pulumi.Input[_builtins.str] error_blob_uri: Specifies the Azure storage blob where script error stream will be uploaded.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input['RunCommandOutputBlobManagedIdentityArgs'] output_blob_managed_identity: An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        :param pulumi.Input[_builtins.str] output_blob_uri: Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        :param pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]] parameters: A list of `parameter` blocks as defined below. The parameters used by the script.
        :param pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]] protected_parameters: A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        :param pulumi.Input[_builtins.str] run_as_password: Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] run_as_user: Specifies the user account on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Virtual Machine Run Command.
        """
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if error_blob_managed_identity is not None:
            pulumi.set(__self__, "error_blob_managed_identity", error_blob_managed_identity)
        if error_blob_uri is not None:
            pulumi.set(__self__, "error_blob_uri", error_blob_uri)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_blob_managed_identity is not None:
            pulumi.set(__self__, "output_blob_managed_identity", output_blob_managed_identity)
        if output_blob_uri is not None:
            pulumi.set(__self__, "output_blob_uri", output_blob_uri)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if protected_parameters is not None:
            pulumi.set(__self__, "protected_parameters", protected_parameters)
        if run_as_password is not None:
            pulumi.set(__self__, "run_as_password", run_as_password)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['RunCommandSourceArgs']:
        """
        A `source` block as defined below. The source of the run command script.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['RunCommandSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="errorBlobManagedIdentity")
    def error_blob_managed_identity(self) -> Optional[pulumi.Input['RunCommandErrorBlobManagedIdentityArgs']]:
        """
        An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        """
        return pulumi.get(self, "error_blob_managed_identity")

    @error_blob_managed_identity.setter
    def error_blob_managed_identity(self, value: Optional[pulumi.Input['RunCommandErrorBlobManagedIdentityArgs']]):
        pulumi.set(self, "error_blob_managed_identity", value)

    @_builtins.property
    @pulumi.getter(name="errorBlobUri")
    def error_blob_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure storage blob where script error stream will be uploaded.
        """
        return pulumi.get(self, "error_blob_uri")

    @error_blob_uri.setter
    def error_blob_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_blob_uri", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputBlobManagedIdentity")
    def output_blob_managed_identity(self) -> Optional[pulumi.Input['RunCommandOutputBlobManagedIdentityArgs']]:
        """
        An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        """
        return pulumi.get(self, "output_blob_managed_identity")

    @output_blob_managed_identity.setter
    def output_blob_managed_identity(self, value: Optional[pulumi.Input['RunCommandOutputBlobManagedIdentityArgs']]):
        pulumi.set(self, "output_blob_managed_identity", value)

    @_builtins.property
    @pulumi.getter(name="outputBlobUri")
    def output_blob_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        """
        return pulumi.get(self, "output_blob_uri")

    @output_blob_uri.setter
    def output_blob_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_blob_uri", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]]]:
        """
        A list of `parameter` blocks as defined below. The parameters used by the script.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="protectedParameters")
    def protected_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]]]:
        """
        A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        """
        return pulumi.get(self, "protected_parameters")

    @protected_parameters.setter
    def protected_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]]]):
        pulumi.set(self, "protected_parameters", value)

    @_builtins.property
    @pulumi.getter(name="runAsPassword")
    def run_as_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        """
        return pulumi.get(self, "run_as_password")

    @run_as_password.setter
    def run_as_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_password", value)

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user account on the VM when executing the Virtual Machine Run Command.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_user", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Virtual Machine Run Command.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RunCommandState:
    def __init__(__self__, *,
                 error_blob_managed_identity: Optional[pulumi.Input['RunCommandErrorBlobManagedIdentityArgs']] = None,
                 error_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_views: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandInstanceViewArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_blob_managed_identity: Optional[pulumi.Input['RunCommandOutputBlobManagedIdentityArgs']] = None,
                 output_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]]] = None,
                 protected_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]]] = None,
                 run_as_password: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['RunCommandSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RunCommand resources.
        :param pulumi.Input['RunCommandErrorBlobManagedIdentityArgs'] error_blob_managed_identity: An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        :param pulumi.Input[_builtins.str] error_blob_uri: Specifies the Azure storage blob where script error stream will be uploaded.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input['RunCommandOutputBlobManagedIdentityArgs'] output_blob_managed_identity: An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        :param pulumi.Input[_builtins.str] output_blob_uri: Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        :param pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]] parameters: A list of `parameter` blocks as defined below. The parameters used by the script.
        :param pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]] protected_parameters: A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        :param pulumi.Input[_builtins.str] run_as_password: Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] run_as_user: Specifies the user account on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input['RunCommandSourceArgs'] source: A `source` block as defined below. The source of the run command script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] virtual_machine_id: Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        if error_blob_managed_identity is not None:
            pulumi.set(__self__, "error_blob_managed_identity", error_blob_managed_identity)
        if error_blob_uri is not None:
            pulumi.set(__self__, "error_blob_uri", error_blob_uri)
        if instance_views is not None:
            pulumi.set(__self__, "instance_views", instance_views)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_blob_managed_identity is not None:
            pulumi.set(__self__, "output_blob_managed_identity", output_blob_managed_identity)
        if output_blob_uri is not None:
            pulumi.set(__self__, "output_blob_uri", output_blob_uri)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if protected_parameters is not None:
            pulumi.set(__self__, "protected_parameters", protected_parameters)
        if run_as_password is not None:
            pulumi.set(__self__, "run_as_password", run_as_password)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter(name="errorBlobManagedIdentity")
    def error_blob_managed_identity(self) -> Optional[pulumi.Input['RunCommandErrorBlobManagedIdentityArgs']]:
        """
        An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        """
        return pulumi.get(self, "error_blob_managed_identity")

    @error_blob_managed_identity.setter
    def error_blob_managed_identity(self, value: Optional[pulumi.Input['RunCommandErrorBlobManagedIdentityArgs']]):
        pulumi.set(self, "error_blob_managed_identity", value)

    @_builtins.property
    @pulumi.getter(name="errorBlobUri")
    def error_blob_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure storage blob where script error stream will be uploaded.
        """
        return pulumi.get(self, "error_blob_uri")

    @error_blob_uri.setter
    def error_blob_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_blob_uri", value)

    @_builtins.property
    @pulumi.getter(name="instanceViews")
    def instance_views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandInstanceViewArgs']]]]:
        return pulumi.get(self, "instance_views")

    @instance_views.setter
    def instance_views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandInstanceViewArgs']]]]):
        pulumi.set(self, "instance_views", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputBlobManagedIdentity")
    def output_blob_managed_identity(self) -> Optional[pulumi.Input['RunCommandOutputBlobManagedIdentityArgs']]:
        """
        An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        """
        return pulumi.get(self, "output_blob_managed_identity")

    @output_blob_managed_identity.setter
    def output_blob_managed_identity(self, value: Optional[pulumi.Input['RunCommandOutputBlobManagedIdentityArgs']]):
        pulumi.set(self, "output_blob_managed_identity", value)

    @_builtins.property
    @pulumi.getter(name="outputBlobUri")
    def output_blob_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        """
        return pulumi.get(self, "output_blob_uri")

    @output_blob_uri.setter
    def output_blob_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_blob_uri", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]]]:
        """
        A list of `parameter` blocks as defined below. The parameters used by the script.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="protectedParameters")
    def protected_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]]]:
        """
        A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        """
        return pulumi.get(self, "protected_parameters")

    @protected_parameters.setter
    def protected_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunCommandProtectedParameterArgs']]]]):
        pulumi.set(self, "protected_parameters", value)

    @_builtins.property
    @pulumi.getter(name="runAsPassword")
    def run_as_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        """
        return pulumi.get(self, "run_as_password")

    @run_as_password.setter
    def run_as_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_password", value)

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user account on the VM when executing the Virtual Machine Run Command.
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_user", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['RunCommandSourceArgs']]:
        """
        A `source` block as defined below. The source of the run command script.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['RunCommandSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Virtual Machine Run Command.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:compute/runCommand:RunCommand")
class RunCommand(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 error_blob_managed_identity: Optional[pulumi.Input[Union['RunCommandErrorBlobManagedIdentityArgs', 'RunCommandErrorBlobManagedIdentityArgsDict']]] = None,
                 error_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_blob_managed_identity: Optional[pulumi.Input[Union['RunCommandOutputBlobManagedIdentityArgs', 'RunCommandOutputBlobManagedIdentityArgsDict']]] = None,
                 output_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandParameterArgs', 'RunCommandParameterArgsDict']]]]] = None,
                 protected_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandProtectedParameterArgs', 'RunCommandProtectedParameterArgsDict']]]]] = None,
                 run_as_password: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['RunCommandSourceArgs', 'RunCommandSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Machine Run Command.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-uai",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-VM",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            size="Standard_B2s",
            admin_username="adminuser",
            admin_password="P@$$w0rd1234!",
            disable_password_authentication=False,
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Premium_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            identity={
                "type": "SystemAssigned, UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_account = azure.storage.Account("example",
            name="exampleaccount",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_container = azure.storage.Container("example",
            name="example-sc",
            storage_account_name=example_account.name,
            container_access_type="blob")
        example1 = azure.storage.Blob("example1",
            name="script1",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source_content="echo 'hello world'")
        example2 = azure.storage.Blob("example2",
            name="output",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Append")
        example3 = azure.storage.Blob("example3",
            name="error",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Append")
        example = azure.storage.get_account_sas_output(connection_string=example_account.primary_connection_string,
            https_only=True,
            signed_version="2019-10-10",
            start="2023-04-01T00:00:00Z",
            expiry="2024-04-01T00:00:00Z",
            resource_types={
                "service": False,
                "container": False,
                "object": True,
            },
            services={
                "blob": True,
                "queue": False,
                "table": False,
                "file": False,
            },
            permissions={
                "read": True,
                "write": True,
                "delete": False,
                "list": False,
                "add": True,
                "create": True,
                "update": False,
                "process": False,
                "tag": False,
                "filter": False,
            })
        # basic example
        example_run_command = azure.compute.RunCommand("example",
            name="example-vmrc",
            location=example_resource_group.location,
            virtual_machine_id=example_linux_virtual_machine.id,
            source={
                "script": "echo 'hello world'",
            })
        # authorize to storage blob using user assigned identity
        example2_run_command = azure.compute.RunCommand("example2",
            location=example_resource_group.location,
            name="example2-vmrc",
            virtual_machine_id=example_linux_virtual_machine.id,
            output_blob_uri=example2.id,
            error_blob_uri=example3.id,
            run_as_password="P@$$w0rd1234!",
            run_as_user="adminuser",
            source={
                "script_uri": example1.id,
                "script_uri_managed_identity": {
                    "client_id": example_user_assigned_identity.client_id,
                },
            },
            error_blob_managed_identity={
                "client_id": example_user_assigned_identity.client_id,
            },
            output_blob_managed_identity={
                "client_id": example_user_assigned_identity.client_id,
            },
            parameters=[{
                "name": "examplev1",
                "value": "val1",
            }],
            protected_parameters=[{
                "name": "examplev2",
                "value": "val2",
            }],
            tags={
                "environment": "terraform-examples",
                "some_key": "some-value",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        # authorize to storage blob using SAS token
        example3_run_command = azure.compute.RunCommand("example3",
            location=example_resource_group.location,
            name="example3-vmrc",
            virtual_machine_id=example_linux_virtual_machine.id,
            run_as_password="P@$$w0rd1234!",
            run_as_user="adminuser",
            error_blob_uri=pulumi.Output.all(
                id=example3.id,
                example=example
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}{resolved_outputs['example']}")
        ,
            output_blob_uri=pulumi.Output.all(
                id=example2.id,
                example=example
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}{resolved_outputs['example']}")
        ,
            source={
                "script_uri": pulumi.Output.all(
                    id=example1.id,
                    example=example
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}{resolved_outputs['example']}")
        ,
            },
            parameters=[{
                "name": "example-vm1",
                "value": "val1",
            }],
            tags={
                "environment": "terraform-example-s",
                "some_key": "some-value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2023-03-01

        ## Import

        An existing Virtual Machine Run Command can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/runCommand:RunCommand example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/vm1/runCommands/rc1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RunCommandErrorBlobManagedIdentityArgs', 'RunCommandErrorBlobManagedIdentityArgsDict']] error_blob_managed_identity: An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        :param pulumi.Input[_builtins.str] error_blob_uri: Specifies the Azure storage blob where script error stream will be uploaded.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input[Union['RunCommandOutputBlobManagedIdentityArgs', 'RunCommandOutputBlobManagedIdentityArgsDict']] output_blob_managed_identity: An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        :param pulumi.Input[_builtins.str] output_blob_uri: Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunCommandParameterArgs', 'RunCommandParameterArgsDict']]]] parameters: A list of `parameter` blocks as defined below. The parameters used by the script.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunCommandProtectedParameterArgs', 'RunCommandProtectedParameterArgsDict']]]] protected_parameters: A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        :param pulumi.Input[_builtins.str] run_as_password: Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] run_as_user: Specifies the user account on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[Union['RunCommandSourceArgs', 'RunCommandSourceArgsDict']] source: A `source` block as defined below. The source of the run command script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] virtual_machine_id: Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RunCommandArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Machine Run Command.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-uai",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-VM",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            size="Standard_B2s",
            admin_username="adminuser",
            admin_password="P@$$w0rd1234!",
            disable_password_authentication=False,
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Premium_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            identity={
                "type": "SystemAssigned, UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_account = azure.storage.Account("example",
            name="exampleaccount",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_container = azure.storage.Container("example",
            name="example-sc",
            storage_account_name=example_account.name,
            container_access_type="blob")
        example1 = azure.storage.Blob("example1",
            name="script1",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Block",
            source_content="echo 'hello world'")
        example2 = azure.storage.Blob("example2",
            name="output",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Append")
        example3 = azure.storage.Blob("example3",
            name="error",
            storage_account_name=example_account.name,
            storage_container_name=example_container.name,
            type="Append")
        example = azure.storage.get_account_sas_output(connection_string=example_account.primary_connection_string,
            https_only=True,
            signed_version="2019-10-10",
            start="2023-04-01T00:00:00Z",
            expiry="2024-04-01T00:00:00Z",
            resource_types={
                "service": False,
                "container": False,
                "object": True,
            },
            services={
                "blob": True,
                "queue": False,
                "table": False,
                "file": False,
            },
            permissions={
                "read": True,
                "write": True,
                "delete": False,
                "list": False,
                "add": True,
                "create": True,
                "update": False,
                "process": False,
                "tag": False,
                "filter": False,
            })
        # basic example
        example_run_command = azure.compute.RunCommand("example",
            name="example-vmrc",
            location=example_resource_group.location,
            virtual_machine_id=example_linux_virtual_machine.id,
            source={
                "script": "echo 'hello world'",
            })
        # authorize to storage blob using user assigned identity
        example2_run_command = azure.compute.RunCommand("example2",
            location=example_resource_group.location,
            name="example2-vmrc",
            virtual_machine_id=example_linux_virtual_machine.id,
            output_blob_uri=example2.id,
            error_blob_uri=example3.id,
            run_as_password="P@$$w0rd1234!",
            run_as_user="adminuser",
            source={
                "script_uri": example1.id,
                "script_uri_managed_identity": {
                    "client_id": example_user_assigned_identity.client_id,
                },
            },
            error_blob_managed_identity={
                "client_id": example_user_assigned_identity.client_id,
            },
            output_blob_managed_identity={
                "client_id": example_user_assigned_identity.client_id,
            },
            parameters=[{
                "name": "examplev1",
                "value": "val1",
            }],
            protected_parameters=[{
                "name": "examplev2",
                "value": "val2",
            }],
            tags={
                "environment": "terraform-examples",
                "some_key": "some-value",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        # authorize to storage blob using SAS token
        example3_run_command = azure.compute.RunCommand("example3",
            location=example_resource_group.location,
            name="example3-vmrc",
            virtual_machine_id=example_linux_virtual_machine.id,
            run_as_password="P@$$w0rd1234!",
            run_as_user="adminuser",
            error_blob_uri=pulumi.Output.all(
                id=example3.id,
                example=example
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}{resolved_outputs['example']}")
        ,
            output_blob_uri=pulumi.Output.all(
                id=example2.id,
                example=example
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}{resolved_outputs['example']}")
        ,
            source={
                "script_uri": pulumi.Output.all(
                    id=example1.id,
                    example=example
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}{resolved_outputs['example']}")
        ,
            },
            parameters=[{
                "name": "example-vm1",
                "value": "val1",
            }],
            tags={
                "environment": "terraform-example-s",
                "some_key": "some-value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2023-03-01

        ## Import

        An existing Virtual Machine Run Command can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/runCommand:RunCommand example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/vm1/runCommands/rc1
        ```

        :param str resource_name: The name of the resource.
        :param RunCommandArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RunCommandArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 error_blob_managed_identity: Optional[pulumi.Input[Union['RunCommandErrorBlobManagedIdentityArgs', 'RunCommandErrorBlobManagedIdentityArgsDict']]] = None,
                 error_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_blob_managed_identity: Optional[pulumi.Input[Union['RunCommandOutputBlobManagedIdentityArgs', 'RunCommandOutputBlobManagedIdentityArgsDict']]] = None,
                 output_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandParameterArgs', 'RunCommandParameterArgsDict']]]]] = None,
                 protected_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandProtectedParameterArgs', 'RunCommandProtectedParameterArgsDict']]]]] = None,
                 run_as_password: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['RunCommandSourceArgs', 'RunCommandSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RunCommandArgs.__new__(RunCommandArgs)

            __props__.__dict__["error_blob_managed_identity"] = None if error_blob_managed_identity is None else pulumi.Output.secret(error_blob_managed_identity)
            __props__.__dict__["error_blob_uri"] = error_blob_uri
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["output_blob_managed_identity"] = None if output_blob_managed_identity is None else pulumi.Output.secret(output_blob_managed_identity)
            __props__.__dict__["output_blob_uri"] = output_blob_uri
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["protected_parameters"] = None if protected_parameters is None else pulumi.Output.secret(protected_parameters)
            __props__.__dict__["run_as_password"] = None if run_as_password is None else pulumi.Output.secret(run_as_password)
            __props__.__dict__["run_as_user"] = run_as_user
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
            __props__.__dict__["instance_views"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["errorBlobManagedIdentity", "outputBlobManagedIdentity", "protectedParameters", "runAsPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RunCommand, __self__).__init__(
            'azure:compute/runCommand:RunCommand',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            error_blob_managed_identity: Optional[pulumi.Input[Union['RunCommandErrorBlobManagedIdentityArgs', 'RunCommandErrorBlobManagedIdentityArgsDict']]] = None,
            error_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
            instance_views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandInstanceViewArgs', 'RunCommandInstanceViewArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_blob_managed_identity: Optional[pulumi.Input[Union['RunCommandOutputBlobManagedIdentityArgs', 'RunCommandOutputBlobManagedIdentityArgsDict']]] = None,
            output_blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandParameterArgs', 'RunCommandParameterArgsDict']]]]] = None,
            protected_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunCommandProtectedParameterArgs', 'RunCommandProtectedParameterArgsDict']]]]] = None,
            run_as_password: Optional[pulumi.Input[_builtins.str]] = None,
            run_as_user: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['RunCommandSourceArgs', 'RunCommandSourceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RunCommand':
        """
        Get an existing RunCommand resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RunCommandErrorBlobManagedIdentityArgs', 'RunCommandErrorBlobManagedIdentityArgsDict']] error_blob_managed_identity: An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        :param pulumi.Input[_builtins.str] error_blob_uri: Specifies the Azure storage blob where script error stream will be uploaded.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        :param pulumi.Input[Union['RunCommandOutputBlobManagedIdentityArgs', 'RunCommandOutputBlobManagedIdentityArgsDict']] output_blob_managed_identity: An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        :param pulumi.Input[_builtins.str] output_blob_uri: Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunCommandParameterArgs', 'RunCommandParameterArgsDict']]]] parameters: A list of `parameter` blocks as defined below. The parameters used by the script.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunCommandProtectedParameterArgs', 'RunCommandProtectedParameterArgsDict']]]] protected_parameters: A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        :param pulumi.Input[_builtins.str] run_as_password: Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] run_as_user: Specifies the user account on the VM when executing the Virtual Machine Run Command.
        :param pulumi.Input[Union['RunCommandSourceArgs', 'RunCommandSourceArgsDict']] source: A `source` block as defined below. The source of the run command script.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Virtual Machine Run Command.
        :param pulumi.Input[_builtins.str] virtual_machine_id: Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RunCommandState.__new__(_RunCommandState)

        __props__.__dict__["error_blob_managed_identity"] = error_blob_managed_identity
        __props__.__dict__["error_blob_uri"] = error_blob_uri
        __props__.__dict__["instance_views"] = instance_views
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["output_blob_managed_identity"] = output_blob_managed_identity
        __props__.__dict__["output_blob_uri"] = output_blob_uri
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["protected_parameters"] = protected_parameters
        __props__.__dict__["run_as_password"] = run_as_password
        __props__.__dict__["run_as_user"] = run_as_user
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return RunCommand(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="errorBlobManagedIdentity")
    def error_blob_managed_identity(self) -> pulumi.Output[Optional['outputs.RunCommandErrorBlobManagedIdentity']]:
        """
        An `error_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to errorBlobUri storage blob.
        """
        return pulumi.get(self, "error_blob_managed_identity")

    @_builtins.property
    @pulumi.getter(name="errorBlobUri")
    def error_blob_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Azure storage blob where script error stream will be uploaded.
        """
        return pulumi.get(self, "error_blob_uri")

    @_builtins.property
    @pulumi.getter(name="instanceViews")
    def instance_views(self) -> pulumi.Output[Sequence['outputs.RunCommandInstanceView']]:
        return pulumi.get(self, "instance_views")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Virtual Machine Run Command. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputBlobManagedIdentity")
    def output_blob_managed_identity(self) -> pulumi.Output[Optional['outputs.RunCommandOutputBlobManagedIdentity']]:
        """
        An `output_blob_managed_identity` block as defined below. User-assigned managed Identity that has access to outputBlobUri storage blob.
        """
        return pulumi.get(self, "output_blob_managed_identity")

    @_builtins.property
    @pulumi.getter(name="outputBlobUri")
    def output_blob_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Azure storage blob where script output stream will be uploaded. It can be basic blob URI with SAS token.
        """
        return pulumi.get(self, "output_blob_uri")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.RunCommandParameter']]]:
        """
        A list of `parameter` blocks as defined below. The parameters used by the script.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="protectedParameters")
    def protected_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.RunCommandProtectedParameter']]]:
        """
        A list of `protected_parameter` blocks as defined below. The protected parameters used by the script.
        """
        return pulumi.get(self, "protected_parameters")

    @_builtins.property
    @pulumi.getter(name="runAsPassword")
    def run_as_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the user account password on the VM when executing the Virtual Machine Run Command.
        """
        return pulumi.get(self, "run_as_password")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the user account on the VM when executing the Virtual Machine Run Command.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.RunCommandSource']:
        """
        A `source` block as defined below. The source of the run command script.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Virtual Machine Run Command.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Virtual Machine ID within which this Virtual Machine Run Command should exist. Changing this forces a new Virtual Machine Run Command to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

