# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SharedImageVersionArgs', 'SharedImageVersion']

@pulumi.input_type
class SharedImageVersionArgs:
    def __init__(__self__, *,
                 gallery_name: pulumi.Input[_builtins.str],
                 image_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 target_regions: pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]],
                 blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_of_replicated_locations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SharedImageVersion resource.
        :param pulumi.Input[_builtins.str] gallery_name: The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_name: The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]] target_regions: One or more `target_region` blocks as documented below.
        :param pulumi.Input[_builtins.str] blob_uri: URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[_builtins.bool] deletion_of_replicated_locations_enabled: Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_image_id: The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] name: The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_disk_snapshot_id: The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] replication_mode: Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A collection of tags which should be applied to this resource.
        """
        pulumi.set(__self__, "gallery_name", gallery_name)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "target_regions", target_regions)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if deletion_of_replicated_locations_enabled is not None:
            pulumi.set(__self__, "deletion_of_replicated_locations_enabled", deletion_of_replicated_locations_enabled)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_image_id is not None:
            pulumi.set(__self__, "managed_image_id", managed_image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_disk_snapshot_id is not None:
            pulumi.set(__self__, "os_disk_snapshot_id", os_disk_snapshot_id)
        if replication_mode is not None:
            pulumi.set(__self__, "replication_mode", replication_mode)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_name")

    @gallery_name.setter
    def gallery_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gallery_name", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]]:
        """
        One or more `target_region` blocks as documented below.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]]):
        pulumi.set(self, "target_regions", value)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.

        > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        """
        return pulumi.get(self, "blob_uri")

    @blob_uri.setter
    def blob_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_uri", value)

    @_builtins.property
    @pulumi.getter(name="deletionOfReplicatedLocationsEnabled")
    def deletion_of_replicated_locations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "deletion_of_replicated_locations_enabled")

    @deletion_of_replicated_locations_enabled.setter
    def deletion_of_replicated_locations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_of_replicated_locations_enabled", value)

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Image Version.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedImageId")
    def managed_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.

        > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        """
        return pulumi.get(self, "managed_image_id")

    @managed_image_id.setter
    def managed_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_image_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osDiskSnapshotId")
    def os_disk_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        """
        return pulumi.get(self, "os_disk_snapshot_id")

    @os_disk_snapshot_id.setter
    def os_disk_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "replication_mode")

    @replication_mode.setter
    def replication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_mode", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.

        > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A collection of tags which should be applied to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SharedImageVersionState:
    def __init__(__self__, *,
                 blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_of_replicated_locations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]]] = None):
        """
        Input properties used for looking up and filtering SharedImageVersion resources.
        :param pulumi.Input[_builtins.str] blob_uri: URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[_builtins.bool] deletion_of_replicated_locations_enabled: Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] gallery_name: The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_name: The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_image_id: The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] name: The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_disk_snapshot_id: The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] replication_mode: Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A collection of tags which should be applied to this resource.
        :param pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]] target_regions: One or more `target_region` blocks as documented below.
        """
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if deletion_of_replicated_locations_enabled is not None:
            pulumi.set(__self__, "deletion_of_replicated_locations_enabled", deletion_of_replicated_locations_enabled)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if gallery_name is not None:
            pulumi.set(__self__, "gallery_name", gallery_name)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_image_id is not None:
            pulumi.set(__self__, "managed_image_id", managed_image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_disk_snapshot_id is not None:
            pulumi.set(__self__, "os_disk_snapshot_id", os_disk_snapshot_id)
        if replication_mode is not None:
            pulumi.set(__self__, "replication_mode", replication_mode)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.

        > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        """
        return pulumi.get(self, "blob_uri")

    @blob_uri.setter
    def blob_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_uri", value)

    @_builtins.property
    @pulumi.getter(name="deletionOfReplicatedLocationsEnabled")
    def deletion_of_replicated_locations_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "deletion_of_replicated_locations_enabled")

    @deletion_of_replicated_locations_enabled.setter
    def deletion_of_replicated_locations_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_of_replicated_locations_enabled", value)

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Image Version.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @_builtins.property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_name")

    @gallery_name.setter
    def gallery_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gallery_name", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedImageId")
    def managed_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.

        > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        """
        return pulumi.get(self, "managed_image_id")

    @managed_image_id.setter
    def managed_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_image_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osDiskSnapshotId")
    def os_disk_snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        """
        return pulumi.get(self, "os_disk_snapshot_id")

    @os_disk_snapshot_id.setter
    def os_disk_snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "replication_mode")

    @replication_mode.setter
    def replication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_mode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.

        > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A collection of tags which should be applied to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]]]:
        """
        One or more `target_region` blocks as documented below.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SharedImageVersionTargetRegionArgs']]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.type_token("azure:compute/sharedImageVersion:SharedImageVersion")
class SharedImageVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_of_replicated_locations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SharedImageVersionTargetRegionArgs', 'SharedImageVersionTargetRegionArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Version of a Shared Image within a Shared Image Gallery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        existing = azure.compute.get_image(name="search-api",
            resource_group_name="packerimages")
        existing_get_shared_image = azure.compute.get_shared_image(name="existing-image",
            gallery_name="existing_gallery",
            resource_group_name="existing-resources")
        example = azure.compute.SharedImageVersion("example",
            name="0.0.1",
            gallery_name=existing_get_shared_image.gallery_name,
            image_name=existing_get_shared_image.name,
            resource_group_name=existing_get_shared_image.resource_group_name,
            location=existing_get_shared_image.location,
            managed_image_id=existing.id,
            target_regions=[{
                "name": existing_get_shared_image.location,
                "regional_replica_count": 5,
                "storage_account_type": "Standard_LRS",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2023-07-03

        ## Import

        Shared Image Versions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/sharedImageVersion:SharedImageVersion version /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/galleries/gallery1/images/image1/versions/1.2.3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] blob_uri: URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[_builtins.bool] deletion_of_replicated_locations_enabled: Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] gallery_name: The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_name: The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_image_id: The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] name: The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_disk_snapshot_id: The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] replication_mode: Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A collection of tags which should be applied to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SharedImageVersionTargetRegionArgs', 'SharedImageVersionTargetRegionArgsDict']]]] target_regions: One or more `target_region` blocks as documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedImageVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Version of a Shared Image within a Shared Image Gallery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        existing = azure.compute.get_image(name="search-api",
            resource_group_name="packerimages")
        existing_get_shared_image = azure.compute.get_shared_image(name="existing-image",
            gallery_name="existing_gallery",
            resource_group_name="existing-resources")
        example = azure.compute.SharedImageVersion("example",
            name="0.0.1",
            gallery_name=existing_get_shared_image.gallery_name,
            image_name=existing_get_shared_image.name,
            resource_group_name=existing_get_shared_image.resource_group_name,
            location=existing_get_shared_image.location,
            managed_image_id=existing.id,
            target_regions=[{
                "name": existing_get_shared_image.location,
                "regional_replica_count": 5,
                "storage_account_type": "Standard_LRS",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2023-07-03

        ## Import

        Shared Image Versions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/sharedImageVersion:SharedImageVersion version /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/galleries/gallery1/images/image1/versions/1.2.3
        ```

        :param str resource_name: The name of the resource.
        :param SharedImageVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedImageVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_of_replicated_locations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SharedImageVersionTargetRegionArgs', 'SharedImageVersionTargetRegionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedImageVersionArgs.__new__(SharedImageVersionArgs)

            __props__.__dict__["blob_uri"] = blob_uri
            __props__.__dict__["deletion_of_replicated_locations_enabled"] = deletion_of_replicated_locations_enabled
            __props__.__dict__["end_of_life_date"] = end_of_life_date
            __props__.__dict__["exclude_from_latest"] = exclude_from_latest
            if gallery_name is None and not opts.urn:
                raise TypeError("Missing required property 'gallery_name'")
            __props__.__dict__["gallery_name"] = gallery_name
            if image_name is None and not opts.urn:
                raise TypeError("Missing required property 'image_name'")
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_image_id"] = managed_image_id
            __props__.__dict__["name"] = name
            __props__.__dict__["os_disk_snapshot_id"] = os_disk_snapshot_id
            __props__.__dict__["replication_mode"] = replication_mode
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["tags"] = tags
            if target_regions is None and not opts.urn:
                raise TypeError("Missing required property 'target_regions'")
            __props__.__dict__["target_regions"] = target_regions
        super(SharedImageVersion, __self__).__init__(
            'azure:compute/sharedImageVersion:SharedImageVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blob_uri: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_of_replicated_locations_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_from_latest: Optional[pulumi.Input[_builtins.bool]] = None,
            gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_disk_snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SharedImageVersionTargetRegionArgs', 'SharedImageVersionTargetRegionArgsDict']]]]] = None) -> 'SharedImageVersion':
        """
        Get an existing SharedImageVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] blob_uri: URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[_builtins.bool] deletion_of_replicated_locations_enabled: Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image Version.
        :param pulumi.Input[_builtins.bool] exclude_from_latest: Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        :param pulumi.Input[_builtins.str] gallery_name: The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_name: The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_image_id: The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] name: The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_disk_snapshot_id: The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.
               
               > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        :param pulumi.Input[_builtins.str] replication_mode: Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.
               
               > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A collection of tags which should be applied to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SharedImageVersionTargetRegionArgs', 'SharedImageVersionTargetRegionArgsDict']]]] target_regions: One or more `target_region` blocks as documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedImageVersionState.__new__(_SharedImageVersionState)

        __props__.__dict__["blob_uri"] = blob_uri
        __props__.__dict__["deletion_of_replicated_locations_enabled"] = deletion_of_replicated_locations_enabled
        __props__.__dict__["end_of_life_date"] = end_of_life_date
        __props__.__dict__["exclude_from_latest"] = exclude_from_latest
        __props__.__dict__["gallery_name"] = gallery_name
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_image_id"] = managed_image_id
        __props__.__dict__["name"] = name
        __props__.__dict__["os_disk_snapshot_id"] = os_disk_snapshot_id
        __props__.__dict__["replication_mode"] = replication_mode
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_regions"] = target_regions
        return SharedImageVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URI of the Azure Storage Blob used to create the Image Version. Changing this forces a new resource to be created.

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.

        > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter(name="deletionOfReplicatedLocationsEnabled")
    def deletion_of_replicated_locations_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether this Shared Image Version can be deleted from the Azure Regions this is replicated to. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "deletion_of_replicated_locations_enabled")

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Image Version.
        """
        return pulumi.get(self, "end_of_life_date")

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Image Version be excluded from the `latest` filter? If set to `true` this Image Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @_builtins.property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Shared Image Gallery in which the Shared Image exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_name")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Shared Image within the Shared Image Gallery in which this Version should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedImageId")
    def managed_image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Managed Image or Virtual Machine ID which should be used for this Shared Image Version. Changing this forces a new resource to be created.

        > **NOTE:** The ID can be sourced from the `compute.Image` data source or resource

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        """
        return pulumi.get(self, "managed_image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The version number for this Image Version, such as `1.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osDiskSnapshotId")
    def os_disk_snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the OS disk snapshot which should be used for this Shared Image Version. Changing this forces a new resource to be created.

        > **NOTE:** You must specify exact one of `blob_uri`, `managed_image_id` and `os_disk_snapshot_id`.
        """
        return pulumi.get(self, "os_disk_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="replicationMode")
    def replication_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mode to be used for replication. Possible values are `Full` and `Shallow`. Defaults to `Full`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "replication_mode")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Storage Account where the Blob exists. Changing this forces a new resource to be created.

        > **NOTE:** `blob_uri` and `storage_account_id` must be specified together
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A collection of tags which should be applied to this resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> pulumi.Output[Sequence['outputs.SharedImageVersionTargetRegion']]:
        """
        One or more `target_region` blocks as documented below.
        """
        return pulumi.get(self, "target_regions")

