# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WindowsVirtualMachineArgs', 'WindowsVirtualMachine']

@pulumi.input_type
class WindowsVirtualMachineArgs:
    def __init__(__self__, *,
                 network_interface_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 os_disk: pulumi.Input['WindowsVirtualMachineOsDiskArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.str],
                 additional_capabilities: Optional[pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs']] = None,
                 additional_unattend_contents: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_extension_operations: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_diagnostics: Optional[pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs']] = None,
                 bypass_platform_safety_checks_on_user_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_updates: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]]] = None,
                 hotpatching_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WindowsVirtualMachineIdentityArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_image_notification: Optional[pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs']] = None,
                 os_managed_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_assessment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['WindowsVirtualMachinePlanArgs']] = None,
                 platform_fault_domain: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reboot_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_agent_platform_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 winrm_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WindowsVirtualMachine resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interface_ids: . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        :param pulumi.Input['WindowsVirtualMachineOsDiskArgs'] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        :param pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs'] additional_capabilities: A `additional_capabilities` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]] additional_unattend_contents: One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.bool] allow_extension_operations: Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_updates_enabled: Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_set_id: Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.bool] bypass_platform_safety_checks_on_user_schedule_enabled: Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.
               
               > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.
               
               > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        :param pulumi.Input[_builtins.str] computer_name: Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        :param pulumi.Input[_builtins.str] disk_controller_type: Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]] gallery_applications: One or more `gallery_application` blocks as defined below.
               
               > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        :param pulumi.Input[_builtins.bool] hotpatching_enabled: Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).
               
               > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        :param pulumi.Input['WindowsVirtualMachineIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs'] os_image_notification: A `os_image_notification` block as defined below.
        :param pulumi.Input[_builtins.str] os_managed_disk_id: The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.
               
               > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        :param pulumi.Input[_builtins.str] patch_assessment_mode: Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.
               
               > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        :param pulumi.Input[_builtins.str] patch_mode: Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).
               
               > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        :param pulumi.Input['WindowsVirtualMachinePlanArgs'] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain: Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.
               
               > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        :param pulumi.Input[_builtins.str] reboot_setting: Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.
               
               > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs'] source_image_reference: A `source_image_reference` block as defined below. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine.
        :param pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs'] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] timezone: Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine.
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.
               
               > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.
               
               > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).
               
               > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        :param pulumi.Input[_builtins.bool] vm_agent_platform_updates_enabled: Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]] winrm_listeners: One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        pulumi.set(__self__, "os_disk", os_disk)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "size", size)
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if additional_unattend_contents is not None:
            pulumi.set(__self__, "additional_unattend_contents", additional_unattend_contents)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if allow_extension_operations is not None:
            pulumi.set(__self__, "allow_extension_operations", allow_extension_operations)
        if automatic_updates_enabled is not None:
            pulumi.set(__self__, "automatic_updates_enabled", automatic_updates_enabled)
        if availability_set_id is not None:
            pulumi.set(__self__, "availability_set_id", availability_set_id)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if bypass_platform_safety_checks_on_user_schedule_enabled is not None:
            pulumi.set(__self__, "bypass_platform_safety_checks_on_user_schedule_enabled", bypass_platform_safety_checks_on_user_schedule_enabled)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if disk_controller_type is not None:
            pulumi.set(__self__, "disk_controller_type", disk_controller_type)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if enable_automatic_updates is not None:
            warnings.warn("""this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""", DeprecationWarning)
            pulumi.log.warn("""enable_automatic_updates is deprecated: this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""")
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)
        if gallery_applications is not None:
            pulumi.set(__self__, "gallery_applications", gallery_applications)
        if hotpatching_enabled is not None:
            pulumi.set(__self__, "hotpatching_enabled", hotpatching_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_bid_price is not None:
            pulumi.set(__self__, "max_bid_price", max_bid_price)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_image_notification is not None:
            pulumi.set(__self__, "os_image_notification", os_image_notification)
        if os_managed_disk_id is not None:
            pulumi.set(__self__, "os_managed_disk_id", os_managed_disk_id)
        if patch_assessment_mode is not None:
            pulumi.set(__self__, "patch_assessment_mode", patch_assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_image_reference is not None:
            pulumi.set(__self__, "source_image_reference", source_image_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_notification is not None:
            pulumi.set(__self__, "termination_notification", termination_notification)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if virtual_machine_scale_set_id is not None:
            pulumi.set(__self__, "virtual_machine_scale_set_id", virtual_machine_scale_set_id)
        if vm_agent_platform_updates_enabled is not None:
            warnings.warn("""this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""", DeprecationWarning)
            pulumi.log.warn("""vm_agent_platform_updates_enabled is deprecated: this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""")
        if vm_agent_platform_updates_enabled is not None:
            pulumi.set(__self__, "vm_agent_platform_updates_enabled", vm_agent_platform_updates_enabled)
        if vtpm_enabled is not None:
            pulumi.set(__self__, "vtpm_enabled", vtpm_enabled)
        if winrm_listeners is not None:
            pulumi.set(__self__, "winrm_listeners", winrm_listeners)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "network_interface_ids", value)

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Input['WindowsVirtualMachineOsDiskArgs']:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: pulumi.Input['WindowsVirtualMachineOsDiskArgs']):
        pulumi.set(self, "os_disk", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs']]:
        """
        A `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @_builtins.property
    @pulumi.getter(name="additionalUnattendContents")
    def additional_unattend_contents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]]]:
        """
        One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "additional_unattend_contents")

    @additional_unattend_contents.setter
    def additional_unattend_contents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]]]):
        pulumi.set(self, "additional_unattend_contents", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="allowExtensionOperations")
    def allow_extension_operations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        """
        return pulumi.get(self, "allow_extension_operations")

    @allow_extension_operations.setter
    def allow_extension_operations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_extension_operations", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpdatesEnabled")
    def automatic_updates_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        """
        return pulumi.get(self, "automatic_updates_enabled")

    @automatic_updates_enabled.setter
    def automatic_updates_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_updates_enabled", value)

    @_builtins.property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "availability_set_id")

    @availability_set_id.setter
    def availability_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_set_id", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="bypassPlatformSafetyChecksOnUserScheduleEnabled")
    def bypass_platform_safety_checks_on_user_schedule_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.

        > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "bypass_platform_safety_checks_on_user_schedule_enabled")

    @bypass_platform_safety_checks_on_user_schedule_enabled.setter
    def bypass_platform_safety_checks_on_user_schedule_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_platform_safety_checks_on_user_schedule_enabled", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.

        > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "computer_name", value)

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_data", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @_builtins.property
    @pulumi.getter(name="diskControllerType")
    def disk_controller_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        """
        return pulumi.get(self, "disk_controller_type")

    @disk_controller_type.setter
    def disk_controller_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_controller_type", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    @_utilities.deprecated("""this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""")
    def enable_automatic_updates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_automatic_updates")

    @enable_automatic_updates.setter
    def enable_automatic_updates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_automatic_updates", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extensions_time_budget", value)

    @_builtins.property
    @pulumi.getter(name="galleryApplications")
    def gallery_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]]]:
        """
        One or more `gallery_application` blocks as defined below.

        > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        """
        return pulumi.get(self, "gallery_applications")

    @gallery_applications.setter
    def gallery_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]]]):
        pulumi.set(self, "gallery_applications", value)

    @_builtins.property
    @pulumi.getter(name="hotpatchingEnabled")
    def hotpatching_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).

        > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        """
        return pulumi.get(self, "hotpatching_enabled")

    @hotpatching_enabled.setter
    def hotpatching_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hotpatching_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WindowsVirtualMachineIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WindowsVirtualMachineIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.

        > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "max_bid_price")

    @max_bid_price.setter
    def max_bid_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_bid_price", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osImageNotification")
    def os_image_notification(self) -> Optional[pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs']]:
        """
        A `os_image_notification` block as defined below.
        """
        return pulumi.get(self, "os_image_notification")

    @os_image_notification.setter
    def os_image_notification(self, value: Optional[pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs']]):
        pulumi.set(self, "os_image_notification", value)

    @_builtins.property
    @pulumi.getter(name="osManagedDiskId")
    def os_managed_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.

        > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        """
        return pulumi.get(self, "os_managed_disk_id")

    @os_managed_disk_id.setter
    def os_managed_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_managed_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="patchAssessmentMode")
    def patch_assessment_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.

        > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        """
        return pulumi.get(self, "patch_assessment_mode")

    @patch_assessment_mode.setter
    def patch_assessment_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_assessment_mode", value)

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).

        > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "patch_mode")

    @patch_mode.setter
    def patch_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_mode", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['WindowsVirtualMachinePlanArgs']]:
        """
        A `plan` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['WindowsVirtualMachinePlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "platform_fault_domain")

    @platform_fault_domain.setter
    def platform_fault_domain(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "platform_fault_domain", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.

        > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        """
        return pulumi.get(self, "provision_vm_agent")

    @provision_vm_agent.setter
    def provision_vm_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provision_vm_agent", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.

        > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "reboot_setting")

    @reboot_setting.setter
    def reboot_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reboot_setting", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @secure_boot_enabled.setter
    def secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.

        > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> Optional[pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs']]:
        """
        A `source_image_reference` block as defined below. Changing this forces a new resource to be created.

        > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_reference")

    @source_image_reference.setter
    def source_image_reference(self, value: Optional[pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs']]):
        pulumi.set(self, "source_image_reference", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> Optional[pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs']]:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @termination_notification.setter
    def termination_notification(self, value: Optional[pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs']]):
        pulumi.set(self, "termination_notification", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineScaleSetId")
    def virtual_machine_scale_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.

        > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.

        > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).

        > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        """
        return pulumi.get(self, "virtual_machine_scale_set_id")

    @virtual_machine_scale_set_id.setter
    def virtual_machine_scale_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_scale_set_id", value)

    @_builtins.property
    @pulumi.getter(name="vmAgentPlatformUpdatesEnabled")
    @_utilities.deprecated("""this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""")
    def vm_agent_platform_updates_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "vm_agent_platform_updates_enabled")

    @vm_agent_platform_updates_enabled.setter
    def vm_agent_platform_updates_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vm_agent_platform_updates_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vtpm_enabled")

    @vtpm_enabled.setter
    def vtpm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vtpm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="winrmListeners")
    def winrm_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]]]:
        """
        One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "winrm_listeners")

    @winrm_listeners.setter
    def winrm_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]]]):
        pulumi.set(self, "winrm_listeners", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _WindowsVirtualMachineState:
    def __init__(__self__, *,
                 additional_capabilities: Optional[pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs']] = None,
                 additional_unattend_contents: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_extension_operations: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_diagnostics: Optional[pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs']] = None,
                 bypass_platform_safety_checks_on_user_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_updates: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]]] = None,
                 hotpatching_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WindowsVirtualMachineIdentityArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 os_disk: Optional[pulumi.Input['WindowsVirtualMachineOsDiskArgs']] = None,
                 os_image_notification: Optional[pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs']] = None,
                 os_managed_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_assessment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input['WindowsVirtualMachinePlanArgs']] = None,
                 platform_fault_domain: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 reboot_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_agent_platform_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 winrm_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WindowsVirtualMachine resources.
        :param pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs'] additional_capabilities: A `additional_capabilities` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]] additional_unattend_contents: One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.bool] allow_extension_operations: Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_updates_enabled: Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_set_id: Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.bool] bypass_platform_safety_checks_on_user_schedule_enabled: Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.
               
               > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.
               
               > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        :param pulumi.Input[_builtins.str] computer_name: Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        :param pulumi.Input[_builtins.str] disk_controller_type: Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]] gallery_applications: One or more `gallery_application` blocks as defined below.
               
               > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        :param pulumi.Input[_builtins.bool] hotpatching_enabled: Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).
               
               > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        :param pulumi.Input['WindowsVirtualMachineIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interface_ids: . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        :param pulumi.Input['WindowsVirtualMachineOsDiskArgs'] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs'] os_image_notification: A `os_image_notification` block as defined below.
        :param pulumi.Input[_builtins.str] os_managed_disk_id: The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.
               
               > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        :param pulumi.Input[_builtins.str] patch_assessment_mode: Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.
               
               > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        :param pulumi.Input[_builtins.str] patch_mode: Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).
               
               > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        :param pulumi.Input['WindowsVirtualMachinePlanArgs'] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain: Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The Primary Private IP Address assigned to this Virtual Machine.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: A list of Private IP Addresses assigned to this Virtual Machine.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.
               
               > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        :param pulumi.Input[_builtins.str] public_ip_address: The Primary Public IP Address assigned to this Virtual Machine.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_addresses: A list of the Public IP Addresses assigned to this Virtual Machine.
        :param pulumi.Input[_builtins.str] reboot_setting: Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.
               
               > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs'] source_image_reference: A `source_image_reference` block as defined below. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine.
        :param pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs'] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] timezone: Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine.
        :param pulumi.Input[_builtins.str] virtual_machine_id: A 128-bit identifier which uniquely identifies this Virtual Machine.
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.
               
               > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.
               
               > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).
               
               > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        :param pulumi.Input[_builtins.bool] vm_agent_platform_updates_enabled: Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]] winrm_listeners: One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if additional_unattend_contents is not None:
            pulumi.set(__self__, "additional_unattend_contents", additional_unattend_contents)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if allow_extension_operations is not None:
            pulumi.set(__self__, "allow_extension_operations", allow_extension_operations)
        if automatic_updates_enabled is not None:
            pulumi.set(__self__, "automatic_updates_enabled", automatic_updates_enabled)
        if availability_set_id is not None:
            pulumi.set(__self__, "availability_set_id", availability_set_id)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if bypass_platform_safety_checks_on_user_schedule_enabled is not None:
            pulumi.set(__self__, "bypass_platform_safety_checks_on_user_schedule_enabled", bypass_platform_safety_checks_on_user_schedule_enabled)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if disk_controller_type is not None:
            pulumi.set(__self__, "disk_controller_type", disk_controller_type)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if enable_automatic_updates is not None:
            warnings.warn("""this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""", DeprecationWarning)
            pulumi.log.warn("""enable_automatic_updates is deprecated: this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""")
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if encryption_at_host_enabled is not None:
            pulumi.set(__self__, "encryption_at_host_enabled", encryption_at_host_enabled)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extensions_time_budget is not None:
            pulumi.set(__self__, "extensions_time_budget", extensions_time_budget)
        if gallery_applications is not None:
            pulumi.set(__self__, "gallery_applications", gallery_applications)
        if hotpatching_enabled is not None:
            pulumi.set(__self__, "hotpatching_enabled", hotpatching_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_bid_price is not None:
            pulumi.set(__self__, "max_bid_price", max_bid_price)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if os_image_notification is not None:
            pulumi.set(__self__, "os_image_notification", os_image_notification)
        if os_managed_disk_id is not None:
            pulumi.set(__self__, "os_managed_disk_id", os_managed_disk_id)
        if patch_assessment_mode is not None:
            pulumi.set(__self__, "patch_assessment_mode", patch_assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if reboot_setting is not None:
            pulumi.set(__self__, "reboot_setting", reboot_setting)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_image_reference is not None:
            pulumi.set(__self__, "source_image_reference", source_image_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if termination_notification is not None:
            pulumi.set(__self__, "termination_notification", termination_notification)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_scale_set_id is not None:
            pulumi.set(__self__, "virtual_machine_scale_set_id", virtual_machine_scale_set_id)
        if vm_agent_platform_updates_enabled is not None:
            warnings.warn("""this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""", DeprecationWarning)
            pulumi.log.warn("""vm_agent_platform_updates_enabled is deprecated: this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""")
        if vm_agent_platform_updates_enabled is not None:
            pulumi.set(__self__, "vm_agent_platform_updates_enabled", vm_agent_platform_updates_enabled)
        if vtpm_enabled is not None:
            pulumi.set(__self__, "vtpm_enabled", vtpm_enabled)
        if winrm_listeners is not None:
            pulumi.set(__self__, "winrm_listeners", winrm_listeners)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs']]:
        """
        A `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['WindowsVirtualMachineAdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @_builtins.property
    @pulumi.getter(name="additionalUnattendContents")
    def additional_unattend_contents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]]]:
        """
        One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "additional_unattend_contents")

    @additional_unattend_contents.setter
    def additional_unattend_contents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineAdditionalUnattendContentArgs']]]]):
        pulumi.set(self, "additional_unattend_contents", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="allowExtensionOperations")
    def allow_extension_operations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        """
        return pulumi.get(self, "allow_extension_operations")

    @allow_extension_operations.setter
    def allow_extension_operations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_extension_operations", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpdatesEnabled")
    def automatic_updates_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        """
        return pulumi.get(self, "automatic_updates_enabled")

    @automatic_updates_enabled.setter
    def automatic_updates_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_updates_enabled", value)

    @_builtins.property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "availability_set_id")

    @availability_set_id.setter
    def availability_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_set_id", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['WindowsVirtualMachineBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="bypassPlatformSafetyChecksOnUserScheduleEnabled")
    def bypass_platform_safety_checks_on_user_schedule_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.

        > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "bypass_platform_safety_checks_on_user_schedule_enabled")

    @bypass_platform_safety_checks_on_user_schedule_enabled.setter
    def bypass_platform_safety_checks_on_user_schedule_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bypass_platform_safety_checks_on_user_schedule_enabled", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.

        > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "computer_name", value)

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_data", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @_builtins.property
    @pulumi.getter(name="diskControllerType")
    def disk_controller_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        """
        return pulumi.get(self, "disk_controller_type")

    @disk_controller_type.setter
    def disk_controller_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_controller_type", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    @_utilities.deprecated("""this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""")
    def enable_automatic_updates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_automatic_updates")

    @enable_automatic_updates.setter
    def enable_automatic_updates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_automatic_updates", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @encryption_at_host_enabled.setter
    def encryption_at_host_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_host_enabled", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @extensions_time_budget.setter
    def extensions_time_budget(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extensions_time_budget", value)

    @_builtins.property
    @pulumi.getter(name="galleryApplications")
    def gallery_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]]]:
        """
        One or more `gallery_application` blocks as defined below.

        > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        """
        return pulumi.get(self, "gallery_applications")

    @gallery_applications.setter
    def gallery_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineGalleryApplicationArgs']]]]):
        pulumi.set(self, "gallery_applications", value)

    @_builtins.property
    @pulumi.getter(name="hotpatchingEnabled")
    def hotpatching_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).

        > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        """
        return pulumi.get(self, "hotpatching_enabled")

    @hotpatching_enabled.setter
    def hotpatching_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hotpatching_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WindowsVirtualMachineIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WindowsVirtualMachineIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.

        > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "max_bid_price")

    @max_bid_price.setter
    def max_bid_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_bid_price", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_interface_ids", value)

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['WindowsVirtualMachineOsDiskArgs']]:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['WindowsVirtualMachineOsDiskArgs']]):
        pulumi.set(self, "os_disk", value)

    @_builtins.property
    @pulumi.getter(name="osImageNotification")
    def os_image_notification(self) -> Optional[pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs']]:
        """
        A `os_image_notification` block as defined below.
        """
        return pulumi.get(self, "os_image_notification")

    @os_image_notification.setter
    def os_image_notification(self, value: Optional[pulumi.Input['WindowsVirtualMachineOsImageNotificationArgs']]):
        pulumi.set(self, "os_image_notification", value)

    @_builtins.property
    @pulumi.getter(name="osManagedDiskId")
    def os_managed_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.

        > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        """
        return pulumi.get(self, "os_managed_disk_id")

    @os_managed_disk_id.setter
    def os_managed_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_managed_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="patchAssessmentMode")
    def patch_assessment_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.

        > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        """
        return pulumi.get(self, "patch_assessment_mode")

    @patch_assessment_mode.setter
    def patch_assessment_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_assessment_mode", value)

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).

        > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "patch_mode")

    @patch_mode.setter
    def patch_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_mode", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['WindowsVirtualMachinePlanArgs']]:
        """
        A `plan` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['WindowsVirtualMachinePlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "platform_fault_domain")

    @platform_fault_domain.setter
    def platform_fault_domain(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "platform_fault_domain", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Private IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Private IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_addresses")

    @private_ip_addresses.setter
    def private_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.

        > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        """
        return pulumi.get(self, "provision_vm_agent")

    @provision_vm_agent.setter
    def provision_vm_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provision_vm_agent", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Public IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the Public IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_addresses")

    @public_ip_addresses.setter
    def public_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.

        > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "reboot_setting")

    @reboot_setting.setter
    def reboot_setting(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reboot_setting", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @secure_boot_enabled.setter
    def secure_boot_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_boot_enabled", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.

        > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> Optional[pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs']]:
        """
        A `source_image_reference` block as defined below. Changing this forces a new resource to be created.

        > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_reference")

    @source_image_reference.setter
    def source_image_reference(self, value: Optional[pulumi.Input['WindowsVirtualMachineSourceImageReferenceArgs']]):
        pulumi.set(self, "source_image_reference", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> Optional[pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs']]:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @termination_notification.setter
    def termination_notification(self, value: Optional[pulumi.Input['WindowsVirtualMachineTerminationNotificationArgs']]):
        pulumi.set(self, "termination_notification", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A 128-bit identifier which uniquely identifies this Virtual Machine.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineScaleSetId")
    def virtual_machine_scale_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.

        > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.

        > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).

        > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        """
        return pulumi.get(self, "virtual_machine_scale_set_id")

    @virtual_machine_scale_set_id.setter
    def virtual_machine_scale_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_scale_set_id", value)

    @_builtins.property
    @pulumi.getter(name="vmAgentPlatformUpdatesEnabled")
    @_utilities.deprecated("""this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""")
    def vm_agent_platform_updates_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "vm_agent_platform_updates_enabled")

    @vm_agent_platform_updates_enabled.setter
    def vm_agent_platform_updates_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vm_agent_platform_updates_enabled", value)

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vtpm_enabled")

    @vtpm_enabled.setter
    def vtpm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vtpm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="winrmListeners")
    def winrm_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]]]:
        """
        One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "winrm_listeners")

    @winrm_listeners.setter
    def winrm_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineWinrmListenerArgs']]]]):
        pulumi.set(self, "winrm_listeners", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("azure:compute/windowsVirtualMachine:WindowsVirtualMachine")
class WindowsVirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[Union['WindowsVirtualMachineAdditionalCapabilitiesArgs', 'WindowsVirtualMachineAdditionalCapabilitiesArgsDict']]] = None,
                 additional_unattend_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineAdditionalUnattendContentArgs', 'WindowsVirtualMachineAdditionalUnattendContentArgsDict']]]]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_extension_operations: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['WindowsVirtualMachineBootDiagnosticsArgs', 'WindowsVirtualMachineBootDiagnosticsArgsDict']]] = None,
                 bypass_platform_safety_checks_on_user_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_updates: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineGalleryApplicationArgs', 'WindowsVirtualMachineGalleryApplicationArgsDict']]]]] = None,
                 hotpatching_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WindowsVirtualMachineIdentityArgs', 'WindowsVirtualMachineIdentityArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 os_disk: Optional[pulumi.Input[Union['WindowsVirtualMachineOsDiskArgs', 'WindowsVirtualMachineOsDiskArgsDict']]] = None,
                 os_image_notification: Optional[pulumi.Input[Union['WindowsVirtualMachineOsImageNotificationArgs', 'WindowsVirtualMachineOsImageNotificationArgsDict']]] = None,
                 os_managed_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_assessment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['WindowsVirtualMachinePlanArgs', 'WindowsVirtualMachinePlanArgsDict']]] = None,
                 platform_fault_domain: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reboot_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineSecretArgs', 'WindowsVirtualMachineSecretArgsDict']]]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input[Union['WindowsVirtualMachineSourceImageReferenceArgs', 'WindowsVirtualMachineSourceImageReferenceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input[Union['WindowsVirtualMachineTerminationNotificationArgs', 'WindowsVirtualMachineTerminationNotificationArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_agent_platform_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 winrm_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineWinrmListenerArgs', 'WindowsVirtualMachineWinrmListenerArgsDict']]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Windows Virtual Machine.

        ## Disclaimers

        > **Note** This provider will automatically remove the OS Disk by default - this behaviour can be configured using the `features` setting within the Provider block.

        > **Note** All arguments including the administrator login and password will be stored in the raw state as plain-text.

        > **Note** This resource does not support Unmanaged Disks. If you need to use Unmanaged Disks you can continue to use the `compute.VirtualMachine` resource instead.

        > **Note** This resource does not support attaching existing OS Disks. You can instead capture an image of the OS Disk or continue to use the `compute.VirtualMachine` resource instead.

        > In this release there's a known issue where the `public_ip_address` and `public_ip_addresses` fields may not be fully populated for Dynamic Public IP's.

        ## Example Usage

        This example provisions a basic Windows Virtual Machine on an internal network.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_windows_virtual_machine = azure.compute.WindowsVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            admin_password="P@$$w0rd1234!",
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "sku": "2016-Datacenter",
                "version": "latest",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2024-03-01, 2023-04-02

        ## Import

        Windows Virtual Machines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/windowsVirtualMachine:WindowsVirtualMachine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/machine1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WindowsVirtualMachineAdditionalCapabilitiesArgs', 'WindowsVirtualMachineAdditionalCapabilitiesArgsDict']] additional_capabilities: A `additional_capabilities` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineAdditionalUnattendContentArgs', 'WindowsVirtualMachineAdditionalUnattendContentArgsDict']]]] additional_unattend_contents: One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.bool] allow_extension_operations: Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_updates_enabled: Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_set_id: Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WindowsVirtualMachineBootDiagnosticsArgs', 'WindowsVirtualMachineBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.bool] bypass_platform_safety_checks_on_user_schedule_enabled: Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.
               
               > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.
               
               > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        :param pulumi.Input[_builtins.str] computer_name: Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        :param pulumi.Input[_builtins.str] disk_controller_type: Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineGalleryApplicationArgs', 'WindowsVirtualMachineGalleryApplicationArgsDict']]]] gallery_applications: One or more `gallery_application` blocks as defined below.
               
               > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        :param pulumi.Input[_builtins.bool] hotpatching_enabled: Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).
               
               > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        :param pulumi.Input[Union['WindowsVirtualMachineIdentityArgs', 'WindowsVirtualMachineIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interface_ids: . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        :param pulumi.Input[Union['WindowsVirtualMachineOsDiskArgs', 'WindowsVirtualMachineOsDiskArgsDict']] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[Union['WindowsVirtualMachineOsImageNotificationArgs', 'WindowsVirtualMachineOsImageNotificationArgsDict']] os_image_notification: A `os_image_notification` block as defined below.
        :param pulumi.Input[_builtins.str] os_managed_disk_id: The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.
               
               > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        :param pulumi.Input[_builtins.str] patch_assessment_mode: Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.
               
               > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        :param pulumi.Input[_builtins.str] patch_mode: Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).
               
               > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        :param pulumi.Input[Union['WindowsVirtualMachinePlanArgs', 'WindowsVirtualMachinePlanArgsDict']] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain: Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.
               
               > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        :param pulumi.Input[_builtins.str] reboot_setting: Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.
               
               > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineSecretArgs', 'WindowsVirtualMachineSecretArgsDict']]]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Union['WindowsVirtualMachineSourceImageReferenceArgs', 'WindowsVirtualMachineSourceImageReferenceArgsDict']] source_image_reference: A `source_image_reference` block as defined below. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine.
        :param pulumi.Input[Union['WindowsVirtualMachineTerminationNotificationArgs', 'WindowsVirtualMachineTerminationNotificationArgsDict']] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] timezone: Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine.
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.
               
               > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.
               
               > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).
               
               > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        :param pulumi.Input[_builtins.bool] vm_agent_platform_updates_enabled: Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineWinrmListenerArgs', 'WindowsVirtualMachineWinrmListenerArgsDict']]]] winrm_listeners: One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WindowsVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Windows Virtual Machine.

        ## Disclaimers

        > **Note** This provider will automatically remove the OS Disk by default - this behaviour can be configured using the `features` setting within the Provider block.

        > **Note** All arguments including the administrator login and password will be stored in the raw state as plain-text.

        > **Note** This resource does not support Unmanaged Disks. If you need to use Unmanaged Disks you can continue to use the `compute.VirtualMachine` resource instead.

        > **Note** This resource does not support attaching existing OS Disks. You can instead capture an image of the OS Disk or continue to use the `compute.VirtualMachine` resource instead.

        > In this release there's a known issue where the `public_ip_address` and `public_ip_addresses` fields may not be fully populated for Dynamic Public IP's.

        ## Example Usage

        This example provisions a basic Windows Virtual Machine on an internal network.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_windows_virtual_machine = azure.compute.WindowsVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            admin_password="P@$$w0rd1234!",
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "sku": "2016-Datacenter",
                "version": "latest",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2024-03-01, 2023-04-02

        ## Import

        Windows Virtual Machines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/windowsVirtualMachine:WindowsVirtualMachine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/machine1
        ```

        :param str resource_name: The name of the resource.
        :param WindowsVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WindowsVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[Union['WindowsVirtualMachineAdditionalCapabilitiesArgs', 'WindowsVirtualMachineAdditionalCapabilitiesArgsDict']]] = None,
                 additional_unattend_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineAdditionalUnattendContentArgs', 'WindowsVirtualMachineAdditionalUnattendContentArgsDict']]]]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_extension_operations: Optional[pulumi.Input[_builtins.bool]] = None,
                 automatic_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['WindowsVirtualMachineBootDiagnosticsArgs', 'WindowsVirtualMachineBootDiagnosticsArgsDict']]] = None,
                 bypass_platform_safety_checks_on_user_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 computer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_automatic_updates: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineGalleryApplicationArgs', 'WindowsVirtualMachineGalleryApplicationArgsDict']]]]] = None,
                 hotpatching_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WindowsVirtualMachineIdentityArgs', 'WindowsVirtualMachineIdentityArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 os_disk: Optional[pulumi.Input[Union['WindowsVirtualMachineOsDiskArgs', 'WindowsVirtualMachineOsDiskArgsDict']]] = None,
                 os_image_notification: Optional[pulumi.Input[Union['WindowsVirtualMachineOsImageNotificationArgs', 'WindowsVirtualMachineOsImageNotificationArgsDict']]] = None,
                 os_managed_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_assessment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[Union['WindowsVirtualMachinePlanArgs', 'WindowsVirtualMachinePlanArgsDict']]] = None,
                 platform_fault_domain: Optional[pulumi.Input[_builtins.int]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reboot_setting: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineSecretArgs', 'WindowsVirtualMachineSecretArgsDict']]]]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_reference: Optional[pulumi.Input[Union['WindowsVirtualMachineSourceImageReferenceArgs', 'WindowsVirtualMachineSourceImageReferenceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 termination_notification: Optional[pulumi.Input[Union['WindowsVirtualMachineTerminationNotificationArgs', 'WindowsVirtualMachineTerminationNotificationArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_agent_platform_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 winrm_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineWinrmListenerArgs', 'WindowsVirtualMachineWinrmListenerArgsDict']]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WindowsVirtualMachineArgs.__new__(WindowsVirtualMachineArgs)

            __props__.__dict__["additional_capabilities"] = additional_capabilities
            __props__.__dict__["additional_unattend_contents"] = additional_unattend_contents
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["admin_username"] = admin_username
            __props__.__dict__["allow_extension_operations"] = allow_extension_operations
            __props__.__dict__["automatic_updates_enabled"] = automatic_updates_enabled
            __props__.__dict__["availability_set_id"] = availability_set_id
            __props__.__dict__["boot_diagnostics"] = boot_diagnostics
            __props__.__dict__["bypass_platform_safety_checks_on_user_schedule_enabled"] = bypass_platform_safety_checks_on_user_schedule_enabled
            __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
            __props__.__dict__["computer_name"] = computer_name
            __props__.__dict__["custom_data"] = None if custom_data is None else pulumi.Output.secret(custom_data)
            __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
            __props__.__dict__["dedicated_host_id"] = dedicated_host_id
            __props__.__dict__["disk_controller_type"] = disk_controller_type
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["enable_automatic_updates"] = enable_automatic_updates
            __props__.__dict__["encryption_at_host_enabled"] = encryption_at_host_enabled
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["extensions_time_budget"] = extensions_time_budget
            __props__.__dict__["gallery_applications"] = gallery_applications
            __props__.__dict__["hotpatching_enabled"] = hotpatching_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["location"] = location
            __props__.__dict__["max_bid_price"] = max_bid_price
            __props__.__dict__["name"] = name
            if network_interface_ids is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_ids'")
            __props__.__dict__["network_interface_ids"] = network_interface_ids
            if os_disk is None and not opts.urn:
                raise TypeError("Missing required property 'os_disk'")
            __props__.__dict__["os_disk"] = os_disk
            __props__.__dict__["os_image_notification"] = os_image_notification
            __props__.__dict__["os_managed_disk_id"] = os_managed_disk_id
            __props__.__dict__["patch_assessment_mode"] = patch_assessment_mode
            __props__.__dict__["patch_mode"] = patch_mode
            __props__.__dict__["plan"] = plan
            __props__.__dict__["platform_fault_domain"] = platform_fault_domain
            __props__.__dict__["priority"] = priority
            __props__.__dict__["provision_vm_agent"] = provision_vm_agent
            __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
            __props__.__dict__["reboot_setting"] = reboot_setting
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["secure_boot_enabled"] = secure_boot_enabled
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["source_image_id"] = source_image_id
            __props__.__dict__["source_image_reference"] = source_image_reference
            __props__.__dict__["tags"] = tags
            __props__.__dict__["termination_notification"] = termination_notification
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["virtual_machine_scale_set_id"] = virtual_machine_scale_set_id
            __props__.__dict__["vm_agent_platform_updates_enabled"] = vm_agent_platform_updates_enabled
            __props__.__dict__["vtpm_enabled"] = vtpm_enabled
            __props__.__dict__["winrm_listeners"] = winrm_listeners
            __props__.__dict__["zone"] = zone
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["private_ip_addresses"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["public_ip_addresses"] = None
            __props__.__dict__["virtual_machine_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword", "customData"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WindowsVirtualMachine, __self__).__init__(
            'azure:compute/windowsVirtualMachine:WindowsVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_capabilities: Optional[pulumi.Input[Union['WindowsVirtualMachineAdditionalCapabilitiesArgs', 'WindowsVirtualMachineAdditionalCapabilitiesArgsDict']]] = None,
            additional_unattend_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineAdditionalUnattendContentArgs', 'WindowsVirtualMachineAdditionalUnattendContentArgsDict']]]]] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            admin_username: Optional[pulumi.Input[_builtins.str]] = None,
            allow_extension_operations: Optional[pulumi.Input[_builtins.bool]] = None,
            automatic_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            boot_diagnostics: Optional[pulumi.Input[Union['WindowsVirtualMachineBootDiagnosticsArgs', 'WindowsVirtualMachineBootDiagnosticsArgsDict']]] = None,
            bypass_platform_safety_checks_on_user_schedule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            computer_name: Optional[pulumi.Input[_builtins.str]] = None,
            custom_data: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_host_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_controller_type: Optional[pulumi.Input[_builtins.str]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            enable_automatic_updates: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_at_host_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            extensions_time_budget: Optional[pulumi.Input[_builtins.str]] = None,
            gallery_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineGalleryApplicationArgs', 'WindowsVirtualMachineGalleryApplicationArgsDict']]]]] = None,
            hotpatching_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['WindowsVirtualMachineIdentityArgs', 'WindowsVirtualMachineIdentityArgsDict']]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_bid_price: Optional[pulumi.Input[_builtins.float]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            os_disk: Optional[pulumi.Input[Union['WindowsVirtualMachineOsDiskArgs', 'WindowsVirtualMachineOsDiskArgsDict']]] = None,
            os_image_notification: Optional[pulumi.Input[Union['WindowsVirtualMachineOsImageNotificationArgs', 'WindowsVirtualMachineOsImageNotificationArgsDict']]] = None,
            os_managed_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            patch_assessment_mode: Optional[pulumi.Input[_builtins.str]] = None,
            patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[Union['WindowsVirtualMachinePlanArgs', 'WindowsVirtualMachinePlanArgsDict']]] = None,
            platform_fault_domain: Optional[pulumi.Input[_builtins.int]] = None,
            priority: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            provision_vm_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            reboot_setting: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineSecretArgs', 'WindowsVirtualMachineSecretArgsDict']]]]] = None,
            secure_boot_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_image_reference: Optional[pulumi.Input[Union['WindowsVirtualMachineSourceImageReferenceArgs', 'WindowsVirtualMachineSourceImageReferenceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            termination_notification: Optional[pulumi.Input[Union['WindowsVirtualMachineTerminationNotificationArgs', 'WindowsVirtualMachineTerminationNotificationArgsDict']]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_machine_scale_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            vm_agent_platform_updates_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            vtpm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            winrm_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineWinrmListenerArgs', 'WindowsVirtualMachineWinrmListenerArgsDict']]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'WindowsVirtualMachine':
        """
        Get an existing WindowsVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WindowsVirtualMachineAdditionalCapabilitiesArgs', 'WindowsVirtualMachineAdditionalCapabilitiesArgsDict']] additional_capabilities: A `additional_capabilities` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineAdditionalUnattendContentArgs', 'WindowsVirtualMachineAdditionalUnattendContentArgsDict']]]] additional_unattend_contents: One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.str] admin_username: The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        :param pulumi.Input[_builtins.bool] allow_extension_operations: Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] automatic_updates_enabled: Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] availability_set_id: Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WindowsVirtualMachineBootDiagnosticsArgs', 'WindowsVirtualMachineBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as defined below.
        :param pulumi.Input[_builtins.bool] bypass_platform_safety_checks_on_user_schedule_enabled: Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.
               
               > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.
               
               > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        :param pulumi.Input[_builtins.str] computer_name: Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        :param pulumi.Input[_builtins.str] dedicated_host_id: The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        :param pulumi.Input[_builtins.str] disk_controller_type: Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.bool] encryption_at_host_enabled: Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] extensions_time_budget: Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineGalleryApplicationArgs', 'WindowsVirtualMachineGalleryApplicationArgsDict']]]] gallery_applications: One or more `gallery_application` blocks as defined below.
               
               > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        :param pulumi.Input[_builtins.bool] hotpatching_enabled: Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).
               
               > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        :param pulumi.Input[Union['WindowsVirtualMachineIdentityArgs', 'WindowsVirtualMachineIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] max_bid_price: The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.
               
               > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[_builtins.str] name: The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interface_ids: . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        :param pulumi.Input[Union['WindowsVirtualMachineOsDiskArgs', 'WindowsVirtualMachineOsDiskArgsDict']] os_disk: An `os_disk` block as defined below.
        :param pulumi.Input[Union['WindowsVirtualMachineOsImageNotificationArgs', 'WindowsVirtualMachineOsImageNotificationArgsDict']] os_image_notification: A `os_image_notification` block as defined below.
        :param pulumi.Input[_builtins.str] os_managed_disk_id: The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.
               
               > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        :param pulumi.Input[_builtins.str] patch_assessment_mode: Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.
               
               > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        :param pulumi.Input[_builtins.str] patch_mode: Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).
               
               > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        :param pulumi.Input[Union['WindowsVirtualMachinePlanArgs', 'WindowsVirtualMachinePlanArgsDict']] plan: A `plan` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] platform_fault_domain: Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: The Primary Private IP Address assigned to this Virtual Machine.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: A list of Private IP Addresses assigned to this Virtual Machine.
        :param pulumi.Input[_builtins.bool] provision_vm_agent: Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.
               
               > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        :param pulumi.Input[_builtins.str] public_ip_address: The Primary Public IP Address assigned to this Virtual Machine.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_addresses: A list of the Public IP Addresses assigned to this Virtual Machine.
        :param pulumi.Input[_builtins.str] reboot_setting: Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.
               
               > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineSecretArgs', 'WindowsVirtualMachineSecretArgsDict']]]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[_builtins.bool] secure_boot_enabled: Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        :param pulumi.Input[_builtins.str] source_image_id: The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Union['WindowsVirtualMachineSourceImageReferenceArgs', 'WindowsVirtualMachineSourceImageReferenceArgsDict']] source_image_reference: A `source_image_reference` block as defined below. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to this Virtual Machine.
        :param pulumi.Input[Union['WindowsVirtualMachineTerminationNotificationArgs', 'WindowsVirtualMachineTerminationNotificationArgsDict']] termination_notification: A `termination_notification` block as defined below.
        :param pulumi.Input[_builtins.str] timezone: Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] user_data: The Base64-Encoded User Data which should be used for this Virtual Machine.
        :param pulumi.Input[_builtins.str] virtual_machine_id: A 128-bit identifier which uniquely identifies this Virtual Machine.
        :param pulumi.Input[_builtins.str] virtual_machine_scale_set_id: Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.
               
               > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.
               
               > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).
               
               > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        :param pulumi.Input[_builtins.bool] vm_agent_platform_updates_enabled: Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] vtpm_enabled: Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineWinrmListenerArgs', 'WindowsVirtualMachineWinrmListenerArgsDict']]]] winrm_listeners: One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WindowsVirtualMachineState.__new__(_WindowsVirtualMachineState)

        __props__.__dict__["additional_capabilities"] = additional_capabilities
        __props__.__dict__["additional_unattend_contents"] = additional_unattend_contents
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["allow_extension_operations"] = allow_extension_operations
        __props__.__dict__["automatic_updates_enabled"] = automatic_updates_enabled
        __props__.__dict__["availability_set_id"] = availability_set_id
        __props__.__dict__["boot_diagnostics"] = boot_diagnostics
        __props__.__dict__["bypass_platform_safety_checks_on_user_schedule_enabled"] = bypass_platform_safety_checks_on_user_schedule_enabled
        __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
        __props__.__dict__["computer_name"] = computer_name
        __props__.__dict__["custom_data"] = custom_data
        __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
        __props__.__dict__["dedicated_host_id"] = dedicated_host_id
        __props__.__dict__["disk_controller_type"] = disk_controller_type
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["enable_automatic_updates"] = enable_automatic_updates
        __props__.__dict__["encryption_at_host_enabled"] = encryption_at_host_enabled
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["extensions_time_budget"] = extensions_time_budget
        __props__.__dict__["gallery_applications"] = gallery_applications
        __props__.__dict__["hotpatching_enabled"] = hotpatching_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["location"] = location
        __props__.__dict__["max_bid_price"] = max_bid_price
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interface_ids"] = network_interface_ids
        __props__.__dict__["os_disk"] = os_disk
        __props__.__dict__["os_image_notification"] = os_image_notification
        __props__.__dict__["os_managed_disk_id"] = os_managed_disk_id
        __props__.__dict__["patch_assessment_mode"] = patch_assessment_mode
        __props__.__dict__["patch_mode"] = patch_mode
        __props__.__dict__["plan"] = plan
        __props__.__dict__["platform_fault_domain"] = platform_fault_domain
        __props__.__dict__["priority"] = priority
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["private_ip_addresses"] = private_ip_addresses
        __props__.__dict__["provision_vm_agent"] = provision_vm_agent
        __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["public_ip_addresses"] = public_ip_addresses
        __props__.__dict__["reboot_setting"] = reboot_setting
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["secure_boot_enabled"] = secure_boot_enabled
        __props__.__dict__["size"] = size
        __props__.__dict__["source_image_id"] = source_image_id
        __props__.__dict__["source_image_reference"] = source_image_reference
        __props__.__dict__["tags"] = tags
        __props__.__dict__["termination_notification"] = termination_notification
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        __props__.__dict__["virtual_machine_scale_set_id"] = virtual_machine_scale_set_id
        __props__.__dict__["vm_agent_platform_updates_enabled"] = vm_agent_platform_updates_enabled
        __props__.__dict__["vtpm_enabled"] = vtpm_enabled
        __props__.__dict__["winrm_listeners"] = winrm_listeners
        __props__.__dict__["zone"] = zone
        return WindowsVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> pulumi.Output[Optional['outputs.WindowsVirtualMachineAdditionalCapabilities']]:
        """
        A `additional_capabilities` block as defined below.
        """
        return pulumi.get(self, "additional_capabilities")

    @_builtins.property
    @pulumi.getter(name="additionalUnattendContents")
    def additional_unattend_contents(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsVirtualMachineAdditionalUnattendContent']]]:
        """
        One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "additional_unattend_contents")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of the local administrator used for the Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** This is required unless using an existing OS Managed Disk by specifying `os_managed_disk_id`.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="allowExtensionOperations")
    def allow_extension_operations(self) -> pulumi.Output[_builtins.bool]:
        """
        Should Extension Operations be allowed on this Virtual Machine? Defaults to `true`.
        """
        return pulumi.get(self, "allow_extension_operations")

    @_builtins.property
    @pulumi.getter(name="automaticUpdatesEnabled")
    def automatic_updates_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if Automatic Updates are Enabled for the Windows Virtual Machine. Changing this forces a new resource to be created. Defaults to `true`.
        """
        return pulumi.get(self, "automatic_updates_enabled")

    @_builtins.property
    @pulumi.getter(name="availabilitySetId")
    def availability_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the Availability Set in which the Virtual Machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "availability_set_id")

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> pulumi.Output[Optional['outputs.WindowsVirtualMachineBootDiagnostics']]:
        """
        A `boot_diagnostics` block as defined below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @_builtins.property
    @pulumi.getter(name="bypassPlatformSafetyChecksOnUserScheduleEnabled")
    def bypass_platform_safety_checks_on_user_schedule_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to skip platform scheduled patching when a user schedule is associated with the VM. Defaults to `false`.

        > **NOTE:** `bypass_platform_safety_checks_on_user_schedule_enabled` can only be set to `true` when `patch_mode` is set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "bypass_platform_safety_checks_on_user_schedule_enabled")

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group which the Virtual Machine should be allocated to.

        > **NOTE:** `capacity_reservation_group_id` cannot be used with `availability_set_id` or `proximity_placement_group_id`
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Hostname which should be used for this Virtual Machine. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name`, then you must specify `computer_name`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name")

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_data")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a Dedicated Host Group that this Windows Virtual Machine should be run within. Conflicts with `dedicated_host_id`.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a Dedicated Host where this machine should be run on. Conflicts with `dedicated_host_group_id`.
        """
        return pulumi.get(self, "dedicated_host_id")

    @_builtins.property
    @pulumi.getter(name="diskControllerType")
    def disk_controller_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Disk Controller Type used for this Virtual Machine. Possible values are `SCSI` and `NVMe`.
        """
        return pulumi.get(self, "disk_controller_type")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Windows Virtual Machine should exist. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    @_utilities.deprecated("""this property has been deprecated in favour of automatic_updates_enabled and will be removed in 5.0 of the provider.""")
    def enable_automatic_updates(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "enable_automatic_updates")

    @_builtins.property
    @pulumi.getter(name="encryptionAtHostEnabled")
    def encryption_at_host_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should all of the disks (including the temp disk) attached to this Virtual Machine be encrypted by enabling Encryption at Host?
        """
        return pulumi.get(self, "encryption_at_host_enabled")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies what should happen when the Virtual Machine is evicted for price reasons when using a Spot instance. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="extensionsTimeBudget")
    def extensions_time_budget(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the duration allocated for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. Defaults to `PT1H30M`.
        """
        return pulumi.get(self, "extensions_time_budget")

    @_builtins.property
    @pulumi.getter(name="galleryApplications")
    def gallery_applications(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsVirtualMachineGalleryApplication']]]:
        """
        One or more `gallery_application` blocks as defined below.

        > **Note** Gallery Application Assignments can be defined either directly on `compute.WindowsVirtualMachine` resource, or using the `compute.GalleryApplicationAssignment` resource - but the two approaches cannot be used together. If both are used with the same Virtual Machine, spurious changes will occur. If `compute.GalleryApplicationAssignment` is used, it's recommended to use `ignore_changes` for the `gallery_application` block on the corresponding `compute.WindowsVirtualMachine` resource, to avoid a persistent diff when using this resource.
        """
        return pulumi.get(self, "gallery_applications")

    @_builtins.property
    @pulumi.getter(name="hotpatchingEnabled")
    def hotpatching_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).

        > **NOTE:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, and the VM's `size` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM. An example of how to correctly configure a Windows Virtual Machine to use the `hotpatching_enabled` field can be found in the `./examples/virtual-machines/windows/hotpatching-enabled` directory within the GitHub Repository.
        """
        return pulumi.get(self, "hotpatching_enabled")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.WindowsVirtualMachineIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of on-premise license (also known as [Azure Hybrid Use Benefit](https://docs.microsoft.com/windows-server/get-started/azure-hybrid-benefit)) which should be used for this Virtual Machine. Possible values are `None`, `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where the Windows Virtual Machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxBidPrice")
    def max_bid_price(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The maximum price you're willing to pay for this Virtual Machine, in US Dollars; which must be greater than the current spot price. If this bid price falls below the current spot price the Virtual Machine will be evicted using the `eviction_policy`. Defaults to `-1`, which means that the Virtual Machine should not be evicted for price reasons.

        > **NOTE:** This can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "max_bid_price")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Windows Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        . A list of Network Interface IDs which should be attached to this Virtual Machine. The first Network Interface ID in this list will be the Primary Network Interface on the Virtual Machine.
        """
        return pulumi.get(self, "network_interface_ids")

    @_builtins.property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Output['outputs.WindowsVirtualMachineOsDisk']:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disk")

    @_builtins.property
    @pulumi.getter(name="osImageNotification")
    def os_image_notification(self) -> pulumi.Output[Optional['outputs.WindowsVirtualMachineOsImageNotification']]:
        """
        A `os_image_notification` block as defined below.
        """
        return pulumi.get(self, "os_image_notification")

    @_builtins.property
    @pulumi.getter(name="osManagedDiskId")
    def os_managed_disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of an existing Managed Disk to use as the OS Disk for this Windows Virtual Machine.

        > **Note:** When specifying an existing Managed Disk it is not currently possible to subsequently manage the Operating System Profile properties: `admin_username`, `admin_password`, `bypass_platform_safety_checks_on_user_schedule_enabled`, `computer_name`, `custom_data`, `provision_vm_agent`, `patch_mode`, `patch_assessment_mode`, or `reboot_setting`.
        """
        return pulumi.get(self, "os_managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="patchAssessmentMode")
    def patch_assessment_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mode of VM Guest Patching for the Virtual Machine. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.

        > **NOTE:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        """
        return pulumi.get(self, "patch_assessment_mode")

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mode of in-guest patching to this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).

        > **NOTE:** If `patch_mode` is set to `AutomaticByPlatform` then `provision_vm_agent` must also be set to `true`. If the Virtual Machine is using a hotpatching enabled image the `patch_mode` must always be set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "patch_mode")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional['outputs.WindowsVirtualMachinePlan']]:
        """
        A `plan` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the Platform Fault Domain in which this Windows Virtual Machine should be created. Defaults to `-1`, which means this will be automatically assigned to a fault domain that best maintains balance across the available fault domains. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "platform_fault_domain")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the priority of this Virtual Machine. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Private IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Private IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> pulumi.Output[_builtins.bool]:
        """
        Should the Azure VM Agent be provisioned on this Virtual Machine? Defaults to `true`. Changing this forces a new resource to be created.

        > **NOTE:** If `provision_vm_agent` is set to `false` then `allow_extension_operations` must also be set to `false`.
        """
        return pulumi.get(self, "provision_vm_agent")

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Proximity Placement Group which the Virtual Machine should be assigned to.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Public IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of the Public IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="rebootSetting")
    def reboot_setting(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the reboot setting for platform scheduled patching. Possible values are `Always`, `IfRequired` and `Never`.

        > **NOTE:** `reboot_setting` can only be set when `patch_mode` is set to `AutomaticByPlatform`.
        """
        return pulumi.get(self, "reboot_setting")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Windows Virtual Machine should be exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsVirtualMachineSecret']]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if Secure Boot and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU which should be used for this Virtual Machine, such as `Standard_F2`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Image which this Virtual Machine should be created from. Changing this forces a new resource to be created. Possible Image ID types include `Image ID`s, `Shared Image ID`s, `Shared Image Version ID`s, `Community Gallery Image ID`s, `Community Gallery Image Version ID`s, `Shared Gallery Image ID`s and `Shared Gallery Image Version ID`s.

        > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_id")

    @_builtins.property
    @pulumi.getter(name="sourceImageReference")
    def source_image_reference(self) -> pulumi.Output[Optional['outputs.WindowsVirtualMachineSourceImageReference']]:
        """
        A `source_image_reference` block as defined below. Changing this forces a new resource to be created.

        > **NOTE:** One of either `source_image_id` or `source_image_reference` must be set.
        """
        return pulumi.get(self, "source_image_reference")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to this Virtual Machine.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="terminationNotification")
    def termination_notification(self) -> pulumi.Output['outputs.WindowsVirtualMachineTerminationNotification']:
        """
        A `termination_notification` block as defined below.
        """
        return pulumi.get(self, "termination_notification")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Time Zone which should be used by the Virtual Machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-Encoded User Data which should be used for this Virtual Machine.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        A 128-bit identifier which uniquely identifies this Virtual Machine.
        """
        return pulumi.get(self, "virtual_machine_id")

    @_builtins.property
    @pulumi.getter(name="virtualMachineScaleSetId")
    def virtual_machine_scale_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Orchestrated Virtual Machine Scale Set that this Virtual Machine should be created within.

        > **NOTE:** To update `virtual_machine_scale_set_id` the Preview Feature `Microsoft.Compute/SingleFDAttachDetachVMToVmss` needs to be enabled, see [the documentation](https://review.learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm#enroll-in-the-preview) for more information.

        > **NOTE:** Orchestrated Virtual Machine Scale Sets can be provisioned using [the `compute.OrchestratedVirtualMachineScaleSet` resource](https://www.terraform.io/docs/providers/azurerm/r/orchestrated_virtual_machine_scale_set.html).

        > **NOTE:** To attach an existing VM to a Virtual Machine Scale Set, the scale set must have `single_placement_group` set to `false`, see [the documentation](https://learn.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-attach-detach-vm?tabs=portal-1%2Cportal-2%2Cportal-3#limitations-for-attaching-an-existing-vm-to-a-scale-set) for more information.
        """
        return pulumi.get(self, "virtual_machine_scale_set_id")

    @_builtins.property
    @pulumi.getter(name="vmAgentPlatformUpdatesEnabled")
    @_utilities.deprecated("""this property has been deprecated due to a breaking change introduced by the Service team, which redefined it as a read-only field within the API""")
    def vm_agent_platform_updates_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether VMAgent Platform Updates is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "vm_agent_platform_updates_enabled")

    @_builtins.property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if vTPM (virtual Trusted Platform Module) and Trusted Launch is enabled for the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vtpm_enabled")

    @_builtins.property
    @pulumi.getter(name="winrmListeners")
    def winrm_listeners(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsVirtualMachineWinrmListener']]]:
        """
        One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "winrm_listeners")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        * `zones` - (Optional) Specifies the Availability Zone in which this Windows Virtual Machine should be located. Changing this forces a new Windows Virtual Machine to be created.
        """
        return pulumi.get(self, "zone")

