# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BudgetManagementGroupArgs', 'BudgetManagementGroup']

@pulumi.input_type
class BudgetManagementGroupArgs:
    def __init__(__self__, *,
                 amount: pulumi.Input[_builtins.float],
                 management_group_id: pulumi.Input[_builtins.str],
                 notifications: pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]],
                 time_period: pulumi.Input['BudgetManagementGroupTimePeriodArgs'],
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['BudgetManagementGroupFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_grain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BudgetManagementGroup resource.
        :param pulumi.Input[_builtins.float] amount: The total amount of cost to track with the budget.
        :param pulumi.Input[_builtins.str] management_group_id: The ID of the Management Group. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input['BudgetManagementGroupTimePeriodArgs'] time_period: A `time_period` block as defined below.
        :param pulumi.Input[_builtins.str] etag: (Optional) The ETag of the Management Group Consumption Budget.
        :param pulumi.Input['BudgetManagementGroupFilterArgs'] filter: A `filter` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] time_grain: The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "management_group_id", management_group_id)
        pulumi.set(__self__, "notifications", notifications)
        pulumi.set(__self__, "time_period", time_period)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if time_grain is not None:
            pulumi.set(__self__, "time_grain", time_grain)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Input[_builtins.float]:
        """
        The total amount of cost to track with the budget.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Management Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_group_id")

    @management_group_id.setter
    def management_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_group_id", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]]:
        """
        One or more `notification` blocks as defined below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> pulumi.Input['BudgetManagementGroupTimePeriodArgs']:
        """
        A `time_period` block as defined below.
        """
        return pulumi.get(self, "time_period")

    @time_period.setter
    def time_period(self, value: pulumi.Input['BudgetManagementGroupTimePeriodArgs']):
        pulumi.set(self, "time_period", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional) The ETag of the Management Group Consumption Budget.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['BudgetManagementGroupFilterArgs']]:
        """
        A `filter` block as defined below.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['BudgetManagementGroupFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "time_grain")

    @time_grain.setter
    def time_grain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_grain", value)


@pulumi.input_type
class _BudgetManagementGroupState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[_builtins.float]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['BudgetManagementGroupFilterArgs']] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]]] = None,
                 time_grain: Optional[pulumi.Input[_builtins.str]] = None,
                 time_period: Optional[pulumi.Input['BudgetManagementGroupTimePeriodArgs']] = None):
        """
        Input properties used for looking up and filtering BudgetManagementGroup resources.
        :param pulumi.Input[_builtins.float] amount: The total amount of cost to track with the budget.
        :param pulumi.Input[_builtins.str] etag: (Optional) The ETag of the Management Group Consumption Budget.
        :param pulumi.Input['BudgetManagementGroupFilterArgs'] filter: A `filter` block as defined below.
        :param pulumi.Input[_builtins.str] management_group_id: The ID of the Management Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] time_grain: The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        :param pulumi.Input['BudgetManagementGroupTimePeriodArgs'] time_period: A `time_period` block as defined below.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if management_group_id is not None:
            pulumi.set(__self__, "management_group_id", management_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if time_grain is not None:
            pulumi.set(__self__, "time_grain", time_grain)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total amount of cost to track with the budget.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional) The ETag of the Management Group Consumption Budget.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['BudgetManagementGroupFilterArgs']]:
        """
        A `filter` block as defined below.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['BudgetManagementGroupFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Management Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_group_id")

    @management_group_id.setter
    def management_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]]]:
        """
        One or more `notification` blocks as defined below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetManagementGroupNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "time_grain")

    @time_grain.setter
    def time_grain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_grain", value)

    @_builtins.property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional[pulumi.Input['BudgetManagementGroupTimePeriodArgs']]:
        """
        A `time_period` block as defined below.
        """
        return pulumi.get(self, "time_period")

    @time_period.setter
    def time_period(self, value: Optional[pulumi.Input['BudgetManagementGroupTimePeriodArgs']]):
        pulumi.set(self, "time_period", value)


@pulumi.type_token("azure:consumption/budgetManagementGroup:BudgetManagementGroup")
class BudgetManagementGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.float]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['BudgetManagementGroupFilterArgs', 'BudgetManagementGroupFilterArgsDict']]] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetManagementGroupNotificationArgs', 'BudgetManagementGroupNotificationArgsDict']]]]] = None,
                 time_grain: Optional[pulumi.Input[_builtins.str]] = None,
                 time_period: Optional[pulumi.Input[Union['BudgetManagementGroupTimePeriodArgs', 'BudgetManagementGroupTimePeriodArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Consumption Budget for a Management Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.Group("example", display_name="example")
        example_resource_group = azure.core.ResourceGroup("example",
            name="example",
            location="eastus")
        example_budget_management_group = azure.consumption.BudgetManagementGroup("example",
            name="example",
            management_group_id=example.id,
            amount=1000,
            time_grain="Monthly",
            time_period={
                "start_date": "2022-06-01T00:00:00Z",
                "end_date": "2022-07-01T00:00:00Z",
            },
            filter={
                "dimensions": [{
                    "name": "ResourceGroupName",
                    "values": [example_resource_group.name],
                }],
                "tags": [{
                    "name": "foo",
                    "values": [
                        "bar",
                        "baz",
                    ],
                }],
            },
            notifications=[
                {
                    "enabled": True,
                    "threshold": 90,
                    "operator": "EqualTo",
                    "contact_emails": [
                        "foo@example.com",
                        "bar@example.com",
                    ],
                },
                {
                    "enabled": False,
                    "threshold": 100,
                    "operator": "GreaterThan",
                    "threshold_type": "Forecasted",
                    "contact_emails": [
                        "foo@example.com",
                        "bar@example.com",
                    ],
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Consumption` - 2019-10-01

        ## Import

        Management Group Consumption Budgets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:consumption/budgetManagementGroup:BudgetManagementGroup example /providers/Microsoft.Management/managementGroups/00000000-0000-0000-0000-000000000000/providers/Microsoft.Consumption/budgets/budget1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] amount: The total amount of cost to track with the budget.
        :param pulumi.Input[_builtins.str] etag: (Optional) The ETag of the Management Group Consumption Budget.
        :param pulumi.Input[Union['BudgetManagementGroupFilterArgs', 'BudgetManagementGroupFilterArgsDict']] filter: A `filter` block as defined below.
        :param pulumi.Input[_builtins.str] management_group_id: The ID of the Management Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BudgetManagementGroupNotificationArgs', 'BudgetManagementGroupNotificationArgsDict']]]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] time_grain: The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['BudgetManagementGroupTimePeriodArgs', 'BudgetManagementGroupTimePeriodArgsDict']] time_period: A `time_period` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BudgetManagementGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Consumption Budget for a Management Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.management.Group("example", display_name="example")
        example_resource_group = azure.core.ResourceGroup("example",
            name="example",
            location="eastus")
        example_budget_management_group = azure.consumption.BudgetManagementGroup("example",
            name="example",
            management_group_id=example.id,
            amount=1000,
            time_grain="Monthly",
            time_period={
                "start_date": "2022-06-01T00:00:00Z",
                "end_date": "2022-07-01T00:00:00Z",
            },
            filter={
                "dimensions": [{
                    "name": "ResourceGroupName",
                    "values": [example_resource_group.name],
                }],
                "tags": [{
                    "name": "foo",
                    "values": [
                        "bar",
                        "baz",
                    ],
                }],
            },
            notifications=[
                {
                    "enabled": True,
                    "threshold": 90,
                    "operator": "EqualTo",
                    "contact_emails": [
                        "foo@example.com",
                        "bar@example.com",
                    ],
                },
                {
                    "enabled": False,
                    "threshold": 100,
                    "operator": "GreaterThan",
                    "threshold_type": "Forecasted",
                    "contact_emails": [
                        "foo@example.com",
                        "bar@example.com",
                    ],
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Consumption` - 2019-10-01

        ## Import

        Management Group Consumption Budgets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:consumption/budgetManagementGroup:BudgetManagementGroup example /providers/Microsoft.Management/managementGroups/00000000-0000-0000-0000-000000000000/providers/Microsoft.Consumption/budgets/budget1
        ```

        :param str resource_name: The name of the resource.
        :param BudgetManagementGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BudgetManagementGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.float]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['BudgetManagementGroupFilterArgs', 'BudgetManagementGroupFilterArgsDict']]] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetManagementGroupNotificationArgs', 'BudgetManagementGroupNotificationArgsDict']]]]] = None,
                 time_grain: Optional[pulumi.Input[_builtins.str]] = None,
                 time_period: Optional[pulumi.Input[Union['BudgetManagementGroupTimePeriodArgs', 'BudgetManagementGroupTimePeriodArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BudgetManagementGroupArgs.__new__(BudgetManagementGroupArgs)

            if amount is None and not opts.urn:
                raise TypeError("Missing required property 'amount'")
            __props__.__dict__["amount"] = amount
            __props__.__dict__["etag"] = etag
            __props__.__dict__["filter"] = filter
            if management_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'management_group_id'")
            __props__.__dict__["management_group_id"] = management_group_id
            __props__.__dict__["name"] = name
            if notifications is None and not opts.urn:
                raise TypeError("Missing required property 'notifications'")
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["time_grain"] = time_grain
            if time_period is None and not opts.urn:
                raise TypeError("Missing required property 'time_period'")
            __props__.__dict__["time_period"] = time_period
        super(BudgetManagementGroup, __self__).__init__(
            'azure:consumption/budgetManagementGroup:BudgetManagementGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[_builtins.float]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[Union['BudgetManagementGroupFilterArgs', 'BudgetManagementGroupFilterArgsDict']]] = None,
            management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BudgetManagementGroupNotificationArgs', 'BudgetManagementGroupNotificationArgsDict']]]]] = None,
            time_grain: Optional[pulumi.Input[_builtins.str]] = None,
            time_period: Optional[pulumi.Input[Union['BudgetManagementGroupTimePeriodArgs', 'BudgetManagementGroupTimePeriodArgsDict']]] = None) -> 'BudgetManagementGroup':
        """
        Get an existing BudgetManagementGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] amount: The total amount of cost to track with the budget.
        :param pulumi.Input[_builtins.str] etag: (Optional) The ETag of the Management Group Consumption Budget.
        :param pulumi.Input[Union['BudgetManagementGroupFilterArgs', 'BudgetManagementGroupFilterArgsDict']] filter: A `filter` block as defined below.
        :param pulumi.Input[_builtins.str] management_group_id: The ID of the Management Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BudgetManagementGroupNotificationArgs', 'BudgetManagementGroupNotificationArgsDict']]]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] time_grain: The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['BudgetManagementGroupTimePeriodArgs', 'BudgetManagementGroupTimePeriodArgsDict']] time_period: A `time_period` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BudgetManagementGroupState.__new__(_BudgetManagementGroupState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["etag"] = etag
        __props__.__dict__["filter"] = filter
        __props__.__dict__["management_group_id"] = management_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["time_grain"] = time_grain
        __props__.__dict__["time_period"] = time_period
        return BudgetManagementGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Output[_builtins.float]:
        """
        The total amount of cost to track with the budget.
        """
        return pulumi.get(self, "amount")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional) The ETag of the Management Group Consumption Budget.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.BudgetManagementGroupFilter']]:
        """
        A `filter` block as defined below.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Management Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Management Group Consumption Budget. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Sequence['outputs.BudgetManagementGroupNotification']]:
        """
        One or more `notification` blocks as defined below.
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time covered by a budget. Tracking of the amount will be reset based on the time grain. Must be one of `BillingAnnual`, `BillingMonth`, `BillingQuarter`, `Annually`, `Monthly` and `Quarterly`. Defaults to `Monthly`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "time_grain")

    @_builtins.property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> pulumi.Output['outputs.BudgetManagementGroupTimePeriod']:
        """
        A `time_period` block as defined below.
        """
        return pulumi.get(self, "time_period")

