# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AppDaprArgs',
    'AppDaprArgsDict',
    'AppIdentityArgs',
    'AppIdentityArgsDict',
    'AppIngressArgs',
    'AppIngressArgsDict',
    'AppIngressCorsArgs',
    'AppIngressCorsArgsDict',
    'AppIngressCustomDomainArgs',
    'AppIngressCustomDomainArgsDict',
    'AppIngressIpSecurityRestrictionArgs',
    'AppIngressIpSecurityRestrictionArgsDict',
    'AppIngressTrafficWeightArgs',
    'AppIngressTrafficWeightArgsDict',
    'AppRegistryArgs',
    'AppRegistryArgsDict',
    'AppSecretArgs',
    'AppSecretArgsDict',
    'AppTemplateArgs',
    'AppTemplateArgsDict',
    'AppTemplateAzureQueueScaleRuleArgs',
    'AppTemplateAzureQueueScaleRuleArgsDict',
    'AppTemplateAzureQueueScaleRuleAuthenticationArgs',
    'AppTemplateAzureQueueScaleRuleAuthenticationArgsDict',
    'AppTemplateContainerArgs',
    'AppTemplateContainerArgsDict',
    'AppTemplateContainerEnvArgs',
    'AppTemplateContainerEnvArgsDict',
    'AppTemplateContainerLivenessProbeArgs',
    'AppTemplateContainerLivenessProbeArgsDict',
    'AppTemplateContainerLivenessProbeHeaderArgs',
    'AppTemplateContainerLivenessProbeHeaderArgsDict',
    'AppTemplateContainerReadinessProbeArgs',
    'AppTemplateContainerReadinessProbeArgsDict',
    'AppTemplateContainerReadinessProbeHeaderArgs',
    'AppTemplateContainerReadinessProbeHeaderArgsDict',
    'AppTemplateContainerStartupProbeArgs',
    'AppTemplateContainerStartupProbeArgsDict',
    'AppTemplateContainerStartupProbeHeaderArgs',
    'AppTemplateContainerStartupProbeHeaderArgsDict',
    'AppTemplateContainerVolumeMountArgs',
    'AppTemplateContainerVolumeMountArgsDict',
    'AppTemplateCustomScaleRuleArgs',
    'AppTemplateCustomScaleRuleArgsDict',
    'AppTemplateCustomScaleRuleAuthenticationArgs',
    'AppTemplateCustomScaleRuleAuthenticationArgsDict',
    'AppTemplateHttpScaleRuleArgs',
    'AppTemplateHttpScaleRuleArgsDict',
    'AppTemplateHttpScaleRuleAuthenticationArgs',
    'AppTemplateHttpScaleRuleAuthenticationArgsDict',
    'AppTemplateInitContainerArgs',
    'AppTemplateInitContainerArgsDict',
    'AppTemplateInitContainerEnvArgs',
    'AppTemplateInitContainerEnvArgsDict',
    'AppTemplateInitContainerVolumeMountArgs',
    'AppTemplateInitContainerVolumeMountArgsDict',
    'AppTemplateTcpScaleRuleArgs',
    'AppTemplateTcpScaleRuleArgsDict',
    'AppTemplateTcpScaleRuleAuthenticationArgs',
    'AppTemplateTcpScaleRuleAuthenticationArgsDict',
    'AppTemplateVolumeArgs',
    'AppTemplateVolumeArgsDict',
    'EnvironmentDaprComponentMetadataArgs',
    'EnvironmentDaprComponentMetadataArgsDict',
    'EnvironmentDaprComponentSecretArgs',
    'EnvironmentDaprComponentSecretArgsDict',
    'EnvironmentIdentityArgs',
    'EnvironmentIdentityArgsDict',
    'EnvironmentWorkloadProfileArgs',
    'EnvironmentWorkloadProfileArgsDict',
    'JobEventTriggerConfigArgs',
    'JobEventTriggerConfigArgsDict',
    'JobEventTriggerConfigScaleArgs',
    'JobEventTriggerConfigScaleArgsDict',
    'JobEventTriggerConfigScaleRuleArgs',
    'JobEventTriggerConfigScaleRuleArgsDict',
    'JobEventTriggerConfigScaleRuleAuthenticationArgs',
    'JobEventTriggerConfigScaleRuleAuthenticationArgsDict',
    'JobIdentityArgs',
    'JobIdentityArgsDict',
    'JobManualTriggerConfigArgs',
    'JobManualTriggerConfigArgsDict',
    'JobRegistryArgs',
    'JobRegistryArgsDict',
    'JobScheduleTriggerConfigArgs',
    'JobScheduleTriggerConfigArgsDict',
    'JobSecretArgs',
    'JobSecretArgsDict',
    'JobTemplateArgs',
    'JobTemplateArgsDict',
    'JobTemplateContainerArgs',
    'JobTemplateContainerArgsDict',
    'JobTemplateContainerEnvArgs',
    'JobTemplateContainerEnvArgsDict',
    'JobTemplateContainerLivenessProbeArgs',
    'JobTemplateContainerLivenessProbeArgsDict',
    'JobTemplateContainerLivenessProbeHeaderArgs',
    'JobTemplateContainerLivenessProbeHeaderArgsDict',
    'JobTemplateContainerReadinessProbeArgs',
    'JobTemplateContainerReadinessProbeArgsDict',
    'JobTemplateContainerReadinessProbeHeaderArgs',
    'JobTemplateContainerReadinessProbeHeaderArgsDict',
    'JobTemplateContainerStartupProbeArgs',
    'JobTemplateContainerStartupProbeArgsDict',
    'JobTemplateContainerStartupProbeHeaderArgs',
    'JobTemplateContainerStartupProbeHeaderArgsDict',
    'JobTemplateContainerVolumeMountArgs',
    'JobTemplateContainerVolumeMountArgsDict',
    'JobTemplateInitContainerArgs',
    'JobTemplateInitContainerArgsDict',
    'JobTemplateInitContainerEnvArgs',
    'JobTemplateInitContainerEnvArgsDict',
    'JobTemplateInitContainerVolumeMountArgs',
    'JobTemplateInitContainerVolumeMountArgsDict',
    'JobTemplateVolumeArgs',
    'JobTemplateVolumeArgsDict',
]

MYPY = False

if not MYPY:
    class AppDaprArgsDict(TypedDict):
        app_id: pulumi.Input[_builtins.str]
        """
        The Dapr Application Identifier.
        """
        app_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The port which the application is listening on. This is the same as the `ingress` port.
        """
        app_protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
elif False:
    AppDaprArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppDaprArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 app_port: Optional[pulumi.Input[_builtins.int]] = None,
                 app_protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] app_id: The Dapr Application Identifier.
        :param pulumi.Input[_builtins.int] app_port: The port which the application is listening on. This is the same as the `ingress` port.
        :param pulumi.Input[_builtins.str] app_protocol: The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
        pulumi.set(__self__, "app_id", app_id)
        if app_port is not None:
            pulumi.set(__self__, "app_port", app_port)
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Dapr Application Identifier.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="appPort")
    def app_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port which the application is listening on. This is the same as the `ingress` port.
        """
        return pulumi.get(self, "app_port")

    @app_port.setter
    def app_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "app_port", value)

    @_builtins.property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
        return pulumi.get(self, "app_protocol")

    @app_protocol.setter
    def app_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_protocol", value)


if not MYPY:
    class AppIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    AppIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AppIngressArgsDict(TypedDict):
        target_port: pulumi.Input[_builtins.int]
        """
        The target port on the container for the Ingress traffic.
        """
        traffic_weights: pulumi.Input[Sequence[pulumi.Input['AppIngressTrafficWeightArgsDict']]]
        """
        One or more `traffic_weight` blocks as detailed below.
        """
        allow_insecure_connections: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should this ingress allow insecure connections?
        """
        client_certificate_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The client certificate mode for the Ingress. Possible values are `require`, `accept`, and `ignore`.
        """
        cors: NotRequired[pulumi.Input['AppIngressCorsArgsDict']]
        """
        A `cors` block as defined below.
        """
        custom_domains: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppIngressCustomDomainArgsDict']]]]
        """
        One or more `custom_domain` block as detailed below.
        """
        exposed_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The exposed port on the container for the Ingress traffic.

        > **Note:** `exposed_port` can only be specified when `transport` is set to `tcp`.
        """
        external_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Are connections to this Ingress from outside the Container App Environment enabled? Defaults to `false`.
        """
        fqdn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The FQDN of the ingress.
        """
        ip_security_restrictions: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppIngressIpSecurityRestrictionArgsDict']]]]
        """
        One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        """
        transport: NotRequired[pulumi.Input[_builtins.str]]
        """
        The transport method for the Ingress. Possible values are `auto`, `http`, `http2` and `tcp`. Defaults to `auto`.

        > **Note:** if `transport` is set to `tcp`, `exposed_port` and `target_port` should be set at the same time.
        """
elif False:
    AppIngressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppIngressArgs:
    def __init__(__self__, *,
                 target_port: pulumi.Input[_builtins.int],
                 traffic_weights: pulumi.Input[Sequence[pulumi.Input['AppIngressTrafficWeightArgs']]],
                 allow_insecure_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input['AppIngressCorsArgs']] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input['AppIngressCustomDomainArgs']]]] = None,
                 exposed_port: Optional[pulumi.Input[_builtins.int]] = None,
                 external_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_security_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['AppIngressIpSecurityRestrictionArgs']]]] = None,
                 transport: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] target_port: The target port on the container for the Ingress traffic.
        :param pulumi.Input[Sequence[pulumi.Input['AppIngressTrafficWeightArgs']]] traffic_weights: One or more `traffic_weight` blocks as detailed below.
        :param pulumi.Input[_builtins.bool] allow_insecure_connections: Should this ingress allow insecure connections?
        :param pulumi.Input[_builtins.str] client_certificate_mode: The client certificate mode for the Ingress. Possible values are `require`, `accept`, and `ignore`.
        :param pulumi.Input['AppIngressCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AppIngressCustomDomainArgs']]] custom_domains: One or more `custom_domain` block as detailed below.
        :param pulumi.Input[_builtins.int] exposed_port: The exposed port on the container for the Ingress traffic.
               
               > **Note:** `exposed_port` can only be specified when `transport` is set to `tcp`.
        :param pulumi.Input[_builtins.bool] external_enabled: Are connections to this Ingress from outside the Container App Environment enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the ingress.
        :param pulumi.Input[Sequence[pulumi.Input['AppIngressIpSecurityRestrictionArgs']]] ip_security_restrictions: One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        :param pulumi.Input[_builtins.str] transport: The transport method for the Ingress. Possible values are `auto`, `http`, `http2` and `tcp`. Defaults to `auto`.
               
               > **Note:** if `transport` is set to `tcp`, `exposed_port` and `target_port` should be set at the same time.
        """
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "traffic_weights", traffic_weights)
        if allow_insecure_connections is not None:
            pulumi.set(__self__, "allow_insecure_connections", allow_insecure_connections)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if exposed_port is not None:
            pulumi.set(__self__, "exposed_port", exposed_port)
        if external_enabled is not None:
            pulumi.set(__self__, "external_enabled", external_enabled)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_security_restrictions is not None:
            pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[_builtins.int]:
        """
        The target port on the container for the Ingress traffic.
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_port", value)

    @_builtins.property
    @pulumi.getter(name="trafficWeights")
    def traffic_weights(self) -> pulumi.Input[Sequence[pulumi.Input['AppIngressTrafficWeightArgs']]]:
        """
        One or more `traffic_weight` blocks as detailed below.
        """
        return pulumi.get(self, "traffic_weights")

    @traffic_weights.setter
    def traffic_weights(self, value: pulumi.Input[Sequence[pulumi.Input['AppIngressTrafficWeightArgs']]]):
        pulumi.set(self, "traffic_weights", value)

    @_builtins.property
    @pulumi.getter(name="allowInsecureConnections")
    def allow_insecure_connections(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this ingress allow insecure connections?
        """
        return pulumi.get(self, "allow_insecure_connections")

    @allow_insecure_connections.setter
    def allow_insecure_connections(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_insecure_connections", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client certificate mode for the Ingress. Possible values are `require`, `accept`, and `ignore`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['AppIngressCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['AppIngressCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppIngressCustomDomainArgs']]]]:
        """
        One or more `custom_domain` block as detailed below.
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppIngressCustomDomainArgs']]]]):
        pulumi.set(self, "custom_domains", value)

    @_builtins.property
    @pulumi.getter(name="exposedPort")
    def exposed_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The exposed port on the container for the Ingress traffic.

        > **Note:** `exposed_port` can only be specified when `transport` is set to `tcp`.
        """
        return pulumi.get(self, "exposed_port")

    @exposed_port.setter
    def exposed_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "exposed_port", value)

    @_builtins.property
    @pulumi.getter(name="externalEnabled")
    def external_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are connections to this Ingress from outside the Container App Environment enabled? Defaults to `false`.
        """
        return pulumi.get(self, "external_enabled")

    @external_enabled.setter
    def external_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_enabled", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the ingress.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppIngressIpSecurityRestrictionArgs']]]]:
        """
        One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        """
        return pulumi.get(self, "ip_security_restrictions")

    @ip_security_restrictions.setter
    def ip_security_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppIngressIpSecurityRestrictionArgs']]]]):
        pulumi.set(self, "ip_security_restrictions", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The transport method for the Ingress. Possible values are `auto`, `http`, `http2` and `tcp`. Defaults to `auto`.

        > **Note:** if `transport` is set to `tcp`, `exposed_port` and `target_port` should be set at the same time.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transport", value)


if not MYPY:
    class AppIngressCorsArgsDict(TypedDict):
        allowed_origins: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies the list of origins that are allowed to make cross-origin calls.
        """
        allow_credentials_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether user credentials are allowed in the cross-origin request is enabled. Defaults to `false`.
        """
        allowed_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the list of request headers that are permitted in the actual request.
        """
        allowed_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        """
        exposed_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the list of headers exposed to the browser in the response to a cross-origin request.
        """
        max_age_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the number of seconds that the browser can cache the results of a preflight request.
        """
elif False:
    AppIngressCorsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppIngressCorsArgs:
    def __init__(__self__, *,
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 allow_credentials_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exposed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: Specifies the list of origins that are allowed to make cross-origin calls.
        :param pulumi.Input[_builtins.bool] allow_credentials_enabled: Whether user credentials are allowed in the cross-origin request is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_headers: Specifies the list of request headers that are permitted in the actual request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_methods: Specifies the list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exposed_headers: Specifies the list of headers exposed to the browser in the response to a cross-origin request.
        :param pulumi.Input[_builtins.int] max_age_in_seconds: Specifies the number of seconds that the browser can cache the results of a preflight request.
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allow_credentials_enabled is not None:
            pulumi.set(__self__, "allow_credentials_enabled", allow_credentials_enabled)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of origins that are allowed to make cross-origin calls.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_origins", value)

    @_builtins.property
    @pulumi.getter(name="allowCredentialsEnabled")
    def allow_credentials_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether user credentials are allowed in the cross-origin request is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "allow_credentials_enabled")

    @allow_credentials_enabled.setter
    def allow_credentials_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_credentials_enabled", value)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of request headers that are permitted in the actual request.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @_builtins.property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of headers exposed to the browser in the response to a cross-origin request.
        """
        return pulumi.get(self, "exposed_headers")

    @exposed_headers.setter
    def exposed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exposed_headers", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of seconds that the browser can cache the results of a preflight request.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_in_seconds", value)


if not MYPY:
    class AppIngressCustomDomainArgsDict(TypedDict):
        certificate_binding_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Binding type.
        """
        certificate_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Container App Environment Certificate.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name for this Container App. Changing this forces a new resource to be created.
        """
elif False:
    AppIngressCustomDomainArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppIngressCustomDomainArgs:
    def __init__(__self__, *,
                 certificate_binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] certificate_binding_type: The Binding type.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of the Container App Environment Certificate.
        :param pulumi.Input[_builtins.str] name: The name for this Container App. Changing this forces a new resource to be created.
        """
        if certificate_binding_type is not None:
            pulumi.set(__self__, "certificate_binding_type", certificate_binding_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateBindingType")
    def certificate_binding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Binding type.
        """
        return pulumi.get(self, "certificate_binding_type")

    @certificate_binding_type.setter
    def certificate_binding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_binding_type", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App Environment Certificate.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this Container App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class AppIngressIpSecurityRestrictionArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        The IP-filter action. `Allow` or `Deny`.

        > **Note:** The `action` types in an all `ip_security_restriction` blocks must be the same for the `ingress`, mixing `Allow` and `Deny` rules is not currently supported by the service.
        """
        ip_address_range: pulumi.Input[_builtins.str]
        """
        The incoming IP address or range of IP addresses (in CIDR notation).
        """
        name: pulumi.Input[_builtins.str]
        """
        Name for the IP restriction rule.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Describe the IP restriction rule that is being sent to the container-app.
        """
elif False:
    AppIngressIpSecurityRestrictionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppIngressIpSecurityRestrictionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ip_address_range: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: The IP-filter action. `Allow` or `Deny`.
               
               > **Note:** The `action` types in an all `ip_security_restriction` blocks must be the same for the `ingress`, mixing `Allow` and `Deny` rules is not currently supported by the service.
        :param pulumi.Input[_builtins.str] ip_address_range: The incoming IP address or range of IP addresses (in CIDR notation).
        :param pulumi.Input[_builtins.str] name: Name for the IP restriction rule.
        :param pulumi.Input[_builtins.str] description: Describe the IP restriction rule that is being sent to the container-app.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip_address_range", ip_address_range)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The IP-filter action. `Allow` or `Deny`.

        > **Note:** The `action` types in an all `ip_security_restriction` blocks must be the same for the `ingress`, mixing `Allow` and `Deny` rules is not currently supported by the service.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> pulumi.Input[_builtins.str]:
        """
        The incoming IP address or range of IP addresses (in CIDR notation).
        """
        return pulumi.get(self, "ip_address_range")

    @ip_address_range.setter
    def ip_address_range(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_address_range", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name for the IP restriction rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describe the IP restriction rule that is being sent to the container-app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class AppIngressTrafficWeightArgsDict(TypedDict):
        percentage: pulumi.Input[_builtins.int]
        """
        The percentage of traffic which should be sent this revision.

        > **Note:** The cumulative values for `weight` must equal 100 exactly and explicitly, no default weights are assumed.
        """
        label: NotRequired[pulumi.Input[_builtins.str]]
        """
        The label to apply to the revision as a name prefix for routing traffic.
        """
        latest_revision: NotRequired[pulumi.Input[_builtins.bool]]
        """
        This traffic Weight applies to the latest stable Container Revision. At most only one `traffic_weight` block can have the `latest_revision` set to `true`.
        """
        revision_suffix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The suffix string to which this `traffic_weight` applies.

        > **Note:** If `latest_revision` is `false`, the `revision_suffix` shall be specified.
        """
elif False:
    AppIngressTrafficWeightArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppIngressTrafficWeightArgs:
    def __init__(__self__, *,
                 percentage: pulumi.Input[_builtins.int],
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_revision: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision_suffix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] percentage: The percentage of traffic which should be sent this revision.
               
               > **Note:** The cumulative values for `weight` must equal 100 exactly and explicitly, no default weights are assumed.
        :param pulumi.Input[_builtins.str] label: The label to apply to the revision as a name prefix for routing traffic.
        :param pulumi.Input[_builtins.bool] latest_revision: This traffic Weight applies to the latest stable Container Revision. At most only one `traffic_weight` block can have the `latest_revision` set to `true`.
        :param pulumi.Input[_builtins.str] revision_suffix: The suffix string to which this `traffic_weight` applies.
               
               > **Note:** If `latest_revision` is `false`, the `revision_suffix` shall be specified.
        """
        pulumi.set(__self__, "percentage", percentage)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)

    @_builtins.property
    @pulumi.getter
    def percentage(self) -> pulumi.Input[_builtins.int]:
        """
        The percentage of traffic which should be sent this revision.

        > **Note:** The cumulative values for `weight` must equal 100 exactly and explicitly, no default weights are assumed.
        """
        return pulumi.get(self, "percentage")

    @percentage.setter
    def percentage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "percentage", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label to apply to the revision as a name prefix for routing traffic.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This traffic Weight applies to the latest stable Container Revision. At most only one `traffic_weight` block can have the `latest_revision` set to `true`.
        """
        return pulumi.get(self, "latest_revision")

    @latest_revision.setter
    def latest_revision(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "latest_revision", value)

    @_builtins.property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The suffix string to which this `traffic_weight` applies.

        > **Note:** If `latest_revision` is `false`, the `revision_suffix` shall be specified.
        """
        return pulumi.get(self, "revision_suffix")

    @revision_suffix.setter
    def revision_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_suffix", value)


if not MYPY:
    class AppRegistryArgsDict(TypedDict):
        server: pulumi.Input[_builtins.str]
        """
        The hostname for the Container Registry.

        The authentication details must also be supplied, `identity` and `username`/`password_secret_name` are mutually exclusive.
        """
        identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.

        > **Note:** The Resource ID must be of a User Assigned Managed identity defined in an `identity` block.
        """
        password_secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
elif False:
    AppRegistryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppRegistryArgs:
    def __init__(__self__, *,
                 server: pulumi.Input[_builtins.str],
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 password_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] server: The hostname for the Container Registry.
               
               The authentication details must also be supplied, `identity` and `username`/`password_secret_name` are mutually exclusive.
        :param pulumi.Input[_builtins.str] identity: Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.
               
               > **Note:** The Resource ID must be of a User Assigned Managed identity defined in an `identity` block.
        :param pulumi.Input[_builtins.str] password_secret_name: The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        :param pulumi.Input[_builtins.str] username: The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
        pulumi.set(__self__, "server", server)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password_secret_name is not None:
            pulumi.set(__self__, "password_secret_name", password_secret_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def server(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname for the Container Registry.

        The authentication details must also be supplied, `identity` and `username`/`password_secret_name` are mutually exclusive.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.

        > **Note:** The Resource ID must be of a User Assigned Managed identity defined in an `identity` block.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="passwordSecretName")
    def password_secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        """
        return pulumi.get(self, "password_secret_name")

    @password_secret_name.setter
    def password_secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_secret_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class AppSecretArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The secret name.
        """
        identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.

        !> **Note:** `identity` must be used together with `key_vault_secret_id`
        """
        key_vault_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of a Key Vault secret. This can be a versioned or version-less ID.

        !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for this secret.

        !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
elif False:
    AppSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The secret name.
        :param pulumi.Input[_builtins.str] identity: The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.
               
               !> **Note:** `identity` must be used together with `key_vault_secret_id`
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The ID of a Key Vault secret. This can be a versioned or version-less ID.
               
               !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        :param pulumi.Input[_builtins.str] value: The value for this secret.
               
               !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        pulumi.set(__self__, "name", name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.

        !> **Note:** `identity` must be used together with `key_vault_secret_id`
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Key Vault secret. This can be a versioned or version-less ID.

        !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for this secret.

        !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AppTemplateArgsDict(TypedDict):
        containers: pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerArgsDict']]]
        """
        One or more `container` blocks as detailed below.
        """
        azure_queue_scale_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleArgsDict']]]]
        """
        One or more `azure_queue_scale_rule` blocks as defined below.
        """
        custom_scale_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleArgsDict']]]]
        """
        One or more `custom_scale_rule` blocks as defined below.
        """
        http_scale_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleArgsDict']]]]
        """
        One or more `http_scale_rule` blocks as defined below.
        """
        init_containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerArgsDict']]]]
        """
        The definition of an init container that is part of the group as documented in the `init_container` block below.
        """
        max_replicas: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of replicas for this container.
        """
        min_replicas: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum number of replicas for this container.
        """
        revision_suffix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The suffix for the revision. This value must be unique for the lifetime of the Resource. If omitted the service will use a hash function to create one.
        """
        tcp_scale_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleArgsDict']]]]
        """
        One or more `tcp_scale_rule` blocks as defined below.
        """
        termination_grace_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateVolumeArgsDict']]]]
        """
        A `volume` block as detailed below.
        """
elif False:
    AppTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerArgs']]],
                 azure_queue_scale_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleArgs']]]] = None,
                 custom_scale_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleArgs']]]] = None,
                 http_scale_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerArgs']]]] = None,
                 max_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 min_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 revision_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_scale_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleArgs']]]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateVolumeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerArgs']]] containers: One or more `container` blocks as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleArgs']]] azure_queue_scale_rules: One or more `azure_queue_scale_rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleArgs']]] custom_scale_rules: One or more `custom_scale_rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleArgs']]] http_scale_rules: One or more `http_scale_rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerArgs']]] init_containers: The definition of an init container that is part of the group as documented in the `init_container` block below.
        :param pulumi.Input[_builtins.int] max_replicas: The maximum number of replicas for this container.
        :param pulumi.Input[_builtins.int] min_replicas: The minimum number of replicas for this container.
        :param pulumi.Input[_builtins.str] revision_suffix: The suffix for the revision. This value must be unique for the lifetime of the Resource. If omitted the service will use a hash function to create one.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleArgs']]] tcp_scale_rules: One or more `tcp_scale_rule` blocks as defined below.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateVolumeArgs']]] volumes: A `volume` block as detailed below.
        """
        pulumi.set(__self__, "containers", containers)
        if azure_queue_scale_rules is not None:
            pulumi.set(__self__, "azure_queue_scale_rules", azure_queue_scale_rules)
        if custom_scale_rules is not None:
            pulumi.set(__self__, "custom_scale_rules", custom_scale_rules)
        if http_scale_rules is not None:
            pulumi.set(__self__, "http_scale_rules", http_scale_rules)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)
        if tcp_scale_rules is not None:
            pulumi.set(__self__, "tcp_scale_rules", tcp_scale_rules)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerArgs']]]:
        """
        One or more `container` blocks as detailed below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="azureQueueScaleRules")
    def azure_queue_scale_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleArgs']]]]:
        """
        One or more `azure_queue_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "azure_queue_scale_rules")

    @azure_queue_scale_rules.setter
    def azure_queue_scale_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleArgs']]]]):
        pulumi.set(self, "azure_queue_scale_rules", value)

    @_builtins.property
    @pulumi.getter(name="customScaleRules")
    def custom_scale_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleArgs']]]]:
        """
        One or more `custom_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_scale_rules")

    @custom_scale_rules.setter
    def custom_scale_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleArgs']]]]):
        pulumi.set(self, "custom_scale_rules", value)

    @_builtins.property
    @pulumi.getter(name="httpScaleRules")
    def http_scale_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleArgs']]]]:
        """
        One or more `http_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "http_scale_rules")

    @http_scale_rules.setter
    def http_scale_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleArgs']]]]):
        pulumi.set(self, "http_scale_rules", value)

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerArgs']]]]:
        """
        The definition of an init container that is part of the group as documented in the `init_container` block below.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @_builtins.property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of replicas for this container.
        """
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_replicas", value)

    @_builtins.property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of replicas for this container.
        """
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_replicas", value)

    @_builtins.property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The suffix for the revision. This value must be unique for the lifetime of the Resource. If omitted the service will use a hash function to create one.
        """
        return pulumi.get(self, "revision_suffix")

    @revision_suffix.setter
    def revision_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_suffix", value)

    @_builtins.property
    @pulumi.getter(name="tcpScaleRules")
    def tcp_scale_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleArgs']]]]:
        """
        One or more `tcp_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "tcp_scale_rules")

    @tcp_scale_rules.setter
    def tcp_scale_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleArgs']]]]):
        pulumi.set(self, "tcp_scale_rules", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateVolumeArgs']]]]:
        """
        A `volume` block as detailed below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class AppTemplateAzureQueueScaleRuleArgsDict(TypedDict):
        authentications: pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleAuthenticationArgsDict']]]
        """
        One or more `authentication` blocks as defined below.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Scaling Rule
        """
        queue_length: pulumi.Input[_builtins.int]
        """
        The value of the length of the queue to trigger scaling actions.
        """
        queue_name: pulumi.Input[_builtins.str]
        """
        The name of the Azure Queue
        """
elif False:
    AppTemplateAzureQueueScaleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateAzureQueueScaleRuleArgs:
    def __init__(__self__, *,
                 authentications: pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleAuthenticationArgs']]],
                 name: pulumi.Input[_builtins.str],
                 queue_length: pulumi.Input[_builtins.int],
                 queue_name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleAuthenticationArgs']]] authentications: One or more `authentication` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Scaling Rule
        :param pulumi.Input[_builtins.int] queue_length: The value of the length of the queue to trigger scaling actions.
        :param pulumi.Input[_builtins.str] queue_name: The name of the Azure Queue
        """
        pulumi.set(__self__, "authentications", authentications)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "queue_length", queue_length)
        pulumi.set(__self__, "queue_name", queue_name)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleAuthenticationArgs']]]:
        """
        One or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")

    @authentications.setter
    def authentications(self, value: pulumi.Input[Sequence[pulumi.Input['AppTemplateAzureQueueScaleRuleAuthenticationArgs']]]):
        pulumi.set(self, "authentications", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> pulumi.Input[_builtins.int]:
        """
        The value of the length of the queue to trigger scaling actions.
        """
        return pulumi.get(self, "queue_length")

    @queue_length.setter
    def queue_length(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "queue_length", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Azure Queue
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_name", value)


if not MYPY:
    class AppTemplateAzureQueueScaleRuleAuthenticationArgsDict(TypedDict):
        secret_name: pulumi.Input[_builtins.str]
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        trigger_parameter: pulumi.Input[_builtins.str]
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
elif False:
    AppTemplateAzureQueueScaleRuleAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateAzureQueueScaleRuleAuthenticationArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[_builtins.str],
                 trigger_parameter: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param pulumi.Input[_builtins.str] trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> pulumi.Input[_builtins.str]:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")

    @trigger_parameter.setter
    def trigger_parameter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_parameter", value)


if not MYPY:
    class AppTemplateContainerArgsDict(TypedDict):
        cpu: pulumi.Input[_builtins.float]
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        image: pulumi.Input[_builtins.str]
        """
        The image to use to create the container.
        """
        memory: pulumi.Input[_builtins.str]
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the container
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of extra arguments to pass to the container.
        """
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerEnvArgsDict']]]]
        """
        One or more `env` blocks as detailed below.
        """
        ephemeral_storage: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        liveness_probes: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeArgsDict']]]]
        """
        A `liveness_probe` block as detailed below.
        """
        readiness_probes: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeArgsDict']]]]
        """
        A `readiness_probe` block as detailed below.
        """
        startup_probes: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeArgsDict']]]]
        """
        A `startup_probe` block as detailed below.
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerVolumeMountArgsDict']]]]
        """
        A `volume_mounts` block as detailed below.
        """
elif False:
    AppTemplateContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[_builtins.float],
                 image: pulumi.Input[_builtins.str],
                 memory: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerEnvArgs']]]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 liveness_probes: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeArgs']]]] = None,
                 readiness_probes: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeArgs']]]] = None,
                 startup_probes: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.float] cpu: The amount of vCPU to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[_builtins.str] image: The image to use to create the container.
        :param pulumi.Input[_builtins.str] memory: The amount of memory to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[_builtins.str] name: The name of the container
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: A list of extra arguments to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerEnvArgs']]] envs: One or more `env` blocks as detailed below.
        :param pulumi.Input[_builtins.str] ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeArgs']]] liveness_probes: A `liveness_probe` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeArgs']]] readiness_probes: A `readiness_probe` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeArgs']]] startup_probes: A `startup_probe` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerVolumeMountArgs']]] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if liveness_probes is not None:
            pulumi.set(__self__, "liveness_probes", liveness_probes)
        if readiness_probes is not None:
            pulumi.set(__self__, "readiness_probes", readiness_probes)
        if startup_probes is not None:
            pulumi.set(__self__, "startup_probes", startup_probes)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[_builtins.float]:
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Input[_builtins.str]:
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the container
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerEnvArgs']]]]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeArgs']]]]:
        """
        A `liveness_probe` block as detailed below.
        """
        return pulumi.get(self, "liveness_probes")

    @liveness_probes.setter
    def liveness_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeArgs']]]]):
        pulumi.set(self, "liveness_probes", value)

    @_builtins.property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeArgs']]]]:
        """
        A `readiness_probe` block as detailed below.
        """
        return pulumi.get(self, "readiness_probes")

    @readiness_probes.setter
    def readiness_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeArgs']]]]):
        pulumi.set(self, "readiness_probes", value)

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeArgs']]]]:
        """
        A `startup_probe` block as detailed below.
        """
        return pulumi.get(self, "startup_probes")

    @startup_probes.setter
    def startup_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeArgs']]]]):
        pulumi.set(self, "startup_probes", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerVolumeMountArgs']]]]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class AppTemplateContainerEnvArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the environment variable for the container.
        """
        secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the secret that contains the value for this environment variable.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for this environment variable.

        > **Note:** This value is ignored if `secret_name` is used
        """
elif False:
    AppTemplateContainerEnvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the environment variable for the container.
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret that contains the value for this environment variable.
        :param pulumi.Input[_builtins.str] value: The value for this environment variable.
               
               > **Note:** This value is ignored if `secret_name` is used
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the environment variable for the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for this environment variable.

        > **Note:** This value is ignored if `secret_name` is used
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AppTemplateContainerLivenessProbeArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        transport: pulumi.Input[_builtins.str]
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        failure_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeHeaderArgsDict']]]]
        """
        A `header` block as detailed below.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        initial_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `1` seconds.
        """
        interval_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        termination_grace_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
elif False:
    AppTemplateContainerLivenessProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerLivenessProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 transport: pulumi.Input[_builtins.str],
                 failure_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param pulumi.Input[_builtins.str] transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param pulumi.Input[_builtins.int] failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeHeaderArgs']]] headers: A `header` block as detailed below.
        :param pulumi.Input[_builtins.str] host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param pulumi.Input[_builtins.int] initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `1` seconds.
        :param pulumi.Input[_builtins.int] interval_seconds: How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        :param pulumi.Input[_builtins.str] path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param pulumi.Input[_builtins.int] timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Input[_builtins.str]:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @failure_count_threshold.setter
    def failure_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeHeaderArgs']]]]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerLivenessProbeHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `1` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_delay", value)

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class AppTemplateContainerLivenessProbeHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The HTTP Header Name.
        """
        value: pulumi.Input[_builtins.str]
        """
        The HTTP Header value.
        """
elif False:
    AppTemplateContainerLivenessProbeHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerLivenessProbeHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The HTTP Header Name.
        :param pulumi.Input[_builtins.str] value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AppTemplateContainerReadinessProbeArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        transport: pulumi.Input[_builtins.str]
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        failure_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeHeaderArgsDict']]]]
        """
        A `header` block as detailed below.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        initial_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        interval_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        success_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
elif False:
    AppTemplateContainerReadinessProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerReadinessProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 transport: pulumi.Input[_builtins.str],
                 failure_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 success_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param pulumi.Input[_builtins.str] transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param pulumi.Input[_builtins.int] failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeHeaderArgs']]] headers: A `header` block as detailed below.
        :param pulumi.Input[_builtins.str] host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param pulumi.Input[_builtins.int] initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param pulumi.Input[_builtins.int] interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param pulumi.Input[_builtins.str] path: The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param pulumi.Input[_builtins.int] success_count_threshold: The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        :param pulumi.Input[_builtins.int] timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_count_threshold is not None:
            pulumi.set(__self__, "success_count_threshold", success_count_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Input[_builtins.str]:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @failure_count_threshold.setter
    def failure_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeHeaderArgs']]]]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerReadinessProbeHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_delay", value)

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="successCountThreshold")
    def success_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "success_count_threshold")

    @success_count_threshold.setter
    def success_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "success_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class AppTemplateContainerReadinessProbeHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The HTTP Header Name.
        """
        value: pulumi.Input[_builtins.str]
        """
        The HTTP Header value.
        """
elif False:
    AppTemplateContainerReadinessProbeHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerReadinessProbeHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The HTTP Header Name.
        :param pulumi.Input[_builtins.str] value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AppTemplateContainerStartupProbeArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        transport: pulumi.Input[_builtins.str]
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        failure_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeHeaderArgsDict']]]]
        """
        A `header` block as detailed below.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        initial_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        interval_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        termination_grace_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
elif False:
    AppTemplateContainerStartupProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerStartupProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 transport: pulumi.Input[_builtins.str],
                 failure_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param pulumi.Input[_builtins.str] transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param pulumi.Input[_builtins.int] failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeHeaderArgs']]] headers: A `header` block as detailed below.
        :param pulumi.Input[_builtins.str] host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param pulumi.Input[_builtins.int] initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param pulumi.Input[_builtins.int] interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param pulumi.Input[_builtins.str] path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param pulumi.Input[_builtins.int] timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Input[_builtins.str]:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @failure_count_threshold.setter
    def failure_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeHeaderArgs']]]]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateContainerStartupProbeHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_delay", value)

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class AppTemplateContainerStartupProbeHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The HTTP Header Name.
        """
        value: pulumi.Input[_builtins.str]
        """
        The HTTP Header value.
        """
elif False:
    AppTemplateContainerStartupProbeHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerStartupProbeHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The HTTP Header Name.
        :param pulumi.Input[_builtins.str] value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AppTemplateContainerVolumeMountArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the Volume to be mounted in the container.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path in the container at which to mount this volume.
        """
        sub_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The sub path of the volume to be mounted in the container.
        """
elif False:
    AppTemplateContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateContainerVolumeMountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 sub_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the Volume to be mounted in the container.
        :param pulumi.Input[_builtins.str] path: The path in the container at which to mount this volume.
        :param pulumi.Input[_builtins.str] sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Volume to be mounted in the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_path", value)


if not MYPY:
    class AppTemplateCustomScaleRuleArgsDict(TypedDict):
        custom_rule_type: pulumi.Input[_builtins.str]
        """
        The Custom rule type. Possible values include: `activemq`, `artemis-queue`, `kafka`, `pulsar`, `aws-cloudwatch`, `aws-dynamodb`, `aws-dynamodb-streams`, `aws-kinesis-stream`, `aws-sqs-queue`, `azure-app-insights`, `azure-blob`, `azure-data-explorer`, `azure-eventhub`, `azure-log-analytics`, `azure-monitor`, `azure-pipelines`, `azure-servicebus`, `azure-queue`, `cassandra`, `cpu`, `cron`, `datadog`, `elasticsearch`, `external`, `external-push`, `gcp-stackdriver`, `gcp-storage`, `gcp-pubsub`, `graphite`, `http`, `huawei-cloudeye`, `ibmmq`, `influxdb`, `kubernetes-workload`, `liiklus`, `memory`, `metrics-api`, `mongodb`, `mssql`, `mysql`, `nats-jetstream`, `stan`, `tcp`, `new-relic`, `openstack-metric`, `openstack-swift`, `postgresql`, `predictkube`, `prometheus`, `rabbitmq`, `redis`, `redis-cluster`, `redis-sentinel`, `redis-streams`, `redis-cluster-streams`, `redis-sentinel-streams`, `selenium-grid`,`solace-event-queue`, and `github-runner`.
        """
        metadata: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]
        """
        A map of string key-value pairs to configure the Custom Scale Rule.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Scaling Rule
        """
        authentications: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleAuthenticationArgsDict']]]]
        """
        Zero or more `authentication` blocks as defined below.
        """
elif False:
    AppTemplateCustomScaleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateCustomScaleRuleArgs:
    def __init__(__self__, *,
                 custom_rule_type: pulumi.Input[_builtins.str],
                 metadata: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 authentications: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleAuthenticationArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] custom_rule_type: The Custom rule type. Possible values include: `activemq`, `artemis-queue`, `kafka`, `pulsar`, `aws-cloudwatch`, `aws-dynamodb`, `aws-dynamodb-streams`, `aws-kinesis-stream`, `aws-sqs-queue`, `azure-app-insights`, `azure-blob`, `azure-data-explorer`, `azure-eventhub`, `azure-log-analytics`, `azure-monitor`, `azure-pipelines`, `azure-servicebus`, `azure-queue`, `cassandra`, `cpu`, `cron`, `datadog`, `elasticsearch`, `external`, `external-push`, `gcp-stackdriver`, `gcp-storage`, `gcp-pubsub`, `graphite`, `http`, `huawei-cloudeye`, `ibmmq`, `influxdb`, `kubernetes-workload`, `liiklus`, `memory`, `metrics-api`, `mongodb`, `mssql`, `mysql`, `nats-jetstream`, `stan`, `tcp`, `new-relic`, `openstack-metric`, `openstack-swift`, `postgresql`, `predictkube`, `prometheus`, `rabbitmq`, `redis`, `redis-cluster`, `redis-sentinel`, `redis-streams`, `redis-cluster-streams`, `redis-sentinel-streams`, `selenium-grid`,`solace-event-queue`, and `github-runner`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: A map of string key-value pairs to configure the Custom Scale Rule.
        :param pulumi.Input[_builtins.str] name: The name of the Scaling Rule
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleAuthenticationArgs']]] authentications: Zero or more `authentication` blocks as defined below.
        """
        pulumi.set(__self__, "custom_rule_type", custom_rule_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="customRuleType")
    def custom_rule_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Custom rule type. Possible values include: `activemq`, `artemis-queue`, `kafka`, `pulsar`, `aws-cloudwatch`, `aws-dynamodb`, `aws-dynamodb-streams`, `aws-kinesis-stream`, `aws-sqs-queue`, `azure-app-insights`, `azure-blob`, `azure-data-explorer`, `azure-eventhub`, `azure-log-analytics`, `azure-monitor`, `azure-pipelines`, `azure-servicebus`, `azure-queue`, `cassandra`, `cpu`, `cron`, `datadog`, `elasticsearch`, `external`, `external-push`, `gcp-stackdriver`, `gcp-storage`, `gcp-pubsub`, `graphite`, `http`, `huawei-cloudeye`, `ibmmq`, `influxdb`, `kubernetes-workload`, `liiklus`, `memory`, `metrics-api`, `mongodb`, `mssql`, `mysql`, `nats-jetstream`, `stan`, `tcp`, `new-relic`, `openstack-metric`, `openstack-swift`, `postgresql`, `predictkube`, `prometheus`, `rabbitmq`, `redis`, `redis-cluster`, `redis-sentinel`, `redis-streams`, `redis-cluster-streams`, `redis-sentinel-streams`, `selenium-grid`,`solace-event-queue`, and `github-runner`.
        """
        return pulumi.get(self, "custom_rule_type")

    @custom_rule_type.setter
    def custom_rule_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_rule_type", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        A map of string key-value pairs to configure the Custom Scale Rule.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleAuthenticationArgs']]]]:
        """
        Zero or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")

    @authentications.setter
    def authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateCustomScaleRuleAuthenticationArgs']]]]):
        pulumi.set(self, "authentications", value)


if not MYPY:
    class AppTemplateCustomScaleRuleAuthenticationArgsDict(TypedDict):
        secret_name: pulumi.Input[_builtins.str]
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        trigger_parameter: pulumi.Input[_builtins.str]
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
elif False:
    AppTemplateCustomScaleRuleAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateCustomScaleRuleAuthenticationArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[_builtins.str],
                 trigger_parameter: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param pulumi.Input[_builtins.str] trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> pulumi.Input[_builtins.str]:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")

    @trigger_parameter.setter
    def trigger_parameter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_parameter", value)


if not MYPY:
    class AppTemplateHttpScaleRuleArgsDict(TypedDict):
        concurrent_requests: pulumi.Input[_builtins.str]
        """
        The number of concurrent requests to trigger scaling.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Scaling Rule
        """
        authentications: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleAuthenticationArgsDict']]]]
        """
        Zero or more `authentication` blocks as defined below.
        """
elif False:
    AppTemplateHttpScaleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateHttpScaleRuleArgs:
    def __init__(__self__, *,
                 concurrent_requests: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 authentications: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleAuthenticationArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] concurrent_requests: The number of concurrent requests to trigger scaling.
        :param pulumi.Input[_builtins.str] name: The name of the Scaling Rule
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleAuthenticationArgs']]] authentications: Zero or more `authentication` blocks as defined below.
        """
        pulumi.set(__self__, "concurrent_requests", concurrent_requests)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="concurrentRequests")
    def concurrent_requests(self) -> pulumi.Input[_builtins.str]:
        """
        The number of concurrent requests to trigger scaling.
        """
        return pulumi.get(self, "concurrent_requests")

    @concurrent_requests.setter
    def concurrent_requests(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "concurrent_requests", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleAuthenticationArgs']]]]:
        """
        Zero or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")

    @authentications.setter
    def authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateHttpScaleRuleAuthenticationArgs']]]]):
        pulumi.set(self, "authentications", value)


if not MYPY:
    class AppTemplateHttpScaleRuleAuthenticationArgsDict(TypedDict):
        secret_name: pulumi.Input[_builtins.str]
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        trigger_parameter: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
elif False:
    AppTemplateHttpScaleRuleAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateHttpScaleRuleAuthenticationArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[_builtins.str],
                 trigger_parameter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param pulumi.Input[_builtins.str] trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")

    @trigger_parameter.setter
    def trigger_parameter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_parameter", value)


if not MYPY:
    class AppTemplateInitContainerArgsDict(TypedDict):
        image: pulumi.Input[_builtins.str]
        """
        The image to use to create the container.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the container
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of extra arguments to pass to the container.
        """
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        cpu: NotRequired[pulumi.Input[_builtins.float]]
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerEnvArgsDict']]]]
        """
        One or more `env` blocks as detailed below.
        """
        ephemeral_storage: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        memory: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerVolumeMountArgsDict']]]]
        """
        A `volume_mounts` block as detailed below.
        """
elif False:
    AppTemplateInitContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateInitContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerEnvArgs']]]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] image: The image to use to create the container.
        :param pulumi.Input[_builtins.str] name: The name of the container
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: A list of extra arguments to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param pulumi.Input[_builtins.float] cpu: The amount of vCPU to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerEnvArgs']]] envs: One or more `env` blocks as detailed below.
        :param pulumi.Input[_builtins.str] ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param pulumi.Input[_builtins.str] memory: The amount of memory to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerVolumeMountArgs']]] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the container
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerEnvArgs']]]]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerVolumeMountArgs']]]]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateInitContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class AppTemplateInitContainerEnvArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the environment variable for the container.
        """
        secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the secret that contains the value for this environment variable.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for this environment variable.

        > **Note:** This value is ignored if `secret_name` is used
        """
elif False:
    AppTemplateInitContainerEnvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateInitContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the environment variable for the container.
        :param pulumi.Input[_builtins.str] secret_name: The name of the secret that contains the value for this environment variable.
        :param pulumi.Input[_builtins.str] value: The value for this environment variable.
               
               > **Note:** This value is ignored if `secret_name` is used
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the environment variable for the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for this environment variable.

        > **Note:** This value is ignored if `secret_name` is used
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AppTemplateInitContainerVolumeMountArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the Volume to be mounted in the container.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path in the container at which to mount this volume.
        """
        sub_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The sub path of the volume to be mounted in the container.
        """
elif False:
    AppTemplateInitContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateInitContainerVolumeMountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 sub_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the Volume to be mounted in the container.
        :param pulumi.Input[_builtins.str] path: The path in the container at which to mount this volume.
        :param pulumi.Input[_builtins.str] sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Volume to be mounted in the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_path", value)


if not MYPY:
    class AppTemplateTcpScaleRuleArgsDict(TypedDict):
        concurrent_requests: pulumi.Input[_builtins.str]
        """
        The number of concurrent requests to trigger scaling.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Scaling Rule
        """
        authentications: NotRequired[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleAuthenticationArgsDict']]]]
        """
        Zero or more `authentication` blocks as defined below.
        """
elif False:
    AppTemplateTcpScaleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateTcpScaleRuleArgs:
    def __init__(__self__, *,
                 concurrent_requests: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 authentications: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleAuthenticationArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] concurrent_requests: The number of concurrent requests to trigger scaling.
        :param pulumi.Input[_builtins.str] name: The name of the Scaling Rule
        :param pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleAuthenticationArgs']]] authentications: Zero or more `authentication` blocks as defined below.
        """
        pulumi.set(__self__, "concurrent_requests", concurrent_requests)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="concurrentRequests")
    def concurrent_requests(self) -> pulumi.Input[_builtins.str]:
        """
        The number of concurrent requests to trigger scaling.
        """
        return pulumi.get(self, "concurrent_requests")

    @concurrent_requests.setter
    def concurrent_requests(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "concurrent_requests", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleAuthenticationArgs']]]]:
        """
        Zero or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")

    @authentications.setter
    def authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppTemplateTcpScaleRuleAuthenticationArgs']]]]):
        pulumi.set(self, "authentications", value)


if not MYPY:
    class AppTemplateTcpScaleRuleAuthenticationArgsDict(TypedDict):
        secret_name: pulumi.Input[_builtins.str]
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        trigger_parameter: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
elif False:
    AppTemplateTcpScaleRuleAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateTcpScaleRuleAuthenticationArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[_builtins.str],
                 trigger_parameter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param pulumi.Input[_builtins.str] trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")

    @trigger_parameter.setter
    def trigger_parameter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_parameter", value)


if not MYPY:
    class AppTemplateVolumeArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the volume.
        """
        mount_options: NotRequired[pulumi.Input[_builtins.str]]
        """
        Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        """
        storage_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the `AzureFile` storage.
        """
        storage_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of storage volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`. Defaults to `EmptyDir`.
        """
elif False:
    AppTemplateVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppTemplateVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 mount_options: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the volume.
        :param pulumi.Input[_builtins.str] mount_options: Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        :param pulumi.Input[_builtins.str] storage_name: The name of the `AzureFile` storage.
        :param pulumi.Input[_builtins.str] storage_type: The type of storage volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`. Defaults to `EmptyDir`.
        """
        pulumi.set(__self__, "name", name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if storage_name is not None:
            pulumi.set(__self__, "storage_name", storage_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_options", value)

    @_builtins.property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the `AzureFile` storage.
        """
        return pulumi.get(self, "storage_name")

    @storage_name.setter
    def storage_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_name", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of storage volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`. Defaults to `EmptyDir`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)


if not MYPY:
    class EnvironmentDaprComponentMetadataArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the Metadata configuration item.
        """
        secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of a secret specified in the `secrets` block that contains the value for this metadata configuration item.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for this metadata configuration item.
        """
elif False:
    EnvironmentDaprComponentMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentDaprComponentMetadataArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the Metadata configuration item.
        :param pulumi.Input[_builtins.str] secret_name: The name of a secret specified in the `secrets` block that contains the value for this metadata configuration item.
        :param pulumi.Input[_builtins.str] value: The value for this metadata configuration item.
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Metadata configuration item.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a secret specified in the `secrets` block that contains the value for this metadata configuration item.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for this metadata configuration item.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class EnvironmentDaprComponentSecretArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The Secret name.
        """
        identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identity to use for accessing key vault reference.
        """
        key_vault_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Key Vault Secret ID. Could be either one of `id` or `versionless_id`.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for this secret.
        """
elif False:
    EnvironmentDaprComponentSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentDaprComponentSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The Secret name.
        :param pulumi.Input[_builtins.str] identity: The identity to use for accessing key vault reference.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The Key Vault Secret ID. Could be either one of `id` or `versionless_id`.
        :param pulumi.Input[_builtins.str] value: The value for this secret.
        """
        pulumi.set(__self__, "name", name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The Secret name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity to use for accessing key vault reference.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key Vault Secret ID. Could be either one of `id` or `versionless_id`.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for this secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class EnvironmentIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    EnvironmentIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class EnvironmentWorkloadProfileArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the workload profile.
        """
        workload_profile_type: pulumi.Input[_builtins.str]
        """
        Workload profile type for the workloads to run on. Possible values include `Consumption`, `D4`, `D8`, `D16`, `D32`, `E4`, `E8`, `E16` and `E32`.

        > **Note:** A `Consumption` type must have a name of `Consumption` and an environment may only have one `Consumption` Workload Profile.

        > **Note:** Defining a `Consumption` profile is optional, however, Environments created without an initial Workload Profile cannot have them added at a later time and must be recreated. Similarly, an environment created with Profiles must always have at least one defined Profile, removing all profiles will force a recreation of the resource.
        """
        maximum_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        minimum_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum number of instances of workload profile that can be deployed in the Container App Environment.
        """
elif False:
    EnvironmentWorkloadProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentWorkloadProfileArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 workload_profile_type: pulumi.Input[_builtins.str],
                 maximum_count: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the workload profile.
        :param pulumi.Input[_builtins.str] workload_profile_type: Workload profile type for the workloads to run on. Possible values include `Consumption`, `D4`, `D8`, `D16`, `D32`, `E4`, `E8`, `E16` and `E32`.
               
               > **Note:** A `Consumption` type must have a name of `Consumption` and an environment may only have one `Consumption` Workload Profile.
               
               > **Note:** Defining a `Consumption` profile is optional, however, Environments created without an initial Workload Profile cannot have them added at a later time and must be recreated. Similarly, an environment created with Profiles must always have at least one defined Profile, removing all profiles will force a recreation of the resource.
        :param pulumi.Input[_builtins.int] maximum_count: The maximum number of instances of workload profile that can be deployed in the Container App Environment.
        :param pulumi.Input[_builtins.int] minimum_count: The minimum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "workload_profile_type", workload_profile_type)
        if maximum_count is not None:
            pulumi.set(__self__, "maximum_count", maximum_count)
        if minimum_count is not None:
            pulumi.set(__self__, "minimum_count", minimum_count)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the workload profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="workloadProfileType")
    def workload_profile_type(self) -> pulumi.Input[_builtins.str]:
        """
        Workload profile type for the workloads to run on. Possible values include `Consumption`, `D4`, `D8`, `D16`, `D32`, `E4`, `E8`, `E16` and `E32`.

        > **Note:** A `Consumption` type must have a name of `Consumption` and an environment may only have one `Consumption` Workload Profile.

        > **Note:** Defining a `Consumption` profile is optional, however, Environments created without an initial Workload Profile cannot have them added at a later time and must be recreated. Similarly, an environment created with Profiles must always have at least one defined Profile, removing all profiles will force a recreation of the resource.
        """
        return pulumi.get(self, "workload_profile_type")

    @workload_profile_type.setter
    def workload_profile_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workload_profile_type", value)

    @_builtins.property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        return pulumi.get(self, "maximum_count")

    @maximum_count.setter
    def maximum_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_count", value)

    @_builtins.property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        return pulumi.get(self, "minimum_count")

    @minimum_count.setter
    def minimum_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_count", value)


if not MYPY:
    class JobEventTriggerConfigArgsDict(TypedDict):
        parallelism: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        replica_completion_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of successful replica completions before overall job completion.
        """
        scales: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleArgsDict']]]]
        """
        A `scale` block as defined below.
        """
elif False:
    JobEventTriggerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobEventTriggerConfigArgs:
    def __init__(__self__, *,
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 replica_completion_count: Optional[pulumi.Input[_builtins.int]] = None,
                 scales: Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.int] parallelism: Number of parallel replicas of a job that can run at a given time.
        :param pulumi.Input[_builtins.int] replica_completion_count: Minimum number of successful replica completions before overall job completion.
        :param pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleArgs']]] scales: A `scale` block as defined below.
        """
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if replica_completion_count is not None:
            pulumi.set(__self__, "replica_completion_count", replica_completion_count)
        if scales is not None:
            pulumi.set(__self__, "scales", scales)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @_builtins.property
    @pulumi.getter(name="replicaCompletionCount")
    def replica_completion_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of successful replica completions before overall job completion.
        """
        return pulumi.get(self, "replica_completion_count")

    @replica_completion_count.setter
    def replica_completion_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_completion_count", value)

    @_builtins.property
    @pulumi.getter
    def scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleArgs']]]]:
        """
        A `scale` block as defined below.
        """
        return pulumi.get(self, "scales")

    @scales.setter
    def scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleArgs']]]]):
        pulumi.set(self, "scales", value)


if not MYPY:
    class JobEventTriggerConfigScaleArgsDict(TypedDict):
        max_executions: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of job executions that are created for a trigger.
        """
        min_executions: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of job executions that are created for a trigger.
        """
        polling_interval_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Interval to check each event source in seconds.
        """
        rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleArgsDict']]]]
        """
        A `rules` block as defined below.
        """
elif False:
    JobEventTriggerConfigScaleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobEventTriggerConfigScaleArgs:
    def __init__(__self__, *,
                 max_executions: Optional[pulumi.Input[_builtins.int]] = None,
                 min_executions: Optional[pulumi.Input[_builtins.int]] = None,
                 polling_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.int] max_executions: Maximum number of job executions that are created for a trigger.
        :param pulumi.Input[_builtins.int] min_executions: Minimum number of job executions that are created for a trigger.
        :param pulumi.Input[_builtins.int] polling_interval_in_seconds: Interval to check each event source in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleArgs']]] rules: A `rules` block as defined below.
        """
        if max_executions is not None:
            pulumi.set(__self__, "max_executions", max_executions)
        if min_executions is not None:
            pulumi.set(__self__, "min_executions", min_executions)
        if polling_interval_in_seconds is not None:
            pulumi.set(__self__, "polling_interval_in_seconds", polling_interval_in_seconds)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="maxExecutions")
    def max_executions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of job executions that are created for a trigger.
        """
        return pulumi.get(self, "max_executions")

    @max_executions.setter
    def max_executions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_executions", value)

    @_builtins.property
    @pulumi.getter(name="minExecutions")
    def min_executions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of job executions that are created for a trigger.
        """
        return pulumi.get(self, "min_executions")

    @min_executions.setter
    def min_executions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_executions", value)

    @_builtins.property
    @pulumi.getter(name="pollingIntervalInSeconds")
    def polling_interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval to check each event source in seconds.
        """
        return pulumi.get(self, "polling_interval_in_seconds")

    @polling_interval_in_seconds.setter
    def polling_interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "polling_interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleArgs']]]]:
        """
        A `rules` block as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleArgs']]]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class JobEventTriggerConfigScaleRuleArgsDict(TypedDict):
        custom_rule_type: pulumi.Input[_builtins.str]
        """
        Type of the scale rule.
        """
        metadata: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]
        """
        Metadata properties to describe the scale rule.
        """
        name: pulumi.Input[_builtins.str]
        """
        Name of the scale rule.
        """
        authentications: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleAuthenticationArgsDict']]]]
        """
        A `authentication` block as defined below.
        """
elif False:
    JobEventTriggerConfigScaleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobEventTriggerConfigScaleRuleArgs:
    def __init__(__self__, *,
                 custom_rule_type: pulumi.Input[_builtins.str],
                 metadata: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 authentications: Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleAuthenticationArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] custom_rule_type: Type of the scale rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata properties to describe the scale rule.
        :param pulumi.Input[_builtins.str] name: Name of the scale rule.
        :param pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleAuthenticationArgs']]] authentications: A `authentication` block as defined below.
        """
        pulumi.set(__self__, "custom_rule_type", custom_rule_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="customRuleType")
    def custom_rule_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the scale rule.
        """
        return pulumi.get(self, "custom_rule_type")

    @custom_rule_type.setter
    def custom_rule_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_rule_type", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Metadata properties to describe the scale rule.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the scale rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleAuthenticationArgs']]]]:
        """
        A `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")

    @authentications.setter
    def authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobEventTriggerConfigScaleRuleAuthenticationArgs']]]]):
        pulumi.set(self, "authentications", value)


if not MYPY:
    class JobEventTriggerConfigScaleRuleAuthenticationArgsDict(TypedDict):
        secret_name: pulumi.Input[_builtins.str]
        """
        Name of the secret from which to pull the auth params.
        """
        trigger_parameter: pulumi.Input[_builtins.str]
        """
        Trigger Parameter that uses the secret.
        """
elif False:
    JobEventTriggerConfigScaleRuleAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobEventTriggerConfigScaleRuleAuthenticationArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[_builtins.str],
                 trigger_parameter: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_name: Name of the secret from which to pull the auth params.
        :param pulumi.Input[_builtins.str] trigger_parameter: Trigger Parameter that uses the secret.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the secret from which to pull the auth params.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> pulumi.Input[_builtins.str]:
        """
        Trigger Parameter that uses the secret.
        """
        return pulumi.get(self, "trigger_parameter")

    @trigger_parameter.setter
    def trigger_parameter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_parameter", value)


if not MYPY:
    class JobIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of identity used for the Container App Job. Possible values are `SystemAssigned`, `UserAssigned` and `None`. Defaults to `None`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of Managed Identity IDs to assign to the Container App Job.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    JobIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of identity used for the Container App Job. Possible values are `SystemAssigned`, `UserAssigned` and `None`. Defaults to `None`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of Managed Identity IDs to assign to the Container App Job.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of identity used for the Container App Job. Possible values are `SystemAssigned`, `UserAssigned` and `None`. Defaults to `None`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Managed Identity IDs to assign to the Container App Job.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class JobManualTriggerConfigArgsDict(TypedDict):
        parallelism: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        replica_completion_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of successful replica completions before overall job completion.
        """
elif False:
    JobManualTriggerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobManualTriggerConfigArgs:
    def __init__(__self__, *,
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 replica_completion_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] parallelism: Number of parallel replicas of a job that can run at a given time.
        :param pulumi.Input[_builtins.int] replica_completion_count: Minimum number of successful replica completions before overall job completion.
        """
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if replica_completion_count is not None:
            pulumi.set(__self__, "replica_completion_count", replica_completion_count)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @_builtins.property
    @pulumi.getter(name="replicaCompletionCount")
    def replica_completion_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of successful replica completions before overall job completion.
        """
        return pulumi.get(self, "replica_completion_count")

    @replica_completion_count.setter
    def replica_completion_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_completion_count", value)


if not MYPY:
    class JobRegistryArgsDict(TypedDict):
        server: pulumi.Input[_builtins.str]
        """
        The URL of the Azure Container Registry server.
        """
        identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        A Managed Identity to use to authenticate with Azure Container Registry.
        """
        password_secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Secret that contains the registry login password.
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        The username to use to authenticate with Azure Container Registry.
        """
elif False:
    JobRegistryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobRegistryArgs:
    def __init__(__self__, *,
                 server: pulumi.Input[_builtins.str],
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 password_secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] server: The URL of the Azure Container Registry server.
        :param pulumi.Input[_builtins.str] identity: A Managed Identity to use to authenticate with Azure Container Registry.
        :param pulumi.Input[_builtins.str] password_secret_name: The name of the Secret that contains the registry login password.
        :param pulumi.Input[_builtins.str] username: The username to use to authenticate with Azure Container Registry.
        """
        pulumi.set(__self__, "server", server)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password_secret_name is not None:
            pulumi.set(__self__, "password_secret_name", password_secret_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def server(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of the Azure Container Registry server.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Managed Identity to use to authenticate with Azure Container Registry.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="passwordSecretName")
    def password_secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Secret that contains the registry login password.
        """
        return pulumi.get(self, "password_secret_name")

    @password_secret_name.setter
    def password_secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_secret_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username to use to authenticate with Azure Container Registry.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class JobScheduleTriggerConfigArgsDict(TypedDict):
        cron_expression: pulumi.Input[_builtins.str]
        """
        Cron formatted repeating schedule of a Cron Job.
        """
        parallelism: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        replica_completion_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of successful replica completions before overall job completion.
        """
elif False:
    JobScheduleTriggerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobScheduleTriggerConfigArgs:
    def __init__(__self__, *,
                 cron_expression: pulumi.Input[_builtins.str],
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 replica_completion_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] cron_expression: Cron formatted repeating schedule of a Cron Job.
        :param pulumi.Input[_builtins.int] parallelism: Number of parallel replicas of a job that can run at a given time.
        :param pulumi.Input[_builtins.int] replica_completion_count: Minimum number of successful replica completions before overall job completion.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if replica_completion_count is not None:
            pulumi.set(__self__, "replica_completion_count", replica_completion_count)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> pulumi.Input[_builtins.str]:
        """
        Cron formatted repeating schedule of a Cron Job.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @_builtins.property
    @pulumi.getter(name="replicaCompletionCount")
    def replica_completion_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of successful replica completions before overall job completion.
        """
        return pulumi.get(self, "replica_completion_count")

    @replica_completion_count.setter
    def replica_completion_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_completion_count", value)


if not MYPY:
    class JobSecretArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The secret name.
        """
        identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.

        !> **Note:** `identity` must be used together with `key_vault_secret_id`
        """
        key_vault_secret_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of a Key Vault secret. This can be a versioned or version-less ID.

        !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for this secret.

        !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
elif False:
    JobSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 identity: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The secret name.
        :param pulumi.Input[_builtins.str] identity: The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.
               
               !> **Note:** `identity` must be used together with `key_vault_secret_id`
        :param pulumi.Input[_builtins.str] key_vault_secret_id: The ID of a Key Vault secret. This can be a versioned or version-less ID.
               
               !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        :param pulumi.Input[_builtins.str] value: The value for this secret.
               
               !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        pulumi.set(__self__, "name", name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.

        !> **Note:** `identity` must be used together with `key_vault_secret_id`
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Key Vault secret. This can be a versioned or version-less ID.

        !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for this secret.

        !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobTemplateArgsDict(TypedDict):
        containers: pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerArgsDict']]]
        """
        A `container` block as defined below.
        """
        init_containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerArgsDict']]]]
        """
        A `init_container` block as defined below.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateVolumeArgsDict']]]]
        """
        A `volume` block as defined below.
        """
elif False:
    JobTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerArgs']]],
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateVolumeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerArgs']]] containers: A `container` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerArgs']]] init_containers: A `init_container` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateVolumeArgs']]] volumes: A `volume` block as defined below.
        """
        pulumi.set(__self__, "containers", containers)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerArgs']]]:
        """
        A `container` block as defined below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerArgs']]]]:
        """
        A `init_container` block as defined below.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateVolumeArgs']]]]:
        """
        A `volume` block as defined below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobTemplateContainerArgsDict(TypedDict):
        cpu: pulumi.Input[_builtins.float]
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        image: pulumi.Input[_builtins.str]
        """
        The image to use to create the container.
        """
        memory: pulumi.Input[_builtins.str]
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the container.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of extra arguments to pass to the container.
        """
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerEnvArgsDict']]]]
        """
        One or more `env` blocks as detailed below.
        """
        ephemeral_storage: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        liveness_probes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeArgsDict']]]]
        """
        A `liveness_probe` block as detailed below.
        """
        readiness_probes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeArgsDict']]]]
        """
        A `readiness_probe` block as detailed below.
        """
        startup_probes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeArgsDict']]]]
        """
        A `startup_probe` block as detailed below.
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerVolumeMountArgsDict']]]]
        """
        A `volume_mounts` block as detailed below.
        """
elif False:
    JobTemplateContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[_builtins.float],
                 image: pulumi.Input[_builtins.str],
                 memory: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerEnvArgs']]]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 liveness_probes: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeArgs']]]] = None,
                 readiness_probes: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeArgs']]]] = None,
                 startup_probes: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.float] cpu: The amount of vCPU to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[_builtins.str] image: The image to use to create the container.
        :param pulumi.Input[_builtins.str] memory: The amount of memory to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[_builtins.str] name: The name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: A list of extra arguments to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerEnvArgs']]] envs: One or more `env` blocks as detailed below.
        :param pulumi.Input[_builtins.str] ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeArgs']]] liveness_probes: A `liveness_probe` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeArgs']]] readiness_probes: A `readiness_probe` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeArgs']]] startup_probes: A `startup_probe` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerVolumeMountArgs']]] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if liveness_probes is not None:
            pulumi.set(__self__, "liveness_probes", liveness_probes)
        if readiness_probes is not None:
            pulumi.set(__self__, "readiness_probes", readiness_probes)
        if startup_probes is not None:
            pulumi.set(__self__, "startup_probes", startup_probes)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[_builtins.float]:
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Input[_builtins.str]:
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerEnvArgs']]]]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeArgs']]]]:
        """
        A `liveness_probe` block as detailed below.
        """
        return pulumi.get(self, "liveness_probes")

    @liveness_probes.setter
    def liveness_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeArgs']]]]):
        pulumi.set(self, "liveness_probes", value)

    @_builtins.property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeArgs']]]]:
        """
        A `readiness_probe` block as detailed below.
        """
        return pulumi.get(self, "readiness_probes")

    @readiness_probes.setter
    def readiness_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeArgs']]]]):
        pulumi.set(self, "readiness_probes", value)

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeArgs']]]]:
        """
        A `startup_probe` block as detailed below.
        """
        return pulumi.get(self, "startup_probes")

    @startup_probes.setter
    def startup_probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeArgs']]]]):
        pulumi.set(self, "startup_probes", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerVolumeMountArgs']]]]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class JobTemplateContainerEnvArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the environment variable.
        """
        secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the environment variable.
        """
elif False:
    JobTemplateContainerEnvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the environment variable.
        :param pulumi.Input[_builtins.str] secret_name: Name of the Container App secret from which to pull the environment variable value.
        :param pulumi.Input[_builtins.str] value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobTemplateContainerLivenessProbeArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        transport: pulumi.Input[_builtins.str]
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        failure_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeHeaderArgsDict']]]]
        """
        A `header` block as detailed below.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        initial_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time in seconds to wait after the container has started before the probe is started.
        """
        interval_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        termination_grace_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
elif False:
    JobTemplateContainerLivenessProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerLivenessProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 transport: pulumi.Input[_builtins.str],
                 failure_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param pulumi.Input[_builtins.str] transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param pulumi.Input[_builtins.int] failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeHeaderArgs']]] headers: A `header` block as detailed below.
        :param pulumi.Input[_builtins.str] host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param pulumi.Input[_builtins.int] initial_delay: The time in seconds to wait after the container has started before the probe is started.
        :param pulumi.Input[_builtins.int] interval_seconds: How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        :param pulumi.Input[_builtins.str] path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param pulumi.Input[_builtins.int] timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Input[_builtins.str]:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @failure_count_threshold.setter
    def failure_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeHeaderArgs']]]]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerLivenessProbeHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds to wait after the container has started before the probe is started.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_delay", value)

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class JobTemplateContainerLivenessProbeHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The HTTP Header Name.
        """
        value: pulumi.Input[_builtins.str]
        """
        The HTTP Header value.
        """
elif False:
    JobTemplateContainerLivenessProbeHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerLivenessProbeHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The HTTP Header Name.
        :param pulumi.Input[_builtins.str] value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobTemplateContainerReadinessProbeArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        transport: pulumi.Input[_builtins.str]
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        failure_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeHeaderArgsDict']]]]
        """
        A `header` block as detailed below.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        initial_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        interval_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        success_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
elif False:
    JobTemplateContainerReadinessProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerReadinessProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 transport: pulumi.Input[_builtins.str],
                 failure_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 success_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param pulumi.Input[_builtins.str] transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param pulumi.Input[_builtins.int] failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeHeaderArgs']]] headers: A `header` block as detailed below.
        :param pulumi.Input[_builtins.str] host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param pulumi.Input[_builtins.int] initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param pulumi.Input[_builtins.int] interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param pulumi.Input[_builtins.str] path: The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param pulumi.Input[_builtins.int] success_count_threshold: The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        :param pulumi.Input[_builtins.int] timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_count_threshold is not None:
            pulumi.set(__self__, "success_count_threshold", success_count_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Input[_builtins.str]:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @failure_count_threshold.setter
    def failure_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeHeaderArgs']]]]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerReadinessProbeHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_delay", value)

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="successCountThreshold")
    def success_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "success_count_threshold")

    @success_count_threshold.setter
    def success_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "success_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class JobTemplateContainerReadinessProbeHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The HTTP Header Name.
        """
        value: pulumi.Input[_builtins.str]
        """
        The HTTP Header value.
        """
elif False:
    JobTemplateContainerReadinessProbeHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerReadinessProbeHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The HTTP Header Name.
        :param pulumi.Input[_builtins.str] value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobTemplateContainerStartupProbeArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        transport: pulumi.Input[_builtins.str]
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        failure_count_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeHeaderArgsDict']]]]
        """
        A `header` block as detailed below.
        """
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        initial_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        interval_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        termination_grace_period_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
elif False:
    JobTemplateContainerStartupProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerStartupProbeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 transport: pulumi.Input[_builtins.str],
                 failure_count_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeHeaderArgs']]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param pulumi.Input[_builtins.str] transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param pulumi.Input[_builtins.int] failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeHeaderArgs']]] headers: A `header` block as detailed below.
        :param pulumi.Input[_builtins.str] host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param pulumi.Input[_builtins.int] initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param pulumi.Input[_builtins.int] interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param pulumi.Input[_builtins.str] path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param pulumi.Input[_builtins.int] termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param pulumi.Input[_builtins.int] timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Input[_builtins.str]:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @failure_count_threshold.setter
    def failure_count_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failure_count_threshold", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeHeaderArgs']]]]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateContainerStartupProbeHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "initial_delay", value)

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @interval_seconds.setter
    def interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class JobTemplateContainerStartupProbeHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The HTTP Header Name.
        """
        value: pulumi.Input[_builtins.str]
        """
        The HTTP Header value.
        """
elif False:
    JobTemplateContainerStartupProbeHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerStartupProbeHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The HTTP Header Name.
        :param pulumi.Input[_builtins.str] value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobTemplateContainerVolumeMountArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path within the container at which the volume should be mounted. Must not contain `:`.
        """
        sub_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The sub path of the volume to be mounted in the container.
        """
elif False:
    JobTemplateContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateContainerVolumeMountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 sub_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        :param pulumi.Input[_builtins.str] path: The path within the container at which the volume should be mounted. Must not contain `:`.
        :param pulumi.Input[_builtins.str] sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path within the container at which the volume should be mounted. Must not contain `:`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_path", value)


if not MYPY:
    class JobTemplateInitContainerArgsDict(TypedDict):
        image: pulumi.Input[_builtins.str]
        """
        The image to use to create the container.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the container.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of extra arguments to pass to the container.
        """
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        cpu: NotRequired[pulumi.Input[_builtins.float]]
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerEnvArgsDict']]]]
        """
        One or more `env` blocks as detailed below.
        """
        ephemeral_storage: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        memory: NotRequired[pulumi.Input[_builtins.str]]
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerVolumeMountArgsDict']]]]
        """
        A `volume_mounts` block as detailed below.
        """
elif False:
    JobTemplateInitContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateInitContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerEnvArgs']]]] = None,
                 ephemeral_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 memory: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] image: The image to use to create the container.
        :param pulumi.Input[_builtins.str] name: The name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] args: A list of extra arguments to pass to the container.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param pulumi.Input[_builtins.float] cpu: The amount of vCPU to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerEnvArgs']]] envs: One or more `env` blocks as detailed below.
        :param pulumi.Input[_builtins.str] ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param pulumi.Input[_builtins.str] memory: The amount of memory to allocate to the container.
               
               > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerVolumeMountArgs']]] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "args", value)

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of vCPU to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerEnvArgs']]]]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ephemeral_storage", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of memory to allocate to the container.

        > **Note:** When using a Consumption plan, the `cpu` and `memory` properties must add up to one of the combinations found in the Microsoft provided documentation, for more information see [vCPU and memory allocation requirements](https://learn.microsoft.com/azure/container-apps/containers#allocations)
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerVolumeMountArgs']]]]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateInitContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class JobTemplateInitContainerEnvArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the environment variable.
        """
        secret_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the environment variable.
        """
elif False:
    JobTemplateInitContainerEnvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateInitContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the environment variable.
        :param pulumi.Input[_builtins.str] secret_name: Name of the Container App secret from which to pull the environment variable value.
        :param pulumi.Input[_builtins.str] value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobTemplateInitContainerVolumeMountArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        """
        path: pulumi.Input[_builtins.str]
        """
        The path within the container at which the volume should be mounted. Must not contain `:`.
        """
        sub_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The sub path of the volume to be mounted in the container.
        """
elif False:
    JobTemplateInitContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateInitContainerVolumeMountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 sub_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        :param pulumi.Input[_builtins.str] path: The path within the container at which the volume should be mounted. Must not contain `:`.
        :param pulumi.Input[_builtins.str] sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path within the container at which the volume should be mounted. Must not contain `:`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_path", value)


if not MYPY:
    class JobTemplateVolumeArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the volume.
        """
        mount_options: NotRequired[pulumi.Input[_builtins.str]]
        """
        Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        """
        storage_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the storage to use for the volume.
        """
        storage_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of storage to use for the volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`.
        """
elif False:
    JobTemplateVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobTemplateVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 mount_options: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the volume.
        :param pulumi.Input[_builtins.str] mount_options: Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        :param pulumi.Input[_builtins.str] storage_name: The name of the storage to use for the volume.
        :param pulumi.Input[_builtins.str] storage_type: The type of storage to use for the volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`.
        """
        pulumi.set(__self__, "name", name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if storage_name is not None:
            pulumi.set(__self__, "storage_name", storage_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_options", value)

    @_builtins.property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the storage to use for the volume.
        """
        return pulumi.get(self, "storage_name")

    @storage_name.setter
    def storage_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_name", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of storage to use for the volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)


