# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomDomainArgs', 'CustomDomain']

@pulumi.input_type
class CustomDomainArgs:
    def __init__(__self__, *,
                 container_app_id: pulumi.Input[_builtins.str],
                 certificate_binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDomain resource.
        :param pulumi.Input[_builtins.str] container_app_id: The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_binding_type: The Binding type. Possible values include `Disabled` and `SniEnabled`.
        :param pulumi.Input[_builtins.str] container_app_environment_certificate_id: The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.
               
               > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        :param pulumi.Input[_builtins.str] name: The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.
               
               > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        pulumi.set(__self__, "container_app_id", container_app_id)
        if certificate_binding_type is not None:
            pulumi.set(__self__, "certificate_binding_type", certificate_binding_type)
        if container_app_environment_certificate_id is not None:
            pulumi.set(__self__, "container_app_environment_certificate_id", container_app_environment_certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="containerAppId")
    def container_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_id")

    @container_app_id.setter
    def container_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_app_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateBindingType")
    def certificate_binding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Binding type. Possible values include `Disabled` and `SniEnabled`.
        """
        return pulumi.get(self, "certificate_binding_type")

    @certificate_binding_type.setter
    def certificate_binding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_binding_type", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentCertificateId")
    def container_app_environment_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.

        > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        """
        return pulumi.get(self, "container_app_environment_certificate_id")

    @container_app_environment_certificate_id.setter
    def container_app_environment_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_environment_certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.

        > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CustomDomainState:
    def __init__(__self__, *,
                 certificate_binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_managed_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDomain resources.
        :param pulumi.Input[_builtins.str] certificate_binding_type: The Binding type. Possible values include `Disabled` and `SniEnabled`.
        :param pulumi.Input[_builtins.str] container_app_environment_certificate_id: The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.
               
               > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        :param pulumi.Input[_builtins.str] container_app_environment_managed_certificate_id: The ID of the Container App Environment Managed Certificate to use.
        :param pulumi.Input[_builtins.str] container_app_id: The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.
               
               > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        if certificate_binding_type is not None:
            pulumi.set(__self__, "certificate_binding_type", certificate_binding_type)
        if container_app_environment_certificate_id is not None:
            pulumi.set(__self__, "container_app_environment_certificate_id", container_app_environment_certificate_id)
        if container_app_environment_managed_certificate_id is not None:
            pulumi.set(__self__, "container_app_environment_managed_certificate_id", container_app_environment_managed_certificate_id)
        if container_app_id is not None:
            pulumi.set(__self__, "container_app_id", container_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateBindingType")
    def certificate_binding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Binding type. Possible values include `Disabled` and `SniEnabled`.
        """
        return pulumi.get(self, "certificate_binding_type")

    @certificate_binding_type.setter
    def certificate_binding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_binding_type", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentCertificateId")
    def container_app_environment_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.

        > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        """
        return pulumi.get(self, "container_app_environment_certificate_id")

    @container_app_environment_certificate_id.setter
    def container_app_environment_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_environment_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentManagedCertificateId")
    def container_app_environment_managed_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App Environment Managed Certificate to use.
        """
        return pulumi.get(self, "container_app_environment_managed_certificate_id")

    @container_app_environment_managed_certificate_id.setter
    def container_app_environment_managed_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_environment_managed_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="containerAppId")
    def container_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_id")

    @container_app_id.setter
    def container_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.

        > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:containerapp/customDomain:CustomDomain")
class CustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container App Custom Domain.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="contoso.com",
            resource_group_name=example.name)
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="Example-Environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_app = azure.containerapp.App("example",
            name="example-app",
            container_app_environment_id=example_environment.id,
            resource_group_name=example.name,
            revision_mode="Single",
            template={
                "containers": [{
                    "name": "examplecontainerapp",
                    "image": "mcr.microsoft.com/k8se/quickstart:latest",
                    "cpu": 0.25,
                    "memory": "0.5Gi",
                }],
            },
            ingress={
                "allow_insecure_connections": False,
                "external_enabled": True,
                "target_port": 5000,
                "transport": "http",
                "traffic_weights": [{
                    "latest_revision": True,
                    "percentage": 100,
                }],
            })
        example_txt_record = azure.dns.TxtRecord("example",
            name="asuid.example",
            resource_group_name=example_zone.resource_group_name,
            zone_name=example_zone.name,
            ttl=300,
            records=[{
                "value": example_app.custom_domain_verification_id,
            }])
        example_environment_certificate = azure.containerapp.EnvironmentCertificate("example",
            name="myfriendlyname",
            container_app_environment_id=example_environment.id,
            certificate_blob=std.filebase64(input="path/to/certificate_file.pfx").result,
            certificate_password="$3cretSqu1rreL")
        example_custom_domain = azure.containerapp.CustomDomain("example",
            name=std.trimsuffix(input=std.trimprefix(input=api["fqdn"],
                    prefix="asuid.").result,
                suffix=".").result,
            container_app_id=example_app.id,
            container_app_environment_certificate_id=example_environment_certificate.id,
            certificate_binding_type="SniEnabled")
        ```

        ### Managed Certificate

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.containerapp.CustomDomain("example",
            name=std.trimsuffix(input=std.trimprefix(input=api["fqdn"],
                    prefix="asuid.").result,
                suffix=".").result,
            container_app_id=example_azurerm_container_app["id"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-07-01

        ## Import

        A Container App Custom Domain can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/customDomain:CustomDomain example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/containerApps/myContainerApp/customDomainName/mycustomdomain.example.com"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_binding_type: The Binding type. Possible values include `Disabled` and `SniEnabled`.
        :param pulumi.Input[_builtins.str] container_app_environment_certificate_id: The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.
               
               > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        :param pulumi.Input[_builtins.str] container_app_id: The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.
               
               > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App Custom Domain.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="contoso.com",
            resource_group_name=example.name)
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="Example-Environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_app = azure.containerapp.App("example",
            name="example-app",
            container_app_environment_id=example_environment.id,
            resource_group_name=example.name,
            revision_mode="Single",
            template={
                "containers": [{
                    "name": "examplecontainerapp",
                    "image": "mcr.microsoft.com/k8se/quickstart:latest",
                    "cpu": 0.25,
                    "memory": "0.5Gi",
                }],
            },
            ingress={
                "allow_insecure_connections": False,
                "external_enabled": True,
                "target_port": 5000,
                "transport": "http",
                "traffic_weights": [{
                    "latest_revision": True,
                    "percentage": 100,
                }],
            })
        example_txt_record = azure.dns.TxtRecord("example",
            name="asuid.example",
            resource_group_name=example_zone.resource_group_name,
            zone_name=example_zone.name,
            ttl=300,
            records=[{
                "value": example_app.custom_domain_verification_id,
            }])
        example_environment_certificate = azure.containerapp.EnvironmentCertificate("example",
            name="myfriendlyname",
            container_app_environment_id=example_environment.id,
            certificate_blob=std.filebase64(input="path/to/certificate_file.pfx").result,
            certificate_password="$3cretSqu1rreL")
        example_custom_domain = azure.containerapp.CustomDomain("example",
            name=std.trimsuffix(input=std.trimprefix(input=api["fqdn"],
                    prefix="asuid.").result,
                suffix=".").result,
            container_app_id=example_app.id,
            container_app_environment_certificate_id=example_environment_certificate.id,
            certificate_binding_type="SniEnabled")
        ```

        ### Managed Certificate

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.containerapp.CustomDomain("example",
            name=std.trimsuffix(input=std.trimprefix(input=api["fqdn"],
                    prefix="asuid.").result,
                suffix=".").result,
            container_app_id=example_azurerm_container_app["id"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-07-01

        ## Import

        A Container App Custom Domain can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/customDomain:CustomDomain example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/containerApps/myContainerApp/customDomainName/mycustomdomain.example.com"
        ```

        :param str resource_name: The name of the resource.
        :param CustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDomainArgs.__new__(CustomDomainArgs)

            __props__.__dict__["certificate_binding_type"] = certificate_binding_type
            __props__.__dict__["container_app_environment_certificate_id"] = container_app_environment_certificate_id
            if container_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_id'")
            __props__.__dict__["container_app_id"] = container_app_id
            __props__.__dict__["name"] = name
            __props__.__dict__["container_app_environment_managed_certificate_id"] = None
        super(CustomDomain, __self__).__init__(
            'azure:containerapp/customDomain:CustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_binding_type: Optional[pulumi.Input[_builtins.str]] = None,
            container_app_environment_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            container_app_environment_managed_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            container_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomDomain':
        """
        Get an existing CustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_binding_type: The Binding type. Possible values include `Disabled` and `SniEnabled`.
        :param pulumi.Input[_builtins.str] container_app_environment_certificate_id: The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.
               
               > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        :param pulumi.Input[_builtins.str] container_app_environment_managed_certificate_id: The ID of the Container App Environment Managed Certificate to use.
        :param pulumi.Input[_builtins.str] container_app_id: The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.
               
               > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDomainState.__new__(_CustomDomainState)

        __props__.__dict__["certificate_binding_type"] = certificate_binding_type
        __props__.__dict__["container_app_environment_certificate_id"] = container_app_environment_certificate_id
        __props__.__dict__["container_app_environment_managed_certificate_id"] = container_app_environment_managed_certificate_id
        __props__.__dict__["container_app_id"] = container_app_id
        __props__.__dict__["name"] = name
        return CustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateBindingType")
    def certificate_binding_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Binding type. Possible values include `Disabled` and `SniEnabled`.
        """
        return pulumi.get(self, "certificate_binding_type")

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentCertificateId")
    def container_app_environment_certificate_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Container App Environment Certificate to use. Changing this forces a new resource to be created.

        > **Note:** Omit this value if you wish to use an Azure Managed certificate. You must create the relevant DNS verification steps before this process will be successful.
        """
        return pulumi.get(self, "container_app_environment_certificate_id")

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentManagedCertificateId")
    def container_app_environment_managed_certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container App Environment Managed Certificate to use.
        """
        return pulumi.get(self, "container_app_environment_managed_certificate_id")

    @_builtins.property
    @pulumi.getter(name="containerAppId")
    def container_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container App to which this Custom Domain should be bound. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the Custom Domain. Must be the CN or a named SAN in the certificate specified by the `container_app_environment_certificate_id`. Changing this forces a new resource to be created.

        > **Note:** The Custom Domain verification TXT record requires a prefix of `asuid.`, however, this must be trimmed from the `name` property here. See the [official docs](https://learn.microsoft.com/en-us/azure/container-apps/custom-domains-certificates) for more information.
        """
        return pulumi.get(self, "name")

