# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentCustomDomainArgs', 'EnvironmentCustomDomain']

@pulumi.input_type
class EnvironmentCustomDomainArgs:
    def __init__(__self__, *,
                 certificate_blob_base64: pulumi.Input[_builtins.str],
                 certificate_password: pulumi.Input[_builtins.str],
                 container_app_environment_id: pulumi.Input[_builtins.str],
                 dns_suffix: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EnvironmentCustomDomain resource.
        :param pulumi.Input[_builtins.str] certificate_blob_base64: The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        :param pulumi.Input[_builtins.str] certificate_password: The password for the Certificate bundle.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_suffix: Custom DNS Suffix for the Container App Environment.
        """
        pulumi.set(__self__, "certificate_blob_base64", certificate_blob_base64)
        pulumi.set(__self__, "certificate_password", certificate_password)
        pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        pulumi.set(__self__, "dns_suffix", dns_suffix)

    @_builtins.property
    @pulumi.getter(name="certificateBlobBase64")
    def certificate_blob_base64(self) -> pulumi.Input[_builtins.str]:
        """
        The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        """
        return pulumi.get(self, "certificate_blob_base64")

    @certificate_blob_base64.setter
    def certificate_blob_base64(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_blob_base64", value)

    @_builtins.property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> pulumi.Input[_builtins.str]:
        """
        The password for the Certificate bundle.
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_password", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_app_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> pulumi.Input[_builtins.str]:
        """
        Custom DNS Suffix for the Container App Environment.
        """
        return pulumi.get(self, "dns_suffix")

    @dns_suffix.setter
    def dns_suffix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dns_suffix", value)


@pulumi.input_type
class _EnvironmentCustomDomainState:
    def __init__(__self__, *,
                 certificate_blob_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_suffix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentCustomDomain resources.
        :param pulumi.Input[_builtins.str] certificate_blob_base64: The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        :param pulumi.Input[_builtins.str] certificate_password: The password for the Certificate bundle.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_suffix: Custom DNS Suffix for the Container App Environment.
        """
        if certificate_blob_base64 is not None:
            pulumi.set(__self__, "certificate_blob_base64", certificate_blob_base64)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if container_app_environment_id is not None:
            pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if dns_suffix is not None:
            pulumi.set(__self__, "dns_suffix", dns_suffix)

    @_builtins.property
    @pulumi.getter(name="certificateBlobBase64")
    def certificate_blob_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        """
        return pulumi.get(self, "certificate_blob_base64")

    @certificate_blob_base64.setter
    def certificate_blob_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_blob_base64", value)

    @_builtins.property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the Certificate bundle.
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_password", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom DNS Suffix for the Container App Environment.
        """
        return pulumi.get(self, "dns_suffix")

    @dns_suffix.setter
    def dns_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_suffix", value)


@pulumi.type_token("azure:containerapp/environmentCustomDomain:EnvironmentCustomDomain")
class EnvironmentCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_blob_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container App Environment Custom Domain Suffix.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="my-environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_environment_custom_domain = azure.containerapp.EnvironmentCustomDomain("example",
            container_app_environment_id=example_environment.id,
            certificate_blob_base64=std.filebase64(input="testacc.pfx").result,
            certificate_password="TestAcc",
            dns_suffix="acceptancetest.contoso.com")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-07-01

        * `Microsoft.OperationalInsights` - 2020-08-01

        ## Import

        A Container App Environment Custom Domain Suffix can be imported using the `resource id` of its parent container App Environment, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentCustomDomain:EnvironmentCustomDomain example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myEnvironment"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_blob_base64: The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        :param pulumi.Input[_builtins.str] certificate_password: The password for the Certificate bundle.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_suffix: Custom DNS Suffix for the Container App Environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App Environment Custom Domain Suffix.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="my-environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_environment_custom_domain = azure.containerapp.EnvironmentCustomDomain("example",
            container_app_environment_id=example_environment.id,
            certificate_blob_base64=std.filebase64(input="testacc.pfx").result,
            certificate_password="TestAcc",
            dns_suffix="acceptancetest.contoso.com")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-07-01

        * `Microsoft.OperationalInsights` - 2020-08-01

        ## Import

        A Container App Environment Custom Domain Suffix can be imported using the `resource id` of its parent container App Environment, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentCustomDomain:EnvironmentCustomDomain example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myEnvironment"
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_blob_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentCustomDomainArgs.__new__(EnvironmentCustomDomainArgs)

            if certificate_blob_base64 is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_blob_base64'")
            __props__.__dict__["certificate_blob_base64"] = certificate_blob_base64
            if certificate_password is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_password'")
            __props__.__dict__["certificate_password"] = None if certificate_password is None else pulumi.Output.secret(certificate_password)
            if container_app_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_environment_id'")
            __props__.__dict__["container_app_environment_id"] = container_app_environment_id
            if dns_suffix is None and not opts.urn:
                raise TypeError("Missing required property 'dns_suffix'")
            __props__.__dict__["dns_suffix"] = dns_suffix
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificatePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EnvironmentCustomDomain, __self__).__init__(
            'azure:containerapp/environmentCustomDomain:EnvironmentCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_blob_base64: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_password: Optional[pulumi.Input[_builtins.str]] = None,
            container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns_suffix: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvironmentCustomDomain':
        """
        Get an existing EnvironmentCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_blob_base64: The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        :param pulumi.Input[_builtins.str] certificate_password: The password for the Certificate bundle.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_suffix: Custom DNS Suffix for the Container App Environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentCustomDomainState.__new__(_EnvironmentCustomDomainState)

        __props__.__dict__["certificate_blob_base64"] = certificate_blob_base64
        __props__.__dict__["certificate_password"] = certificate_password
        __props__.__dict__["container_app_environment_id"] = container_app_environment_id
        __props__.__dict__["dns_suffix"] = dns_suffix
        return EnvironmentCustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateBlobBase64")
    def certificate_blob_base64(self) -> pulumi.Output[_builtins.str]:
        """
        The bundle of Private Key and Certificate for the Custom DNS Suffix as a base64 encoded PFX or PEM.
        """
        return pulumi.get(self, "certificate_blob_base64")

    @_builtins.property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the Certificate bundle.
        """
        return pulumi.get(self, "certificate_password")

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Apps Managed Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @_builtins.property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        Custom DNS Suffix for the Container App Environment.
        """
        return pulumi.get(self, "dns_suffix")

