# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentStorageArgs', 'EnvironmentStorage']

@pulumi.input_type
class EnvironmentStorageArgs:
    def __init__(__self__, *,
                 access_mode: pulumi.Input[_builtins.str],
                 container_app_environment_id: pulumi.Input[_builtins.str],
                 share_name: pulumi.Input[_builtins.str],
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_server_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentStorage resource.
        :param pulumi.Input[_builtins.str] access_mode: The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] share_name: The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] access_key: The Storage Account Access Key.
        :param pulumi.Input[_builtins.str] account_name: The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_server_url: The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
               *
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        pulumi.set(__self__, "share_name", share_name)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_server_url is not None:
            pulumi.set(__self__, "nfs_server_url", nfs_server_url)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_app_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_name", value)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Storage Account Access Key.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nfsServerUrl")
    def nfs_server_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
        *
        """
        return pulumi.get(self, "nfs_server_url")

    @nfs_server_url.setter
    def nfs_server_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nfs_server_url", value)


@pulumi.input_type
class _EnvironmentStorageState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentStorage resources.
        :param pulumi.Input[_builtins.str] access_key: The Storage Account Access Key.
        :param pulumi.Input[_builtins.str] access_mode: The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] account_name: The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_server_url: The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
               *
        :param pulumi.Input[_builtins.str] share_name: The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if container_app_environment_id is not None:
            pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_server_url is not None:
            pulumi.set(__self__, "nfs_server_url", nfs_server_url)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Storage Account Access Key.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nfsServerUrl")
    def nfs_server_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
        *
        """
        return pulumi.get(self, "nfs_server_url")

    @nfs_server_url.setter
    def nfs_server_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nfs_server_url", value)

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_name", value)


@pulumi.type_token("azure:containerapp/environmentStorage:EnvironmentStorage")
class EnvironmentStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container App Environment Storage.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="myEnvironment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_account = azure.storage.Account("example",
            name="azureteststorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_share = azure.storage.Share("example",
            name="sharename",
            storage_account_name=example_account.name,
            quota=5)
        example_environment_storage = azure.containerapp.EnvironmentStorage("example",
            name="mycontainerappstorage",
            container_app_environment_id=example_environment.id,
            account_name=example_account.name,
            share_name=example_share.name,
            access_key=example_account.primary_access_key,
            access_mode="ReadOnly")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-07-01

        ## Import

        A Container App Environment Storage can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentStorage:EnvironmentStorage example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myEnvironment/storages/mystorage"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The Storage Account Access Key.
        :param pulumi.Input[_builtins.str] access_mode: The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] account_name: The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_server_url: The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
               *
        :param pulumi.Input[_builtins.str] share_name: The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentStorageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App Environment Storage.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="myEnvironment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_account = azure.storage.Account("example",
            name="azureteststorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_share = azure.storage.Share("example",
            name="sharename",
            storage_account_name=example_account.name,
            quota=5)
        example_environment_storage = azure.containerapp.EnvironmentStorage("example",
            name="mycontainerappstorage",
            container_app_environment_id=example_environment.id,
            account_name=example_account.name,
            share_name=example_share.name,
            access_key=example_account.primary_access_key,
            access_mode="ReadOnly")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App` - 2025-07-01

        ## Import

        A Container App Environment Storage can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentStorage:EnvironmentStorage example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myEnvironment/storages/mystorage"
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentStorageArgs.__new__(EnvironmentStorageArgs)

            __props__.__dict__["access_key"] = None if access_key is None else pulumi.Output.secret(access_key)
            if access_mode is None and not opts.urn:
                raise TypeError("Missing required property 'access_mode'")
            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["account_name"] = account_name
            if container_app_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_environment_id'")
            __props__.__dict__["container_app_environment_id"] = container_app_environment_id
            __props__.__dict__["name"] = name
            __props__.__dict__["nfs_server_url"] = nfs_server_url
            if share_name is None and not opts.urn:
                raise TypeError("Missing required property 'share_name'")
            __props__.__dict__["share_name"] = share_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EnvironmentStorage, __self__).__init__(
            'azure:containerapp/environmentStorage:EnvironmentStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            access_mode: Optional[pulumi.Input[_builtins.str]] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nfs_server_url: Optional[pulumi.Input[_builtins.str]] = None,
            share_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvironmentStorage':
        """
        Get an existing EnvironmentStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The Storage Account Access Key.
        :param pulumi.Input[_builtins.str] access_mode: The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] account_name: The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_server_url: The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
               *
        :param pulumi.Input[_builtins.str] share_name: The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentStorageState.__new__(_EnvironmentStorageState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["container_app_environment_id"] = container_app_environment_id
        __props__.__dict__["name"] = name
        __props__.__dict__["nfs_server_url"] = nfs_server_url
        __props__.__dict__["share_name"] = share_name
        return EnvironmentStorage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Storage Account Access Key.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure Storage Account in which the Share to be used is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container App Environment to which this storage belongs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for this Container App Environment Storage. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsServerUrl")
    def nfs_server_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The NFS server to use for the Azure File Share, the format will be `yourstorageaccountname.file.core.windows.net`. Changing this forces a new resource to be created.
        *
        """
        return pulumi.get(self, "nfs_server_url")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Storage Share to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "share_name")

