# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterTrustedAccessRoleBindingArgs', 'ClusterTrustedAccessRoleBinding']

@pulumi.input_type
class ClusterTrustedAccessRoleBindingArgs:
    def __init__(__self__, *,
                 kubernetes_cluster_id: pulumi.Input[_builtins.str],
                 roles: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 source_resource_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterTrustedAccessRoleBinding resource.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of roles to bind, each item is a resource type qualified role name.
        :param pulumi.Input[_builtins.str] source_resource_id: The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of roles to bind, each item is a resource type qualified role name.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ClusterTrustedAccessRoleBindingState:
    def __init__(__self__, *,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterTrustedAccessRoleBinding resources.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of roles to bind, each item is a resource type qualified role name.
        :param pulumi.Input[_builtins.str] source_resource_id: The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        if kubernetes_cluster_id is not None:
            pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of roles to bind, each item is a resource type qualified role name.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_resource_id", value)


@pulumi.type_token("azure:containerservice/clusterTrustedAccessRoleBinding:ClusterTrustedAccessRoleBinding")
class ClusterTrustedAccessRoleBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.appinsights.Insights("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            application_type="example-value")
        test = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=example_azurerm_client_config["tenantId"],
            sku_name="example-value",
            soft_delete_retention_days="example-value")
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=example_azurerm_client_config["tenantId"],
            object_id=example_azurerm_client_config["objectId"],
            key_permissions="example-value")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            dns_prefix="acctestaksexample",
            default_node_pool={
                "name": "example-value",
                "node_count": "example-value",
                "vm_size": "example-value",
                "upgrade_settings": {
                    "max_surge": "example-value",
                },
            },
            identity={
                "type": "example-value",
            })
        example_account = azure.storage.Account("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            account_tier="example-value",
            account_replication_type="example-value")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            application_insights_id=example.id,
            identity={
                "type": "example-value",
            })
        example_cluster_trusted_access_role_binding = azure.containerservice.ClusterTrustedAccessRoleBinding("example",
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            name="example",
            roles="example-value",
            source_resource_id=example_workspace.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService` - 2025-07-01

        ## Import

        An existing Kubernetes Cluster Trusted Access Role Binding can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/clusterTrustedAccessRoleBinding:ClusterTrustedAccessRoleBinding example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{managedClusterName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Kubernetes Cluster Trusted Access Role Binding exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Kubernetes Cluster Trusted Access Role Binding exists. For example `example-resource-group`.

        * Where `{managedClusterName}` is the name of the Managed Cluster. For example `managedClusterValue`.

        * Where `{trustedAccessRoleBindingName}` is the name of the Trusted Access Role Binding. For example `trustedAccessRoleBindingValue`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of roles to bind, each item is a resource type qualified role name.
        :param pulumi.Input[_builtins.str] source_resource_id: The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterTrustedAccessRoleBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.appinsights.Insights("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            application_type="example-value")
        test = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=example_azurerm_client_config["tenantId"],
            sku_name="example-value",
            soft_delete_retention_days="example-value")
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=example_azurerm_client_config["tenantId"],
            object_id=example_azurerm_client_config["objectId"],
            key_permissions="example-value")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            dns_prefix="acctestaksexample",
            default_node_pool={
                "name": "example-value",
                "node_count": "example-value",
                "vm_size": "example-value",
                "upgrade_settings": {
                    "max_surge": "example-value",
                },
            },
            identity={
                "type": "example-value",
            })
        example_account = azure.storage.Account("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            account_tier="example-value",
            account_replication_type="example-value")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            application_insights_id=example.id,
            identity={
                "type": "example-value",
            })
        example_cluster_trusted_access_role_binding = azure.containerservice.ClusterTrustedAccessRoleBinding("example",
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            name="example",
            roles="example-value",
            source_resource_id=example_workspace.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService` - 2025-07-01

        ## Import

        An existing Kubernetes Cluster Trusted Access Role Binding can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/clusterTrustedAccessRoleBinding:ClusterTrustedAccessRoleBinding example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{managedClusterName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Kubernetes Cluster Trusted Access Role Binding exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Kubernetes Cluster Trusted Access Role Binding exists. For example `example-resource-group`.

        * Where `{managedClusterName}` is the name of the Managed Cluster. For example `managedClusterValue`.

        * Where `{trustedAccessRoleBindingName}` is the name of the Trusted Access Role Binding. For example `trustedAccessRoleBindingValue`.

        :param str resource_name: The name of the resource.
        :param ClusterTrustedAccessRoleBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterTrustedAccessRoleBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterTrustedAccessRoleBindingArgs.__new__(ClusterTrustedAccessRoleBindingArgs)

            if kubernetes_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_cluster_id'")
            __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
            __props__.__dict__["name"] = name
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if source_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_resource_id'")
            __props__.__dict__["source_resource_id"] = source_resource_id
        super(ClusterTrustedAccessRoleBinding, __self__).__init__(
            'azure:containerservice/clusterTrustedAccessRoleBinding:ClusterTrustedAccessRoleBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source_resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClusterTrustedAccessRoleBinding':
        """
        Get an existing ClusterTrustedAccessRoleBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: A list of roles to bind, each item is a resource type qualified role name.
        :param pulumi.Input[_builtins.str] source_resource_id: The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterTrustedAccessRoleBindingState.__new__(_ClusterTrustedAccessRoleBindingState)

        __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
        __props__.__dict__["name"] = name
        __props__.__dict__["roles"] = roles
        __props__.__dict__["source_resource_id"] = source_resource_id
        return ClusterTrustedAccessRoleBinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Kubernetes Cluster Id within which this Kubernetes Cluster Trusted Access Role Binding should exist. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Kubernetes Cluster Trusted Access Role Binding. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of roles to bind, each item is a resource type qualified role name.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ARM resource ID of source resource that trusted access is configured for. Changing this forces a new Kubernetes Cluster Trusted Access Role Binding to be created.
        """
        return pulumi.get(self, "source_resource_id")

