# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesClusterArgs', 'KubernetesCluster']

@pulumi.input_type
class KubernetesClusterArgs:
    def __init__(__self__, *,
                 default_node_pool: pulumi.Input['KubernetesClusterDefaultNodePoolArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 aci_connector_linux: Optional[pulumi.Input['KubernetesClusterAciConnectorLinuxArgs']] = None,
                 ai_toolchain_operator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_server_access_profile: Optional[pulumi.Input['KubernetesClusterApiServerAccessProfileArgs']] = None,
                 auto_scaler_profile: Optional[pulumi.Input['KubernetesClusterAutoScalerProfileArgs']] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_role_based_access_control: Optional[pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs']] = None,
                 azure_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap_profile: Optional[pulumi.Input['KubernetesClusterBootstrapProfileArgs']] = None,
                 confidential_computing: Optional[pulumi.Input['KubernetesClusterConfidentialComputingArgs']] = None,
                 cost_analysis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_ca_trust_certificates_base64s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix_private_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 http_application_routing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_proxy_config: Optional[pulumi.Input['KubernetesClusterHttpProxyConfigArgs']] = None,
                 identity: Optional[pulumi.Input['KubernetesClusterIdentityArgs']] = None,
                 image_cleaner_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_cleaner_interval_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 ingress_application_gateway: Optional[pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs']] = None,
                 key_management_service: Optional[pulumi.Input['KubernetesClusterKeyManagementServiceArgs']] = None,
                 key_vault_secrets_provider: Optional[pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs']] = None,
                 kubelet_identity: Optional[pulumi.Input['KubernetesClusterKubeletIdentityArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_profile: Optional[pulumi.Input['KubernetesClusterLinuxProfileArgs']] = None,
                 local_account_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowArgs']] = None,
                 maintenance_window_auto_upgrade: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs']] = None,
                 maintenance_window_node_os: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs']] = None,
                 microsoft_defender: Optional[pulumi.Input['KubernetesClusterMicrosoftDefenderArgs']] = None,
                 monitor_metrics: Optional[pulumi.Input['KubernetesClusterMonitorMetricsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['KubernetesClusterNetworkProfileArgs']] = None,
                 node_os_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 node_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_issuer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oms_agent: Optional[pulumi.Input['KubernetesClusterOmsAgentArgs']] = None,
                 open_service_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_public_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_based_access_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_command_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_mesh_profile: Optional[pulumi.Input['KubernetesClusterServiceMeshProfileArgs']] = None,
                 service_principal: Optional[pulumi.Input['KubernetesClusterServicePrincipalArgs']] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_profile: Optional[pulumi.Input['KubernetesClusterStorageProfileArgs']] = None,
                 support_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_override: Optional[pulumi.Input['KubernetesClusterUpgradeOverrideArgs']] = None,
                 web_app_routing: Optional[pulumi.Input['KubernetesClusterWebAppRoutingArgs']] = None,
                 windows_profile: Optional[pulumi.Input['KubernetesClusterWindowsProfileArgs']] = None,
                 workload_autoscaler_profile: Optional[pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs']] = None,
                 workload_identity_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a KubernetesCluster resource.
        :param pulumi.Input['KubernetesClusterDefaultNodePoolArgs'] default_node_pool: Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterAciConnectorLinuxArgs'] aci_connector_linux: A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        :param pulumi.Input[_builtins.bool] ai_toolchain_operator_enabled: Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        :param pulumi.Input['KubernetesClusterApiServerAccessProfileArgs'] api_server_access_profile: An `api_server_access_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterAutoScalerProfileArgs'] auto_scaler_profile: A `auto_scaler_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.
               
               !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
               
               > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        :param pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs'] azure_active_directory_role_based_access_control: A `azure_active_directory_role_based_access_control` block as defined below.
        :param pulumi.Input[_builtins.bool] azure_policy_enabled: Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        :param pulumi.Input['KubernetesClusterBootstrapProfileArgs'] bootstrap_profile: A `bootstrap_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterConfidentialComputingArgs'] confidential_computing: A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        :param pulumi.Input[_builtins.bool] cost_analysis_enabled: Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_ca_trust_certificates_base64s: A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix_private_cluster: Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.
               
               > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.
               
               In addition, one of either `identity` or `service_principal` blocks must be specified.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] http_application_routing_enabled: Should HTTP Application Routing be enabled?
               
               > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        :param pulumi.Input['KubernetesClusterHttpProxyConfigArgs'] http_proxy_config: A `http_proxy_config` block as defined below.
        :param pulumi.Input['KubernetesClusterIdentityArgs'] identity: An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.bool] image_cleaner_enabled: Specifies whether Image Cleaner is enabled.
        :param pulumi.Input[_builtins.int] image_cleaner_interval_hours: Specifies the interval in hours when images should be cleaned up.
        :param pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs'] ingress_application_gateway: A `ingress_application_gateway` block as defined below.
               
               > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        :param pulumi.Input['KubernetesClusterKeyManagementServiceArgs'] key_management_service: A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        :param pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs'] key_vault_secrets_provider: A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        :param pulumi.Input['KubernetesClusterKubeletIdentityArgs'] kubelet_identity: A `kubelet_identity` block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version: Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        :param pulumi.Input['KubernetesClusterLinuxProfileArgs'] linux_profile: A `linux_profile` block as defined below.
        :param pulumi.Input[_builtins.bool] local_account_disabled: If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.
               
               > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        :param pulumi.Input[_builtins.str] location: The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs'] maintenance_window_auto_upgrade: A `maintenance_window_auto_upgrade` block as defined below.
        :param pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs'] maintenance_window_node_os: A `maintenance_window_node_os` block as defined below.
        :param pulumi.Input['KubernetesClusterMicrosoftDefenderArgs'] microsoft_defender: A `microsoft_defender` block as defined below.
        :param pulumi.Input['KubernetesClusterMonitorMetricsArgs'] monitor_metrics: Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.
               
               > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        :param pulumi.Input[_builtins.str] name: The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterNetworkProfileArgs'] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        :param pulumi.Input[_builtins.str] node_os_upgrade_channel: The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.
               
               > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        :param pulumi.Input[_builtins.str] node_resource_group: The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.
               
               > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        :param pulumi.Input[_builtins.bool] oidc_issuer_enabled: Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        :param pulumi.Input['KubernetesClusterOmsAgentArgs'] oms_agent: A `oms_agent` block as defined below.
        :param pulumi.Input[_builtins.bool] open_service_mesh_enabled: Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        :param pulumi.Input[_builtins.bool] private_cluster_enabled: Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_cluster_public_fqdn_enabled: Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.
               
               > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.core.ResourceGroup("example",
                   name="example",
                   location="West Europe")
               example_zone = azure.privatedns.Zone("example",
                   name="privatelink.eastus2.azmk8s.io",
                   resource_group_name=example.name)
               example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
                   name="aks-example-identity",
                   resource_group_name=example.name,
                   location=example.location)
               example_assignment = azure.authorization.Assignment("example",
                   scope=example_zone.id,
                   role_definition_name="Private DNS Zone Contributor",
                   principal_id=example_user_assigned_identity.principal_id)
               example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
                   name="aksexamplewithprivatednszone1",
                   location=example.location,
                   resource_group_name=example.name,
                   dns_prefix="aksexamplednsprefix1",
                   private_cluster_enabled=True,
                   private_dns_zone_id=example_zone.id,
                   opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
               ```
        :param pulumi.Input[_builtins.str] private_dns_zone_id: Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] role_based_access_control_enabled: Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] run_command_enabled: Whether to enable run command for the cluster or not. Defaults to `true`.
        :param pulumi.Input['KubernetesClusterServiceMeshProfileArgs'] service_mesh_profile: A `service_mesh_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterServicePrincipalArgs'] service_principal: A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.str] sku_tier: The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.
               
               > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        :param pulumi.Input['KubernetesClusterStorageProfileArgs'] storage_profile: A `storage_profile` block as defined below.
        :param pulumi.Input[_builtins.str] support_plan: Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['KubernetesClusterUpgradeOverrideArgs'] upgrade_override: A `upgrade_override` block as defined below.
        :param pulumi.Input['KubernetesClusterWebAppRoutingArgs'] web_app_routing: A `web_app_routing` block as defined below.
        :param pulumi.Input['KubernetesClusterWindowsProfileArgs'] windows_profile: A `windows_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs'] workload_autoscaler_profile: A `workload_autoscaler_profile` block defined below.
        :param pulumi.Input[_builtins.bool] workload_identity_enabled: Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.
               
               > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.
               
               > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        pulumi.set(__self__, "default_node_pool", default_node_pool)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if aci_connector_linux is not None:
            pulumi.set(__self__, "aci_connector_linux", aci_connector_linux)
        if ai_toolchain_operator_enabled is not None:
            pulumi.set(__self__, "ai_toolchain_operator_enabled", ai_toolchain_operator_enabled)
        if api_server_access_profile is not None:
            pulumi.set(__self__, "api_server_access_profile", api_server_access_profile)
        if auto_scaler_profile is not None:
            pulumi.set(__self__, "auto_scaler_profile", auto_scaler_profile)
        if automatic_upgrade_channel is not None:
            pulumi.set(__self__, "automatic_upgrade_channel", automatic_upgrade_channel)
        if azure_active_directory_role_based_access_control is not None:
            pulumi.set(__self__, "azure_active_directory_role_based_access_control", azure_active_directory_role_based_access_control)
        if azure_policy_enabled is not None:
            pulumi.set(__self__, "azure_policy_enabled", azure_policy_enabled)
        if bootstrap_profile is not None:
            pulumi.set(__self__, "bootstrap_profile", bootstrap_profile)
        if confidential_computing is not None:
            pulumi.set(__self__, "confidential_computing", confidential_computing)
        if cost_analysis_enabled is not None:
            pulumi.set(__self__, "cost_analysis_enabled", cost_analysis_enabled)
        if custom_ca_trust_certificates_base64s is not None:
            pulumi.set(__self__, "custom_ca_trust_certificates_base64s", custom_ca_trust_certificates_base64s)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if dns_prefix is not None:
            pulumi.set(__self__, "dns_prefix", dns_prefix)
        if dns_prefix_private_cluster is not None:
            pulumi.set(__self__, "dns_prefix_private_cluster", dns_prefix_private_cluster)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if http_application_routing_enabled is not None:
            pulumi.set(__self__, "http_application_routing_enabled", http_application_routing_enabled)
        if http_proxy_config is not None:
            pulumi.set(__self__, "http_proxy_config", http_proxy_config)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if image_cleaner_enabled is not None:
            pulumi.set(__self__, "image_cleaner_enabled", image_cleaner_enabled)
        if image_cleaner_interval_hours is not None:
            pulumi.set(__self__, "image_cleaner_interval_hours", image_cleaner_interval_hours)
        if ingress_application_gateway is not None:
            pulumi.set(__self__, "ingress_application_gateway", ingress_application_gateway)
        if key_management_service is not None:
            pulumi.set(__self__, "key_management_service", key_management_service)
        if key_vault_secrets_provider is not None:
            pulumi.set(__self__, "key_vault_secrets_provider", key_vault_secrets_provider)
        if kubelet_identity is not None:
            pulumi.set(__self__, "kubelet_identity", kubelet_identity)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if linux_profile is not None:
            pulumi.set(__self__, "linux_profile", linux_profile)
        if local_account_disabled is not None:
            pulumi.set(__self__, "local_account_disabled", local_account_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if maintenance_window_auto_upgrade is not None:
            pulumi.set(__self__, "maintenance_window_auto_upgrade", maintenance_window_auto_upgrade)
        if maintenance_window_node_os is not None:
            pulumi.set(__self__, "maintenance_window_node_os", maintenance_window_node_os)
        if microsoft_defender is not None:
            pulumi.set(__self__, "microsoft_defender", microsoft_defender)
        if monitor_metrics is not None:
            pulumi.set(__self__, "monitor_metrics", monitor_metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if node_os_upgrade_channel is not None:
            pulumi.set(__self__, "node_os_upgrade_channel", node_os_upgrade_channel)
        if node_resource_group is not None:
            pulumi.set(__self__, "node_resource_group", node_resource_group)
        if oidc_issuer_enabled is not None:
            pulumi.set(__self__, "oidc_issuer_enabled", oidc_issuer_enabled)
        if oms_agent is not None:
            pulumi.set(__self__, "oms_agent", oms_agent)
        if open_service_mesh_enabled is not None:
            pulumi.set(__self__, "open_service_mesh_enabled", open_service_mesh_enabled)
        if private_cluster_enabled is not None:
            pulumi.set(__self__, "private_cluster_enabled", private_cluster_enabled)
        if private_cluster_public_fqdn_enabled is not None:
            pulumi.set(__self__, "private_cluster_public_fqdn_enabled", private_cluster_public_fqdn_enabled)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if role_based_access_control_enabled is not None:
            pulumi.set(__self__, "role_based_access_control_enabled", role_based_access_control_enabled)
        if run_command_enabled is not None:
            pulumi.set(__self__, "run_command_enabled", run_command_enabled)
        if service_mesh_profile is not None:
            pulumi.set(__self__, "service_mesh_profile", service_mesh_profile)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if support_plan is not None:
            pulumi.set(__self__, "support_plan", support_plan)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_override is not None:
            pulumi.set(__self__, "upgrade_override", upgrade_override)
        if web_app_routing is not None:
            pulumi.set(__self__, "web_app_routing", web_app_routing)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)
        if workload_autoscaler_profile is not None:
            pulumi.set(__self__, "workload_autoscaler_profile", workload_autoscaler_profile)
        if workload_identity_enabled is not None:
            pulumi.set(__self__, "workload_identity_enabled", workload_identity_enabled)

    @_builtins.property
    @pulumi.getter(name="defaultNodePool")
    def default_node_pool(self) -> pulumi.Input['KubernetesClusterDefaultNodePoolArgs']:
        """
        Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        """
        return pulumi.get(self, "default_node_pool")

    @default_node_pool.setter
    def default_node_pool(self, value: pulumi.Input['KubernetesClusterDefaultNodePoolArgs']):
        pulumi.set(self, "default_node_pool", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="aciConnectorLinux")
    def aci_connector_linux(self) -> Optional[pulumi.Input['KubernetesClusterAciConnectorLinuxArgs']]:
        """
        A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        """
        return pulumi.get(self, "aci_connector_linux")

    @aci_connector_linux.setter
    def aci_connector_linux(self, value: Optional[pulumi.Input['KubernetesClusterAciConnectorLinuxArgs']]):
        pulumi.set(self, "aci_connector_linux", value)

    @_builtins.property
    @pulumi.getter(name="aiToolchainOperatorEnabled")
    def ai_toolchain_operator_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        """
        return pulumi.get(self, "ai_toolchain_operator_enabled")

    @ai_toolchain_operator_enabled.setter
    def ai_toolchain_operator_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_toolchain_operator_enabled", value)

    @_builtins.property
    @pulumi.getter(name="apiServerAccessProfile")
    def api_server_access_profile(self) -> Optional[pulumi.Input['KubernetesClusterApiServerAccessProfileArgs']]:
        """
        An `api_server_access_profile` block as defined below.
        """
        return pulumi.get(self, "api_server_access_profile")

    @api_server_access_profile.setter
    def api_server_access_profile(self, value: Optional[pulumi.Input['KubernetesClusterApiServerAccessProfileArgs']]):
        pulumi.set(self, "api_server_access_profile", value)

    @_builtins.property
    @pulumi.getter(name="autoScalerProfile")
    def auto_scaler_profile(self) -> Optional[pulumi.Input['KubernetesClusterAutoScalerProfileArgs']]:
        """
        A `auto_scaler_profile` block as defined below.
        """
        return pulumi.get(self, "auto_scaler_profile")

    @auto_scaler_profile.setter
    def auto_scaler_profile(self, value: Optional[pulumi.Input['KubernetesClusterAutoScalerProfileArgs']]):
        pulumi.set(self, "auto_scaler_profile", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeChannel")
    def automatic_upgrade_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.

        !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).

        > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        """
        return pulumi.get(self, "automatic_upgrade_channel")

    @automatic_upgrade_channel.setter
    def automatic_upgrade_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_upgrade_channel", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryRoleBasedAccessControl")
    def azure_active_directory_role_based_access_control(self) -> Optional[pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs']]:
        """
        A `azure_active_directory_role_based_access_control` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_role_based_access_control")

    @azure_active_directory_role_based_access_control.setter
    def azure_active_directory_role_based_access_control(self, value: Optional[pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs']]):
        pulumi.set(self, "azure_active_directory_role_based_access_control", value)

    @_builtins.property
    @pulumi.getter(name="azurePolicyEnabled")
    def azure_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        """
        return pulumi.get(self, "azure_policy_enabled")

    @azure_policy_enabled.setter
    def azure_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azure_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapProfile")
    def bootstrap_profile(self) -> Optional[pulumi.Input['KubernetesClusterBootstrapProfileArgs']]:
        """
        A `bootstrap_profile` block as defined below.
        """
        return pulumi.get(self, "bootstrap_profile")

    @bootstrap_profile.setter
    def bootstrap_profile(self, value: Optional[pulumi.Input['KubernetesClusterBootstrapProfileArgs']]):
        pulumi.set(self, "bootstrap_profile", value)

    @_builtins.property
    @pulumi.getter(name="confidentialComputing")
    def confidential_computing(self) -> Optional[pulumi.Input['KubernetesClusterConfidentialComputingArgs']]:
        """
        A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        """
        return pulumi.get(self, "confidential_computing")

    @confidential_computing.setter
    def confidential_computing(self, value: Optional[pulumi.Input['KubernetesClusterConfidentialComputingArgs']]):
        pulumi.set(self, "confidential_computing", value)

    @_builtins.property
    @pulumi.getter(name="costAnalysisEnabled")
    def cost_analysis_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        """
        return pulumi.get(self, "cost_analysis_enabled")

    @cost_analysis_enabled.setter
    def cost_analysis_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cost_analysis_enabled", value)

    @_builtins.property
    @pulumi.getter(name="customCaTrustCertificatesBase64s")
    def custom_ca_trust_certificates_base64s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        """
        return pulumi.get(self, "custom_ca_trust_certificates_base64s")

    @custom_ca_trust_certificates_base64s.setter
    def custom_ca_trust_certificates_base64s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_ca_trust_certificates_base64s", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_prefix")

    @dns_prefix.setter
    def dns_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dnsPrefixPrivateCluster")
    def dns_prefix_private_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.

        > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.

        In addition, one of either `identity` or `service_principal` blocks must be specified.
        """
        return pulumi.get(self, "dns_prefix_private_cluster")

    @dns_prefix_private_cluster.setter
    def dns_prefix_private_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_prefix_private_cluster", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingEnabled")
    def http_application_routing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should HTTP Application Routing be enabled?

        > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        """
        return pulumi.get(self, "http_application_routing_enabled")

    @http_application_routing_enabled.setter
    def http_application_routing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http_application_routing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpProxyConfig")
    def http_proxy_config(self) -> Optional[pulumi.Input['KubernetesClusterHttpProxyConfigArgs']]:
        """
        A `http_proxy_config` block as defined below.
        """
        return pulumi.get(self, "http_proxy_config")

    @http_proxy_config.setter
    def http_proxy_config(self, value: Optional[pulumi.Input['KubernetesClusterHttpProxyConfigArgs']]):
        pulumi.set(self, "http_proxy_config", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['KubernetesClusterIdentityArgs']]:
        """
        An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.

        !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['KubernetesClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="imageCleanerEnabled")
    def image_cleaner_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Image Cleaner is enabled.
        """
        return pulumi.get(self, "image_cleaner_enabled")

    @image_cleaner_enabled.setter
    def image_cleaner_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "image_cleaner_enabled", value)

    @_builtins.property
    @pulumi.getter(name="imageCleanerIntervalHours")
    def image_cleaner_interval_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the interval in hours when images should be cleaned up.
        """
        return pulumi.get(self, "image_cleaner_interval_hours")

    @image_cleaner_interval_hours.setter
    def image_cleaner_interval_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "image_cleaner_interval_hours", value)

    @_builtins.property
    @pulumi.getter(name="ingressApplicationGateway")
    def ingress_application_gateway(self) -> Optional[pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs']]:
        """
        A `ingress_application_gateway` block as defined below.

        > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        """
        return pulumi.get(self, "ingress_application_gateway")

    @ingress_application_gateway.setter
    def ingress_application_gateway(self, value: Optional[pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs']]):
        pulumi.set(self, "ingress_application_gateway", value)

    @_builtins.property
    @pulumi.getter(name="keyManagementService")
    def key_management_service(self) -> Optional[pulumi.Input['KubernetesClusterKeyManagementServiceArgs']]:
        """
        A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        """
        return pulumi.get(self, "key_management_service")

    @key_management_service.setter
    def key_management_service(self, value: Optional[pulumi.Input['KubernetesClusterKeyManagementServiceArgs']]):
        pulumi.set(self, "key_management_service", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretsProvider")
    def key_vault_secrets_provider(self) -> Optional[pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs']]:
        """
        A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        """
        return pulumi.get(self, "key_vault_secrets_provider")

    @key_vault_secrets_provider.setter
    def key_vault_secrets_provider(self, value: Optional[pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs']]):
        pulumi.set(self, "key_vault_secrets_provider", value)

    @_builtins.property
    @pulumi.getter(name="kubeletIdentity")
    def kubelet_identity(self) -> Optional[pulumi.Input['KubernetesClusterKubeletIdentityArgs']]:
        """
        A `kubelet_identity` block as defined below.
        """
        return pulumi.get(self, "kubelet_identity")

    @kubelet_identity.setter
    def kubelet_identity(self, value: Optional[pulumi.Input['KubernetesClusterKubeletIdentityArgs']]):
        pulumi.set(self, "kubelet_identity", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).

        > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> Optional[pulumi.Input['KubernetesClusterLinuxProfileArgs']]:
        """
        A `linux_profile` block as defined below.
        """
        return pulumi.get(self, "linux_profile")

    @linux_profile.setter
    def linux_profile(self, value: Optional[pulumi.Input['KubernetesClusterLinuxProfileArgs']]):
        pulumi.set(self, "linux_profile", value)

    @_builtins.property
    @pulumi.getter(name="localAccountDisabled")
    def local_account_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.

        > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        """
        return pulumi.get(self, "local_account_disabled")

    @local_account_disabled.setter
    def local_account_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_account_disabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['KubernetesClusterMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowAutoUpgrade")
    def maintenance_window_auto_upgrade(self) -> Optional[pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs']]:
        """
        A `maintenance_window_auto_upgrade` block as defined below.
        """
        return pulumi.get(self, "maintenance_window_auto_upgrade")

    @maintenance_window_auto_upgrade.setter
    def maintenance_window_auto_upgrade(self, value: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs']]):
        pulumi.set(self, "maintenance_window_auto_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowNodeOs")
    def maintenance_window_node_os(self) -> Optional[pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs']]:
        """
        A `maintenance_window_node_os` block as defined below.
        """
        return pulumi.get(self, "maintenance_window_node_os")

    @maintenance_window_node_os.setter
    def maintenance_window_node_os(self, value: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs']]):
        pulumi.set(self, "maintenance_window_node_os", value)

    @_builtins.property
    @pulumi.getter(name="microsoftDefender")
    def microsoft_defender(self) -> Optional[pulumi.Input['KubernetesClusterMicrosoftDefenderArgs']]:
        """
        A `microsoft_defender` block as defined below.
        """
        return pulumi.get(self, "microsoft_defender")

    @microsoft_defender.setter
    def microsoft_defender(self, value: Optional[pulumi.Input['KubernetesClusterMicrosoftDefenderArgs']]):
        pulumi.set(self, "microsoft_defender", value)

    @_builtins.property
    @pulumi.getter(name="monitorMetrics")
    def monitor_metrics(self) -> Optional[pulumi.Input['KubernetesClusterMonitorMetricsArgs']]:
        """
        Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.

        > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        """
        return pulumi.get(self, "monitor_metrics")

    @monitor_metrics.setter
    def monitor_metrics(self, value: Optional[pulumi.Input['KubernetesClusterMonitorMetricsArgs']]):
        pulumi.set(self, "monitor_metrics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['KubernetesClusterNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below. Changing this forces a new resource to be created.

        > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['KubernetesClusterNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="nodeOsUpgradeChannel")
    def node_os_upgrade_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.

        > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        """
        return pulumi.get(self, "node_os_upgrade_channel")

    @node_os_upgrade_channel.setter
    def node_os_upgrade_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_os_upgrade_channel", value)

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.

        > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        """
        return pulumi.get(self, "node_resource_group")

    @node_resource_group.setter
    def node_resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="oidcIssuerEnabled")
    def oidc_issuer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        """
        return pulumi.get(self, "oidc_issuer_enabled")

    @oidc_issuer_enabled.setter
    def oidc_issuer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "oidc_issuer_enabled", value)

    @_builtins.property
    @pulumi.getter(name="omsAgent")
    def oms_agent(self) -> Optional[pulumi.Input['KubernetesClusterOmsAgentArgs']]:
        """
        A `oms_agent` block as defined below.
        """
        return pulumi.get(self, "oms_agent")

    @oms_agent.setter
    def oms_agent(self, value: Optional[pulumi.Input['KubernetesClusterOmsAgentArgs']]):
        pulumi.set(self, "oms_agent", value)

    @_builtins.property
    @pulumi.getter(name="openServiceMeshEnabled")
    def open_service_mesh_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        """
        return pulumi.get(self, "open_service_mesh_enabled")

    @open_service_mesh_enabled.setter
    def open_service_mesh_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_service_mesh_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateClusterEnabled")
    def private_cluster_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_cluster_enabled")

    @private_cluster_enabled.setter
    def private_cluster_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_cluster_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateClusterPublicFqdnEnabled")
    def private_cluster_public_fqdn_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.

        > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_zone = azure.privatedns.Zone("example",
            name="privatelink.eastus2.azmk8s.io",
            resource_group_name=example.name)
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="aks-example-identity",
            resource_group_name=example.name,
            location=example.location)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_zone.id,
            role_definition_name="Private DNS Zone Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="aksexamplewithprivatednszone1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="aksexamplednsprefix1",
            private_cluster_enabled=True,
            private_dns_zone_id=example_zone.id,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```
        """
        return pulumi.get(self, "private_cluster_public_fqdn_enabled")

    @private_cluster_public_fqdn_enabled.setter
    def private_cluster_public_fqdn_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_cluster_public_fqdn_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="roleBasedAccessControlEnabled")
    def role_based_access_control_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_based_access_control_enabled")

    @role_based_access_control_enabled.setter
    def role_based_access_control_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "role_based_access_control_enabled", value)

    @_builtins.property
    @pulumi.getter(name="runCommandEnabled")
    def run_command_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable run command for the cluster or not. Defaults to `true`.
        """
        return pulumi.get(self, "run_command_enabled")

    @run_command_enabled.setter
    def run_command_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_command_enabled", value)

    @_builtins.property
    @pulumi.getter(name="serviceMeshProfile")
    def service_mesh_profile(self) -> Optional[pulumi.Input['KubernetesClusterServiceMeshProfileArgs']]:
        """
        A `service_mesh_profile` block as defined below.
        """
        return pulumi.get(self, "service_mesh_profile")

    @service_mesh_profile.setter
    def service_mesh_profile(self, value: Optional[pulumi.Input['KubernetesClusterServiceMeshProfileArgs']]):
        pulumi.set(self, "service_mesh_profile", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional[pulumi.Input['KubernetesClusterServicePrincipalArgs']]:
        """
        A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.

        !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: Optional[pulumi.Input['KubernetesClusterServicePrincipalArgs']]):
        pulumi.set(self, "service_principal", value)

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.

        > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @_builtins.property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['KubernetesClusterStorageProfileArgs']]:
        """
        A `storage_profile` block as defined below.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['KubernetesClusterStorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)

    @_builtins.property
    @pulumi.getter(name="supportPlan")
    def support_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        """
        return pulumi.get(self, "support_plan")

    @support_plan.setter
    def support_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_plan", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradeOverride")
    def upgrade_override(self) -> Optional[pulumi.Input['KubernetesClusterUpgradeOverrideArgs']]:
        """
        A `upgrade_override` block as defined below.
        """
        return pulumi.get(self, "upgrade_override")

    @upgrade_override.setter
    def upgrade_override(self, value: Optional[pulumi.Input['KubernetesClusterUpgradeOverrideArgs']]):
        pulumi.set(self, "upgrade_override", value)

    @_builtins.property
    @pulumi.getter(name="webAppRouting")
    def web_app_routing(self) -> Optional[pulumi.Input['KubernetesClusterWebAppRoutingArgs']]:
        """
        A `web_app_routing` block as defined below.
        """
        return pulumi.get(self, "web_app_routing")

    @web_app_routing.setter
    def web_app_routing(self, value: Optional[pulumi.Input['KubernetesClusterWebAppRoutingArgs']]):
        pulumi.set(self, "web_app_routing", value)

    @_builtins.property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['KubernetesClusterWindowsProfileArgs']]:
        """
        A `windows_profile` block as defined below.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['KubernetesClusterWindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)

    @_builtins.property
    @pulumi.getter(name="workloadAutoscalerProfile")
    def workload_autoscaler_profile(self) -> Optional[pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs']]:
        """
        A `workload_autoscaler_profile` block defined below.
        """
        return pulumi.get(self, "workload_autoscaler_profile")

    @workload_autoscaler_profile.setter
    def workload_autoscaler_profile(self, value: Optional[pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs']]):
        pulumi.set(self, "workload_autoscaler_profile", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityEnabled")
    def workload_identity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.

        > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.

        > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        return pulumi.get(self, "workload_identity_enabled")

    @workload_identity_enabled.setter
    def workload_identity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workload_identity_enabled", value)


@pulumi.input_type
class _KubernetesClusterState:
    def __init__(__self__, *,
                 aci_connector_linux: Optional[pulumi.Input['KubernetesClusterAciConnectorLinuxArgs']] = None,
                 ai_toolchain_operator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_server_access_profile: Optional[pulumi.Input['KubernetesClusterApiServerAccessProfileArgs']] = None,
                 auto_scaler_profile: Optional[pulumi.Input['KubernetesClusterAutoScalerProfileArgs']] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_role_based_access_control: Optional[pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs']] = None,
                 azure_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap_profile: Optional[pulumi.Input['KubernetesClusterBootstrapProfileArgs']] = None,
                 confidential_computing: Optional[pulumi.Input['KubernetesClusterConfidentialComputingArgs']] = None,
                 cost_analysis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 current_kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_ca_trust_certificates_base64s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_node_pool: Optional[pulumi.Input['KubernetesClusterDefaultNodePoolArgs']] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix_private_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 http_application_routing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_application_routing_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_proxy_config: Optional[pulumi.Input['KubernetesClusterHttpProxyConfigArgs']] = None,
                 identity: Optional[pulumi.Input['KubernetesClusterIdentityArgs']] = None,
                 image_cleaner_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_cleaner_interval_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 ingress_application_gateway: Optional[pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs']] = None,
                 key_management_service: Optional[pulumi.Input['KubernetesClusterKeyManagementServiceArgs']] = None,
                 key_vault_secrets_provider: Optional[pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs']] = None,
                 kube_admin_config_raw: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_admin_configs: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeAdminConfigArgs']]]] = None,
                 kube_config_raw: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_configs: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]]] = None,
                 kubelet_identity: Optional[pulumi.Input['KubernetesClusterKubeletIdentityArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_profile: Optional[pulumi.Input['KubernetesClusterLinuxProfileArgs']] = None,
                 local_account_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowArgs']] = None,
                 maintenance_window_auto_upgrade: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs']] = None,
                 maintenance_window_node_os: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs']] = None,
                 microsoft_defender: Optional[pulumi.Input['KubernetesClusterMicrosoftDefenderArgs']] = None,
                 monitor_metrics: Optional[pulumi.Input['KubernetesClusterMonitorMetricsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['KubernetesClusterNetworkProfileArgs']] = None,
                 node_os_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 node_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 node_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_issuer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oidc_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oms_agent: Optional[pulumi.Input['KubernetesClusterOmsAgentArgs']] = None,
                 open_service_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 portal_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 private_cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_public_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_based_access_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_command_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_mesh_profile: Optional[pulumi.Input['KubernetesClusterServiceMeshProfileArgs']] = None,
                 service_principal: Optional[pulumi.Input['KubernetesClusterServicePrincipalArgs']] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_profile: Optional[pulumi.Input['KubernetesClusterStorageProfileArgs']] = None,
                 support_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_override: Optional[pulumi.Input['KubernetesClusterUpgradeOverrideArgs']] = None,
                 web_app_routing: Optional[pulumi.Input['KubernetesClusterWebAppRoutingArgs']] = None,
                 windows_profile: Optional[pulumi.Input['KubernetesClusterWindowsProfileArgs']] = None,
                 workload_autoscaler_profile: Optional[pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs']] = None,
                 workload_identity_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering KubernetesCluster resources.
        :param pulumi.Input['KubernetesClusterAciConnectorLinuxArgs'] aci_connector_linux: A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        :param pulumi.Input[_builtins.bool] ai_toolchain_operator_enabled: Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        :param pulumi.Input['KubernetesClusterApiServerAccessProfileArgs'] api_server_access_profile: An `api_server_access_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterAutoScalerProfileArgs'] auto_scaler_profile: A `auto_scaler_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.
               
               !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
               
               > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        :param pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs'] azure_active_directory_role_based_access_control: A `azure_active_directory_role_based_access_control` block as defined below.
        :param pulumi.Input[_builtins.bool] azure_policy_enabled: Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        :param pulumi.Input['KubernetesClusterBootstrapProfileArgs'] bootstrap_profile: A `bootstrap_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterConfidentialComputingArgs'] confidential_computing: A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        :param pulumi.Input[_builtins.bool] cost_analysis_enabled: Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        :param pulumi.Input[_builtins.str] current_kubernetes_version: The current version running on the Azure Kubernetes Managed Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_ca_trust_certificates_base64s: A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        :param pulumi.Input['KubernetesClusterDefaultNodePoolArgs'] default_node_pool: Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix_private_cluster: Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.
               
               > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.
               
               In addition, one of either `identity` or `service_principal` blocks must be specified.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Azure Kubernetes Managed Cluster.
        :param pulumi.Input[_builtins.bool] http_application_routing_enabled: Should HTTP Application Routing be enabled?
               
               > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        :param pulumi.Input[_builtins.str] http_application_routing_zone_name: The Zone Name of the HTTP Application Routing.
        :param pulumi.Input['KubernetesClusterHttpProxyConfigArgs'] http_proxy_config: A `http_proxy_config` block as defined below.
        :param pulumi.Input['KubernetesClusterIdentityArgs'] identity: An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.bool] image_cleaner_enabled: Specifies whether Image Cleaner is enabled.
        :param pulumi.Input[_builtins.int] image_cleaner_interval_hours: Specifies the interval in hours when images should be cleaned up.
        :param pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs'] ingress_application_gateway: A `ingress_application_gateway` block as defined below.
               
               > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        :param pulumi.Input['KubernetesClusterKeyManagementServiceArgs'] key_management_service: A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        :param pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs'] key_vault_secrets_provider: A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        :param pulumi.Input[_builtins.str] kube_admin_config_raw: Raw Kubernetes config for the admin account to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeAdminConfigArgs']]] kube_admin_configs: A `kube_admin_config` block as defined below. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        :param pulumi.Input[_builtins.str] kube_config_raw: Raw Kubernetes config to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]] kube_configs: A `kube_config` block as defined below.
        :param pulumi.Input['KubernetesClusterKubeletIdentityArgs'] kubelet_identity: A `kubelet_identity` block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version: Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        :param pulumi.Input['KubernetesClusterLinuxProfileArgs'] linux_profile: A `linux_profile` block as defined below.
        :param pulumi.Input[_builtins.bool] local_account_disabled: If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.
               
               > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        :param pulumi.Input[_builtins.str] location: The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs'] maintenance_window_auto_upgrade: A `maintenance_window_auto_upgrade` block as defined below.
        :param pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs'] maintenance_window_node_os: A `maintenance_window_node_os` block as defined below.
        :param pulumi.Input['KubernetesClusterMicrosoftDefenderArgs'] microsoft_defender: A `microsoft_defender` block as defined below.
        :param pulumi.Input['KubernetesClusterMonitorMetricsArgs'] monitor_metrics: Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.
               
               > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        :param pulumi.Input[_builtins.str] name: The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterNetworkProfileArgs'] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        :param pulumi.Input[_builtins.str] node_os_upgrade_channel: The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.
               
               > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        :param pulumi.Input[_builtins.str] node_resource_group: The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.
               
               > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        :param pulumi.Input[_builtins.str] node_resource_group_id: The ID of the Resource Group containing the resources for this Managed Kubernetes Cluster.
        :param pulumi.Input[_builtins.bool] oidc_issuer_enabled: Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        :param pulumi.Input[_builtins.str] oidc_issuer_url: The OIDC issuer URL that is associated with the cluster.
        :param pulumi.Input['KubernetesClusterOmsAgentArgs'] oms_agent: A `oms_agent` block as defined below.
        :param pulumi.Input[_builtins.bool] open_service_mesh_enabled: Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        :param pulumi.Input[_builtins.str] portal_fqdn: The FQDN for the Azure Portal resources when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        :param pulumi.Input[_builtins.bool] private_cluster_enabled: Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_cluster_public_fqdn_enabled: Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.
               
               > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.core.ResourceGroup("example",
                   name="example",
                   location="West Europe")
               example_zone = azure.privatedns.Zone("example",
                   name="privatelink.eastus2.azmk8s.io",
                   resource_group_name=example.name)
               example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
                   name="aks-example-identity",
                   resource_group_name=example.name,
                   location=example.location)
               example_assignment = azure.authorization.Assignment("example",
                   scope=example_zone.id,
                   role_definition_name="Private DNS Zone Contributor",
                   principal_id=example_user_assigned_identity.principal_id)
               example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
                   name="aksexamplewithprivatednszone1",
                   location=example.location,
                   resource_group_name=example.name,
                   dns_prefix="aksexamplednsprefix1",
                   private_cluster_enabled=True,
                   private_dns_zone_id=example_zone.id,
                   opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
               ```
        :param pulumi.Input[_builtins.str] private_dns_zone_id: Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_fqdn: The FQDN for the Kubernetes Cluster when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] role_based_access_control_enabled: Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] run_command_enabled: Whether to enable run command for the cluster or not. Defaults to `true`.
        :param pulumi.Input['KubernetesClusterServiceMeshProfileArgs'] service_mesh_profile: A `service_mesh_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterServicePrincipalArgs'] service_principal: A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.str] sku_tier: The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.
               
               > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        :param pulumi.Input['KubernetesClusterStorageProfileArgs'] storage_profile: A `storage_profile` block as defined below.
        :param pulumi.Input[_builtins.str] support_plan: Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['KubernetesClusterUpgradeOverrideArgs'] upgrade_override: A `upgrade_override` block as defined below.
        :param pulumi.Input['KubernetesClusterWebAppRoutingArgs'] web_app_routing: A `web_app_routing` block as defined below.
        :param pulumi.Input['KubernetesClusterWindowsProfileArgs'] windows_profile: A `windows_profile` block as defined below.
        :param pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs'] workload_autoscaler_profile: A `workload_autoscaler_profile` block defined below.
        :param pulumi.Input[_builtins.bool] workload_identity_enabled: Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.
               
               > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.
               
               > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        if aci_connector_linux is not None:
            pulumi.set(__self__, "aci_connector_linux", aci_connector_linux)
        if ai_toolchain_operator_enabled is not None:
            pulumi.set(__self__, "ai_toolchain_operator_enabled", ai_toolchain_operator_enabled)
        if api_server_access_profile is not None:
            pulumi.set(__self__, "api_server_access_profile", api_server_access_profile)
        if auto_scaler_profile is not None:
            pulumi.set(__self__, "auto_scaler_profile", auto_scaler_profile)
        if automatic_upgrade_channel is not None:
            pulumi.set(__self__, "automatic_upgrade_channel", automatic_upgrade_channel)
        if azure_active_directory_role_based_access_control is not None:
            pulumi.set(__self__, "azure_active_directory_role_based_access_control", azure_active_directory_role_based_access_control)
        if azure_policy_enabled is not None:
            pulumi.set(__self__, "azure_policy_enabled", azure_policy_enabled)
        if bootstrap_profile is not None:
            pulumi.set(__self__, "bootstrap_profile", bootstrap_profile)
        if confidential_computing is not None:
            pulumi.set(__self__, "confidential_computing", confidential_computing)
        if cost_analysis_enabled is not None:
            pulumi.set(__self__, "cost_analysis_enabled", cost_analysis_enabled)
        if current_kubernetes_version is not None:
            pulumi.set(__self__, "current_kubernetes_version", current_kubernetes_version)
        if custom_ca_trust_certificates_base64s is not None:
            pulumi.set(__self__, "custom_ca_trust_certificates_base64s", custom_ca_trust_certificates_base64s)
        if default_node_pool is not None:
            pulumi.set(__self__, "default_node_pool", default_node_pool)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if dns_prefix is not None:
            pulumi.set(__self__, "dns_prefix", dns_prefix)
        if dns_prefix_private_cluster is not None:
            pulumi.set(__self__, "dns_prefix_private_cluster", dns_prefix_private_cluster)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if http_application_routing_enabled is not None:
            pulumi.set(__self__, "http_application_routing_enabled", http_application_routing_enabled)
        if http_application_routing_zone_name is not None:
            pulumi.set(__self__, "http_application_routing_zone_name", http_application_routing_zone_name)
        if http_proxy_config is not None:
            pulumi.set(__self__, "http_proxy_config", http_proxy_config)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if image_cleaner_enabled is not None:
            pulumi.set(__self__, "image_cleaner_enabled", image_cleaner_enabled)
        if image_cleaner_interval_hours is not None:
            pulumi.set(__self__, "image_cleaner_interval_hours", image_cleaner_interval_hours)
        if ingress_application_gateway is not None:
            pulumi.set(__self__, "ingress_application_gateway", ingress_application_gateway)
        if key_management_service is not None:
            pulumi.set(__self__, "key_management_service", key_management_service)
        if key_vault_secrets_provider is not None:
            pulumi.set(__self__, "key_vault_secrets_provider", key_vault_secrets_provider)
        if kube_admin_config_raw is not None:
            pulumi.set(__self__, "kube_admin_config_raw", kube_admin_config_raw)
        if kube_admin_configs is not None:
            pulumi.set(__self__, "kube_admin_configs", kube_admin_configs)
        if kube_config_raw is not None:
            pulumi.set(__self__, "kube_config_raw", kube_config_raw)
        if kube_configs is not None:
            pulumi.set(__self__, "kube_configs", kube_configs)
        if kubelet_identity is not None:
            pulumi.set(__self__, "kubelet_identity", kubelet_identity)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if linux_profile is not None:
            pulumi.set(__self__, "linux_profile", linux_profile)
        if local_account_disabled is not None:
            pulumi.set(__self__, "local_account_disabled", local_account_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if maintenance_window_auto_upgrade is not None:
            pulumi.set(__self__, "maintenance_window_auto_upgrade", maintenance_window_auto_upgrade)
        if maintenance_window_node_os is not None:
            pulumi.set(__self__, "maintenance_window_node_os", maintenance_window_node_os)
        if microsoft_defender is not None:
            pulumi.set(__self__, "microsoft_defender", microsoft_defender)
        if monitor_metrics is not None:
            pulumi.set(__self__, "monitor_metrics", monitor_metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if node_os_upgrade_channel is not None:
            pulumi.set(__self__, "node_os_upgrade_channel", node_os_upgrade_channel)
        if node_resource_group is not None:
            pulumi.set(__self__, "node_resource_group", node_resource_group)
        if node_resource_group_id is not None:
            pulumi.set(__self__, "node_resource_group_id", node_resource_group_id)
        if oidc_issuer_enabled is not None:
            pulumi.set(__self__, "oidc_issuer_enabled", oidc_issuer_enabled)
        if oidc_issuer_url is not None:
            pulumi.set(__self__, "oidc_issuer_url", oidc_issuer_url)
        if oms_agent is not None:
            pulumi.set(__self__, "oms_agent", oms_agent)
        if open_service_mesh_enabled is not None:
            pulumi.set(__self__, "open_service_mesh_enabled", open_service_mesh_enabled)
        if portal_fqdn is not None:
            pulumi.set(__self__, "portal_fqdn", portal_fqdn)
        if private_cluster_enabled is not None:
            pulumi.set(__self__, "private_cluster_enabled", private_cluster_enabled)
        if private_cluster_public_fqdn_enabled is not None:
            pulumi.set(__self__, "private_cluster_public_fqdn_enabled", private_cluster_public_fqdn_enabled)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if private_fqdn is not None:
            pulumi.set(__self__, "private_fqdn", private_fqdn)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if role_based_access_control_enabled is not None:
            pulumi.set(__self__, "role_based_access_control_enabled", role_based_access_control_enabled)
        if run_command_enabled is not None:
            pulumi.set(__self__, "run_command_enabled", run_command_enabled)
        if service_mesh_profile is not None:
            pulumi.set(__self__, "service_mesh_profile", service_mesh_profile)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if support_plan is not None:
            pulumi.set(__self__, "support_plan", support_plan)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_override is not None:
            pulumi.set(__self__, "upgrade_override", upgrade_override)
        if web_app_routing is not None:
            pulumi.set(__self__, "web_app_routing", web_app_routing)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)
        if workload_autoscaler_profile is not None:
            pulumi.set(__self__, "workload_autoscaler_profile", workload_autoscaler_profile)
        if workload_identity_enabled is not None:
            pulumi.set(__self__, "workload_identity_enabled", workload_identity_enabled)

    @_builtins.property
    @pulumi.getter(name="aciConnectorLinux")
    def aci_connector_linux(self) -> Optional[pulumi.Input['KubernetesClusterAciConnectorLinuxArgs']]:
        """
        A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        """
        return pulumi.get(self, "aci_connector_linux")

    @aci_connector_linux.setter
    def aci_connector_linux(self, value: Optional[pulumi.Input['KubernetesClusterAciConnectorLinuxArgs']]):
        pulumi.set(self, "aci_connector_linux", value)

    @_builtins.property
    @pulumi.getter(name="aiToolchainOperatorEnabled")
    def ai_toolchain_operator_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        """
        return pulumi.get(self, "ai_toolchain_operator_enabled")

    @ai_toolchain_operator_enabled.setter
    def ai_toolchain_operator_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_toolchain_operator_enabled", value)

    @_builtins.property
    @pulumi.getter(name="apiServerAccessProfile")
    def api_server_access_profile(self) -> Optional[pulumi.Input['KubernetesClusterApiServerAccessProfileArgs']]:
        """
        An `api_server_access_profile` block as defined below.
        """
        return pulumi.get(self, "api_server_access_profile")

    @api_server_access_profile.setter
    def api_server_access_profile(self, value: Optional[pulumi.Input['KubernetesClusterApiServerAccessProfileArgs']]):
        pulumi.set(self, "api_server_access_profile", value)

    @_builtins.property
    @pulumi.getter(name="autoScalerProfile")
    def auto_scaler_profile(self) -> Optional[pulumi.Input['KubernetesClusterAutoScalerProfileArgs']]:
        """
        A `auto_scaler_profile` block as defined below.
        """
        return pulumi.get(self, "auto_scaler_profile")

    @auto_scaler_profile.setter
    def auto_scaler_profile(self, value: Optional[pulumi.Input['KubernetesClusterAutoScalerProfileArgs']]):
        pulumi.set(self, "auto_scaler_profile", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeChannel")
    def automatic_upgrade_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.

        !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).

        > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        """
        return pulumi.get(self, "automatic_upgrade_channel")

    @automatic_upgrade_channel.setter
    def automatic_upgrade_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_upgrade_channel", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryRoleBasedAccessControl")
    def azure_active_directory_role_based_access_control(self) -> Optional[pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs']]:
        """
        A `azure_active_directory_role_based_access_control` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_role_based_access_control")

    @azure_active_directory_role_based_access_control.setter
    def azure_active_directory_role_based_access_control(self, value: Optional[pulumi.Input['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs']]):
        pulumi.set(self, "azure_active_directory_role_based_access_control", value)

    @_builtins.property
    @pulumi.getter(name="azurePolicyEnabled")
    def azure_policy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        """
        return pulumi.get(self, "azure_policy_enabled")

    @azure_policy_enabled.setter
    def azure_policy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azure_policy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapProfile")
    def bootstrap_profile(self) -> Optional[pulumi.Input['KubernetesClusterBootstrapProfileArgs']]:
        """
        A `bootstrap_profile` block as defined below.
        """
        return pulumi.get(self, "bootstrap_profile")

    @bootstrap_profile.setter
    def bootstrap_profile(self, value: Optional[pulumi.Input['KubernetesClusterBootstrapProfileArgs']]):
        pulumi.set(self, "bootstrap_profile", value)

    @_builtins.property
    @pulumi.getter(name="confidentialComputing")
    def confidential_computing(self) -> Optional[pulumi.Input['KubernetesClusterConfidentialComputingArgs']]:
        """
        A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        """
        return pulumi.get(self, "confidential_computing")

    @confidential_computing.setter
    def confidential_computing(self, value: Optional[pulumi.Input['KubernetesClusterConfidentialComputingArgs']]):
        pulumi.set(self, "confidential_computing", value)

    @_builtins.property
    @pulumi.getter(name="costAnalysisEnabled")
    def cost_analysis_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        """
        return pulumi.get(self, "cost_analysis_enabled")

    @cost_analysis_enabled.setter
    def cost_analysis_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cost_analysis_enabled", value)

    @_builtins.property
    @pulumi.getter(name="currentKubernetesVersion")
    def current_kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current version running on the Azure Kubernetes Managed Cluster.
        """
        return pulumi.get(self, "current_kubernetes_version")

    @current_kubernetes_version.setter
    def current_kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_kubernetes_version", value)

    @_builtins.property
    @pulumi.getter(name="customCaTrustCertificatesBase64s")
    def custom_ca_trust_certificates_base64s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        """
        return pulumi.get(self, "custom_ca_trust_certificates_base64s")

    @custom_ca_trust_certificates_base64s.setter
    def custom_ca_trust_certificates_base64s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_ca_trust_certificates_base64s", value)

    @_builtins.property
    @pulumi.getter(name="defaultNodePool")
    def default_node_pool(self) -> Optional[pulumi.Input['KubernetesClusterDefaultNodePoolArgs']]:
        """
        Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        """
        return pulumi.get(self, "default_node_pool")

    @default_node_pool.setter
    def default_node_pool(self, value: Optional[pulumi.Input['KubernetesClusterDefaultNodePoolArgs']]):
        pulumi.set(self, "default_node_pool", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_prefix")

    @dns_prefix.setter
    def dns_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dnsPrefixPrivateCluster")
    def dns_prefix_private_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.

        > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.

        In addition, one of either `identity` or `service_principal` blocks must be specified.
        """
        return pulumi.get(self, "dns_prefix_private_cluster")

    @dns_prefix_private_cluster.setter
    def dns_prefix_private_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_prefix_private_cluster", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the Azure Kubernetes Managed Cluster.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingEnabled")
    def http_application_routing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should HTTP Application Routing be enabled?

        > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        """
        return pulumi.get(self, "http_application_routing_enabled")

    @http_application_routing_enabled.setter
    def http_application_routing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http_application_routing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingZoneName")
    def http_application_routing_zone_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone Name of the HTTP Application Routing.
        """
        return pulumi.get(self, "http_application_routing_zone_name")

    @http_application_routing_zone_name.setter
    def http_application_routing_zone_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_application_routing_zone_name", value)

    @_builtins.property
    @pulumi.getter(name="httpProxyConfig")
    def http_proxy_config(self) -> Optional[pulumi.Input['KubernetesClusterHttpProxyConfigArgs']]:
        """
        A `http_proxy_config` block as defined below.
        """
        return pulumi.get(self, "http_proxy_config")

    @http_proxy_config.setter
    def http_proxy_config(self, value: Optional[pulumi.Input['KubernetesClusterHttpProxyConfigArgs']]):
        pulumi.set(self, "http_proxy_config", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['KubernetesClusterIdentityArgs']]:
        """
        An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.

        !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['KubernetesClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="imageCleanerEnabled")
    def image_cleaner_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Image Cleaner is enabled.
        """
        return pulumi.get(self, "image_cleaner_enabled")

    @image_cleaner_enabled.setter
    def image_cleaner_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "image_cleaner_enabled", value)

    @_builtins.property
    @pulumi.getter(name="imageCleanerIntervalHours")
    def image_cleaner_interval_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the interval in hours when images should be cleaned up.
        """
        return pulumi.get(self, "image_cleaner_interval_hours")

    @image_cleaner_interval_hours.setter
    def image_cleaner_interval_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "image_cleaner_interval_hours", value)

    @_builtins.property
    @pulumi.getter(name="ingressApplicationGateway")
    def ingress_application_gateway(self) -> Optional[pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs']]:
        """
        A `ingress_application_gateway` block as defined below.

        > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        """
        return pulumi.get(self, "ingress_application_gateway")

    @ingress_application_gateway.setter
    def ingress_application_gateway(self, value: Optional[pulumi.Input['KubernetesClusterIngressApplicationGatewayArgs']]):
        pulumi.set(self, "ingress_application_gateway", value)

    @_builtins.property
    @pulumi.getter(name="keyManagementService")
    def key_management_service(self) -> Optional[pulumi.Input['KubernetesClusterKeyManagementServiceArgs']]:
        """
        A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        """
        return pulumi.get(self, "key_management_service")

    @key_management_service.setter
    def key_management_service(self, value: Optional[pulumi.Input['KubernetesClusterKeyManagementServiceArgs']]):
        pulumi.set(self, "key_management_service", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretsProvider")
    def key_vault_secrets_provider(self) -> Optional[pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs']]:
        """
        A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        """
        return pulumi.get(self, "key_vault_secrets_provider")

    @key_vault_secrets_provider.setter
    def key_vault_secrets_provider(self, value: Optional[pulumi.Input['KubernetesClusterKeyVaultSecretsProviderArgs']]):
        pulumi.set(self, "key_vault_secrets_provider", value)

    @_builtins.property
    @pulumi.getter(name="kubeAdminConfigRaw")
    def kube_admin_config_raw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Raw Kubernetes config for the admin account to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        """
        return pulumi.get(self, "kube_admin_config_raw")

    @kube_admin_config_raw.setter
    def kube_admin_config_raw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_admin_config_raw", value)

    @_builtins.property
    @pulumi.getter(name="kubeAdminConfigs")
    def kube_admin_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeAdminConfigArgs']]]]:
        """
        A `kube_admin_config` block as defined below. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        """
        return pulumi.get(self, "kube_admin_configs")

    @kube_admin_configs.setter
    def kube_admin_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeAdminConfigArgs']]]]):
        pulumi.set(self, "kube_admin_configs", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Raw Kubernetes config to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @kube_config_raw.setter
    def kube_config_raw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config_raw", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfigs")
    def kube_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]]]:
        """
        A `kube_config` block as defined below.
        """
        return pulumi.get(self, "kube_configs")

    @kube_configs.setter
    def kube_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterKubeConfigArgs']]]]):
        pulumi.set(self, "kube_configs", value)

    @_builtins.property
    @pulumi.getter(name="kubeletIdentity")
    def kubelet_identity(self) -> Optional[pulumi.Input['KubernetesClusterKubeletIdentityArgs']]:
        """
        A `kubelet_identity` block as defined below.
        """
        return pulumi.get(self, "kubelet_identity")

    @kubelet_identity.setter
    def kubelet_identity(self, value: Optional[pulumi.Input['KubernetesClusterKubeletIdentityArgs']]):
        pulumi.set(self, "kubelet_identity", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).

        > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> Optional[pulumi.Input['KubernetesClusterLinuxProfileArgs']]:
        """
        A `linux_profile` block as defined below.
        """
        return pulumi.get(self, "linux_profile")

    @linux_profile.setter
    def linux_profile(self, value: Optional[pulumi.Input['KubernetesClusterLinuxProfileArgs']]):
        pulumi.set(self, "linux_profile", value)

    @_builtins.property
    @pulumi.getter(name="localAccountDisabled")
    def local_account_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.

        > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        """
        return pulumi.get(self, "local_account_disabled")

    @local_account_disabled.setter
    def local_account_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_account_disabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['KubernetesClusterMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowAutoUpgrade")
    def maintenance_window_auto_upgrade(self) -> Optional[pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs']]:
        """
        A `maintenance_window_auto_upgrade` block as defined below.
        """
        return pulumi.get(self, "maintenance_window_auto_upgrade")

    @maintenance_window_auto_upgrade.setter
    def maintenance_window_auto_upgrade(self, value: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowAutoUpgradeArgs']]):
        pulumi.set(self, "maintenance_window_auto_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowNodeOs")
    def maintenance_window_node_os(self) -> Optional[pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs']]:
        """
        A `maintenance_window_node_os` block as defined below.
        """
        return pulumi.get(self, "maintenance_window_node_os")

    @maintenance_window_node_os.setter
    def maintenance_window_node_os(self, value: Optional[pulumi.Input['KubernetesClusterMaintenanceWindowNodeOsArgs']]):
        pulumi.set(self, "maintenance_window_node_os", value)

    @_builtins.property
    @pulumi.getter(name="microsoftDefender")
    def microsoft_defender(self) -> Optional[pulumi.Input['KubernetesClusterMicrosoftDefenderArgs']]:
        """
        A `microsoft_defender` block as defined below.
        """
        return pulumi.get(self, "microsoft_defender")

    @microsoft_defender.setter
    def microsoft_defender(self, value: Optional[pulumi.Input['KubernetesClusterMicrosoftDefenderArgs']]):
        pulumi.set(self, "microsoft_defender", value)

    @_builtins.property
    @pulumi.getter(name="monitorMetrics")
    def monitor_metrics(self) -> Optional[pulumi.Input['KubernetesClusterMonitorMetricsArgs']]:
        """
        Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.

        > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        """
        return pulumi.get(self, "monitor_metrics")

    @monitor_metrics.setter
    def monitor_metrics(self, value: Optional[pulumi.Input['KubernetesClusterMonitorMetricsArgs']]):
        pulumi.set(self, "monitor_metrics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['KubernetesClusterNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below. Changing this forces a new resource to be created.

        > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['KubernetesClusterNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="nodeOsUpgradeChannel")
    def node_os_upgrade_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.

        > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        """
        return pulumi.get(self, "node_os_upgrade_channel")

    @node_os_upgrade_channel.setter
    def node_os_upgrade_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_os_upgrade_channel", value)

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.

        > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        """
        return pulumi.get(self, "node_resource_group")

    @node_resource_group.setter
    def node_resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroupId")
    def node_resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource Group containing the resources for this Managed Kubernetes Cluster.
        """
        return pulumi.get(self, "node_resource_group_id")

    @node_resource_group_id.setter
    def node_resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="oidcIssuerEnabled")
    def oidc_issuer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        """
        return pulumi.get(self, "oidc_issuer_enabled")

    @oidc_issuer_enabled.setter
    def oidc_issuer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "oidc_issuer_enabled", value)

    @_builtins.property
    @pulumi.getter(name="oidcIssuerUrl")
    def oidc_issuer_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OIDC issuer URL that is associated with the cluster.
        """
        return pulumi.get(self, "oidc_issuer_url")

    @oidc_issuer_url.setter
    def oidc_issuer_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oidc_issuer_url", value)

    @_builtins.property
    @pulumi.getter(name="omsAgent")
    def oms_agent(self) -> Optional[pulumi.Input['KubernetesClusterOmsAgentArgs']]:
        """
        A `oms_agent` block as defined below.
        """
        return pulumi.get(self, "oms_agent")

    @oms_agent.setter
    def oms_agent(self, value: Optional[pulumi.Input['KubernetesClusterOmsAgentArgs']]):
        pulumi.set(self, "oms_agent", value)

    @_builtins.property
    @pulumi.getter(name="openServiceMeshEnabled")
    def open_service_mesh_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        """
        return pulumi.get(self, "open_service_mesh_enabled")

    @open_service_mesh_enabled.setter
    def open_service_mesh_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_service_mesh_enabled", value)

    @_builtins.property
    @pulumi.getter(name="portalFqdn")
    def portal_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN for the Azure Portal resources when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        """
        return pulumi.get(self, "portal_fqdn")

    @portal_fqdn.setter
    def portal_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="privateClusterEnabled")
    def private_cluster_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_cluster_enabled")

    @private_cluster_enabled.setter
    def private_cluster_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_cluster_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateClusterPublicFqdnEnabled")
    def private_cluster_public_fqdn_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.

        > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_zone = azure.privatedns.Zone("example",
            name="privatelink.eastus2.azmk8s.io",
            resource_group_name=example.name)
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="aks-example-identity",
            resource_group_name=example.name,
            location=example.location)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_zone.id,
            role_definition_name="Private DNS Zone Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="aksexamplewithprivatednszone1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="aksexamplednsprefix1",
            private_cluster_enabled=True,
            private_dns_zone_id=example_zone.id,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```
        """
        return pulumi.get(self, "private_cluster_public_fqdn_enabled")

    @private_cluster_public_fqdn_enabled.setter
    def private_cluster_public_fqdn_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_cluster_public_fqdn_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="privateFqdn")
    def private_fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN for the Kubernetes Cluster when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        """
        return pulumi.get(self, "private_fqdn")

    @private_fqdn.setter
    def private_fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="roleBasedAccessControlEnabled")
    def role_based_access_control_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_based_access_control_enabled")

    @role_based_access_control_enabled.setter
    def role_based_access_control_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "role_based_access_control_enabled", value)

    @_builtins.property
    @pulumi.getter(name="runCommandEnabled")
    def run_command_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable run command for the cluster or not. Defaults to `true`.
        """
        return pulumi.get(self, "run_command_enabled")

    @run_command_enabled.setter
    def run_command_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_command_enabled", value)

    @_builtins.property
    @pulumi.getter(name="serviceMeshProfile")
    def service_mesh_profile(self) -> Optional[pulumi.Input['KubernetesClusterServiceMeshProfileArgs']]:
        """
        A `service_mesh_profile` block as defined below.
        """
        return pulumi.get(self, "service_mesh_profile")

    @service_mesh_profile.setter
    def service_mesh_profile(self, value: Optional[pulumi.Input['KubernetesClusterServiceMeshProfileArgs']]):
        pulumi.set(self, "service_mesh_profile", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional[pulumi.Input['KubernetesClusterServicePrincipalArgs']]:
        """
        A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.

        !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        """
        return pulumi.get(self, "service_principal")

    @service_principal.setter
    def service_principal(self, value: Optional[pulumi.Input['KubernetesClusterServicePrincipalArgs']]):
        pulumi.set(self, "service_principal", value)

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.

        > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @_builtins.property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['KubernetesClusterStorageProfileArgs']]:
        """
        A `storage_profile` block as defined below.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['KubernetesClusterStorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)

    @_builtins.property
    @pulumi.getter(name="supportPlan")
    def support_plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        """
        return pulumi.get(self, "support_plan")

    @support_plan.setter
    def support_plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_plan", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradeOverride")
    def upgrade_override(self) -> Optional[pulumi.Input['KubernetesClusterUpgradeOverrideArgs']]:
        """
        A `upgrade_override` block as defined below.
        """
        return pulumi.get(self, "upgrade_override")

    @upgrade_override.setter
    def upgrade_override(self, value: Optional[pulumi.Input['KubernetesClusterUpgradeOverrideArgs']]):
        pulumi.set(self, "upgrade_override", value)

    @_builtins.property
    @pulumi.getter(name="webAppRouting")
    def web_app_routing(self) -> Optional[pulumi.Input['KubernetesClusterWebAppRoutingArgs']]:
        """
        A `web_app_routing` block as defined below.
        """
        return pulumi.get(self, "web_app_routing")

    @web_app_routing.setter
    def web_app_routing(self, value: Optional[pulumi.Input['KubernetesClusterWebAppRoutingArgs']]):
        pulumi.set(self, "web_app_routing", value)

    @_builtins.property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['KubernetesClusterWindowsProfileArgs']]:
        """
        A `windows_profile` block as defined below.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['KubernetesClusterWindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)

    @_builtins.property
    @pulumi.getter(name="workloadAutoscalerProfile")
    def workload_autoscaler_profile(self) -> Optional[pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs']]:
        """
        A `workload_autoscaler_profile` block defined below.
        """
        return pulumi.get(self, "workload_autoscaler_profile")

    @workload_autoscaler_profile.setter
    def workload_autoscaler_profile(self, value: Optional[pulumi.Input['KubernetesClusterWorkloadAutoscalerProfileArgs']]):
        pulumi.set(self, "workload_autoscaler_profile", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityEnabled")
    def workload_identity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.

        > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.

        > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        return pulumi.get(self, "workload_identity_enabled")

    @workload_identity_enabled.setter
    def workload_identity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "workload_identity_enabled", value)


@pulumi.type_token("azure:containerservice/kubernetesCluster:KubernetesCluster")
class KubernetesCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aci_connector_linux: Optional[pulumi.Input[Union['KubernetesClusterAciConnectorLinuxArgs', 'KubernetesClusterAciConnectorLinuxArgsDict']]] = None,
                 ai_toolchain_operator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_server_access_profile: Optional[pulumi.Input[Union['KubernetesClusterApiServerAccessProfileArgs', 'KubernetesClusterApiServerAccessProfileArgsDict']]] = None,
                 auto_scaler_profile: Optional[pulumi.Input[Union['KubernetesClusterAutoScalerProfileArgs', 'KubernetesClusterAutoScalerProfileArgsDict']]] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_role_based_access_control: Optional[pulumi.Input[Union['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs', 'KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgsDict']]] = None,
                 azure_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap_profile: Optional[pulumi.Input[Union['KubernetesClusterBootstrapProfileArgs', 'KubernetesClusterBootstrapProfileArgsDict']]] = None,
                 confidential_computing: Optional[pulumi.Input[Union['KubernetesClusterConfidentialComputingArgs', 'KubernetesClusterConfidentialComputingArgsDict']]] = None,
                 cost_analysis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_ca_trust_certificates_base64s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_node_pool: Optional[pulumi.Input[Union['KubernetesClusterDefaultNodePoolArgs', 'KubernetesClusterDefaultNodePoolArgsDict']]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix_private_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 http_application_routing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_proxy_config: Optional[pulumi.Input[Union['KubernetesClusterHttpProxyConfigArgs', 'KubernetesClusterHttpProxyConfigArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['KubernetesClusterIdentityArgs', 'KubernetesClusterIdentityArgsDict']]] = None,
                 image_cleaner_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_cleaner_interval_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 ingress_application_gateway: Optional[pulumi.Input[Union['KubernetesClusterIngressApplicationGatewayArgs', 'KubernetesClusterIngressApplicationGatewayArgsDict']]] = None,
                 key_management_service: Optional[pulumi.Input[Union['KubernetesClusterKeyManagementServiceArgs', 'KubernetesClusterKeyManagementServiceArgsDict']]] = None,
                 key_vault_secrets_provider: Optional[pulumi.Input[Union['KubernetesClusterKeyVaultSecretsProviderArgs', 'KubernetesClusterKeyVaultSecretsProviderArgsDict']]] = None,
                 kubelet_identity: Optional[pulumi.Input[Union['KubernetesClusterKubeletIdentityArgs', 'KubernetesClusterKubeletIdentityArgsDict']]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_profile: Optional[pulumi.Input[Union['KubernetesClusterLinuxProfileArgs', 'KubernetesClusterLinuxProfileArgsDict']]] = None,
                 local_account_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowArgs', 'KubernetesClusterMaintenanceWindowArgsDict']]] = None,
                 maintenance_window_auto_upgrade: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowAutoUpgradeArgs', 'KubernetesClusterMaintenanceWindowAutoUpgradeArgsDict']]] = None,
                 maintenance_window_node_os: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowNodeOsArgs', 'KubernetesClusterMaintenanceWindowNodeOsArgsDict']]] = None,
                 microsoft_defender: Optional[pulumi.Input[Union['KubernetesClusterMicrosoftDefenderArgs', 'KubernetesClusterMicrosoftDefenderArgsDict']]] = None,
                 monitor_metrics: Optional[pulumi.Input[Union['KubernetesClusterMonitorMetricsArgs', 'KubernetesClusterMonitorMetricsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['KubernetesClusterNetworkProfileArgs', 'KubernetesClusterNetworkProfileArgsDict']]] = None,
                 node_os_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 node_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_issuer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oms_agent: Optional[pulumi.Input[Union['KubernetesClusterOmsAgentArgs', 'KubernetesClusterOmsAgentArgsDict']]] = None,
                 open_service_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_public_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_based_access_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_command_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_mesh_profile: Optional[pulumi.Input[Union['KubernetesClusterServiceMeshProfileArgs', 'KubernetesClusterServiceMeshProfileArgsDict']]] = None,
                 service_principal: Optional[pulumi.Input[Union['KubernetesClusterServicePrincipalArgs', 'KubernetesClusterServicePrincipalArgsDict']]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_profile: Optional[pulumi.Input[Union['KubernetesClusterStorageProfileArgs', 'KubernetesClusterStorageProfileArgsDict']]] = None,
                 support_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_override: Optional[pulumi.Input[Union['KubernetesClusterUpgradeOverrideArgs', 'KubernetesClusterUpgradeOverrideArgsDict']]] = None,
                 web_app_routing: Optional[pulumi.Input[Union['KubernetesClusterWebAppRoutingArgs', 'KubernetesClusterWebAppRoutingArgsDict']]] = None,
                 windows_profile: Optional[pulumi.Input[Union['KubernetesClusterWindowsProfileArgs', 'KubernetesClusterWindowsProfileArgsDict']]] = None,
                 workload_autoscaler_profile: Optional[pulumi.Input[Union['KubernetesClusterWorkloadAutoscalerProfileArgs', 'KubernetesClusterWorkloadAutoscalerProfileArgsDict']]] = None,
                 workload_identity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Managed Kubernetes Cluster (also known as AKS / Azure Kubernetes Service)

        > **Note:** Due to the fast-moving nature of AKS, we recommend using the latest version of the Azure Provider when using AKS.

        ## Example Usage

        This example provisions a basic Managed Kubernetes Cluster.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-aks1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="exampleaks1",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_D2_v2",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Environment": "Production",
            })
        pulumi.export("clientCertificate", example_kubernetes_cluster.kube_configs[0].client_certificate)
        pulumi.export("kubeConfig", example_kubernetes_cluster.kube_config_raw)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService` - 2025-07-01

        ## Import

        Managed Kubernetes Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/kubernetesCluster:KubernetesCluster cluster1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ContainerService/managedClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesClusterAciConnectorLinuxArgs', 'KubernetesClusterAciConnectorLinuxArgsDict']] aci_connector_linux: A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        :param pulumi.Input[_builtins.bool] ai_toolchain_operator_enabled: Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        :param pulumi.Input[Union['KubernetesClusterApiServerAccessProfileArgs', 'KubernetesClusterApiServerAccessProfileArgsDict']] api_server_access_profile: An `api_server_access_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterAutoScalerProfileArgs', 'KubernetesClusterAutoScalerProfileArgsDict']] auto_scaler_profile: A `auto_scaler_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.
               
               !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
               
               > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        :param pulumi.Input[Union['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs', 'KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgsDict']] azure_active_directory_role_based_access_control: A `azure_active_directory_role_based_access_control` block as defined below.
        :param pulumi.Input[_builtins.bool] azure_policy_enabled: Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        :param pulumi.Input[Union['KubernetesClusterBootstrapProfileArgs', 'KubernetesClusterBootstrapProfileArgsDict']] bootstrap_profile: A `bootstrap_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterConfidentialComputingArgs', 'KubernetesClusterConfidentialComputingArgsDict']] confidential_computing: A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        :param pulumi.Input[_builtins.bool] cost_analysis_enabled: Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_ca_trust_certificates_base64s: A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        :param pulumi.Input[Union['KubernetesClusterDefaultNodePoolArgs', 'KubernetesClusterDefaultNodePoolArgsDict']] default_node_pool: Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix_private_cluster: Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.
               
               > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.
               
               In addition, one of either `identity` or `service_principal` blocks must be specified.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] http_application_routing_enabled: Should HTTP Application Routing be enabled?
               
               > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        :param pulumi.Input[Union['KubernetesClusterHttpProxyConfigArgs', 'KubernetesClusterHttpProxyConfigArgsDict']] http_proxy_config: A `http_proxy_config` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterIdentityArgs', 'KubernetesClusterIdentityArgsDict']] identity: An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.bool] image_cleaner_enabled: Specifies whether Image Cleaner is enabled.
        :param pulumi.Input[_builtins.int] image_cleaner_interval_hours: Specifies the interval in hours when images should be cleaned up.
        :param pulumi.Input[Union['KubernetesClusterIngressApplicationGatewayArgs', 'KubernetesClusterIngressApplicationGatewayArgsDict']] ingress_application_gateway: A `ingress_application_gateway` block as defined below.
               
               > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        :param pulumi.Input[Union['KubernetesClusterKeyManagementServiceArgs', 'KubernetesClusterKeyManagementServiceArgsDict']] key_management_service: A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        :param pulumi.Input[Union['KubernetesClusterKeyVaultSecretsProviderArgs', 'KubernetesClusterKeyVaultSecretsProviderArgsDict']] key_vault_secrets_provider: A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        :param pulumi.Input[Union['KubernetesClusterKubeletIdentityArgs', 'KubernetesClusterKubeletIdentityArgsDict']] kubelet_identity: A `kubelet_identity` block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version: Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        :param pulumi.Input[Union['KubernetesClusterLinuxProfileArgs', 'KubernetesClusterLinuxProfileArgsDict']] linux_profile: A `linux_profile` block as defined below.
        :param pulumi.Input[_builtins.bool] local_account_disabled: If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.
               
               > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        :param pulumi.Input[_builtins.str] location: The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KubernetesClusterMaintenanceWindowArgs', 'KubernetesClusterMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMaintenanceWindowAutoUpgradeArgs', 'KubernetesClusterMaintenanceWindowAutoUpgradeArgsDict']] maintenance_window_auto_upgrade: A `maintenance_window_auto_upgrade` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMaintenanceWindowNodeOsArgs', 'KubernetesClusterMaintenanceWindowNodeOsArgsDict']] maintenance_window_node_os: A `maintenance_window_node_os` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMicrosoftDefenderArgs', 'KubernetesClusterMicrosoftDefenderArgsDict']] microsoft_defender: A `microsoft_defender` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMonitorMetricsArgs', 'KubernetesClusterMonitorMetricsArgsDict']] monitor_metrics: Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.
               
               > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        :param pulumi.Input[_builtins.str] name: The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KubernetesClusterNetworkProfileArgs', 'KubernetesClusterNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        :param pulumi.Input[_builtins.str] node_os_upgrade_channel: The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.
               
               > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        :param pulumi.Input[_builtins.str] node_resource_group: The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.
               
               > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        :param pulumi.Input[_builtins.bool] oidc_issuer_enabled: Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        :param pulumi.Input[Union['KubernetesClusterOmsAgentArgs', 'KubernetesClusterOmsAgentArgsDict']] oms_agent: A `oms_agent` block as defined below.
        :param pulumi.Input[_builtins.bool] open_service_mesh_enabled: Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        :param pulumi.Input[_builtins.bool] private_cluster_enabled: Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_cluster_public_fqdn_enabled: Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.
               
               > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.core.ResourceGroup("example",
                   name="example",
                   location="West Europe")
               example_zone = azure.privatedns.Zone("example",
                   name="privatelink.eastus2.azmk8s.io",
                   resource_group_name=example.name)
               example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
                   name="aks-example-identity",
                   resource_group_name=example.name,
                   location=example.location)
               example_assignment = azure.authorization.Assignment("example",
                   scope=example_zone.id,
                   role_definition_name="Private DNS Zone Contributor",
                   principal_id=example_user_assigned_identity.principal_id)
               example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
                   name="aksexamplewithprivatednszone1",
                   location=example.location,
                   resource_group_name=example.name,
                   dns_prefix="aksexamplednsprefix1",
                   private_cluster_enabled=True,
                   private_dns_zone_id=example_zone.id,
                   opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
               ```
        :param pulumi.Input[_builtins.str] private_dns_zone_id: Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] role_based_access_control_enabled: Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] run_command_enabled: Whether to enable run command for the cluster or not. Defaults to `true`.
        :param pulumi.Input[Union['KubernetesClusterServiceMeshProfileArgs', 'KubernetesClusterServiceMeshProfileArgsDict']] service_mesh_profile: A `service_mesh_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterServicePrincipalArgs', 'KubernetesClusterServicePrincipalArgsDict']] service_principal: A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.str] sku_tier: The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.
               
               > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        :param pulumi.Input[Union['KubernetesClusterStorageProfileArgs', 'KubernetesClusterStorageProfileArgsDict']] storage_profile: A `storage_profile` block as defined below.
        :param pulumi.Input[_builtins.str] support_plan: Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['KubernetesClusterUpgradeOverrideArgs', 'KubernetesClusterUpgradeOverrideArgsDict']] upgrade_override: A `upgrade_override` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterWebAppRoutingArgs', 'KubernetesClusterWebAppRoutingArgsDict']] web_app_routing: A `web_app_routing` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterWindowsProfileArgs', 'KubernetesClusterWindowsProfileArgsDict']] windows_profile: A `windows_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterWorkloadAutoscalerProfileArgs', 'KubernetesClusterWorkloadAutoscalerProfileArgsDict']] workload_autoscaler_profile: A `workload_autoscaler_profile` block defined below.
        :param pulumi.Input[_builtins.bool] workload_identity_enabled: Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.
               
               > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.
               
               > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Managed Kubernetes Cluster (also known as AKS / Azure Kubernetes Service)

        > **Note:** Due to the fast-moving nature of AKS, we recommend using the latest version of the Azure Provider when using AKS.

        ## Example Usage

        This example provisions a basic Managed Kubernetes Cluster.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-aks1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="exampleaks1",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_D2_v2",
            },
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "Environment": "Production",
            })
        pulumi.export("clientCertificate", example_kubernetes_cluster.kube_configs[0].client_certificate)
        pulumi.export("kubeConfig", example_kubernetes_cluster.kube_config_raw)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService` - 2025-07-01

        ## Import

        Managed Kubernetes Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/kubernetesCluster:KubernetesCluster cluster1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ContainerService/managedClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aci_connector_linux: Optional[pulumi.Input[Union['KubernetesClusterAciConnectorLinuxArgs', 'KubernetesClusterAciConnectorLinuxArgsDict']]] = None,
                 ai_toolchain_operator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 api_server_access_profile: Optional[pulumi.Input[Union['KubernetesClusterApiServerAccessProfileArgs', 'KubernetesClusterApiServerAccessProfileArgsDict']]] = None,
                 auto_scaler_profile: Optional[pulumi.Input[Union['KubernetesClusterAutoScalerProfileArgs', 'KubernetesClusterAutoScalerProfileArgsDict']]] = None,
                 automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_active_directory_role_based_access_control: Optional[pulumi.Input[Union['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs', 'KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgsDict']]] = None,
                 azure_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap_profile: Optional[pulumi.Input[Union['KubernetesClusterBootstrapProfileArgs', 'KubernetesClusterBootstrapProfileArgsDict']]] = None,
                 confidential_computing: Optional[pulumi.Input[Union['KubernetesClusterConfidentialComputingArgs', 'KubernetesClusterConfidentialComputingArgsDict']]] = None,
                 cost_analysis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_ca_trust_certificates_base64s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_node_pool: Optional[pulumi.Input[Union['KubernetesClusterDefaultNodePoolArgs', 'KubernetesClusterDefaultNodePoolArgsDict']]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_prefix_private_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 http_application_routing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_proxy_config: Optional[pulumi.Input[Union['KubernetesClusterHttpProxyConfigArgs', 'KubernetesClusterHttpProxyConfigArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['KubernetesClusterIdentityArgs', 'KubernetesClusterIdentityArgsDict']]] = None,
                 image_cleaner_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_cleaner_interval_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 ingress_application_gateway: Optional[pulumi.Input[Union['KubernetesClusterIngressApplicationGatewayArgs', 'KubernetesClusterIngressApplicationGatewayArgsDict']]] = None,
                 key_management_service: Optional[pulumi.Input[Union['KubernetesClusterKeyManagementServiceArgs', 'KubernetesClusterKeyManagementServiceArgsDict']]] = None,
                 key_vault_secrets_provider: Optional[pulumi.Input[Union['KubernetesClusterKeyVaultSecretsProviderArgs', 'KubernetesClusterKeyVaultSecretsProviderArgsDict']]] = None,
                 kubelet_identity: Optional[pulumi.Input[Union['KubernetesClusterKubeletIdentityArgs', 'KubernetesClusterKubeletIdentityArgsDict']]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_profile: Optional[pulumi.Input[Union['KubernetesClusterLinuxProfileArgs', 'KubernetesClusterLinuxProfileArgsDict']]] = None,
                 local_account_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowArgs', 'KubernetesClusterMaintenanceWindowArgsDict']]] = None,
                 maintenance_window_auto_upgrade: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowAutoUpgradeArgs', 'KubernetesClusterMaintenanceWindowAutoUpgradeArgsDict']]] = None,
                 maintenance_window_node_os: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowNodeOsArgs', 'KubernetesClusterMaintenanceWindowNodeOsArgsDict']]] = None,
                 microsoft_defender: Optional[pulumi.Input[Union['KubernetesClusterMicrosoftDefenderArgs', 'KubernetesClusterMicrosoftDefenderArgsDict']]] = None,
                 monitor_metrics: Optional[pulumi.Input[Union['KubernetesClusterMonitorMetricsArgs', 'KubernetesClusterMonitorMetricsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['KubernetesClusterNetworkProfileArgs', 'KubernetesClusterNetworkProfileArgsDict']]] = None,
                 node_os_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 node_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_issuer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 oms_agent: Optional[pulumi.Input[Union['KubernetesClusterOmsAgentArgs', 'KubernetesClusterOmsAgentArgsDict']]] = None,
                 open_service_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_cluster_public_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_based_access_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_command_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_mesh_profile: Optional[pulumi.Input[Union['KubernetesClusterServiceMeshProfileArgs', 'KubernetesClusterServiceMeshProfileArgsDict']]] = None,
                 service_principal: Optional[pulumi.Input[Union['KubernetesClusterServicePrincipalArgs', 'KubernetesClusterServicePrincipalArgsDict']]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_profile: Optional[pulumi.Input[Union['KubernetesClusterStorageProfileArgs', 'KubernetesClusterStorageProfileArgsDict']]] = None,
                 support_plan: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_override: Optional[pulumi.Input[Union['KubernetesClusterUpgradeOverrideArgs', 'KubernetesClusterUpgradeOverrideArgsDict']]] = None,
                 web_app_routing: Optional[pulumi.Input[Union['KubernetesClusterWebAppRoutingArgs', 'KubernetesClusterWebAppRoutingArgsDict']]] = None,
                 windows_profile: Optional[pulumi.Input[Union['KubernetesClusterWindowsProfileArgs', 'KubernetesClusterWindowsProfileArgsDict']]] = None,
                 workload_autoscaler_profile: Optional[pulumi.Input[Union['KubernetesClusterWorkloadAutoscalerProfileArgs', 'KubernetesClusterWorkloadAutoscalerProfileArgsDict']]] = None,
                 workload_identity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesClusterArgs.__new__(KubernetesClusterArgs)

            __props__.__dict__["aci_connector_linux"] = aci_connector_linux
            __props__.__dict__["ai_toolchain_operator_enabled"] = ai_toolchain_operator_enabled
            __props__.__dict__["api_server_access_profile"] = api_server_access_profile
            __props__.__dict__["auto_scaler_profile"] = auto_scaler_profile
            __props__.__dict__["automatic_upgrade_channel"] = automatic_upgrade_channel
            __props__.__dict__["azure_active_directory_role_based_access_control"] = azure_active_directory_role_based_access_control
            __props__.__dict__["azure_policy_enabled"] = azure_policy_enabled
            __props__.__dict__["bootstrap_profile"] = bootstrap_profile
            __props__.__dict__["confidential_computing"] = confidential_computing
            __props__.__dict__["cost_analysis_enabled"] = cost_analysis_enabled
            __props__.__dict__["custom_ca_trust_certificates_base64s"] = custom_ca_trust_certificates_base64s
            if default_node_pool is None and not opts.urn:
                raise TypeError("Missing required property 'default_node_pool'")
            __props__.__dict__["default_node_pool"] = default_node_pool
            __props__.__dict__["disk_encryption_set_id"] = disk_encryption_set_id
            __props__.__dict__["dns_prefix"] = dns_prefix
            __props__.__dict__["dns_prefix_private_cluster"] = dns_prefix_private_cluster
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["http_application_routing_enabled"] = http_application_routing_enabled
            __props__.__dict__["http_proxy_config"] = http_proxy_config
            __props__.__dict__["identity"] = identity
            __props__.__dict__["image_cleaner_enabled"] = image_cleaner_enabled
            __props__.__dict__["image_cleaner_interval_hours"] = image_cleaner_interval_hours
            __props__.__dict__["ingress_application_gateway"] = ingress_application_gateway
            __props__.__dict__["key_management_service"] = key_management_service
            __props__.__dict__["key_vault_secrets_provider"] = key_vault_secrets_provider
            __props__.__dict__["kubelet_identity"] = kubelet_identity
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["linux_profile"] = linux_profile
            __props__.__dict__["local_account_disabled"] = local_account_disabled
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["maintenance_window_auto_upgrade"] = maintenance_window_auto_upgrade
            __props__.__dict__["maintenance_window_node_os"] = maintenance_window_node_os
            __props__.__dict__["microsoft_defender"] = microsoft_defender
            __props__.__dict__["monitor_metrics"] = monitor_metrics
            __props__.__dict__["name"] = name
            __props__.__dict__["network_profile"] = network_profile
            __props__.__dict__["node_os_upgrade_channel"] = node_os_upgrade_channel
            __props__.__dict__["node_resource_group"] = node_resource_group
            __props__.__dict__["oidc_issuer_enabled"] = oidc_issuer_enabled
            __props__.__dict__["oms_agent"] = oms_agent
            __props__.__dict__["open_service_mesh_enabled"] = open_service_mesh_enabled
            __props__.__dict__["private_cluster_enabled"] = private_cluster_enabled
            __props__.__dict__["private_cluster_public_fqdn_enabled"] = private_cluster_public_fqdn_enabled
            __props__.__dict__["private_dns_zone_id"] = private_dns_zone_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["role_based_access_control_enabled"] = role_based_access_control_enabled
            __props__.__dict__["run_command_enabled"] = run_command_enabled
            __props__.__dict__["service_mesh_profile"] = service_mesh_profile
            __props__.__dict__["service_principal"] = service_principal
            __props__.__dict__["sku_tier"] = sku_tier
            __props__.__dict__["storage_profile"] = storage_profile
            __props__.__dict__["support_plan"] = support_plan
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgrade_override"] = upgrade_override
            __props__.__dict__["web_app_routing"] = web_app_routing
            __props__.__dict__["windows_profile"] = windows_profile
            __props__.__dict__["workload_autoscaler_profile"] = workload_autoscaler_profile
            __props__.__dict__["workload_identity_enabled"] = workload_identity_enabled
            __props__.__dict__["current_kubernetes_version"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["http_application_routing_zone_name"] = None
            __props__.__dict__["kube_admin_config_raw"] = None
            __props__.__dict__["kube_admin_configs"] = None
            __props__.__dict__["kube_config_raw"] = None
            __props__.__dict__["kube_configs"] = None
            __props__.__dict__["node_resource_group_id"] = None
            __props__.__dict__["oidc_issuer_url"] = None
            __props__.__dict__["portal_fqdn"] = None
            __props__.__dict__["private_fqdn"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeAdminConfigRaw", "kubeAdminConfigs", "kubeConfigRaw", "kubeConfigs"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(KubernetesCluster, __self__).__init__(
            'azure:containerservice/kubernetesCluster:KubernetesCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aci_connector_linux: Optional[pulumi.Input[Union['KubernetesClusterAciConnectorLinuxArgs', 'KubernetesClusterAciConnectorLinuxArgsDict']]] = None,
            ai_toolchain_operator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            api_server_access_profile: Optional[pulumi.Input[Union['KubernetesClusterApiServerAccessProfileArgs', 'KubernetesClusterApiServerAccessProfileArgsDict']]] = None,
            auto_scaler_profile: Optional[pulumi.Input[Union['KubernetesClusterAutoScalerProfileArgs', 'KubernetesClusterAutoScalerProfileArgsDict']]] = None,
            automatic_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
            azure_active_directory_role_based_access_control: Optional[pulumi.Input[Union['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs', 'KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgsDict']]] = None,
            azure_policy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            bootstrap_profile: Optional[pulumi.Input[Union['KubernetesClusterBootstrapProfileArgs', 'KubernetesClusterBootstrapProfileArgsDict']]] = None,
            confidential_computing: Optional[pulumi.Input[Union['KubernetesClusterConfidentialComputingArgs', 'KubernetesClusterConfidentialComputingArgsDict']]] = None,
            cost_analysis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            current_kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
            custom_ca_trust_certificates_base64s: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_node_pool: Optional[pulumi.Input[Union['KubernetesClusterDefaultNodePoolArgs', 'KubernetesClusterDefaultNodePoolArgsDict']]] = None,
            disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            dns_prefix_private_cluster: Optional[pulumi.Input[_builtins.str]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            http_application_routing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            http_application_routing_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
            http_proxy_config: Optional[pulumi.Input[Union['KubernetesClusterHttpProxyConfigArgs', 'KubernetesClusterHttpProxyConfigArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['KubernetesClusterIdentityArgs', 'KubernetesClusterIdentityArgsDict']]] = None,
            image_cleaner_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            image_cleaner_interval_hours: Optional[pulumi.Input[_builtins.int]] = None,
            ingress_application_gateway: Optional[pulumi.Input[Union['KubernetesClusterIngressApplicationGatewayArgs', 'KubernetesClusterIngressApplicationGatewayArgsDict']]] = None,
            key_management_service: Optional[pulumi.Input[Union['KubernetesClusterKeyManagementServiceArgs', 'KubernetesClusterKeyManagementServiceArgsDict']]] = None,
            key_vault_secrets_provider: Optional[pulumi.Input[Union['KubernetesClusterKeyVaultSecretsProviderArgs', 'KubernetesClusterKeyVaultSecretsProviderArgsDict']]] = None,
            kube_admin_config_raw: Optional[pulumi.Input[_builtins.str]] = None,
            kube_admin_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterKubeAdminConfigArgs', 'KubernetesClusterKubeAdminConfigArgsDict']]]]] = None,
            kube_config_raw: Optional[pulumi.Input[_builtins.str]] = None,
            kube_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterKubeConfigArgs', 'KubernetesClusterKubeConfigArgsDict']]]]] = None,
            kubelet_identity: Optional[pulumi.Input[Union['KubernetesClusterKubeletIdentityArgs', 'KubernetesClusterKubeletIdentityArgsDict']]] = None,
            kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
            linux_profile: Optional[pulumi.Input[Union['KubernetesClusterLinuxProfileArgs', 'KubernetesClusterLinuxProfileArgsDict']]] = None,
            local_account_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowArgs', 'KubernetesClusterMaintenanceWindowArgsDict']]] = None,
            maintenance_window_auto_upgrade: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowAutoUpgradeArgs', 'KubernetesClusterMaintenanceWindowAutoUpgradeArgsDict']]] = None,
            maintenance_window_node_os: Optional[pulumi.Input[Union['KubernetesClusterMaintenanceWindowNodeOsArgs', 'KubernetesClusterMaintenanceWindowNodeOsArgsDict']]] = None,
            microsoft_defender: Optional[pulumi.Input[Union['KubernetesClusterMicrosoftDefenderArgs', 'KubernetesClusterMicrosoftDefenderArgsDict']]] = None,
            monitor_metrics: Optional[pulumi.Input[Union['KubernetesClusterMonitorMetricsArgs', 'KubernetesClusterMonitorMetricsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile: Optional[pulumi.Input[Union['KubernetesClusterNetworkProfileArgs', 'KubernetesClusterNetworkProfileArgsDict']]] = None,
            node_os_upgrade_channel: Optional[pulumi.Input[_builtins.str]] = None,
            node_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            node_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            oidc_issuer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            oidc_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
            oms_agent: Optional[pulumi.Input[Union['KubernetesClusterOmsAgentArgs', 'KubernetesClusterOmsAgentArgsDict']]] = None,
            open_service_mesh_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            portal_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            private_cluster_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            private_cluster_public_fqdn_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            role_based_access_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            run_command_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            service_mesh_profile: Optional[pulumi.Input[Union['KubernetesClusterServiceMeshProfileArgs', 'KubernetesClusterServiceMeshProfileArgsDict']]] = None,
            service_principal: Optional[pulumi.Input[Union['KubernetesClusterServicePrincipalArgs', 'KubernetesClusterServicePrincipalArgsDict']]] = None,
            sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
            storage_profile: Optional[pulumi.Input[Union['KubernetesClusterStorageProfileArgs', 'KubernetesClusterStorageProfileArgsDict']]] = None,
            support_plan: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            upgrade_override: Optional[pulumi.Input[Union['KubernetesClusterUpgradeOverrideArgs', 'KubernetesClusterUpgradeOverrideArgsDict']]] = None,
            web_app_routing: Optional[pulumi.Input[Union['KubernetesClusterWebAppRoutingArgs', 'KubernetesClusterWebAppRoutingArgsDict']]] = None,
            windows_profile: Optional[pulumi.Input[Union['KubernetesClusterWindowsProfileArgs', 'KubernetesClusterWindowsProfileArgsDict']]] = None,
            workload_autoscaler_profile: Optional[pulumi.Input[Union['KubernetesClusterWorkloadAutoscalerProfileArgs', 'KubernetesClusterWorkloadAutoscalerProfileArgsDict']]] = None,
            workload_identity_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'KubernetesCluster':
        """
        Get an existing KubernetesCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesClusterAciConnectorLinuxArgs', 'KubernetesClusterAciConnectorLinuxArgsDict']] aci_connector_linux: A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        :param pulumi.Input[_builtins.bool] ai_toolchain_operator_enabled: Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        :param pulumi.Input[Union['KubernetesClusterApiServerAccessProfileArgs', 'KubernetesClusterApiServerAccessProfileArgsDict']] api_server_access_profile: An `api_server_access_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterAutoScalerProfileArgs', 'KubernetesClusterAutoScalerProfileArgsDict']] auto_scaler_profile: A `auto_scaler_profile` block as defined below.
        :param pulumi.Input[_builtins.str] automatic_upgrade_channel: The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.
               
               !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
               
               > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        :param pulumi.Input[Union['KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgs', 'KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlArgsDict']] azure_active_directory_role_based_access_control: A `azure_active_directory_role_based_access_control` block as defined below.
        :param pulumi.Input[_builtins.bool] azure_policy_enabled: Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        :param pulumi.Input[Union['KubernetesClusterBootstrapProfileArgs', 'KubernetesClusterBootstrapProfileArgsDict']] bootstrap_profile: A `bootstrap_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterConfidentialComputingArgs', 'KubernetesClusterConfidentialComputingArgsDict']] confidential_computing: A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        :param pulumi.Input[_builtins.bool] cost_analysis_enabled: Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        :param pulumi.Input[_builtins.str] current_kubernetes_version: The current version running on the Azure Kubernetes Managed Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_ca_trust_certificates_base64s: A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        :param pulumi.Input[Union['KubernetesClusterDefaultNodePoolArgs', 'KubernetesClusterDefaultNodePoolArgsDict']] default_node_pool: Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix: DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_prefix_private_cluster: Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.
               
               > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.
               
               In addition, one of either `identity` or `service_principal` blocks must be specified.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Azure Kubernetes Managed Cluster.
        :param pulumi.Input[_builtins.bool] http_application_routing_enabled: Should HTTP Application Routing be enabled?
               
               > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        :param pulumi.Input[_builtins.str] http_application_routing_zone_name: The Zone Name of the HTTP Application Routing.
        :param pulumi.Input[Union['KubernetesClusterHttpProxyConfigArgs', 'KubernetesClusterHttpProxyConfigArgsDict']] http_proxy_config: A `http_proxy_config` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterIdentityArgs', 'KubernetesClusterIdentityArgsDict']] identity: An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.bool] image_cleaner_enabled: Specifies whether Image Cleaner is enabled.
        :param pulumi.Input[_builtins.int] image_cleaner_interval_hours: Specifies the interval in hours when images should be cleaned up.
        :param pulumi.Input[Union['KubernetesClusterIngressApplicationGatewayArgs', 'KubernetesClusterIngressApplicationGatewayArgsDict']] ingress_application_gateway: A `ingress_application_gateway` block as defined below.
               
               > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        :param pulumi.Input[Union['KubernetesClusterKeyManagementServiceArgs', 'KubernetesClusterKeyManagementServiceArgsDict']] key_management_service: A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        :param pulumi.Input[Union['KubernetesClusterKeyVaultSecretsProviderArgs', 'KubernetesClusterKeyVaultSecretsProviderArgsDict']] key_vault_secrets_provider: A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        :param pulumi.Input[_builtins.str] kube_admin_config_raw: Raw Kubernetes config for the admin account to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterKubeAdminConfigArgs', 'KubernetesClusterKubeAdminConfigArgsDict']]]] kube_admin_configs: A `kube_admin_config` block as defined below. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        :param pulumi.Input[_builtins.str] kube_config_raw: Raw Kubernetes config to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesClusterKubeConfigArgs', 'KubernetesClusterKubeConfigArgsDict']]]] kube_configs: A `kube_config` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterKubeletIdentityArgs', 'KubernetesClusterKubeletIdentityArgsDict']] kubelet_identity: A `kubelet_identity` block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version: Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        :param pulumi.Input[Union['KubernetesClusterLinuxProfileArgs', 'KubernetesClusterLinuxProfileArgsDict']] linux_profile: A `linux_profile` block as defined below.
        :param pulumi.Input[_builtins.bool] local_account_disabled: If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.
               
               > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        :param pulumi.Input[_builtins.str] location: The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KubernetesClusterMaintenanceWindowArgs', 'KubernetesClusterMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMaintenanceWindowAutoUpgradeArgs', 'KubernetesClusterMaintenanceWindowAutoUpgradeArgsDict']] maintenance_window_auto_upgrade: A `maintenance_window_auto_upgrade` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMaintenanceWindowNodeOsArgs', 'KubernetesClusterMaintenanceWindowNodeOsArgsDict']] maintenance_window_node_os: A `maintenance_window_node_os` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMicrosoftDefenderArgs', 'KubernetesClusterMicrosoftDefenderArgsDict']] microsoft_defender: A `microsoft_defender` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterMonitorMetricsArgs', 'KubernetesClusterMonitorMetricsArgsDict']] monitor_metrics: Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.
               
               > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        :param pulumi.Input[_builtins.str] name: The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KubernetesClusterNetworkProfileArgs', 'KubernetesClusterNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        :param pulumi.Input[_builtins.str] node_os_upgrade_channel: The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.
               
               > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        :param pulumi.Input[_builtins.str] node_resource_group: The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.
               
               > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        :param pulumi.Input[_builtins.str] node_resource_group_id: The ID of the Resource Group containing the resources for this Managed Kubernetes Cluster.
        :param pulumi.Input[_builtins.bool] oidc_issuer_enabled: Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        :param pulumi.Input[_builtins.str] oidc_issuer_url: The OIDC issuer URL that is associated with the cluster.
        :param pulumi.Input[Union['KubernetesClusterOmsAgentArgs', 'KubernetesClusterOmsAgentArgsDict']] oms_agent: A `oms_agent` block as defined below.
        :param pulumi.Input[_builtins.bool] open_service_mesh_enabled: Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        :param pulumi.Input[_builtins.str] portal_fqdn: The FQDN for the Azure Portal resources when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        :param pulumi.Input[_builtins.bool] private_cluster_enabled: Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_cluster_public_fqdn_enabled: Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.
               
               > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.core.ResourceGroup("example",
                   name="example",
                   location="West Europe")
               example_zone = azure.privatedns.Zone("example",
                   name="privatelink.eastus2.azmk8s.io",
                   resource_group_name=example.name)
               example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
                   name="aks-example-identity",
                   resource_group_name=example.name,
                   location=example.location)
               example_assignment = azure.authorization.Assignment("example",
                   scope=example_zone.id,
                   role_definition_name="Private DNS Zone Contributor",
                   principal_id=example_user_assigned_identity.principal_id)
               example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
                   name="aksexamplewithprivatednszone1",
                   location=example.location,
                   resource_group_name=example.name,
                   dns_prefix="aksexamplednsprefix1",
                   private_cluster_enabled=True,
                   private_dns_zone_id=example_zone.id,
                   opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
               ```
        :param pulumi.Input[_builtins.str] private_dns_zone_id: Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_fqdn: The FQDN for the Kubernetes Cluster when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] role_based_access_control_enabled: Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] run_command_enabled: Whether to enable run command for the cluster or not. Defaults to `true`.
        :param pulumi.Input[Union['KubernetesClusterServiceMeshProfileArgs', 'KubernetesClusterServiceMeshProfileArgsDict']] service_mesh_profile: A `service_mesh_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterServicePrincipalArgs', 'KubernetesClusterServicePrincipalArgsDict']] service_principal: A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.
               
               !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        :param pulumi.Input[_builtins.str] sku_tier: The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.
               
               > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        :param pulumi.Input[Union['KubernetesClusterStorageProfileArgs', 'KubernetesClusterStorageProfileArgsDict']] storage_profile: A `storage_profile` block as defined below.
        :param pulumi.Input[_builtins.str] support_plan: Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['KubernetesClusterUpgradeOverrideArgs', 'KubernetesClusterUpgradeOverrideArgsDict']] upgrade_override: A `upgrade_override` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterWebAppRoutingArgs', 'KubernetesClusterWebAppRoutingArgsDict']] web_app_routing: A `web_app_routing` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterWindowsProfileArgs', 'KubernetesClusterWindowsProfileArgsDict']] windows_profile: A `windows_profile` block as defined below.
        :param pulumi.Input[Union['KubernetesClusterWorkloadAutoscalerProfileArgs', 'KubernetesClusterWorkloadAutoscalerProfileArgsDict']] workload_autoscaler_profile: A `workload_autoscaler_profile` block defined below.
        :param pulumi.Input[_builtins.bool] workload_identity_enabled: Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.
               
               > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.
               
               > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesClusterState.__new__(_KubernetesClusterState)

        __props__.__dict__["aci_connector_linux"] = aci_connector_linux
        __props__.__dict__["ai_toolchain_operator_enabled"] = ai_toolchain_operator_enabled
        __props__.__dict__["api_server_access_profile"] = api_server_access_profile
        __props__.__dict__["auto_scaler_profile"] = auto_scaler_profile
        __props__.__dict__["automatic_upgrade_channel"] = automatic_upgrade_channel
        __props__.__dict__["azure_active_directory_role_based_access_control"] = azure_active_directory_role_based_access_control
        __props__.__dict__["azure_policy_enabled"] = azure_policy_enabled
        __props__.__dict__["bootstrap_profile"] = bootstrap_profile
        __props__.__dict__["confidential_computing"] = confidential_computing
        __props__.__dict__["cost_analysis_enabled"] = cost_analysis_enabled
        __props__.__dict__["current_kubernetes_version"] = current_kubernetes_version
        __props__.__dict__["custom_ca_trust_certificates_base64s"] = custom_ca_trust_certificates_base64s
        __props__.__dict__["default_node_pool"] = default_node_pool
        __props__.__dict__["disk_encryption_set_id"] = disk_encryption_set_id
        __props__.__dict__["dns_prefix"] = dns_prefix
        __props__.__dict__["dns_prefix_private_cluster"] = dns_prefix_private_cluster
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["http_application_routing_enabled"] = http_application_routing_enabled
        __props__.__dict__["http_application_routing_zone_name"] = http_application_routing_zone_name
        __props__.__dict__["http_proxy_config"] = http_proxy_config
        __props__.__dict__["identity"] = identity
        __props__.__dict__["image_cleaner_enabled"] = image_cleaner_enabled
        __props__.__dict__["image_cleaner_interval_hours"] = image_cleaner_interval_hours
        __props__.__dict__["ingress_application_gateway"] = ingress_application_gateway
        __props__.__dict__["key_management_service"] = key_management_service
        __props__.__dict__["key_vault_secrets_provider"] = key_vault_secrets_provider
        __props__.__dict__["kube_admin_config_raw"] = kube_admin_config_raw
        __props__.__dict__["kube_admin_configs"] = kube_admin_configs
        __props__.__dict__["kube_config_raw"] = kube_config_raw
        __props__.__dict__["kube_configs"] = kube_configs
        __props__.__dict__["kubelet_identity"] = kubelet_identity
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["linux_profile"] = linux_profile
        __props__.__dict__["local_account_disabled"] = local_account_disabled
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["maintenance_window_auto_upgrade"] = maintenance_window_auto_upgrade
        __props__.__dict__["maintenance_window_node_os"] = maintenance_window_node_os
        __props__.__dict__["microsoft_defender"] = microsoft_defender
        __props__.__dict__["monitor_metrics"] = monitor_metrics
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile"] = network_profile
        __props__.__dict__["node_os_upgrade_channel"] = node_os_upgrade_channel
        __props__.__dict__["node_resource_group"] = node_resource_group
        __props__.__dict__["node_resource_group_id"] = node_resource_group_id
        __props__.__dict__["oidc_issuer_enabled"] = oidc_issuer_enabled
        __props__.__dict__["oidc_issuer_url"] = oidc_issuer_url
        __props__.__dict__["oms_agent"] = oms_agent
        __props__.__dict__["open_service_mesh_enabled"] = open_service_mesh_enabled
        __props__.__dict__["portal_fqdn"] = portal_fqdn
        __props__.__dict__["private_cluster_enabled"] = private_cluster_enabled
        __props__.__dict__["private_cluster_public_fqdn_enabled"] = private_cluster_public_fqdn_enabled
        __props__.__dict__["private_dns_zone_id"] = private_dns_zone_id
        __props__.__dict__["private_fqdn"] = private_fqdn
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["role_based_access_control_enabled"] = role_based_access_control_enabled
        __props__.__dict__["run_command_enabled"] = run_command_enabled
        __props__.__dict__["service_mesh_profile"] = service_mesh_profile
        __props__.__dict__["service_principal"] = service_principal
        __props__.__dict__["sku_tier"] = sku_tier
        __props__.__dict__["storage_profile"] = storage_profile
        __props__.__dict__["support_plan"] = support_plan
        __props__.__dict__["tags"] = tags
        __props__.__dict__["upgrade_override"] = upgrade_override
        __props__.__dict__["web_app_routing"] = web_app_routing
        __props__.__dict__["windows_profile"] = windows_profile
        __props__.__dict__["workload_autoscaler_profile"] = workload_autoscaler_profile
        __props__.__dict__["workload_identity_enabled"] = workload_identity_enabled
        return KubernetesCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aciConnectorLinux")
    def aci_connector_linux(self) -> pulumi.Output[Optional['outputs.KubernetesClusterAciConnectorLinux']]:
        """
        A `aci_connector_linux` block as defined below. For more details, please visit [Create and configure an AKS cluster to use virtual nodes](https://docs.microsoft.com/azure/aks/virtual-nodes-portal).
        """
        return pulumi.get(self, "aci_connector_linux")

    @_builtins.property
    @pulumi.getter(name="aiToolchainOperatorEnabled")
    def ai_toolchain_operator_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the AI Toolchain Operator should be enabled for the Cluster. Defaults to `false`.
        """
        return pulumi.get(self, "ai_toolchain_operator_enabled")

    @_builtins.property
    @pulumi.getter(name="apiServerAccessProfile")
    def api_server_access_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterApiServerAccessProfile']]:
        """
        An `api_server_access_profile` block as defined below.
        """
        return pulumi.get(self, "api_server_access_profile")

    @_builtins.property
    @pulumi.getter(name="autoScalerProfile")
    def auto_scaler_profile(self) -> pulumi.Output['outputs.KubernetesClusterAutoScalerProfile']:
        """
        A `auto_scaler_profile` block as defined below.
        """
        return pulumi.get(self, "auto_scaler_profile")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeChannel")
    def automatic_upgrade_channel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The upgrade channel for this Kubernetes Cluster. Possible values are `patch`, `rapid`, `node-image` and `stable`. Omitting this field sets this value to `none`.

        !> **Note:** Cluster Auto-Upgrade will update the Kubernetes Cluster (and its Node Pools) to the latest GA version of Kubernetes automatically - please [see the Azure documentation for more information](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).

        > **Note:** Cluster Auto-Upgrade only updates to GA versions of Kubernetes and will not update to Preview versions.
        """
        return pulumi.get(self, "automatic_upgrade_channel")

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryRoleBasedAccessControl")
    def azure_active_directory_role_based_access_control(self) -> pulumi.Output[Optional['outputs.KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl']]:
        """
        A `azure_active_directory_role_based_access_control` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory_role_based_access_control")

    @_builtins.property
    @pulumi.getter(name="azurePolicyEnabled")
    def azure_policy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Azure Policy Add-On be enabled? For more details please visit [Understand Azure Policy for Azure Kubernetes Service](https://docs.microsoft.com/en-ie/azure/governance/policy/concepts/rego-for-aks)
        """
        return pulumi.get(self, "azure_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="bootstrapProfile")
    def bootstrap_profile(self) -> pulumi.Output['outputs.KubernetesClusterBootstrapProfile']:
        """
        A `bootstrap_profile` block as defined below.
        """
        return pulumi.get(self, "bootstrap_profile")

    @_builtins.property
    @pulumi.getter(name="confidentialComputing")
    def confidential_computing(self) -> pulumi.Output[Optional['outputs.KubernetesClusterConfidentialComputing']]:
        """
        A `confidential_computing` block as defined below. For more details please [the documentation](https://learn.microsoft.com/en-us/azure/confidential-computing/confidential-nodes-aks-overview)
        """
        return pulumi.get(self, "confidential_computing")

    @_builtins.property
    @pulumi.getter(name="costAnalysisEnabled")
    def cost_analysis_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should cost analysis be enabled for this Kubernetes Cluster? Defaults to `false`. The `sku_tier` must be set to `Standard` or `Premium` to enable this feature. Enabling this will add Kubernetes Namespace and Deployment details to the Cost Analysis views in the Azure portal.
        """
        return pulumi.get(self, "cost_analysis_enabled")

    @_builtins.property
    @pulumi.getter(name="currentKubernetesVersion")
    def current_kubernetes_version(self) -> pulumi.Output[_builtins.str]:
        """
        The current version running on the Azure Kubernetes Managed Cluster.
        """
        return pulumi.get(self, "current_kubernetes_version")

    @_builtins.property
    @pulumi.getter(name="customCaTrustCertificatesBase64s")
    def custom_ca_trust_certificates_base64s(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of up to 10 base64 encoded CA certificates that will be added to the trust store on nodes.
        """
        return pulumi.get(self, "custom_ca_trust_certificates_base64s")

    @_builtins.property
    @pulumi.getter(name="defaultNodePool")
    def default_node_pool(self) -> pulumi.Output['outputs.KubernetesClusterDefaultNodePool']:
        """
        Specifies configuration for "System" mode node pool. A `default_node_pool` block as defined below.
        """
        return pulumi.get(self, "default_node_pool")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Disk Encryption Set which should be used for the Nodes and Volumes. More information [can be found in the documentation](https://docs.microsoft.com/azure/aks/azure-disk-customer-managed-keys). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="dnsPrefix")
    def dns_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        DNS prefix specified when creating the managed cluster. Possible values must begin and end with a letter or number, contain only letters, numbers, and hyphens and be between 1 and 54 characters in length. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_prefix")

    @_builtins.property
    @pulumi.getter(name="dnsPrefixPrivateCluster")
    def dns_prefix_private_cluster(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the DNS prefix to use with private clusters. Changing this forces a new resource to be created.

        > **Note:** You must define either a `dns_prefix` or a `dns_prefix_private_cluster` field.

        In addition, one of either `identity` or `service_principal` blocks must be specified.
        """
        return pulumi.get(self, "dns_prefix_private_cluster")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Extended Zone (formerly called Edge Zone) within the Azure Region where this Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the Azure Kubernetes Managed Cluster.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingEnabled")
    def http_application_routing_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should HTTP Application Routing be enabled?

        > **Note:** At this time HTTP Application Routing is not supported in Azure China or Azure US Government.
        """
        return pulumi.get(self, "http_application_routing_enabled")

    @_builtins.property
    @pulumi.getter(name="httpApplicationRoutingZoneName")
    def http_application_routing_zone_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone Name of the HTTP Application Routing.
        """
        return pulumi.get(self, "http_application_routing_zone_name")

    @_builtins.property
    @pulumi.getter(name="httpProxyConfig")
    def http_proxy_config(self) -> pulumi.Output[Optional['outputs.KubernetesClusterHttpProxyConfig']]:
        """
        A `http_proxy_config` block as defined below.
        """
        return pulumi.get(self, "http_proxy_config")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.KubernetesClusterIdentity']]:
        """
        An `identity` block as defined below. One of either `identity` or `service_principal` must be specified.

        !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="imageCleanerEnabled")
    def image_cleaner_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether Image Cleaner is enabled.
        """
        return pulumi.get(self, "image_cleaner_enabled")

    @_builtins.property
    @pulumi.getter(name="imageCleanerIntervalHours")
    def image_cleaner_interval_hours(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the interval in hours when images should be cleaned up.
        """
        return pulumi.get(self, "image_cleaner_interval_hours")

    @_builtins.property
    @pulumi.getter(name="ingressApplicationGateway")
    def ingress_application_gateway(self) -> pulumi.Output[Optional['outputs.KubernetesClusterIngressApplicationGateway']]:
        """
        A `ingress_application_gateway` block as defined below.

        > **Note:** Since the Application Gateway is deployed inside a Virtual Network, users (and Service Principals) that are operating the Application Gateway must have the `Microsoft.Network/virtualNetworks/subnets/join/action` permission on the Virtual Network or Subnet. For more details, please visit [Virtual Network Permission](https://learn.microsoft.com/en-us/azure/application-gateway/configuration-infrastructure#virtual-network-permission).
        """
        return pulumi.get(self, "ingress_application_gateway")

    @_builtins.property
    @pulumi.getter(name="keyManagementService")
    def key_management_service(self) -> pulumi.Output[Optional['outputs.KubernetesClusterKeyManagementService']]:
        """
        A `key_management_service` block as defined below. For more details, please visit [Key Management Service (KMS) etcd encryption to an AKS cluster](https://learn.microsoft.com/en-us/azure/aks/use-kms-etcd-encryption).
        """
        return pulumi.get(self, "key_management_service")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretsProvider")
    def key_vault_secrets_provider(self) -> pulumi.Output[Optional['outputs.KubernetesClusterKeyVaultSecretsProvider']]:
        """
        A `key_vault_secrets_provider` block as defined below. For more details, please visit [Azure Keyvault Secrets Provider for AKS](https://docs.microsoft.com/azure/aks/csi-secrets-store-driver).
        """
        return pulumi.get(self, "key_vault_secrets_provider")

    @_builtins.property
    @pulumi.getter(name="kubeAdminConfigRaw")
    def kube_admin_config_raw(self) -> pulumi.Output[_builtins.str]:
        """
        Raw Kubernetes config for the admin account to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        """
        return pulumi.get(self, "kube_admin_config_raw")

    @_builtins.property
    @pulumi.getter(name="kubeAdminConfigs")
    def kube_admin_configs(self) -> pulumi.Output[Sequence['outputs.KubernetesClusterKubeAdminConfig']]:
        """
        A `kube_admin_config` block as defined below. This is only available when Role Based Access Control with Azure Active Directory is enabled and local accounts enabled.
        """
        return pulumi.get(self, "kube_admin_configs")

    @_builtins.property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> pulumi.Output[_builtins.str]:
        """
        Raw Kubernetes config to be used by [kubectl](https://kubernetes.io/docs/reference/kubectl/overview/) and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @_builtins.property
    @pulumi.getter(name="kubeConfigs")
    def kube_configs(self) -> pulumi.Output[Sequence['outputs.KubernetesClusterKubeConfig']]:
        """
        A `kube_config` block as defined below.
        """
        return pulumi.get(self, "kube_configs")

    @_builtins.property
    @pulumi.getter(name="kubeletIdentity")
    def kubelet_identity(self) -> pulumi.Output['outputs.KubernetesClusterKubeletIdentity']:
        """
        A `kubelet_identity` block as defined below.
        """
        return pulumi.get(self, "kubelet_identity")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Kubernetes specified when creating the AKS managed cluster. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).

        > **Note:** Upgrading your cluster may take up to 10 minutes per node.
        """
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter(name="linuxProfile")
    def linux_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterLinuxProfile']]:
        """
        A `linux_profile` block as defined below.
        """
        return pulumi.get(self, "linux_profile")

    @_builtins.property
    @pulumi.getter(name="localAccountDisabled")
    def local_account_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true` local accounts will be disabled. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts) for more information.

        > **Note:** If `local_account_disabled` is set to `true`, it is required to enable Kubernetes RBAC and AKS-managed Azure AD integration. See [the documentation](https://docs.microsoft.com/azure/aks/managed-aad#azure-ad-authentication-overview) for more information.
        """
        return pulumi.get(self, "local_account_disabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Managed Kubernetes Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.KubernetesClusterMaintenanceWindow']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowAutoUpgrade")
    def maintenance_window_auto_upgrade(self) -> pulumi.Output[Optional['outputs.KubernetesClusterMaintenanceWindowAutoUpgrade']]:
        """
        A `maintenance_window_auto_upgrade` block as defined below.
        """
        return pulumi.get(self, "maintenance_window_auto_upgrade")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowNodeOs")
    def maintenance_window_node_os(self) -> pulumi.Output[Optional['outputs.KubernetesClusterMaintenanceWindowNodeOs']]:
        """
        A `maintenance_window_node_os` block as defined below.
        """
        return pulumi.get(self, "maintenance_window_node_os")

    @_builtins.property
    @pulumi.getter(name="microsoftDefender")
    def microsoft_defender(self) -> pulumi.Output[Optional['outputs.KubernetesClusterMicrosoftDefender']]:
        """
        A `microsoft_defender` block as defined below.
        """
        return pulumi.get(self, "microsoft_defender")

    @_builtins.property
    @pulumi.getter(name="monitorMetrics")
    def monitor_metrics(self) -> pulumi.Output[Optional['outputs.KubernetesClusterMonitorMetrics']]:
        """
        Specifies a Prometheus add-on profile for the Kubernetes Cluster. A `monitor_metrics` block as defined below.

        > **Note:** If deploying Managed Prometheus, the `monitor_metrics` properties are required to configure the cluster for metrics collection. If no value is needed, set properties to `null`.
        """
        return pulumi.get(self, "monitor_metrics")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Managed Kubernetes Cluster to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output['outputs.KubernetesClusterNetworkProfile']:
        """
        A `network_profile` block as defined below. Changing this forces a new resource to be created.

        > **Note:** If `network_profile` is not defined, `kubenet` profile will be used by default.
        """
        return pulumi.get(self, "network_profile")

    @_builtins.property
    @pulumi.getter(name="nodeOsUpgradeChannel")
    def node_os_upgrade_channel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The upgrade channel for this Kubernetes Cluster Nodes' OS Image. Possible values are `Unmanaged`, `SecurityPatch`, `NodeImage` and `None`. Defaults to `NodeImage`.

        > **Note:** `node_os_upgrade_channel` must be set to `NodeImage` if `automatic_upgrade_channel` has been set to `node-image`
        """
        return pulumi.get(self, "node_os_upgrade_channel")

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroup")
    def node_resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Kubernetes Nodes should exist. Changing this forces a new resource to be created.

        > **Note:** Azure requires that a new, non-existent Resource Group is used, as otherwise, the provisioning of the Kubernetes Service will fail.
        """
        return pulumi.get(self, "node_resource_group")

    @_builtins.property
    @pulumi.getter(name="nodeResourceGroupId")
    def node_resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Resource Group containing the resources for this Managed Kubernetes Cluster.
        """
        return pulumi.get(self, "node_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="oidcIssuerEnabled")
    def oidc_issuer_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or Disable the [OIDC issuer URL](https://learn.microsoft.com/en-gb/azure/aks/use-oidc-issuer)
        """
        return pulumi.get(self, "oidc_issuer_enabled")

    @_builtins.property
    @pulumi.getter(name="oidcIssuerUrl")
    def oidc_issuer_url(self) -> pulumi.Output[_builtins.str]:
        """
        The OIDC issuer URL that is associated with the cluster.
        """
        return pulumi.get(self, "oidc_issuer_url")

    @_builtins.property
    @pulumi.getter(name="omsAgent")
    def oms_agent(self) -> pulumi.Output[Optional['outputs.KubernetesClusterOmsAgent']]:
        """
        A `oms_agent` block as defined below.
        """
        return pulumi.get(self, "oms_agent")

    @_builtins.property
    @pulumi.getter(name="openServiceMeshEnabled")
    def open_service_mesh_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Open Service Mesh enabled? For more details, please visit [Open Service Mesh for AKS](https://docs.microsoft.com/azure/aks/open-service-mesh-about).
        """
        return pulumi.get(self, "open_service_mesh_enabled")

    @_builtins.property
    @pulumi.getter(name="portalFqdn")
    def portal_fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN for the Azure Portal resources when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        """
        return pulumi.get(self, "portal_fqdn")

    @_builtins.property
    @pulumi.getter(name="privateClusterEnabled")
    def private_cluster_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Kubernetes Cluster have its API server only exposed on internal IP addresses? This provides a Private IP Address for the Kubernetes API on the Virtual Network where the Kubernetes Cluster is located. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_cluster_enabled")

    @_builtins.property
    @pulumi.getter(name="privateClusterPublicFqdnEnabled")
    def private_cluster_public_fqdn_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether a Public FQDN for this Private Cluster should be added. Defaults to `false`.

        > **Note:** If you use BYO DNS Zone, the AKS cluster should either use a User Assigned Identity or a service principal (which is deprecated) with the `Private DNS Zone Contributor` role and access to this Private DNS Zone. If `UserAssigned` identity is used - to prevent improper resource order destruction - the cluster should depend on the role assignment, like in this example:

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_zone = azure.privatedns.Zone("example",
            name="privatelink.eastus2.azmk8s.io",
            resource_group_name=example.name)
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="aks-example-identity",
            resource_group_name=example.name,
            location=example.location)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_zone.id,
            role_definition_name="Private DNS Zone Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="aksexamplewithprivatednszone1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="aksexamplednsprefix1",
            private_cluster_enabled=True,
            private_dns_zone_id=example_zone.id,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```
        """
        return pulumi.get(self, "private_cluster_public_fqdn_enabled")

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Either the ID of Private DNS Zone which should be delegated to this Cluster, `System` to have AKS manage this or `None`. In case of `None` you will need to bring your own DNS server and set up resolving, otherwise, the cluster will have issues after provisioning. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @_builtins.property
    @pulumi.getter(name="privateFqdn")
    def private_fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN for the Kubernetes Cluster when private link has been enabled, which is only resolvable inside the Virtual Network used by the Kubernetes Cluster.
        """
        return pulumi.get(self, "private_fqdn")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Resource Group where the Managed Kubernetes Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="roleBasedAccessControlEnabled")
    def role_based_access_control_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Role Based Access Control for the Kubernetes Cluster should be enabled. Defaults to `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_based_access_control_enabled")

    @_builtins.property
    @pulumi.getter(name="runCommandEnabled")
    def run_command_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable run command for the cluster or not. Defaults to `true`.
        """
        return pulumi.get(self, "run_command_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceMeshProfile")
    def service_mesh_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterServiceMeshProfile']]:
        """
        A `service_mesh_profile` block as defined below.
        """
        return pulumi.get(self, "service_mesh_profile")

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> pulumi.Output[Optional['outputs.KubernetesClusterServicePrincipal']]:
        """
        A `service_principal` block as documented below. One of either `identity` or `service_principal` must be specified.

        !> **Note:** A migration scenario from `service_principal` to `identity` is supported. When upgrading `service_principal` to `identity`, your cluster's control plane and addon pods will switch to use managed identity, but the kubelets will keep using your configured `service_principal` until you upgrade your Node Pool.
        """
        return pulumi.get(self, "service_principal")

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SKU Tier that should be used for this Kubernetes Cluster. Possible values are `Free`, `Standard` (which includes the Uptime SLA) and `Premium`. Defaults to `Free`.

        > **Note:** Whilst the AKS API previously supported the `Paid` SKU - the AKS API introduced a breaking change in API Version `2023-02-01` (used in v3.51.0 and later) where the value `Paid` must now be set to `Standard`.
        """
        return pulumi.get(self, "sku_tier")

    @_builtins.property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterStorageProfile']]:
        """
        A `storage_profile` block as defined below.
        """
        return pulumi.get(self, "storage_profile")

    @_builtins.property
    @pulumi.getter(name="supportPlan")
    def support_plan(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the support plan which should be used for this Kubernetes Cluster. Possible values are `KubernetesOfficial` and `AKSLongTermSupport`. Defaults to `KubernetesOfficial`.
        """
        return pulumi.get(self, "support_plan")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="upgradeOverride")
    def upgrade_override(self) -> pulumi.Output[Optional['outputs.KubernetesClusterUpgradeOverride']]:
        """
        A `upgrade_override` block as defined below.
        """
        return pulumi.get(self, "upgrade_override")

    @_builtins.property
    @pulumi.getter(name="webAppRouting")
    def web_app_routing(self) -> pulumi.Output[Optional['outputs.KubernetesClusterWebAppRouting']]:
        """
        A `web_app_routing` block as defined below.
        """
        return pulumi.get(self, "web_app_routing")

    @_builtins.property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> pulumi.Output['outputs.KubernetesClusterWindowsProfile']:
        """
        A `windows_profile` block as defined below.
        """
        return pulumi.get(self, "windows_profile")

    @_builtins.property
    @pulumi.getter(name="workloadAutoscalerProfile")
    def workload_autoscaler_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterWorkloadAutoscalerProfile']]:
        """
        A `workload_autoscaler_profile` block defined below.
        """
        return pulumi.get(self, "workload_autoscaler_profile")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityEnabled")
    def workload_identity_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether Azure AD Workload Identity should be enabled for the Cluster. Defaults to `false`.

        > **Note:** To enable Azure AD Workload Identity `oidc_issuer_enabled` must be set to `true`.

        > **Note:** Enabling this option will allocate Workload Identity resources to the `kube-system` namespace in Kubernetes. If you wish to customize the deployment of Workload Identity, you can refer to [the documentation on Azure AD Workload Identity.](https://azure.github.io/azure-workload-identity/docs/installation/mutating-admission-webhook.html) The documentation provides guidance on how to install the mutating admission webhook, which allows for the customization of Workload Identity deployment.
        """
        return pulumi.get(self, "workload_identity_enabled")

