# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesClusterNodePoolArgs', 'KubernetesClusterNodePool']

@pulumi.input_type
class KubernetesClusterNodePoolArgs:
    def __init__(__self__, *,
                 kubernetes_cluster_id: pulumi.Input[_builtins.str],
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_driver: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 host_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubelet_config: Optional[pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs']] = None,
                 kubelet_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_os_config: Optional[pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs']] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_network_profile: Optional[pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs']] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_public_ip_prefix_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 orchestrator_version: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_max_price: Optional[pulumi.Input[_builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 temporary_name_for_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 ultra_ssd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_settings: Optional[pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs']] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 windows_profile: Optional[pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs']] = None,
                 workload_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a KubernetesClusterNodePool resource.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.
               
               > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        :param pulumi.Input[_builtins.bool] fips_enabled: Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        :param pulumi.Input[_builtins.str] gpu_driver: Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gpu_instance: Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] host_encryption_enabled: Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        :param pulumi.Input[_builtins.str] host_group_id: The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs'] kubelet_config: A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubelet_disk_type: The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs'] linux_os_config: A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.int] max_pods: The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] mode: Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        :param pulumi.Input[_builtins.str] name: The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.
               
               > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs'] node_network_profile: A `node_network_profile` block as documented below.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] node_public_ip_prefix_id: Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        :param pulumi.Input[_builtins.str] orchestrator_version: Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        :param pulumi.Input[_builtins.str] pod_subnet_id: The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] priority: The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.
               
               > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        :param pulumi.Input[_builtins.str] scale_down_mode: Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.float] spot_max_price: The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.
               
               > **Note:** This field can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        :param pulumi.Input[_builtins.str] temporary_name_for_rotation: Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        :param pulumi.Input[_builtins.bool] ultra_ssd_enabled: Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs'] upgrade_settings: A `upgrade_settings` block as documented below.
        :param pulumi.Input[_builtins.str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] vnet_subnet_id: The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** A route table must be configured on this Subnet.
        :param pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs'] windows_profile: A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workload_runtime: Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.
               
               > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if auto_scaling_enabled is not None:
            pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if fips_enabled is not None:
            pulumi.set(__self__, "fips_enabled", fips_enabled)
        if gpu_driver is not None:
            pulumi.set(__self__, "gpu_driver", gpu_driver)
        if gpu_instance is not None:
            pulumi.set(__self__, "gpu_instance", gpu_instance)
        if host_encryption_enabled is not None:
            pulumi.set(__self__, "host_encryption_enabled", host_encryption_enabled)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if kubelet_disk_type is not None:
            pulumi.set(__self__, "kubelet_disk_type", kubelet_disk_type)
        if linux_os_config is not None:
            pulumi.set(__self__, "linux_os_config", linux_os_config)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_network_profile is not None:
            pulumi.set(__self__, "node_network_profile", node_network_profile)
        if node_public_ip_enabled is not None:
            pulumi.set(__self__, "node_public_ip_enabled", node_public_ip_enabled)
        if node_public_ip_prefix_id is not None:
            pulumi.set(__self__, "node_public_ip_prefix_id", node_public_ip_prefix_id)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if orchestrator_version is not None:
            pulumi.set(__self__, "orchestrator_version", orchestrator_version)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_id is not None:
            pulumi.set(__self__, "pod_subnet_id", pod_subnet_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if scale_down_mode is not None:
            pulumi.set(__self__, "scale_down_mode", scale_down_mode)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temporary_name_for_rotation is not None:
            pulumi.set(__self__, "temporary_name_for_rotation", temporary_name_for_rotation)
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if vnet_subnet_id is not None:
            pulumi.set(__self__, "vnet_subnet_id", vnet_subnet_id)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)
        if workload_runtime is not None:
            pulumi.set(__self__, "workload_runtime", workload_runtime)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.

        > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @auto_scaling_enabled.setter
    def auto_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.

        > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        """
        return pulumi.get(self, "fips_enabled")

    @fips_enabled.setter
    def fips_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fips_enabled", value)

    @_builtins.property
    @pulumi.getter(name="gpuDriver")
    def gpu_driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gpu_driver")

    @gpu_driver.setter
    def gpu_driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_driver", value)

    @_builtins.property
    @pulumi.getter(name="gpuInstance")
    def gpu_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gpu_instance")

    @gpu_instance.setter
    def gpu_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_instance", value)

    @_builtins.property
    @pulumi.getter(name="hostEncryptionEnabled")
    def host_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.

        > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        """
        return pulumi.get(self, "host_encryption_enabled")

    @host_encryption_enabled.setter
    def host_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "host_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs']]:
        """
        A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "kubelet_config")

    @kubelet_config.setter
    def kubelet_config(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs']]):
        pulumi.set(self, "kubelet_config", value)

    @_builtins.property
    @pulumi.getter(name="kubeletDiskType")
    def kubelet_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "kubelet_disk_type")

    @kubelet_disk_type.setter
    def kubelet_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubelet_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="linuxOsConfig")
    def linux_os_config(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs']]:
        """
        A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "linux_os_config")

    @linux_os_config.setter
    def linux_os_config(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs']]):
        pulumi.set(self, "linux_os_config", value)

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_count", value)

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pods", value)

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_count", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.

        > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeNetworkProfile")
    def node_network_profile(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs']]:
        """
        A `node_network_profile` block as documented below.
        """
        return pulumi.get(self, "node_network_profile")

    @node_network_profile.setter
    def node_network_profile(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs']]):
        pulumi.set(self, "node_network_profile", value)

    @_builtins.property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @node_public_ip_enabled.setter
    def node_public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "node_public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="nodePublicIpPrefixId")
    def node_public_ip_prefix_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_public_ip_prefix_id")

    @node_public_ip_prefix_id.setter
    def node_public_ip_prefix_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_public_ip_prefix_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_taints", value)

    @_builtins.property
    @pulumi.getter(name="orchestratorVersion")
    def orchestrator_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).

        > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        """
        return pulumi.get(self, "orchestrator_version")

    @orchestrator_version.setter
    def orchestrator_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "orchestrator_version", value)

    @_builtins.property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_sku", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="podSubnetId")
    def pod_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "pod_subnet_id")

    @pod_subnet_id.setter
    def pod_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.

        > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownMode")
    def scale_down_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        """
        return pulumi.get(self, "scale_down_mode")

    @scale_down_mode.setter
    def scale_down_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_down_mode", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.

        > **Note:** This field can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "spot_max_price")

    @spot_max_price.setter
    def spot_max_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_max_price", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.

        > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="temporaryNameForRotation")
    def temporary_name_for_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        """
        return pulumi.get(self, "temporary_name_for_rotation")

    @temporary_name_for_rotation.setter
    def temporary_name_for_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "temporary_name_for_rotation", value)

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "ultra_ssd_enabled")

    @ultra_ssd_enabled.setter
    def ultra_ssd_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ultra_ssd_enabled", value)

    @_builtins.property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs']]:
        """
        A `upgrade_settings` block as documented below.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_size", value)

    @_builtins.property
    @pulumi.getter(name="vnetSubnetId")
    def vnet_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.

        > **NOTE:** A route table must be configured on this Subnet.
        """
        return pulumi.get(self, "vnet_subnet_id")

    @vnet_subnet_id.setter
    def vnet_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs']]:
        """
        A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)

    @_builtins.property
    @pulumi.getter(name="workloadRuntime")
    def workload_runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.

        > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        """
        return pulumi.get(self, "workload_runtime")

    @workload_runtime.setter
    def workload_runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_runtime", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _KubernetesClusterNodePoolState:
    def __init__(__self__, *,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_driver: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 host_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubelet_config: Optional[pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs']] = None,
                 kubelet_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_os_config: Optional[pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs']] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_network_profile: Optional[pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs']] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_public_ip_prefix_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 orchestrator_version: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_max_price: Optional[pulumi.Input[_builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 temporary_name_for_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 ultra_ssd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_settings: Optional[pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs']] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 windows_profile: Optional[pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs']] = None,
                 workload_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering KubernetesClusterNodePool resources.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        :param pulumi.Input[_builtins.bool] fips_enabled: Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        :param pulumi.Input[_builtins.str] gpu_driver: Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gpu_instance: Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] host_encryption_enabled: Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        :param pulumi.Input[_builtins.str] host_group_id: The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        :param pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs'] kubelet_config: A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubelet_disk_type: The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.
               
               > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        :param pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs'] linux_os_config: A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.int] max_pods: The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] mode: Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        :param pulumi.Input[_builtins.str] name: The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.
               
               > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs'] node_network_profile: A `node_network_profile` block as documented below.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] node_public_ip_prefix_id: Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        :param pulumi.Input[_builtins.str] orchestrator_version: Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        :param pulumi.Input[_builtins.str] pod_subnet_id: The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] priority: The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.
               
               > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        :param pulumi.Input[_builtins.str] scale_down_mode: Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.float] spot_max_price: The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.
               
               > **Note:** This field can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        :param pulumi.Input[_builtins.str] temporary_name_for_rotation: Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        :param pulumi.Input[_builtins.bool] ultra_ssd_enabled: Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs'] upgrade_settings: A `upgrade_settings` block as documented below.
        :param pulumi.Input[_builtins.str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] vnet_subnet_id: The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** A route table must be configured on this Subnet.
        :param pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs'] windows_profile: A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workload_runtime: Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.
               
               > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        if auto_scaling_enabled is not None:
            pulumi.set(__self__, "auto_scaling_enabled", auto_scaling_enabled)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if fips_enabled is not None:
            pulumi.set(__self__, "fips_enabled", fips_enabled)
        if gpu_driver is not None:
            pulumi.set(__self__, "gpu_driver", gpu_driver)
        if gpu_instance is not None:
            pulumi.set(__self__, "gpu_instance", gpu_instance)
        if host_encryption_enabled is not None:
            pulumi.set(__self__, "host_encryption_enabled", host_encryption_enabled)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if kubelet_disk_type is not None:
            pulumi.set(__self__, "kubelet_disk_type", kubelet_disk_type)
        if kubernetes_cluster_id is not None:
            pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if linux_os_config is not None:
            pulumi.set(__self__, "linux_os_config", linux_os_config)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_network_profile is not None:
            pulumi.set(__self__, "node_network_profile", node_network_profile)
        if node_public_ip_enabled is not None:
            pulumi.set(__self__, "node_public_ip_enabled", node_public_ip_enabled)
        if node_public_ip_prefix_id is not None:
            pulumi.set(__self__, "node_public_ip_prefix_id", node_public_ip_prefix_id)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if orchestrator_version is not None:
            pulumi.set(__self__, "orchestrator_version", orchestrator_version)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_id is not None:
            pulumi.set(__self__, "pod_subnet_id", pod_subnet_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if scale_down_mode is not None:
            pulumi.set(__self__, "scale_down_mode", scale_down_mode)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temporary_name_for_rotation is not None:
            pulumi.set(__self__, "temporary_name_for_rotation", temporary_name_for_rotation)
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if vnet_subnet_id is not None:
            pulumi.set(__self__, "vnet_subnet_id", vnet_subnet_id)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)
        if workload_runtime is not None:
            pulumi.set(__self__, "workload_runtime", workload_runtime)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @auto_scaling_enabled.setter
    def auto_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.

        > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        """
        return pulumi.get(self, "fips_enabled")

    @fips_enabled.setter
    def fips_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fips_enabled", value)

    @_builtins.property
    @pulumi.getter(name="gpuDriver")
    def gpu_driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gpu_driver")

    @gpu_driver.setter
    def gpu_driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_driver", value)

    @_builtins.property
    @pulumi.getter(name="gpuInstance")
    def gpu_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gpu_instance")

    @gpu_instance.setter
    def gpu_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_instance", value)

    @_builtins.property
    @pulumi.getter(name="hostEncryptionEnabled")
    def host_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.

        > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        """
        return pulumi.get(self, "host_encryption_enabled")

    @host_encryption_enabled.setter
    def host_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "host_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs']]:
        """
        A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "kubelet_config")

    @kubelet_config.setter
    def kubelet_config(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolKubeletConfigArgs']]):
        pulumi.set(self, "kubelet_config", value)

    @_builtins.property
    @pulumi.getter(name="kubeletDiskType")
    def kubelet_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "kubelet_disk_type")

    @kubelet_disk_type.setter
    def kubelet_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubelet_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.

        > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="linuxOsConfig")
    def linux_os_config(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs']]:
        """
        A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "linux_os_config")

    @linux_os_config.setter
    def linux_os_config(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolLinuxOsConfigArgs']]):
        pulumi.set(self, "linux_os_config", value)

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_count", value)

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pods", value)

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_count", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.

        > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeNetworkProfile")
    def node_network_profile(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs']]:
        """
        A `node_network_profile` block as documented below.
        """
        return pulumi.get(self, "node_network_profile")

    @node_network_profile.setter
    def node_network_profile(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolNodeNetworkProfileArgs']]):
        pulumi.set(self, "node_network_profile", value)

    @_builtins.property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @node_public_ip_enabled.setter
    def node_public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "node_public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="nodePublicIpPrefixId")
    def node_public_ip_prefix_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_public_ip_prefix_id")

    @node_public_ip_prefix_id.setter
    def node_public_ip_prefix_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_public_ip_prefix_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_taints", value)

    @_builtins.property
    @pulumi.getter(name="orchestratorVersion")
    def orchestrator_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).

        > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        """
        return pulumi.get(self, "orchestrator_version")

    @orchestrator_version.setter
    def orchestrator_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "orchestrator_version", value)

    @_builtins.property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_sku", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="podSubnetId")
    def pod_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "pod_subnet_id")

    @pod_subnet_id.setter
    def pod_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.

        > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownMode")
    def scale_down_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        """
        return pulumi.get(self, "scale_down_mode")

    @scale_down_mode.setter
    def scale_down_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scale_down_mode", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.

        > **Note:** This field can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "spot_max_price")

    @spot_max_price.setter
    def spot_max_price(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "spot_max_price", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.

        > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="temporaryNameForRotation")
    def temporary_name_for_rotation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        """
        return pulumi.get(self, "temporary_name_for_rotation")

    @temporary_name_for_rotation.setter
    def temporary_name_for_rotation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "temporary_name_for_rotation", value)

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "ultra_ssd_enabled")

    @ultra_ssd_enabled.setter
    def ultra_ssd_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ultra_ssd_enabled", value)

    @_builtins.property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs']]:
        """
        A `upgrade_settings` block as documented below.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolUpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_size", value)

    @_builtins.property
    @pulumi.getter(name="vnetSubnetId")
    def vnet_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.

        > **NOTE:** A route table must be configured on this Subnet.
        """
        return pulumi.get(self, "vnet_subnet_id")

    @vnet_subnet_id.setter
    def vnet_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs']]:
        """
        A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['KubernetesClusterNodePoolWindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)

    @_builtins.property
    @pulumi.getter(name="workloadRuntime")
    def workload_runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.

        > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        """
        return pulumi.get(self, "workload_runtime")

    @workload_runtime.setter
    def workload_runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_runtime", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:containerservice/kubernetesClusterNodePool:KubernetesClusterNodePool")
class KubernetesClusterNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_driver: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 host_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubelet_config: Optional[pulumi.Input[Union['KubernetesClusterNodePoolKubeletConfigArgs', 'KubernetesClusterNodePoolKubeletConfigArgsDict']]] = None,
                 kubelet_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_os_config: Optional[pulumi.Input[Union['KubernetesClusterNodePoolLinuxOsConfigArgs', 'KubernetesClusterNodePoolLinuxOsConfigArgsDict']]] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_network_profile: Optional[pulumi.Input[Union['KubernetesClusterNodePoolNodeNetworkProfileArgs', 'KubernetesClusterNodePoolNodeNetworkProfileArgsDict']]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_public_ip_prefix_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 orchestrator_version: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_max_price: Optional[pulumi.Input[_builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 temporary_name_for_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 ultra_ssd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_settings: Optional[pulumi.Input[Union['KubernetesClusterNodePoolUpgradeSettingsArgs', 'KubernetesClusterNodePoolUpgradeSettingsArgsDict']]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 windows_profile: Optional[pulumi.Input[Union['KubernetesClusterNodePoolWindowsProfileArgs', 'KubernetesClusterNodePoolWindowsProfileArgsDict']]] = None,
                 workload_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Node Pool within a Kubernetes Cluster

        > **NOTE:** Multiple Node Pools are only supported when the Kubernetes Cluster is using Virtual Machine Scale Sets.

        > **Note:** Changing certain properties is done by cycling the node pool. When cycling it, it doesn’t perform cordon and drain, and it will disrupt rescheduling pods currently running on the previous node pool. `temporary_name_for_rotation` must be specified when changing any of the following properties: `fips_enabled`, `host_encryption_enabled`, `kubelet_config`, `kubelet_disk_type`, `linux_os_config`, `max_pods`, `node_public_ip_enabled`, `os_disk_size_gb`, `os_disk_type`, `pod_subnet_id`, `snapshot_id`, `ultra_ssd_enabled`, `vm_size`, `vnet_subnet_id`, `zones`.

        ## Example Usage

        This example provisions a basic Kubernetes Node Pool.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-aks1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="exampleaks1",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_D2_v2",
            },
            service_principal={
                "client_id": "00000000-0000-0000-0000-000000000000",
                "client_secret": "00000000000000000000000000000000",
            })
        example_kubernetes_cluster_node_pool = azure.containerservice.KubernetesClusterNodePool("example",
            name="internal",
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            vm_size="Standard_DS2_v2",
            node_count=1,
            tags={
                "Environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService` - 2025-07-01

        ## Import

        Kubernetes Cluster Node Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/kubernetesClusterNodePool:KubernetesClusterNodePool pool1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        :param pulumi.Input[_builtins.bool] fips_enabled: Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        :param pulumi.Input[_builtins.str] gpu_driver: Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gpu_instance: Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] host_encryption_enabled: Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        :param pulumi.Input[_builtins.str] host_group_id: The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KubernetesClusterNodePoolKubeletConfigArgs', 'KubernetesClusterNodePoolKubeletConfigArgsDict']] kubelet_config: A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubelet_disk_type: The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.
               
               > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        :param pulumi.Input[Union['KubernetesClusterNodePoolLinuxOsConfigArgs', 'KubernetesClusterNodePoolLinuxOsConfigArgsDict']] linux_os_config: A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.int] max_pods: The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] mode: Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        :param pulumi.Input[_builtins.str] name: The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.
               
               > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input[Union['KubernetesClusterNodePoolNodeNetworkProfileArgs', 'KubernetesClusterNodePoolNodeNetworkProfileArgsDict']] node_network_profile: A `node_network_profile` block as documented below.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] node_public_ip_prefix_id: Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        :param pulumi.Input[_builtins.str] orchestrator_version: Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        :param pulumi.Input[_builtins.str] pod_subnet_id: The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] priority: The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.
               
               > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        :param pulumi.Input[_builtins.str] scale_down_mode: Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.float] spot_max_price: The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.
               
               > **Note:** This field can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        :param pulumi.Input[_builtins.str] temporary_name_for_rotation: Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        :param pulumi.Input[_builtins.bool] ultra_ssd_enabled: Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[Union['KubernetesClusterNodePoolUpgradeSettingsArgs', 'KubernetesClusterNodePoolUpgradeSettingsArgsDict']] upgrade_settings: A `upgrade_settings` block as documented below.
        :param pulumi.Input[_builtins.str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] vnet_subnet_id: The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** A route table must be configured on this Subnet.
        :param pulumi.Input[Union['KubernetesClusterNodePoolWindowsProfileArgs', 'KubernetesClusterNodePoolWindowsProfileArgsDict']] windows_profile: A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workload_runtime: Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.
               
               > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesClusterNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Node Pool within a Kubernetes Cluster

        > **NOTE:** Multiple Node Pools are only supported when the Kubernetes Cluster is using Virtual Machine Scale Sets.

        > **Note:** Changing certain properties is done by cycling the node pool. When cycling it, it doesn’t perform cordon and drain, and it will disrupt rescheduling pods currently running on the previous node pool. `temporary_name_for_rotation` must be specified when changing any of the following properties: `fips_enabled`, `host_encryption_enabled`, `kubelet_config`, `kubelet_disk_type`, `linux_os_config`, `max_pods`, `node_public_ip_enabled`, `os_disk_size_gb`, `os_disk_type`, `pod_subnet_id`, `snapshot_id`, `ultra_ssd_enabled`, `vm_size`, `vnet_subnet_id`, `zones`.

        ## Example Usage

        This example provisions a basic Kubernetes Node Pool.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-aks1",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="exampleaks1",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_D2_v2",
            },
            service_principal={
                "client_id": "00000000-0000-0000-0000-000000000000",
                "client_secret": "00000000000000000000000000000000",
            })
        example_kubernetes_cluster_node_pool = azure.containerservice.KubernetesClusterNodePool("example",
            name="internal",
            kubernetes_cluster_id=example_kubernetes_cluster.id,
            vm_size="Standard_DS2_v2",
            node_count=1,
            tags={
                "Environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService` - 2025-07-01

        ## Import

        Kubernetes Cluster Node Pools can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/kubernetesClusterNodePool:KubernetesClusterNodePool pool1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesClusterNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesClusterNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu_driver: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_instance: Optional[pulumi.Input[_builtins.str]] = None,
                 host_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubelet_config: Optional[pulumi.Input[Union['KubernetesClusterNodePoolKubeletConfigArgs', 'KubernetesClusterNodePoolKubeletConfigArgsDict']]] = None,
                 kubelet_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 linux_os_config: Optional[pulumi.Input[Union['KubernetesClusterNodePoolLinuxOsConfigArgs', 'KubernetesClusterNodePoolLinuxOsConfigArgsDict']]] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_network_profile: Optional[pulumi.Input[Union['KubernetesClusterNodePoolNodeNetworkProfileArgs', 'KubernetesClusterNodePoolNodeNetworkProfileArgsDict']]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_public_ip_prefix_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 orchestrator_version: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scale_down_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_max_price: Optional[pulumi.Input[_builtins.float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 temporary_name_for_rotation: Optional[pulumi.Input[_builtins.str]] = None,
                 ultra_ssd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_settings: Optional[pulumi.Input[Union['KubernetesClusterNodePoolUpgradeSettingsArgs', 'KubernetesClusterNodePoolUpgradeSettingsArgsDict']]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 windows_profile: Optional[pulumi.Input[Union['KubernetesClusterNodePoolWindowsProfileArgs', 'KubernetesClusterNodePoolWindowsProfileArgsDict']]] = None,
                 workload_runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesClusterNodePoolArgs.__new__(KubernetesClusterNodePoolArgs)

            __props__.__dict__["auto_scaling_enabled"] = auto_scaling_enabled
            __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["fips_enabled"] = fips_enabled
            __props__.__dict__["gpu_driver"] = gpu_driver
            __props__.__dict__["gpu_instance"] = gpu_instance
            __props__.__dict__["host_encryption_enabled"] = host_encryption_enabled
            __props__.__dict__["host_group_id"] = host_group_id
            __props__.__dict__["kubelet_config"] = kubelet_config
            __props__.__dict__["kubelet_disk_type"] = kubelet_disk_type
            if kubernetes_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_cluster_id'")
            __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
            __props__.__dict__["linux_os_config"] = linux_os_config
            __props__.__dict__["max_count"] = max_count
            __props__.__dict__["max_pods"] = max_pods
            __props__.__dict__["min_count"] = min_count
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["node_labels"] = node_labels
            __props__.__dict__["node_network_profile"] = node_network_profile
            __props__.__dict__["node_public_ip_enabled"] = node_public_ip_enabled
            __props__.__dict__["node_public_ip_prefix_id"] = node_public_ip_prefix_id
            __props__.__dict__["node_taints"] = node_taints
            __props__.__dict__["orchestrator_version"] = orchestrator_version
            __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
            __props__.__dict__["os_disk_type"] = os_disk_type
            __props__.__dict__["os_sku"] = os_sku
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["pod_subnet_id"] = pod_subnet_id
            __props__.__dict__["priority"] = priority
            __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
            __props__.__dict__["scale_down_mode"] = scale_down_mode
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["spot_max_price"] = spot_max_price
            __props__.__dict__["tags"] = tags
            __props__.__dict__["temporary_name_for_rotation"] = temporary_name_for_rotation
            __props__.__dict__["ultra_ssd_enabled"] = ultra_ssd_enabled
            __props__.__dict__["upgrade_settings"] = upgrade_settings
            __props__.__dict__["vm_size"] = vm_size
            __props__.__dict__["vnet_subnet_id"] = vnet_subnet_id
            __props__.__dict__["windows_profile"] = windows_profile
            __props__.__dict__["workload_runtime"] = workload_runtime
            __props__.__dict__["zones"] = zones
        super(KubernetesClusterNodePool, __self__).__init__(
            'azure:containerservice/kubernetesClusterNodePool:KubernetesClusterNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            capacity_reservation_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            gpu_driver: Optional[pulumi.Input[_builtins.str]] = None,
            gpu_instance: Optional[pulumi.Input[_builtins.str]] = None,
            host_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            kubelet_config: Optional[pulumi.Input[Union['KubernetesClusterNodePoolKubeletConfigArgs', 'KubernetesClusterNodePoolKubeletConfigArgsDict']]] = None,
            kubelet_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            linux_os_config: Optional[pulumi.Input[Union['KubernetesClusterNodePoolLinuxOsConfigArgs', 'KubernetesClusterNodePoolLinuxOsConfigArgsDict']]] = None,
            max_count: Optional[pulumi.Input[_builtins.int]] = None,
            max_pods: Optional[pulumi.Input[_builtins.int]] = None,
            min_count: Optional[pulumi.Input[_builtins.int]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            node_network_profile: Optional[pulumi.Input[Union['KubernetesClusterNodePoolNodeNetworkProfileArgs', 'KubernetesClusterNodePoolNodeNetworkProfileArgsDict']]] = None,
            node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            node_public_ip_prefix_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            orchestrator_version: Optional[pulumi.Input[_builtins.str]] = None,
            os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            os_sku: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            pod_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.str]] = None,
            proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scale_down_mode: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            spot_max_price: Optional[pulumi.Input[_builtins.float]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            temporary_name_for_rotation: Optional[pulumi.Input[_builtins.str]] = None,
            ultra_ssd_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            upgrade_settings: Optional[pulumi.Input[Union['KubernetesClusterNodePoolUpgradeSettingsArgs', 'KubernetesClusterNodePoolUpgradeSettingsArgsDict']]] = None,
            vm_size: Optional[pulumi.Input[_builtins.str]] = None,
            vnet_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            windows_profile: Optional[pulumi.Input[Union['KubernetesClusterNodePoolWindowsProfileArgs', 'KubernetesClusterNodePoolWindowsProfileArgsDict']]] = None,
            workload_runtime: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'KubernetesClusterNodePool':
        """
        Get an existing KubernetesClusterNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_scaling_enabled: Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        :param pulumi.Input[_builtins.str] capacity_reservation_group_id: Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] eviction_policy: The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        :param pulumi.Input[_builtins.bool] fips_enabled: Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        :param pulumi.Input[_builtins.str] gpu_driver: Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gpu_instance: Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] host_encryption_enabled: Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        :param pulumi.Input[_builtins.str] host_group_id: The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['KubernetesClusterNodePoolKubeletConfigArgs', 'KubernetesClusterNodePoolKubeletConfigArgsDict']] kubelet_config: A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubelet_disk_type: The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.
               
               > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        :param pulumi.Input[Union['KubernetesClusterNodePoolLinuxOsConfigArgs', 'KubernetesClusterNodePoolLinuxOsConfigArgsDict']] linux_os_config: A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.int] max_pods: The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] mode: Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        :param pulumi.Input[_builtins.str] name: The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.
               
               > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        :param pulumi.Input[Union['KubernetesClusterNodePoolNodeNetworkProfileArgs', 'KubernetesClusterNodePoolNodeNetworkProfileArgsDict']] node_network_profile: A `node_network_profile` block as documented below.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] node_public_ip_prefix_id: Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        :param pulumi.Input[_builtins.str] orchestrator_version: Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).
               
               > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] os_sku: Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        :param pulumi.Input[_builtins.str] pod_subnet_id: The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] priority: The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.
               
               > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        :param pulumi.Input[_builtins.str] scale_down_mode: Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.float] spot_max_price: The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.
               
               > **Note:** This field can only be configured when `priority` is set to `Spot`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        :param pulumi.Input[_builtins.str] temporary_name_for_rotation: Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        :param pulumi.Input[_builtins.bool] ultra_ssd_enabled: Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[Union['KubernetesClusterNodePoolUpgradeSettingsArgs', 'KubernetesClusterNodePoolUpgradeSettingsArgsDict']] upgrade_settings: A `upgrade_settings` block as documented below.
        :param pulumi.Input[_builtins.str] vm_size: The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        :param pulumi.Input[_builtins.str] vnet_subnet_id: The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
               
               > **NOTE:** A route table must be configured on this Subnet.
        :param pulumi.Input[Union['KubernetesClusterNodePoolWindowsProfileArgs', 'KubernetesClusterNodePoolWindowsProfileArgsDict']] windows_profile: A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workload_runtime: Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.
               
               > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesClusterNodePoolState.__new__(_KubernetesClusterNodePoolState)

        __props__.__dict__["auto_scaling_enabled"] = auto_scaling_enabled
        __props__.__dict__["capacity_reservation_group_id"] = capacity_reservation_group_id
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["fips_enabled"] = fips_enabled
        __props__.__dict__["gpu_driver"] = gpu_driver
        __props__.__dict__["gpu_instance"] = gpu_instance
        __props__.__dict__["host_encryption_enabled"] = host_encryption_enabled
        __props__.__dict__["host_group_id"] = host_group_id
        __props__.__dict__["kubelet_config"] = kubelet_config
        __props__.__dict__["kubelet_disk_type"] = kubelet_disk_type
        __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
        __props__.__dict__["linux_os_config"] = linux_os_config
        __props__.__dict__["max_count"] = max_count
        __props__.__dict__["max_pods"] = max_pods
        __props__.__dict__["min_count"] = min_count
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_labels"] = node_labels
        __props__.__dict__["node_network_profile"] = node_network_profile
        __props__.__dict__["node_public_ip_enabled"] = node_public_ip_enabled
        __props__.__dict__["node_public_ip_prefix_id"] = node_public_ip_prefix_id
        __props__.__dict__["node_taints"] = node_taints
        __props__.__dict__["orchestrator_version"] = orchestrator_version
        __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
        __props__.__dict__["os_disk_type"] = os_disk_type
        __props__.__dict__["os_sku"] = os_sku
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["pod_subnet_id"] = pod_subnet_id
        __props__.__dict__["priority"] = priority
        __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
        __props__.__dict__["scale_down_mode"] = scale_down_mode
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["spot_max_price"] = spot_max_price
        __props__.__dict__["tags"] = tags
        __props__.__dict__["temporary_name_for_rotation"] = temporary_name_for_rotation
        __props__.__dict__["ultra_ssd_enabled"] = ultra_ssd_enabled
        __props__.__dict__["upgrade_settings"] = upgrade_settings
        __props__.__dict__["vm_size"] = vm_size
        __props__.__dict__["vnet_subnet_id"] = vnet_subnet_id
        __props__.__dict__["windows_profile"] = windows_profile
        __props__.__dict__["workload_runtime"] = workload_runtime
        __props__.__dict__["zones"] = zones
        return KubernetesClusterNodePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoScalingEnabled")
    def auto_scaling_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable [auto-scaler](https://docs.microsoft.com/azure/aks/cluster-autoscaler).
        """
        return pulumi.get(self, "auto_scaling_enabled")

    @_builtins.property
    @pulumi.getter(name="capacityReservationGroupId")
    def capacity_reservation_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the Capacity Reservation Group where this Node Pool should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Eviction Policy which should be used for Virtual Machines within the Virtual Machine Scale Set powering this Node Pool. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **Note:** An Eviction Policy can only be configured when `priority` is set to `Spot` and will default to `Delete` unless otherwise specified.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the nodes in this Node Pool have Federal Information Processing Standard enabled? Changing this property requires specifying `temporary_name_for_rotation`.

        > **Note:** FIPS support is in Public Preview - more information and details on how to opt into the Preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview).
        """
        return pulumi.get(self, "fips_enabled")

    @_builtins.property
    @pulumi.getter(name="gpuDriver")
    def gpu_driver(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to install the GPU Driver for the nodes. Possible values are `Install` and `None`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gpu_driver")

    @_builtins.property
    @pulumi.getter(name="gpuInstance")
    def gpu_instance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the GPU MIG instance profile for supported GPU VM SKU. The allowed values are `MIG1g`, `MIG2g`, `MIG3g`, `MIG4g` and `MIG7g`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gpu_instance")

    @_builtins.property
    @pulumi.getter(name="hostEncryptionEnabled")
    def host_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the nodes in this Node Pool have host encryption enabled? Changing this property requires specifying `temporary_name_for_rotation`.

        > **NOTE:** Additional fields must be configured depending on the value of this field - see below.
        """
        return pulumi.get(self, "host_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_group_id")

    @_builtins.property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> pulumi.Output[Optional['outputs.KubernetesClusterNodePoolKubeletConfig']]:
        """
        A `kubelet_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "kubelet_config")

    @_builtins.property
    @pulumi.getter(name="kubeletDiskType")
    def kubelet_disk_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of disk used by kubelet. Possible values are `OS` and `Temporary`. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "kubelet_disk_type")

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Kubernetes Cluster where this Node Pool should exist. Changing this forces a new resource to be created.

        > **NOTE:** The type of Default Node Pool for the Kubernetes Cluster must be `VirtualMachineScaleSets` to attach multiple node pools.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @_builtins.property
    @pulumi.getter(name="linuxOsConfig")
    def linux_os_config(self) -> pulumi.Output[Optional['outputs.KubernetesClusterNodePoolLinuxOsConfig']]:
        """
        A `linux_os_config` block as defined below. Changing this requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "linux_os_config")

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "max_count")

    @_builtins.property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of pods that can run on each agent. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "max_pods")

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "min_count")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Should this Node Pool be used for System or User resources? Possible values are `System` and `User`. Defaults to `User`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Node Pool which should be created within the Kubernetes Cluster. Changing this forces a new resource to be created.

        > **NOTE:** A Windows Node Pool cannot have a `name` longer than 6 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of Kubernetes labels which should be applied to nodes in this Node Pool.
        """
        return pulumi.get(self, "node_labels")

    @_builtins.property
    @pulumi.getter(name="nodeNetworkProfile")
    def node_network_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterNodePoolNodeNetworkProfile']]:
        """
        A `node_network_profile` block as documented below.
        """
        return pulumi.get(self, "node_network_profile")

    @_builtins.property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should each node have a Public IP Address? Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @_builtins.property
    @pulumi.getter(name="nodePublicIpPrefixId")
    def node_public_ip_prefix_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource ID for the Public IP Addresses Prefix for the nodes in this Node Pool. `node_public_ip_enabled` should be `true`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "node_public_ip_prefix_id")

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Kubernetes taints which should be applied to nodes in the agent pool (e.g `key=value:NoSchedule`).
        """
        return pulumi.get(self, "node_taints")

    @_builtins.property
    @pulumi.getter(name="orchestratorVersion")
    def orchestrator_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Kubernetes used for the Agents. If not specified, the latest recommended version will be used at provisioning time (but won't auto-upgrade). AKS does not require an exact patch version to be specified, minor version aliases such as `1.22` are also supported. - The minor version's latest GA patch is automatically chosen in that case. More details can be found in [the documentation](https://docs.microsoft.com/en-us/azure/aks/supported-kubernetes-versions?tabs=azure-cli#alias-minor-version).

        > **Note:** This version must be supported by the Kubernetes Cluster - as such the version of Kubernetes used on the Cluster/Control Plane may need to be upgraded first.
        """
        return pulumi.get(self, "orchestrator_version")

    @_builtins.property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The Agent Operating System disk size in GB. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of disk which should be used for the Operating System. Possible values are `Ephemeral` and `Managed`. Defaults to `Managed`. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "os_disk_type")

    @_builtins.property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the OS SKU used by the agent pool. Possible values are `AzureLinux`, `AzureLinux3`, `Ubuntu`, `Ubuntu2204`, `Windows2019` and `Windows2022`. If not specified, the default is `Ubuntu` if OSType=Linux or `Windows2019` if OSType=Windows. And the default Windows OSSKU will be changed to `Windows2022` after Windows2019 is deprecated. Changing this from `AzureLinux` or `Ubuntu` to `AzureLinux` or `Ubuntu` will not replace the resource, otherwise it forces a new resource to be created.
        """
        return pulumi.get(self, "os_sku")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Operating System which should be used for this Node Pool. Changing this forces a new resource to be created. Possible values are `Linux` and `Windows`. Defaults to `Linux`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="podSubnetId")
    def pod_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Subnet where the pods in the Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "pod_subnet_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Priority for Virtual Machines within the Virtual Machine Scale Set that powers this Node Pool. Possible values are `Regular` and `Spot`. Defaults to `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Proximity Placement Group where the Virtual Machine Scale Set that powers this Node Pool will be placed. Changing this forces a new resource to be created.

        > **Note:** When setting `priority` to Spot - you must configure an `eviction_policy`, `spot_max_price` and add the applicable `node_labels` and `node_taints` [as per the Azure Documentation](https://docs.microsoft.com/azure/aks/spot-node-pool).
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="scaleDownMode")
    def scale_down_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how the node pool should deal with scaled-down nodes. Allowed values are `Delete` and `Deallocate`. Defaults to `Delete`.
        """
        return pulumi.get(self, "scale_down_mode")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Snapshot which should be used to create this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The maximum price you're willing to pay in USD per Virtual Machine. Valid values are `-1` (the current on-demand price for a Virtual Machine) or a positive value with up to five decimal places. Changing this forces a new resource to be created.

        > **Note:** This field can only be configured when `priority` is set to `Spot`.
        """
        return pulumi.get(self, "spot_max_price")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.

        > At this time there's a bug in the AKS API where Tags for a Node Pool are not stored in the correct case - you may wish to use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) functionality to ignore changes to the casing until this is fixed in the AKS API.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="temporaryNameForRotation")
    def temporary_name_for_rotation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the temporary node pool used to cycle the node pool when one of the relevant properties are updated.
        """
        return pulumi.get(self, "temporary_name_for_rotation")

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Used to specify whether the UltraSSD is enabled in the Node Pool. Defaults to `false`. See [the documentation](https://docs.microsoft.com/azure/aks/use-ultra-disks) for more information. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "ultra_ssd_enabled")

    @_builtins.property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> pulumi.Output[Optional['outputs.KubernetesClusterNodePoolUpgradeSettings']]:
        """
        A `upgrade_settings` block as documented below.
        """
        return pulumi.get(self, "upgrade_settings")

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU which should be used for the Virtual Machines used in this Node Pool. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "vm_size")

    @_builtins.property
    @pulumi.getter(name="vnetSubnetId")
    def vnet_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Subnet where this Node Pool should exist. Changing this property requires specifying `temporary_name_for_rotation`.

        > **NOTE:** A route table must be configured on this Subnet.
        """
        return pulumi.get(self, "vnet_subnet_id")

    @_builtins.property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> pulumi.Output[Optional['outputs.KubernetesClusterNodePoolWindowsProfile']]:
        """
        A `windows_profile` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "windows_profile")

    @_builtins.property
    @pulumi.getter(name="workloadRuntime")
    def workload_runtime(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used to specify the workload runtime. Allowed values are `OCIContainer` and `WasmWasi`.

        > **Note:** WebAssembly System Interface node pools are in Public Preview - more information and details on how to opt into the preview can be found in [this article](https://docs.microsoft.com/azure/aks/use-wasi-node-pools)
        """
        return pulumi.get(self, "workload_runtime")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Kubernetes Cluster Node Pool should be located. Changing this property requires specifying `temporary_name_for_rotation`.
        """
        return pulumi.get(self, "zones")

