# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryTokenArgs', 'RegistryToken']

@pulumi.input_type
class RegistryTokenArgs:
    def __init__(__self__, *,
                 container_registry_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 scope_map_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryToken resource.
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_map_id: The ID of the Container Registry Scope Map associated with the token.
        :param pulumi.Input[_builtins.bool] enabled: Should the Container Registry token be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the token. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "container_registry_name", container_registry_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "scope_map_id", scope_map_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_name")

    @container_registry_name.setter
    def container_registry_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_registry_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scopeMapId")
    def scope_map_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry Scope Map associated with the token.
        """
        return pulumi.get(self, "scope_map_id")

    @scope_map_id.setter
    def scope_map_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope_map_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Container Registry token be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryTokenState:
    def __init__(__self__, *,
                 container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_map_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryToken resources.
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should the Container Registry token be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_map_id: The ID of the Container Registry Scope Map associated with the token.
        """
        if container_registry_name is not None:
            pulumi.set(__self__, "container_registry_name", container_registry_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scope_map_id is not None:
            pulumi.set(__self__, "scope_map_id", scope_map_id)

    @_builtins.property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_name")

    @container_registry_name.setter
    def container_registry_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Container Registry token be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scopeMapId")
    def scope_map_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry Scope Map associated with the token.
        """
        return pulumi.get(self, "scope_map_id")

    @scope_map_id.setter
    def scope_map_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope_map_id", value)


@pulumi.type_token("azure:containerservice/registryToken:RegistryToken")
class RegistryToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_map_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Container Registry token associated to a scope map. For more information on scope maps and their tokens see the [product documentation](https://learn.microsoft.com/en-us/azure/container-registry/container-registry-repository-scoped-permissions).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic",
            admin_enabled=False,
            georeplications=[
                {
                    "location": "East US",
                },
                {
                    "location": "West Europe",
                },
            ])
        example_registry_scope_map = azure.containerservice.RegistryScopeMap("example",
            name="example-scope-map",
            container_registry_name=example_registry.name,
            resource_group_name=example.name,
            actions=[
                "repositories/repo1/content/read",
                "repositories/repo1/content/write",
            ])
        example_registry_token = azure.containerservice.RegistryToken("example",
            name="exampletoken",
            container_registry_name=example_registry.name,
            resource_group_name=example.name,
            scope_map_id=example_registry_scope_map.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry` - 2023-11-01-preview

        ## Import

        Container Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryToken:RegistryToken example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerRegistry/registries/myregistry1/tokens/token1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should the Container Registry token be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_map_id: The ID of the Container Registry Scope Map associated with the token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Container Registry token associated to a scope map. For more information on scope maps and their tokens see the [product documentation](https://learn.microsoft.com/en-us/azure/container-registry/container-registry-repository-scoped-permissions).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic",
            admin_enabled=False,
            georeplications=[
                {
                    "location": "East US",
                },
                {
                    "location": "West Europe",
                },
            ])
        example_registry_scope_map = azure.containerservice.RegistryScopeMap("example",
            name="example-scope-map",
            container_registry_name=example_registry.name,
            resource_group_name=example.name,
            actions=[
                "repositories/repo1/content/read",
                "repositories/repo1/content/write",
            ])
        example_registry_token = azure.containerservice.RegistryToken("example",
            name="exampletoken",
            container_registry_name=example_registry.name,
            resource_group_name=example.name,
            scope_map_id=example_registry_scope_map.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry` - 2023-11-01-preview

        ## Import

        Container Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryToken:RegistryToken example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerRegistry/registries/myregistry1/tokens/token1
        ```

        :param str resource_name: The name of the resource.
        :param RegistryTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope_map_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryTokenArgs.__new__(RegistryTokenArgs)

            if container_registry_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_name'")
            __props__.__dict__["container_registry_name"] = container_registry_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if scope_map_id is None and not opts.urn:
                raise TypeError("Missing required property 'scope_map_id'")
            __props__.__dict__["scope_map_id"] = scope_map_id
        super(RegistryToken, __self__).__init__(
            'azure:containerservice/registryToken:RegistryToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scope_map_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryToken':
        """
        Get an existing RegistryToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should the Container Registry token be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope_map_id: The ID of the Container Registry Scope Map associated with the token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryTokenState.__new__(_RegistryTokenState)

        __props__.__dict__["container_registry_name"] = container_registry_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scope_map_id"] = scope_map_id
        return RegistryToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Container Registry token be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scopeMapId")
    def scope_map_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry Scope Map associated with the token.
        """
        return pulumi.get(self, "scope_map_id")

