# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSqlRoleDefinitionResult',
    'AwaitableGetSqlRoleDefinitionResult',
    'get_sql_role_definition',
    'get_sql_role_definition_output',
]

@pulumi.output_type
class GetSqlRoleDefinitionResult:
    """
    A collection of values returned by getSqlRoleDefinition.
    """
    def __init__(__self__, account_name=None, assignable_scopes=None, id=None, name=None, permissions=None, resource_group_name=None, role_definition_id=None, type=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if assignable_scopes and not isinstance(assignable_scopes, list):
            raise TypeError("Expected argument 'assignable_scopes' to be a list")
        pulumi.set(__self__, "assignable_scopes", assignable_scopes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if role_definition_id and not isinstance(role_definition_id, str):
            raise TypeError("Expected argument 'role_definition_id' to be a str")
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> Sequence[_builtins.str]:
        """
        A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition.
        """
        return pulumi.get(self, "assignable_scopes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The role name of the Cosmos DB SQL Role Definition.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetSqlRoleDefinitionPermissionResult']:
        """
        A `permissions` block as defined below.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> _builtins.str:
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Cosmos DB SQL Role Definition.
        """
        return pulumi.get(self, "type")


class AwaitableGetSqlRoleDefinitionResult(GetSqlRoleDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlRoleDefinitionResult(
            account_name=self.account_name,
            assignable_scopes=self.assignable_scopes,
            id=self.id,
            name=self.name,
            permissions=self.permissions,
            resource_group_name=self.resource_group_name,
            role_definition_id=self.role_definition_id,
            type=self.type)


def get_sql_role_definition(account_name: Optional[_builtins.str] = None,
                            resource_group_name: Optional[_builtins.str] = None,
                            role_definition_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlRoleDefinitionResult:
    """
    Use this data source to access information about an existing Cosmos DB SQL Role Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_sql_role_definition(resource_group_name="tfex-cosmosdb-sql-role-definition-rg",
        account_name="tfex-cosmosdb-sql-role-definition-account-name",
        role_definition_id="00000000-0000-0000-0000-000000000000")
    ```


    :param _builtins.str account_name: The name of the Cosmos DB Account.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Cosmos DB SQL Role Definition is created.
    :param _builtins.str role_definition_id: The GUID as the name of the Cosmos DB SQL Role Definition.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['roleDefinitionId'] = role_definition_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cosmosdb/getSqlRoleDefinition:getSqlRoleDefinition', __args__, opts=opts, typ=GetSqlRoleDefinitionResult).value

    return AwaitableGetSqlRoleDefinitionResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        assignable_scopes=pulumi.get(__ret__, 'assignable_scopes'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        role_definition_id=pulumi.get(__ret__, 'role_definition_id'),
        type=pulumi.get(__ret__, 'type'))
def get_sql_role_definition_output(account_name: Optional[pulumi.Input[_builtins.str]] = None,
                                   resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                   role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlRoleDefinitionResult]:
    """
    Use this data source to access information about an existing Cosmos DB SQL Role Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_sql_role_definition(resource_group_name="tfex-cosmosdb-sql-role-definition-rg",
        account_name="tfex-cosmosdb-sql-role-definition-account-name",
        role_definition_id="00000000-0000-0000-0000-000000000000")
    ```


    :param _builtins.str account_name: The name of the Cosmos DB Account.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Cosmos DB SQL Role Definition is created.
    :param _builtins.str role_definition_id: The GUID as the name of the Cosmos DB SQL Role Definition.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['roleDefinitionId'] = role_definition_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cosmosdb/getSqlRoleDefinition:getSqlRoleDefinition', __args__, opts=opts, typ=GetSqlRoleDefinitionResult)
    return __ret__.apply(lambda __response__: GetSqlRoleDefinitionResult(
        account_name=pulumi.get(__response__, 'account_name'),
        assignable_scopes=pulumi.get(__response__, 'assignable_scopes'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        role_definition_id=pulumi.get(__response__, 'role_definition_id'),
        type=pulumi.get(__response__, 'type')))
