# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MongoRoleDefinitionArgs', 'MongoRoleDefinition']

@pulumi.input_type
class MongoRoleDefinitionArgs:
    def __init__(__self__, *,
                 cosmos_mongo_database_id: pulumi.Input[_builtins.str],
                 role_name: pulumi.Input[_builtins.str],
                 inherited_role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]]] = None):
        """
        The set of arguments for constructing a MongoRoleDefinition resource.
        :param pulumi.Input[_builtins.str] cosmos_mongo_database_id: The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_name: The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inherited_role_names: A list of Mongo Roles which are inherited to the Mongo Role Definition.
               
               > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        :param pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]] privileges: A `privilege` block as defined below.
        """
        pulumi.set(__self__, "cosmos_mongo_database_id", cosmos_mongo_database_id)
        pulumi.set(__self__, "role_name", role_name)
        if inherited_role_names is not None:
            pulumi.set(__self__, "inherited_role_names", inherited_role_names)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)

    @_builtins.property
    @pulumi.getter(name="cosmosMongoDatabaseId")
    def cosmos_mongo_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmos_mongo_database_id")

    @cosmos_mongo_database_id.setter
    def cosmos_mongo_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cosmos_mongo_database_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="inheritedRoleNames")
    def inherited_role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Mongo Roles which are inherited to the Mongo Role Definition.

        > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        """
        return pulumi.get(self, "inherited_role_names")

    @inherited_role_names.setter
    def inherited_role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inherited_role_names", value)

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]]]:
        """
        A `privilege` block as defined below.
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]]]):
        pulumi.set(self, "privileges", value)


@pulumi.input_type
class _MongoRoleDefinitionState:
    def __init__(__self__, *,
                 cosmos_mongo_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 inherited_role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MongoRoleDefinition resources.
        :param pulumi.Input[_builtins.str] cosmos_mongo_database_id: The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inherited_role_names: A list of Mongo Roles which are inherited to the Mongo Role Definition.
               
               > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        :param pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]] privileges: A `privilege` block as defined below.
        :param pulumi.Input[_builtins.str] role_name: The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        """
        if cosmos_mongo_database_id is not None:
            pulumi.set(__self__, "cosmos_mongo_database_id", cosmos_mongo_database_id)
        if inherited_role_names is not None:
            pulumi.set(__self__, "inherited_role_names", inherited_role_names)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter(name="cosmosMongoDatabaseId")
    def cosmos_mongo_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmos_mongo_database_id")

    @cosmos_mongo_database_id.setter
    def cosmos_mongo_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cosmos_mongo_database_id", value)

    @_builtins.property
    @pulumi.getter(name="inheritedRoleNames")
    def inherited_role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Mongo Roles which are inherited to the Mongo Role Definition.

        > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        """
        return pulumi.get(self, "inherited_role_names")

    @inherited_role_names.setter
    def inherited_role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "inherited_role_names", value)

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]]]:
        """
        A `privilege` block as defined below.
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoRoleDefinitionPrivilegeArgs']]]]):
        pulumi.set(self, "privileges", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)


@pulumi.type_token("azure:cosmosdb/mongoRoleDefinition:MongoRoleDefinition")
class MongoRoleDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cosmos_mongo_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 inherited_role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoRoleDefinitionPrivilegeArgs', 'MongoRoleDefinitionPrivilegeArgsDict']]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cosmos DB Mongo Role Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="MongoDB",
            capabilities=[
                {
                    "name": "EnableMongo",
                },
                {
                    "name": "EnableMongoRoleBasedAccessControl",
                },
            ],
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_mongo_database = azure.cosmosdb.MongoDatabase("example",
            name="example-mongodb",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name)
        example_mongo_role_definition = azure.cosmosdb.MongoRoleDefinition("example",
            cosmos_mongo_database_id=example_mongo_database.id,
            role_name="example-roledefinition")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB` - 2022-11-15

        ## Import

        Cosmos DB Mongo Role Definitions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/mongoRoleDefinition:MongoRoleDefinition example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/mongodbRoleDefinitions/dbname1.rolename1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cosmos_mongo_database_id: The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inherited_role_names: A list of Mongo Roles which are inherited to the Mongo Role Definition.
               
               > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoRoleDefinitionPrivilegeArgs', 'MongoRoleDefinitionPrivilegeArgsDict']]]] privileges: A `privilege` block as defined below.
        :param pulumi.Input[_builtins.str] role_name: The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongoRoleDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cosmos DB Mongo Role Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="MongoDB",
            capabilities=[
                {
                    "name": "EnableMongo",
                },
                {
                    "name": "EnableMongoRoleBasedAccessControl",
                },
            ],
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_mongo_database = azure.cosmosdb.MongoDatabase("example",
            name="example-mongodb",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name)
        example_mongo_role_definition = azure.cosmosdb.MongoRoleDefinition("example",
            cosmos_mongo_database_id=example_mongo_database.id,
            role_name="example-roledefinition")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB` - 2022-11-15

        ## Import

        Cosmos DB Mongo Role Definitions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/mongoRoleDefinition:MongoRoleDefinition example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/mongodbRoleDefinitions/dbname1.rolename1
        ```

        :param str resource_name: The name of the resource.
        :param MongoRoleDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongoRoleDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cosmos_mongo_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 inherited_role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoRoleDefinitionPrivilegeArgs', 'MongoRoleDefinitionPrivilegeArgsDict']]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongoRoleDefinitionArgs.__new__(MongoRoleDefinitionArgs)

            if cosmos_mongo_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'cosmos_mongo_database_id'")
            __props__.__dict__["cosmos_mongo_database_id"] = cosmos_mongo_database_id
            __props__.__dict__["inherited_role_names"] = inherited_role_names
            __props__.__dict__["privileges"] = privileges
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
        super(MongoRoleDefinition, __self__).__init__(
            'azure:cosmosdb/mongoRoleDefinition:MongoRoleDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cosmos_mongo_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            inherited_role_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            privileges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MongoRoleDefinitionPrivilegeArgs', 'MongoRoleDefinitionPrivilegeArgsDict']]]]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'MongoRoleDefinition':
        """
        Get an existing MongoRoleDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cosmos_mongo_database_id: The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] inherited_role_names: A list of Mongo Roles which are inherited to the Mongo Role Definition.
               
               > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MongoRoleDefinitionPrivilegeArgs', 'MongoRoleDefinitionPrivilegeArgsDict']]]] privileges: A `privilege` block as defined below.
        :param pulumi.Input[_builtins.str] role_name: The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongoRoleDefinitionState.__new__(_MongoRoleDefinitionState)

        __props__.__dict__["cosmos_mongo_database_id"] = cosmos_mongo_database_id
        __props__.__dict__["inherited_role_names"] = inherited_role_names
        __props__.__dict__["privileges"] = privileges
        __props__.__dict__["role_name"] = role_name
        return MongoRoleDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cosmosMongoDatabaseId")
    def cosmos_mongo_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Mongo DB. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cosmos_mongo_database_id")

    @_builtins.property
    @pulumi.getter(name="inheritedRoleNames")
    def inherited_role_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Mongo Roles which are inherited to the Mongo Role Definition.

        > **Note:** The role that needs to be inherited should exist in the Mongo DB of `cosmos_mongo_database_id`.
        """
        return pulumi.get(self, "inherited_role_names")

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> pulumi.Output[Optional[Sequence['outputs.MongoRoleDefinitionPrivilege']]]:
        """
        A `privilege` block as defined below.
        """
        return pulumi.get(self, "privileges")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the Mongo Role Definition. It must be unique for the database account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_name")

