# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlRoleDefinitionArgs', 'SqlRoleDefinition']

@pulumi.input_type
class SqlRoleDefinitionArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 assignable_scopes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 permissions: pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlRoleDefinition resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assignable_scopes: A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.
               
               > **Note:** The resources referenced in assignable scopes need not exist.
        :param pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]] permissions: A `permissions` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        :param pulumi.Input[_builtins.str] role_definition_id: The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "assignable_scopes", assignable_scopes)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.

        > **Note:** The resources referenced in assignable scopes need not exist.
        """
        return pulumi.get(self, "assignable_scopes")

    @assignable_scopes.setter
    def assignable_scopes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "assignable_scopes", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]]:
        """
        A `permissions` block as defined below.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SqlRoleDefinitionState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 assignable_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlRoleDefinition resources.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assignable_scopes: A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.
               
               > **Note:** The resources referenced in assignable scopes need not exist.
        :param pulumi.Input[_builtins.str] name: An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        :param pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]] permissions: A `permissions` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_id: The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if assignable_scopes is not None:
            pulumi.set(__self__, "assignable_scopes", assignable_scopes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if role_definition_id is not None:
            pulumi.set(__self__, "role_definition_id", role_definition_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.

        > **Note:** The resources referenced in assignable scopes need not exist.
        """
        return pulumi.get(self, "assignable_scopes")

    @assignable_scopes.setter
    def assignable_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assignable_scopes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]]]:
        """
        A `permissions` block as defined below.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlRoleDefinitionPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:cosmosdb/sqlRoleDefinition:SqlRoleDefinition")
class SqlRoleDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 assignable_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlRoleDefinitionPermissionArgs', 'SqlRoleDefinitionPermissionArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cosmos DB SQL Role Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-cosmosdb",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_role_definition = azure.cosmosdb.SqlRoleDefinition("example",
            role_definition_id="84cf3a8b-4122-4448-bce2-fa423cfe0a15",
            resource_group_name=example.name,
            account_name=example_account.name,
            name="acctestsqlrole",
            assignable_scopes=[example_account.id.apply(lambda id: f"{id}/dbs/sales")],
            permissions=[{
                "data_actions": ["Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read"],
            }])
        ```

        ## Import

        Cosmos DB SQL Role Definitions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlRoleDefinition:SqlRoleDefinition example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlRoleDefinitions/28b3c337-f436-482b-a167-c2618dc52033
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assignable_scopes: A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.
               
               > **Note:** The resources referenced in assignable scopes need not exist.
        :param pulumi.Input[_builtins.str] name: An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlRoleDefinitionPermissionArgs', 'SqlRoleDefinitionPermissionArgsDict']]]] permissions: A `permissions` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_id: The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlRoleDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cosmos DB SQL Role Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-cosmosdb",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_role_definition = azure.cosmosdb.SqlRoleDefinition("example",
            role_definition_id="84cf3a8b-4122-4448-bce2-fa423cfe0a15",
            resource_group_name=example.name,
            account_name=example_account.name,
            name="acctestsqlrole",
            assignable_scopes=[example_account.id.apply(lambda id: f"{id}/dbs/sales")],
            permissions=[{
                "data_actions": ["Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read"],
            }])
        ```

        ## Import

        Cosmos DB SQL Role Definitions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlRoleDefinition:SqlRoleDefinition example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlRoleDefinitions/28b3c337-f436-482b-a167-c2618dc52033
        ```

        :param str resource_name: The name of the resource.
        :param SqlRoleDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlRoleDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 assignable_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlRoleDefinitionPermissionArgs', 'SqlRoleDefinitionPermissionArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlRoleDefinitionArgs.__new__(SqlRoleDefinitionArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if assignable_scopes is None and not opts.urn:
                raise TypeError("Missing required property 'assignable_scopes'")
            __props__.__dict__["assignable_scopes"] = assignable_scopes
            __props__.__dict__["name"] = name
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["role_definition_id"] = role_definition_id
            __props__.__dict__["type"] = type
        super(SqlRoleDefinition, __self__).__init__(
            'azure:cosmosdb/sqlRoleDefinition:SqlRoleDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            assignable_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SqlRoleDefinitionPermissionArgs', 'SqlRoleDefinitionPermissionArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            role_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlRoleDefinition':
        """
        Get an existing SqlRoleDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assignable_scopes: A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.
               
               > **Note:** The resources referenced in assignable scopes need not exist.
        :param pulumi.Input[_builtins.str] name: An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SqlRoleDefinitionPermissionArgs', 'SqlRoleDefinitionPermissionArgsDict']]]] permissions: A `permissions` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_definition_id: The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlRoleDefinitionState.__new__(_SqlRoleDefinitionState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["assignable_scopes"] = assignable_scopes
        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["role_definition_id"] = role_definition_id
        __props__.__dict__["type"] = type
        return SqlRoleDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of fully qualified scopes at or below which Role Assignments may be created using this Cosmos DB SQL Role Definition. It will allow application of this Cosmos DB SQL Role Definition on the entire Database Account or any underlying Database/Collection. Scopes higher than Database Account are not enforceable as assignable scopes.

        > **Note:** The resources referenced in assignable scopes need not exist.
        """
        return pulumi.get(self, "assignable_scopes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        An user-friendly name for the Cosmos DB SQL Role Definition which must be unique for the Database Account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence['outputs.SqlRoleDefinitionPermission']]:
        """
        A `permissions` block as defined below.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Cosmos DB SQL Role Definition is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The GUID as the name of the Cosmos DB SQL Role Definition - one will be generated if not specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the Cosmos DB SQL Role Definition. Possible values are `BuiltInRole` and `CustomRole`. Defaults to `CustomRole`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

