# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 access_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parameters: Optional[pulumi.Input['WorkspaceCustomParametersArgs']] = None,
                 customer_managed_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_storage_firewall_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhanced_security_compliance: Optional[pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs']] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_rotation_to_latest_version_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_rules_required: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.
               
               > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        :param pulumi.Input[_builtins.str] access_connector_id: Access Connector ID to use when default storage account firewall is enabled. 
               
               > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        :param pulumi.Input['WorkspaceCustomParametersArgs'] custom_parameters: A `custom_parameters` block as documented below.
        :param pulumi.Input[_builtins.bool] customer_managed_key_enabled: Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] default_storage_firewall_enabled: Disallow public access to default storage account. Defaults to `false`.
        :param pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs'] enhanced_security_compliance: An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] load_balancer_backend_address_pool_id: Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_disk_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed disks.
        :param pulumi.Input[_builtins.bool] managed_disk_cmk_rotation_to_latest_version_enabled: Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.
               
               > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        :param pulumi.Input[_builtins.str] managed_services_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_security_group_rules_required: Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if access_connector_id is not None:
            pulumi.set(__self__, "access_connector_id", access_connector_id)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if customer_managed_key_enabled is not None:
            pulumi.set(__self__, "customer_managed_key_enabled", customer_managed_key_enabled)
        if default_storage_firewall_enabled is not None:
            pulumi.set(__self__, "default_storage_firewall_enabled", default_storage_firewall_enabled)
        if enhanced_security_compliance is not None:
            pulumi.set(__self__, "enhanced_security_compliance", enhanced_security_compliance)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if load_balancer_backend_address_pool_id is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_id", load_balancer_backend_address_pool_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_disk_cmk_key_vault_id is not None:
            pulumi.set(__self__, "managed_disk_cmk_key_vault_id", managed_disk_cmk_key_vault_id)
        if managed_disk_cmk_key_vault_key_id is not None:
            pulumi.set(__self__, "managed_disk_cmk_key_vault_key_id", managed_disk_cmk_key_vault_key_id)
        if managed_disk_cmk_rotation_to_latest_version_enabled is not None:
            pulumi.set(__self__, "managed_disk_cmk_rotation_to_latest_version_enabled", managed_disk_cmk_rotation_to_latest_version_enabled)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if managed_services_cmk_key_vault_id is not None:
            pulumi.set(__self__, "managed_services_cmk_key_vault_id", managed_services_cmk_key_vault_id)
        if managed_services_cmk_key_vault_key_id is not None:
            pulumi.set(__self__, "managed_services_cmk_key_vault_key_id", managed_services_cmk_key_vault_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group_rules_required is not None:
            pulumi.set(__self__, "network_security_group_rules_required", network_security_group_rules_required)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.

        > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="accessConnectorId")
    def access_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access Connector ID to use when default storage account firewall is enabled. 

        > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        """
        return pulumi.get(self, "access_connector_id")

    @access_connector_id.setter
    def access_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_connector_id", value)

    @_builtins.property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[pulumi.Input['WorkspaceCustomParametersArgs']]:
        """
        A `custom_parameters` block as documented below.
        """
        return pulumi.get(self, "custom_parameters")

    @custom_parameters.setter
    def custom_parameters(self, value: Optional[pulumi.Input['WorkspaceCustomParametersArgs']]):
        pulumi.set(self, "custom_parameters", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyEnabled")
    def customer_managed_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        """
        return pulumi.get(self, "customer_managed_key_enabled")

    @customer_managed_key_enabled.setter
    def customer_managed_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "customer_managed_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="defaultStorageFirewallEnabled")
    def default_storage_firewall_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disallow public access to default storage account. Defaults to `false`.
        """
        return pulumi.get(self, "default_storage_firewall_enabled")

    @default_storage_firewall_enabled.setter
    def default_storage_firewall_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_storage_firewall_enabled", value)

    @_builtins.property
    @pulumi.getter(name="enhancedSecurityCompliance")
    def enhanced_security_compliance(self) -> Optional[pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs']]:
        """
        An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        """
        return pulumi.get(self, "enhanced_security_compliance")

    @enhanced_security_compliance.setter
    def enhanced_security_compliance(self, value: Optional[pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs']]):
        pulumi.set(self, "enhanced_security_compliance", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolId")
    def load_balancer_backend_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_id")

    @load_balancer_backend_address_pool_id.setter
    def load_balancer_backend_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_backend_address_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkKeyVaultId")
    def managed_disk_cmk_key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_disk_cmk_key_vault_id")

    @managed_disk_cmk_key_vault_id.setter
    def managed_disk_cmk_key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_disk_cmk_key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkKeyVaultKeyId")
    def managed_disk_cmk_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer managed encryption properties for the Databricks Workspace managed disks.
        """
        return pulumi.get(self, "managed_disk_cmk_key_vault_key_id")

    @managed_disk_cmk_key_vault_key_id.setter
    def managed_disk_cmk_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_disk_cmk_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkRotationToLatestVersionEnabled")
    def managed_disk_cmk_rotation_to_latest_version_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        """
        return pulumi.get(self, "managed_disk_cmk_rotation_to_latest_version_enabled")

    @managed_disk_cmk_rotation_to_latest_version_enabled.setter
    def managed_disk_cmk_rotation_to_latest_version_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "managed_disk_cmk_rotation_to_latest_version_enabled", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.

        > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="managedServicesCmkKeyVaultId")
    def managed_services_cmk_key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_services_cmk_key_vault_id")

    @managed_services_cmk_key_vault_id.setter
    def managed_services_cmk_key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_services_cmk_key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="managedServicesCmkKeyVaultKeyId")
    def managed_services_cmk_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        """
        return pulumi.get(self, "managed_services_cmk_key_vault_key_id")

    @managed_services_cmk_key_vault_key_id.setter
    def managed_services_cmk_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_services_cmk_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupRulesRequired")
    def network_security_group_rules_required(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        """
        return pulumi.get(self, "network_security_group_rules_required")

    @network_security_group_rules_required.setter
    def network_security_group_rules_required(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_security_group_rules_required", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 access_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parameters: Optional[pulumi.Input['WorkspaceCustomParametersArgs']] = None,
                 customer_managed_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_storage_firewall_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_security_compliance: Optional[pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs']] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_rotation_to_latest_version_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_disk_identities: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceManagedDiskIdentityArgs']]]] = None,
                 managed_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_rules_required: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_identities: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceStorageAccountIdentityArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[_builtins.str] access_connector_id: Access Connector ID to use when default storage account firewall is enabled. 
               
               > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        :param pulumi.Input['WorkspaceCustomParametersArgs'] custom_parameters: A `custom_parameters` block as documented below.
        :param pulumi.Input[_builtins.bool] customer_managed_key_enabled: Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] default_storage_firewall_enabled: Disallow public access to default storage account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of Managed Disk Encryption Set created by the Databricks Workspace.
        :param pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs'] enhanced_security_compliance: An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] load_balancer_backend_address_pool_id: Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_disk_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed disks.
        :param pulumi.Input[_builtins.bool] managed_disk_cmk_rotation_to_latest_version_enabled: Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceManagedDiskIdentityArgs']]] managed_disk_identities: A `managed_disk_identity` block as documented below.
        :param pulumi.Input[_builtins.str] managed_resource_group_id: The ID of the Managed Resource Group created by the Databricks Workspace.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.
               
               > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        :param pulumi.Input[_builtins.str] managed_services_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_security_group_rules_required: Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.
               
               > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceStorageAccountIdentityArgs']]] storage_account_identities: A `storage_account_identity` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_id: The unique identifier of the databricks workspace in Databricks control plane.
        :param pulumi.Input[_builtins.str] workspace_url: The workspace URL which is of the format 'adb-{workspaceId}.{random}.azuredatabricks.net'
        """
        if access_connector_id is not None:
            pulumi.set(__self__, "access_connector_id", access_connector_id)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if customer_managed_key_enabled is not None:
            pulumi.set(__self__, "customer_managed_key_enabled", customer_managed_key_enabled)
        if default_storage_firewall_enabled is not None:
            pulumi.set(__self__, "default_storage_firewall_enabled", default_storage_firewall_enabled)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if enhanced_security_compliance is not None:
            pulumi.set(__self__, "enhanced_security_compliance", enhanced_security_compliance)
        if infrastructure_encryption_enabled is not None:
            pulumi.set(__self__, "infrastructure_encryption_enabled", infrastructure_encryption_enabled)
        if load_balancer_backend_address_pool_id is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_id", load_balancer_backend_address_pool_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_disk_cmk_key_vault_id is not None:
            pulumi.set(__self__, "managed_disk_cmk_key_vault_id", managed_disk_cmk_key_vault_id)
        if managed_disk_cmk_key_vault_key_id is not None:
            pulumi.set(__self__, "managed_disk_cmk_key_vault_key_id", managed_disk_cmk_key_vault_key_id)
        if managed_disk_cmk_rotation_to_latest_version_enabled is not None:
            pulumi.set(__self__, "managed_disk_cmk_rotation_to_latest_version_enabled", managed_disk_cmk_rotation_to_latest_version_enabled)
        if managed_disk_identities is not None:
            pulumi.set(__self__, "managed_disk_identities", managed_disk_identities)
        if managed_resource_group_id is not None:
            pulumi.set(__self__, "managed_resource_group_id", managed_resource_group_id)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if managed_services_cmk_key_vault_id is not None:
            pulumi.set(__self__, "managed_services_cmk_key_vault_id", managed_services_cmk_key_vault_id)
        if managed_services_cmk_key_vault_key_id is not None:
            pulumi.set(__self__, "managed_services_cmk_key_vault_key_id", managed_services_cmk_key_vault_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group_rules_required is not None:
            pulumi.set(__self__, "network_security_group_rules_required", network_security_group_rules_required)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if storage_account_identities is not None:
            pulumi.set(__self__, "storage_account_identities", storage_account_identities)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @_builtins.property
    @pulumi.getter(name="accessConnectorId")
    def access_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access Connector ID to use when default storage account firewall is enabled. 

        > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        """
        return pulumi.get(self, "access_connector_id")

    @access_connector_id.setter
    def access_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_connector_id", value)

    @_builtins.property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[pulumi.Input['WorkspaceCustomParametersArgs']]:
        """
        A `custom_parameters` block as documented below.
        """
        return pulumi.get(self, "custom_parameters")

    @custom_parameters.setter
    def custom_parameters(self, value: Optional[pulumi.Input['WorkspaceCustomParametersArgs']]):
        pulumi.set(self, "custom_parameters", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyEnabled")
    def customer_managed_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        """
        return pulumi.get(self, "customer_managed_key_enabled")

    @customer_managed_key_enabled.setter
    def customer_managed_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "customer_managed_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="defaultStorageFirewallEnabled")
    def default_storage_firewall_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disallow public access to default storage account. Defaults to `false`.
        """
        return pulumi.get(self, "default_storage_firewall_enabled")

    @default_storage_firewall_enabled.setter
    def default_storage_firewall_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_storage_firewall_enabled", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Managed Disk Encryption Set created by the Databricks Workspace.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="enhancedSecurityCompliance")
    def enhanced_security_compliance(self) -> Optional[pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs']]:
        """
        An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        """
        return pulumi.get(self, "enhanced_security_compliance")

    @enhanced_security_compliance.setter
    def enhanced_security_compliance(self, value: Optional[pulumi.Input['WorkspaceEnhancedSecurityComplianceArgs']]):
        pulumi.set(self, "enhanced_security_compliance", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @infrastructure_encryption_enabled.setter
    def infrastructure_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "infrastructure_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolId")
    def load_balancer_backend_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_id")

    @load_balancer_backend_address_pool_id.setter
    def load_balancer_backend_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_backend_address_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkKeyVaultId")
    def managed_disk_cmk_key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_disk_cmk_key_vault_id")

    @managed_disk_cmk_key_vault_id.setter
    def managed_disk_cmk_key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_disk_cmk_key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkKeyVaultKeyId")
    def managed_disk_cmk_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer managed encryption properties for the Databricks Workspace managed disks.
        """
        return pulumi.get(self, "managed_disk_cmk_key_vault_key_id")

    @managed_disk_cmk_key_vault_key_id.setter
    def managed_disk_cmk_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_disk_cmk_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkRotationToLatestVersionEnabled")
    def managed_disk_cmk_rotation_to_latest_version_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        """
        return pulumi.get(self, "managed_disk_cmk_rotation_to_latest_version_enabled")

    @managed_disk_cmk_rotation_to_latest_version_enabled.setter
    def managed_disk_cmk_rotation_to_latest_version_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "managed_disk_cmk_rotation_to_latest_version_enabled", value)

    @_builtins.property
    @pulumi.getter(name="managedDiskIdentities")
    def managed_disk_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceManagedDiskIdentityArgs']]]]:
        """
        A `managed_disk_identity` block as documented below.
        """
        return pulumi.get(self, "managed_disk_identities")

    @managed_disk_identities.setter
    def managed_disk_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceManagedDiskIdentityArgs']]]]):
        pulumi.set(self, "managed_disk_identities", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupId")
    def managed_resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Managed Resource Group created by the Databricks Workspace.
        """
        return pulumi.get(self, "managed_resource_group_id")

    @managed_resource_group_id.setter
    def managed_resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.

        > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="managedServicesCmkKeyVaultId")
    def managed_services_cmk_key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "managed_services_cmk_key_vault_id")

    @managed_services_cmk_key_vault_id.setter
    def managed_services_cmk_key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_services_cmk_key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="managedServicesCmkKeyVaultKeyId")
    def managed_services_cmk_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        """
        return pulumi.get(self, "managed_services_cmk_key_vault_key_id")

    @managed_services_cmk_key_vault_key_id.setter
    def managed_services_cmk_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_services_cmk_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupRulesRequired")
    def network_security_group_rules_required(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        """
        return pulumi.get(self, "network_security_group_rules_required")

    @network_security_group_rules_required.setter
    def network_security_group_rules_required(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_security_group_rules_required", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.

        > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountIdentities")
    def storage_account_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceStorageAccountIdentityArgs']]]]:
        """
        A `storage_account_identity` block as documented below.
        """
        return pulumi.get(self, "storage_account_identities")

    @storage_account_identities.setter
    def storage_account_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceStorageAccountIdentityArgs']]]]):
        pulumi.set(self, "storage_account_identities", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the databricks workspace in Databricks control plane.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workspace URL which is of the format 'adb-{workspaceId}.{random}.azuredatabricks.net'
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.type_token("azure:databricks/workspace:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parameters: Optional[pulumi.Input[Union['WorkspaceCustomParametersArgs', 'WorkspaceCustomParametersArgsDict']]] = None,
                 customer_managed_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_storage_firewall_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhanced_security_compliance: Optional[pulumi.Input[Union['WorkspaceEnhancedSecurityComplianceArgs', 'WorkspaceEnhancedSecurityComplianceArgsDict']]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_rotation_to_latest_version_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_rules_required: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        Databrick Workspaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:databricks/workspace:Workspace workspace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Databricks/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_connector_id: Access Connector ID to use when default storage account firewall is enabled. 
               
               > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        :param pulumi.Input[Union['WorkspaceCustomParametersArgs', 'WorkspaceCustomParametersArgsDict']] custom_parameters: A `custom_parameters` block as documented below.
        :param pulumi.Input[_builtins.bool] customer_managed_key_enabled: Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] default_storage_firewall_enabled: Disallow public access to default storage account. Defaults to `false`.
        :param pulumi.Input[Union['WorkspaceEnhancedSecurityComplianceArgs', 'WorkspaceEnhancedSecurityComplianceArgsDict']] enhanced_security_compliance: An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] load_balancer_backend_address_pool_id: Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_disk_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed disks.
        :param pulumi.Input[_builtins.bool] managed_disk_cmk_rotation_to_latest_version_enabled: Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.
               
               > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        :param pulumi.Input[_builtins.str] managed_services_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_security_group_rules_required: Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.
               
               > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Databrick Workspaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:databricks/workspace:Workspace workspace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Databricks/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_parameters: Optional[pulumi.Input[Union['WorkspaceCustomParametersArgs', 'WorkspaceCustomParametersArgsDict']]] = None,
                 customer_managed_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_storage_firewall_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enhanced_security_compliance: Optional[pulumi.Input[Union['WorkspaceEnhancedSecurityComplianceArgs', 'WorkspaceEnhancedSecurityComplianceArgsDict']]] = None,
                 infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_disk_cmk_rotation_to_latest_version_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_security_group_rules_required: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            __props__.__dict__["access_connector_id"] = access_connector_id
            __props__.__dict__["custom_parameters"] = custom_parameters
            __props__.__dict__["customer_managed_key_enabled"] = customer_managed_key_enabled
            __props__.__dict__["default_storage_firewall_enabled"] = default_storage_firewall_enabled
            __props__.__dict__["enhanced_security_compliance"] = enhanced_security_compliance
            __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
            __props__.__dict__["load_balancer_backend_address_pool_id"] = load_balancer_backend_address_pool_id
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_disk_cmk_key_vault_id"] = managed_disk_cmk_key_vault_id
            __props__.__dict__["managed_disk_cmk_key_vault_key_id"] = managed_disk_cmk_key_vault_key_id
            __props__.__dict__["managed_disk_cmk_rotation_to_latest_version_enabled"] = managed_disk_cmk_rotation_to_latest_version_enabled
            __props__.__dict__["managed_resource_group_name"] = managed_resource_group_name
            __props__.__dict__["managed_services_cmk_key_vault_id"] = managed_services_cmk_key_vault_id
            __props__.__dict__["managed_services_cmk_key_vault_key_id"] = managed_services_cmk_key_vault_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["network_security_group_rules_required"] = network_security_group_rules_required
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["disk_encryption_set_id"] = None
            __props__.__dict__["managed_disk_identities"] = None
            __props__.__dict__["managed_resource_group_id"] = None
            __props__.__dict__["storage_account_identities"] = None
            __props__.__dict__["workspace_id"] = None
            __props__.__dict__["workspace_url"] = None
        super(Workspace, __self__).__init__(
            'azure:databricks/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_parameters: Optional[pulumi.Input[Union['WorkspaceCustomParametersArgs', 'WorkspaceCustomParametersArgsDict']]] = None,
            customer_managed_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            default_storage_firewall_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            enhanced_security_compliance: Optional[pulumi.Input[Union['WorkspaceEnhancedSecurityComplianceArgs', 'WorkspaceEnhancedSecurityComplianceArgsDict']]] = None,
            infrastructure_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            load_balancer_backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_disk_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_disk_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_disk_cmk_rotation_to_latest_version_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            managed_disk_identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceManagedDiskIdentityArgs', 'WorkspaceManagedDiskIdentityArgsDict']]]]] = None,
            managed_resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            managed_services_cmk_key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_services_cmk_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_security_group_rules_required: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceStorageAccountIdentityArgs', 'WorkspaceStorageAccountIdentityArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_connector_id: Access Connector ID to use when default storage account firewall is enabled. 
               
               > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        :param pulumi.Input[Union['WorkspaceCustomParametersArgs', 'WorkspaceCustomParametersArgsDict']] custom_parameters: A `custom_parameters` block as documented below.
        :param pulumi.Input[_builtins.bool] customer_managed_key_enabled: Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] default_storage_firewall_enabled: Disallow public access to default storage account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of Managed Disk Encryption Set created by the Databricks Workspace.
        :param pulumi.Input[Union['WorkspaceEnhancedSecurityComplianceArgs', 'WorkspaceEnhancedSecurityComplianceArgsDict']] enhanced_security_compliance: An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        :param pulumi.Input[_builtins.bool] infrastructure_encryption_enabled: Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] load_balancer_backend_address_pool_id: Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_disk_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed disks.
        :param pulumi.Input[_builtins.bool] managed_disk_cmk_rotation_to_latest_version_enabled: Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceManagedDiskIdentityArgs', 'WorkspaceManagedDiskIdentityArgsDict']]]] managed_disk_identities: A `managed_disk_identity` block as documented below.
        :param pulumi.Input[_builtins.str] managed_resource_group_id: The ID of the Managed Resource Group created by the Databricks Workspace.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.
               
               > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        :param pulumi.Input[_builtins.str] managed_services_cmk_key_vault_key_id: Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_security_group_rules_required: Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.
               
               > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceStorageAccountIdentityArgs', 'WorkspaceStorageAccountIdentityArgsDict']]]] storage_account_identities: A `storage_account_identity` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_id: The unique identifier of the databricks workspace in Databricks control plane.
        :param pulumi.Input[_builtins.str] workspace_url: The workspace URL which is of the format 'adb-{workspaceId}.{random}.azuredatabricks.net'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["access_connector_id"] = access_connector_id
        __props__.__dict__["custom_parameters"] = custom_parameters
        __props__.__dict__["customer_managed_key_enabled"] = customer_managed_key_enabled
        __props__.__dict__["default_storage_firewall_enabled"] = default_storage_firewall_enabled
        __props__.__dict__["disk_encryption_set_id"] = disk_encryption_set_id
        __props__.__dict__["enhanced_security_compliance"] = enhanced_security_compliance
        __props__.__dict__["infrastructure_encryption_enabled"] = infrastructure_encryption_enabled
        __props__.__dict__["load_balancer_backend_address_pool_id"] = load_balancer_backend_address_pool_id
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_disk_cmk_key_vault_id"] = managed_disk_cmk_key_vault_id
        __props__.__dict__["managed_disk_cmk_key_vault_key_id"] = managed_disk_cmk_key_vault_key_id
        __props__.__dict__["managed_disk_cmk_rotation_to_latest_version_enabled"] = managed_disk_cmk_rotation_to_latest_version_enabled
        __props__.__dict__["managed_disk_identities"] = managed_disk_identities
        __props__.__dict__["managed_resource_group_id"] = managed_resource_group_id
        __props__.__dict__["managed_resource_group_name"] = managed_resource_group_name
        __props__.__dict__["managed_services_cmk_key_vault_id"] = managed_services_cmk_key_vault_id
        __props__.__dict__["managed_services_cmk_key_vault_key_id"] = managed_services_cmk_key_vault_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_security_group_rules_required"] = network_security_group_rules_required
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["storage_account_identities"] = storage_account_identities
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        __props__.__dict__["workspace_url"] = workspace_url
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessConnectorId")
    def access_connector_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access Connector ID to use when default storage account firewall is enabled. 

        > **Note:** The `access_connector_id` field is only required if `default_storage_firewall_enabled` is set to `true`.
        """
        return pulumi.get(self, "access_connector_id")

    @_builtins.property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> pulumi.Output['outputs.WorkspaceCustomParameters']:
        """
        A `custom_parameters` block as documented below.
        """
        return pulumi.get(self, "custom_parameters")

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyEnabled")
    def customer_managed_key_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the workspace enabled for customer managed key encryption? If `true` this enables the Managed Identity for the managed storage account. Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`.
        """
        return pulumi.get(self, "customer_managed_key_enabled")

    @_builtins.property
    @pulumi.getter(name="defaultStorageFirewallEnabled")
    def default_storage_firewall_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disallow public access to default storage account. Defaults to `false`.
        """
        return pulumi.get(self, "default_storage_firewall_enabled")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Managed Disk Encryption Set created by the Databricks Workspace.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="enhancedSecurityCompliance")
    def enhanced_security_compliance(self) -> pulumi.Output[Optional['outputs.WorkspaceEnhancedSecurityCompliance']]:
        """
        An `enhanced_security_compliance` block as documented below. This feature is only valid if `sku` is set to `premium`.
        """
        return pulumi.get(self, "enhanced_security_compliance")

    @_builtins.property
    @pulumi.getter(name="infrastructureEncryptionEnabled")
    def infrastructure_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the Databricks File System root file system enabled with a secondary layer of encryption with platform managed keys? Possible values are `true` or `false`. Defaults to `false`. This field is only valid if the Databricks Workspace `sku` is set to `premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolId")
    def load_balancer_backend_address_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource ID of the Outbound Load balancer Backend Address Pool for Secure Cluster Connectivity (No Public IP) workspace with managed virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkKeyVaultId")
    def managed_disk_cmk_key_vault_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "managed_disk_cmk_key_vault_id")

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkKeyVaultKeyId")
    def managed_disk_cmk_key_vault_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customer managed encryption properties for the Databricks Workspace managed disks.
        """
        return pulumi.get(self, "managed_disk_cmk_key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="managedDiskCmkRotationToLatestVersionEnabled")
    def managed_disk_cmk_rotation_to_latest_version_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether customer managed keys for disk encryption will automatically be rotated to the latest version.
        """
        return pulumi.get(self, "managed_disk_cmk_rotation_to_latest_version_enabled")

    @_builtins.property
    @pulumi.getter(name="managedDiskIdentities")
    def managed_disk_identities(self) -> pulumi.Output[Sequence['outputs.WorkspaceManagedDiskIdentity']]:
        """
        A `managed_disk_identity` block as documented below.
        """
        return pulumi.get(self, "managed_disk_identities")

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupId")
    def managed_resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Managed Resource Group created by the Databricks Workspace.
        """
        return pulumi.get(self, "managed_resource_group_id")

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group where Azure should place the managed Databricks resources. Changing this forces a new resource to be created.

        > **Note:** Make sure that this field is unique if you have multiple Databrick Workspaces deployed in your subscription and choose to not have the `managed_resource_group_name` auto generated by the Azure Resource Provider. Having multiple Databrick Workspaces deployed in the same subscription with the same `manage_resource_group_name` may result in some resources that cannot be deleted.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @_builtins.property
    @pulumi.getter(name="managedServicesCmkKeyVaultId")
    def managed_services_cmk_key_vault_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "managed_services_cmk_key_vault_id")

    @_builtins.property
    @pulumi.getter(name="managedServicesCmkKeyVaultKeyId")
    def managed_services_cmk_key_vault_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customer managed encryption properties for the Databricks Workspace managed resources(e.g. Notebooks and Artifacts).
        """
        return pulumi.get(self, "managed_services_cmk_key_vault_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Databricks Workspace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupRulesRequired")
    def network_security_group_rules_required(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Does the data plane (clusters) to control plane communication happen over private link endpoint only or publicly? Possible values `AllRules`, `NoAzureDatabricksRules` or `NoAzureServiceRules`. Required when `public_network_access_enabled` is set to `false`.
        """
        return pulumi.get(self, "network_security_group_rules_required")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow public access for accessing workspace. Set value to `false` to access workspace only via private link endpoint. Possible values include `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Databricks Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The `sku` to use for the Databricks Workspace. Possible values are `standard`, `premium`, or `trial`.

        > **Note:** Downgrading to a `trial sku` from a `standard` or `premium sku` will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="storageAccountIdentities")
    def storage_account_identities(self) -> pulumi.Output[Sequence['outputs.WorkspaceStorageAccountIdentity']]:
        """
        A `storage_account_identity` block as documented below.
        """
        return pulumi.get(self, "storage_account_identities")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the databricks workspace in Databricks control plane.
        """
        return pulumi.get(self, "workspace_id")

    @_builtins.property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> pulumi.Output[_builtins.str]:
        """
        The workspace URL which is of the format 'adb-{workspaceId}.{random}.azuredatabricks.net'
        """
        return pulumi.get(self, "workspace_url")

