# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorTagRuleArgs', 'MonitorTagRule']

@pulumi.input_type
class MonitorTagRuleArgs:
    def __init__(__self__, *,
                 datadog_monitor_id: pulumi.Input[_builtins.str],
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MonitorTagRule resource.
        :param pulumi.Input[_builtins.str] datadog_monitor_id: The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]] logs: A `log` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]] metrics: A `metric` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        pulumi.set(__self__, "datadog_monitor_id", datadog_monitor_id)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="datadogMonitorId")
    def datadog_monitor_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        """
        return pulumi.get(self, "datadog_monitor_id")

    @datadog_monitor_id.setter
    def datadog_monitor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "datadog_monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]]]:
        """
        A `log` block as defined below.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]]]):
        pulumi.set(self, "logs", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]]]:
        """
        A `metric` block as defined below.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MonitorTagRuleState:
    def __init__(__self__, *,
                 datadog_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitorTagRule resources.
        :param pulumi.Input[_builtins.str] datadog_monitor_id: The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]] logs: A `log` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]] metrics: A `metric` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        if datadog_monitor_id is not None:
            pulumi.set(__self__, "datadog_monitor_id", datadog_monitor_id)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="datadogMonitorId")
    def datadog_monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        """
        return pulumi.get(self, "datadog_monitor_id")

    @datadog_monitor_id.setter
    def datadog_monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datadog_monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]]]:
        """
        A `log` block as defined below.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleLogArgs']]]]):
        pulumi.set(self, "logs", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]]]:
        """
        A `metric` block as defined below.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorTagRuleMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:datadog/monitorTagRule:MonitorTagRule")
class MonitorTagRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleLogArgs', 'MonitorTagRuleLogArgsDict']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleMetricArgs', 'MonitorTagRuleMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages TagRules on the datadog Monitor.

        ## Example Usage

        ### Adding TagRules on monitor
        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-datadog",
            location="West US 2")
        example_monitor = azure.datadog.Monitor("example",
            name="example-monitor",
            resource_group_name=example.name,
            location=example.location,
            datadog_organization={
                "api_key": "XXXX",
                "application_key": "XXXX",
            },
            user={
                "name": "Example",
                "email": "abc@xyz.com",
            },
            sku_name="Linked",
            identity={
                "type": "SystemAssigned",
            })
        example_monitor_tag_rule = azure.datadog.MonitorTagRule("example",
            datadog_monitor_id=example_monitor.id,
            logs=[{
                "subscription_log_enabled": True,
            }],
            metrics=[{
                "filters": [{
                    "name": "Test",
                    "value": "Logs",
                    "action": "Include",
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Datadog` - 2021-03-01

        ## Import

        Tag Rules on the Datadog Monitor can be imported using the `tag rule resource id`, e.g.

        ```sh
        $ pulumi import azure:datadog/monitorTagRule:MonitorTagRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Datadog/monitors/monitor1/tagRules/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] datadog_monitor_id: The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleLogArgs', 'MonitorTagRuleLogArgsDict']]]] logs: A `log` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleMetricArgs', 'MonitorTagRuleMetricArgsDict']]]] metrics: A `metric` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorTagRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages TagRules on the datadog Monitor.

        ## Example Usage

        ### Adding TagRules on monitor
        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-datadog",
            location="West US 2")
        example_monitor = azure.datadog.Monitor("example",
            name="example-monitor",
            resource_group_name=example.name,
            location=example.location,
            datadog_organization={
                "api_key": "XXXX",
                "application_key": "XXXX",
            },
            user={
                "name": "Example",
                "email": "abc@xyz.com",
            },
            sku_name="Linked",
            identity={
                "type": "SystemAssigned",
            })
        example_monitor_tag_rule = azure.datadog.MonitorTagRule("example",
            datadog_monitor_id=example_monitor.id,
            logs=[{
                "subscription_log_enabled": True,
            }],
            metrics=[{
                "filters": [{
                    "name": "Test",
                    "value": "Logs",
                    "action": "Include",
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Datadog` - 2021-03-01

        ## Import

        Tag Rules on the Datadog Monitor can be imported using the `tag rule resource id`, e.g.

        ```sh
        $ pulumi import azure:datadog/monitorTagRule:MonitorTagRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Datadog/monitors/monitor1/tagRules/default
        ```

        :param str resource_name: The name of the resource.
        :param MonitorTagRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorTagRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleLogArgs', 'MonitorTagRuleLogArgsDict']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleMetricArgs', 'MonitorTagRuleMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorTagRuleArgs.__new__(MonitorTagRuleArgs)

            if datadog_monitor_id is None and not opts.urn:
                raise TypeError("Missing required property 'datadog_monitor_id'")
            __props__.__dict__["datadog_monitor_id"] = datadog_monitor_id
            __props__.__dict__["logs"] = logs
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["name"] = name
        super(MonitorTagRule, __self__).__init__(
            'azure:datadog/monitorTagRule:MonitorTagRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datadog_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            logs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleLogArgs', 'MonitorTagRuleLogArgsDict']]]]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleMetricArgs', 'MonitorTagRuleMetricArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'MonitorTagRule':
        """
        Get an existing MonitorTagRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] datadog_monitor_id: The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleLogArgs', 'MonitorTagRuleLogArgsDict']]]] logs: A `log` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitorTagRuleMetricArgs', 'MonitorTagRuleMetricArgsDict']]]] metrics: A `metric` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorTagRuleState.__new__(_MonitorTagRuleState)

        __props__.__dict__["datadog_monitor_id"] = datadog_monitor_id
        __props__.__dict__["logs"] = logs
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["name"] = name
        return MonitorTagRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="datadogMonitorId")
    def datadog_monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Datadog Monitor Id which should be used for this Datadog Monitor Tag Rule. Changing this forces a new Datadog Monitor Tag Rule to be created.
        """
        return pulumi.get(self, "datadog_monitor_id")

    @_builtins.property
    @pulumi.getter
    def logs(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorTagRuleLog']]]:
        """
        A `log` block as defined below.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Optional[Sequence['outputs.MonitorTagRuleMetric']]]:
        """
        A `metric` block as defined below.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Tag Rules configuration. The allowed value is `default`. Defaults to `default`.
        """
        return pulumi.get(self, "name")

