# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTriggerSchedulesResult',
    'AwaitableGetTriggerSchedulesResult',
    'get_trigger_schedules',
    'get_trigger_schedules_output',
]

@pulumi.output_type
class GetTriggerSchedulesResult:
    """
    A collection of values returned by getTriggerSchedules.
    """
    def __init__(__self__, data_factory_id=None, id=None, items=None):
        if data_factory_id and not isinstance(data_factory_id, str):
            raise TypeError("Expected argument 'data_factory_id' to be a str")
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> _builtins.str:
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence[_builtins.str]:
        """
        A list of trigger schedule names available in this Azure Data Factory.
        """
        return pulumi.get(self, "items")


class AwaitableGetTriggerSchedulesResult(GetTriggerSchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTriggerSchedulesResult(
            data_factory_id=self.data_factory_id,
            id=self.id,
            items=self.items)


def get_trigger_schedules(data_factory_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTriggerSchedulesResult:
    """
    Use this data source to access information about all existing trigger schedules in Azure Data Factory.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datafactory.get_trigger_schedules(data_factory_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataFactory/factories/datafactory1")
    pulumi.export("items", example.items)
    ```


    :param _builtins.str data_factory_id: The ID of the Azure Data Factory to fetch trigger schedules from.
    """
    __args__ = dict()
    __args__['dataFactoryId'] = data_factory_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:datafactory/getTriggerSchedules:getTriggerSchedules', __args__, opts=opts, typ=GetTriggerSchedulesResult).value

    return AwaitableGetTriggerSchedulesResult(
        data_factory_id=pulumi.get(__ret__, 'data_factory_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_trigger_schedules_output(data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTriggerSchedulesResult]:
    """
    Use this data source to access information about all existing trigger schedules in Azure Data Factory.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datafactory.get_trigger_schedules(data_factory_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataFactory/factories/datafactory1")
    pulumi.export("items", example.items)
    ```


    :param _builtins.str data_factory_id: The ID of the Azure Data Factory to fetch trigger schedules from.
    """
    __args__ = dict()
    __args__['dataFactoryId'] = data_factory_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:datafactory/getTriggerSchedules:getTriggerSchedules', __args__, opts=opts, typ=GetTriggerSchedulesResult)
    return __ret__.apply(lambda __response__: GetTriggerSchedulesResult(
        data_factory_id=pulumi.get(__response__, 'data_factory_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
