# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LinkedServiceKustoArgs', 'LinkedServiceKusto']

@pulumi.input_type
class LinkedServiceKustoArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 kusto_database_name: pulumi.Input[_builtins.str],
                 kusto_endpoint: pulumi.Input[_builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LinkedServiceKusto resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] kusto_database_name: The Kusto Database Name.
        :param pulumi.Input[_builtins.str] kusto_endpoint: The URI of the Kusto Cluster endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Kusto Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] service_principal_id: The service principal id in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] service_principal_key: The service principal key in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] tenant: The service principal tenant id or name in which to authenticate against the Kusto Database.
               
               > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.
               
               > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        :param pulumi.Input[_builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "kusto_database_name", kusto_database_name)
        pulumi.set(__self__, "kusto_endpoint", kusto_endpoint)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if use_managed_identity is not None:
            pulumi.set(__self__, "use_managed_identity", use_managed_identity)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseName")
    def kusto_database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Kusto Database Name.
        """
        return pulumi.get(self, "kusto_database_name")

    @kusto_database_name.setter
    def kusto_database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kusto_database_name", value)

    @_builtins.property
    @pulumi.getter(name="kustoEndpoint")
    def kusto_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of the Kusto Cluster endpoint.
        """
        return pulumi.get(self, "kusto_endpoint")

    @kusto_endpoint.setter
    def kusto_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kusto_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to Azure Kusto Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal id in which to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal key in which to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_key", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal tenant id or name in which to authenticate against the Kusto Database.

        > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.

        > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "use_managed_identity")

    @use_managed_identity.setter
    def use_managed_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_managed_identity", value)


@pulumi.input_type
class _LinkedServiceKustoState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LinkedServiceKusto resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Kusto Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] kusto_database_name: The Kusto Database Name.
        :param pulumi.Input[_builtins.str] kusto_endpoint: The URI of the Kusto Cluster endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] service_principal_id: The service principal id in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] service_principal_key: The service principal key in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] tenant: The service principal tenant id or name in which to authenticate against the Kusto Database.
               
               > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.
               
               > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        :param pulumi.Input[_builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if kusto_database_name is not None:
            pulumi.set(__self__, "kusto_database_name", kusto_database_name)
        if kusto_endpoint is not None:
            pulumi.set(__self__, "kusto_endpoint", kusto_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if use_managed_identity is not None:
            pulumi.set(__self__, "use_managed_identity", use_managed_identity)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to Azure Kusto Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseName")
    def kusto_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kusto Database Name.
        """
        return pulumi.get(self, "kusto_database_name")

    @kusto_database_name.setter
    def kusto_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kusto_database_name", value)

    @_builtins.property
    @pulumi.getter(name="kustoEndpoint")
    def kusto_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the Kusto Cluster endpoint.
        """
        return pulumi.get(self, "kusto_endpoint")

    @kusto_endpoint.setter
    def kusto_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kusto_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal id in which to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal key in which to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_key", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service principal tenant id or name in which to authenticate against the Kusto Database.

        > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.

        > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "use_managed_identity")

    @use_managed_identity.setter
    def use_managed_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_managed_identity", value)


@pulumi.type_token("azure:datafactory/linkedServiceKusto:LinkedServiceKusto")
class LinkedServiceKusto(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Linked Service (connection) between a Kusto Cluster and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        example_cluster = azure.kusto.Cluster("example",
            name="kustocluster",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Standard_D13_v2",
                "capacity": 2,
            })
        example_database = azure.kusto.Database("example",
            name="my-kusto-database",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name)
        example_linked_service_kusto = azure.datafactory.LinkedServiceKusto("example",
            name="example",
            data_factory_id=example_factory.id,
            kusto_endpoint=example_cluster.uri,
            kusto_database_name=example_database.name,
            use_managed_identity=True)
        example_database_principal_assignment = azure.kusto.DatabasePrincipalAssignment("example",
            name="KustoPrincipalAssignment",
            resource_group_name=example.name,
            cluster_name=example_cluster.name,
            database_name=example_database.name,
            tenant_id=example_factory.identity.tenant_id,
            principal_id=example_factory.identity.principal_id,
            principal_type="App",
            role="Viewer")
        ```

        ## Import

        Data Factory Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceKusto:LinkedServiceKusto example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Kusto Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] kusto_database_name: The Kusto Database Name.
        :param pulumi.Input[_builtins.str] kusto_endpoint: The URI of the Kusto Cluster endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] service_principal_id: The service principal id in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] service_principal_key: The service principal key in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] tenant: The service principal tenant id or name in which to authenticate against the Kusto Database.
               
               > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.
               
               > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        :param pulumi.Input[_builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkedServiceKustoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linked Service (connection) between a Kusto Cluster and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        example_cluster = azure.kusto.Cluster("example",
            name="kustocluster",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Standard_D13_v2",
                "capacity": 2,
            })
        example_database = azure.kusto.Database("example",
            name="my-kusto-database",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name)
        example_linked_service_kusto = azure.datafactory.LinkedServiceKusto("example",
            name="example",
            data_factory_id=example_factory.id,
            kusto_endpoint=example_cluster.uri,
            kusto_database_name=example_database.name,
            use_managed_identity=True)
        example_database_principal_assignment = azure.kusto.DatabasePrincipalAssignment("example",
            name="KustoPrincipalAssignment",
            resource_group_name=example.name,
            cluster_name=example_cluster.name,
            database_name=example_database.name,
            tenant_id=example_factory.identity.tenant_id,
            principal_id=example_factory.identity.principal_id,
            principal_type="App",
            role="Viewer")
        ```

        ## Import

        Data Factory Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceKusto:LinkedServiceKusto example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param LinkedServiceKustoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkedServiceKustoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkedServiceKustoArgs.__new__(LinkedServiceKustoArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["integration_runtime_name"] = integration_runtime_name
            if kusto_database_name is None and not opts.urn:
                raise TypeError("Missing required property 'kusto_database_name'")
            __props__.__dict__["kusto_database_name"] = kusto_database_name
            if kusto_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'kusto_endpoint'")
            __props__.__dict__["kusto_endpoint"] = kusto_endpoint
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["service_principal_key"] = None if service_principal_key is None else pulumi.Output.secret(service_principal_key)
            __props__.__dict__["tenant"] = tenant
            __props__.__dict__["use_managed_identity"] = use_managed_identity
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["servicePrincipalKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinkedServiceKusto, __self__).__init__(
            'azure:datafactory/linkedServiceKusto:LinkedServiceKusto',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
            kusto_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            kusto_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None,
            use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None) -> 'LinkedServiceKusto':
        """
        Get an existing LinkedServiceKusto resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Kusto Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] kusto_database_name: The Kusto Database Name.
        :param pulumi.Input[_builtins.str] kusto_endpoint: The URI of the Kusto Cluster endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] service_principal_id: The service principal id in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] service_principal_key: The service principal key in which to authenticate against the Kusto Database.
        :param pulumi.Input[_builtins.str] tenant: The service principal tenant id or name in which to authenticate against the Kusto Database.
               
               > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.
               
               > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        :param pulumi.Input[_builtins.bool] use_managed_identity: Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkedServiceKustoState.__new__(_LinkedServiceKustoState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["integration_runtime_name"] = integration_runtime_name
        __props__.__dict__["kusto_database_name"] = kusto_database_name
        __props__.__dict__["kusto_endpoint"] = kusto_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["service_principal_key"] = service_principal_key
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["use_managed_identity"] = use_managed_identity
        return LinkedServiceKusto(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to Azure Kusto Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseName")
    def kusto_database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Kusto Database Name.
        """
        return pulumi.get(self, "kusto_database_name")

    @_builtins.property
    @pulumi.getter(name="kustoEndpoint")
    def kusto_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the Kusto Cluster endpoint.
        """
        return pulumi.get(self, "kusto_endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service principal id in which to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service principal key in which to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "service_principal_key")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service principal tenant id or name in which to authenticate against the Kusto Database.

        > **Note:** If `service_principal_id` is used, `service_principal_key` and `tenant` is also required.

        > **Note:** One of Managed Identity authentication and Service Principal authentication must be set.
        """
        return pulumi.get(self, "tenant")

    @_builtins.property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use the Data Factory's managed identity to authenticate against the Kusto Database.
        """
        return pulumi.get(self, "use_managed_identity")

