# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinkedServiceSftpArgs', 'LinkedServiceSftp']

@pulumi.input_type
class LinkedServiceSftpArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[_builtins.str],
                 data_factory_id: pulumi.Input[_builtins.str],
                 host: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 username: pulumi.Input[_builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_passwords: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]]] = None,
                 key_vault_private_key_content_base64: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args']] = None,
                 key_vault_private_key_passphrase: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_host_key_validation: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LinkedServiceSftp resource.
        :param pulumi.Input[_builtins.str] authentication_type: The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] host: The SFTP server hostname.
        :param pulumi.Input[_builtins.int] port: The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        :param pulumi.Input[_builtins.str] username: The username used to log on to the SFTP server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to SFTP Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] host_key_fingerprint: The host key fingerprint of the SFTP server.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The name of the integration runtime to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]] key_vault_passwords: A `key_vault_password` block as defined below.
               
               > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        :param pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args'] key_vault_private_key_content_base64: A `key_vault_private_key_content_base64` block as defined below.
        :param pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs'] key_vault_private_key_passphrase: A `key_vault_private_key_passphrase` block as defined below.
               
               > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] password: Password to log on to the SFTP Server for Basic Authentication.
        :param pulumi.Input[_builtins.str] private_key_content_base64: The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key if the key is encrypted.
        :param pulumi.Input[_builtins.str] private_key_path: The absolute path to the private key file that the self-hosted integration runtime can access.
               
               > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        :param pulumi.Input[_builtins.bool] skip_host_key_validation: Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_key_fingerprint is not None:
            pulumi.set(__self__, "host_key_fingerprint", host_key_fingerprint)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_passwords is not None:
            pulumi.set(__self__, "key_vault_passwords", key_vault_passwords)
        if key_vault_private_key_content_base64 is not None:
            pulumi.set(__self__, "key_vault_private_key_content_base64", key_vault_private_key_content_base64)
        if key_vault_private_key_passphrase is not None:
            pulumi.set(__self__, "key_vault_private_key_passphrase", key_vault_private_key_passphrase)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_content_base64 is not None:
            pulumi.set(__self__, "private_key_content_base64", private_key_content_base64)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if skip_host_key_validation is not None:
            pulumi.set(__self__, "skip_host_key_validation", skip_host_key_validation)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The SFTP server hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username used to log on to the SFTP server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to SFTP Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host key fingerprint of the SFTP server.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @host_key_fingerprint.setter
    def host_key_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the integration runtime to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPasswords")
    def key_vault_passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]]]:
        """
        A `key_vault_password` block as defined below.

        > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        """
        return pulumi.get(self, "key_vault_passwords")

    @key_vault_passwords.setter
    def key_vault_passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]]]):
        pulumi.set(self, "key_vault_passwords", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateKeyContentBase64")
    def key_vault_private_key_content_base64(self) -> Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args']]:
        """
        A `key_vault_private_key_content_base64` block as defined below.
        """
        return pulumi.get(self, "key_vault_private_key_content_base64")

    @key_vault_private_key_content_base64.setter
    def key_vault_private_key_content_base64(self, value: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args']]):
        pulumi.set(self, "key_vault_private_key_content_base64", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateKeyPassphrase")
    def key_vault_private_key_passphrase(self) -> Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs']]:
        """
        A `key_vault_private_key_passphrase` block as defined below.

        > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        """
        return pulumi.get(self, "key_vault_private_key_passphrase")

    @key_vault_private_key_passphrase.setter
    def key_vault_private_key_passphrase(self, value: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs']]):
        pulumi.set(self, "key_vault_private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to log on to the SFTP Server for Basic Authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyContentBase64")
    def private_key_content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        """
        return pulumi.get(self, "private_key_content_base64")

    @private_key_content_base64.setter
    def private_key_content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_content_base64", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passphrase for the private key if the key is encrypted.
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The absolute path to the private key file that the self-hosted integration runtime can access.

        > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        """
        return pulumi.get(self, "private_key_path")

    @private_key_path.setter
    def private_key_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_path", value)

    @_builtins.property
    @pulumi.getter(name="skipHostKeyValidation")
    def skip_host_key_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        """
        return pulumi.get(self, "skip_host_key_validation")

    @skip_host_key_validation.setter
    def skip_host_key_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_host_key_validation", value)


@pulumi.input_type
class _LinkedServiceSftpState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_passwords: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]]] = None,
                 key_vault_private_key_content_base64: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args']] = None,
                 key_vault_private_key_passphrase: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_key_content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_host_key_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LinkedServiceSftp resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to SFTP Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] authentication_type: The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] host: The SFTP server hostname.
        :param pulumi.Input[_builtins.str] host_key_fingerprint: The host key fingerprint of the SFTP server.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The name of the integration runtime to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]] key_vault_passwords: A `key_vault_password` block as defined below.
               
               > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        :param pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args'] key_vault_private_key_content_base64: A `key_vault_private_key_content_base64` block as defined below.
        :param pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs'] key_vault_private_key_passphrase: A `key_vault_private_key_passphrase` block as defined below.
               
               > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] password: Password to log on to the SFTP Server for Basic Authentication.
        :param pulumi.Input[_builtins.int] port: The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        :param pulumi.Input[_builtins.str] private_key_content_base64: The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key if the key is encrypted.
        :param pulumi.Input[_builtins.str] private_key_path: The absolute path to the private key file that the self-hosted integration runtime can access.
               
               > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        :param pulumi.Input[_builtins.bool] skip_host_key_validation: Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        :param pulumi.Input[_builtins.str] username: The username used to log on to the SFTP server.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_key_fingerprint is not None:
            pulumi.set(__self__, "host_key_fingerprint", host_key_fingerprint)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_passwords is not None:
            pulumi.set(__self__, "key_vault_passwords", key_vault_passwords)
        if key_vault_private_key_content_base64 is not None:
            pulumi.set(__self__, "key_vault_private_key_content_base64", key_vault_private_key_content_base64)
        if key_vault_private_key_passphrase is not None:
            pulumi.set(__self__, "key_vault_private_key_passphrase", key_vault_private_key_passphrase)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_key_content_base64 is not None:
            pulumi.set(__self__, "private_key_content_base64", private_key_content_base64)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if skip_host_key_validation is not None:
            pulumi.set(__self__, "skip_host_key_validation", skip_host_key_validation)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to SFTP Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SFTP server hostname.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host key fingerprint of the SFTP server.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @host_key_fingerprint.setter
    def host_key_fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_key_fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the integration runtime to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPasswords")
    def key_vault_passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]]]:
        """
        A `key_vault_password` block as defined below.

        > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        """
        return pulumi.get(self, "key_vault_passwords")

    @key_vault_passwords.setter
    def key_vault_passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkedServiceSftpKeyVaultPasswordArgs']]]]):
        pulumi.set(self, "key_vault_passwords", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateKeyContentBase64")
    def key_vault_private_key_content_base64(self) -> Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args']]:
        """
        A `key_vault_private_key_content_base64` block as defined below.
        """
        return pulumi.get(self, "key_vault_private_key_content_base64")

    @key_vault_private_key_content_base64.setter
    def key_vault_private_key_content_base64(self, value: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args']]):
        pulumi.set(self, "key_vault_private_key_content_base64", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateKeyPassphrase")
    def key_vault_private_key_passphrase(self) -> Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs']]:
        """
        A `key_vault_private_key_passphrase` block as defined below.

        > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        """
        return pulumi.get(self, "key_vault_private_key_passphrase")

    @key_vault_private_key_passphrase.setter
    def key_vault_private_key_passphrase(self, value: Optional[pulumi.Input['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs']]):
        pulumi.set(self, "key_vault_private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to log on to the SFTP Server for Basic Authentication.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyContentBase64")
    def private_key_content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        """
        return pulumi.get(self, "private_key_content_base64")

    @private_key_content_base64.setter
    def private_key_content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_content_base64", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passphrase for the private key if the key is encrypted.
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The absolute path to the private key file that the self-hosted integration runtime can access.

        > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        """
        return pulumi.get(self, "private_key_path")

    @private_key_path.setter
    def private_key_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_path", value)

    @_builtins.property
    @pulumi.getter(name="skipHostKeyValidation")
    def skip_host_key_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        """
        return pulumi.get(self, "skip_host_key_validation")

    @skip_host_key_validation.setter
    def skip_host_key_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_host_key_validation", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username used to log on to the SFTP server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("azure:datafactory/linkedServiceSftp:LinkedServiceSftp")
class LinkedServiceSftp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_passwords: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinkedServiceSftpKeyVaultPasswordArgs', 'LinkedServiceSftpKeyVaultPasswordArgsDict']]]]] = None,
                 key_vault_private_key_content_base64: Optional[pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args', 'LinkedServiceSftpKeyVaultPrivateKeyContentBase64ArgsDict']]] = None,
                 key_vault_private_key_passphrase: Optional[pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs', 'LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_key_content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_host_key_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Linked Service (connection) between a SFTP Server and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_sftp = azure.datafactory.LinkedServiceSftp("example",
            name="example",
            data_factory_id=example_factory.id,
            authentication_type="Basic",
            host="http://www.bing.com",
            port=22,
            username="foo",
            password="bar")
        ```

        ## Import

        Data Factory Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceSftp:LinkedServiceSftp example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to SFTP Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] authentication_type: The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] host: The SFTP server hostname.
        :param pulumi.Input[_builtins.str] host_key_fingerprint: The host key fingerprint of the SFTP server.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The name of the integration runtime to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinkedServiceSftpKeyVaultPasswordArgs', 'LinkedServiceSftpKeyVaultPasswordArgsDict']]]] key_vault_passwords: A `key_vault_password` block as defined below.
               
               > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        :param pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args', 'LinkedServiceSftpKeyVaultPrivateKeyContentBase64ArgsDict']] key_vault_private_key_content_base64: A `key_vault_private_key_content_base64` block as defined below.
        :param pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs', 'LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgsDict']] key_vault_private_key_passphrase: A `key_vault_private_key_passphrase` block as defined below.
               
               > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] password: Password to log on to the SFTP Server for Basic Authentication.
        :param pulumi.Input[_builtins.int] port: The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        :param pulumi.Input[_builtins.str] private_key_content_base64: The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key if the key is encrypted.
        :param pulumi.Input[_builtins.str] private_key_path: The absolute path to the private key file that the self-hosted integration runtime can access.
               
               > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        :param pulumi.Input[_builtins.bool] skip_host_key_validation: Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        :param pulumi.Input[_builtins.str] username: The username used to log on to the SFTP server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkedServiceSftpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linked Service (connection) between a SFTP Server and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_sftp = azure.datafactory.LinkedServiceSftp("example",
            name="example",
            data_factory_id=example_factory.id,
            authentication_type="Basic",
            host="http://www.bing.com",
            port=22,
            username="foo",
            password="bar")
        ```

        ## Import

        Data Factory Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceSftp:LinkedServiceSftp example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param LinkedServiceSftpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkedServiceSftpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_passwords: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinkedServiceSftpKeyVaultPasswordArgs', 'LinkedServiceSftpKeyVaultPasswordArgsDict']]]]] = None,
                 key_vault_private_key_content_base64: Optional[pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args', 'LinkedServiceSftpKeyVaultPrivateKeyContentBase64ArgsDict']]] = None,
                 key_vault_private_key_passphrase: Optional[pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs', 'LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_key_content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_host_key_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkedServiceSftpArgs.__new__(LinkedServiceSftpArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            if authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_type'")
            __props__.__dict__["authentication_type"] = authentication_type
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["host_key_fingerprint"] = host_key_fingerprint
            __props__.__dict__["integration_runtime_name"] = integration_runtime_name
            __props__.__dict__["key_vault_passwords"] = key_vault_passwords
            __props__.__dict__["key_vault_private_key_content_base64"] = key_vault_private_key_content_base64
            __props__.__dict__["key_vault_private_key_passphrase"] = key_vault_private_key_passphrase
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["private_key_content_base64"] = None if private_key_content_base64 is None else pulumi.Output.secret(private_key_content_base64)
            __props__.__dict__["private_key_passphrase"] = None if private_key_passphrase is None else pulumi.Output.secret(private_key_passphrase)
            __props__.__dict__["private_key_path"] = private_key_path
            __props__.__dict__["skip_host_key_validation"] = skip_host_key_validation
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "privateKeyContentBase64", "privateKeyPassphrase"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinkedServiceSftp, __self__).__init__(
            'azure:datafactory/linkedServiceSftp:LinkedServiceSftp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            host_key_fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_passwords: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinkedServiceSftpKeyVaultPasswordArgs', 'LinkedServiceSftpKeyVaultPasswordArgsDict']]]]] = None,
            key_vault_private_key_content_base64: Optional[pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args', 'LinkedServiceSftpKeyVaultPrivateKeyContentBase64ArgsDict']]] = None,
            key_vault_private_key_passphrase: Optional[pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs', 'LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            private_key_content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
            skip_host_key_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'LinkedServiceSftp':
        """
        Get an existing LinkedServiceSftp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to SFTP Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] authentication_type: The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] host: The SFTP server hostname.
        :param pulumi.Input[_builtins.str] host_key_fingerprint: The host key fingerprint of the SFTP server.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The name of the integration runtime to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinkedServiceSftpKeyVaultPasswordArgs', 'LinkedServiceSftpKeyVaultPasswordArgsDict']]]] key_vault_passwords: A `key_vault_password` block as defined below.
               
               > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        :param pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyContentBase64Args', 'LinkedServiceSftpKeyVaultPrivateKeyContentBase64ArgsDict']] key_vault_private_key_content_base64: A `key_vault_private_key_content_base64` block as defined below.
        :param pulumi.Input[Union['LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgs', 'LinkedServiceSftpKeyVaultPrivateKeyPassphraseArgsDict']] key_vault_private_key_passphrase: A `key_vault_private_key_passphrase` block as defined below.
               
               > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] password: Password to log on to the SFTP Server for Basic Authentication.
        :param pulumi.Input[_builtins.int] port: The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        :param pulumi.Input[_builtins.str] private_key_content_base64: The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key if the key is encrypted.
        :param pulumi.Input[_builtins.str] private_key_path: The absolute path to the private key file that the self-hosted integration runtime can access.
               
               > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        :param pulumi.Input[_builtins.bool] skip_host_key_validation: Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        :param pulumi.Input[_builtins.str] username: The username used to log on to the SFTP server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkedServiceSftpState.__new__(_LinkedServiceSftpState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["host"] = host
        __props__.__dict__["host_key_fingerprint"] = host_key_fingerprint
        __props__.__dict__["integration_runtime_name"] = integration_runtime_name
        __props__.__dict__["key_vault_passwords"] = key_vault_passwords
        __props__.__dict__["key_vault_private_key_content_base64"] = key_vault_private_key_content_base64
        __props__.__dict__["key_vault_private_key_passphrase"] = key_vault_private_key_passphrase
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["private_key_content_base64"] = private_key_content_base64
        __props__.__dict__["private_key_passphrase"] = private_key_passphrase
        __props__.__dict__["private_key_path"] = private_key_path
        __props__.__dict__["skip_host_key_validation"] = skip_host_key_validation
        __props__.__dict__["username"] = username
        return LinkedServiceSftp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to SFTP Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of authentication used to connect to the SFTP server. Valid options are `MultiFactor`, `Basic` and `SshPublicKey`.
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The SFTP server hostname.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The host key fingerprint of the SFTP server.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the integration runtime to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @_builtins.property
    @pulumi.getter(name="keyVaultPasswords")
    def key_vault_passwords(self) -> pulumi.Output[Optional[Sequence['outputs.LinkedServiceSftpKeyVaultPassword']]]:
        """
        A `key_vault_password` block as defined below.

        > **Note:** Either `password` or `key_vault_password` is required when `authentication_type` is set to `Basic`.
        """
        return pulumi.get(self, "key_vault_passwords")

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateKeyContentBase64")
    def key_vault_private_key_content_base64(self) -> pulumi.Output[Optional['outputs.LinkedServiceSftpKeyVaultPrivateKeyContentBase64']]:
        """
        A `key_vault_private_key_content_base64` block as defined below.
        """
        return pulumi.get(self, "key_vault_private_key_content_base64")

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateKeyPassphrase")
    def key_vault_private_key_passphrase(self) -> pulumi.Output[Optional['outputs.LinkedServiceSftpKeyVaultPrivateKeyPassphrase']]:
        """
        A `key_vault_private_key_passphrase` block as defined below.

        > **Note:** One of `private_key_content_base64` or `private_key_path` (or their Key Vault equivalent) is required when `authentication_type` is set to `SshPublicKey`.
        """
        return pulumi.get(self, "key_vault_private_key_passphrase")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password to log on to the SFTP Server for Basic Authentication.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The TCP port number that the SFTP server uses to listen for client connection. Default value is 22.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateKeyContentBase64")
    def private_key_content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64 encoded private key content in OpenSSH format used to log on to the SFTP server.
        """
        return pulumi.get(self, "private_key_content_base64")

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The passphrase for the private key if the key is encrypted.
        """
        return pulumi.get(self, "private_key_passphrase")

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The absolute path to the private key file that the self-hosted integration runtime can access.

        > **Note:** `private_key_path` only applies when using a self-hosted integration runtime (instead of the default Azure provided runtime), as indicated by supplying a value for `integration_runtime_name`.
        """
        return pulumi.get(self, "private_key_path")

    @_builtins.property
    @pulumi.getter(name="skipHostKeyValidation")
    def skip_host_key_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to validate host key fingerprint while connecting. If set to `false`, `host_key_fingerprint` must also be set.
        """
        return pulumi.get(self, "skip_host_key_validation")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username used to log on to the SFTP server.
        """
        return pulumi.get(self, "username")

