# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupInstancePostgresqlArgs', 'BackupInstancePostgresql']

@pulumi.input_type
class BackupInstancePostgresqlArgs:
    def __init__(__self__, *,
                 backup_policy_id: pulumi.Input[_builtins.str],
                 database_id: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 database_credential_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupInstancePostgresql resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] database_id: The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] database_credential_key_vault_secret_id: The ID or versionless ID of the key vault secret which stores the connection string of the database.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if database_credential_key_vault_secret_id is not None:
            pulumi.set(__self__, "database_credential_key_vault_secret_id", database_credential_key_vault_secret_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseCredentialKeyVaultSecretId")
    def database_credential_key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or versionless ID of the key vault secret which stores the connection string of the database.
        """
        return pulumi.get(self, "database_credential_key_vault_secret_id")

    @database_credential_key_vault_secret_id.setter
    def database_credential_key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_credential_key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _BackupInstancePostgresqlState:
    def __init__(__self__, *,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_credential_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupInstancePostgresql resources.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] database_credential_key_vault_secret_id: The ID or versionless ID of the key vault secret which stores the connection string of the database.
        :param pulumi.Input[_builtins.str] database_id: The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if database_credential_key_vault_secret_id is not None:
            pulumi.set(__self__, "database_credential_key_vault_secret_id", database_credential_key_vault_secret_id)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseCredentialKeyVaultSecretId")
    def database_credential_key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or versionless ID of the key vault secret which stores the connection string of the database.
        """
        return pulumi.get(self, "database_credential_key_vault_secret_id")

    @database_credential_key_vault_secret_id.setter
    def database_credential_key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_credential_key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("azure:dataprotection/backupInstancePostgresql:BackupInstancePostgresql")
class BackupInstancePostgresql(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_credential_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backup Instance to back up PostgreSQL.

        > **Note:** Before using this resource, there are some prerequisite permissions for configure backup and restore. See more details from <https://docs.microsoft.com/azure/backup/backup-azure-database-postgresql#prerequisite-permissions-for-configure-backup-and-restore>.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_server = azure.postgresql.Server("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="B_Gen5_2",
            storage_mb=5120,
            backup_retention_days=7,
            geo_redundant_backup_enabled=False,
            auto_grow_enabled=True,
            administrator_login="psqladmin",
            administrator_login_password="H@Sh1CoR3!",
            version="9.5",
            ssl_enforcement_enabled=True)
        example_firewall_rule = azure.postgresql.FirewallRule("example",
            name="AllowAllWindowsAzureIps",
            resource_group_name=example.name,
            server_name=example_server.name,
            start_ip_address="0.0.0.0",
            end_ip_address="0.0.0.0")
        example_database = azure.postgresql.Database("example",
            name="example",
            resource_group_name=example.name,
            server_name=example_server.name,
            charset="UTF8",
            collation="English_United States.1252")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Get",
                    ],
                    "secret_permissions": [
                        "Set",
                        "Get",
                        "Delete",
                        "Purge",
                        "Recover",
                    ],
                },
                {
                    "tenant_id": example_backup_vault.identity.tenant_id,
                    "object_id": example_backup_vault.identity.principal_id,
                    "key_permissions": [
                        "Create",
                        "Get",
                    ],
                    "secret_permissions": [
                        "Set",
                        "Get",
                        "Delete",
                        "Purge",
                        "Recover",
                    ],
                },
            ])
        example_secret = azure.keyvault.Secret("example",
            name="example",
            value=pulumi.Output.all(
                exampleServerName=example_server.name,
                exampleDatabaseName=example_database.name,
                exampleServerName1=example_server.name
        ).apply(lambda resolved_outputs: f"Server={resolved_outputs['exampleServerName']}.postgres.database.azure.com;Database={resolved_outputs['exampleDatabaseName']};Port=5432;User Id=psqladmin@{resolved_outputs['exampleServerName1']};Password=H@Sh1CoR3!;Ssl Mode=Require;")
        ,
            key_vault_id=example_key_vault.id)
        example_backup_policy_postgresql = azure.dataprotection.BackupPolicyPostgresql("example",
            name="example",
            resource_group_name=example.name,
            vault_name=example_backup_vault.name,
            backup_repeating_time_intervals=["R/2021-05-23T02:30:00+00:00/P1W"],
            default_retention_duration="P4M")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_server.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        example_backup_instance_postgresql = azure.dataprotection.BackupInstancePostgresql("example",
            name="example",
            location=example.location,
            vault_id=example_backup_vault.id,
            database_id=example_database.id,
            backup_policy_id=example_backup_policy_postgresql.id,
            database_credential_key_vault_secret_id=example_secret.versionless_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Instance PostgreSQL can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupInstancePostgresql:BackupInstancePostgresql example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupInstances/backupInstance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] database_credential_key_vault_secret_id: The ID or versionless ID of the key vault secret which stores the connection string of the database.
        :param pulumi.Input[_builtins.str] database_id: The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupInstancePostgresqlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backup Instance to back up PostgreSQL.

        > **Note:** Before using this resource, there are some prerequisite permissions for configure backup and restore. See more details from <https://docs.microsoft.com/azure/backup/backup-azure-database-postgresql#prerequisite-permissions-for-configure-backup-and-restore>.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_server = azure.postgresql.Server("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="B_Gen5_2",
            storage_mb=5120,
            backup_retention_days=7,
            geo_redundant_backup_enabled=False,
            auto_grow_enabled=True,
            administrator_login="psqladmin",
            administrator_login_password="H@Sh1CoR3!",
            version="9.5",
            ssl_enforcement_enabled=True)
        example_firewall_rule = azure.postgresql.FirewallRule("example",
            name="AllowAllWindowsAzureIps",
            resource_group_name=example.name,
            server_name=example_server.name,
            start_ip_address="0.0.0.0",
            end_ip_address="0.0.0.0")
        example_database = azure.postgresql.Database("example",
            name="example",
            resource_group_name=example.name,
            server_name=example_server.name,
            charset="UTF8",
            collation="English_United States.1252")
        example_backup_vault = azure.dataprotection.BackupVault("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            datastore_type="VaultStore",
            redundancy="LocallyRedundant",
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Create",
                        "Get",
                    ],
                    "secret_permissions": [
                        "Set",
                        "Get",
                        "Delete",
                        "Purge",
                        "Recover",
                    ],
                },
                {
                    "tenant_id": example_backup_vault.identity.tenant_id,
                    "object_id": example_backup_vault.identity.principal_id,
                    "key_permissions": [
                        "Create",
                        "Get",
                    ],
                    "secret_permissions": [
                        "Set",
                        "Get",
                        "Delete",
                        "Purge",
                        "Recover",
                    ],
                },
            ])
        example_secret = azure.keyvault.Secret("example",
            name="example",
            value=pulumi.Output.all(
                exampleServerName=example_server.name,
                exampleDatabaseName=example_database.name,
                exampleServerName1=example_server.name
        ).apply(lambda resolved_outputs: f"Server={resolved_outputs['exampleServerName']}.postgres.database.azure.com;Database={resolved_outputs['exampleDatabaseName']};Port=5432;User Id=psqladmin@{resolved_outputs['exampleServerName1']};Password=H@Sh1CoR3!;Ssl Mode=Require;")
        ,
            key_vault_id=example_key_vault.id)
        example_backup_policy_postgresql = azure.dataprotection.BackupPolicyPostgresql("example",
            name="example",
            resource_group_name=example.name,
            vault_name=example_backup_vault.name,
            backup_repeating_time_intervals=["R/2021-05-23T02:30:00+00:00/P1W"],
            default_retention_duration="P4M")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_server.id,
            role_definition_name="Reader",
            principal_id=example_backup_vault.identity.principal_id)
        example_backup_instance_postgresql = azure.dataprotection.BackupInstancePostgresql("example",
            name="example",
            location=example.location,
            vault_id=example_backup_vault.id,
            database_id=example_database.id,
            backup_policy_id=example_backup_policy_postgresql.id,
            database_credential_key_vault_secret_id=example_secret.versionless_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataProtection` - 2024-04-01

        ## Import

        Backup Instance PostgreSQL can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dataprotection/backupInstancePostgresql:BackupInstancePostgresql example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataProtection/backupVaults/vault1/backupInstances/backupInstance1
        ```

        :param str resource_name: The name of the resource.
        :param BackupInstancePostgresqlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupInstancePostgresqlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_credential_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupInstancePostgresqlArgs.__new__(BackupInstancePostgresqlArgs)

            if backup_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_policy_id'")
            __props__.__dict__["backup_policy_id"] = backup_policy_id
            __props__.__dict__["database_credential_key_vault_secret_id"] = database_credential_key_vault_secret_id
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(BackupInstancePostgresql, __self__).__init__(
            'azure:dataprotection/backupInstancePostgresql:BackupInstancePostgresql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_credential_key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupInstancePostgresql':
        """
        Get an existing BackupInstancePostgresql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_policy_id: The ID of the Backup Policy.
        :param pulumi.Input[_builtins.str] database_credential_key_vault_secret_id: The ID or versionless ID of the key vault secret which stores the connection string of the database.
        :param pulumi.Input[_builtins.str] database_id: The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] location: The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupInstancePostgresqlState.__new__(_BackupInstancePostgresqlState)

        __props__.__dict__["backup_policy_id"] = backup_policy_id
        __props__.__dict__["database_credential_key_vault_secret_id"] = database_credential_key_vault_secret_id
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["vault_id"] = vault_id
        return BackupInstancePostgresql(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @_builtins.property
    @pulumi.getter(name="databaseCredentialKeyVaultSecretId")
    def database_credential_key_vault_secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID or versionless ID of the key vault secret which stores the connection string of the database.
        """
        return pulumi.get(self, "database_credential_key_vault_secret_id")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the source database. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Backup Instance PostgreSQL. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backup Vault within which the PostgreSQL Backup Instance should exist. Changing this forces a new Backup Instance PostgreSQL to be created.
        """
        return pulumi.get(self, "vault_id")

