# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'DatasetBlobStorageStorageAccountArgs',
    'DatasetBlobStorageStorageAccountArgsDict',
    'ShareSnapshotScheduleArgs',
    'ShareSnapshotScheduleArgsDict',
]

MYPY = False

if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Data Share Account. The only possible value is `SystemAssigned`. Changing this forces a new resource to be created.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and the Data Share Account has been created. More details are available below.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Identity of this Data Share Account.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Identity of this Data Share Account.
        """
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Data Share Account. The only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
               
               > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and the Data Share Account has been created. More details are available below.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Identity of this Data Share Account.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Identity of this Data Share Account.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Data Share Account. The only possible value is `SystemAssigned`. Changing this forces a new resource to be created.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned` and the Data Share Account has been created. More details are available below.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Identity of this Data Share Account.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this Data Share Account.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class DatasetBlobStorageStorageAccountArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
        resource_group_name: pulumi.Input[_builtins.str]
        """
        The resource group name of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
        subscription_id: pulumi.Input[_builtins.str]
        """
        The subscription id of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
elif False:
    DatasetBlobStorageStorageAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetBlobStorageStorageAccountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 subscription_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The resource group name of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        :param pulumi.Input[_builtins.str] subscription_id: The subscription id of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource group name of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        The subscription id of the storage account to be shared with the receiver. Changing this forces a new Data Share Blob Storage Dataset to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_id", value)


if not MYPY:
    class ShareSnapshotScheduleArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the snapshot schedule.
        """
        recurrence: pulumi.Input[_builtins.str]
        """
        The interval of the synchronization with the source data. Possible values are `Hour` and `Day`.
        """
        start_time: pulumi.Input[_builtins.str]
        """
        The synchronization with the source data's start time.
        """
elif False:
    ShareSnapshotScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShareSnapshotScheduleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 recurrence: pulumi.Input[_builtins.str],
                 start_time: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the snapshot schedule.
        :param pulumi.Input[_builtins.str] recurrence: The interval of the synchronization with the source data. Possible values are `Hour` and `Day`.
        :param pulumi.Input[_builtins.str] start_time: The synchronization with the source data's start time.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the snapshot schedule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> pulumi.Input[_builtins.str]:
        """
        The interval of the synchronization with the source data. Possible values are `Hour` and `Day`.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recurrence", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        The synchronization with the source data's start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)


