# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatasetKustoDatabaseArgs', 'DatasetKustoDatabase']

@pulumi.input_type
class DatasetKustoDatabaseArgs:
    def __init__(__self__, *,
                 kusto_database_id: pulumi.Input[_builtins.str],
                 share_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatasetKustoDatabase resource.
        :param pulumi.Input[_builtins.str] kusto_database_id: The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] share_id: The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        pulumi.set(__self__, "kusto_database_id", kusto_database_id)
        pulumi.set(__self__, "share_id", share_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "kusto_database_id")

    @kusto_database_id.setter
    def kusto_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kusto_database_id", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DatasetKustoDatabaseState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_cluster_location: Optional[pulumi.Input[_builtins.str]] = None,
                 kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatasetKustoDatabase resources.
        :param pulumi.Input[_builtins.str] display_name: The name of the Data Share Dataset.
        :param pulumi.Input[_builtins.str] kusto_cluster_location: The location of the Kusto Cluster.
        :param pulumi.Input[_builtins.str] kusto_database_id: The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] share_id: The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if kusto_cluster_location is not None:
            pulumi.set(__self__, "kusto_cluster_location", kusto_cluster_location)
        if kusto_database_id is not None:
            pulumi.set(__self__, "kusto_database_id", kusto_database_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if share_id is not None:
            pulumi.set(__self__, "share_id", share_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Data Share Dataset.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="kustoClusterLocation")
    def kusto_cluster_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the Kusto Cluster.
        """
        return pulumi.get(self, "kusto_cluster_location")

    @kusto_cluster_location.setter
    def kusto_cluster_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kusto_cluster_location", value)

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "kusto_database_id")

    @kusto_database_id.setter
    def kusto_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kusto_database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_id", value)


@pulumi.type_token("azure:datashare/datasetKustoDatabase:DatasetKustoDatabase")
class DatasetKustoDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Data Share Kusto Database Dataset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.datashare.Account("example",
            name="example-dsa",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        example_share = azure.datashare.Share("example",
            name="example_ds",
            account_id=example_account.id,
            kind="InPlace")
        example_cluster = azure.kusto.Cluster("example",
            name="examplekc",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        example_database = azure.kusto.Database("example",
            name="examplekd",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_cluster.id,
            role_definition_name="Contributor",
            principal_id=example_account.identity.principal_id)
        example_dataset_kusto_database = azure.datashare.DatasetKustoDatabase("example",
            name="example-dskd",
            share_id=example_share.id,
            kusto_database_id=example_database.id,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataShare` - 2019-11-01

        ## Import

        Data Share Kusto Database Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datashare/datasetKustoDatabase:DatasetKustoDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataShare/accounts/account1/shares/share1/dataSets/dataSet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] kusto_database_id: The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] share_id: The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetKustoDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Share Kusto Database Dataset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.datashare.Account("example",
            name="example-dsa",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        example_share = azure.datashare.Share("example",
            name="example_ds",
            account_id=example_account.id,
            kind="InPlace")
        example_cluster = azure.kusto.Cluster("example",
            name="examplekc",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        example_database = azure.kusto.Database("example",
            name="examplekd",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=example_cluster.name)
        example_assignment = azure.authorization.Assignment("example",
            scope=example_cluster.id,
            role_definition_name="Contributor",
            principal_id=example_account.identity.principal_id)
        example_dataset_kusto_database = azure.datashare.DatasetKustoDatabase("example",
            name="example-dskd",
            share_id=example_share.id,
            kusto_database_id=example_database.id,
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataShare` - 2019-11-01

        ## Import

        Data Share Kusto Database Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datashare/datasetKustoDatabase:DatasetKustoDatabase example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DataShare/accounts/account1/shares/share1/dataSets/dataSet1
        ```

        :param str resource_name: The name of the resource.
        :param DatasetKustoDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetKustoDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetKustoDatabaseArgs.__new__(DatasetKustoDatabaseArgs)

            if kusto_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'kusto_database_id'")
            __props__.__dict__["kusto_database_id"] = kusto_database_id
            __props__.__dict__["name"] = name
            if share_id is None and not opts.urn:
                raise TypeError("Missing required property 'share_id'")
            __props__.__dict__["share_id"] = share_id
            __props__.__dict__["display_name"] = None
            __props__.__dict__["kusto_cluster_location"] = None
        super(DatasetKustoDatabase, __self__).__init__(
            'azure:datashare/datasetKustoDatabase:DatasetKustoDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            kusto_cluster_location: Optional[pulumi.Input[_builtins.str]] = None,
            kusto_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            share_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatasetKustoDatabase':
        """
        Get an existing DatasetKustoDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The name of the Data Share Dataset.
        :param pulumi.Input[_builtins.str] kusto_cluster_location: The location of the Kusto Cluster.
        :param pulumi.Input[_builtins.str] kusto_database_id: The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        :param pulumi.Input[_builtins.str] share_id: The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetKustoDatabaseState.__new__(_DatasetKustoDatabaseState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["kusto_cluster_location"] = kusto_cluster_location
        __props__.__dict__["kusto_database_id"] = kusto_database_id
        __props__.__dict__["name"] = name
        __props__.__dict__["share_id"] = share_id
        return DatasetKustoDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Data Share Dataset.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="kustoClusterLocation")
    def kusto_cluster_location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the Kusto Cluster.
        """
        return pulumi.get(self, "kusto_cluster_location")

    @_builtins.property
    @pulumi.getter(name="kustoDatabaseId")
    def kusto_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Kusto Cluster Database to be shared with the receiver. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "kusto_database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Data Share Kusto Database Dataset. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Data Share where this Data Share Kusto Database Dataset should be created. Changing this forces a new Data Share Kusto Database Dataset to be created.
        """
        return pulumi.get(self, "share_id")

