# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GalleryArgs', 'Gallery']

@pulumi.input_type
class GalleryArgs:
    def __init__(__self__, *,
                 dev_center_id: pulumi.Input[_builtins.str],
                 shared_gallery_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Gallery resource.
        :param pulumi.Input[_builtins.str] dev_center_id: Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] shared_gallery_id: The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        pulumi.set(__self__, "shared_gallery_id", shared_gallery_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @dev_center_id.setter
    def dev_center_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_center_id", value)

    @_builtins.property
    @pulumi.getter(name="sharedGalleryId")
    def shared_gallery_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "shared_gallery_id")

    @shared_gallery_id.setter
    def shared_gallery_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "shared_gallery_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GalleryState:
    def __init__(__self__, *,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_gallery_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gallery resources.
        :param pulumi.Input[_builtins.str] dev_center_id: Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] shared_gallery_id: The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        if dev_center_id is not None:
            pulumi.set(__self__, "dev_center_id", dev_center_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shared_gallery_id is not None:
            pulumi.set(__self__, "shared_gallery_id", shared_gallery_id)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @dev_center_id.setter
    def dev_center_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sharedGalleryId")
    def shared_gallery_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "shared_gallery_id")

    @shared_gallery_id.setter
    def shared_gallery_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_gallery_id", value)


@pulumi.type_token("azure:devcenter/gallery:Gallery")
class Gallery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_gallery_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Dev Center Gallery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test_user_assigned_identity = azure.authorization.UserAssignedIdentity("test",
            name="example-uai",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"])
        test = azure.devcenter.DevCenter("test",
            name="example-devcenter",
            resource_group_name=test_azurerm_resource_group["name"],
            location=test_azurerm_resource_group["location"],
            identity={
                "type": "UserAssigned",
                "identity_ids": [test_user_assigned_identity.id],
            })
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="example-image-gallery",
            location=example.location,
            resource_group_name=example.name)
        example_gallery = azure.devcenter.Gallery("example",
            dev_center_id=example_azurerm_dev_center["id"],
            shared_gallery_id=example_shared_image_gallery.id,
            name="example")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center Gallery can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/gallery:Gallery example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devCenters/{devCenterName}/galleries/{galleryName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Dev Center Gallery exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Dev Center Gallery exists. For example `example-resource-group`.

        * Where `{devCenterName}` is the name of the Dev Center. For example `devCenterValue`.

        * Where `{galleryName}` is the name of the Gallery. For example `galleryValue`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_center_id: Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] shared_gallery_id: The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GalleryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center Gallery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test_user_assigned_identity = azure.authorization.UserAssignedIdentity("test",
            name="example-uai",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"])
        test = azure.devcenter.DevCenter("test",
            name="example-devcenter",
            resource_group_name=test_azurerm_resource_group["name"],
            location=test_azurerm_resource_group["location"],
            identity={
                "type": "UserAssigned",
                "identity_ids": [test_user_assigned_identity.id],
            })
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="example-image-gallery",
            location=example.location,
            resource_group_name=example.name)
        example_gallery = azure.devcenter.Gallery("example",
            dev_center_id=example_azurerm_dev_center["id"],
            shared_gallery_id=example_shared_image_gallery.id,
            name="example")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center Gallery can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/gallery:Gallery example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devCenters/{devCenterName}/galleries/{galleryName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Dev Center Gallery exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Dev Center Gallery exists. For example `example-resource-group`.

        * Where `{devCenterName}` is the name of the Dev Center. For example `devCenterValue`.

        * Where `{galleryName}` is the name of the Gallery. For example `galleryValue`.

        :param str resource_name: The name of the resource.
        :param GalleryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GalleryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_gallery_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GalleryArgs.__new__(GalleryArgs)

            if dev_center_id is None and not opts.urn:
                raise TypeError("Missing required property 'dev_center_id'")
            __props__.__dict__["dev_center_id"] = dev_center_id
            __props__.__dict__["name"] = name
            if shared_gallery_id is None and not opts.urn:
                raise TypeError("Missing required property 'shared_gallery_id'")
            __props__.__dict__["shared_gallery_id"] = shared_gallery_id
        super(Gallery, __self__).__init__(
            'azure:devcenter/gallery:Gallery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            shared_gallery_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Gallery':
        """
        Get an existing Gallery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_center_id: Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        :param pulumi.Input[_builtins.str] shared_gallery_id: The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GalleryState.__new__(_GalleryState)

        __props__.__dict__["dev_center_id"] = dev_center_id
        __props__.__dict__["name"] = name
        __props__.__dict__["shared_gallery_id"] = shared_gallery_id
        return Gallery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Dev Center within which this Dev Center Gallery should exist. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sharedGalleryId")
    def shared_gallery_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Shared Gallery which should be connected to the Dev Center Gallery. Changing this forces a new Dev Center Gallery to be created.
        """
        return pulumi.get(self, "shared_gallery_id")

