# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkConnectionResult',
    'AwaitableGetNetworkConnectionResult',
    'get_network_connection',
    'get_network_connection_output',
]

@pulumi.output_type
class GetNetworkConnectionResult:
    """
    A collection of values returned by getNetworkConnection.
    """
    def __init__(__self__, domain_join_type=None, domain_name=None, domain_username=None, id=None, location=None, name=None, organization_unit=None, resource_group_name=None, subnet_id=None, tags=None):
        if domain_join_type and not isinstance(domain_join_type, str):
            raise TypeError("Expected argument 'domain_join_type' to be a str")
        pulumi.set(__self__, "domain_join_type", domain_join_type)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if domain_username and not isinstance(domain_username, str):
            raise TypeError("Expected argument 'domain_username' to be a str")
        pulumi.set(__self__, "domain_username", domain_username)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_unit and not isinstance(organization_unit, str):
            raise TypeError("Expected argument 'organization_unit' to be a str")
        pulumi.set(__self__, "organization_unit", organization_unit)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainJoinType")
    def domain_join_type(self) -> _builtins.str:
        """
        The Azure Active Directory Join type.
        """
        return pulumi.get(self, "domain_join_type")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The name of the Azure Active Directory domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainUsername")
    def domain_username(self) -> _builtins.str:
        """
        The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        """
        return pulumi.get(self, "domain_username")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Dev Center Network Connection exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> _builtins.str:
        """
        The Azure Active Directory domain Organization Unit (OU).
        """
        return pulumi.get(self, "organization_unit")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The ID of the Subnet that is used to attach Virtual Machines.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Dev Center Network Connection.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkConnectionResult(GetNetworkConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkConnectionResult(
            domain_join_type=self.domain_join_type,
            domain_name=self.domain_name,
            domain_username=self.domain_username,
            id=self.id,
            location=self.location,
            name=self.name,
            organization_unit=self.organization_unit,
            resource_group_name=self.resource_group_name,
            subnet_id=self.subnet_id,
            tags=self.tags)


def get_network_connection(name: Optional[_builtins.str] = None,
                           resource_group_name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkConnectionResult:
    """
    Use this data source to access information about an existing Dev Center Network Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_network_connection(name="example",
        resource_group_name="example-resource-group")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str name: The name of this Dev Center Network Connection.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dev Center Network Connection exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getNetworkConnection:getNetworkConnection', __args__, opts=opts, typ=GetNetworkConnectionResult).value

    return AwaitableGetNetworkConnectionResult(
        domain_join_type=pulumi.get(__ret__, 'domain_join_type'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        domain_username=pulumi.get(__ret__, 'domain_username'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        organization_unit=pulumi.get(__ret__, 'organization_unit'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_connection_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                  resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkConnectionResult]:
    """
    Use this data source to access information about an existing Dev Center Network Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_network_connection(name="example",
        resource_group_name="example-resource-group")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str name: The name of this Dev Center Network Connection.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dev Center Network Connection exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getNetworkConnection:getNetworkConnection', __args__, opts=opts, typ=GetNetworkConnectionResult)
    return __ret__.apply(lambda __response__: GetNetworkConnectionResult(
        domain_join_type=pulumi.get(__response__, 'domain_join_type'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        domain_username=pulumi.get(__response__, 'domain_username'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        organization_unit=pulumi.get(__response__, 'organization_unit'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        tags=pulumi.get(__response__, 'tags')))
