# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, description=None, dev_center_id=None, dev_center_uri=None, id=None, identities=None, location=None, maximum_dev_boxes_per_user=None, name=None, resource_group_name=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dev_center_id and not isinstance(dev_center_id, str):
            raise TypeError("Expected argument 'dev_center_id' to be a str")
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        if dev_center_uri and not isinstance(dev_center_uri, str):
            raise TypeError("Expected argument 'dev_center_uri' to be a str")
        pulumi.set(__self__, "dev_center_uri", dev_center_uri)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if maximum_dev_boxes_per_user and not isinstance(maximum_dev_boxes_per_user, int):
            raise TypeError("Expected argument 'maximum_dev_boxes_per_user' to be a int")
        pulumi.set(__self__, "maximum_dev_boxes_per_user", maximum_dev_boxes_per_user)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Dev Center Project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> _builtins.str:
        """
        The ID of the associated Dev Center.
        """
        return pulumi.get(self, "dev_center_id")

    @_builtins.property
    @pulumi.getter(name="devCenterUri")
    def dev_center_uri(self) -> _builtins.str:
        """
        The URI of the Dev Center.
        """
        return pulumi.get(self, "dev_center_uri")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetProjectIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Dev Center Project exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumDevBoxesPerUser")
    def maximum_dev_boxes_per_user(self) -> _builtins.int:
        """
        The maximum number of Dev Boxes a single user can create across all pools in the project.
        """
        return pulumi.get(self, "maximum_dev_boxes_per_user")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Dev Center Project.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            description=self.description,
            dev_center_id=self.dev_center_id,
            dev_center_uri=self.dev_center_uri,
            id=self.id,
            identities=self.identities,
            location=self.location,
            maximum_dev_boxes_per_user=self.maximum_dev_boxes_per_user,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_project(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Use this data source to access information about an existing Dev Center Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_project(name="example",
        resource_group_name="example-resource-group")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str name: The name of this Dev Center Project.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dev Center Project exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        description=pulumi.get(__ret__, 'description'),
        dev_center_id=pulumi.get(__ret__, 'dev_center_id'),
        dev_center_uri=pulumi.get(__ret__, 'dev_center_uri'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        maximum_dev_boxes_per_user=pulumi.get(__ret__, 'maximum_dev_boxes_per_user'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Use this data source to access information about an existing Dev Center Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_project(name="example",
        resource_group_name="example-resource-group")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str name: The name of this Dev Center Project.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dev Center Project exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        description=pulumi.get(__response__, 'description'),
        dev_center_id=pulumi.get(__response__, 'dev_center_id'),
        dev_center_uri=pulumi.get(__response__, 'dev_center_uri'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        maximum_dev_boxes_per_user=pulumi.get(__response__, 'maximum_dev_boxes_per_user'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
