# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectPoolArgs', 'ProjectPool']

@pulumi.input_type
class ProjectPoolArgs:
    def __init__(__self__, *,
                 dev_box_definition_name: pulumi.Input[_builtins.str],
                 dev_center_attached_network_name: pulumi.Input[_builtins.str],
                 dev_center_project_id: pulumi.Input[_builtins.str],
                 local_administrator_enabled: pulumi.Input[_builtins.bool],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_virtual_network_regions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_sign_on_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_on_disconnect_grace_period_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ProjectPool resource.
        :param pulumi.Input[_builtins.str] dev_box_definition_name: The name of the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] dev_center_attached_network_name: The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] local_administrator_enabled: Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_virtual_network_regions: A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.
               
               > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_sign_on_enabled: Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.int] stop_on_disconnect_grace_period_minutes: The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        pulumi.set(__self__, "dev_box_definition_name", dev_box_definition_name)
        pulumi.set(__self__, "dev_center_attached_network_name", dev_center_attached_network_name)
        pulumi.set(__self__, "dev_center_project_id", dev_center_project_id)
        pulumi.set(__self__, "local_administrator_enabled", local_administrator_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_virtual_network_regions is not None:
            pulumi.set(__self__, "managed_virtual_network_regions", managed_virtual_network_regions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if single_sign_on_enabled is not None:
            pulumi.set(__self__, "single_sign_on_enabled", single_sign_on_enabled)
        if stop_on_disconnect_grace_period_minutes is not None:
            pulumi.set(__self__, "stop_on_disconnect_grace_period_minutes", stop_on_disconnect_grace_period_minutes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devBoxDefinitionName")
    def dev_box_definition_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "dev_box_definition_name")

    @dev_box_definition_name.setter
    def dev_box_definition_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_box_definition_name", value)

    @_builtins.property
    @pulumi.getter(name="devCenterAttachedNetworkName")
    def dev_center_attached_network_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        """
        return pulumi.get(self, "dev_center_attached_network_name")

    @dev_center_attached_network_name.setter
    def dev_center_attached_network_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_center_attached_network_name", value)

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_project_id")

    @dev_center_project_id.setter
    def dev_center_project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_center_project_id", value)

    @_builtins.property
    @pulumi.getter(name="localAdministratorEnabled")
    def local_administrator_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        """
        return pulumi.get(self, "local_administrator_enabled")

    @local_administrator_enabled.setter
    def local_administrator_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "local_administrator_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedVirtualNetworkRegions")
    def managed_virtual_network_regions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.

        > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        """
        return pulumi.get(self, "managed_virtual_network_regions")

    @managed_virtual_network_regions.setter
    def managed_virtual_network_regions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_virtual_network_regions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="singleSignOnEnabled")
    def single_sign_on_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "single_sign_on_enabled")

    @single_sign_on_enabled.setter
    def single_sign_on_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_sign_on_enabled", value)

    @_builtins.property
    @pulumi.getter(name="stopOnDisconnectGracePeriodMinutes")
    def stop_on_disconnect_grace_period_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        """
        return pulumi.get(self, "stop_on_disconnect_grace_period_minutes")

    @stop_on_disconnect_grace_period_minutes.setter
    def stop_on_disconnect_grace_period_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_on_disconnect_grace_period_minutes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectPoolState:
    def __init__(__self__, *,
                 dev_box_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_attached_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_administrator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_virtual_network_regions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_sign_on_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_on_disconnect_grace_period_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ProjectPool resources.
        :param pulumi.Input[_builtins.str] dev_box_definition_name: The name of the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] dev_center_attached_network_name: The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] local_administrator_enabled: Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_virtual_network_regions: A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.
               
               > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_sign_on_enabled: Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.int] stop_on_disconnect_grace_period_minutes: The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        if dev_box_definition_name is not None:
            pulumi.set(__self__, "dev_box_definition_name", dev_box_definition_name)
        if dev_center_attached_network_name is not None:
            pulumi.set(__self__, "dev_center_attached_network_name", dev_center_attached_network_name)
        if dev_center_project_id is not None:
            pulumi.set(__self__, "dev_center_project_id", dev_center_project_id)
        if local_administrator_enabled is not None:
            pulumi.set(__self__, "local_administrator_enabled", local_administrator_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_virtual_network_regions is not None:
            pulumi.set(__self__, "managed_virtual_network_regions", managed_virtual_network_regions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if single_sign_on_enabled is not None:
            pulumi.set(__self__, "single_sign_on_enabled", single_sign_on_enabled)
        if stop_on_disconnect_grace_period_minutes is not None:
            pulumi.set(__self__, "stop_on_disconnect_grace_period_minutes", stop_on_disconnect_grace_period_minutes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devBoxDefinitionName")
    def dev_box_definition_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "dev_box_definition_name")

    @dev_box_definition_name.setter
    def dev_box_definition_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_box_definition_name", value)

    @_builtins.property
    @pulumi.getter(name="devCenterAttachedNetworkName")
    def dev_center_attached_network_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        """
        return pulumi.get(self, "dev_center_attached_network_name")

    @dev_center_attached_network_name.setter
    def dev_center_attached_network_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_attached_network_name", value)

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_project_id")

    @dev_center_project_id.setter
    def dev_center_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_project_id", value)

    @_builtins.property
    @pulumi.getter(name="localAdministratorEnabled")
    def local_administrator_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        """
        return pulumi.get(self, "local_administrator_enabled")

    @local_administrator_enabled.setter
    def local_administrator_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_administrator_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedVirtualNetworkRegions")
    def managed_virtual_network_regions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.

        > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        """
        return pulumi.get(self, "managed_virtual_network_regions")

    @managed_virtual_network_regions.setter
    def managed_virtual_network_regions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_virtual_network_regions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="singleSignOnEnabled")
    def single_sign_on_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "single_sign_on_enabled")

    @single_sign_on_enabled.setter
    def single_sign_on_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_sign_on_enabled", value)

    @_builtins.property
    @pulumi.getter(name="stopOnDisconnectGracePeriodMinutes")
    def stop_on_disconnect_grace_period_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        """
        return pulumi.get(self, "stop_on_disconnect_grace_period_minutes")

    @stop_on_disconnect_grace_period_minutes.setter
    def stop_on_disconnect_grace_period_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "stop_on_disconnect_grace_period_minutes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:devcenter/projectPool:ProjectPool")
class ProjectPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dev_box_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_attached_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_administrator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_virtual_network_regions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_sign_on_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_on_disconnect_grace_period_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Dev Center Project Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_dev_center = azure.devcenter.DevCenter("example",
            name="example-dc",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_connection = azure.devcenter.NetworkConnection("example",
            name="example-dcnc",
            resource_group_name=example.name,
            location=example.location,
            subnet_id=example_subnet.id,
            domain_join_type="AzureADJoin")
        example_attached_network = azure.devcenter.AttachedNetwork("example",
            name="example-dcet",
            dev_center_id=example_dev_center.id,
            network_connection_id=example_network_connection.id)
        example_project = azure.devcenter.Project("example",
            name="example-dcp",
            resource_group_name=example.name,
            location=example.location,
            dev_center_id=example_dev_center.id)
        example_dev_box_definition = azure.devcenter.DevBoxDefinition("example",
            name="example-dcet",
            location=example.location,
            dev_center_id=example_dev_center.id,
            image_reference_id=example_dev_center.id.apply(lambda id: f"{id}/galleries/default/images/microsoftvisualstudio_visualstudioplustools_vs-2022-ent-general-win10-m365-gen2"),
            sku_name="general_i_8c32gb256ssd_v2")
        example_project_pool = azure.devcenter.ProjectPool("example",
            name="example-dcpl",
            location=example.location,
            dev_center_project_id=example_project.id,
            dev_box_definition_name=example_dev_box_definition.name,
            local_administrator_enabled=True,
            dev_center_attached_network_name=example_attached_network.name,
            stop_on_disconnect_grace_period_minutes=60)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center Project Pool can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/projectPool:ProjectPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/projects/project1/pools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_box_definition_name: The name of the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] dev_center_attached_network_name: The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] local_administrator_enabled: Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_virtual_network_regions: A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.
               
               > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_sign_on_enabled: Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.int] stop_on_disconnect_grace_period_minutes: The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center Project Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_dev_center = azure.devcenter.DevCenter("example",
            name="example-dc",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_connection = azure.devcenter.NetworkConnection("example",
            name="example-dcnc",
            resource_group_name=example.name,
            location=example.location,
            subnet_id=example_subnet.id,
            domain_join_type="AzureADJoin")
        example_attached_network = azure.devcenter.AttachedNetwork("example",
            name="example-dcet",
            dev_center_id=example_dev_center.id,
            network_connection_id=example_network_connection.id)
        example_project = azure.devcenter.Project("example",
            name="example-dcp",
            resource_group_name=example.name,
            location=example.location,
            dev_center_id=example_dev_center.id)
        example_dev_box_definition = azure.devcenter.DevBoxDefinition("example",
            name="example-dcet",
            location=example.location,
            dev_center_id=example_dev_center.id,
            image_reference_id=example_dev_center.id.apply(lambda id: f"{id}/galleries/default/images/microsoftvisualstudio_visualstudioplustools_vs-2022-ent-general-win10-m365-gen2"),
            sku_name="general_i_8c32gb256ssd_v2")
        example_project_pool = azure.devcenter.ProjectPool("example",
            name="example-dcpl",
            location=example.location,
            dev_center_project_id=example_project.id,
            dev_box_definition_name=example_dev_box_definition.name,
            local_administrator_enabled=True,
            dev_center_attached_network_name=example_attached_network.name,
            stop_on_disconnect_grace_period_minutes=60)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center Project Pool can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/projectPool:ProjectPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/projects/project1/pools/pool1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dev_box_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_attached_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 local_administrator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_virtual_network_regions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_sign_on_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 stop_on_disconnect_grace_period_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectPoolArgs.__new__(ProjectPoolArgs)

            if dev_box_definition_name is None and not opts.urn:
                raise TypeError("Missing required property 'dev_box_definition_name'")
            __props__.__dict__["dev_box_definition_name"] = dev_box_definition_name
            if dev_center_attached_network_name is None and not opts.urn:
                raise TypeError("Missing required property 'dev_center_attached_network_name'")
            __props__.__dict__["dev_center_attached_network_name"] = dev_center_attached_network_name
            if dev_center_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'dev_center_project_id'")
            __props__.__dict__["dev_center_project_id"] = dev_center_project_id
            if local_administrator_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'local_administrator_enabled'")
            __props__.__dict__["local_administrator_enabled"] = local_administrator_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_virtual_network_regions"] = managed_virtual_network_regions
            __props__.__dict__["name"] = name
            __props__.__dict__["single_sign_on_enabled"] = single_sign_on_enabled
            __props__.__dict__["stop_on_disconnect_grace_period_minutes"] = stop_on_disconnect_grace_period_minutes
            __props__.__dict__["tags"] = tags
        super(ProjectPool, __self__).__init__(
            'azure:devcenter/projectPool:ProjectPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dev_box_definition_name: Optional[pulumi.Input[_builtins.str]] = None,
            dev_center_attached_network_name: Optional[pulumi.Input[_builtins.str]] = None,
            dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            local_administrator_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_virtual_network_regions: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            single_sign_on_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            stop_on_disconnect_grace_period_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ProjectPool':
        """
        Get an existing ProjectPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_box_definition_name: The name of the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] dev_center_attached_network_name: The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        :param pulumi.Input[_builtins.str] dev_center_project_id: The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] local_administrator_enabled: Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] managed_virtual_network_regions: A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.
               
               > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] single_sign_on_enabled: Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.int] stop_on_disconnect_grace_period_minutes: The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectPoolState.__new__(_ProjectPoolState)

        __props__.__dict__["dev_box_definition_name"] = dev_box_definition_name
        __props__.__dict__["dev_center_attached_network_name"] = dev_center_attached_network_name
        __props__.__dict__["dev_center_project_id"] = dev_center_project_id
        __props__.__dict__["local_administrator_enabled"] = local_administrator_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_virtual_network_regions"] = managed_virtual_network_regions
        __props__.__dict__["name"] = name
        __props__.__dict__["single_sign_on_enabled"] = single_sign_on_enabled
        __props__.__dict__["stop_on_disconnect_grace_period_minutes"] = stop_on_disconnect_grace_period_minutes
        __props__.__dict__["tags"] = tags
        return ProjectPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="devBoxDefinitionName")
    def dev_box_definition_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "dev_box_definition_name")

    @_builtins.property
    @pulumi.getter(name="devCenterAttachedNetworkName")
    def dev_center_attached_network_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        """
        return pulumi.get(self, "dev_center_attached_network_name")

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated Dev Center Project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_project_id")

    @_builtins.property
    @pulumi.getter(name="localAdministratorEnabled")
    def local_administrator_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        """
        return pulumi.get(self, "local_administrator_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dev Center Project Pool should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedVirtualNetworkRegions")
    def managed_virtual_network_regions(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A list of the regions of the managed Virtual Network. When specified, the Dev Center Project Pool will use a Microsoft managed network.

        > **Note:** Currently only one region can be specified for `managed_virtual_network_regions`.
        """
        return pulumi.get(self, "managed_virtual_network_regions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center Project Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="singleSignOnEnabled")
    def single_sign_on_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether Dev Boxes in the Pool will have SSO enabled or disabled. Defaults to `false`.
        """
        return pulumi.get(self, "single_sign_on_enabled")

    @_builtins.property
    @pulumi.getter(name="stopOnDisconnectGracePeriodMinutes")
    def stop_on_disconnect_grace_period_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected. Possible values are between `60` and `480`.
        """
        return pulumi.get(self, "stop_on_disconnect_grace_period_minutes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project Pool.
        """
        return pulumi.get(self, "tags")

