# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServiceInitialReplicaSetArgs',
    'ServiceInitialReplicaSetArgsDict',
    'ServiceNotificationsArgs',
    'ServiceNotificationsArgsDict',
    'ServiceSecureLdapArgs',
    'ServiceSecureLdapArgsDict',
    'ServiceSecurityArgs',
    'ServiceSecurityArgsDict',
]

MYPY = False

if not MYPY:
    class ServiceInitialReplicaSetArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The ID of the subnet in which to place the initial replica set. Changing this forces a new resource to be created.
        """
        domain_controller_ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of subnet IP addresses for the domain controllers in the initial replica set, typically two.
        """
        external_access_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The publicly routable IP address for the domain controllers in the initial replica set.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        A unique ID for the replica set.
        """
        location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        """
        service_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The current service status for the initial replica set.
        """
elif False:
    ServiceInitialReplicaSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceInitialReplicaSetArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 domain_controller_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_access_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 service_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet in which to place the initial replica set. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_controller_ip_addresses: A list of subnet IP addresses for the domain controllers in the initial replica set, typically two.
        :param pulumi.Input[_builtins.str] external_access_ip_address: The publicly routable IP address for the domain controllers in the initial replica set.
        :param pulumi.Input[_builtins.str] id: A unique ID for the replica set.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_status: The current service status for the initial replica set.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if domain_controller_ip_addresses is not None:
            pulumi.set(__self__, "domain_controller_ip_addresses", domain_controller_ip_addresses)
        if external_access_ip_address is not None:
            pulumi.set(__self__, "external_access_ip_address", external_access_ip_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_status is not None:
            pulumi.set(__self__, "service_status", service_status)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet in which to place the initial replica set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="domainControllerIpAddresses")
    def domain_controller_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of subnet IP addresses for the domain controllers in the initial replica set, typically two.
        """
        return pulumi.get(self, "domain_controller_ip_addresses")

    @domain_controller_ip_addresses.setter
    def domain_controller_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_controller_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessIpAddress")
    def external_access_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The publicly routable IP address for the domain controllers in the initial replica set.
        """
        return pulumi.get(self, "external_access_ip_address")

    @external_access_ip_address.setter
    def external_access_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_access_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique ID for the replica set.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="serviceStatus")
    def service_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current service status for the initial replica set.
        """
        return pulumi.get(self, "service_status")

    @service_status.setter
    def service_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_status", value)


if not MYPY:
    class ServiceNotificationsArgsDict(TypedDict):
        additional_recipients: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of additional email addresses to notify when there are alerts in the managed domain.
        """
        notify_dc_admins: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to notify members of the _AAD DC Administrators_ group when there are alerts in the managed domain.
        """
        notify_global_admins: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to notify all Global Administrators when there are alerts in the managed domain.
        """
elif False:
    ServiceNotificationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceNotificationsArgs:
    def __init__(__self__, *,
                 additional_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 notify_dc_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 notify_global_admins: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_recipients: A list of additional email addresses to notify when there are alerts in the managed domain.
        :param pulumi.Input[_builtins.bool] notify_dc_admins: Whether to notify members of the _AAD DC Administrators_ group when there are alerts in the managed domain.
        :param pulumi.Input[_builtins.bool] notify_global_admins: Whether to notify all Global Administrators when there are alerts in the managed domain.
        """
        if additional_recipients is not None:
            pulumi.set(__self__, "additional_recipients", additional_recipients)
        if notify_dc_admins is not None:
            pulumi.set(__self__, "notify_dc_admins", notify_dc_admins)
        if notify_global_admins is not None:
            pulumi.set(__self__, "notify_global_admins", notify_global_admins)

    @_builtins.property
    @pulumi.getter(name="additionalRecipients")
    def additional_recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of additional email addresses to notify when there are alerts in the managed domain.
        """
        return pulumi.get(self, "additional_recipients")

    @additional_recipients.setter
    def additional_recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_recipients", value)

    @_builtins.property
    @pulumi.getter(name="notifyDcAdmins")
    def notify_dc_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to notify members of the _AAD DC Administrators_ group when there are alerts in the managed domain.
        """
        return pulumi.get(self, "notify_dc_admins")

    @notify_dc_admins.setter
    def notify_dc_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notify_dc_admins", value)

    @_builtins.property
    @pulumi.getter(name="notifyGlobalAdmins")
    def notify_global_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to notify all Global Administrators when there are alerts in the managed domain.
        """
        return pulumi.get(self, "notify_global_admins")

    @notify_global_admins.setter
    def notify_global_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notify_global_admins", value)


if not MYPY:
    class ServiceSecureLdapArgsDict(TypedDict):
        enabled: pulumi.Input[_builtins.bool]
        """
        Whether to enable secure LDAP for the managed domain. For more information, please see [official documentation on enabling LDAPS](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-configure-ldaps), paying particular attention to the section on network security to avoid unnecessarily exposing your service to Internet-borne bruteforce attacks.
        """
        pfx_certificate: pulumi.Input[_builtins.str]
        """
        The certificate/private key to use for LDAPS, as a base64-encoded TripleDES-SHA1 encrypted PKCS#12 bundle (PFX file).
        """
        pfx_certificate_password: pulumi.Input[_builtins.str]
        """
        The password to use for decrypting the PKCS#12 bundle (PFX file).
        """
        certificate_expiry: NotRequired[pulumi.Input[_builtins.str]]
        """
        The expiry time of the certificate.
        """
        certificate_thumbprint: NotRequired[pulumi.Input[_builtins.str]]
        """
        The thumbprint of the certificate.
        """
        external_access_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable external access to LDAPS over the Internet. Defaults to `false`.
        """
        public_certificate: NotRequired[pulumi.Input[_builtins.str]]
        """
        The public certificate.
        """
elif False:
    ServiceSecureLdapArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceSecureLdapArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 pfx_certificate: pulumi.Input[_builtins.str],
                 pfx_certificate_password: pulumi.Input[_builtins.str],
                 certificate_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 external_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_certificate: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable secure LDAP for the managed domain. For more information, please see [official documentation on enabling LDAPS](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-configure-ldaps), paying particular attention to the section on network security to avoid unnecessarily exposing your service to Internet-borne bruteforce attacks.
        :param pulumi.Input[_builtins.str] pfx_certificate: The certificate/private key to use for LDAPS, as a base64-encoded TripleDES-SHA1 encrypted PKCS#12 bundle (PFX file).
        :param pulumi.Input[_builtins.str] pfx_certificate_password: The password to use for decrypting the PKCS#12 bundle (PFX file).
        :param pulumi.Input[_builtins.str] certificate_expiry: The expiry time of the certificate.
        :param pulumi.Input[_builtins.str] certificate_thumbprint: The thumbprint of the certificate.
        :param pulumi.Input[_builtins.bool] external_access_enabled: Whether to enable external access to LDAPS over the Internet. Defaults to `false`.
        :param pulumi.Input[_builtins.str] public_certificate: The public certificate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "pfx_certificate", pfx_certificate)
        pulumi.set(__self__, "pfx_certificate_password", pfx_certificate_password)
        if certificate_expiry is not None:
            pulumi.set(__self__, "certificate_expiry", certificate_expiry)
        if certificate_thumbprint is not None:
            pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        if external_access_enabled is not None:
            pulumi.set(__self__, "external_access_enabled", external_access_enabled)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to enable secure LDAP for the managed domain. For more information, please see [official documentation on enabling LDAPS](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-configure-ldaps), paying particular attention to the section on network security to avoid unnecessarily exposing your service to Internet-borne bruteforce attacks.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="pfxCertificate")
    def pfx_certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The certificate/private key to use for LDAPS, as a base64-encoded TripleDES-SHA1 encrypted PKCS#12 bundle (PFX file).
        """
        return pulumi.get(self, "pfx_certificate")

    @pfx_certificate.setter
    def pfx_certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pfx_certificate", value)

    @_builtins.property
    @pulumi.getter(name="pfxCertificatePassword")
    def pfx_certificate_password(self) -> pulumi.Input[_builtins.str]:
        """
        The password to use for decrypting the PKCS#12 bundle (PFX file).
        """
        return pulumi.get(self, "pfx_certificate_password")

    @pfx_certificate_password.setter
    def pfx_certificate_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pfx_certificate_password", value)

    @_builtins.property
    @pulumi.getter(name="certificateExpiry")
    def certificate_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiry time of the certificate.
        """
        return pulumi.get(self, "certificate_expiry")

    @certificate_expiry.setter
    def certificate_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_expiry", value)

    @_builtins.property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @certificate_thumbprint.setter
    def certificate_thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_thumbprint", value)

    @_builtins.property
    @pulumi.getter(name="externalAccessEnabled")
    def external_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable external access to LDAPS over the Internet. Defaults to `false`.
        """
        return pulumi.get(self, "external_access_enabled")

    @external_access_enabled.setter
    def external_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public certificate.
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_certificate", value)


if not MYPY:
    class ServiceSecurityArgsDict(TypedDict):
        kerberos_armoring_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable Kerberos Armoring. Defaults to `false`.
        """
        kerberos_rc4_encryption_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable Kerberos RC4 Encryption. Defaults to `false`.
        """
        ntlm_v1_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable legacy NTLM v1 support. Defaults to `false`.
        """
        sync_kerberos_passwords: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to synchronize Kerberos password hashes to the managed domain. Defaults to `false`.
        """
        sync_ntlm_passwords: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to synchronize NTLM password hashes to the managed domain. Defaults to `false`.
        """
        sync_on_prem_passwords: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to synchronize on-premises password hashes to the managed domain. Defaults to `false`.
        """
        tls_v1_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable legacy TLS v1 support. Defaults to `false`.
        """
elif False:
    ServiceSecurityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceSecurityArgs:
    def __init__(__self__, *,
                 kerberos_armoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 kerberos_rc4_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ntlm_v1_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_kerberos_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_ntlm_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_on_prem_passwords: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_v1_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] kerberos_armoring_enabled: Whether to enable Kerberos Armoring. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] kerberos_rc4_encryption_enabled: Whether to enable Kerberos RC4 Encryption. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] ntlm_v1_enabled: Whether to enable legacy NTLM v1 support. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] sync_kerberos_passwords: Whether to synchronize Kerberos password hashes to the managed domain. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] sync_ntlm_passwords: Whether to synchronize NTLM password hashes to the managed domain. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] sync_on_prem_passwords: Whether to synchronize on-premises password hashes to the managed domain. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] tls_v1_enabled: Whether to enable legacy TLS v1 support. Defaults to `false`.
        """
        if kerberos_armoring_enabled is not None:
            pulumi.set(__self__, "kerberos_armoring_enabled", kerberos_armoring_enabled)
        if kerberos_rc4_encryption_enabled is not None:
            pulumi.set(__self__, "kerberos_rc4_encryption_enabled", kerberos_rc4_encryption_enabled)
        if ntlm_v1_enabled is not None:
            pulumi.set(__self__, "ntlm_v1_enabled", ntlm_v1_enabled)
        if sync_kerberos_passwords is not None:
            pulumi.set(__self__, "sync_kerberos_passwords", sync_kerberos_passwords)
        if sync_ntlm_passwords is not None:
            pulumi.set(__self__, "sync_ntlm_passwords", sync_ntlm_passwords)
        if sync_on_prem_passwords is not None:
            pulumi.set(__self__, "sync_on_prem_passwords", sync_on_prem_passwords)
        if tls_v1_enabled is not None:
            pulumi.set(__self__, "tls_v1_enabled", tls_v1_enabled)

    @_builtins.property
    @pulumi.getter(name="kerberosArmoringEnabled")
    def kerberos_armoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Kerberos Armoring. Defaults to `false`.
        """
        return pulumi.get(self, "kerberos_armoring_enabled")

    @kerberos_armoring_enabled.setter
    def kerberos_armoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos_armoring_enabled", value)

    @_builtins.property
    @pulumi.getter(name="kerberosRc4EncryptionEnabled")
    def kerberos_rc4_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable Kerberos RC4 Encryption. Defaults to `false`.
        """
        return pulumi.get(self, "kerberos_rc4_encryption_enabled")

    @kerberos_rc4_encryption_enabled.setter
    def kerberos_rc4_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos_rc4_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ntlmV1Enabled")
    def ntlm_v1_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable legacy NTLM v1 support. Defaults to `false`.
        """
        return pulumi.get(self, "ntlm_v1_enabled")

    @ntlm_v1_enabled.setter
    def ntlm_v1_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ntlm_v1_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syncKerberosPasswords")
    def sync_kerberos_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize Kerberos password hashes to the managed domain. Defaults to `false`.
        """
        return pulumi.get(self, "sync_kerberos_passwords")

    @sync_kerberos_passwords.setter
    def sync_kerberos_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_kerberos_passwords", value)

    @_builtins.property
    @pulumi.getter(name="syncNtlmPasswords")
    def sync_ntlm_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize NTLM password hashes to the managed domain. Defaults to `false`.
        """
        return pulumi.get(self, "sync_ntlm_passwords")

    @sync_ntlm_passwords.setter
    def sync_ntlm_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_ntlm_passwords", value)

    @_builtins.property
    @pulumi.getter(name="syncOnPremPasswords")
    def sync_on_prem_passwords(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize on-premises password hashes to the managed domain. Defaults to `false`.
        """
        return pulumi.get(self, "sync_on_prem_passwords")

    @sync_on_prem_passwords.setter
    def sync_on_prem_passwords(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_on_prem_passwords", value)

    @_builtins.property
    @pulumi.getter(name="tlsV1Enabled")
    def tls_v1_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable legacy TLS v1 support. Defaults to `false`.
        """
        return pulumi.get(self, "tls_v1_enabled")

    @tls_v1_enabled.setter
    def tls_v1_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_v1_enabled", value)


