# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 initial_replica_set: pulumi.Input['ServiceInitialReplicaSetArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 domain_configuration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 filtered_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input['ServiceNotificationsArgs']] = None,
                 secure_ldap: Optional[pulumi.Input['ServiceSecureLdapArgs']] = None,
                 security: Optional[pulumi.Input['ServiceSecurityArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] domain_name: The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        :param pulumi.Input['ServiceInitialReplicaSetArgs'] initial_replica_set: An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        :param pulumi.Input[_builtins.str] domain_configuration_type: The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] filtered_sync_enabled: Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input['ServiceNotificationsArgs'] notifications: A `notifications` block as defined below.
        :param pulumi.Input['ServiceSecureLdapArgs'] secure_ldap: A `secure_ldap` block as defined below.
        :param pulumi.Input['ServiceSecurityArgs'] security: A `security` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "initial_replica_set", initial_replica_set)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if domain_configuration_type is not None:
            pulumi.set(__self__, "domain_configuration_type", domain_configuration_type)
        if filtered_sync_enabled is not None:
            pulumi.set(__self__, "filtered_sync_enabled", filtered_sync_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if secure_ldap is not None:
            pulumi.set(__self__, "secure_ldap", secure_ldap)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="initialReplicaSet")
    def initial_replica_set(self) -> pulumi.Input['ServiceInitialReplicaSetArgs']:
        """
        An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        """
        return pulumi.get(self, "initial_replica_set")

    @initial_replica_set.setter
    def initial_replica_set(self, value: pulumi.Input['ServiceInitialReplicaSetArgs']):
        pulumi.set(self, "initial_replica_set", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="domainConfigurationType")
    def domain_configuration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_configuration_type")

    @domain_configuration_type.setter
    def domain_configuration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_configuration_type", value)

    @_builtins.property
    @pulumi.getter(name="filteredSyncEnabled")
    def filtered_sync_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        """
        return pulumi.get(self, "filtered_sync_enabled")

    @filtered_sync_enabled.setter
    def filtered_sync_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "filtered_sync_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['ServiceNotificationsArgs']]:
        """
        A `notifications` block as defined below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['ServiceNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="secureLdap")
    def secure_ldap(self) -> Optional[pulumi.Input['ServiceSecureLdapArgs']]:
        """
        A `secure_ldap` block as defined below.
        """
        return pulumi.get(self, "secure_ldap")

    @secure_ldap.setter
    def secure_ldap(self, value: Optional[pulumi.Input['ServiceSecureLdapArgs']]):
        pulumi.set(self, "secure_ldap", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['ServiceSecurityArgs']]:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['ServiceSecurityArgs']]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_configuration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filtered_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 initial_replica_set: Optional[pulumi.Input['ServiceInitialReplicaSetArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input['ServiceNotificationsArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_ldap: Optional[pulumi.Input['ServiceSecureLdapArgs']] = None,
                 security: Optional[pulumi.Input['ServiceSecurityArgs']] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.str] deployment_id: A unique ID for the managed domain deployment.
        :param pulumi.Input[_builtins.str] domain_configuration_type: The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] domain_name: The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] filtered_sync_enabled: Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        :param pulumi.Input['ServiceInitialReplicaSetArgs'] initial_replica_set: An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input['ServiceNotificationsArgs'] notifications: A `notifications` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_id: The Azure resource ID for the domain service.
        :param pulumi.Input['ServiceSecureLdapArgs'] secure_ldap: A `secure_ldap` block as defined below.
        :param pulumi.Input['ServiceSecurityArgs'] security: A `security` block as defined below.
        :param pulumi.Input[_builtins.str] sku: The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        """
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if domain_configuration_type is not None:
            pulumi.set(__self__, "domain_configuration_type", domain_configuration_type)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if filtered_sync_enabled is not None:
            pulumi.set(__self__, "filtered_sync_enabled", filtered_sync_enabled)
        if initial_replica_set is not None:
            pulumi.set(__self__, "initial_replica_set", initial_replica_set)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secure_ldap is not None:
            pulumi.set(__self__, "secure_ldap", secure_ldap)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if sync_owner is not None:
            pulumi.set(__self__, "sync_owner", sync_owner)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique ID for the managed domain deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="domainConfigurationType")
    def domain_configuration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_configuration_type")

    @domain_configuration_type.setter
    def domain_configuration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_configuration_type", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="filteredSyncEnabled")
    def filtered_sync_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        """
        return pulumi.get(self, "filtered_sync_enabled")

    @filtered_sync_enabled.setter
    def filtered_sync_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "filtered_sync_enabled", value)

    @_builtins.property
    @pulumi.getter(name="initialReplicaSet")
    def initial_replica_set(self) -> Optional[pulumi.Input['ServiceInitialReplicaSetArgs']]:
        """
        An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        """
        return pulumi.get(self, "initial_replica_set")

    @initial_replica_set.setter
    def initial_replica_set(self, value: Optional[pulumi.Input['ServiceInitialReplicaSetArgs']]):
        pulumi.set(self, "initial_replica_set", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['ServiceNotificationsArgs']]:
        """
        A `notifications` block as defined below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['ServiceNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure resource ID for the domain service.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="secureLdap")
    def secure_ldap(self) -> Optional[pulumi.Input['ServiceSecureLdapArgs']]:
        """
        A `secure_ldap` block as defined below.
        """
        return pulumi.get(self, "secure_ldap")

    @secure_ldap.setter
    def secure_ldap(self, value: Optional[pulumi.Input['ServiceSecureLdapArgs']]):
        pulumi.set(self, "secure_ldap", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['ServiceSecurityArgs']]:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['ServiceSecurityArgs']]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="syncOwner")
    def sync_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "sync_owner")

    @sync_owner.setter
    def sync_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_owner", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:domainservices/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_configuration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filtered_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 initial_replica_set: Optional[pulumi.Input[Union['ServiceInitialReplicaSetArgs', 'ServiceInitialReplicaSetArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Union['ServiceNotificationsArgs', 'ServiceNotificationsArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_ldap: Optional[pulumi.Input[Union['ServiceSecureLdapArgs', 'ServiceSecureLdapArgsDict']]] = None,
                 security: Optional[pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        deploy = azure.core.ResourceGroup("deploy",
            name="example-resources",
            location="West Europe")
        deploy_virtual_network = azure.network.VirtualNetwork("deploy",
            name="deploy-vnet",
            location=deploy.location,
            resource_group_name=deploy.name,
            address_spaces=["10.0.1.0/16"])
        deploy_subnet = azure.network.Subnet("deploy",
            name="deploy-subnet",
            resource_group_name=deploy.name,
            virtual_network_name=deploy_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        deploy_network_security_group = azure.network.NetworkSecurityGroup("deploy",
            name="deploy-nsg",
            location=deploy.location,
            resource_group_name=deploy.name,
            security_rules=[
                {
                    "name": "AllowSyncWithAzureAD",
                    "priority": 101,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "443",
                    "source_address_prefix": "AzureActiveDirectoryDomainServices",
                    "destination_address_prefix": "*",
                },
                {
                    "name": "AllowRD",
                    "priority": 201,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "3389",
                    "source_address_prefix": "CorpNetSaw",
                    "destination_address_prefix": "*",
                },
                {
                    "name": "AllowPSRemoting",
                    "priority": 301,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "5986",
                    "source_address_prefix": "AzureActiveDirectoryDomainServices",
                    "destination_address_prefix": "*",
                },
                {
                    "name": "AllowLDAPS",
                    "priority": 401,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "636",
                    "source_address_prefix": "*",
                    "destination_address_prefix": "*",
                },
            ])
        deploy_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("deploy",
            subnet_id=deploy_subnet.id,
            network_security_group_id=deploy_network_security_group.id)
        dc_admins = azuread.Group("dc_admins",
            display_name="AAD DC Administrators",
            security_enabled=True)
        admin = azuread.User("admin",
            user_principal_name="dc-admin@hashicorp-example.com",
            display_name="DC Administrator",
            password="Pa55w0Rd!!1")
        admin_group_member = azuread.GroupMember("admin",
            group_object_id=dc_admins.object_id,
            member_object_id=admin.object_id)
        example = azuread.ServicePrincipal("example", application_id="2565bd9d-da50-47d4-8b85-4c97f669dc36")
        aadds = azure.core.ResourceGroup("aadds",
            name="aadds-rg",
            location="westeurope")
        example_service = azure.domainservices.Service("example",
            name="example-aadds",
            location=aadds.location,
            resource_group_name=aadds.name,
            domain_name="widgetslogin.net",
            sku="Enterprise",
            filtered_sync_enabled=False,
            initial_replica_set={
                "subnet_id": deploy_subnet.id,
            },
            notifications={
                "additional_recipients": [
                    "notifyA@example.net",
                    "notifyB@example.org",
                ],
                "notify_dc_admins": True,
                "notify_global_admins": True,
            },
            security={
                "sync_kerberos_passwords": True,
                "sync_ntlm_passwords": True,
                "sync_on_prem_passwords": True,
            },
            tags={
                "Environment": "prod",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example,
                    deploy_subnet_network_security_group_association,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AAD` - 2021-05-01

        ## Import

        Domain Services can be imported using the resource ID, together with the Replica Set ID that you wish to designate as the initial replica set, e.g.

        ```sh
        $ pulumi import azure:domainservices/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AAD/domainServices/instance1/initialReplicaSetId/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_configuration_type: The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] domain_name: The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] filtered_sync_enabled: Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        :param pulumi.Input[Union['ServiceInitialReplicaSetArgs', 'ServiceInitialReplicaSetArgsDict']] initial_replica_set: An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServiceNotificationsArgs', 'ServiceNotificationsArgsDict']] notifications: A `notifications` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServiceSecureLdapArgs', 'ServiceSecureLdapArgsDict']] secure_ldap: A `secure_ldap` block as defined below.
        :param pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']] security: A `security` block as defined below.
        :param pulumi.Input[_builtins.str] sku: The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        deploy = azure.core.ResourceGroup("deploy",
            name="example-resources",
            location="West Europe")
        deploy_virtual_network = azure.network.VirtualNetwork("deploy",
            name="deploy-vnet",
            location=deploy.location,
            resource_group_name=deploy.name,
            address_spaces=["10.0.1.0/16"])
        deploy_subnet = azure.network.Subnet("deploy",
            name="deploy-subnet",
            resource_group_name=deploy.name,
            virtual_network_name=deploy_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        deploy_network_security_group = azure.network.NetworkSecurityGroup("deploy",
            name="deploy-nsg",
            location=deploy.location,
            resource_group_name=deploy.name,
            security_rules=[
                {
                    "name": "AllowSyncWithAzureAD",
                    "priority": 101,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "443",
                    "source_address_prefix": "AzureActiveDirectoryDomainServices",
                    "destination_address_prefix": "*",
                },
                {
                    "name": "AllowRD",
                    "priority": 201,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "3389",
                    "source_address_prefix": "CorpNetSaw",
                    "destination_address_prefix": "*",
                },
                {
                    "name": "AllowPSRemoting",
                    "priority": 301,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "5986",
                    "source_address_prefix": "AzureActiveDirectoryDomainServices",
                    "destination_address_prefix": "*",
                },
                {
                    "name": "AllowLDAPS",
                    "priority": 401,
                    "direction": "Inbound",
                    "access": "Allow",
                    "protocol": "Tcp",
                    "source_port_range": "*",
                    "destination_port_range": "636",
                    "source_address_prefix": "*",
                    "destination_address_prefix": "*",
                },
            ])
        deploy_subnet_network_security_group_association = azure.network.SubnetNetworkSecurityGroupAssociation("deploy",
            subnet_id=deploy_subnet.id,
            network_security_group_id=deploy_network_security_group.id)
        dc_admins = azuread.Group("dc_admins",
            display_name="AAD DC Administrators",
            security_enabled=True)
        admin = azuread.User("admin",
            user_principal_name="dc-admin@hashicorp-example.com",
            display_name="DC Administrator",
            password="Pa55w0Rd!!1")
        admin_group_member = azuread.GroupMember("admin",
            group_object_id=dc_admins.object_id,
            member_object_id=admin.object_id)
        example = azuread.ServicePrincipal("example", application_id="2565bd9d-da50-47d4-8b85-4c97f669dc36")
        aadds = azure.core.ResourceGroup("aadds",
            name="aadds-rg",
            location="westeurope")
        example_service = azure.domainservices.Service("example",
            name="example-aadds",
            location=aadds.location,
            resource_group_name=aadds.name,
            domain_name="widgetslogin.net",
            sku="Enterprise",
            filtered_sync_enabled=False,
            initial_replica_set={
                "subnet_id": deploy_subnet.id,
            },
            notifications={
                "additional_recipients": [
                    "notifyA@example.net",
                    "notifyB@example.org",
                ],
                "notify_dc_admins": True,
                "notify_global_admins": True,
            },
            security={
                "sync_kerberos_passwords": True,
                "sync_ntlm_passwords": True,
                "sync_on_prem_passwords": True,
            },
            tags={
                "Environment": "prod",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example,
                    deploy_subnet_network_security_group_association,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AAD` - 2021-05-01

        ## Import

        Domain Services can be imported using the resource ID, together with the Replica Set ID that you wish to designate as the initial replica set, e.g.

        ```sh
        $ pulumi import azure:domainservices/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AAD/domainServices/instance1/initialReplicaSetId/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_configuration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 filtered_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 initial_replica_set: Optional[pulumi.Input[Union['ServiceInitialReplicaSetArgs', 'ServiceInitialReplicaSetArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Union['ServiceNotificationsArgs', 'ServiceNotificationsArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_ldap: Optional[pulumi.Input[Union['ServiceSecureLdapArgs', 'ServiceSecureLdapArgsDict']]] = None,
                 security: Optional[pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["domain_configuration_type"] = domain_configuration_type
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["filtered_sync_enabled"] = filtered_sync_enabled
            if initial_replica_set is None and not opts.urn:
                raise TypeError("Missing required property 'initial_replica_set'")
            __props__.__dict__["initial_replica_set"] = initial_replica_set
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["notifications"] = notifications
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secure_ldap"] = secure_ldap
            __props__.__dict__["security"] = security
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["deployment_id"] = None
            __props__.__dict__["resource_id"] = None
            __props__.__dict__["sync_owner"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["version"] = None
        super(Service, __self__).__init__(
            'azure:domainservices/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
            domain_configuration_type: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            filtered_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            initial_replica_set: Optional[pulumi.Input[Union['ServiceInitialReplicaSetArgs', 'ServiceInitialReplicaSetArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notifications: Optional[pulumi.Input[Union['ServiceNotificationsArgs', 'ServiceNotificationsArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            secure_ldap: Optional[pulumi.Input[Union['ServiceSecureLdapArgs', 'ServiceSecureLdapArgsDict']]] = None,
            security: Optional[pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            sync_owner: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deployment_id: A unique ID for the managed domain deployment.
        :param pulumi.Input[_builtins.str] domain_configuration_type: The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] domain_name: The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] filtered_sync_enabled: Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        :param pulumi.Input[Union['ServiceInitialReplicaSetArgs', 'ServiceInitialReplicaSetArgsDict']] initial_replica_set: An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServiceNotificationsArgs', 'ServiceNotificationsArgsDict']] notifications: A `notifications` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_id: The Azure resource ID for the domain service.
        :param pulumi.Input[Union['ServiceSecureLdapArgs', 'ServiceSecureLdapArgsDict']] secure_ldap: A `secure_ldap` block as defined below.
        :param pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']] security: A `security` block as defined below.
        :param pulumi.Input[_builtins.str] sku: The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["domain_configuration_type"] = domain_configuration_type
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["filtered_sync_enabled"] = filtered_sync_enabled
        __props__.__dict__["initial_replica_set"] = initial_replica_set
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["secure_ldap"] = secure_ldap
        __props__.__dict__["security"] = security
        __props__.__dict__["sku"] = sku
        __props__.__dict__["sync_owner"] = sync_owner
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["version"] = version
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique ID for the managed domain deployment.
        """
        return pulumi.get(self, "deployment_id")

    @_builtins.property
    @pulumi.getter(name="domainConfigurationType")
    def domain_configuration_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The configuration type of this Active Directory Domain. Possible values are `FullySynced` and `ResourceTrusting`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_configuration_type")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Active Directory domain to use. See [official documentation](https://docs.microsoft.com/azure/active-directory-domain-services/tutorial-create-instance#create-a-managed-domain) for constraints and recommendations. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="filteredSyncEnabled")
    def filtered_sync_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable group-based filtered sync (also called scoped synchronisation). Defaults to `false`.
        """
        return pulumi.get(self, "filtered_sync_enabled")

    @_builtins.property
    @pulumi.getter(name="initialReplicaSet")
    def initial_replica_set(self) -> pulumi.Output['outputs.ServiceInitialReplicaSet']:
        """
        An `initial_replica_set` block as defined below. The initial replica set inherits the same location as the Domain Service resource.
        """
        return pulumi.get(self, "initial_replica_set")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where the Domain Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for your managed Active Directory Domain Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output['outputs.ServiceNotifications']:
        """
        A `notifications` block as defined below.
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Domain Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure resource ID for the domain service.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="secureLdap")
    def secure_ldap(self) -> pulumi.Output['outputs.ServiceSecureLdap']:
        """
        A `secure_ldap` block as defined below.
        """
        return pulumi.get(self, "secure_ldap")

    @_builtins.property
    @pulumi.getter
    def security(self) -> pulumi.Output['outputs.ServiceSecurity']:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "security")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU to use when provisioning the Domain Service resource. One of `Standard`, `Enterprise` or `Premium`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="syncOwner")
    def sync_owner(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "sync_owner")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "version")

