# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TagRulesArgs', 'TagRules']

@pulumi.input_type
class TagRulesArgs:
    def __init__(__self__, *,
                 monitor_id: pulumi.Input[_builtins.str],
                 log_rule: Optional[pulumi.Input['TagRulesLogRuleArgs']] = None,
                 metric_rule: Optional[pulumi.Input['TagRulesMetricRuleArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TagRules resource.
        :param pulumi.Input[_builtins.str] monitor_id: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input['TagRulesLogRuleArgs'] log_rule: Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        :param pulumi.Input['TagRulesMetricRuleArgs'] metric_rule: Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "monitor_id", monitor_id)
        if log_rule is not None:
            pulumi.set(__self__, "log_rule", log_rule)
        if metric_rule is not None:
            pulumi.set(__self__, "metric_rule", metric_rule)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter(name="logRule")
    def log_rule(self) -> Optional[pulumi.Input['TagRulesLogRuleArgs']]:
        """
        Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        """
        return pulumi.get(self, "log_rule")

    @log_rule.setter
    def log_rule(self, value: Optional[pulumi.Input['TagRulesLogRuleArgs']]):
        pulumi.set(self, "log_rule", value)

    @_builtins.property
    @pulumi.getter(name="metricRule")
    def metric_rule(self) -> Optional[pulumi.Input['TagRulesMetricRuleArgs']]:
        """
        Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        """
        return pulumi.get(self, "metric_rule")

    @metric_rule.setter
    def metric_rule(self, value: Optional[pulumi.Input['TagRulesMetricRuleArgs']]):
        pulumi.set(self, "metric_rule", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TagRulesState:
    def __init__(__self__, *,
                 log_rule: Optional[pulumi.Input['TagRulesLogRuleArgs']] = None,
                 metric_rule: Optional[pulumi.Input['TagRulesMetricRuleArgs']] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TagRules resources.
        :param pulumi.Input['TagRulesLogRuleArgs'] log_rule: Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        :param pulumi.Input['TagRulesMetricRuleArgs'] metric_rule: Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        :param pulumi.Input[_builtins.str] monitor_id: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        if log_rule is not None:
            pulumi.set(__self__, "log_rule", log_rule)
        if metric_rule is not None:
            pulumi.set(__self__, "metric_rule", metric_rule)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="logRule")
    def log_rule(self) -> Optional[pulumi.Input['TagRulesLogRuleArgs']]:
        """
        Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        """
        return pulumi.get(self, "log_rule")

    @log_rule.setter
    def log_rule(self, value: Optional[pulumi.Input['TagRulesLogRuleArgs']]):
        pulumi.set(self, "log_rule", value)

    @_builtins.property
    @pulumi.getter(name="metricRule")
    def metric_rule(self) -> Optional[pulumi.Input['TagRulesMetricRuleArgs']]:
        """
        Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        """
        return pulumi.get(self, "metric_rule")

    @metric_rule.setter
    def metric_rule(self, value: Optional[pulumi.Input['TagRulesMetricRuleArgs']]):
        pulumi.set(self, "metric_rule", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:dynatrace/tagRules:TagRules")
class TagRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_rule: Optional[pulumi.Input[Union['TagRulesLogRuleArgs', 'TagRulesLogRuleArgsDict']]] = None,
                 metric_rule: Optional[pulumi.Input[Union['TagRulesMetricRuleArgs', 'TagRulesMetricRuleArgsDict']]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Dynatrace tag rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_monitor = azure.dynatrace.Monitor("example",
            name="exmpledynatracemonitor",
            resource_group_name=example.name,
            location=test["location"],
            monitoring_enabled=True,
            marketplace_subscription_status="Active",
            identity={
                "type": "SystemAssigned",
            },
            user={
                "first_name": "Alice",
                "last_name": "Bobab",
                "email": "alice@microsoft.com",
                "phone_number": "123456",
                "country": "westus",
            },
            plan={
                "usage_type": "COMMITTED",
                "billing_cycle": "MONTHLY",
                "plan": "azureportalintegration_privatepreview@TIDhjdtn7tfnxcy",
                "effective_date": "2019-08-30T15:14:33Z",
            })
        example_tag_rules = azure.dynatrace.TagRules("example",
            name="default",
            monitor_id=test_azurerm_dynatrace_monitors["id"],
            log_rule={
                "filtering_tags": [{
                    "name": "Environment",
                    "value": "Prod",
                    "action": "Include",
                }],
                "send_azure_active_directory_logs_enabled": True,
                "send_activity_logs_enabled": True,
                "send_subscription_logs_enabled": True,
            },
            metric_rule={
                "filtering_tags": [{
                    "name": "Environment",
                    "value": "Prod",
                    "action": "Include",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Dynatrace.Observability` - 2023-04-27

        ## Import

        Dynatrace tag rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dynatrace/tagRules:TagRules example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Dynatrace.Observability/monitors/monitor1/tagRules/tagRules1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TagRulesLogRuleArgs', 'TagRulesLogRuleArgsDict']] log_rule: Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        :param pulumi.Input[Union['TagRulesMetricRuleArgs', 'TagRulesMetricRuleArgsDict']] metric_rule: Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        :param pulumi.Input[_builtins.str] monitor_id: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Dynatrace tag rules.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_monitor = azure.dynatrace.Monitor("example",
            name="exmpledynatracemonitor",
            resource_group_name=example.name,
            location=test["location"],
            monitoring_enabled=True,
            marketplace_subscription_status="Active",
            identity={
                "type": "SystemAssigned",
            },
            user={
                "first_name": "Alice",
                "last_name": "Bobab",
                "email": "alice@microsoft.com",
                "phone_number": "123456",
                "country": "westus",
            },
            plan={
                "usage_type": "COMMITTED",
                "billing_cycle": "MONTHLY",
                "plan": "azureportalintegration_privatepreview@TIDhjdtn7tfnxcy",
                "effective_date": "2019-08-30T15:14:33Z",
            })
        example_tag_rules = azure.dynatrace.TagRules("example",
            name="default",
            monitor_id=test_azurerm_dynatrace_monitors["id"],
            log_rule={
                "filtering_tags": [{
                    "name": "Environment",
                    "value": "Prod",
                    "action": "Include",
                }],
                "send_azure_active_directory_logs_enabled": True,
                "send_activity_logs_enabled": True,
                "send_subscription_logs_enabled": True,
            },
            metric_rule={
                "filtering_tags": [{
                    "name": "Environment",
                    "value": "Prod",
                    "action": "Include",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Dynatrace.Observability` - 2023-04-27

        ## Import

        Dynatrace tag rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dynatrace/tagRules:TagRules example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Dynatrace.Observability/monitors/monitor1/tagRules/tagRules1
        ```

        :param str resource_name: The name of the resource.
        :param TagRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_rule: Optional[pulumi.Input[Union['TagRulesLogRuleArgs', 'TagRulesLogRuleArgsDict']]] = None,
                 metric_rule: Optional[pulumi.Input[Union['TagRulesMetricRuleArgs', 'TagRulesMetricRuleArgsDict']]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagRulesArgs.__new__(TagRulesArgs)

            __props__.__dict__["log_rule"] = log_rule
            __props__.__dict__["metric_rule"] = metric_rule
            if monitor_id is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_id'")
            __props__.__dict__["monitor_id"] = monitor_id
            __props__.__dict__["name"] = name
        super(TagRules, __self__).__init__(
            'azure:dynatrace/tagRules:TagRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            log_rule: Optional[pulumi.Input[Union['TagRulesLogRuleArgs', 'TagRulesLogRuleArgsDict']]] = None,
            metric_rule: Optional[pulumi.Input[Union['TagRulesMetricRuleArgs', 'TagRulesMetricRuleArgsDict']]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'TagRules':
        """
        Get an existing TagRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TagRulesLogRuleArgs', 'TagRulesLogRuleArgsDict']] log_rule: Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        :param pulumi.Input[Union['TagRulesMetricRuleArgs', 'TagRulesMetricRuleArgsDict']] metric_rule: Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        :param pulumi.Input[_builtins.str] monitor_id: Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagRulesState.__new__(_TagRulesState)

        __props__.__dict__["log_rule"] = log_rule
        __props__.__dict__["metric_rule"] = metric_rule
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["name"] = name
        return TagRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="logRule")
    def log_rule(self) -> pulumi.Output[Optional['outputs.TagRulesLogRule']]:
        """
        Set of rules for sending logs for the Monitor resource. A `log_rule` block as defined below.
        """
        return pulumi.get(self, "log_rule")

    @_builtins.property
    @pulumi.getter(name="metricRule")
    def metric_rule(self) -> pulumi.Output[Optional['outputs.TagRulesMetricRule']]:
        """
        Set of rules for sending metrics for the Monitor resource. A `metric_rule` block as defined below.
        """
        return pulumi.get(self, "metric_rule")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Dynatrace monitor. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Dynatrace tag rules. Currently, the only supported value is `default`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

