# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVolumeGroupResult',
    'AwaitableGetVolumeGroupResult',
    'get_volume_group',
    'get_volume_group_output',
]

@pulumi.output_type
class GetVolumeGroupResult:
    """
    A collection of values returned by getVolumeGroup.
    """
    def __init__(__self__, elastic_san_id=None, encryption_type=None, encryptions=None, id=None, identities=None, name=None, network_rules=None, protocol_type=None):
        if elastic_san_id and not isinstance(elastic_san_id, str):
            raise TypeError("Expected argument 'elastic_san_id' to be a str")
        pulumi.set(__self__, "elastic_san_id", elastic_san_id)
        if encryption_type and not isinstance(encryption_type, str):
            raise TypeError("Expected argument 'encryption_type' to be a str")
        pulumi.set(__self__, "encryption_type", encryption_type)
        if encryptions and not isinstance(encryptions, list):
            raise TypeError("Expected argument 'encryptions' to be a list")
        pulumi.set(__self__, "encryptions", encryptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_rules and not isinstance(network_rules, list):
            raise TypeError("Expected argument 'network_rules' to be a list")
        pulumi.set(__self__, "network_rules", network_rules)
        if protocol_type and not isinstance(protocol_type, str):
            raise TypeError("Expected argument 'protocol_type' to be a str")
        pulumi.set(__self__, "protocol_type", protocol_type)

    @_builtins.property
    @pulumi.getter(name="elasticSanId")
    def elastic_san_id(self) -> _builtins.str:
        return pulumi.get(self, "elastic_san_id")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> _builtins.str:
        """
        The type of the key used to encrypt the data of the disk.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> Sequence['outputs.GetVolumeGroupEncryptionResult']:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryptions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetVolumeGroupIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> Sequence['outputs.GetVolumeGroupNetworkRuleResult']:
        """
        One or more `network_rule` blocks as defined below.
        """
        return pulumi.get(self, "network_rules")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.str:
        """
        The type of the storage target.
        """
        return pulumi.get(self, "protocol_type")


class AwaitableGetVolumeGroupResult(GetVolumeGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeGroupResult(
            elastic_san_id=self.elastic_san_id,
            encryption_type=self.encryption_type,
            encryptions=self.encryptions,
            id=self.id,
            identities=self.identities,
            name=self.name,
            network_rules=self.network_rules,
            protocol_type=self.protocol_type)


def get_volume_group(elastic_san_id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeGroupResult:
    """
    Use this data source to access information about an existing Elastic SAN Volume Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.elasticsan.get(name="existing",
        resource_group_name="existing")
    example_get_volume_group = azure.elasticsan.get_volume_group(name="existing",
        elastic_san_id=example.id)
    pulumi.export("id", example_get_volume_group.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ElasticSan` - 2023-01-01


    :param _builtins.str elastic_san_id: The Elastic SAN ID within which the Elastic SAN Volume Group exists.
    :param _builtins.str name: The name of the Elastic SAN Volume Group.
    """
    __args__ = dict()
    __args__['elasticSanId'] = elastic_san_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:elasticsan/getVolumeGroup:getVolumeGroup', __args__, opts=opts, typ=GetVolumeGroupResult).value

    return AwaitableGetVolumeGroupResult(
        elastic_san_id=pulumi.get(__ret__, 'elastic_san_id'),
        encryption_type=pulumi.get(__ret__, 'encryption_type'),
        encryptions=pulumi.get(__ret__, 'encryptions'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        name=pulumi.get(__ret__, 'name'),
        network_rules=pulumi.get(__ret__, 'network_rules'),
        protocol_type=pulumi.get(__ret__, 'protocol_type'))
def get_volume_group_output(elastic_san_id: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeGroupResult]:
    """
    Use this data source to access information about an existing Elastic SAN Volume Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.elasticsan.get(name="existing",
        resource_group_name="existing")
    example_get_volume_group = azure.elasticsan.get_volume_group(name="existing",
        elastic_san_id=example.id)
    pulumi.export("id", example_get_volume_group.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ElasticSan` - 2023-01-01


    :param _builtins.str elastic_san_id: The Elastic SAN ID within which the Elastic SAN Volume Group exists.
    :param _builtins.str name: The name of the Elastic SAN Volume Group.
    """
    __args__ = dict()
    __args__['elasticSanId'] = elastic_san_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:elasticsan/getVolumeGroup:getVolumeGroup', __args__, opts=opts, typ=GetVolumeGroupResult)
    return __ret__.apply(lambda __response__: GetVolumeGroupResult(
        elastic_san_id=pulumi.get(__response__, 'elastic_san_id'),
        encryption_type=pulumi.get(__response__, 'encryption_type'),
        encryptions=pulumi.get(__response__, 'encryptions'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        name=pulumi.get(__response__, 'name'),
        network_rules=pulumi.get(__response__, 'network_rules'),
        protocol_type=pulumi.get(__response__, 'protocol_type')))
