# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 size_in_gib: pulumi.Input[_builtins.int],
                 volume_group_id: pulumi.Input[_builtins.str],
                 create_source: Optional[pulumi.Input['VolumeCreateSourceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[_builtins.int] size_in_gib: Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).
               
               > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        :param pulumi.Input[_builtins.str] volume_group_id: Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeCreateSourceArgs'] create_source: A `create_source` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "size_in_gib", size_in_gib)
        pulumi.set(__self__, "volume_group_id", volume_group_id)
        if create_source is not None:
            pulumi.set(__self__, "create_source", create_source)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).

        > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        """
        return pulumi.get(self, "size_in_gib")

    @size_in_gib.setter
    def size_in_gib(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size_in_gib", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_group_id")

    @volume_group_id.setter
    def volume_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_group_id", value)

    @_builtins.property
    @pulumi.getter(name="createSource")
    def create_source(self) -> Optional[pulumi.Input['VolumeCreateSourceArgs']]:
        """
        A `create_source` block as defined below.
        """
        return pulumi.get(self, "create_source")

    @create_source.setter
    def create_source(self, value: Optional[pulumi.Input['VolumeCreateSourceArgs']]):
        pulumi.set(self, "create_source", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 create_source: Optional[pulumi.Input['VolumeCreateSourceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 target_iqn: Optional[pulumi.Input[_builtins.str]] = None,
                 target_portal_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 target_portal_port: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input['VolumeCreateSourceArgs'] create_source: A `create_source` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_gib: Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).
               
               > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        :param pulumi.Input[_builtins.str] target_iqn: The iSCSI Target IQN of the Elastic SAN Volume.
        :param pulumi.Input[_builtins.str] target_portal_hostname: The iSCSI Target Portal Host Name of the Elastic SAN Volume.
        :param pulumi.Input[_builtins.int] target_portal_port: The iSCSI Target Portal Port of the Elastic SAN Volume.
        :param pulumi.Input[_builtins.str] volume_group_id: Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_id: The UUID of the Elastic SAN Volume.
        """
        if create_source is not None:
            pulumi.set(__self__, "create_source", create_source)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_in_gib is not None:
            pulumi.set(__self__, "size_in_gib", size_in_gib)
        if target_iqn is not None:
            pulumi.set(__self__, "target_iqn", target_iqn)
        if target_portal_hostname is not None:
            pulumi.set(__self__, "target_portal_hostname", target_portal_hostname)
        if target_portal_port is not None:
            pulumi.set(__self__, "target_portal_port", target_portal_port)
        if volume_group_id is not None:
            pulumi.set(__self__, "volume_group_id", volume_group_id)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="createSource")
    def create_source(self) -> Optional[pulumi.Input['VolumeCreateSourceArgs']]:
        """
        A `create_source` block as defined below.
        """
        return pulumi.get(self, "create_source")

    @create_source.setter
    def create_source(self, value: Optional[pulumi.Input['VolumeCreateSourceArgs']]):
        pulumi.set(self, "create_source", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).

        > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        """
        return pulumi.get(self, "size_in_gib")

    @size_in_gib.setter
    def size_in_gib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_in_gib", value)

    @_builtins.property
    @pulumi.getter(name="targetIqn")
    def target_iqn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The iSCSI Target IQN of the Elastic SAN Volume.
        """
        return pulumi.get(self, "target_iqn")

    @target_iqn.setter
    def target_iqn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_iqn", value)

    @_builtins.property
    @pulumi.getter(name="targetPortalHostname")
    def target_portal_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The iSCSI Target Portal Host Name of the Elastic SAN Volume.
        """
        return pulumi.get(self, "target_portal_hostname")

    @target_portal_hostname.setter
    def target_portal_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_portal_hostname", value)

    @_builtins.property
    @pulumi.getter(name="targetPortalPort")
    def target_portal_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The iSCSI Target Portal Port of the Elastic SAN Volume.
        """
        return pulumi.get(self, "target_portal_port")

    @target_portal_port.setter
    def target_portal_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_portal_port", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_group_id")

    @volume_group_id.setter
    def volume_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_group_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the Elastic SAN Volume.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


@pulumi.type_token("azure:elasticsan/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_source: Optional[pulumi.Input[Union['VolumeCreateSourceArgs', 'VolumeCreateSourceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Elastic SAN Volume resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_elastic_san = azure.elasticsan.ElasticSan("example",
            name="example-es",
            resource_group_name=example.name,
            location=example.location,
            base_size_in_tib=1,
            sku={
                "name": "Premium_LRS",
            })
        example_volume_group = azure.elasticsan.VolumeGroup("example",
            name="example-esvg",
            elastic_san_id=example_elastic_san.id)
        example_volume = azure.elasticsan.Volume("example",
            name="example-esv",
            volume_group_id=example_volume_group.id,
            size_in_gib=1)
        pulumi.export("targetIqn", example_volume.target_iqn)
        ```

        ## Example of creating an Elastic SAN Volume from a Disk Snapshot

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_elastic_san = azure.elasticsan.ElasticSan("example",
            name="example-es",
            resource_group_name=example.name,
            location=example.location,
            base_size_in_tib=1,
            sku={
                "name": "Premium_LRS",
            })
        example_volume_group = azure.elasticsan.VolumeGroup("example",
            name="example-esvg",
            elastic_san_id=example_elastic_san.id)
        example_managed_disk = azure.compute.ManagedDisk("example",
            name="example-disk",
            location=example.location,
            resource_group_name=example.name,
            create_option="Empty",
            storage_account_type="Standard_LRS",
            disk_size_gb=2)
        example_snapshot = azure.compute.Snapshot("example",
            name="example-ss",
            location=example.location,
            resource_group_name=example.name,
            create_option="Copy",
            source_uri=example_managed_disk.id)
        example2 = azure.elasticsan.Volume("example2",
            name="example-esv2",
            volume_group_id=example_volume_group.id,
            size_in_gib=2,
            create_source={
                "source_type": "DiskSnapshot",
                "source_id": example_snapshot.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ElasticSan` - 2023-01-01

        ## Import

        An existing Elastic SAN Volume can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:elasticsan/volume:Volume example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ElasticSan/elasticSans/esan1/volumeGroups/vg1/volumes/vol1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VolumeCreateSourceArgs', 'VolumeCreateSourceArgsDict']] create_source: A `create_source` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_gib: Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).
               
               > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        :param pulumi.Input[_builtins.str] volume_group_id: Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Elastic SAN Volume resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_elastic_san = azure.elasticsan.ElasticSan("example",
            name="example-es",
            resource_group_name=example.name,
            location=example.location,
            base_size_in_tib=1,
            sku={
                "name": "Premium_LRS",
            })
        example_volume_group = azure.elasticsan.VolumeGroup("example",
            name="example-esvg",
            elastic_san_id=example_elastic_san.id)
        example_volume = azure.elasticsan.Volume("example",
            name="example-esv",
            volume_group_id=example_volume_group.id,
            size_in_gib=1)
        pulumi.export("targetIqn", example_volume.target_iqn)
        ```

        ## Example of creating an Elastic SAN Volume from a Disk Snapshot

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_elastic_san = azure.elasticsan.ElasticSan("example",
            name="example-es",
            resource_group_name=example.name,
            location=example.location,
            base_size_in_tib=1,
            sku={
                "name": "Premium_LRS",
            })
        example_volume_group = azure.elasticsan.VolumeGroup("example",
            name="example-esvg",
            elastic_san_id=example_elastic_san.id)
        example_managed_disk = azure.compute.ManagedDisk("example",
            name="example-disk",
            location=example.location,
            resource_group_name=example.name,
            create_option="Empty",
            storage_account_type="Standard_LRS",
            disk_size_gb=2)
        example_snapshot = azure.compute.Snapshot("example",
            name="example-ss",
            location=example.location,
            resource_group_name=example.name,
            create_option="Copy",
            source_uri=example_managed_disk.id)
        example2 = azure.elasticsan.Volume("example2",
            name="example-esv2",
            volume_group_id=example_volume_group.id,
            size_in_gib=2,
            create_source={
                "source_type": "DiskSnapshot",
                "source_id": example_snapshot.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ElasticSan` - 2023-01-01

        ## Import

        An existing Elastic SAN Volume can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:elasticsan/volume:Volume example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ElasticSan/elasticSans/esan1/volumeGroups/vg1/volumes/vol1
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_source: Optional[pulumi.Input[Union['VolumeCreateSourceArgs', 'VolumeCreateSourceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["create_source"] = create_source
            __props__.__dict__["name"] = name
            if size_in_gib is None and not opts.urn:
                raise TypeError("Missing required property 'size_in_gib'")
            __props__.__dict__["size_in_gib"] = size_in_gib
            if volume_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_group_id'")
            __props__.__dict__["volume_group_id"] = volume_group_id
            __props__.__dict__["target_iqn"] = None
            __props__.__dict__["target_portal_hostname"] = None
            __props__.__dict__["target_portal_port"] = None
            __props__.__dict__["volume_id"] = None
        super(Volume, __self__).__init__(
            'azure:elasticsan/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_source: Optional[pulumi.Input[Union['VolumeCreateSourceArgs', 'VolumeCreateSourceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_gib: Optional[pulumi.Input[_builtins.int]] = None,
            target_iqn: Optional[pulumi.Input[_builtins.str]] = None,
            target_portal_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            target_portal_port: Optional[pulumi.Input[_builtins.int]] = None,
            volume_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            volume_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VolumeCreateSourceArgs', 'VolumeCreateSourceArgsDict']] create_source: A `create_source` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] size_in_gib: Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).
               
               > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        :param pulumi.Input[_builtins.str] target_iqn: The iSCSI Target IQN of the Elastic SAN Volume.
        :param pulumi.Input[_builtins.str] target_portal_hostname: The iSCSI Target Portal Host Name of the Elastic SAN Volume.
        :param pulumi.Input[_builtins.int] target_portal_port: The iSCSI Target Portal Port of the Elastic SAN Volume.
        :param pulumi.Input[_builtins.str] volume_group_id: Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_id: The UUID of the Elastic SAN Volume.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["create_source"] = create_source
        __props__.__dict__["name"] = name
        __props__.__dict__["size_in_gib"] = size_in_gib
        __props__.__dict__["target_iqn"] = target_iqn
        __props__.__dict__["target_portal_hostname"] = target_portal_hostname
        __props__.__dict__["target_portal_port"] = target_portal_port
        __props__.__dict__["volume_group_id"] = volume_group_id
        __props__.__dict__["volume_id"] = volume_id
        return Volume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createSource")
    def create_source(self) -> pulumi.Output[Optional['outputs.VolumeCreateSource']]:
        """
        A `create_source` block as defined below.
        """
        return pulumi.get(self, "create_source")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Elastic SAN Volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the size of the Elastic SAN Volume in GiB. The size should be within the remaining capacity of the parent Elastic SAN. Possible values are between `1` and `65536` (16 TiB).

        > **Note:** The size can only be increased. If `create_source` is specified, then the size must be equal to or greater than the source's size.
        """
        return pulumi.get(self, "size_in_gib")

    @_builtins.property
    @pulumi.getter(name="targetIqn")
    def target_iqn(self) -> pulumi.Output[_builtins.str]:
        """
        The iSCSI Target IQN of the Elastic SAN Volume.
        """
        return pulumi.get(self, "target_iqn")

    @_builtins.property
    @pulumi.getter(name="targetPortalHostname")
    def target_portal_hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The iSCSI Target Portal Host Name of the Elastic SAN Volume.
        """
        return pulumi.get(self, "target_portal_hostname")

    @_builtins.property
    @pulumi.getter(name="targetPortalPort")
    def target_portal_port(self) -> pulumi.Output[_builtins.int]:
        """
        The iSCSI Target Portal Port of the Elastic SAN Volume.
        """
        return pulumi.get(self, "target_portal_port")

    @_builtins.property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Volume Group ID within which this Elastic SAN Volume should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_group_id")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the Elastic SAN Volume.
        """
        return pulumi.get(self, "volume_id")

