# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input['NamespaceIdentityArgs']] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_spaces_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        :param pulumi.Input['NamespaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]] topic_spaces_configurations: A `topic_spaces_configuration` block as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inbound_ip_rules is not None:
            pulumi.set(__self__, "inbound_ip_rules", inbound_ip_rules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_spaces_configurations is not None:
            pulumi.set(__self__, "topic_spaces_configurations", topic_spaces_configurations)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['NamespaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['NamespaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]]]:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @inbound_ip_rules.setter
    def inbound_ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]]]):
        pulumi.set(self, "inbound_ip_rules", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topicSpacesConfigurations")
    def topic_spaces_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]]]:
        """
        A `topic_spaces_configuration` block as defined below.
        """
        return pulumi.get(self, "topic_spaces_configurations")

    @topic_spaces_configurations.setter
    def topic_spaces_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]]]):
        pulumi.set(self, "topic_spaces_configurations", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input['NamespaceIdentityArgs']] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_spaces_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        :param pulumi.Input['NamespaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]] topic_spaces_configurations: A `topic_spaces_configuration` block as defined below.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inbound_ip_rules is not None:
            pulumi.set(__self__, "inbound_ip_rules", inbound_ip_rules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_spaces_configurations is not None:
            pulumi.set(__self__, "topic_spaces_configurations", topic_spaces_configurations)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['NamespaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['NamespaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]]]:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @inbound_ip_rules.setter
    def inbound_ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceInboundIpRuleArgs']]]]):
        pulumi.set(self, "inbound_ip_rules", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topicSpacesConfigurations")
    def topic_spaces_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]]]:
        """
        A `topic_spaces_configuration` block as defined below.
        """
        return pulumi.get(self, "topic_spaces_configurations")

    @topic_spaces_configurations.setter
    def topic_spaces_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTopicSpacesConfigurationArgs']]]]):
        pulumi.set(self, "topic_spaces_configurations", value)


@pulumi.type_token("azure:eventgrid/namespace:Namespace")
class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input[Union['NamespaceIdentityArgs', 'NamespaceIdentityArgsDict']]] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceInboundIpRuleArgs', 'NamespaceInboundIpRuleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_spaces_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceTopicSpacesConfigurationArgs', 'NamespaceTopicSpacesConfigurationArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an EventGrid Namespace

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_namespace = azure.eventgrid.Namespace("example",
            name="my-eventgrid-namespace",
            location=example.location,
            resource_group_name=example.name,
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid` - 2023-12-15-preview

        ## Import

        EventGrid Namespace's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/namespace:Namespace namespace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventGrid/namespaces/namespace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        :param pulumi.Input[Union['NamespaceIdentityArgs', 'NamespaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceInboundIpRuleArgs', 'NamespaceInboundIpRuleArgsDict']]]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceTopicSpacesConfigurationArgs', 'NamespaceTopicSpacesConfigurationArgsDict']]]] topic_spaces_configurations: A `topic_spaces_configuration` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EventGrid Namespace

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_namespace = azure.eventgrid.Namespace("example",
            name="my-eventgrid-namespace",
            location=example.location,
            resource_group_name=example.name,
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid` - 2023-12-15-preview

        ## Import

        EventGrid Namespace's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/namespace:Namespace namespace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventGrid/namespaces/namespace1
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input[Union['NamespaceIdentityArgs', 'NamespaceIdentityArgsDict']]] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceInboundIpRuleArgs', 'NamespaceInboundIpRuleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_spaces_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceTopicSpacesConfigurationArgs', 'NamespaceTopicSpacesConfigurationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["identity"] = identity
            __props__.__dict__["inbound_ip_rules"] = inbound_ip_rules
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["topic_spaces_configurations"] = topic_spaces_configurations
        super(Namespace, __self__).__init__(
            'azure:eventgrid/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            identity: Optional[pulumi.Input[Union['NamespaceIdentityArgs', 'NamespaceIdentityArgsDict']]] = None,
            inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceInboundIpRuleArgs', 'NamespaceInboundIpRuleArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            topic_spaces_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceTopicSpacesConfigurationArgs', 'NamespaceTopicSpacesConfigurationArgsDict']]]]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        :param pulumi.Input[Union['NamespaceIdentityArgs', 'NamespaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceInboundIpRuleArgs', 'NamespaceInboundIpRuleArgsDict']]]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceTopicSpacesConfigurationArgs', 'NamespaceTopicSpacesConfigurationArgsDict']]]] topic_spaces_configurations: A `topic_spaces_configuration` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["identity"] = identity
        __props__.__dict__["inbound_ip_rules"] = inbound_ip_rules
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic_spaces_configurations"] = topic_spaces_configurations
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the Capacity / Throughput Units for an Eventgrid Namespace. Valid values can be between `1` and `40`.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.NamespaceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> pulumi.Output[Optional[Sequence['outputs.NamespaceInboundIpRule']]]:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Event Grid Namespace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether or not public network access is allowed for this server. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Event Grid Namespace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines which tier to use. The only possible value is `Standard`. Defaults to `Standard`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="topicSpacesConfigurations")
    def topic_spaces_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.NamespaceTopicSpacesConfiguration']]]:
        """
        A `topic_spaces_configuration` block as defined below.
        """
        return pulumi.get(self, "topic_spaces_configurations")

