# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PartnerNamespaceArgs', 'PartnerNamespace']

@pulumi.input_type
class PartnerNamespaceArgs:
    def __init__(__self__, *,
                 partner_registration_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_topic_routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PartnerNamespace resource.
        :param pulumi.Input[_builtins.str] partner_registration_id: The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_topic_routing_mode: The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        pulumi.set(__self__, "partner_registration_id", partner_registration_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if inbound_ip_rules is not None:
            pulumi.set(__self__, "inbound_ip_rules", inbound_ip_rules)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partner_topic_routing_mode is not None:
            pulumi.set(__self__, "partner_topic_routing_mode", partner_topic_routing_mode)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="partnerRegistrationId")
    def partner_registration_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "partner_registration_id")

    @partner_registration_id.setter
    def partner_registration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "partner_registration_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]]]:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @inbound_ip_rules.setter
    def inbound_ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]]]):
        pulumi.set(self, "inbound_ip_rules", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partnerTopicRoutingMode")
    def partner_topic_routing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "partner_topic_routing_mode")

    @partner_topic_routing_mode.setter
    def partner_topic_routing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_topic_routing_mode", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PartnerNamespaceState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_registration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_topic_routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PartnerNamespace resources.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint for the Event Grid Partner Namespace.
        :param pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_registration_id: The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_topic_routing_mode: The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if inbound_ip_rules is not None:
            pulumi.set(__self__, "inbound_ip_rules", inbound_ip_rules)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partner_registration_id is not None:
            pulumi.set(__self__, "partner_registration_id", partner_registration_id)
        if partner_topic_routing_mode is not None:
            pulumi.set(__self__, "partner_topic_routing_mode", partner_topic_routing_mode)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]]]:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @inbound_ip_rules.setter
    def inbound_ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PartnerNamespaceInboundIpRuleArgs']]]]):
        pulumi.set(self, "inbound_ip_rules", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partnerRegistrationId")
    def partner_registration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "partner_registration_id")

    @partner_registration_id.setter
    def partner_registration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_registration_id", value)

    @_builtins.property
    @pulumi.getter(name="partnerTopicRoutingMode")
    def partner_topic_routing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "partner_topic_routing_mode")

    @partner_topic_routing_mode.setter
    def partner_topic_routing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partner_topic_routing_mode", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:eventgrid/partnerNamespace:PartnerNamespace")
class PartnerNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PartnerNamespaceInboundIpRuleArgs', 'PartnerNamespaceInboundIpRuleArgsDict']]]]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_registration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_topic_routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Event Grid Partner Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_partner_registration = azure.eventgrid.PartnerRegistration("example",
            name="example-partner-registration",
            resource_group_name=example.name)
        example_partner_namespace = azure.eventgrid.PartnerNamespace("example",
            name="example-partner-namespace",
            location=example.location,
            resource_group_name=example.name,
            partner_registration_id=example_partner_registration.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid` - 2025-02-15

        ## Import

        Event Grid Partner Namespaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/partnerNamespace:PartnerNamespace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.EventGrid/partnerNamespaces/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PartnerNamespaceInboundIpRuleArgs', 'PartnerNamespaceInboundIpRuleArgsDict']]]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_registration_id: The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_topic_routing_mode: The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PartnerNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Event Grid Partner Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_partner_registration = azure.eventgrid.PartnerRegistration("example",
            name="example-partner-registration",
            resource_group_name=example.name)
        example_partner_namespace = azure.eventgrid.PartnerNamespace("example",
            name="example-partner-namespace",
            location=example.location,
            resource_group_name=example.name,
            partner_registration_id=example_partner_registration.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventGrid` - 2025-02-15

        ## Import

        Event Grid Partner Namespaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventgrid/partnerNamespace:PartnerNamespace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.EventGrid/partnerNamespaces/example
        ```

        :param str resource_name: The name of the resource.
        :param PartnerNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartnerNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PartnerNamespaceInboundIpRuleArgs', 'PartnerNamespaceInboundIpRuleArgsDict']]]]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_registration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partner_topic_routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartnerNamespaceArgs.__new__(PartnerNamespaceArgs)

            __props__.__dict__["inbound_ip_rules"] = inbound_ip_rules
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if partner_registration_id is None and not opts.urn:
                raise TypeError("Missing required property 'partner_registration_id'")
            __props__.__dict__["partner_registration_id"] = partner_registration_id
            __props__.__dict__["partner_topic_routing_mode"] = partner_topic_routing_mode
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["endpoint"] = None
        super(PartnerNamespace, __self__).__init__(
            'azure:eventgrid/partnerNamespace:PartnerNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            inbound_ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PartnerNamespaceInboundIpRuleArgs', 'PartnerNamespaceInboundIpRuleArgsDict']]]]] = None,
            local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partner_registration_id: Optional[pulumi.Input[_builtins.str]] = None,
            partner_topic_routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'PartnerNamespace':
        """
        Get an existing PartnerNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint for the Event Grid Partner Namespace.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PartnerNamespaceInboundIpRuleArgs', 'PartnerNamespaceInboundIpRuleArgsDict']]]] inbound_ip_rules: One or more `inbound_ip_rule` blocks as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_registration_id: The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] partner_topic_routing_mode: The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PartnerNamespaceState.__new__(_PartnerNamespaceState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["inbound_ip_rules"] = inbound_ip_rules
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["partner_registration_id"] = partner_registration_id
        __props__.__dict__["partner_topic_routing_mode"] = partner_topic_routing_mode
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return PartnerNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint for the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="inboundIpRules")
    def inbound_ip_rules(self) -> pulumi.Output[Optional[Sequence['outputs.PartnerNamespaceInboundIpRule']]]:
        """
        One or more `inbound_ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "inbound_ip_rules")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether local authentication methods are enabled for the Event Grid Partner Namespace. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Event Grid Partner Namespace exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Event Grid Partner Namespace. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partnerRegistrationId")
    def partner_registration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource Id of the Event Grid Partner Registration that this namespace is associated with. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "partner_registration_id")

    @_builtins.property
    @pulumi.getter(name="partnerTopicRoutingMode")
    def partner_topic_routing_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The partner topic routing mode. Possible values are `ChannelNameHeader` and `SourceEventAttribute`. Defaults to `ChannelNameHeader`. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "partner_topic_routing_mode")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether or not public network access is allowed for this server. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Event Grid Partner Namespace should exist. Changing this forces a new Event Grid Partner Namespace to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Event Grid Partner Namespace.
        """
        return pulumi.get(self, "tags")

