# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventHubNamespaceArgs', 'EventHubNamespace']

@pulumi.input_type
class EventHubNamespaceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 auto_inflate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['EventHubNamespaceIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_throughput_units: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rulesets: Optional[pulumi.Input['EventHubNamespaceNetworkRulesetsArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a EventHubNamespace resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        :param pulumi.Input[_builtins.bool] auto_inflate_enabled: Is Auto Inflate enabled for the EventHub Namespace?
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        :param pulumi.Input['EventHubNamespaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_throughput_units: Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input['EventHubNamespaceNetworkRulesetsArgs'] network_rulesets: A `network_rulesets` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if auto_inflate_enabled is not None:
            pulumi.set(__self__, "auto_inflate_enabled", auto_inflate_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dedicated_cluster_id is not None:
            pulumi.set(__self__, "dedicated_cluster_id", dedicated_cluster_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_throughput_units is not None:
            pulumi.set(__self__, "maximum_throughput_units", maximum_throughput_units)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rulesets is not None:
            pulumi.set(__self__, "network_rulesets", network_rulesets)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="autoInflateEnabled")
    def auto_inflate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Auto Inflate enabled for the EventHub Namespace?
        """
        return pulumi.get(self, "auto_inflate_enabled")

    @auto_inflate_enabled.setter
    def auto_inflate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_inflate_enabled", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @dedicated_cluster_id.setter
    def dedicated_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EventHubNamespaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EventHubNamespaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumThroughputUnits")
    def maximum_throughput_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        """
        return pulumi.get(self, "maximum_throughput_units")

    @maximum_throughput_units.setter
    def maximum_throughput_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_throughput_units", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkRulesets")
    def network_rulesets(self) -> Optional[pulumi.Input['EventHubNamespaceNetworkRulesetsArgs']]:
        """
        A `network_rulesets` block as defined below.
        """
        return pulumi.get(self, "network_rulesets")

    @network_rulesets.setter
    def network_rulesets(self, value: Optional[pulumi.Input['EventHubNamespaceNetworkRulesetsArgs']]):
        pulumi.set(self, "network_rulesets", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EventHubNamespaceState:
    def __init__(__self__, *,
                 auto_inflate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 default_primary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 default_primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 default_secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 default_secondary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 default_secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['EventHubNamespaceIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_throughput_units: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rulesets: Optional[pulumi.Input['EventHubNamespaceNetworkRulesetsArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering EventHubNamespace resources.
        :param pulumi.Input[_builtins.bool] auto_inflate_enabled: Is Auto Inflate enabled for the EventHub Namespace?
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_primary_connection_string: The primary connection string for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] default_primary_connection_string_alias: The alias of the primary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        :param pulumi.Input[_builtins.str] default_primary_key: The primary access key for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] default_secondary_connection_string: The secondary connection string for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] default_secondary_connection_string_alias: The alias of the secondary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        :param pulumi.Input[_builtins.str] default_secondary_key: The secondary access key for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input['EventHubNamespaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_throughput_units: Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input['EventHubNamespaceNetworkRulesetsArgs'] network_rulesets: A `network_rulesets` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if auto_inflate_enabled is not None:
            pulumi.set(__self__, "auto_inflate_enabled", auto_inflate_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dedicated_cluster_id is not None:
            pulumi.set(__self__, "dedicated_cluster_id", dedicated_cluster_id)
        if default_primary_connection_string is not None:
            pulumi.set(__self__, "default_primary_connection_string", default_primary_connection_string)
        if default_primary_connection_string_alias is not None:
            pulumi.set(__self__, "default_primary_connection_string_alias", default_primary_connection_string_alias)
        if default_primary_key is not None:
            pulumi.set(__self__, "default_primary_key", default_primary_key)
        if default_secondary_connection_string is not None:
            pulumi.set(__self__, "default_secondary_connection_string", default_secondary_connection_string)
        if default_secondary_connection_string_alias is not None:
            pulumi.set(__self__, "default_secondary_connection_string_alias", default_secondary_connection_string_alias)
        if default_secondary_key is not None:
            pulumi.set(__self__, "default_secondary_key", default_secondary_key)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_throughput_units is not None:
            pulumi.set(__self__, "maximum_throughput_units", maximum_throughput_units)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rulesets is not None:
            pulumi.set(__self__, "network_rulesets", network_rulesets)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoInflateEnabled")
    def auto_inflate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Auto Inflate enabled for the EventHub Namespace?
        """
        return pulumi.get(self, "auto_inflate_enabled")

    @auto_inflate_enabled.setter
    def auto_inflate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_inflate_enabled", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @dedicated_cluster_id.setter
    def dedicated_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrimaryConnectionString")
    def default_primary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary connection string for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_primary_connection_string")

    @default_primary_connection_string.setter
    def default_primary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_primary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrimaryConnectionStringAlias")
    def default_primary_connection_string_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of the primary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        """
        return pulumi.get(self, "default_primary_connection_string_alias")

    @default_primary_connection_string_alias.setter
    def default_primary_connection_string_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_primary_connection_string_alias", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrimaryKey")
    def default_primary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary access key for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_primary_key")

    @default_primary_key.setter
    def default_primary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_primary_key", value)

    @_builtins.property
    @pulumi.getter(name="defaultSecondaryConnectionString")
    def default_secondary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary connection string for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_secondary_connection_string")

    @default_secondary_connection_string.setter
    def default_secondary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_secondary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="defaultSecondaryConnectionStringAlias")
    def default_secondary_connection_string_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of the secondary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        """
        return pulumi.get(self, "default_secondary_connection_string_alias")

    @default_secondary_connection_string_alias.setter
    def default_secondary_connection_string_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_secondary_connection_string_alias", value)

    @_builtins.property
    @pulumi.getter(name="defaultSecondaryKey")
    def default_secondary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary access key for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_secondary_key")

    @default_secondary_key.setter
    def default_secondary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_secondary_key", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EventHubNamespaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EventHubNamespaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumThroughputUnits")
    def maximum_throughput_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        """
        return pulumi.get(self, "maximum_throughput_units")

    @maximum_throughput_units.setter
    def maximum_throughput_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_throughput_units", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkRulesets")
    def network_rulesets(self) -> Optional[pulumi.Input['EventHubNamespaceNetworkRulesetsArgs']]:
        """
        A `network_rulesets` block as defined below.
        """
        return pulumi.get(self, "network_rulesets")

    @network_rulesets.setter
    def network_rulesets(self, value: Optional[pulumi.Input['EventHubNamespaceNetworkRulesetsArgs']]):
        pulumi.set(self, "network_rulesets", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:eventhub/eventHubNamespace:EventHubNamespace")
class EventHubNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_inflate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['EventHubNamespaceIdentityArgs', 'EventHubNamespaceIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_throughput_units: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rulesets: Optional[pulumi.Input[Union['EventHubNamespaceNetworkRulesetsArgs', 'EventHubNamespaceNetworkRulesetsArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an EventHub Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            capacity=2,
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventHub` - 2024-01-01

        ## Import

        EventHub Namespaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/eventHubNamespace:EventHubNamespace namespace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventHub/namespaces/namespace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_inflate_enabled: Is Auto Inflate enabled for the EventHub Namespace?
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EventHubNamespaceIdentityArgs', 'EventHubNamespaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_throughput_units: Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EventHubNamespaceNetworkRulesetsArgs', 'EventHubNamespaceNetworkRulesetsArgsDict']] network_rulesets: A `network_rulesets` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventHubNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EventHub Namespace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-namespace",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            capacity=2,
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.EventHub` - 2024-01-01

        ## Import

        EventHub Namespaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:eventhub/eventHubNamespace:EventHubNamespace namespace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.EventHub/namespaces/namespace1
        ```

        :param str resource_name: The name of the resource.
        :param EventHubNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventHubNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_inflate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['EventHubNamespaceIdentityArgs', 'EventHubNamespaceIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_throughput_units: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_rulesets: Optional[pulumi.Input[Union['EventHubNamespaceNetworkRulesetsArgs', 'EventHubNamespaceNetworkRulesetsArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventHubNamespaceArgs.__new__(EventHubNamespaceArgs)

            __props__.__dict__["auto_inflate_enabled"] = auto_inflate_enabled
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["dedicated_cluster_id"] = dedicated_cluster_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_throughput_units"] = maximum_throughput_units
            __props__.__dict__["minimum_tls_version"] = minimum_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["network_rulesets"] = network_rulesets
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["default_primary_connection_string"] = None
            __props__.__dict__["default_primary_connection_string_alias"] = None
            __props__.__dict__["default_primary_key"] = None
            __props__.__dict__["default_secondary_connection_string"] = None
            __props__.__dict__["default_secondary_connection_string_alias"] = None
            __props__.__dict__["default_secondary_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["defaultPrimaryConnectionString", "defaultPrimaryConnectionStringAlias", "defaultPrimaryKey", "defaultSecondaryConnectionString", "defaultSecondaryConnectionStringAlias", "defaultSecondaryKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EventHubNamespace, __self__).__init__(
            'azure:eventhub/eventHubNamespace:EventHubNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_inflate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            default_primary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
            default_primary_key: Optional[pulumi.Input[_builtins.str]] = None,
            default_secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            default_secondary_connection_string_alias: Optional[pulumi.Input[_builtins.str]] = None,
            default_secondary_key: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['EventHubNamespaceIdentityArgs', 'EventHubNamespaceIdentityArgsDict']]] = None,
            local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_throughput_units: Optional[pulumi.Input[_builtins.int]] = None,
            minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_rulesets: Optional[pulumi.Input[Union['EventHubNamespaceNetworkRulesetsArgs', 'EventHubNamespaceNetworkRulesetsArgsDict']]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'EventHubNamespace':
        """
        Get an existing EventHubNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_inflate_enabled: Is Auto Inflate enabled for the EventHub Namespace?
        :param pulumi.Input[_builtins.int] capacity: Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_primary_connection_string: The primary connection string for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] default_primary_connection_string_alias: The alias of the primary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        :param pulumi.Input[_builtins.str] default_primary_key: The primary access key for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] default_secondary_connection_string: The secondary connection string for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[_builtins.str] default_secondary_connection_string_alias: The alias of the secondary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        :param pulumi.Input[_builtins.str] default_secondary_key: The secondary access key for the authorization rule `RootManageSharedAccessKey`.
        :param pulumi.Input[Union['EventHubNamespaceIdentityArgs', 'EventHubNamespaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_throughput_units: Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['EventHubNamespaceNetworkRulesetsArgs', 'EventHubNamespaceNetworkRulesetsArgsDict']] network_rulesets: A `network_rulesets` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventHubNamespaceState.__new__(_EventHubNamespaceState)

        __props__.__dict__["auto_inflate_enabled"] = auto_inflate_enabled
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["dedicated_cluster_id"] = dedicated_cluster_id
        __props__.__dict__["default_primary_connection_string"] = default_primary_connection_string
        __props__.__dict__["default_primary_connection_string_alias"] = default_primary_connection_string_alias
        __props__.__dict__["default_primary_key"] = default_primary_key
        __props__.__dict__["default_secondary_connection_string"] = default_secondary_connection_string
        __props__.__dict__["default_secondary_connection_string_alias"] = default_secondary_connection_string_alias
        __props__.__dict__["default_secondary_key"] = default_secondary_key
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["maximum_throughput_units"] = maximum_throughput_units
        __props__.__dict__["minimum_tls_version"] = minimum_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["network_rulesets"] = network_rulesets
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        return EventHubNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoInflateEnabled")
    def auto_inflate_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Auto Inflate enabled for the EventHub Namespace?
        """
        return pulumi.get(self, "auto_inflate_enabled")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the Capacity / Throughput Units for a `Standard` SKU namespace. Default capacity has a maximum of `2`, but can be increased in blocks of 2 on a committed purchase basis. Defaults to `1`.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the EventHub Dedicated Cluster where this Namespace should created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @_builtins.property
    @pulumi.getter(name="defaultPrimaryConnectionString")
    def default_primary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The primary connection string for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="defaultPrimaryConnectionStringAlias")
    def default_primary_connection_string_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The alias of the primary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        """
        return pulumi.get(self, "default_primary_connection_string_alias")

    @_builtins.property
    @pulumi.getter(name="defaultPrimaryKey")
    def default_primary_key(self) -> pulumi.Output[_builtins.str]:
        """
        The primary access key for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_primary_key")

    @_builtins.property
    @pulumi.getter(name="defaultSecondaryConnectionString")
    def default_secondary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary connection string for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="defaultSecondaryConnectionStringAlias")
    def default_secondary_connection_string_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The alias of the secondary connection string for the authorization rule `RootManageSharedAccessKey`, which is generated when disaster recovery is enabled.
        """
        return pulumi.get(self, "default_secondary_connection_string_alias")

    @_builtins.property
    @pulumi.getter(name="defaultSecondaryKey")
    def default_secondary_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary access key for the authorization rule `RootManageSharedAccessKey`.
        """
        return pulumi.get(self, "default_secondary_key")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.EventHubNamespaceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is SAS authentication enabled for the EventHub Namespace? Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumThroughputUnits")
    def maximum_throughput_units(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of throughput units when Auto Inflate is Enabled. Valid values range from `1` - `40`.
        """
        return pulumi.get(self, "maximum_throughput_units")

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimum supported TLS version for this EventHub Namespace. Valid values are: `1.0`, `1.1` and `1.2`. Defaults to `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the EventHub Namespace resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkRulesets")
    def network_rulesets(self) -> pulumi.Output['outputs.EventHubNamespaceNetworkRulesets']:
        """
        A `network_rulesets` block as defined below.
        """
        return pulumi.get(self, "network_rulesets")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is public network access enabled for the EventHub Namespace? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the namespace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        Defines which tier to use. Valid options are `Basic`, `Standard`, and `Premium`. Please note that setting this field to `Premium` will force the creation of a new resource.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

