# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CustomHttpsConfigurationCustomHttpsConfiguration',
    'FirewallPolicyCustomRule',
    'FirewallPolicyCustomRuleMatchCondition',
    'FirewallPolicyManagedRule',
    'FirewallPolicyManagedRuleExclusion',
    'FirewallPolicyManagedRuleOverride',
    'FirewallPolicyManagedRuleOverrideExclusion',
    'FirewallPolicyManagedRuleOverrideRule',
    'FirewallPolicyManagedRuleOverrideRuleExclusion',
    'FrontdoorBackendPool',
    'FrontdoorBackendPoolBackend',
    'FrontdoorBackendPoolHealthProbe',
    'FrontdoorBackendPoolLoadBalancing',
    'FrontdoorBackendPoolSetting',
    'FrontdoorExplicitResourceOrder',
    'FrontdoorFrontendEndpoint',
    'FrontdoorRoutingRule',
    'FrontdoorRoutingRuleForwardingConfiguration',
    'FrontdoorRoutingRuleRedirectConfiguration',
    'RulesEngineRule',
    'RulesEngineRuleAction',
    'RulesEngineRuleActionRequestHeader',
    'RulesEngineRuleActionResponseHeader',
    'RulesEngineRuleMatchCondition',
]

@pulumi.output_type
class CustomHttpsConfigurationCustomHttpsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureKeyVaultCertificateSecretName":
            suggest = "azure_key_vault_certificate_secret_name"
        elif key == "azureKeyVaultCertificateSecretVersion":
            suggest = "azure_key_vault_certificate_secret_version"
        elif key == "azureKeyVaultCertificateVaultId":
            suggest = "azure_key_vault_certificate_vault_id"
        elif key == "certificateSource":
            suggest = "certificate_source"
        elif key == "minimumTlsVersion":
            suggest = "minimum_tls_version"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "provisioningSubstate":
            suggest = "provisioning_substate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomHttpsConfigurationCustomHttpsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomHttpsConfigurationCustomHttpsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomHttpsConfigurationCustomHttpsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_key_vault_certificate_secret_name: Optional[_builtins.str] = None,
                 azure_key_vault_certificate_secret_version: Optional[_builtins.str] = None,
                 azure_key_vault_certificate_vault_id: Optional[_builtins.str] = None,
                 certificate_source: Optional[_builtins.str] = None,
                 minimum_tls_version: Optional[_builtins.str] = None,
                 provisioning_state: Optional[_builtins.str] = None,
                 provisioning_substate: Optional[_builtins.str] = None):
        """
        :param _builtins.str azure_key_vault_certificate_secret_name: The name of the Key Vault secret representing the full certificate PFX.
        :param _builtins.str azure_key_vault_certificate_secret_version: The version of the Key Vault secret representing the full certificate PFX.
               
               > **Note:** In order to enable the use of your own custom `HTTPS certificate` you must grant `Azure Front Door Service` access to your key vault. For instructions on how to configure your `Key Vault` correctly please refer to the [product documentation](https://docs.microsoft.com/azure/frontdoor/front-door-custom-domain-https#option-2-use-your-own-certificate).
        :param _builtins.str azure_key_vault_certificate_vault_id: The ID of the Key Vault containing the SSL certificate.
        :param _builtins.str certificate_source: Certificate source to encrypted `HTTPS` traffic with. Allowed values are `FrontDoor` or `AzureKeyVault`. Defaults to `FrontDoor`.
               
               The following attributes are only valid if `certificate_source` is set to `AzureKeyVault`:
        :param _builtins.str minimum_tls_version: Minimum client TLS version supported.
        """
        if azure_key_vault_certificate_secret_name is not None:
            pulumi.set(__self__, "azure_key_vault_certificate_secret_name", azure_key_vault_certificate_secret_name)
        if azure_key_vault_certificate_secret_version is not None:
            pulumi.set(__self__, "azure_key_vault_certificate_secret_version", azure_key_vault_certificate_secret_version)
        if azure_key_vault_certificate_vault_id is not None:
            pulumi.set(__self__, "azure_key_vault_certificate_vault_id", azure_key_vault_certificate_vault_id)
        if certificate_source is not None:
            pulumi.set(__self__, "certificate_source", certificate_source)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if provisioning_substate is not None:
            pulumi.set(__self__, "provisioning_substate", provisioning_substate)

    @_builtins.property
    @pulumi.getter(name="azureKeyVaultCertificateSecretName")
    def azure_key_vault_certificate_secret_name(self) -> Optional[_builtins.str]:
        """
        The name of the Key Vault secret representing the full certificate PFX.
        """
        return pulumi.get(self, "azure_key_vault_certificate_secret_name")

    @_builtins.property
    @pulumi.getter(name="azureKeyVaultCertificateSecretVersion")
    def azure_key_vault_certificate_secret_version(self) -> Optional[_builtins.str]:
        """
        The version of the Key Vault secret representing the full certificate PFX.

        > **Note:** In order to enable the use of your own custom `HTTPS certificate` you must grant `Azure Front Door Service` access to your key vault. For instructions on how to configure your `Key Vault` correctly please refer to the [product documentation](https://docs.microsoft.com/azure/frontdoor/front-door-custom-domain-https#option-2-use-your-own-certificate).
        """
        return pulumi.get(self, "azure_key_vault_certificate_secret_version")

    @_builtins.property
    @pulumi.getter(name="azureKeyVaultCertificateVaultId")
    def azure_key_vault_certificate_vault_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Key Vault containing the SSL certificate.
        """
        return pulumi.get(self, "azure_key_vault_certificate_vault_id")

    @_builtins.property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> Optional[_builtins.str]:
        """
        Certificate source to encrypted `HTTPS` traffic with. Allowed values are `FrontDoor` or `AzureKeyVault`. Defaults to `FrontDoor`.

        The following attributes are only valid if `certificate_source` is set to `AzureKeyVault`:
        """
        return pulumi.get(self, "certificate_source")

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[_builtins.str]:
        """
        Minimum client TLS version supported.
        """
        return pulumi.get(self, "minimum_tls_version")

    @_builtins.property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "provisioning_state")

    @_builtins.property
    @pulumi.getter(name="provisioningSubstate")
    def provisioning_substate(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "provisioning_substate")


@pulumi.output_type
class FirewallPolicyCustomRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"
        elif key == "rateLimitDurationInMinutes":
            suggest = "rate_limit_duration_in_minutes"
        elif key == "rateLimitThreshold":
            suggest = "rate_limit_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyCustomRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyCustomRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyCustomRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 match_conditions: Optional[Sequence['outputs.FirewallPolicyCustomRuleMatchCondition']] = None,
                 priority: Optional[_builtins.int] = None,
                 rate_limit_duration_in_minutes: Optional[_builtins.int] = None,
                 rate_limit_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.str action: The action to perform when the rule is matched. Possible values are `Allow`, `Block`, `Log`, or `Redirect`.
        :param _builtins.str name: Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        :param _builtins.str type: The type of rule. Possible values are `MatchRule` or `RateLimitRule`.
        :param _builtins.bool enabled: Is the rule is enabled or disabled? Defaults to `true`.
        :param Sequence['FirewallPolicyCustomRuleMatchConditionArgs'] match_conditions: One or more `match_condition` block defined below. Can support up to `10` `match_condition` blocks.
        :param _builtins.int priority: The priority of the rule. Rules with a lower value will be evaluated before rules with a higher value. Defaults to `1`.
        :param _builtins.int rate_limit_duration_in_minutes: The rate limit duration in minutes. Defaults to `1`.
        :param _builtins.int rate_limit_threshold: The rate limit threshold. Defaults to `10`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rate_limit_duration_in_minutes is not None:
            pulumi.set(__self__, "rate_limit_duration_in_minutes", rate_limit_duration_in_minutes)
        if rate_limit_threshold is not None:
            pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to perform when the rule is matched. Possible values are `Allow`, `Block`, `Log`, or `Redirect`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of rule. Possible values are `MatchRule` or `RateLimitRule`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Is the rule is enabled or disabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.FirewallPolicyCustomRuleMatchCondition']]:
        """
        One or more `match_condition` block defined below. Can support up to `10` `match_condition` blocks.
        """
        return pulumi.get(self, "match_conditions")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority of the rule. Rules with a lower value will be evaluated before rules with a higher value. Defaults to `1`.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="rateLimitDurationInMinutes")
    def rate_limit_duration_in_minutes(self) -> Optional[_builtins.int]:
        """
        The rate limit duration in minutes. Defaults to `1`.
        """
        return pulumi.get(self, "rate_limit_duration_in_minutes")

    @_builtins.property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> Optional[_builtins.int]:
        """
        The rate limit threshold. Defaults to `10`.
        """
        return pulumi.get(self, "rate_limit_threshold")


@pulumi.output_type
class FirewallPolicyCustomRuleMatchCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchValues":
            suggest = "match_values"
        elif key == "matchVariable":
            suggest = "match_variable"
        elif key == "negationCondition":
            suggest = "negation_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyCustomRuleMatchCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyCustomRuleMatchCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyCustomRuleMatchCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_values: Sequence[_builtins.str],
                 match_variable: _builtins.str,
                 operator: _builtins.str,
                 negation_condition: Optional[_builtins.bool] = None,
                 selector: Optional[_builtins.str] = None,
                 transforms: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] match_values: Up to `600` possible values to match. Limit is in total across all `match_condition` blocks and `match_values` arguments. String value itself can be up to `256` characters long.
        :param _builtins.str match_variable: The request variable to compare with. Possible values are `Cookies`, `PostArgs`, `QueryString`, `RemoteAddr`, `RequestBody`, `RequestHeader`, `RequestMethod`, `RequestUri`, or `SocketAddr`.
        :param _builtins.str operator: Comparison type to use for matching with the variable value. Possible values are `Any`, `BeginsWith`, `Contains`, `EndsWith`, `Equal`, `GeoMatch`, `GreaterThan`, `GreaterThanOrEqual`, `IPMatch`, `LessThan`, `LessThanOrEqual` or `RegEx`.
        :param _builtins.bool negation_condition: Should the result of the condition be negated.
        :param _builtins.str selector: Match against a specific key if the `match_variable` is `QueryString`, `PostArgs`, `RequestHeader` or `Cookies`.
        :param Sequence[_builtins.str] transforms: Up to `5` transforms to apply. Possible values are `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `URLDecode` or`URLEncode`.
        """
        pulumi.set(__self__, "match_values", match_values)
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        if negation_condition is not None:
            pulumi.set(__self__, "negation_condition", negation_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @_builtins.property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Sequence[_builtins.str]:
        """
        Up to `600` possible values to match. Limit is in total across all `match_condition` blocks and `match_values` arguments. String value itself can be up to `256` characters long.
        """
        return pulumi.get(self, "match_values")

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> _builtins.str:
        """
        The request variable to compare with. Possible values are `Cookies`, `PostArgs`, `QueryString`, `RemoteAddr`, `RequestBody`, `RequestHeader`, `RequestMethod`, `RequestUri`, or `SocketAddr`.
        """
        return pulumi.get(self, "match_variable")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Comparison type to use for matching with the variable value. Possible values are `Any`, `BeginsWith`, `Contains`, `EndsWith`, `Equal`, `GeoMatch`, `GreaterThan`, `GreaterThanOrEqual`, `IPMatch`, `LessThan`, `LessThanOrEqual` or `RegEx`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="negationCondition")
    def negation_condition(self) -> Optional[_builtins.bool]:
        """
        Should the result of the condition be negated.
        """
        return pulumi.get(self, "negation_condition")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[_builtins.str]:
        """
        Match against a specific key if the `match_variable` is `QueryString`, `PostArgs`, `RequestHeader` or `Cookies`.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[_builtins.str]]:
        """
        Up to `5` transforms to apply. Possible values are `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `URLDecode` or`URLEncode`.
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class FirewallPolicyManagedRule(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 version: _builtins.str,
                 exclusions: Optional[Sequence['outputs.FirewallPolicyManagedRuleExclusion']] = None,
                 overrides: Optional[Sequence['outputs.FirewallPolicyManagedRuleOverride']] = None):
        """
        :param _builtins.str type: The name of the managed rule to use with this resource.
        :param _builtins.str version: The version on the managed rule to use with this resource.
        :param Sequence['FirewallPolicyManagedRuleExclusionArgs'] exclusions: One or more `exclusion` blocks as defined below.
        :param Sequence['FirewallPolicyManagedRuleOverrideArgs'] overrides: One or more `override` blocks as defined below.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The name of the managed rule to use with this resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version on the managed rule to use with this resource.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.FirewallPolicyManagedRuleExclusion']]:
        """
        One or more `exclusion` blocks as defined below.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Optional[Sequence['outputs.FirewallPolicyManagedRuleOverride']]:
        """
        One or more `override` blocks as defined below.
        """
        return pulumi.get(self, "overrides")


@pulumi.output_type
class FirewallPolicyManagedRuleExclusion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyManagedRuleExclusion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyManagedRuleExclusion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyManagedRuleExclusion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: _builtins.str,
                 operator: _builtins.str,
                 selector: _builtins.str):
        """
        :param _builtins.str match_variable: The variable type to be excluded. Possible values are `QueryStringArgNames`, `RequestBodyPostArgNames`, `RequestCookieNames`, `RequestHeaderNames`.
        :param _builtins.str operator: Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. Possible values are: `Equals`, `Contains`, `StartsWith`, `EndsWith`, `EqualsAny`.
        :param _builtins.str selector: Selector for the value in the `match_variable` attribute this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> _builtins.str:
        """
        The variable type to be excluded. Possible values are `QueryStringArgNames`, `RequestBodyPostArgNames`, `RequestCookieNames`, `RequestHeaderNames`.
        """
        return pulumi.get(self, "match_variable")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. Possible values are: `Equals`, `Contains`, `StartsWith`, `EndsWith`, `EqualsAny`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> _builtins.str:
        """
        Selector for the value in the `match_variable` attribute this exclusion applies to.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class FirewallPolicyManagedRuleOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyManagedRuleOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyManagedRuleOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyManagedRuleOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: _builtins.str,
                 exclusions: Optional[Sequence['outputs.FirewallPolicyManagedRuleOverrideExclusion']] = None,
                 rules: Optional[Sequence['outputs.FirewallPolicyManagedRuleOverrideRule']] = None):
        """
        :param _builtins.str rule_group_name: The managed rule group to override.
        :param Sequence['FirewallPolicyManagedRuleOverrideExclusionArgs'] exclusions: One or more `exclusion` blocks as defined below.
        :param Sequence['FirewallPolicyManagedRuleOverrideRuleArgs'] rules: One or more `rule` blocks as defined below. If none are specified, all of the rules in the group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> _builtins.str:
        """
        The managed rule group to override.
        """
        return pulumi.get(self, "rule_group_name")

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.FirewallPolicyManagedRuleOverrideExclusion']]:
        """
        One or more `exclusion` blocks as defined below.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.FirewallPolicyManagedRuleOverrideRule']]:
        """
        One or more `rule` blocks as defined below. If none are specified, all of the rules in the group will be disabled.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class FirewallPolicyManagedRuleOverrideExclusion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyManagedRuleOverrideExclusion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyManagedRuleOverrideExclusion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyManagedRuleOverrideExclusion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: _builtins.str,
                 operator: _builtins.str,
                 selector: _builtins.str):
        """
        :param _builtins.str match_variable: The variable type to be excluded. Possible values are `QueryStringArgNames`, `RequestBodyPostArgNames`, `RequestCookieNames`, `RequestHeaderNames`.
        :param _builtins.str operator: Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. Possible values are: `Equals`, `Contains`, `StartsWith`, `EndsWith`, `EqualsAny`.
        :param _builtins.str selector: Selector for the value in the `match_variable` attribute this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> _builtins.str:
        """
        The variable type to be excluded. Possible values are `QueryStringArgNames`, `RequestBodyPostArgNames`, `RequestCookieNames`, `RequestHeaderNames`.
        """
        return pulumi.get(self, "match_variable")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. Possible values are: `Equals`, `Contains`, `StartsWith`, `EndsWith`, `EqualsAny`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> _builtins.str:
        """
        Selector for the value in the `match_variable` attribute this exclusion applies to.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class FirewallPolicyManagedRuleOverrideRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyManagedRuleOverrideRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyManagedRuleOverrideRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyManagedRuleOverrideRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 rule_id: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 exclusions: Optional[Sequence['outputs.FirewallPolicyManagedRuleOverrideRuleExclusion']] = None):
        """
        :param _builtins.str action: The action to be applied when the rule matches. Possible values are `Allow`, `Block`, `Log`, or `Redirect`.
        :param _builtins.str rule_id: Identifier for the managed rule.
        :param _builtins.bool enabled: Is the managed rule override enabled or disabled. Defaults to `false`
        :param Sequence['FirewallPolicyManagedRuleOverrideRuleExclusionArgs'] exclusions: One or more `exclusion` blocks as defined below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "rule_id", rule_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to be applied when the rule matches. Possible values are `Allow`, `Block`, `Log`, or `Redirect`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Is the managed rule override enabled or disabled. Defaults to `false`
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.FirewallPolicyManagedRuleOverrideRuleExclusion']]:
        """
        One or more `exclusion` blocks as defined below.
        """
        return pulumi.get(self, "exclusions")


@pulumi.output_type
class FirewallPolicyManagedRuleOverrideRuleExclusion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyManagedRuleOverrideRuleExclusion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyManagedRuleOverrideRuleExclusion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyManagedRuleOverrideRuleExclusion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: _builtins.str,
                 operator: _builtins.str,
                 selector: _builtins.str):
        """
        :param _builtins.str match_variable: The variable type to be excluded. Possible values are `QueryStringArgNames`, `RequestBodyPostArgNames`, `RequestCookieNames`, `RequestHeaderNames`.
        :param _builtins.str operator: Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. Possible values are: `Equals`, `Contains`, `StartsWith`, `EndsWith`, `EqualsAny`.
        :param _builtins.str selector: Selector for the value in the `match_variable` attribute this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> _builtins.str:
        """
        The variable type to be excluded. Possible values are `QueryStringArgNames`, `RequestBodyPostArgNames`, `RequestCookieNames`, `RequestHeaderNames`.
        """
        return pulumi.get(self, "match_variable")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to. Possible values are: `Equals`, `Contains`, `StartsWith`, `EndsWith`, `EqualsAny`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> _builtins.str:
        """
        Selector for the value in the `match_variable` attribute this exclusion applies to.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class FrontdoorBackendPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthProbeName":
            suggest = "health_probe_name"
        elif key == "loadBalancingName":
            suggest = "load_balancing_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorBackendPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorBackendPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorBackendPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backends: Sequence['outputs.FrontdoorBackendPoolBackend'],
                 health_probe_name: _builtins.str,
                 load_balancing_name: _builtins.str,
                 name: _builtins.str,
                 id: Optional[_builtins.str] = None):
        """
        :param Sequence['FrontdoorBackendPoolBackendArgs'] backends: A `backend` block as defined below.
        :param _builtins.str health_probe_name: Specifies the name of the `backend_pool_health_probe` block within this resource to use for this `Backend Pool`.
        :param _builtins.str load_balancing_name: Specifies the name of the `backend_pool_load_balancing` block within this resource to use for this `Backend Pool`.
        :param _builtins.str name: Specifies the name of the Backend Pool.
        :param _builtins.str id: The ID of the FrontDoor.
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "health_probe_name", health_probe_name)
        pulumi.set(__self__, "load_balancing_name", load_balancing_name)
        pulumi.set(__self__, "name", name)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Sequence['outputs.FrontdoorBackendPoolBackend']:
        """
        A `backend` block as defined below.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="healthProbeName")
    def health_probe_name(self) -> _builtins.str:
        """
        Specifies the name of the `backend_pool_health_probe` block within this resource to use for this `Backend Pool`.
        """
        return pulumi.get(self, "health_probe_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancingName")
    def load_balancing_name(self) -> _builtins.str:
        """
        Specifies the name of the `backend_pool_load_balancing` block within this resource to use for this `Backend Pool`.
        """
        return pulumi.get(self, "load_balancing_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the Backend Pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the FrontDoor.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class FrontdoorBackendPoolBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorBackendPoolBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorBackendPoolBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorBackendPoolBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 host_header: _builtins.str,
                 http_port: _builtins.int,
                 https_port: _builtins.int,
                 enabled: Optional[_builtins.bool] = None,
                 priority: Optional[_builtins.int] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: Location of the backend (IP address or FQDN)
        :param _builtins.str host_header: The value to use as the host header sent to the backend.
        :param _builtins.int http_port: The HTTP TCP port number. Possible values are between `1` - `65535`.
        :param _builtins.int https_port: The HTTPS TCP port number. Possible values are between `1` - `65535`.
        :param _builtins.bool enabled: Specifies if the backend is enabled or not. Valid options are `true` or `false`. Defaults to `true`.
        :param _builtins.int priority: Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy. Defaults to `1`.
        :param _builtins.int weight: Weight of this endpoint for load balancing purposes. Defaults to `50`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "http_port", http_port)
        pulumi.set(__self__, "https_port", https_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Location of the backend (IP address or FQDN)
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> _builtins.str:
        """
        The value to use as the host header sent to the backend.
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> _builtins.int:
        """
        The HTTP TCP port number. Possible values are between `1` - `65535`.
        """
        return pulumi.get(self, "http_port")

    @_builtins.property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> _builtins.int:
        """
        The HTTPS TCP port number. Possible values are between `1` - `65535`.
        """
        return pulumi.get(self, "https_port")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if the backend is enabled or not. Valid options are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy. Defaults to `1`.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight of this endpoint for load balancing purposes. Defaults to `50`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class FrontdoorBackendPoolHealthProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "probeMethod":
            suggest = "probe_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorBackendPoolHealthProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorBackendPoolHealthProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorBackendPoolHealthProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 interval_in_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 probe_method: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the name of the Health Probe.
        :param _builtins.bool enabled: Is this health probe enabled? Defaults to `true`.
        :param _builtins.str id: The ID of the FrontDoor.
        :param _builtins.int interval_in_seconds: The number of seconds between each Health Probe. Defaults to `120`.
        :param _builtins.str path: The path to use for the Health Probe. Default is `/`.
        :param _builtins.str probe_method: Specifies HTTP method the health probe uses when querying the backend pool instances. Possible values include: `GET` and `HEAD`. Defaults to `GET`.
               
               > **NOTE:** Use the `HEAD` method if you do not need to check the response body of your health probe.
        :param _builtins.str protocol: Protocol scheme to use for the Health Probe. Possible values are `Http` and `Https`. Defaults to `Http`.
        """
        pulumi.set(__self__, "name", name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if probe_method is not None:
            pulumi.set(__self__, "probe_method", probe_method)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the Health Probe.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Is this health probe enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the FrontDoor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        The number of seconds between each Health Probe. Defaults to `120`.
        """
        return pulumi.get(self, "interval_in_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path to use for the Health Probe. Default is `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="probeMethod")
    def probe_method(self) -> Optional[_builtins.str]:
        """
        Specifies HTTP method the health probe uses when querying the backend pool instances. Possible values include: `GET` and `HEAD`. Defaults to `GET`.

        > **NOTE:** Use the `HEAD` method if you do not need to check the response body of your health probe.
        """
        return pulumi.get(self, "probe_method")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol scheme to use for the Health Probe. Possible values are `Http` and `Https`. Defaults to `Http`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class FrontdoorBackendPoolLoadBalancing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalLatencyMilliseconds":
            suggest = "additional_latency_milliseconds"
        elif key == "sampleSize":
            suggest = "sample_size"
        elif key == "successfulSamplesRequired":
            suggest = "successful_samples_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorBackendPoolLoadBalancing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorBackendPoolLoadBalancing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorBackendPoolLoadBalancing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 additional_latency_milliseconds: Optional[_builtins.int] = None,
                 id: Optional[_builtins.str] = None,
                 sample_size: Optional[_builtins.int] = None,
                 successful_samples_required: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: Specifies the name of the Load Balancer.
        :param _builtins.int additional_latency_milliseconds: The additional latency in milliseconds for probes to fall into the lowest latency bucket. Defaults to `0`.
        :param _builtins.str id: The ID of the FrontDoor.
        :param _builtins.int sample_size: The number of samples to consider for load balancing decisions. Defaults to `4`.
        :param _builtins.int successful_samples_required: The number of samples within the sample period that must succeed. Defaults to `2`.
        """
        pulumi.set(__self__, "name", name)
        if additional_latency_milliseconds is not None:
            pulumi.set(__self__, "additional_latency_milliseconds", additional_latency_milliseconds)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if successful_samples_required is not None:
            pulumi.set(__self__, "successful_samples_required", successful_samples_required)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="additionalLatencyMilliseconds")
    def additional_latency_milliseconds(self) -> Optional[_builtins.int]:
        """
        The additional latency in milliseconds for probes to fall into the lowest latency bucket. Defaults to `0`.
        """
        return pulumi.get(self, "additional_latency_milliseconds")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the FrontDoor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[_builtins.int]:
        """
        The number of samples to consider for load balancing decisions. Defaults to `4`.
        """
        return pulumi.get(self, "sample_size")

    @_builtins.property
    @pulumi.getter(name="successfulSamplesRequired")
    def successful_samples_required(self) -> Optional[_builtins.int]:
        """
        The number of samples within the sample period that must succeed. Defaults to `2`.
        """
        return pulumi.get(self, "successful_samples_required")


@pulumi.output_type
class FrontdoorBackendPoolSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enforceBackendPoolsCertificateNameCheck":
            suggest = "enforce_backend_pools_certificate_name_check"
        elif key == "backendPoolsSendReceiveTimeoutSeconds":
            suggest = "backend_pools_send_receive_timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorBackendPoolSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorBackendPoolSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorBackendPoolSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enforce_backend_pools_certificate_name_check: _builtins.bool,
                 backend_pools_send_receive_timeout_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enforce_backend_pools_certificate_name_check: Enforce certificate name check on `HTTPS` requests to all backend pools, this setting will have no effect on `HTTP` requests. Permitted values are `true` or `false`.
               
               > **NOTE:** `backend_pools_send_receive_timeout_seconds` and `enforce_backend_pools_certificate_name_check` apply to all backend pools.
        :param _builtins.int backend_pools_send_receive_timeout_seconds: Specifies the send and receive timeout on forwarding request to the backend. When the timeout is reached, the request fails and returns. Possible values are between `0` - `240`. Defaults to `60`.
        """
        pulumi.set(__self__, "enforce_backend_pools_certificate_name_check", enforce_backend_pools_certificate_name_check)
        if backend_pools_send_receive_timeout_seconds is not None:
            pulumi.set(__self__, "backend_pools_send_receive_timeout_seconds", backend_pools_send_receive_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="enforceBackendPoolsCertificateNameCheck")
    def enforce_backend_pools_certificate_name_check(self) -> _builtins.bool:
        """
        Enforce certificate name check on `HTTPS` requests to all backend pools, this setting will have no effect on `HTTP` requests. Permitted values are `true` or `false`.

        > **NOTE:** `backend_pools_send_receive_timeout_seconds` and `enforce_backend_pools_certificate_name_check` apply to all backend pools.
        """
        return pulumi.get(self, "enforce_backend_pools_certificate_name_check")

    @_builtins.property
    @pulumi.getter(name="backendPoolsSendReceiveTimeoutSeconds")
    def backend_pools_send_receive_timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the send and receive timeout on forwarding request to the backend. When the timeout is reached, the request fails and returns. Possible values are between `0` - `240`. Defaults to `60`.
        """
        return pulumi.get(self, "backend_pools_send_receive_timeout_seconds")


@pulumi.output_type
class FrontdoorExplicitResourceOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPoolHealthProbeIds":
            suggest = "backend_pool_health_probe_ids"
        elif key == "backendPoolIds":
            suggest = "backend_pool_ids"
        elif key == "backendPoolLoadBalancingIds":
            suggest = "backend_pool_load_balancing_ids"
        elif key == "frontendEndpointIds":
            suggest = "frontend_endpoint_ids"
        elif key == "routingRuleIds":
            suggest = "routing_rule_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorExplicitResourceOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorExplicitResourceOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorExplicitResourceOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_pool_health_probe_ids: Optional[Sequence[_builtins.str]] = None,
                 backend_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 backend_pool_load_balancing_ids: Optional[Sequence[_builtins.str]] = None,
                 frontend_endpoint_ids: Optional[Sequence[_builtins.str]] = None,
                 routing_rule_ids: Optional[Sequence[_builtins.str]] = None):
        if backend_pool_health_probe_ids is not None:
            pulumi.set(__self__, "backend_pool_health_probe_ids", backend_pool_health_probe_ids)
        if backend_pool_ids is not None:
            pulumi.set(__self__, "backend_pool_ids", backend_pool_ids)
        if backend_pool_load_balancing_ids is not None:
            pulumi.set(__self__, "backend_pool_load_balancing_ids", backend_pool_load_balancing_ids)
        if frontend_endpoint_ids is not None:
            pulumi.set(__self__, "frontend_endpoint_ids", frontend_endpoint_ids)
        if routing_rule_ids is not None:
            pulumi.set(__self__, "routing_rule_ids", routing_rule_ids)

    @_builtins.property
    @pulumi.getter(name="backendPoolHealthProbeIds")
    def backend_pool_health_probe_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "backend_pool_health_probe_ids")

    @_builtins.property
    @pulumi.getter(name="backendPoolIds")
    def backend_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "backend_pool_ids")

    @_builtins.property
    @pulumi.getter(name="backendPoolLoadBalancingIds")
    def backend_pool_load_balancing_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "backend_pool_load_balancing_ids")

    @_builtins.property
    @pulumi.getter(name="frontendEndpointIds")
    def frontend_endpoint_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "frontend_endpoint_ids")

    @_builtins.property
    @pulumi.getter(name="routingRuleIds")
    def routing_rule_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "routing_rule_ids")


@pulumi.output_type
class FrontdoorFrontendEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "sessionAffinityEnabled":
            suggest = "session_affinity_enabled"
        elif key == "sessionAffinityTtlSeconds":
            suggest = "session_affinity_ttl_seconds"
        elif key == "webApplicationFirewallPolicyLinkId":
            suggest = "web_application_firewall_policy_link_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorFrontendEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorFrontendEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorFrontendEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: _builtins.str,
                 name: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 session_affinity_enabled: Optional[_builtins.bool] = None,
                 session_affinity_ttl_seconds: Optional[_builtins.int] = None,
                 web_application_firewall_policy_link_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str host_name: Specifies the host name of the `frontend_endpoint`. Must be a domain name. In order to use a name.azurefd.net domain, the name value must match the Front Door name.
        :param _builtins.str name: Specifies the name of the `frontend_endpoint`.
        :param _builtins.str id: The ID of the FrontDoor.
        :param _builtins.bool session_affinity_enabled: Whether to allow session affinity on this host. Valid options are `true` or `false` Defaults to `false`.
        :param _builtins.int session_affinity_ttl_seconds: The TTL to use in seconds for session affinity, if applicable. Defaults to `0`.
        :param _builtins.str web_application_firewall_policy_link_id: Defines the Web Application Firewall policy `ID` for each host.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "name", name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if session_affinity_enabled is not None:
            pulumi.set(__self__, "session_affinity_enabled", session_affinity_enabled)
        if session_affinity_ttl_seconds is not None:
            pulumi.set(__self__, "session_affinity_ttl_seconds", session_affinity_ttl_seconds)
        if web_application_firewall_policy_link_id is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link_id", web_application_firewall_policy_link_id)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        Specifies the host name of the `frontend_endpoint`. Must be a domain name. In order to use a name.azurefd.net domain, the name value must match the Front Door name.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the `frontend_endpoint`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the FrontDoor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="sessionAffinityEnabled")
    def session_affinity_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to allow session affinity on this host. Valid options are `true` or `false` Defaults to `false`.
        """
        return pulumi.get(self, "session_affinity_enabled")

    @_builtins.property
    @pulumi.getter(name="sessionAffinityTtlSeconds")
    def session_affinity_ttl_seconds(self) -> Optional[_builtins.int]:
        """
        The TTL to use in seconds for session affinity, if applicable. Defaults to `0`.
        """
        return pulumi.get(self, "session_affinity_ttl_seconds")

    @_builtins.property
    @pulumi.getter(name="webApplicationFirewallPolicyLinkId")
    def web_application_firewall_policy_link_id(self) -> Optional[_builtins.str]:
        """
        Defines the Web Application Firewall policy `ID` for each host.
        """
        return pulumi.get(self, "web_application_firewall_policy_link_id")


@pulumi.output_type
class FrontdoorRoutingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptedProtocols":
            suggest = "accepted_protocols"
        elif key == "frontendEndpoints":
            suggest = "frontend_endpoints"
        elif key == "patternsToMatches":
            suggest = "patterns_to_matches"
        elif key == "forwardingConfiguration":
            suggest = "forwarding_configuration"
        elif key == "redirectConfiguration":
            suggest = "redirect_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorRoutingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorRoutingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorRoutingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accepted_protocols: Sequence[_builtins.str],
                 frontend_endpoints: Sequence[_builtins.str],
                 name: _builtins.str,
                 patterns_to_matches: Sequence[_builtins.str],
                 enabled: Optional[_builtins.bool] = None,
                 forwarding_configuration: Optional['outputs.FrontdoorRoutingRuleForwardingConfiguration'] = None,
                 id: Optional[_builtins.str] = None,
                 redirect_configuration: Optional['outputs.FrontdoorRoutingRuleRedirectConfiguration'] = None):
        """
        :param Sequence[_builtins.str] accepted_protocols: Protocol schemes to match for the Backend Routing Rule. Possible values are `Http` and `Https`.
        :param Sequence[_builtins.str] frontend_endpoints: The names of the `frontend_endpoint` blocks within this resource to associate with this `routing_rule`.
        :param _builtins.str name: Specifies the name of the Routing Rule.
        :param Sequence[_builtins.str] patterns_to_matches: The route patterns for the Backend Routing Rule.
        :param _builtins.bool enabled: `Enable` or `Disable` use of this Backend Routing Rule. Permitted values are `true` or `false`. Defaults to `true`.
        :param 'FrontdoorRoutingRuleForwardingConfigurationArgs' forwarding_configuration: A `forwarding_configuration` block as defined below.
        :param _builtins.str id: The ID of the FrontDoor.
        :param 'FrontdoorRoutingRuleRedirectConfigurationArgs' redirect_configuration: A `redirect_configuration` block as defined below.
        """
        pulumi.set(__self__, "accepted_protocols", accepted_protocols)
        pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "patterns_to_matches", patterns_to_matches)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forwarding_configuration is not None:
            pulumi.set(__self__, "forwarding_configuration", forwarding_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)

    @_builtins.property
    @pulumi.getter(name="acceptedProtocols")
    def accepted_protocols(self) -> Sequence[_builtins.str]:
        """
        Protocol schemes to match for the Backend Routing Rule. Possible values are `Http` and `Https`.
        """
        return pulumi.get(self, "accepted_protocols")

    @_builtins.property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Sequence[_builtins.str]:
        """
        The names of the `frontend_endpoint` blocks within this resource to associate with this `routing_rule`.
        """
        return pulumi.get(self, "frontend_endpoints")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the Routing Rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="patternsToMatches")
    def patterns_to_matches(self) -> Sequence[_builtins.str]:
        """
        The route patterns for the Backend Routing Rule.
        """
        return pulumi.get(self, "patterns_to_matches")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        `Enable` or `Disable` use of this Backend Routing Rule. Permitted values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="forwardingConfiguration")
    def forwarding_configuration(self) -> Optional['outputs.FrontdoorRoutingRuleForwardingConfiguration']:
        """
        A `forwarding_configuration` block as defined below.
        """
        return pulumi.get(self, "forwarding_configuration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the FrontDoor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional['outputs.FrontdoorRoutingRuleRedirectConfiguration']:
        """
        A `redirect_configuration` block as defined below.
        """
        return pulumi.get(self, "redirect_configuration")


@pulumi.output_type
class FrontdoorRoutingRuleForwardingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPoolName":
            suggest = "backend_pool_name"
        elif key == "cacheDuration":
            suggest = "cache_duration"
        elif key == "cacheEnabled":
            suggest = "cache_enabled"
        elif key == "cacheQueryParameterStripDirective":
            suggest = "cache_query_parameter_strip_directive"
        elif key == "cacheQueryParameters":
            suggest = "cache_query_parameters"
        elif key == "cacheUseDynamicCompression":
            suggest = "cache_use_dynamic_compression"
        elif key == "customForwardingPath":
            suggest = "custom_forwarding_path"
        elif key == "forwardingProtocol":
            suggest = "forwarding_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorRoutingRuleForwardingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorRoutingRuleForwardingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorRoutingRuleForwardingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_pool_name: _builtins.str,
                 cache_duration: Optional[_builtins.str] = None,
                 cache_enabled: Optional[_builtins.bool] = None,
                 cache_query_parameter_strip_directive: Optional[_builtins.str] = None,
                 cache_query_parameters: Optional[Sequence[_builtins.str]] = None,
                 cache_use_dynamic_compression: Optional[_builtins.bool] = None,
                 custom_forwarding_path: Optional[_builtins.str] = None,
                 forwarding_protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str backend_pool_name: Specifies the name of the Backend Pool to forward the incoming traffic to.
        :param _builtins.str cache_duration: Specify the minimum caching duration (in ISO8601 notation e.g. `P1DT2H` for 1 day and 2 hours). Needs to be greater than 0 and smaller than 365 days. `cache_duration` works only in combination with `cache_enabled` set to `true`.
        :param _builtins.bool cache_enabled: Specifies whether to Enable caching or not. Valid options are `true` or `false`. Defaults to `false`.
        :param _builtins.str cache_query_parameter_strip_directive: Defines cache behaviour in relation to query string parameters. Valid options are `StripAll`, `StripAllExcept`, `StripOnly` or `StripNone`. Defaults to `StripAll`.
        :param Sequence[_builtins.str] cache_query_parameters: Specify query parameters (array). Works only in combination with `cache_query_parameter_strip_directive` set to `StripAllExcept` or `StripOnly`.
        :param _builtins.bool cache_use_dynamic_compression: Whether to use dynamic compression when caching. Valid options are `true` or `false`. Defaults to `false`.
        :param _builtins.str custom_forwarding_path: Path to use when constructing the request to forward to the backend. This functions as a URL Rewrite. Default behaviour preserves the URL path.
        :param _builtins.str forwarding_protocol: Protocol to use when redirecting. Valid options are `HttpOnly`, `HttpsOnly`, or `MatchRequest`. Defaults to `HttpsOnly`.
        """
        pulumi.set(__self__, "backend_pool_name", backend_pool_name)
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)
        if cache_enabled is not None:
            pulumi.set(__self__, "cache_enabled", cache_enabled)
        if cache_query_parameter_strip_directive is not None:
            pulumi.set(__self__, "cache_query_parameter_strip_directive", cache_query_parameter_strip_directive)
        if cache_query_parameters is not None:
            pulumi.set(__self__, "cache_query_parameters", cache_query_parameters)
        if cache_use_dynamic_compression is not None:
            pulumi.set(__self__, "cache_use_dynamic_compression", cache_use_dynamic_compression)
        if custom_forwarding_path is not None:
            pulumi.set(__self__, "custom_forwarding_path", custom_forwarding_path)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)

    @_builtins.property
    @pulumi.getter(name="backendPoolName")
    def backend_pool_name(self) -> _builtins.str:
        """
        Specifies the name of the Backend Pool to forward the incoming traffic to.
        """
        return pulumi.get(self, "backend_pool_name")

    @_builtins.property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[_builtins.str]:
        """
        Specify the minimum caching duration (in ISO8601 notation e.g. `P1DT2H` for 1 day and 2 hours). Needs to be greater than 0 and smaller than 365 days. `cache_duration` works only in combination with `cache_enabled` set to `true`.
        """
        return pulumi.get(self, "cache_duration")

    @_builtins.property
    @pulumi.getter(name="cacheEnabled")
    def cache_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to Enable caching or not. Valid options are `true` or `false`. Defaults to `false`.
        """
        return pulumi.get(self, "cache_enabled")

    @_builtins.property
    @pulumi.getter(name="cacheQueryParameterStripDirective")
    def cache_query_parameter_strip_directive(self) -> Optional[_builtins.str]:
        """
        Defines cache behaviour in relation to query string parameters. Valid options are `StripAll`, `StripAllExcept`, `StripOnly` or `StripNone`. Defaults to `StripAll`.
        """
        return pulumi.get(self, "cache_query_parameter_strip_directive")

    @_builtins.property
    @pulumi.getter(name="cacheQueryParameters")
    def cache_query_parameters(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specify query parameters (array). Works only in combination with `cache_query_parameter_strip_directive` set to `StripAllExcept` or `StripOnly`.
        """
        return pulumi.get(self, "cache_query_parameters")

    @_builtins.property
    @pulumi.getter(name="cacheUseDynamicCompression")
    def cache_use_dynamic_compression(self) -> Optional[_builtins.bool]:
        """
        Whether to use dynamic compression when caching. Valid options are `true` or `false`. Defaults to `false`.
        """
        return pulumi.get(self, "cache_use_dynamic_compression")

    @_builtins.property
    @pulumi.getter(name="customForwardingPath")
    def custom_forwarding_path(self) -> Optional[_builtins.str]:
        """
        Path to use when constructing the request to forward to the backend. This functions as a URL Rewrite. Default behaviour preserves the URL path.
        """
        return pulumi.get(self, "custom_forwarding_path")

    @_builtins.property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[_builtins.str]:
        """
        Protocol to use when redirecting. Valid options are `HttpOnly`, `HttpsOnly`, or `MatchRequest`. Defaults to `HttpsOnly`.
        """
        return pulumi.get(self, "forwarding_protocol")


@pulumi.output_type
class FrontdoorRoutingRuleRedirectConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectProtocol":
            suggest = "redirect_protocol"
        elif key == "redirectType":
            suggest = "redirect_type"
        elif key == "customFragment":
            suggest = "custom_fragment"
        elif key == "customHost":
            suggest = "custom_host"
        elif key == "customPath":
            suggest = "custom_path"
        elif key == "customQueryString":
            suggest = "custom_query_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontdoorRoutingRuleRedirectConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontdoorRoutingRuleRedirectConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontdoorRoutingRuleRedirectConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_protocol: _builtins.str,
                 redirect_type: _builtins.str,
                 custom_fragment: Optional[_builtins.str] = None,
                 custom_host: Optional[_builtins.str] = None,
                 custom_path: Optional[_builtins.str] = None,
                 custom_query_string: Optional[_builtins.str] = None):
        """
        :param _builtins.str redirect_protocol: Protocol to use when redirecting. Valid options are `HttpOnly`, `HttpsOnly`, or `MatchRequest`.
        :param _builtins.str redirect_type: Status code for the redirect. Valida options are `Moved`, `Found`, `TemporaryRedirect`, `PermanentRedirect`.
        :param _builtins.str custom_fragment: The destination fragment in the portion of URL after '#'. Set this to add a fragment to the redirect URL.
        :param _builtins.str custom_host: Set this to change the URL for the redirection.
        :param _builtins.str custom_path: The path to retain as per the incoming request, or update in the URL for the redirection.
        :param _builtins.str custom_query_string: Replace any existing query string from the incoming request URL.
        """
        pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        pulumi.set(__self__, "redirect_type", redirect_type)
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_host is not None:
            pulumi.set(__self__, "custom_host", custom_host)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)

    @_builtins.property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> _builtins.str:
        """
        Protocol to use when redirecting. Valid options are `HttpOnly`, `HttpsOnly`, or `MatchRequest`.
        """
        return pulumi.get(self, "redirect_protocol")

    @_builtins.property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> _builtins.str:
        """
        Status code for the redirect. Valida options are `Moved`, `Found`, `TemporaryRedirect`, `PermanentRedirect`.
        """
        return pulumi.get(self, "redirect_type")

    @_builtins.property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[_builtins.str]:
        """
        The destination fragment in the portion of URL after '#'. Set this to add a fragment to the redirect URL.
        """
        return pulumi.get(self, "custom_fragment")

    @_builtins.property
    @pulumi.getter(name="customHost")
    def custom_host(self) -> Optional[_builtins.str]:
        """
        Set this to change the URL for the redirection.
        """
        return pulumi.get(self, "custom_host")

    @_builtins.property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[_builtins.str]:
        """
        The path to retain as per the incoming request, or update in the URL for the redirection.
        """
        return pulumi.get(self, "custom_path")

    @_builtins.property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[_builtins.str]:
        """
        Replace any existing query string from the incoming request URL.
        """
        return pulumi.get(self, "custom_query_string")


@pulumi.output_type
class RulesEngineRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 priority: _builtins.int,
                 action: Optional['outputs.RulesEngineRuleAction'] = None,
                 match_conditions: Optional[Sequence['outputs.RulesEngineRuleMatchCondition']] = None):
        """
        :param _builtins.str name: The name of the rule.
        :param _builtins.int priority: Priority of the rule, must be unique per rules engine definition.
        :param 'RulesEngineRuleActionArgs' action: An `action` block as defined below.
        :param Sequence['RulesEngineRuleMatchConditionArgs'] match_conditions: One or more `match_condition` block as defined below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of the rule, must be unique per rules engine definition.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional['outputs.RulesEngineRuleAction']:
        """
        An `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.RulesEngineRuleMatchCondition']]:
        """
        One or more `match_condition` block as defined below.
        """
        return pulumi.get(self, "match_conditions")


@pulumi.output_type
class RulesEngineRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeaders":
            suggest = "request_headers"
        elif key == "responseHeaders":
            suggest = "response_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_headers: Optional[Sequence['outputs.RulesEngineRuleActionRequestHeader']] = None,
                 response_headers: Optional[Sequence['outputs.RulesEngineRuleActionResponseHeader']] = None):
        """
        :param Sequence['RulesEngineRuleActionRequestHeaderArgs'] request_headers: A `request_header` block as defined below.
        :param Sequence['RulesEngineRuleActionResponseHeaderArgs'] response_headers: A `response_header` block as defined below.
        """
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Sequence['outputs.RulesEngineRuleActionRequestHeader']]:
        """
        A `request_header` block as defined below.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence['outputs.RulesEngineRuleActionResponseHeader']]:
        """
        A `response_header` block as defined below.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class RulesEngineRuleActionRequestHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerActionType":
            suggest = "header_action_type"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineRuleActionRequestHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineRuleActionRequestHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineRuleActionRequestHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_action_type: Optional[_builtins.str] = None,
                 header_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str header_action_type: can be set to `Overwrite`, `Append` or `Delete`.
        :param _builtins.str header_name: header name (string).
        :param _builtins.str value: value name (string).
        """
        if header_action_type is not None:
            pulumi.set(__self__, "header_action_type", header_action_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="headerActionType")
    def header_action_type(self) -> Optional[_builtins.str]:
        """
        can be set to `Overwrite`, `Append` or `Delete`.
        """
        return pulumi.get(self, "header_action_type")

    @_builtins.property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[_builtins.str]:
        """
        header name (string).
        """
        return pulumi.get(self, "header_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        value name (string).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RulesEngineRuleActionResponseHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerActionType":
            suggest = "header_action_type"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineRuleActionResponseHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineRuleActionResponseHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineRuleActionResponseHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_action_type: Optional[_builtins.str] = None,
                 header_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str header_action_type: can be set to `Overwrite`, `Append` or `Delete`.
        :param _builtins.str header_name: header name (string).
        :param _builtins.str value: value name (string).
        """
        if header_action_type is not None:
            pulumi.set(__self__, "header_action_type", header_action_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="headerActionType")
    def header_action_type(self) -> Optional[_builtins.str]:
        """
        can be set to `Overwrite`, `Append` or `Delete`.
        """
        return pulumi.get(self, "header_action_type")

    @_builtins.property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[_builtins.str]:
        """
        header name (string).
        """
        return pulumi.get(self, "header_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        value name (string).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RulesEngineRuleMatchCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineRuleMatchCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineRuleMatchCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineRuleMatchCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: _builtins.str,
                 negate_condition: Optional[_builtins.bool] = None,
                 selector: Optional[_builtins.str] = None,
                 transforms: Optional[Sequence[_builtins.str]] = None,
                 values: Optional[Sequence[_builtins.str]] = None,
                 variable: Optional[_builtins.str] = None):
        """
        :param _builtins.str operator: can be set to `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith` or `EndsWith`
        :param _builtins.bool negate_condition: can be set to `true` or `false` to negate the given condition. Defaults to `false`.
        :param _builtins.str selector: match against a specific key when `variable` is set to `PostArgs` or `RequestHeader`. It cannot be used with `QueryString` and `RequestMethod`.
        :param Sequence[_builtins.str] transforms: can be set to one or more values out of `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`
        :param Sequence[_builtins.str] values: (array) can contain one or more strings.
        :param _builtins.str variable: can be set to `IsMobile`, `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestURI`, `RequestPath`, `RequestFilename`, `RequestFilenameExtension`,`RequestHeader`,`RequestBody` or `RequestScheme`.
        """
        pulumi.set(__self__, "operator", operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        can be set to `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith` or `EndsWith`
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[_builtins.bool]:
        """
        can be set to `true` or `false` to negate the given condition. Defaults to `false`.
        """
        return pulumi.get(self, "negate_condition")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[_builtins.str]:
        """
        match against a specific key when `variable` is set to `PostArgs` or `RequestHeader`. It cannot be used with `QueryString` and `RequestMethod`.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[_builtins.str]]:
        """
        can be set to one or more values out of `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`
        """
        return pulumi.get(self, "transforms")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        (array) can contain one or more strings.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def variable(self) -> Optional[_builtins.str]:
        """
        can be set to `IsMobile`, `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestURI`, `RequestPath`, `RequestFilename`, `RequestFilenameExtension`,`RequestHeader`,`RequestBody` or `RequestScheme`.
        """
        return pulumi.get(self, "variable")


