# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServicesAccountResult',
    'AwaitableGetServicesAccountResult',
    'get_services_account',
    'get_services_account_output',
]

@pulumi.output_type
class GetServicesAccountResult:
    """
    A collection of values returned by getServicesAccount.
    """
    def __init__(__self__, application_id=None, billing_plan_id=None, id=None, name=None, resource_group_name=None, tags=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if billing_plan_id and not isinstance(billing_plan_id, str):
            raise TypeError("Expected argument 'billing_plan_id' to be a str")
        pulumi.set(__self__, "billing_plan_id", billing_plan_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        The application ID associated with the Graph Services Account.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="billingPlanId")
    def billing_plan_id(self) -> _builtins.str:
        """
        The billing plan ID for the Graph Services Account.
        """
        return pulumi.get(self, "billing_plan_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Graph Services Account.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServicesAccountResult(GetServicesAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicesAccountResult(
            application_id=self.application_id,
            billing_plan_id=self.billing_plan_id,
            id=self.id,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_services_account(name: Optional[_builtins.str] = None,
                         resource_group_name: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicesAccountResult:
    """
    Use this data source to access information about an existing Graph Services Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.graph.get_services_account(name="example-graph-services-account",
        resource_group_name="example-resources")
    pulumi.export("applicationId", example.application_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.GraphServices` - 2023-04-13


    :param _builtins.str name: The name of the Graph Services Account.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Graph Services Account exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:graph/getServicesAccount:getServicesAccount', __args__, opts=opts, typ=GetServicesAccountResult).value

    return AwaitableGetServicesAccountResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        billing_plan_id=pulumi.get(__ret__, 'billing_plan_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_services_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicesAccountResult]:
    """
    Use this data source to access information about an existing Graph Services Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.graph.get_services_account(name="example-graph-services-account",
        resource_group_name="example-resources")
    pulumi.export("applicationId", example.application_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.GraphServices` - 2023-04-13


    :param _builtins.str name: The name of the Graph Services Account.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Graph Services Account exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:graph/getServicesAccount:getServicesAccount', __args__, opts=opts, typ=GetServicesAccountResult)
    return __ret__.apply(lambda __response__: GetServicesAccountResult(
        application_id=pulumi.get(__response__, 'application_id'),
        billing_plan_id=pulumi.get(__response__, 'billing_plan_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
