# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HadoopClusterArgs', 'HadoopCluster']

@pulumi.input_type
class HadoopClusterArgs:
    def __init__(__self__, *,
                 cluster_version: pulumi.Input[_builtins.str],
                 component_version: pulumi.Input['HadoopClusterComponentVersionArgs'],
                 gateway: pulumi.Input['HadoopClusterGatewayArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 roles: pulumi.Input['HadoopClusterRolesArgs'],
                 tier: pulumi.Input[_builtins.str],
                 compute_isolation: Optional[pulumi.Input['HadoopClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]]] = None,
                 extension: Optional[pulumi.Input['HadoopClusterExtensionArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input['HadoopClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['HadoopClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['HadoopClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs']] = None,
                 security_profile: Optional[pulumi.Input['HadoopClusterSecurityProfileArgs']] = None,
                 storage_account_gen2: Optional[pulumi.Input['HadoopClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HadoopCluster resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['HadoopClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input['HadoopClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['HadoopClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input['HadoopClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "component_version", component_version)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "tier", tier)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Input['HadoopClusterComponentVersionArgs']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: pulumi.Input['HadoopClusterComponentVersionArgs']):
        pulumi.set(self, "component_version", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Input['HadoopClusterGatewayArgs']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input['HadoopClusterGatewayArgs']):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input['HadoopClusterRolesArgs']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input['HadoopClusterRolesArgs']):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['HadoopClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['HadoopClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['HadoopClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['HadoopClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['HadoopClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['HadoopClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['HadoopClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['HadoopClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['HadoopClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['HadoopClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['HadoopClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['HadoopClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['HadoopClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['HadoopClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.input_type
class _HadoopClusterState:
    def __init__(__self__, *,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input['HadoopClusterComponentVersionArgs']] = None,
                 compute_isolation: Optional[pulumi.Input['HadoopClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]]] = None,
                 extension: Optional[pulumi.Input['HadoopClusterExtensionArgs']] = None,
                 gateway: Optional[pulumi.Input['HadoopClusterGatewayArgs']] = None,
                 https_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input['HadoopClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['HadoopClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['HadoopClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input['HadoopClusterRolesArgs']] = None,
                 security_profile: Optional[pulumi.Input['HadoopClusterSecurityProfileArgs']] = None,
                 ssh_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_gen2: Optional[pulumi.Input['HadoopClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HadoopCluster resources.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['HadoopClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input['HadoopClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input['HadoopClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Hadoop Cluster.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['HadoopClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['HadoopClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input['HadoopClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Hadoop Cluster.
        :param pulumi.Input['HadoopClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if ssh_endpoint is not None:
            pulumi.set(__self__, "ssh_endpoint", ssh_endpoint)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input['HadoopClusterComponentVersionArgs']]:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input['HadoopClusterComponentVersionArgs']]):
        pulumi.set(self, "component_version", value)

    @_builtins.property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['HadoopClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['HadoopClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['HadoopClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['HadoopClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input['HadoopClusterGatewayArgs']]:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input['HadoopClusterGatewayArgs']]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['HadoopClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['HadoopClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['HadoopClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['HadoopClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['HadoopClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['HadoopClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['HadoopClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input['HadoopClusterRolesArgs']]:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input['HadoopClusterRolesArgs']]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['HadoopClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['HadoopClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @_builtins.property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH Connectivity Endpoint for this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @ssh_endpoint.setter
    def ssh_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['HadoopClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['HadoopClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HadoopClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.type_token("azure:hdinsight/hadoopCluster:HadoopCluster")
class HadoopCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['HadoopClusterComponentVersionArgs', 'HadoopClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['HadoopClusterComputeIsolationArgs', 'HadoopClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterDiskEncryptionArgs', 'HadoopClusterDiskEncryptionArgsDict']]]]] = None,
                 extension: Optional[pulumi.Input[Union['HadoopClusterExtensionArgs', 'HadoopClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['HadoopClusterGatewayArgs', 'HadoopClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['HadoopClusterMetastoresArgs', 'HadoopClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['HadoopClusterMonitorArgs', 'HadoopClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['HadoopClusterNetworkArgs', 'HadoopClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['HadoopClusterPrivateLinkConfigurationArgs', 'HadoopClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['HadoopClusterRolesArgs', 'HadoopClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['HadoopClusterSecurityProfileArgs', 'HadoopClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['HadoopClusterStorageAccountGen2Args', 'HadoopClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterStorageAccountArgs', 'HadoopClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a HDInsight Hadoop Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_hadoop_cluster = azure.hdinsight.HadoopCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "hadoop": "2.7",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "PAssword123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D4_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight` - 2021-06-01

        ## Import

        HDInsight Hadoop Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/hadoopCluster:HadoopCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterComponentVersionArgs', 'HadoopClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['HadoopClusterComputeIsolationArgs', 'HadoopClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterDiskEncryptionArgs', 'HadoopClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[Union['HadoopClusterExtensionArgs', 'HadoopClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['HadoopClusterGatewayArgs', 'HadoopClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterMetastoresArgs', 'HadoopClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['HadoopClusterMonitorArgs', 'HadoopClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterNetworkArgs', 'HadoopClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['HadoopClusterPrivateLinkConfigurationArgs', 'HadoopClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterRolesArgs', 'HadoopClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['HadoopClusterSecurityProfileArgs', 'HadoopClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterStorageAccountGen2Args', 'HadoopClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterStorageAccountArgs', 'HadoopClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HadoopClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a HDInsight Hadoop Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_hadoop_cluster = azure.hdinsight.HadoopCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "hadoop": "2.7",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "PAssword123!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D4_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_D3_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight` - 2021-06-01

        ## Import

        HDInsight Hadoop Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/hadoopCluster:HadoopCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param HadoopClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HadoopClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['HadoopClusterComponentVersionArgs', 'HadoopClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['HadoopClusterComputeIsolationArgs', 'HadoopClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterDiskEncryptionArgs', 'HadoopClusterDiskEncryptionArgsDict']]]]] = None,
                 extension: Optional[pulumi.Input[Union['HadoopClusterExtensionArgs', 'HadoopClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['HadoopClusterGatewayArgs', 'HadoopClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['HadoopClusterMetastoresArgs', 'HadoopClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['HadoopClusterMonitorArgs', 'HadoopClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['HadoopClusterNetworkArgs', 'HadoopClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['HadoopClusterPrivateLinkConfigurationArgs', 'HadoopClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['HadoopClusterRolesArgs', 'HadoopClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['HadoopClusterSecurityProfileArgs', 'HadoopClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['HadoopClusterStorageAccountGen2Args', 'HadoopClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterStorageAccountArgs', 'HadoopClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HadoopClusterArgs.__new__(HadoopClusterArgs)

            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            if component_version is None and not opts.urn:
                raise TypeError("Missing required property 'component_version'")
            __props__.__dict__["component_version"] = component_version
            __props__.__dict__["compute_isolation"] = compute_isolation
            __props__.__dict__["disk_encryptions"] = disk_encryptions
            __props__.__dict__["extension"] = extension
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["location"] = location
            __props__.__dict__["metastores"] = metastores
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["private_link_configuration"] = private_link_configuration
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["storage_account_gen2"] = storage_account_gen2
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["https_endpoint"] = None
            __props__.__dict__["ssh_endpoint"] = None
        super(HadoopCluster, __self__).__init__(
            'azure:hdinsight/hadoopCluster:HadoopCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            component_version: Optional[pulumi.Input[Union['HadoopClusterComponentVersionArgs', 'HadoopClusterComponentVersionArgsDict']]] = None,
            compute_isolation: Optional[pulumi.Input[Union['HadoopClusterComputeIsolationArgs', 'HadoopClusterComputeIsolationArgsDict']]] = None,
            disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterDiskEncryptionArgs', 'HadoopClusterDiskEncryptionArgsDict']]]]] = None,
            extension: Optional[pulumi.Input[Union['HadoopClusterExtensionArgs', 'HadoopClusterExtensionArgsDict']]] = None,
            gateway: Optional[pulumi.Input[Union['HadoopClusterGatewayArgs', 'HadoopClusterGatewayArgsDict']]] = None,
            https_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metastores: Optional[pulumi.Input[Union['HadoopClusterMetastoresArgs', 'HadoopClusterMetastoresArgsDict']]] = None,
            monitor: Optional[pulumi.Input[Union['HadoopClusterMonitorArgs', 'HadoopClusterMonitorArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['HadoopClusterNetworkArgs', 'HadoopClusterNetworkArgsDict']]] = None,
            private_link_configuration: Optional[pulumi.Input[Union['HadoopClusterPrivateLinkConfigurationArgs', 'HadoopClusterPrivateLinkConfigurationArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Union['HadoopClusterRolesArgs', 'HadoopClusterRolesArgsDict']]] = None,
            security_profile: Optional[pulumi.Input[Union['HadoopClusterSecurityProfileArgs', 'HadoopClusterSecurityProfileArgsDict']]] = None,
            ssh_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_gen2: Optional[pulumi.Input[Union['HadoopClusterStorageAccountGen2Args', 'HadoopClusterStorageAccountGen2ArgsDict']]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterStorageAccountArgs', 'HadoopClusterStorageAccountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'HadoopCluster':
        """
        Get an existing HadoopCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterComponentVersionArgs', 'HadoopClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['HadoopClusterComputeIsolationArgs', 'HadoopClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterDiskEncryptionArgs', 'HadoopClusterDiskEncryptionArgsDict']]]] disk_encryptions: One or more `disk_encryption` block as defined below.
        :param pulumi.Input[Union['HadoopClusterExtensionArgs', 'HadoopClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['HadoopClusterGatewayArgs', 'HadoopClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Hadoop Cluster.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterMetastoresArgs', 'HadoopClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['HadoopClusterMonitorArgs', 'HadoopClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterNetworkArgs', 'HadoopClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['HadoopClusterPrivateLinkConfigurationArgs', 'HadoopClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HadoopClusterRolesArgs', 'HadoopClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['HadoopClusterSecurityProfileArgs', 'HadoopClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Hadoop Cluster.
        :param pulumi.Input[Union['HadoopClusterStorageAccountGen2Args', 'HadoopClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HadoopClusterStorageAccountArgs', 'HadoopClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HadoopClusterState.__new__(_HadoopClusterState)

        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["component_version"] = component_version
        __props__.__dict__["compute_isolation"] = compute_isolation
        __props__.__dict__["disk_encryptions"] = disk_encryptions
        __props__.__dict__["extension"] = extension
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["https_endpoint"] = https_endpoint
        __props__.__dict__["location"] = location
        __props__.__dict__["metastores"] = metastores
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_link_configuration"] = private_link_configuration
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["roles"] = roles
        __props__.__dict__["security_profile"] = security_profile
        __props__.__dict__["ssh_endpoint"] = ssh_endpoint
        __props__.__dict__["storage_account_gen2"] = storage_account_gen2
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["tls_min_version"] = tls_min_version
        return HadoopCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Output['outputs.HadoopClusterComponentVersion']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @_builtins.property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> pulumi.Output[Optional['outputs.HadoopClusterComputeIsolation']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.HadoopClusterDiskEncryption']]]:
        """
        One or more `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> pulumi.Output[Optional['outputs.HadoopClusterExtension']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Output['outputs.HadoopClusterGateway']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def metastores(self) -> pulumi.Output[Optional['outputs.HadoopClusterMetastores']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.HadoopClusterMonitor']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name for this HDInsight Hadoop Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.HadoopClusterNetwork']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> pulumi.Output[Optional['outputs.HadoopClusterPrivateLinkConfiguration']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Hadoop Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output['outputs.HadoopClusterRoles']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.HadoopClusterSecurityProfile']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @_builtins.property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH Connectivity Endpoint for this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @_builtins.property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> pulumi.Output[Optional['outputs.HadoopClusterStorageAccountGen2']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.HadoopClusterStorageAccount']]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of Tags which should be assigned to this HDInsight Hadoop Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Hadoop Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

