# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InteractiveQueryClusterArgs', 'InteractiveQueryCluster']

@pulumi.input_type
class InteractiveQueryClusterArgs:
    def __init__(__self__, *,
                 cluster_version: pulumi.Input[_builtins.str],
                 component_version: pulumi.Input['InteractiveQueryClusterComponentVersionArgs'],
                 gateway: pulumi.Input['InteractiveQueryClusterGatewayArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 roles: pulumi.Input['InteractiveQueryClusterRolesArgs'],
                 tier: pulumi.Input[_builtins.str],
                 compute_isolation: Optional[pulumi.Input['InteractiveQueryClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extension: Optional[pulumi.Input['InteractiveQueryClusterExtensionArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input['InteractiveQueryClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['InteractiveQueryClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['InteractiveQueryClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs']] = None,
                 security_profile: Optional[pulumi.Input['InteractiveQueryClusterSecurityProfileArgs']] = None,
                 storage_account_gen2: Optional[pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InteractiveQueryCluster resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]] disk_encryptions: A `disk_encryption` block as defined below.
        :param pulumi.Input[_builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "component_version", component_version)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "tier", tier)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "encryption_in_transit_enabled", encryption_in_transit_enabled)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Input['InteractiveQueryClusterComponentVersionArgs']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: pulumi.Input['InteractiveQueryClusterComponentVersionArgs']):
        pulumi.set(self, "component_version", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Input['InteractiveQueryClusterGatewayArgs']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input['InteractiveQueryClusterGatewayArgs']):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input['InteractiveQueryClusterRolesArgs']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input['InteractiveQueryClusterRolesArgs']):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['InteractiveQueryClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['InteractiveQueryClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]]]:
        """
        A `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @_builtins.property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @encryption_in_transit_enabled.setter
    def encryption_in_transit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_in_transit_enabled", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['InteractiveQueryClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['InteractiveQueryClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['InteractiveQueryClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['InteractiveQueryClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['InteractiveQueryClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['InteractiveQueryClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['InteractiveQueryClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['InteractiveQueryClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['InteractiveQueryClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['InteractiveQueryClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.input_type
class _InteractiveQueryClusterState:
    def __init__(__self__, *,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input['InteractiveQueryClusterComponentVersionArgs']] = None,
                 compute_isolation: Optional[pulumi.Input['InteractiveQueryClusterComputeIsolationArgs']] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extension: Optional[pulumi.Input['InteractiveQueryClusterExtensionArgs']] = None,
                 gateway: Optional[pulumi.Input['InteractiveQueryClusterGatewayArgs']] = None,
                 https_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input['InteractiveQueryClusterMetastoresArgs']] = None,
                 monitor: Optional[pulumi.Input['InteractiveQueryClusterMonitorArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['InteractiveQueryClusterNetworkArgs']] = None,
                 private_link_configuration: Optional[pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input['InteractiveQueryClusterRolesArgs']] = None,
                 security_profile: Optional[pulumi.Input['InteractiveQueryClusterSecurityProfileArgs']] = None,
                 ssh_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_gen2: Optional[pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args']] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InteractiveQueryCluster resources.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterComponentVersionArgs'] component_version: A `component_version` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterComputeIsolationArgs'] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]] disk_encryptions: A `disk_encryption` block as defined below.
        :param pulumi.Input[_builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterExtensionArgs'] extension: An `extension` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterGatewayArgs'] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterMetastoresArgs'] metastores: A `metastores` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterMonitorArgs'] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterNetworkArgs'] network: A `network` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs'] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['InteractiveQueryClusterRolesArgs'] roles: A `roles` block as defined below.
        :param pulumi.Input['InteractiveQueryClusterSecurityProfileArgs'] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        :param pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args'] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if compute_isolation is not None:
            pulumi.set(__self__, "compute_isolation", compute_isolation)
        if disk_encryptions is not None:
            pulumi.set(__self__, "disk_encryptions", disk_encryptions)
        if encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "encryption_in_transit_enabled", encryption_in_transit_enabled)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metastores is not None:
            pulumi.set(__self__, "metastores", metastores)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if ssh_endpoint is not None:
            pulumi.set(__self__, "ssh_endpoint", ssh_endpoint)
        if storage_account_gen2 is not None:
            pulumi.set(__self__, "storage_account_gen2", storage_account_gen2)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if tls_min_version is not None:
            pulumi.set(__self__, "tls_min_version", tls_min_version)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input['InteractiveQueryClusterComponentVersionArgs']]:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input['InteractiveQueryClusterComponentVersionArgs']]):
        pulumi.set(self, "component_version", value)

    @_builtins.property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> Optional[pulumi.Input['InteractiveQueryClusterComputeIsolationArgs']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @compute_isolation.setter
    def compute_isolation(self, value: Optional[pulumi.Input['InteractiveQueryClusterComputeIsolationArgs']]):
        pulumi.set(self, "compute_isolation", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]]]:
        """
        A `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @disk_encryptions.setter
    def disk_encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterDiskEncryptionArgs']]]]):
        pulumi.set(self, "disk_encryptions", value)

    @_builtins.property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @encryption_in_transit_enabled.setter
    def encryption_in_transit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_in_transit_enabled", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['InteractiveQueryClusterExtensionArgs']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['InteractiveQueryClusterExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input['InteractiveQueryClusterGatewayArgs']]:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input['InteractiveQueryClusterGatewayArgs']]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metastores(self) -> Optional[pulumi.Input['InteractiveQueryClusterMetastoresArgs']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @metastores.setter
    def metastores(self, value: Optional[pulumi.Input['InteractiveQueryClusterMetastoresArgs']]):
        pulumi.set(self, "metastores", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['InteractiveQueryClusterMonitorArgs']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['InteractiveQueryClusterMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['InteractiveQueryClusterNetworkArgs']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['InteractiveQueryClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional[pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @private_link_configuration.setter
    def private_link_configuration(self, value: Optional[pulumi.Input['InteractiveQueryClusterPrivateLinkConfigurationArgs']]):
        pulumi.set(self, "private_link_configuration", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input['InteractiveQueryClusterRolesArgs']]:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input['InteractiveQueryClusterRolesArgs']]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['InteractiveQueryClusterSecurityProfileArgs']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['InteractiveQueryClusterSecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @_builtins.property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SSH Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @ssh_endpoint.setter
    def ssh_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> Optional[pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @storage_account_gen2.setter
    def storage_account_gen2(self, value: Optional[pulumi.Input['InteractiveQueryClusterStorageAccountGen2Args']]):
        pulumi.set(self, "storage_account_gen2", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InteractiveQueryClusterStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

    @tls_min_version.setter
    def tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_min_version", value)


@pulumi.type_token("azure:hdinsight/interactiveQueryCluster:InteractiveQueryCluster")
class InteractiveQueryCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['InteractiveQueryClusterComponentVersionArgs', 'InteractiveQueryClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['InteractiveQueryClusterComputeIsolationArgs', 'InteractiveQueryClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterDiskEncryptionArgs', 'InteractiveQueryClusterDiskEncryptionArgsDict']]]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extension: Optional[pulumi.Input[Union['InteractiveQueryClusterExtensionArgs', 'InteractiveQueryClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['InteractiveQueryClusterGatewayArgs', 'InteractiveQueryClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['InteractiveQueryClusterMetastoresArgs', 'InteractiveQueryClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['InteractiveQueryClusterMonitorArgs', 'InteractiveQueryClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['InteractiveQueryClusterNetworkArgs', 'InteractiveQueryClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['InteractiveQueryClusterPrivateLinkConfigurationArgs', 'InteractiveQueryClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['InteractiveQueryClusterRolesArgs', 'InteractiveQueryClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['InteractiveQueryClusterSecurityProfileArgs', 'InteractiveQueryClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['InteractiveQueryClusterStorageAccountGen2Args', 'InteractiveQueryClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterStorageAccountArgs', 'InteractiveQueryClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a HDInsight Interactive Query Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_interactive_query_cluster = azure.hdinsight.InteractiveQueryCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "interactive_hive": "2.1",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D13_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D14_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_A4_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight` - 2021-06-01

        ## Import

        HDInsight Interactive Query Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/interactiveQueryCluster:InteractiveQueryCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterComponentVersionArgs', 'InteractiveQueryClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterComputeIsolationArgs', 'InteractiveQueryClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterDiskEncryptionArgs', 'InteractiveQueryClusterDiskEncryptionArgsDict']]]] disk_encryptions: A `disk_encryption` block as defined below.
        :param pulumi.Input[_builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterExtensionArgs', 'InteractiveQueryClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterGatewayArgs', 'InteractiveQueryClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterMetastoresArgs', 'InteractiveQueryClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterMonitorArgs', 'InteractiveQueryClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterNetworkArgs', 'InteractiveQueryClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterPrivateLinkConfigurationArgs', 'InteractiveQueryClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterRolesArgs', 'InteractiveQueryClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterSecurityProfileArgs', 'InteractiveQueryClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterStorageAccountGen2Args', 'InteractiveQueryClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterStorageAccountArgs', 'InteractiveQueryClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InteractiveQueryClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a HDInsight Interactive Query Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="hdinsightstor",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="hdinsight",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_interactive_query_cluster = azure.hdinsight.InteractiveQueryCluster("example",
            name="example-hdicluster",
            resource_group_name=example.name,
            location=example.location,
            cluster_version="3.6",
            tier="Standard",
            component_version={
                "interactive_hive": "2.1",
            },
            gateway={
                "username": "acctestusrgw",
                "password": "Password!",
            },
            storage_accounts=[{
                "storage_container_id": example_container.id,
                "storage_account_key": example_account.primary_access_key,
                "is_default": True,
            }],
            roles={
                "head_node": {
                    "vm_size": "Standard_D13_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
                "worker_node": {
                    "vm_size": "Standard_D14_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                    "target_instance_count": 3,
                },
                "zookeeper_node": {
                    "vm_size": "Standard_A4_V2",
                    "username": "acctestusrvm",
                    "password": "AccTestvdSC4daf986!",
                },
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HDInsight` - 2021-06-01

        ## Import

        HDInsight Interactive Query Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:hdinsight/interactiveQueryCluster:InteractiveQueryCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.HDInsight/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param InteractiveQueryClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InteractiveQueryClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 component_version: Optional[pulumi.Input[Union['InteractiveQueryClusterComponentVersionArgs', 'InteractiveQueryClusterComponentVersionArgsDict']]] = None,
                 compute_isolation: Optional[pulumi.Input[Union['InteractiveQueryClusterComputeIsolationArgs', 'InteractiveQueryClusterComputeIsolationArgsDict']]] = None,
                 disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterDiskEncryptionArgs', 'InteractiveQueryClusterDiskEncryptionArgsDict']]]]] = None,
                 encryption_in_transit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 extension: Optional[pulumi.Input[Union['InteractiveQueryClusterExtensionArgs', 'InteractiveQueryClusterExtensionArgsDict']]] = None,
                 gateway: Optional[pulumi.Input[Union['InteractiveQueryClusterGatewayArgs', 'InteractiveQueryClusterGatewayArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metastores: Optional[pulumi.Input[Union['InteractiveQueryClusterMetastoresArgs', 'InteractiveQueryClusterMetastoresArgsDict']]] = None,
                 monitor: Optional[pulumi.Input[Union['InteractiveQueryClusterMonitorArgs', 'InteractiveQueryClusterMonitorArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['InteractiveQueryClusterNetworkArgs', 'InteractiveQueryClusterNetworkArgsDict']]] = None,
                 private_link_configuration: Optional[pulumi.Input[Union['InteractiveQueryClusterPrivateLinkConfigurationArgs', 'InteractiveQueryClusterPrivateLinkConfigurationArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Union['InteractiveQueryClusterRolesArgs', 'InteractiveQueryClusterRolesArgsDict']]] = None,
                 security_profile: Optional[pulumi.Input[Union['InteractiveQueryClusterSecurityProfileArgs', 'InteractiveQueryClusterSecurityProfileArgsDict']]] = None,
                 storage_account_gen2: Optional[pulumi.Input[Union['InteractiveQueryClusterStorageAccountGen2Args', 'InteractiveQueryClusterStorageAccountGen2ArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterStorageAccountArgs', 'InteractiveQueryClusterStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InteractiveQueryClusterArgs.__new__(InteractiveQueryClusterArgs)

            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            if component_version is None and not opts.urn:
                raise TypeError("Missing required property 'component_version'")
            __props__.__dict__["component_version"] = component_version
            __props__.__dict__["compute_isolation"] = compute_isolation
            __props__.__dict__["disk_encryptions"] = disk_encryptions
            __props__.__dict__["encryption_in_transit_enabled"] = encryption_in_transit_enabled
            __props__.__dict__["extension"] = extension
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["location"] = location
            __props__.__dict__["metastores"] = metastores
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["private_link_configuration"] = private_link_configuration
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["security_profile"] = security_profile
            __props__.__dict__["storage_account_gen2"] = storage_account_gen2
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["tls_min_version"] = tls_min_version
            __props__.__dict__["https_endpoint"] = None
            __props__.__dict__["ssh_endpoint"] = None
        super(InteractiveQueryCluster, __self__).__init__(
            'azure:hdinsight/interactiveQueryCluster:InteractiveQueryCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            component_version: Optional[pulumi.Input[Union['InteractiveQueryClusterComponentVersionArgs', 'InteractiveQueryClusterComponentVersionArgsDict']]] = None,
            compute_isolation: Optional[pulumi.Input[Union['InteractiveQueryClusterComputeIsolationArgs', 'InteractiveQueryClusterComputeIsolationArgsDict']]] = None,
            disk_encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterDiskEncryptionArgs', 'InteractiveQueryClusterDiskEncryptionArgsDict']]]]] = None,
            encryption_in_transit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            extension: Optional[pulumi.Input[Union['InteractiveQueryClusterExtensionArgs', 'InteractiveQueryClusterExtensionArgsDict']]] = None,
            gateway: Optional[pulumi.Input[Union['InteractiveQueryClusterGatewayArgs', 'InteractiveQueryClusterGatewayArgsDict']]] = None,
            https_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metastores: Optional[pulumi.Input[Union['InteractiveQueryClusterMetastoresArgs', 'InteractiveQueryClusterMetastoresArgsDict']]] = None,
            monitor: Optional[pulumi.Input[Union['InteractiveQueryClusterMonitorArgs', 'InteractiveQueryClusterMonitorArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['InteractiveQueryClusterNetworkArgs', 'InteractiveQueryClusterNetworkArgsDict']]] = None,
            private_link_configuration: Optional[pulumi.Input[Union['InteractiveQueryClusterPrivateLinkConfigurationArgs', 'InteractiveQueryClusterPrivateLinkConfigurationArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Union['InteractiveQueryClusterRolesArgs', 'InteractiveQueryClusterRolesArgsDict']]] = None,
            security_profile: Optional[pulumi.Input[Union['InteractiveQueryClusterSecurityProfileArgs', 'InteractiveQueryClusterSecurityProfileArgsDict']]] = None,
            ssh_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_gen2: Optional[pulumi.Input[Union['InteractiveQueryClusterStorageAccountGen2Args', 'InteractiveQueryClusterStorageAccountGen2ArgsDict']]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterStorageAccountArgs', 'InteractiveQueryClusterStorageAccountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None,
            tls_min_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'InteractiveQueryCluster':
        """
        Get an existing InteractiveQueryCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_version: Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterComponentVersionArgs', 'InteractiveQueryClusterComponentVersionArgsDict']] component_version: A `component_version` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterComputeIsolationArgs', 'InteractiveQueryClusterComputeIsolationArgsDict']] compute_isolation: A `compute_isolation` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterDiskEncryptionArgs', 'InteractiveQueryClusterDiskEncryptionArgsDict']]]] disk_encryptions: A `disk_encryption` block as defined below.
        :param pulumi.Input[_builtins.bool] encryption_in_transit_enabled: Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterExtensionArgs', 'InteractiveQueryClusterExtensionArgsDict']] extension: An `extension` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterGatewayArgs', 'InteractiveQueryClusterGatewayArgsDict']] gateway: A `gateway` block as defined below.
        :param pulumi.Input[_builtins.str] https_endpoint: The HTTPS Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterMetastoresArgs', 'InteractiveQueryClusterMetastoresArgsDict']] metastores: A `metastores` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterMonitorArgs', 'InteractiveQueryClusterMonitorArgsDict']] monitor: A `monitor` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterNetworkArgs', 'InteractiveQueryClusterNetworkArgsDict']] network: A `network` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterPrivateLinkConfigurationArgs', 'InteractiveQueryClusterPrivateLinkConfigurationArgsDict']] private_link_configuration: A `private_link_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InteractiveQueryClusterRolesArgs', 'InteractiveQueryClusterRolesArgsDict']] roles: A `roles` block as defined below.
        :param pulumi.Input[Union['InteractiveQueryClusterSecurityProfileArgs', 'InteractiveQueryClusterSecurityProfileArgsDict']] security_profile: A `security_profile` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ssh_endpoint: The SSH Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        :param pulumi.Input[Union['InteractiveQueryClusterStorageAccountGen2Args', 'InteractiveQueryClusterStorageAccountGen2ArgsDict']] storage_account_gen2: A `storage_account_gen2` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InteractiveQueryClusterStorageAccountArgs', 'InteractiveQueryClusterStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        :param pulumi.Input[_builtins.str] tier: Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tls_min_version: The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.
               
               > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InteractiveQueryClusterState.__new__(_InteractiveQueryClusterState)

        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["component_version"] = component_version
        __props__.__dict__["compute_isolation"] = compute_isolation
        __props__.__dict__["disk_encryptions"] = disk_encryptions
        __props__.__dict__["encryption_in_transit_enabled"] = encryption_in_transit_enabled
        __props__.__dict__["extension"] = extension
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["https_endpoint"] = https_endpoint
        __props__.__dict__["location"] = location
        __props__.__dict__["metastores"] = metastores
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_link_configuration"] = private_link_configuration
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["roles"] = roles
        __props__.__dict__["security_profile"] = security_profile
        __props__.__dict__["ssh_endpoint"] = ssh_endpoint
        __props__.__dict__["storage_account_gen2"] = storage_account_gen2
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["tls_min_version"] = tls_min_version
        return InteractiveQueryCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Version of HDInsights which should be used for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> pulumi.Output['outputs.InteractiveQueryClusterComponentVersion']:
        """
        A `component_version` block as defined below.
        """
        return pulumi.get(self, "component_version")

    @_builtins.property
    @pulumi.getter(name="computeIsolation")
    def compute_isolation(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterComputeIsolation']]:
        """
        A `compute_isolation` block as defined below.
        """
        return pulumi.get(self, "compute_isolation")

    @_builtins.property
    @pulumi.getter(name="diskEncryptions")
    def disk_encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.InteractiveQueryClusterDiskEncryption']]]:
        """
        A `disk_encryption` block as defined below.
        """
        return pulumi.get(self, "disk_encryptions")

    @_builtins.property
    @pulumi.getter(name="encryptionInTransitEnabled")
    def encryption_in_transit_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether encryption in transit is enabled for this Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_in_transit_enabled")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterExtension']]:
        """
        An `extension` block as defined below.
        """
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Output['outputs.InteractiveQueryClusterGateway']:
        """
        A `gateway` block as defined below.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTPS Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "https_endpoint")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def metastores(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterMetastores']]:
        """
        A `metastores` block as defined below.
        """
        return pulumi.get(self, "metastores")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterMonitor']]:
        """
        A `monitor` block as defined below.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name for this HDInsight Interactive Query Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterNetwork']]:
        """
        A `network` block as defined below.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterPrivateLinkConfiguration']]:
        """
        A `private_link_configuration` block as defined below.
        """
        return pulumi.get(self, "private_link_configuration")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group in which this HDInsight Interactive Query Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output['outputs.InteractiveQueryClusterRoles']:
        """
        A `roles` block as defined below.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterSecurityProfile']]:
        """
        A `security_profile` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_profile")

    @_builtins.property
    @pulumi.getter(name="sshEndpoint")
    def ssh_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The SSH Connectivity Endpoint for this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "ssh_endpoint")

    @_builtins.property
    @pulumi.getter(name="storageAccountGen2")
    def storage_account_gen2(self) -> pulumi.Output[Optional['outputs.InteractiveQueryClusterStorageAccountGen2']]:
        """
        A `storage_account_gen2` block as defined below.
        """
        return pulumi.get(self, "storage_account_gen2")

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.InteractiveQueryClusterStorageAccount']]]:
        """
        One or more `storage_account` block as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of Tags which should be assigned to this HDInsight Interactive Query Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Tier which should be used for this HDInsight Interactive Query Cluster. Possible values are `Standard` or `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="tlsMinVersion")
    def tls_min_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimal supported TLS version. Possible values are 1.0, 1.1 or 1.2. Changing this forces a new resource to be created.

        > **Note:** Starting on June 30, 2020, Azure HDInsight will enforce TLS 1.2 or later versions for all HTTPS connections. For more information, see [Azure HDInsight TLS 1.2 Enforcement](https://azure.microsoft.com/en-us/updates/azure-hdinsight-tls-12-enforcement/).
        """
        return pulumi.get(self, "tls_min_version")

