# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DicomServiceAuthenticationArgs',
    'DicomServiceAuthenticationArgsDict',
    'DicomServiceCorsArgs',
    'DicomServiceCorsArgsDict',
    'DicomServiceIdentityArgs',
    'DicomServiceIdentityArgsDict',
    'DicomServicePrivateEndpointArgs',
    'DicomServicePrivateEndpointArgsDict',
    'DicomServiceStorageArgs',
    'DicomServiceStorageArgsDict',
    'FhirServiceAuthenticationArgs',
    'FhirServiceAuthenticationArgsDict',
    'FhirServiceCorsArgs',
    'FhirServiceCorsArgsDict',
    'FhirServiceIdentityArgs',
    'FhirServiceIdentityArgsDict',
    'FhirServiceOciArtifactArgs',
    'FhirServiceOciArtifactArgsDict',
    'MedtechServiceIdentityArgs',
    'MedtechServiceIdentityArgsDict',
    'ServiceAuthenticationConfigurationArgs',
    'ServiceAuthenticationConfigurationArgsDict',
    'ServiceCorsConfigurationArgs',
    'ServiceCorsConfigurationArgsDict',
    'ServiceIdentityArgs',
    'ServiceIdentityArgsDict',
    'WorkspacePrivateEndpointConnectionArgs',
    'WorkspacePrivateEndpointConnectionArgsDict',
]

MYPY = False

if not MYPY:
    class DicomServiceAuthenticationArgsDict(TypedDict):
        audiences: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        authority: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    DicomServiceAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DicomServiceAuthenticationArgs:
    def __init__(__self__, *,
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 authority: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audiences: The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The intended audience to receive authentication tokens for the service. The default value is <https://dicom.azurehealthcareapis.azure.com>
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audiences", value)

    @_builtins.property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authority", value)


if not MYPY:
    class DicomServiceCorsArgsDict(TypedDict):
        allow_credentials: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to allow credentials in CORS. Defaults to `false`.
        """
        allowed_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of allowed headers for CORS.
        """
        allowed_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of allowed methods for CORS.
        """
        allowed_origins: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of allowed origins for CORS.
        """
        max_age_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
elif False:
    DicomServiceCorsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DicomServiceCorsArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] allow_credentials: Whether to allow credentials in CORS. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_headers: A list of allowed headers for CORS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_methods: A list of allowed methods for CORS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: A list of allowed origins for CORS.
        :param pulumi.Input[_builtins.int] max_age_in_seconds: The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow credentials in CORS. Defaults to `false`.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_credentials", value)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed headers for CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed methods for CORS.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed origins for CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum age in seconds for the CORS configuration (must be between 0 and 99998 inclusive).
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_in_seconds", value)


if not MYPY:
    class DicomServiceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    DicomServiceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DicomServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of identity used for the Healthcare DICOM service. Possible values are `UserAssigned`, `SystemAssigned` and `SystemAssigned, UserAssigned`. If `UserAssigned` is set, an `identity_ids` must be set as well.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of User Assigned Identity IDs which should be assigned to this Healthcare DICOM service.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class DicomServicePrivateEndpointArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Healthcare DICOM Service.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
elif False:
    DicomServicePrivateEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DicomServicePrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the Healthcare DICOM Service.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Healthcare DICOM Service.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare DICOM Service. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class DicomServiceStorageArgsDict(TypedDict):
        file_system_name: pulumi.Input[_builtins.str]
        """
        The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        """
        storage_account_id: pulumi.Input[_builtins.str]
        """
        The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.

        > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
elif False:
    DicomServiceStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DicomServiceStorageArgs:
    def __init__(__self__, *,
                 file_system_name: pulumi.Input[_builtins.str],
                 storage_account_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] file_system_name: The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
               
               > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Input[_builtins.str]:
        """
        The filesystem name of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of connected storage account. Changing this forces a new Healthcare DICOM Service to be created.

        > **Note:** The `is_hns_enabled` needs to be set to `true` for the storage account to be used with the Healthcare DICOM Service.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)


if not MYPY:
    class FhirServiceAuthenticationArgsDict(TypedDict):
        audience: pulumi.Input[_builtins.str]
        """
        The intended audience to receive authentication tokens for the service.
        """
        authority: pulumi.Input[_builtins.str]
        smart_proxy_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether smart proxy is enabled.
        """
elif False:
    FhirServiceAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirServiceAuthenticationArgs:
    def __init__(__self__, *,
                 audience: pulumi.Input[_builtins.str],
                 authority: pulumi.Input[_builtins.str],
                 smart_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] audience: The intended audience to receive authentication tokens for the service.
        :param pulumi.Input[_builtins.bool] smart_proxy_enabled: Whether smart proxy is enabled.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "authority", authority)
        if smart_proxy_enabled is not None:
            pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> pulumi.Input[_builtins.str]:
        """
        The intended audience to receive authentication tokens for the service.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter
    def authority(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authority", value)

    @_builtins.property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether smart proxy is enabled.
        """
        return pulumi.get(self, "smart_proxy_enabled")

    @smart_proxy_enabled.setter
    def smart_proxy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smart_proxy_enabled", value)


if not MYPY:
    class FhirServiceCorsArgsDict(TypedDict):
        allowed_headers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A set of headers to be allowed via CORS.
        """
        allowed_methods: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        allowed_origins: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A set of origins to be allowed via CORS.
        """
        credentials_allowed: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If credentials are allowed via CORS.
        """
        max_age_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The max age to be allowed via CORS.
        """
elif False:
    FhirServiceCorsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirServiceCorsArgs:
    def __init__(__self__, *,
                 allowed_headers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 credentials_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_headers: A set of headers to be allowed via CORS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_methods: The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: A set of origins to be allowed via CORS.
        :param pulumi.Input[_builtins.bool] credentials_allowed: If credentials are allowed via CORS.
        :param pulumi.Input[_builtins.int] max_age_in_seconds: The max age to be allowed via CORS.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if credentials_allowed is not None:
            pulumi.set(__self__, "credentials_allowed", credentials_allowed)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_headers", value)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_methods", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_origins", value)

    @_builtins.property
    @pulumi.getter(name="credentialsAllowed")
    def credentials_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If credentials are allowed via CORS.
        """
        return pulumi.get(self, "credentials_allowed")

    @credentials_allowed.setter
    def credentials_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "credentials_allowed", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_in_seconds", value)


if not MYPY:
    class FhirServiceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    FhirServiceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class FhirServiceOciArtifactArgsDict(TypedDict):
        login_server: pulumi.Input[_builtins.str]
        """
        An Azure container registry used for export operations of the service instance.
        """
        digest: NotRequired[pulumi.Input[_builtins.str]]
        """
        A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        """
        image_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        An image within Azure container registry used for export operations of the service instance.
        """
elif False:
    FhirServiceOciArtifactArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirServiceOciArtifactArgs:
    def __init__(__self__, *,
                 login_server: pulumi.Input[_builtins.str],
                 digest: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] login_server: An Azure container registry used for export operations of the service instance.
        :param pulumi.Input[_builtins.str] digest: A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        :param pulumi.Input[_builtins.str] image_name: An image within Azure container registry used for export operations of the service instance.
        """
        pulumi.set(__self__, "login_server", login_server)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)

    @_builtins.property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> pulumi.Input[_builtins.str]:
        """
        An Azure container registry used for export operations of the service instance.
        """
        return pulumi.get(self, "login_server")

    @login_server.setter
    def login_server(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login_server", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A digest of an image within Azure container registry used for export operations of the service instance to narrow the artifacts down.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An image within Azure container registry used for export operations of the service instance.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)


if not MYPY:
    class MedtechServiceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this System Assigned Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this System Assigned Managed Service Identity.
        """
elif False:
    MedtechServiceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MedtechServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this System Assigned Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Healthcare Med Tech Service. Possible values are `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Healthcare Med Tech Service.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this System Assigned Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ServiceAuthenticationConfigurationArgsDict(TypedDict):
        audience: NotRequired[pulumi.Input[_builtins.str]]
        """
        The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        """
        authority: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
        Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        """
        smart_proxy_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
elif False:
    ServiceAuthenticationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceAuthenticationConfigurationArgs:
    def __init__(__self__, *,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 authority: Optional[pulumi.Input[_builtins.str]] = None,
                 smart_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] audience: The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        :param pulumi.Input[_builtins.str] authority: The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
               Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        :param pulumi.Input[_builtins.bool] smart_proxy_enabled: (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if smart_proxy_enabled is not None:
            pulumi.set(__self__, "smart_proxy_enabled", smart_proxy_enabled)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intended audience to receive authentication tokens for the service. The default value is https://azurehealthcareapis.com
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory (tenant) that serves as the authentication authority to access the service. The default authority is the Directory defined in the authentication scheme in use when running this provider.
        Authority must be registered to Azure AD and in the following format: https://{Azure-AD-endpoint}/{tenant-id}.
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authority", value)

    @_builtins.property
    @pulumi.getter(name="smartProxyEnabled")
    def smart_proxy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Boolean) Enables the 'SMART on FHIR' option for mobile and web implementations.
        """
        return pulumi.get(self, "smart_proxy_enabled")

    @smart_proxy_enabled.setter
    def smart_proxy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smart_proxy_enabled", value)


if not MYPY:
    class ServiceCorsConfigurationArgsDict(TypedDict):
        allow_credentials: NotRequired[pulumi.Input[_builtins.bool]]
        """
        (Boolean) If credentials are allowed via CORS.
        """
        allowed_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A set of headers to be allowed via CORS.
        """
        allowed_methods: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        allowed_origins: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A set of origins to be allowed via CORS.
        """
        max_age_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The max age to be allowed via CORS.
        """
elif False:
    ServiceCorsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceCorsConfigurationArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 max_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] allow_credentials: (Boolean) If credentials are allowed via CORS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_headers: A set of headers to be allowed via CORS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_methods: The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_origins: A set of origins to be allowed via CORS.
        :param pulumi.Input[_builtins.int] max_age_in_seconds: The max age to be allowed via CORS.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Boolean) If credentials are allowed via CORS.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_credentials", value)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of headers to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The methods to be allowed via CORS. Possible values are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PATCH` and `PUT`.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of origins to be allowed via CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_origins", value)

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max age to be allowed via CORS.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_age_in_seconds", value)


if not MYPY:
    class ServiceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ServiceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of managed identity to assign. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class WorkspacePrivateEndpointConnectionArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Healthcare Workspace.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
elif False:
    WorkspacePrivateEndpointConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspacePrivateEndpointConnectionArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the Healthcare Workspace.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Healthcare Workspace.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare Workspace. Changing this forces a new Healthcare Workspace to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


